package mage.cards.b;

import mage.MageInt;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.DisturbAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;

import java.util.UUID;

/**
 * @author TheElk801
 */
public final class BaithookAngler extends CardImpl {

    public BaithookAngler(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{U}");

        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.PEASANT);
        this.power = new MageInt(2);
        this.toughness = new MageInt(1);
        this.secondSideCardClazz = mage.cards.h.HookHauntDrifter.class;

        // Disturb {1}{U}
        this.addAbility(new DisturbAbility(this, "{1}{U}"));
    }

    private BaithookAngler(final BaithookAngler card) {
        super(card);
    }

    @Override
    public BaithookAngler copy() {
        return new BaithookAngler(this);
    }
}
