
package mage.cards.a;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author LoneFox
 */
public final class AvenTrooper extends CardImpl {

    public AvenTrooper(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{3}{W}");
        this.subtype.add(SubType.BIRD);
        this.subtype.add(SubType.SOLDIER);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Flying
        this.addAbility(FlyingAbility.getInstance());
        // {2}{W}, Discard a card: Aven Trooper gets +1/+2 until end of turn.
        Ability ability = new SimpleActivatedAbility(new BoostSourceEffect(1, 2, Duration.EndOfTurn), new ManaCostsImpl<>("{2}{W}"));
        ability.addCost(new DiscardCardCost());
        this.addAbility(ability);
    }

    private AvenTrooper(final AvenTrooper card) {
        super(card);
    }

    @Override
    public AvenTrooper copy() {
        return new AvenTrooper(this);
    }
}
