
package mage.cards.a;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.CanBlockOnlyFlyingAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.MorphAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;

/**
 *
 * @author LoneFox
 */
public final class AscendingAven extends CardImpl {

    public AscendingAven(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{2}{U}{U}");
        this.subtype.add(SubType.BIRD);
        this.subtype.add(SubType.SOLDIER);
        this.power = new MageInt(3);
        this.toughness = new MageInt(2);

        // Flying
        this.addAbility(FlyingAbility.getInstance());
        // Ascending Aven can block only creatures with flying.
        this.addAbility(new CanBlockOnlyFlyingAbility());
        // Morph {2}{U}
        this.addAbility(new MorphAbility(this, new ManaCostsImpl<>("{2}{U}")));
    }

    private AscendingAven(final AscendingAven card) {
        super(card);
    }

    @Override
    public AscendingAven copy() {
        return new AscendingAven(this);
    }
}
