
package mage.cards.a;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.TargetController;

/**
 *
 * @author Loki
 */
public final class ArchwingDragon extends CardImpl {

    public ArchwingDragon(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{R}{R}");
        this.subtype.add(SubType.DRAGON);

        this.power = new MageInt(4);
        this.toughness = new MageInt(4);

        this.addAbility(FlyingAbility.getInstance());
        this.addAbility(HasteAbility.getInstance());

        // At the beginning of the end step, return Archwing Dragon to its owner's hand.
        this.addAbility(new BeginningOfEndStepTriggeredAbility(TargetController.NEXT, new ReturnToHandSourceEffect(true), false));

    }

    private ArchwingDragon(final ArchwingDragon card) {
        super(card);
    }

    @Override
    public ArchwingDragon copy() {
        return new ArchwingDragon(this);
    }
}
