
package mage.cards.a;

import java.util.UUID;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.CantCastMoreThanOneSpellEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.TargetController;
import mage.constants.Zone;

/**
 *
 * @author dustinconrad
 */
public final class ArcaneLaboratory extends CardImpl {

    public ArcaneLaboratory(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.ENCHANTMENT},"{2}{U}");


        // Each player can't cast more than one spell each turn.
        this.addAbility(new SimpleStaticAbility(new CantCastMoreThanOneSpellEffect(TargetController.ANY)));
    }

    private ArcaneLaboratory(final ArcaneLaboratory card) {
        super(card);
    }

    @Override
    public ArcaneLaboratory copy() {
        return new ArcaneLaboratory(this);
    }
}
