
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.DestroySourceEffect;
import mage.abilities.effects.common.combat.CantBlockAttackActivateAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.*;
import mage.filter.FilterPermanent;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

/**
 *
 * @author North
 */
public final class ArachnusWeb extends CardImpl {

    public ArachnusWeb(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{G}");
        this.subtype.add(SubType.AURA);

        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.Detriment));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);

        // Enchanted creature can't attack or block, and its activated abilities can't be activated.
        this.addAbility(new SimpleStaticAbility(new CantBlockAttackActivateAttachedEffect()));
        // At the beginning of the end step, if enchanted creature's power is 4 or greater, destroy Arachnus Web.
        FilterPermanent filter = new FilterPermanent("if enchanted creature's power is 4 or greater");
        filter.add(new PowerPredicate(ComparisonType.MORE_THAN, 3));
        this.addAbility(new BeginningOfEndStepTriggeredAbility(
                TargetController.NEXT, new DestroySourceEffect(),
                false, new AttachedToMatchesFilterCondition(filter)));
    }

    private ArachnusWeb(final ArachnusWeb card) {
        super(card);
    }

    @Override
    public ArachnusWeb copy() {
        return new ArachnusWeb(this);
    }
}
