
package mage.cards.a;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;

/**
 *
 * @author noxx
 */
public final class AlchemistsApprentice extends CardImpl {

    public AlchemistsApprentice(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId,setInfo,new CardType[]{CardType.CREATURE},"{1}{U}");
        this.subtype.add(SubType.HUMAN);
        this.subtype.add(SubType.WIZARD);

        this.power = new MageInt(1);
        this.toughness = new MageInt(1);

        // Sacrifice Alchemist's Apprentice: Draw a card.
        this.addAbility(new SimpleActivatedAbility(new DrawCardSourceControllerEffect(1),
                new SacrificeSourceCost()));
    }

    private AlchemistsApprentice(final AlchemistsApprentice card) {
        super(card);
    }

    @Override
    public AlchemistsApprentice copy() {
        return new AlchemistsApprentice(this);
    }
}
