package mage.cards.a;

import java.util.UUID;
import mage.constants.SubType;
import mage.target.common.TargetCreaturePermanent;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.combat.CantBeBlockedAttachedEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.constants.Outcome;
import mage.target.TargetPermanent;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Zone;

/**
 *
 * @author TheElk801
 */
public final class AetherTunnel extends CardImpl {

    public AetherTunnel(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{U}");

        this.subtype.add(SubType.AURA);

        // Enchant creature
        TargetPermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget(auraTarget);
        this.getSpellAbility().addEffect(new AttachEffect(Outcome.BoostCreature));
        Ability ability = new EnchantAbility(auraTarget);
        this.addAbility(ability);

        // Enchanted creature gets +1/+0 and can't be blocked.
        ability = new SimpleStaticAbility(
                new BoostEnchantedEffect(1, 0, Duration.WhileOnBattlefield)
        );
        ability.addEffect(
                new CantBeBlockedAttachedEffect(AttachmentType.AURA)
                        .setText("and can't be blocked")
        );
        this.addAbility(ability);
    }

    private AetherTunnel(final AetherTunnel card) {
        super(card);
    }

    @Override
    public AetherTunnel copy() {
        return new AetherTunnel(this);
    }
}
