package mage.cards.a;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.StaticFilters;

/**
 *
 * @author Backfir3
 */
public final class AbsoluteGrace extends CardImpl {

    public AbsoluteGrace(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{W}");

        // All creatures have protection from black.
        Ability ability = ProtectionAbility.from(ObjectColor.BLACK);
        this.addAbility(new SimpleStaticAbility(new GainAbilityAllEffect(ability, Duration.WhileOnBattlefield,
                StaticFilters.FILTER_PERMANENT_ALL_CREATURES, false)));
    }

    private AbsoluteGrace(final AbsoluteGrace card) {
        super(card);
    }

    @Override
    public AbsoluteGrace copy() {
        return new AbsoluteGrace(this);
    }

}
