package mage.tournament.cubes;

import mage.game.draft.DraftCube;

/**
 * @author TheBear132
 * This cube is taken from this article https://magic.wizards.com/en/articles/archive/magic-online/khans-expanded-cube-2019-07-23
 * If the cards are from any of the Tarkir sets, the preferred set will be set to that set
 */

public class KhansExpandedCube extends DraftCube {

    public KhansExpandedCube() {
        super("MTGO Khans Expanded Cube");

        cubeCards.add(new DraftCube.CardIdentity("Herald of Anafenza", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Embodiment of Spring", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Bloodsoaked Champion", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Kolaghan Stormsinger", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Experiment One", ""));
        cubeCards.add(new DraftCube.CardIdentity("Taigam, Ojutai Master", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chronomaton", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arid Mesa", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Hateblade", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Enclave Cryptologist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cruel Sadist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Monastery Swiftspear", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Gnarlwood Dryad", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ojutai, Soul of Winter", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Filigree Familiar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ash Barrens", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Woe-Reaper", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Deranged Assistant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Disowned Ancestor", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Abbot of Keral Keep", ""));
        cubeCards.add(new DraftCube.CardIdentity("Patron of the Wild", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dragonlord Silumgar", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Pilgrim's Eye", ""));
        cubeCards.add(new DraftCube.CardIdentity("Battlefield Forge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ainok Bond-Kin", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Elusive Spellfist", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ruthless Ripper", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Firebrand Archer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pelt Collector", ""));
        cubeCards.add(new DraftCube.CardIdentity("Connive // Concoct", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skittering Surveyor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blood Crypt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Daring Skyjek", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jeskai Elder", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Shambling Goblin", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Horde Ambusher", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ainok Survivalist", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Dreadhorde Butcher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Awakened Amalgam", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodfell Caves", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Hidden Dragonslayer", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Jeskai Sage", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Battle Brawler", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Ire Shaman", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Broodhatch Nantuko", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dragonlord Kolaghan", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Peace Strider", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodstained Mire", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Master of Pearls", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Plaxmanta", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kitesail Freebooter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jeering Instigator", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Deadly Recluse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ghor-Clan Rampager", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rampaging Monument", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blooming Marsh", ""));
        cubeCards.add(new DraftCube.CardIdentity("Remorseful Cleric", ""));
        cubeCards.add(new DraftCube.CardIdentity("Qarsi Deceiver", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Skullhunter", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Kiln Fiend", ""));
        cubeCards.add(new DraftCube.CardIdentity("Decorated Champion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Atarka, World Render", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Solemn Simulacrum", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blossoming Sands", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Seeker of the Way", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Spellweaver Eternal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Silumgar Assassin", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Mogg War Marshal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Den Protector", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Knight of Autumn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chamber Sentry", ""));
        cubeCards.add(new DraftCube.CardIdentity("Botanical Sanctum", ""));
        cubeCards.add(new DraftCube.CardIdentity("Soulfire Grand Master", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Stratus Dancer", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Skinthinner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nef-Crop Entangler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Glade Watcher", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Dromoka, the Eternal", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Duplicant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Breeding Pool", ""));
        cubeCards.add(new DraftCube.CardIdentity("Steward of Solidarity", ""));
        cubeCards.add(new DraftCube.CardIdentity("Willbender", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sultai Emissary", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Skirk Marauder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Heir of the Wilds", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Chief of the Edge", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Animation Module", ""));
        cubeCards.add(new DraftCube.CardIdentity("Caves of Koilos", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tithe Taker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Echo Tracer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aphetto Exterminator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thermo-Alchemist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Obsessive Skinner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chief of the Scale", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ghostfire Blade", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Concealed Courtyard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wall of Omens", ""));
        cubeCards.add(new DraftCube.CardIdentity("Riptide Entrancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blood-Chin Fanatic", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("War-Name Aspirant", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Rattleclaw Mystic", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Elenda, the Dusk Rose", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sylvok Lifestaff", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dismal Backwater", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Abzan Falconer", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Riptide Survivor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Graveblade Marauder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crater Elemental", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ilysian Caryatid", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mortify", ""));
        cubeCards.add(new DraftCube.CardIdentity("Triangle of War", ""));
        cubeCards.add(new DraftCube.CardIdentity("Evolving Wilds", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Arashin Foremost", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Aphetto Runecaster", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grim Haruspex", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Flamewake Phoenix", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Deathmist Raptor", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Start // Finish", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cranial Archive", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Flooded Strand", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Kor Sanctifiers", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gurmag Drowner", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Strike Leader", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Legion Warboss", ""));
        cubeCards.add(new DraftCube.CardIdentity("Springbloom Druid", ""));
        cubeCards.add(new DraftCube.CardIdentity("Utter End", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Dream Chisel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Frontier Bivouac", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Hordechief", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Kheru Spellsnatcher", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Necravolver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bonecrusher Giant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tuskguard Captain", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Castigate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Guild Globe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Godless Shrine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Monastery Mentor", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Master of the Veil", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bane of the Living", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reckless Bushwhacker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Anavolver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Obzedat's Aid", ""));
        cubeCards.add(new DraftCube.CardIdentity("Leering Emblem", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grand Coliseum", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wingbeat Warrior", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mistfire Weaver", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Bellowing Saddlebrute", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Skirk Commando", ""));
        cubeCards.add(new DraftCube.CardIdentity("Armorcraft Judge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Death Grasp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prophetic Prism", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hallowed Fountain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Abzan Battle Priest", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Niblis of Frost", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gift of Doom", ""));
        cubeCards.add(new DraftCube.CardIdentity("Smelt-Ward Minotaur", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goreclaw, Terror of Qal Sisma", ""));
        cubeCards.add(new DraftCube.CardIdentity("Campaign of Vengeance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stormrider Rig", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Hissing Quagmire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aven Liberator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Talrand, Sky Summoner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grinning Demon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ashcloud Phoenix", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Nantuko Vigilante", ""));
        cubeCards.add(new DraftCube.CardIdentity("Golgari Guildmage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Trip Noose", ""));
        cubeCards.add(new DraftCube.CardIdentity("Inspiring Vantage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Daru Sanctifier", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chromeshell Crab", ""));
        cubeCards.add(new DraftCube.CardIdentity("Haunted Cadaver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Atarka Efreet", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Serpentine Basilisk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dreg Mangler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arcane Encyclopedia", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jungle Hollow", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Dragonscale General", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Icefall Regent", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Haunted Dead", ""));
        cubeCards.add(new DraftCube.CardIdentity("Battering Craghorn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sultai Flayer", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Corpsejack Menace", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sickleslicer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Llanowar Wastes", ""));
        cubeCards.add(new DraftCube.CardIdentity("High Sentinels of Arashin", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ixidor, Reality Sculptor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mer-Ek Nightblade", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Blistering Firecat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Surrak, the Hunt Caller", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Izoni, Thousand-Eyed", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bonehoard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lumbering Falls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ojutai Exemplars", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ixidron", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thrasher Brute", ""));
        cubeCards.add(new DraftCube.CardIdentity("Erratic Cyclops", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thelonite Hermit", ""));
        cubeCards.add(new DraftCube.CardIdentity("Assassin's Trophy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Obelisk of Alara", ""));
        cubeCards.add(new DraftCube.CardIdentity("Marsh Flats", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stonehorn Dignitary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mischievous Quanar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Creakwood Ghoul", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Heelcutter", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Challenger Troll", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grisly Salvage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Misty Rainforest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elite Scaleguard", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Soulblade Djinn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rakshasa Gravecaller", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Heart-Piercer", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Conclave Naturalists", ""));
        cubeCards.add(new DraftCube.CardIdentity("Find // Finality", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mystic Monastery", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Giant Killer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vesuvan Shapeshifter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Noosegraf Mob", ""));
        cubeCards.add(new DraftCube.CardIdentity("Caldera Hellion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gigapede", ""));
        cubeCards.add(new DraftCube.CardIdentity("Death Frenzy", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Needle Spires", ""));
        cubeCards.add(new DraftCube.CardIdentity("Patron of the Valiant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Brine Elemental", ""));
        cubeCards.add(new DraftCube.CardIdentity("Silent Specter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Charging Monstrosaur", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hystrodon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Deadbridge Chant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nomad Outpost", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Wingmate Roc", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Quicksilver Dragon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gurmag Angler", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Dragon-Style Twins", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Kessig Cagebreakers", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nyx Weaver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Opulent Palace", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Daru Lancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thousand Winds", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Tombstalker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flamerush Rider", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Pine Walker", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Coiling Oracle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Overgrown Tomb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Exalted Angel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dive Down", ""));
        cubeCards.add(new DraftCube.CardIdentity("Necropolis Fiend", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Quakefoot Cyclops", ""));
        cubeCards.add(new DraftCube.CardIdentity("Primal Whisperer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Icefeather Aven", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Polluted Delta", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Linvala, the Preserver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Opt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ghastly Demise", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skarrgan Hellkite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hooting Mandrills", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Mystic Snake", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prismatic Vista", ""));
        cubeCards.add(new DraftCube.CardIdentity("Harm's Way", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stubborn Denial", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Moment of Craving", ""));
        cubeCards.add(new DraftCube.CardIdentity("Firemaw Kavu", ""));
        cubeCards.add(new DraftCube.CardIdentity("Root Elemental", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sagu Mauler", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Rugged Highlands", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Path to Exile", ""));
        cubeCards.add(new DraftCube.CardIdentity("Disdainful Stroke", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Vicious Offering", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rockshard Elemental", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temur War Shaman", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Applied Biomancy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sacred Foundry", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sheltering Light", ""));
        cubeCards.add(new DraftCube.CardIdentity("Force Away", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Expunge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bedlam Reveler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hooded Hydra", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ethereal Ambush", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Sandsteppe Citadel", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Adamant Will", ""));
        cubeCards.add(new DraftCube.CardIdentity("Impulse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Murder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Weapon Surge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Venomspout Brackus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Incubation // Incongruity", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scalding Tarn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Artful Maneuver", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Jilt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Foul Renewal", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Burning Oil", ""));
        cubeCards.add(new DraftCube.CardIdentity("Earthbrawn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Urban Evolution", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scoured Barrens", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Disenchant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reality Shift", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Price of Fame", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Strike", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grapple with the Past", ""));
        cubeCards.add(new DraftCube.CardIdentity("Secret Plans", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Shambling Vent", ""));
        cubeCards.add(new DraftCube.CardIdentity("Feat of Resistance", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Think Twice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Murderous Cut", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Temur Battle Rage", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Winds of Qal Sisma", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Yavimaya's Embrace", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shivan Reef", ""));
        cubeCards.add(new DraftCube.CardIdentity("Feeling of Dread", ""));
        cubeCards.add(new DraftCube.CardIdentity("Twisted Reflection", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reach of Shadows", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Omen of the Forge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crushing Canopy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stormchaser Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spirebluff Canal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phalanx Tactics", ""));
        cubeCards.add(new DraftCube.CardIdentity("Winds of Rebuke", ""));
        cubeCards.add(new DraftCube.CardIdentity("Death Wind", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Brimstone Volley", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gnaw to the Bone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodwater Entity", ""));
        cubeCards.add(new DraftCube.CardIdentity("Steam Vents", ""));
        cubeCards.add(new DraftCube.CardIdentity("Valorous Stance", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Forbidden Alchemy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Duress", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Geistblast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thornado", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wee Dragonauts", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stomping Ground", ""));
        cubeCards.add(new DraftCube.CardIdentity("Generous Gift", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phantasmal Form", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chainer's Edict", ""));
        cubeCards.add(new DraftCube.CardIdentity("Risk Factor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wild Hunger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crackling Drake", ""));
        cubeCards.add(new DraftCube.CardIdentity("Swiftwater Cliffs", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Radiant's Judgment", ""));
        cubeCards.add(new DraftCube.CardIdentity("Repulse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Agonizing Remorse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bolt Bend", ""));
        cubeCards.add(new DraftCube.CardIdentity("Become Immense", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Hypersonic Dragon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple Garden", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rally the Peasants", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sinister Sabotage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Morgue Theft", ""));
        cubeCards.add(new DraftCube.CardIdentity("Burn Away", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Savage Swipe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Izzet Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Abandon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Miraculous Recovery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chemister's Insight", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mire Triton", ""));
        cubeCards.add(new DraftCube.CardIdentity("Deem Worthy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Epic Confrontation", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Electrolyze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Deceit", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oust", ""));
        cubeCards.add(new DraftCube.CardIdentity("Commit // Memory", ""));
        cubeCards.add(new DraftCube.CardIdentity("Doomfall", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flames of the Raze-Boar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Savage Punch", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Sonic Assault", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Enlightenment", ""));
        cubeCards.add(new DraftCube.CardIdentity("Collective Effort", ""));
        cubeCards.add(new DraftCube.CardIdentity("Icy Blast", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Heartless Pillage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Faithless Looting", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tracker's Instincts", ""));
        cubeCards.add(new DraftCube.CardIdentity("Winterflame", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Epiphany", ""));
        cubeCards.add(new DraftCube.CardIdentity("Slaughter the Strong", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dig Through Time", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Infest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flame Slash", ""));
        cubeCards.add(new DraftCube.CardIdentity("Winding Way", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prophetic Bolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Malady", ""));
        cubeCards.add(new DraftCube.CardIdentity("End Hostilities", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Callous Dismissal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Parting Thoughts", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reckless Charge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Map the Wastes", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Honored Crop-Captain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Malice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fell the Mighty", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chart a Course", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wander in Death", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nightbird's Clutches", ""));
        cubeCards.add(new DraftCube.CardIdentity("Voracious Hydra", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sunhome Guildmage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Mystery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Myth Realized", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Strategic Planning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Moan of the Unhallowed", ""));
        cubeCards.add(new DraftCube.CardIdentity("Roast", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Nissa's Judgment", ""));
        cubeCards.add(new DraftCube.CardIdentity("Viashino Firstblade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Plenty", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mastery of the Unseen", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Write into Being", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Smiting Helix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tormenting Voice", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Spider Spawning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Firemane Avenger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Silence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Silkwrap", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Set Adrift", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Vigor Mortis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arc Lightning", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("See the Unwritten", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Foundry Champion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Triumph", ""));
        cubeCards.add(new DraftCube.CardIdentity("Suspension Field", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Treasure Cruise", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Crux of Fate", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Collective Defiance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hardened Scales", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Integrity // Intervention", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fabled Passage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightform", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Spontaneous Mutation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dead Drop", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Repeating Barrage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Obscuring Aether", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Response // Resurgence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thornwood Falls", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Stasis Snare", ""));
        cubeCards.add(new DraftCube.CardIdentity("Riddleform", ""));
        cubeCards.add(new DraftCube.CardIdentity("Debilitating Injury", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Rolling Temblor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Durable Handicraft", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ride Down", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Tranquil Cove", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Cast Out", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cloudform", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Raiders' Spoils", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Crater's Claws", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Trail of Mystery", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("War Flare", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Verdant Catacombs", ""));
        cubeCards.add(new DraftCube.CardIdentity("Righteous Cause", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skywise Teachings", "Dragons of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Raiders' Wake", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rageform", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Colossal Majesty", ""));
        cubeCards.add(new DraftCube.CardIdentity("Warleader's Helix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wandering Fumarole", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mantis Rider", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Watery Grave", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shu Yun, the Silent Tempest", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Wind-Scarred Crag", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Elsha of the Infinite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Windswept Heath", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Warden of the Eye", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Wooded Foothills", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Efreet Weaponmaster", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Yavimaya Coast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kykar, Wind's Fury", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jeskai Charm", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Flying Crane Technique", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Jeskai Ascendancy", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Alesha, Who Smiles at Death", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Butcher of the Horde", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ankle Shanker", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Zurgo Helmsmasher", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ponyback Brigade", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Crackling Doom", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Charm", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Ascendancy", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Fervent Charge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Anafenza, the Foremost", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Siege Rhino", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Armament Corps", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ivorytusk Fortress", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Abzan Guide", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Abzan Charm", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Ready // Willing", ""));
        cubeCards.add(new DraftCube.CardIdentity("Duneblast", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Abzan Ascendancy", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Sidisi, Brood Tyrant", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Rakshasa Vizier", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Sultai Soothsayer", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Abomination of Gudul", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Muldrotha, the Gravetide", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tasigur, the Golden Fang", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Sultai Charm", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Villainous Wealth", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Sultai Ascendancy", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Savage Knuckleblade", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Yasova Dragonclaw", "Fate Reforged"));
        cubeCards.add(new DraftCube.CardIdentity("Avalanche Tusker", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Bear's Companion", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Surrak Dragonclaw", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Intet, the Dreamer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Snowhorn Rider", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Temur Charm", "Khans of Tarkir"));
        cubeCards.add(new DraftCube.CardIdentity("Temur Ascendancy", "Khans of Tarkir"));
    }
}
