package mage.view;

import mage.game.Game;
import mage.game.command.Plane;
import mage.players.PlayableObjectStats;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;

/**
 * @author spjspj
 */
public class PlaneView implements CommandObjectView, Serializable {

    protected UUID id;
    protected String name;
    protected String imageFileName = "";
    protected int imageNumber = 0;
    protected String expansionSetCode = "";
    protected List<String> rules;
    protected PlayableObjectStats playableStats = new PlayableObjectStats();

    public PlaneView(Plane plane, Game game) {
        this.id = plane.getId();
        this.name = plane.getName();
        this.imageFileName = plane.getImageFileName();
        this.imageNumber = plane.getImageNumber();
        this.expansionSetCode = plane.getExpansionSetCode();
        this.rules = plane.getAbilities().getRules(game, plane);
    }

    @Override
    public String getExpansionSetCode() {
        return expansionSetCode;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public UUID getId() {
        return id;
    }

    @Override
    public String getImageFileName() {
        return imageFileName;
    }

    @Override
    public int getImageNumber() {
        return imageNumber;
    }

    @Override
    public List<String> getRules() {
        return rules;
    }

    @Override
    public boolean isPlayable() {
        return this.playableStats.getPlayableAmount() > 0;
    }

    @Override
    public void setPlayableStats(PlayableObjectStats playableStats) {
        this.playableStats = playableStats;
    }

    @Override
    public PlayableObjectStats getPlayableStats() {
        return this.playableStats;
    }

    @Override
    public boolean isChoosable() {
        // unsupported
        return false;
    }

    @Override
    public void setChoosable(boolean isChoosable) {
        // unsupported
    }

    @Override
    public boolean isSelected() {
        // unsupported
        return false;
    }

    @Override
    public void setSelected(boolean isSelected) {
        // unsupported
    }
}
