package mage.client.table;

import mage.cards.decks.DeckCardLists;
import mage.client.SessionHandler;
import mage.client.util.ClientDefaultSettings;
import mage.players.PlayerType;

import javax.swing.*;
import java.util.UUID;

/**
 * @author BetaSteward_at_googlemail.com
 */
public class TournamentPlayerPanel extends javax.swing.JPanel {


    /**
     * Creates new form TournamentPlayerPanel
     */
    public TournamentPlayerPanel() {
        initComponents();
        this.pnlPlayerName.setVisible(false);
    }

    public void init(int playerNum, PlayerType playerType, int playerSkill) {
        cbPlayerType.setModel(new DefaultComboBoxModel(SessionHandler.getPlayerTypes()));
        this.lblPlayerNum.setText("Player " + playerNum);
        if (ClientDefaultSettings.otherPlayerIndex != null) {
            Integer index = Integer.parseInt(ClientDefaultSettings.otherPlayerIndex);
            if (index >= cbPlayerType.getItemCount()) {
                cbPlayerType.setSelectedIndex(cbPlayerType.getItemCount() - 1);
            } else {
                cbPlayerType.setSelectedIndex(index);
            }
        }
        if (playerType != null) {
            this.cbPlayerType.setSelectedItem(playerType);
        }
        this.spnLevel.setValue(playerSkill);
    }

    public JComboBox getPlayerType() {
        return this.cbPlayerType;
    }

    public int getPlayerSkill() {
        return (Integer) this.spnLevel.getValue();
    }

    public boolean joinTournamentTable(UUID roomId, UUID tableId, DeckCardLists deckCardLists) {
        if (this.cbPlayerType.getSelectedItem() != PlayerType.HUMAN) {
            return SessionHandler.joinTournamentTable(
                    roomId,
                    tableId,
                    this.txtPlayerName.getText(),
                    (PlayerType) this.cbPlayerType.getSelectedItem(),
                    (Integer) spnLevel.getValue(),
                    deckCardLists,
                    "");
        }
        return true;
    }


    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        cbPlayerType = new javax.swing.JComboBox();
        lblPlayerNum = new javax.swing.JLabel();
        pnlPlayerName = new javax.swing.JPanel();
        txtPlayerName = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        spnLevel = new javax.swing.JSpinner();

        jLabel1.setLabelFor(cbPlayerType);
        jLabel1.setText("Type:");

        cbPlayerType.setModel(new javax.swing.DefaultComboBoxModel(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        cbPlayerType.addActionListener(evt -> cbPlayerTypeActionPerformed(evt));

        lblPlayerNum.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        lblPlayerNum.setText("Player Num:");

        jLabel2.setText("Name:");

        jLabel3.setText("Skill:");

        spnLevel.setModel(new javax.swing.SpinnerNumberModel(2, 1, 10, 1));
        spnLevel.setRequestFocusEnabled(false);

        javax.swing.GroupLayout pnlPlayerNameLayout = new javax.swing.GroupLayout(pnlPlayerName);
        pnlPlayerName.setLayout(pnlPlayerNameLayout);
        pnlPlayerNameLayout.setHorizontalGroup(
                pnlPlayerNameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(pnlPlayerNameLayout.createSequentialGroup()
                                .addComponent(jLabel3)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(spnLevel, javax.swing.GroupLayout.PREFERRED_SIZE, 51, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(67, 67, 67)
                                .addComponent(jLabel2)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(txtPlayerName, javax.swing.GroupLayout.DEFAULT_SIZE, 130, Short.MAX_VALUE))
        );
        pnlPlayerNameLayout.setVerticalGroup(
                pnlPlayerNameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(pnlPlayerNameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                .addComponent(txtPlayerName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(jLabel3)
                                .addComponent(jLabel2)
                                .addComponent(spnLevel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addComponent(lblPlayerNum)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(cbPlayerType, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(pnlPlayerName, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                                .addComponent(lblPlayerNum)
                                .addComponent(jLabel1)
                                .addComponent(cbPlayerType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addComponent(pnlPlayerName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
    }// </editor-fold>//GEN-END:initComponents

    private void cbPlayerTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbPlayerTypeActionPerformed
        if (this.cbPlayerType.getSelectedItem() != PlayerType.HUMAN) {
            this.pnlPlayerName.setVisible(true);
            this.txtPlayerName.setText(ClientDefaultSettings.computerName + " " + this.lblPlayerNum.getText().charAt(this.lblPlayerNum.getText().length() - 1));
            this.txtPlayerName.setEditable(false);
            this.txtPlayerName.setEnabled(false);
        } else {
            this.pnlPlayerName.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }//GEN-LAST:event_cbPlayerTypeActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox cbPlayerType;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel lblPlayerNum;
    private javax.swing.JPanel pnlPlayerName;
    private javax.swing.JSpinner spnLevel;
    private javax.swing.JTextField txtPlayerName;
    // End of variables declaration//GEN-END:variables

}
