package mage.client.table;

import java.util.UUID;
import javax.swing.JComponent;

import mage.client.MagePane;
import mage.client.SessionHandler;
import mage.client.plugins.impl.Plugins;

/**
 * Game GUI: lobby frame
 *
 * @author BetaSteward_at_googlemail.com
 */
public class TablesPane extends MagePane {

    UUID roomId = null;

    public TablesPane() {
        boolean initialized = false;
        if (Plugins.instance.isThemePluginLoaded()) {
            tablesPanel = new mage.client.table.TablesPanel();
            JComponent container = Plugins.instance.updateTablePanel(tablesPanel.getUIComponents());
            if (container != null) {
                initComponents(container);
                container.add(tablesPanel);
                container.setOpaque(false);
                initialized = true;
            }
        }
        if (!initialized) {
            initComponents();
        }
    }

    public void cleanUp() {
        tablesPanel.cleanUp();
    }

    @Override
    public void changeGUISize() {
        super.changeGUISize();
        tablesPanel.changeGUISize();
    }

    public void showTables() {
        UUID roomId = SessionHandler.getSession().getMainRoomId();
        if (roomId != null) {
            this.roomId = roomId;
            this.setTitle("Server's lobby");
            tablesPanel.showTables(roomId);
            this.repaint();
        }
    }

    @Override
    public boolean isActiveTable() {
        // it's defalt server lobby, so don't count it as active
        return false;
    }

    public void hideTables() {
        tablesPanel.hideTables();
    }

    public void clearChat() {
        tablesPanel.getChatPanel().clear();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        tablesPanel = new mage.client.table.TablesPanel();

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(tablesPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 541, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(tablesPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 471, Short.MAX_VALUE)
        );

    }// </editor-fold>//GEN-END:initComponents

    private void initComponents(JComponent container) {
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(container, javax.swing.GroupLayout.DEFAULT_SIZE, 541, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(container, javax.swing.GroupLayout.DEFAULT_SIZE, 471, Short.MAX_VALUE)
        );
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private mage.client.table.TablesPanel tablesPanel;
    // End of variables declaration//GEN-END:variables

    @Override
    public void activated() {
        tablesPanel.startUpdateTasks(false);
    }

    @Override
    public void deactivated() {
        super.deactivated();
        tablesPanel.stopTasks();
    }

    public void setTableFilter() {
        if (tablesPanel != null) {
            tablesPanel.setTableFilter();
        }
    }

    @Override
    public UUID getSortTableId() {
        return null;
    }

    @Override
    public int getSortOrder() {
        // lobby must be first all the time
        return 0;
    }
}
