package mage.client.table;

import mage.cards.decks.importer.DeckImporter;
import mage.client.SessionHandler;
import mage.client.util.ClientDefaultSettings;
import mage.client.util.Event;
import mage.client.util.Listener;
import mage.players.PlayerType;

import javax.swing.*;
import java.io.IOException;
import java.util.UUID;

/**
 * @author BetaSteward_at_googlemail.com
 */
public class TablePlayerPanel extends javax.swing.JPanel {

    protected final PlayerTypeEventSource playerTypeEventSource = new PlayerTypeEventSource();

    public TablePlayerPanel() {
        initComponents();
        this.newPlayerPanel.setVisible(false);
    }

    public void init(int playerNum, PlayerType playerType, int playerSkill, String playerDeck) {
        cbPlayerType.setModel(new DefaultComboBoxModel(SessionHandler.getPlayerTypes()));
        this.lblPlayerNum.setText("Player " + playerNum);
        if (ClientDefaultSettings.otherPlayerIndex != null) {
            Integer index = Integer.parseInt(ClientDefaultSettings.otherPlayerIndex);
            if (index >= cbPlayerType.getItemCount()) {
                cbPlayerType.setSelectedIndex(cbPlayerType.getItemCount() - 1);
            } else {
                cbPlayerType.setSelectedIndex(index);
            }
        }
        if (playerType != null) {
            this.cbPlayerType.setSelectedItem(playerType);
        }
        this.newPlayerPanel.setDeckFile(playerDeck);
        this.newPlayerPanel.setSkillLevel(playerSkill);
    }

    public boolean joinTable(UUID roomId, UUID tableId) throws IOException, ClassNotFoundException {
        if (this.cbPlayerType.getSelectedItem() != PlayerType.HUMAN) {
            return SessionHandler.joinTable(roomId, tableId, this.newPlayerPanel.getPlayerName(), (PlayerType) this.cbPlayerType.getSelectedItem(), this.newPlayerPanel.getSkillLevel(), DeckImporter.importDeckFromFile(this.newPlayerPanel.getDeckFile(), true), "");
        }
        return true;
    }

    public PlayerType getPlayerType() {
        return PlayerType.getByDescription(this.cbPlayerType.getSelectedItem().toString());
    }

    public int getPlayerSkill() {
        return newPlayerPanel.getSkillLevel();
    }

    public String getPlayerDeck() {
        return newPlayerPanel.getDeckFile();
    }

    public void addPlayerTypeEventListener(Listener<Event> listener) {
        playerTypeEventSource.addListener(listener);
    }

    public void clearPlayerTypeEventListeners() {
        playerTypeEventSource.clearListeners();
    }


    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lbPlayerType = new javax.swing.JLabel();
        cbPlayerType = new javax.swing.JComboBox();
        newPlayerPanel = new mage.client.table.NewPlayerPanel();
        lblPlayerNum = new javax.swing.JLabel();

        lbPlayerType.setText("Type:");

        cbPlayerType.addActionListener(evt -> cbPlayerTypeActionPerformed(evt));

        lblPlayerNum.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblPlayerNum.setText("Player #");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addContainerGap()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(lblPlayerNum)
                                        .addGroup(layout.createSequentialGroup()
                                                .addComponent(lbPlayerType)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(cbPlayerType, javax.swing.GroupLayout.PREFERRED_SIZE, 166, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(newPlayerPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 318, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(layout.createSequentialGroup()
                                                .addComponent(lblPlayerNum)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                                        .addComponent(cbPlayerType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                        .addComponent(lbPlayerType)))
                                        .addComponent(newPlayerPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 43, Short.MAX_VALUE))
                                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void cbPlayerTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbPlayerTypeActionPerformed
        if (getPlayerType() != PlayerType.HUMAN) {
            this.newPlayerPanel.setVisible(true);
            this.newPlayerPanel.setPlayerName(ClientDefaultSettings.computerName + " " + this.lblPlayerNum.getText().charAt(this.lblPlayerNum.getText().length() - 1));
        } else {
            this.newPlayerPanel.setVisible(false);
        }
        this.revalidate();
        this.repaint();
        this.playerTypeEventSource.playerTypeChanged();
    }//GEN-LAST:event_cbPlayerTypeActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox cbPlayerType;
    private javax.swing.JLabel lbPlayerType;
    private javax.swing.JLabel lblPlayerNum;
    private mage.client.table.NewPlayerPanel newPlayerPanel;
    // End of variables declaration//GEN-END:variables

}
