package mage.client.draft;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.JComponent;
import mage.client.MagePane;
import mage.client.plugins.impl.Plugins;

/**
 * Game GUI: draft frame
 *
 * @author BetaSteward_at_googlemail.com
 */
public class DraftPane extends MagePane {

    UUID tableId = null;
    UUID draftId = null;

    public DraftPane() {
        boolean initialized = false;
        if (Plugins.instance.isThemePluginLoaded()) {
            Map<String, JComponent> uiComponents = new HashMap<>();
            JComponent container = Plugins.instance.updateTablePanel(uiComponents);
            if (container != null) {
                draftPanel1 = new mage.client.draft.DraftPanel();
                initComponents(container);
                container.add(draftPanel1);
                container.setOpaque(false);
                draftPanel1.setOpaque(false);
                initialized = true;
            }
        }
        if (!initialized) {
            initComponents();
        }
    }

    @Override
    public void changeGUISize() {
        super.changeGUISize();
        draftPanel1.changeGUISize();
    }

    public void showDraft(UUID tableId, UUID draftId) {
        this.tableId = tableId;
        this.draftId = draftId;
        this.setTitle("Draft - " + draftId);
        this.draftPanel1.showDraft(draftId);
    }

    @Override
    public boolean isActiveTable() {
        return this.draftId != null;
    }

    public void removeDraft() {
        draftPanel1.cleanUp();
        this.removeFrame();
    }

    @Override
    public UUID getSortTableId() {
        return tableId;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        draftPanel1 = new mage.client.draft.DraftPanel();

        jScrollPane1.setViewportView(draftPanel1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 868, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 582, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    private void initComponents(Component container) {

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(container, javax.swing.GroupLayout.DEFAULT_SIZE, 885, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addComponent(container, javax.swing.GroupLayout.DEFAULT_SIZE, 626, Short.MAX_VALUE)
        );
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    mage.client.draft.DraftPanel draftPanel1;
    javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables

}
