package mage.client.dialog;

import mage.client.MageFrame;
import org.apache.log4j.Logger;

import javax.swing.*;
import java.awt.event.KeyEvent;

/**
 * App GUI: debug only, testing dialogs system
 *
 * @author JayDi85
 */
public class TestModalDialog extends MageDialog {

    private static final Logger logger = Logger.getLogger(TestModalDialog.class);

    private final TestModalSampleDialog constModalDialog1;
    private final TestModalSampleDialog constModalDialog2;
    private final TestModalSampleDialog constModalDialog3;

    private final TestModalSampleDialog constNonModalDialog1;
    private final TestModalSampleDialog constNonModalDialog2;
    private final TestModalSampleDialog constNonModalDialog3;

    public TestModalDialog() {
        initComponents();

        constModalDialog1 = new TestModalSampleDialog("const modal dialog 1", true, true, -50, -50);
        constModalDialog2 = new TestModalSampleDialog("const modal dialog 2", true, true, -100, -100);
        constModalDialog3 = new TestModalSampleDialog("const modal dialog 3", true, true, -150, -150);

        constNonModalDialog1 = new TestModalSampleDialog("const non modal dialog 1", false, true, -50, -50);
        constNonModalDialog2 = new TestModalSampleDialog("const non modal dialog 2", false, true, -100, -100);
        constNonModalDialog3 = new TestModalSampleDialog("const non modal dialog 3", false, true, -150, -150);
    }

    public void showDialog() {
        this.setModal(false);
        getRootPane().setDefaultButton(buttonCancel);

        // windows settings
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add(this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);
        this.makeWindowCentered();

        // Close on "ESC"
        registerKeyboardAction(e -> onCancel(), KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

        this.setVisible(true);
    }

    private void onCancel() {
        this.removeDialog();
    }

    private void showLater(TestModalSampleDialog dialog) {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                logger.info(dialog.getTitle());
                dialog.showDialog();
            }
        });
    }

    private void showConstModalDialogs(boolean isReverse) {
        if (isReverse) {
            showLater(constModalDialog3);
            showLater(constModalDialog2);
            showLater(constModalDialog1);
        } else {
            showLater(constModalDialog1);
            showLater(constModalDialog2);
            showLater(constModalDialog3);
        }
    }

    private void showConstNonModalDialogs(boolean isReverse) {
        if (isReverse) {
            showLater(constNonModalDialog3);
            showLater(constNonModalDialog2);
            showLater(constNonModalDialog1);
        } else {
            showLater(constNonModalDialog1);
            showLater(constNonModalDialog2);
            showLater(constNonModalDialog3);
        }
    }

    private void showDynModalDialogs(boolean isReverse) {
        TestModalSampleDialog dynDialog1 = new TestModalSampleDialog("dyn modal dialog 1", true, false, -50, -50);
        TestModalSampleDialog dynDialog2 = new TestModalSampleDialog("dyn modal dialog 2", true, false, -100, -100);
        TestModalSampleDialog dynDialog3 = new TestModalSampleDialog("dyn modal dialog 3", true, false, -150, -150);

        if (isReverse) {
            showLater(dynDialog3);
            showLater(dynDialog2);
            showLater(dynDialog1);
        } else {
            showLater(dynDialog1);
            showLater(dynDialog2);
            showLater(dynDialog3);
        }
    }

    private void showDynNonModalDialogs(boolean isReverse) {
        TestModalSampleDialog dynDialog1 = new TestModalSampleDialog("dyn non modal dialog 1", false, false, -50, -50);
        TestModalSampleDialog dynDialog2 = new TestModalSampleDialog("dyn non modal dialog 2", false, false, -100, -100);
        TestModalSampleDialog dynDialog3 = new TestModalSampleDialog("dyn non modal dialog 3", false, false, -150, -150);

        if (isReverse) {
            showLater(dynDialog3);
            showLater(dynDialog2);
            showLater(dynDialog1);
        } else {
            showLater(dynDialog1);
            showLater(dynDialog2);
            showLater(dynDialog3);
        }
    }


    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonCancel = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        buttonShowConstModal123 = new javax.swing.JButton();
        buttonShowConstModal321 = new javax.swing.JButton();
        buttonShowDynModal123 = new javax.swing.JButton();
        buttonShowDynModal321 = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        buttonShowConstNonModal123 = new javax.swing.JButton();
        buttonShowConstNonModal321 = new javax.swing.JButton();
        buttonShowDynNonModal321 = new javax.swing.JButton();
        buttonShowDynNonModal123 = new javax.swing.JButton();
        buttonPrintFramesList = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        buttonCancel.setText("Close");
        buttonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonCancelActionPerformed(evt);
            }
        });

        jLabel1.setText("Test modal dialog system:");

        buttonShowConstModal123.setText("const modal 123");
        buttonShowConstModal123.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonShowConstModal123ActionPerformed(evt);
            }
        });

        buttonShowConstModal321.setText("const modal 321");
        buttonShowConstModal321.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonShowConstModal321ActionPerformed(evt);
            }
        });

        buttonShowDynModal123.setText("dyn modal 123");
        buttonShowDynModal123.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonShowDynModal123ActionPerformed(evt);
            }
        });

        buttonShowDynModal321.setText("dyn modal 321");
        buttonShowDynModal321.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonShowDynModal321ActionPerformed(evt);
            }
        });

        jLabel2.setText("Test mon modal dialog system:");

        buttonShowConstNonModal123.setText("const non modal 123");
        buttonShowConstNonModal123.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonShowConstNonModal123ActionPerformed(evt);
            }
        });

        buttonShowConstNonModal321.setText("const non modal 321");
        buttonShowConstNonModal321.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonShowConstNonModal321ActionPerformed(evt);
            }
        });

        buttonShowDynNonModal321.setText("dyn non modal 321");
        buttonShowDynNonModal321.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonShowDynNonModal321ActionPerformed(evt);
            }
        });

        buttonShowDynNonModal123.setText("dyn non modal 123");
        buttonShowDynNonModal123.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonShowDynNonModal123ActionPerformed(evt);
            }
        });

        buttonPrintFramesList.setText("print frames list");
        buttonPrintFramesList.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonPrintFramesListActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addContainerGap()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                                .addGap(0, 0, Short.MAX_VALUE)
                                                .addComponent(buttonCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addGroup(layout.createSequentialGroup()
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                        .addComponent(jLabel1)
                                                        .addGroup(layout.createSequentialGroup()
                                                                .addComponent(buttonShowConstModal123)
                                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                                .addComponent(buttonShowConstModal321))
                                                        .addGroup(layout.createSequentialGroup()
                                                                .addComponent(buttonShowDynModal123)
                                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                                .addComponent(buttonShowDynModal321))
                                                        .addComponent(jLabel2)
                                                        .addGroup(layout.createSequentialGroup()
                                                                .addComponent(buttonShowConstNonModal123)
                                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                                .addComponent(buttonShowConstNonModal321))
                                                        .addGroup(layout.createSequentialGroup()
                                                                .addComponent(buttonShowDynNonModal123)
                                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                                .addComponent(buttonShowDynNonModal321))
                                                        .addComponent(buttonPrintFramesList))
                                                .addGap(0, 44, Short.MAX_VALUE)))
                                .addContainerGap())
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(jLabel1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(buttonShowConstModal123)
                                        .addComponent(buttonShowConstModal321))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(buttonShowDynModal123)
                                        .addComponent(buttonShowDynModal321))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel2)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(buttonShowConstNonModal123)
                                        .addComponent(buttonShowConstNonModal321))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(buttonShowDynNonModal123)
                                        .addComponent(buttonShowDynNonModal321))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(buttonPrintFramesList)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 129, Short.MAX_VALUE)
                                .addComponent(buttonCancel, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void buttonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonCancelActionPerformed
        onCancel();
    }//GEN-LAST:event_buttonCancelActionPerformed

    private void buttonShowConstModal123ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonShowConstModal123ActionPerformed
        showConstModalDialogs(false);
    }//GEN-LAST:event_buttonShowConstModal123ActionPerformed

    private void buttonShowConstModal321ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonShowConstModal321ActionPerformed
        showConstModalDialogs(true);
    }//GEN-LAST:event_buttonShowConstModal321ActionPerformed

    private void buttonShowDynModal123ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonShowDynModal123ActionPerformed
        showDynModalDialogs(false);
    }//GEN-LAST:event_buttonShowDynModal123ActionPerformed

    private void buttonShowDynModal321ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonShowDynModal321ActionPerformed
        showDynModalDialogs(true);
    }//GEN-LAST:event_buttonShowDynModal321ActionPerformed

    private void buttonShowConstNonModal123ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonShowConstNonModal123ActionPerformed
        showConstNonModalDialogs(false);
    }//GEN-LAST:event_buttonShowConstNonModal123ActionPerformed

    private void buttonShowConstNonModal321ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonShowConstNonModal321ActionPerformed
        showConstNonModalDialogs(true);
    }//GEN-LAST:event_buttonShowConstNonModal321ActionPerformed

    private void buttonShowDynNonModal321ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonShowDynNonModal321ActionPerformed
        showDynNonModalDialogs(true);
    }//GEN-LAST:event_buttonShowDynNonModal321ActionPerformed

    private void buttonShowDynNonModal123ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonShowDynNonModal123ActionPerformed
        showDynNonModalDialogs(false);
    }//GEN-LAST:event_buttonShowDynNonModal123ActionPerformed

    private void buttonPrintFramesListActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonPrintFramesListActionPerformed
        MageDialog.printFramesOrder("print");
    }//GEN-LAST:event_buttonPrintFramesListActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton buttonCancel;
    private javax.swing.JButton buttonPrintFramesList;
    private javax.swing.JButton buttonShowConstModal123;
    private javax.swing.JButton buttonShowConstModal321;
    private javax.swing.JButton buttonShowConstNonModal123;
    private javax.swing.JButton buttonShowConstNonModal321;
    private javax.swing.JButton buttonShowDynModal123;
    private javax.swing.JButton buttonShowDynModal321;
    private javax.swing.JButton buttonShowDynNonModal123;
    private javax.swing.JButton buttonShowDynNonModal321;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    // End of variables declaration//GEN-END:variables
}
