package mage.client.dialog;

import mage.client.MageFrame;

import javax.swing.*;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

/**
 * Game GUI: choose number dialog
 *
 * @author BetaSteward_at_googlemail.com, JayDi85
 */
public class PickNumberDialog extends MageDialog {

    private boolean cancel;
    private PickNumberCallback callback = null;

    public PickNumberDialog() {
        initComponents();

        this.textMessage.enableHyperlinksAndCardPopups();
        this.setModal(true);
    }

    public interface PickNumberCallback {
        void onChoiceDone();
    }

    public void showDialog(int min, int max, String message, PickNumberCallback callback) {
        this.editAmount.setModel(new SpinnerNumberModel(min, min, max, 1));
        this.textMessage.setContentType("text/html");
        this.textMessage.setText(message);
        this.callback = callback;

        List<String> limits = new ArrayList<>();
        if (min != Integer.MIN_VALUE) {
            limits.add("from " + min);
        }
        limits.add("to " + (max == Integer.MAX_VALUE ? "any" : max));
        this.labelLimits.setText(String.join(" ", limits));

        this.buttonOk.setVisible(true);
        this.buttonCancel.setVisible(false);
        this.pack();

        // window settings
        MageFrame.getDesktop().remove(this);
        MageFrame.getDesktop().add(this, this.isModal() ? JLayeredPane.MODAL_LAYER : JLayeredPane.PALETTE_LAYER);

        this.getRootPane().setDefaultButton(this.buttonOk); // restore default button after root panel change (no need actually)

        // enable spinner's enter key like text (one enter press instead two)
        // https://stackoverflow.com/questions/3873870/java-keylistener-not-firing-on-jspinner
        ((JSpinner.DefaultEditor) this.editAmount.getEditor()).getTextField().addKeyListener(new KeyListener() {

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_ENTER) {
                    buttonOk.doClick();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

        });

        this.makeWindowCentered();

        // TODO: need to fix focus restore on second popup (it's not get focus, test on Manamorphose)
        this.setVisible(true);
    }

    public int getAmount() {
        return ((Number) editAmount.getValue()).intValue();
    }

    public boolean isCancel() {
        return cancel;
    }

    private void doClose() {
        this.hideDialog();
        if (this.callback != null) {
            this.callback.onChoiceDone();
        }
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollMessage = new javax.swing.JScrollPane();
        textMessage = new mage.client.components.MageEditorPane();
        editAmount = new javax.swing.JSpinner();
        labelLimits = new javax.swing.JLabel();
        panelCommands = new javax.swing.JPanel();
        buttonOk = new javax.swing.JButton();
        buttonCancel = new javax.swing.JButton();

        scrollMessage.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        scrollMessage.setFocusable(false);

        textMessage.setEditable(false);
        textMessage.setText("long text long text long text long text long text long text long text long text");
        textMessage.setFocusable(false);
        textMessage.setOpaque(false);
        scrollMessage.setViewportView(textMessage);

        editAmount.setModel(new javax.swing.SpinnerNumberModel(1, null, null, 1));

        labelLimits.setText("min 1, max 123");

        buttonOk.setText("Choose");
        buttonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonOkActionPerformed(evt);
            }
        });

        buttonCancel.setText("Cancel");
        buttonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonCancelActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout panelCommandsLayout = new javax.swing.GroupLayout(panelCommands);
        panelCommands.setLayout(panelCommandsLayout);
        panelCommandsLayout.setHorizontalGroup(
            panelCommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelCommandsLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(buttonOk)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(buttonCancel)
                .addContainerGap())
        );
        panelCommandsLayout.setVerticalGroup(
            panelCommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panelCommandsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panelCommandsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(buttonOk)
                    .addComponent(buttonCancel))
                .addContainerGap())
        );

        getRootPane().setDefaultButton(buttonOk);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(scrollMessage, javax.swing.GroupLayout.DEFAULT_SIZE, 183, Short.MAX_VALUE)
                    .addComponent(panelCommands, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(editAmount, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(labelLimits)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(scrollMessage, javax.swing.GroupLayout.DEFAULT_SIZE, 117, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(editAmount, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(labelLimits))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(panelCommands, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void buttonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonOkActionPerformed
        this.cancel = false;
        doClose();
    }//GEN-LAST:event_buttonOkActionPerformed

    private void buttonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonCancelActionPerformed
        this.cancel = true;
        doClose();
    }//GEN-LAST:event_buttonCancelActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton buttonCancel;
    private javax.swing.JButton buttonOk;
    private javax.swing.JSpinner editAmount;
    private javax.swing.JLabel labelLimits;
    private javax.swing.JPanel panelCommands;
    private javax.swing.JScrollPane scrollMessage;
    private mage.client.components.MageEditorPane textMessage;
    // End of variables declaration//GEN-END:variables

}
