package mage.client.dialog;

import mage.client.MageFrame;
import mage.client.util.AppUtil;
import mage.client.util.GUISizeHelper;
import mage.util.CardUtil;

/**
 * GUI: error dialog with copyable error message
 * // TODO: add game logs and data for game errors (client side info from GameView)
 *
 * @author JayDi85
 */
public class ErrorDialog extends MageDialog {

    private final String GITHUB_ISSUES_PAGE = "https://github.com/magefree/mage/issues";

    public ErrorDialog() {
        initComponents();
    }

    public void showDialog(String errorType, String errorTitle, String errorText) {
        this.textInfo.setText("You can report bugs and create new feature requests at github: " + GITHUB_ISSUES_PAGE);
        this.textInfo.setCaretPosition(0);

        String fullTitle = errorType + " - " + errorTitle;
        this.setTitle(fullTitle);

        // add additional info
        String fullError = "Error type: " + fullTitle + "\n"
                + "Client version: " + MageFrame.getInstance().getVersion().toString() + "\n"
                + "\n"
                + errorText;
        this.textError.setText(fullError);
        this.textError.setCaretPosition(0);

        this.changeGUISize();

        this.pack();
        this.revalidate();
        this.repaint();
        this.setModal(true);
        this.setVisible(true);
    }

    @Override
    public void changeGUISize() {
        super.changeGUISize();

        this.textError.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.textInfo.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.btnCopyToClipboard.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.btnOpenGithub.setFont(GUISizeHelper.gameFeedbackPanelFont);
        this.btnOK.setFont(GUISizeHelper.gameFeedbackPanelFont);
    }

    private void openGithub() {
        // create new issue on github with predefined fields
        String title = this.getTitle();
        String body = this.textError.getText();
        String labels = "bug";
        String url = String.format("%s/new?labels=%s&title=%s&body=%s",
                GITHUB_ISSUES_PAGE,
                CardUtil.urlEncode(labels),
                CardUtil.urlEncode(title),
                CardUtil.urlEncode(body)
        );
        AppUtil.openUrlInSystemBrowser(url);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        btnOK = new javax.swing.JButton();
        pnlError = new javax.swing.JScrollPane();
        textError = new javax.swing.JTextArea();
        pnlInfo = new javax.swing.JScrollPane();
        textInfo = new javax.swing.JTextArea();
        btnCopyToClipboard = new javax.swing.JButton();
        btnOpenGithub = new javax.swing.JButton();

        setResizable(true);
        setTitle("Error");

        btnOK.setText("Close");
        btnOK.setMaximumSize(new java.awt.Dimension(59, 33));
        btnOK.setMinimumSize(new java.awt.Dimension(59, 33));
        btnOK.setPreferredSize(new java.awt.Dimension(59, 33));
        btnOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnOKActionPerformed(evt);
            }
        });

        textError.setEditable(false);
        textError.setColumns(20);
        textError.setLineWrap(true);
        textError.setRows(5);
        textError.setWrapStyleWord(true);
        pnlError.setViewportView(textError);

        textInfo.setEditable(false);
        textInfo.setLineWrap(true);
        textInfo.setText("[bug report instructions]");
        pnlInfo.setViewportView(textInfo);

        btnCopyToClipboard.setIcon(new javax.swing.ImageIcon(getClass().getResource("/buttons/copy_24.png"))); // NOI18N
        btnCopyToClipboard.setText("Copy error to clipboard");
        btnCopyToClipboard.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCopyToClipboardActionPerformed(evt);
            }
        });

        btnOpenGithub.setIcon(new javax.swing.ImageIcon(getClass().getResource("/buttons/search_24.png"))); // NOI18N
        btnOpenGithub.setText("Open github and create bug report");
        btnOpenGithub.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnOpenGithubActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(pnlInfo)
                    .addComponent(pnlError)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(btnCopyToClipboard, javax.swing.GroupLayout.PREFERRED_SIZE, 202, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnOpenGithub)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(btnOK, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(6, 6, 6)
                .addComponent(pnlInfo, javax.swing.GroupLayout.PREFERRED_SIZE, 73, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pnlError, javax.swing.GroupLayout.DEFAULT_SIZE, 225, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnOK, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnCopyToClipboard)
                    .addComponent(btnOpenGithub))
                .addGap(12, 12, 12))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOKActionPerformed
        this.hideDialog();
    }//GEN-LAST:event_btnOKActionPerformed

    private void btnCopyToClipboardActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCopyToClipboardActionPerformed
        AppUtil.setClipboardData(textError.getText());
    }//GEN-LAST:event_btnCopyToClipboardActionPerformed

    private void btnOpenGithubActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOpenGithubActionPerformed
        openGithub();
    }//GEN-LAST:event_btnOpenGithubActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCopyToClipboard;
    private javax.swing.JButton btnOK;
    private javax.swing.JButton btnOpenGithub;
    private javax.swing.JScrollPane pnlError;
    private javax.swing.JScrollPane pnlInfo;
    private javax.swing.JTextArea textError;
    private javax.swing.JTextArea textInfo;
    // End of variables declaration//GEN-END:variables

}
