/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.counter;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import mage.interfaces.PluginException;
import mage.interfaces.plugin.CounterPlugin;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.events.Init;
import net.xeoh.plugins.base.annotations.events.PluginLoaded;
import net.xeoh.plugins.base.annotations.meta.Author;
import org.apache.log4j.Logger;
import org.mage.plugins.counter.CounterBean;

@PluginImplementation
@Author(name="nantuko")
public class CounterPluginImpl
implements CounterPlugin {
    private static final String PLUGIN_DATA_FOLDER_PATH = "plugins" + File.separator + "plugin.data" + File.separator + "counters";
    private static final String DATA_STORAGE_FILE = "counters";
    private static final Logger log = Logger.getLogger(CounterPluginImpl.class);
    private boolean isLoaded = false;

    @Init
    public void init() {
        File data;
        File dataFolder = new File(PLUGIN_DATA_FOLDER_PATH);
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
            if (!dataFolder.exists()) {
                throw new RuntimeException("CounterPluginImpl: Couldn't create folders: " + PLUGIN_DATA_FOLDER_PATH);
            }
        }
        if (!(data = new File(PLUGIN_DATA_FOLDER_PATH + File.separator + DATA_STORAGE_FILE)).exists()) {
            try {
                data.createNewFile();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new RuntimeException("Couldn't create data file for counter plugin: " + e.getMessage());
            }
        }
        this.isLoaded = true;
    }

    @PluginLoaded
    public void newPlugin(CounterPlugin plugin) {
        log.info((Object)(plugin.toString() + " has been loaded."));
    }

    public String toString() {
        return "[Game counter plugin, version 0.1]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGamePlayed() throws PluginException {
        block32: {
            if (!this.isLoaded) {
                return;
            }
            File data = new File(PLUGIN_DATA_FOLDER_PATH + File.separator + DATA_STORAGE_FILE);
            ObjectInputStream ois = null;
            ObjectOutputStream oos = null;
            if (data.exists()) {
                CounterBean c;
                int prev = 0;
                try {
                    ois = new ObjectInputStream(new FileInputStream(data));
                    Object o = ois.readObject();
                    c = null;
                    if (o instanceof CounterBean) {
                        c = (CounterBean)o;
                        prev = c.getGamesPlayed();
                    }
                }
                catch (EOFException e) {
                }
                catch (IOException e) {
                    throw new PluginException((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    throw new PluginException((Throwable)e);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Exception e) {}
                    }
                }
                try {
                    CounterPluginImpl e = this;
                    synchronized (e) {
                        oos = new ObjectOutputStream(new FileOutputStream(data));
                        c = new CounterBean();
                        c.setGamesPlayed(prev + 1);
                        oos.writeObject(c);
                        oos.close();
                        break block32;
                    }
                }
                catch (IOException e) {
                    throw new PluginException((Throwable)e);
                }
                finally {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            log.error((Object)"Counter plugin: data file doesn't exist, please restart plugin.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getGamePlayed() throws PluginException {
        if (!this.isLoaded) {
            return -1;
        }
        File data = new File(PLUGIN_DATA_FOLDER_PATH + File.separator + DATA_STORAGE_FILE);
        if (!data.exists()) {
            return 0;
        }
        if (!data.exists()) {
            log.error((Object)"Counter plugin: data file doesn't exist, please restart plugin.");
            return 0;
        }
        ObjectInputStream ois = null;
        try {
            CounterPluginImpl counterPluginImpl = this;
            synchronized (counterPluginImpl) {
                ois = new ObjectInputStream(new FileInputStream(data));
                Object o = ois.readObject();
                CounterBean c = null;
                if (o instanceof CounterBean) {
                    c = (CounterBean)o;
                }
                ois.close();
                int n = c.getGamesPlayed();
                return n;
            }
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
            catch (ClassNotFoundException e2) {
                throw new PluginException((Throwable)e2);
            }
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception e) {}
            }
        }
        {
            catch (EOFException e) {
                int n = 0;
                return n;
            }
        }
    }
}

