/*******************************************************************************
 * The MIT License (MIT)
 *
 * Copyright (c) 2022, Jean-David Gadina - www.xs-labs.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the Software), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

import Cocoa

@objc( TemperatureToString )
public class TemperatureToString: ValueTransformer
{
    public override class func transformedValueClass() -> AnyClass
    {
        return NSString.self
    }

    public override class func allowsReverseTransformation() -> Bool
    {
        return false
    }

    public override func transformedValue( _ value: Any? ) -> Any?
    {
        let n: Int? =
        {
            if let n = value as? Int
            {
                return n
            }
            else if let n = value as? Double
            {
                return Int( n )
            }

            return nil
        }()

        guard var n = n, n > 0
        else
        {
            return "--" as NSString
        }

        if UserDefaults.standard.bool( forKey: "convertToFahrenheit" )
        {
            n = Int( Double( n ) * 1.8 + 32 )
        }

        let unit = UserDefaults.standard.bool( forKey: "convertToFahrenheit" ) ? "F" : "C"

        return "\( n )°\( unit )" as NSString
    }
}
