/*******************************************************************************
 * Copyright (c) 2012, Jean-David Gadina - www.xs-labs.com
 * All rights reserved.
 * 
 * Boost Software License - Version 1.0 - August 17th, 2003
 * 
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 * 
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************/
 
/* $Id$ */

#import "CKTranslationUnit+Private.h"
#import "CKIndex.h"

@implementation CKTranslationUnit( Private )

- ( id )initWithPath: ( NSString * )path text: ( NSString * )text index: ( CKIndex * )index args: ( NSArray * )args
{
    NSUInteger i;
    id         arg;
    
    if( ( self = [ self init ] ) )
    {
		_lock  = [ NSLock new ];
        _path  = [ path copy ];
        _index = ( index == nil ) ? [ CKIndex new ] : [ index retain ];
        
        if( text == nil )
        {
            _text = [ [ NSString stringWithContentsOfFile: _path encoding: NSUTF8StringEncoding error: NULL ] retain ];
            
            if( _text.length == 0 )
            {
                [ self release ];
                
                return nil;
            }
        }
        else
        {
            _text        = [ text retain ];
            _unsavedFile = calloc( sizeof( struct CXUnsavedFile ), 1 );
            
            if( _unsavedFile == NULL )
            {
                [ self release ];
                
                return nil;
            }
            
            ( ( struct CXUnsavedFile * )_unsavedFile )->Filename = _path.fileSystemRepresentation;
            ( ( struct CXUnsavedFile * )_unsavedFile )->Contents = _text.UTF8String;
            ( ( struct CXUnsavedFile * )_unsavedFile )->Length   = _text.length;
        }
        
        if( args.count > 0 )
        {
            _args = ( char ** )calloc( sizeof( char * ), args.count );
            
            if( _args == NULL )
            {
                [ self release ];
                
                return nil;
            }
            
            i = 0;
            
            for( arg in args )
            {
                if( [ arg isKindOfClass: [ NSString class ] ] == NO )
                {
                    continue;
                }
                
                _args[ i ] = calloc( sizeof( char ), strlen( ( ( NSString * )arg ).UTF8String ) + 1 );
                
                if( _args[ i ] == NULL )
                {
                    [ self release ];
                    
                    return nil;
                }
                
                strlcpy( ( char * )_args[ i ], ( ( NSString * )arg ).UTF8String, strlen( ( ( NSString * )arg ).UTF8String ) + 1 );
                
                i++;
                
                _numArgs = ( int )i;
            }
        }
        
        _cxTranslationUnit = clang_parseTranslationUnit
        (
            _index.cxIndex,
            _path.fileSystemRepresentation,
            ( const char * const * )_args,
            _numArgs,
            _unsavedFile,
            ( _unsavedFile == NULL ) ? 0 : 1,
            clang_defaultEditingTranslationUnitOptions()
          | CXTranslationUnit_DetailedPreprocessingRecord
          | CXTranslationUnit_PrecompiledPreamble
          | CXTranslationUnit_CacheCompletionResults
          | CXTranslationUnit_Incomplete
        );
        
        if( _cxTranslationUnit == NULL )
        {
            [ self release ];
            
            return nil;
        }
        
        [ self tokens ];
        [ self diagnostics ];
    }
    
    return self;
}

@end
