/*******************************************************************************
 * Copyright (c) 2012, Jean-David Gadina - www.xs-labs.com
 * All rights reserved.
 * 
 * Boost Software License - Version 1.0 - August 17th, 2003
 * 
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 * 
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************/
 
/* $Id$ */

/*!
 * @header          CKToken.h
 * @copyright       (c) 2010-2014 - Jean-David Gadina - www.xs-labs.com
 * @author          Jean-David Gadina - www.xs-labs.com
 * @abstract        ClangKit token class
 */

/*!
 * @typedef         CKTokenKind
 * @abstract        Token kind
 */
typedef NSInteger CKTokenKind;

/*!
 * @var             CKTokenKindPunctuation
 * @abstract        Token kind - Punctuation
 */
FOUNDATION_EXPORT CKTokenKind CKTokenKindPunctuation;

/*!
 * @var             CKTokenKindKeyword
 * @abstract        Token kind - Keyword
 */
FOUNDATION_EXPORT CKTokenKind CKTokenKindKeyword;

/*!
 * @var             CKTokenKindIdentifier
 * @abstract        Token kind - Identifier
 */
FOUNDATION_EXPORT CKTokenKind CKTokenKindIdentifier;

/*!
 * @var             CKTokenKindLiteral
 * @abstract        Token kind - Literal
 */
FOUNDATION_EXPORT CKTokenKind CKTokenKindLiteral;

/*!
 * @var             CKTokenKindComment
 * @abstract        Token kind - Comment
 */
FOUNDATION_EXPORT CKTokenKind CKTokenKindComment;

@class CKTranslationUnit;
@class CKCursor;
@class CKSourceLocation;

/*!
 * @class           CKToken
 * @abstract        Token class
 */
@interface CKToken: NSObject
{
@protected
    
    NSString         * _spelling;
    CKTokenKind        _kind;
    NSUInteger         _line;
    NSUInteger         _column;
    NSRange            _range;
    CKCursor         * _cursor;
    CKSourceLocation * _sourceLocation;
}

/*!
 * @property        spelling
 * @abstract        The token's spelling
 */
@property( atomic, readonly ) NSString * spelling;

/*!
 * @property        kind
 * @abstract        The token kind
 */
@property( atomic, readonly ) CKTokenKind kind;

/*!
 * @property        line
 * @abstract        The line number for the token
 */
@property( atomic, readonly ) NSUInteger line;

/*!
 * @property        column
 * @abstract        The column number for the token
 */
@property( atomic, readonly ) NSUInteger column;

/*!
 * @property        range
 * @abstract        The token's range
 */
@property( atomic, readonly ) NSRange range;

/*!
 * @property        cursor
 * @abstract        The token's cursor
 */
@property( atomic, readonly ) CKCursor * cursor;

/*!
 * @property        sourceLocation
 * @abstract        The source location of the token
 */
@property( atomic, readonly ) CKSourceLocation * sourceLocation;

/*!
 * @method          tokensForTranslationUnit:tokens:
 * @abstract        Gets a list of token objects from a translation unit
 * @param           translationUnit     The translation unit
 * @param           tokensPointer       Optional - Used to retrieve the internal libclang tokens
 * @return          An array of token objects
 */
+ ( NSArray * )tokensForTranslationUnit: ( CKTranslationUnit * )translationUnit tokens: ( void ** )tokensPointer;

@end
