/*******************************************************************************
 * Copyright (c) 2012, Jean-David Gadina - www.xs-labs.com
 * All rights reserved.
 * 
 * Boost Software License - Version 1.0 - August 17th, 2003
 * 
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 * 
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************/
 
/* $Id$ */

#import "CKIndex.h"

@implementation CKIndex

@synthesize cxIndex = _cxIndex;

+ ( id )index
{
    return [ [ [ self alloc ] init ] autorelease ];
}

- ( id )init
{
    if( ( self = [ super init ] ) )
    {
        _cxIndex = clang_createIndex( 0, 0 );
    }
    
    return self;
}

- ( void )dealloc
{
    clang_disposeIndex( _cxIndex );
    
    [ super dealloc ];
}

- ( BOOL )excludeDeclarationsFromPCH
{
    @synchronized( self )
    {
        return _excludeDeclarationsFromPCH;
    }
}

- ( BOOL )displayDiagnostics
{
    @synchronized( self )
    {
        return _displayDiagnostics;
    }
}

- ( void )setExcludeDeclarationsFromPCH: ( BOOL )value
{
    @synchronized( self )
    {
        if( value != _excludeDeclarationsFromPCH )
        {
            clang_disposeIndex( _cxIndex );
            
            _cxIndex = clang_createIndex( ( int )_excludeDeclarationsFromPCH, ( int )_displayDiagnostics );
        }
    }
}

- ( void )setDisplayDiagnostics: ( BOOL )value
{
    @synchronized( self )
    {
        if( value != _displayDiagnostics )
        {
            clang_disposeIndex( _cxIndex );
            
            _cxIndex = clang_createIndex( ( int )_excludeDeclarationsFromPCH, ( int )_displayDiagnostics );
        }
    }
}

@end
