/*******************************************************************************
 * Copyright (c) 2012, Jean-David Gadina - www.xs-labs.com
 * All rights reserved.
 * 
 * Boost Software License - Version 1.0 - August 17th, 2003
 * 
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 * 
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************/
 
/* $Id$ */

#import "CKFixIt.h"
#import "CKDiagnostic.h"

@implementation CKFixIt

@synthesize string = _string;
@synthesize range  = _range;

+ ( NSArray * )fixItsForDiagnostic: ( CKDiagnostic * )diagnostic
{
    unsigned int     i;
    unsigned int     n;
    NSMutableArray * fixIts;
    CKFixIt        * fixIt;
    
    n      = clang_getDiagnosticNumFixIts( diagnostic.cxDiagnostic );
    fixIts = [ NSMutableArray arrayWithCapacity: n ];
    
    for( i = 0; i < n; i++ )
    {
        fixIt = [ self fixItWithDiagnostic: diagnostic index: i ];
        
        if( fixIt != nil )
        {
            [ fixIts addObject: fixIt ];
        }
    }
    
    return [ NSArray arrayWithArray: fixIts ];
}

+ ( id )fixItWithDiagnostic: ( CKDiagnostic * )diagnostic index: ( NSUInteger )index
{
    return [ [ [ self alloc ] initWithDiagnostic: diagnostic index: index ] autorelease ];
}

- ( id )initWithDiagnostic: ( CKDiagnostic * )diagnostic index: ( NSUInteger )index
{
    CXSourceRange range;
    CXString      string;
    
    if( ( self = [ self init ] ) )
    {
        string  = clang_getDiagnosticFixIt( diagnostic.cxDiagnostic, ( unsigned int )index, &range );
        _string = [ [ NSString alloc ] initWithCString: clang_getCString( string ) encoding: NSUTF8StringEncoding ];
    }
    
    return self;
}

- ( void )dealloc
{
    [ _string release ];
    
    [ super dealloc ];
}

- ( NSString * )description
{
    NSString * description;
    
    description = [ super description ];
    description = [ description stringByAppendingFormat: @": %@", self.string ];
    
    return description;
}

@end
