/*******************************************************************************
 * Copyright (c) 2012, Jean-David Gadina - www.xs-labs.com
 * All rights reserved.
 * 
 * Boost Software License - Version 1.0 - August 17th, 2003
 * 
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 * 
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************/
 
/* $Id$ */

#import "CKDiagnostic.h"
#import "CKDiagnostic+Private.h"
#import "CKTranslationUnit.h"

CKDiagnosticSeverity CKDiagnosticSeverityIgnored  = CXDiagnostic_Ignored;
CKDiagnosticSeverity CKDiagnosticSeverityNote     = CXDiagnostic_Note;
CKDiagnosticSeverity CKDiagnosticSeverityWarning  = CXDiagnostic_Warning;
CKDiagnosticSeverity CKDiagnosticSeverityError    = CXDiagnostic_Error;
CKDiagnosticSeverity CKDiagnosticSeverityFatal    = CXDiagnostic_Fatal;

@implementation CKDiagnostic

@synthesize cxDiagnostic    = _cxDiagnostic;
@synthesize spelling        = _spelling;
@synthesize severity        = _severity;
@synthesize fixIts          = _fixIts;
@synthesize line            = _line;
@synthesize column          = _column;
@synthesize range           = _range;

+ ( NSArray * )diagnosticsForTranslationUnit: ( CKTranslationUnit * )translationUnit
{
    unsigned int     numDiagnostics;
    unsigned int     i;
    NSMutableArray * diagnostics;
    CKDiagnostic   * diagnostic;
    
    numDiagnostics = clang_getNumDiagnostics( translationUnit.cxTranslationUnit );
    diagnostics    = [ NSMutableArray arrayWithCapacity: ( NSUInteger )numDiagnostics ];
    
    for( i = 0; i < numDiagnostics; i++ )
    {
        diagnostic = [ CKDiagnostic diagnosticWithTranslationUnit: translationUnit index: i ];
        
        if( diagnostic != nil )
        {
            [ diagnostics addObject: diagnostic ];
        }
    }
    
    return [ NSArray arrayWithArray: diagnostics ];
}

+ ( id )diagnosticWithTranslationUnit: ( CKTranslationUnit * )translationUnit index: ( NSUInteger )index
{
    return [ [ [ self alloc ] initWithTranslationUnit: ( CKTranslationUnit * )translationUnit index: index ] autorelease ];
}

- ( id )initWithTranslationUnit: ( CKTranslationUnit * )translationUnit index: ( NSUInteger )index
{
    if( ( self = [ self initWithCXDiagnostic: clang_getDiagnostic( translationUnit.cxTranslationUnit, ( unsigned int )index ) translationUnit: translationUnit ] ) )
    {}
    
    return self;
}

- ( void )dealloc
{
    clang_disposeDiagnostic( _cxDiagnostic );
    
    [ _fixIts   release ];
    [ _spelling release ];
    
    [ super dealloc ];
}

- ( NSString * )description
{
    NSString * description;
    NSString * severity;
    
    if( self.severity == CKDiagnosticSeverityError )
    {
        severity = @"Error";
    }
    else if( self.severity == CKDiagnosticSeverityFatal )
    {
        severity = @"Fatal";
    }
    else if( self.severity == CKDiagnosticSeverityIgnored )
    {
        severity = @"Ignored";
    }
    else if( self.severity == CKDiagnosticSeverityNote )
    {
        severity = @"Note";
    }
    else if( self.severity == CKDiagnosticSeverityWarning )
    {
        severity = @"Warning";
    }
    else
    {
        severity = @"Unknown";
    }
    
    description = [ super description ];
    description = [ description stringByAppendingFormat: @": %@[%lu:%lu] - %@",
                                                         severity,
                                                         ( unsigned long )( self.line ),
                                                         ( unsigned long )( self.column ),
                                                         self.spelling
                  ];
    
    return description;
}

@end
