/*******************************************************************************
 * Copyright (c) 2012, Jean-David Gadina - www.xs-labs.com
 * All rights reserved.
 * 
 * Boost Software License - Version 1.0 - August 17th, 2003
 * 
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 * 
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************/
 
/* $Id$ */

#import "CKCursor+Private.h"
#import "CKSourceLocation.h"

@implementation CKCursor( Private )

- ( id )initWithCXCursor: ( CXCursor )cursor
{
    CXString            displayName;
    CXString            kindSpelling;
    CXSourceLocation    location;
    
    if( ( self = [ self init ] ) )
    {
        if( clang_Cursor_isNull( cursor ) )
        {
            [ self release ];
            
            return nil;
        }
        
        _cxCursorPointer = calloc( sizeof( CXCursor ), 1 );
        
        memcpy( _cxCursorPointer, &cursor, sizeof( CXCursor ) );
        
        _kind         = clang_getCursorKind( cursor );
        displayName   = clang_getCursorDisplayName( cursor );
        kindSpelling  = clang_getCursorKindSpelling( ( enum CXCursorKind )_kind );
        _displayName  = [ [ NSString alloc ] initWithCString: clang_getCString( displayName) encoding: NSUTF8StringEncoding ];
        _kindSpelling = [ [ NSString alloc ] initWithCString: clang_getCString( kindSpelling) encoding: NSUTF8StringEncoding ];
        location      = clang_getCursorLocation( cursor );
        _location     = [ [ CKSourceLocation alloc ] initWithPointerData1: location.ptr_data[ 0 ] pointerData2: location.ptr_data[ 1 ] intData: location.int_data ];
        
        if( clang_isCursorDefinition( cursor ) )
        {
            _isDefinition = YES;
        }
        
        [ self definition ];
        [ self referenced ];
        
        if( clang_isDeclaration(     ( enum CXCursorKind )_kind ) ) { _isDeclaration     = YES; }
        if( clang_isReference(       ( enum CXCursorKind )_kind ) ) { _isReference       = YES; }
        if( clang_isPreprocessing(   ( enum CXCursorKind )_kind ) ) { _isPreprocessing   = YES; }
        if( clang_isExpression(      ( enum CXCursorKind )_kind ) ) { _isExpression      = YES; }
        if( clang_isAttribute(       ( enum CXCursorKind )_kind ) ) { _isAttribute       = YES; }
        if( clang_isInvalid(         ( enum CXCursorKind )_kind ) ) { _isInvalid         = YES; }
        if( clang_isStatement(       ( enum CXCursorKind )_kind ) ) { _isStatement       = YES; }
        if( clang_isTranslationUnit( ( enum CXCursorKind )_kind ) ) { _isTranslationUnit = YES; }
        if( clang_isUnexposed(       ( enum CXCursorKind )_kind ) ) { _isUnexposed       = YES; }
    }
    
    return self;
}

@end
