/*******************************************************************************
 * Copyright (c) 2012, Jean-David Gadina - www.xs-labs.com
 * All rights reserved.
 * 
 * Boost Software License - Version 1.0 - August 17th, 2003
 * 
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 * 
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ******************************************************************************/
 
/* $Id$ */

/*!
 * @header          CKCompletionChunk.h
 * @copyright       (c) 2010-2014 - Jean-David Gadina - www.xs-labs.com
 * @author          Jean-David Gadina - www.xs-labs.com
 * @abstract        ClangKit completion chunk class
 */

/*!
 * @typedef         CKCompletionChunkKind
 * @abstract        Completion chunk kind
 */
typedef NSUInteger CKCompletionChunkKind;

/*!
 * @var             CKCompletionChunkKindOptional
 * @abstract        Completion chunk kind - Optional
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindOptional;

/*!
 * @var             CKCompletionChunkKindTypedText
 * @abstract        Completion chunk kind - Typed text
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindTypedText;

/*!
 * @var             CKCompletionChunkKindText
 * @abstract        Completion chunk kind - Text
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindText;

/*!
 * @var             CKCompletionChunkKindPlaceholder
 * @abstract        Completion chunk kind - Placeholder
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindPlaceholder;

/*!
 * @var             CKCompletionChunkKindInformative
 * @abstract        Completion chunk kind - Informative
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindInformative;

/*!
 * @var             CKCompletionChunkKindCurrentParameter
 * @abstract        Completion chunk kind - Current parameter
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindCurrentParameter;

/*!
 * @var             CKCompletionChunkKindLeftParen
 * @abstract        Completion chunk kind - Left parenthesis
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindLeftParen;

/*!
 * @var             CKCompletionChunkKindRightParen
 * @abstract        Completion chunk kind - Right parenthesis
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindRightParen;

/*!
 * @var             CKCompletionChunkKindLeftBracket
 * @abstract        Completion chunk kind - Left bracket
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindLeftBracket;

/*!
 * @var             CKCompletionChunkKindRightBracket
 * @abstract        Completion chunk kind - Right bracket
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindRightBracket;

/*!
 * @var             CKCompletionChunkKindLeftBrace
 * @abstract        Completion chunk kind - Left brace
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindLeftBrace;

/*!
 * @var             CKCompletionChunkKindRightBrace
 * @abstract        Completion chunk kind - Right brace
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindRightBrace;

/*!
 * @var             CKCompletionChunkKindLeftAngle
 * @abstract        Completion chunk kind - Left angle
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindLeftAngle;

/*!
 * @var             CKCompletionChunkKindRightAngle
 * @abstract        Completion chunk kind - Right angle
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindRightAngle;

/*!
 * @var             CKCompletionChunkKindComma
 * @abstract        Completion chunk kind - Comma
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindComma;

/*!
 * @var             CKCompletionChunkKindResultType
 * @abstract        Completion chunk kind - Result type
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindResultType;

/*!
 * @var             CKCompletionChunkKindColon
 * @abstract        Completion chunk kind - Colon
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindColon;

/*!
 * @var             CKCompletionChunkKindSemiColon
 * @abstract        Completion chunk kind - Semi colon
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindSemiColon;

/*!
 * @var             CKCompletionChunkKindEqual
 * @abstract        Completion chunk kind - Equal
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindEqual;

/*!
 * @var             CKCompletionChunkKindHorizontalSpace
 * @abstract        Completion chunk kind - Horizontal space
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindHorizontalSpace;

/*!
 * @var             CKCompletionChunkKindVerticalSpace
 * @abstract        Completion chunk kind - Vertical space
 */
FOUNDATION_EXPORT CKCompletionChunkKind CKCompletionChunkKindVerticalSpace;

/*!
 * @class           CKCompletionChunk
 * @abstract        Completion chunk class
 */
@interface CKCompletionChunk: NSObject
{
@protected

    NSString            * _text;
    CKCompletionChunkKind _kind;
}

/*!
 * @property        text
 * @abstract        The completion chunk's text
 */
@property( atomic, readonly ) NSString * text;

/*!
 * @property        kind
 * @abstract        The completion chunk's kind
 */
@property( atomic, readonly ) CKCompletionChunkKind kind;

/*!
 * @method          completionChunkWithCXCompletionString:chunkNumber:
 * @abstract        Gets a completion chunk from a completion string
 * @param           string      The completion string
 * @param           chunkNumber The chunk number
 * @return          The completion chunk object
 * @discussion      The returned object is autoreleased.
 */
+ ( id )completionChunkWithCXCompletionString: ( CXCompletionString )string chunkNumber: ( NSUInteger )chunkNumber;

/*!
 * @method          initWithCXCompletionString:chunkNumber:
 * @abstract        Initializes a completion chunk from a completion string
 * @param           string      The completion string
 * @param           chunkNumber The chunk number
 * @return          The completion chunk object
 */
- ( id )initWithCXCompletionString: ( CXCompletionString )string chunkNumber: ( NSUInteger )chunkNumber;

@end
