# Contribution Guidelines

- If you want to add something, keep it generally PG-13. I love accepting pull requests but if it's something vulgar I will slap it down. Same thing goes for generally unkind things. Basically, if you have to wonder if it's too edgy, it probably is. This is an inclusive and safe environment and if you don't like that for whatever reason, go make your own gem.

- Make sure you're adding changes in the right spot. I don't mind moving `end` statements around here and there but as this project grows, I'm gonna lean on you to know where `class`es and `def`s go. If I see it happening, I'll suggest an edit before accepting your request-- mostly to help you in the future (but also to make my life as a maintainer a little less work).

- Try labeling your `end` statements the way they're labeled in the other classes and methods. It'll help everyone stay organized and make it much more readable/cleaner. Also, if you're making something that's similar to one of the other methods already created, just add your method to the same class.

- Have fun! So far, this Ruby gem has no real-world value. You can create images and bundle them into your projects! It's a fun way to meme and learn code at the same time-- all while contributing to a fun open source project.
