# To-do list

## Things people want

- [x] Upload/download scores (really, editable sharing)
- [x] Multiple scores per page
- [ ] Download playback
- [ ] Actually useful triplets
- [ ] 2 of 2. etc. play back correctly
- [x] Marker showing where playback is
- [x] Playback ties properly
- [ ] Snapping for text box dragging
- [x] View-only mode for mobile

## Bugs to fix

- [ ] Dotting should retain the same group (by shortening other notes in group)
- [ ] Triplets with tails can group
- [ ] Deleting multiple staves doesn't preserve gap on first one

## Mobile

- [x] Shouldn't be able to create a new score
- [x] BPM slider not updating
- [x] Better images for playback
- [ ] Faster rendering needed! So that large scores can playback

## Small features

- [ ] Allow choosing fonts
- [ ] Contenteditable to allow editing text / e.t.c. without popup ?

## Big features

- [x] Single notes
- [x] Note groups
- [x] Modifying notes
- [x] Adding notes
- [x] Reactive gracenotes
- [x] Time signatures
- [x] Repeat marks
- [x] Second timings
- [x] Anacrusis
- [x] Note ties
- [x] Adding staves / bars
- [x] Text boxes
- [x] Triplets
- [x] Harmony Stave
- [x] Resizable interface
- [x] Copy/paste/undo/redo
- [x] Documentation
- [x] Saving / Loading
- [x] Printing
- [x] Playback

## Bugs fixed

- [x] fix slanted beams
- [x] cap should be dependent on how many notes are in the group
- [x] check / fix gaps between notes
- [x] combine rests somehow into a single rest (if there are multiple next to each other)
- [x] placing notes from a blank score (of different lengths)
- [x] fix random errors with adding note (it just throws an error sometimes)
- [x] Any time rests are merged, some notes are deleted
- [x] Make adding notes more frictionless
- [x] Make icons for note input
- [x] Width of drag boxes is wrong
- [x] Automatically group notes to correct grouping
- [x] Add notes before first note in bar and in empty bar
- [x] Deleting multiple notes doesn't work
- [x] todo in groupNotes function
- [x] Add zoom
- [x] previousNoteData should return correct x value
- [x] Ties on notes on input (if inputted notes are split)
- [x] Tied notes should move together
- [x] When splitting really large notes right after a short note, the large note gets split into too many short notes
- [x] Notes can't be added to the end of the bar
- [x] Placing a minim then one before it causes stack overflow
- [x] Placing a single quaver and then moving the mouse causes an error
- [x] Delete second timings when their notes are deleted
- [x] Delete noteXY when a note is deleted
- [x] Have noteLeft, noteRight and noteY instead of noteXY
- [x] Good default zoom
- [x] Better zoom (instead of this weird 5 \* 210 or whatever)
- [x] Second Timings for bars
- [x] ID for notes so that secondTiming can refer to that (also for bar, then there won't need to be different implementations!)
- [x] Tied notes still have bugs - e.g. changes gap between notes
- [x] a quaver then a crotchet in 6 8 produces 4 group notes
- [x] Selected items should be in a line from start to end
- [x] Selection should look nicer
- [x] Making a selection then adding another note somewhere crashes it (the selection is no longer in the noteModels)
- [x] Selecting a note then deleting its bar/stave leaves the selection box
- [x] Text box dragging is broken
- [x] Add transforms for texts
- [x] Correct zoom on page load
- [x] HG -> HA gracenote on next note looks a bit crushed
- [x] Merge long notes into long notes (semibreves into semibreves or minims, e.t.c.)
  - [x] Work out what the expected behaviour of groupNotes should be in regards to splitting notes into tied notes
- [x] I think for ties - no automatic insertion / deletion - it's too subjective
- [x] Tie-ing a crotchet to a semiquaver then placing a quaver in front breaks ties
- [x] Crotchet triplets act as if there is a beam
- [x] makeCorrectGroupings in Controller
- [x] Dragging a single gracenote up then down again causes a render bug
- [x] Tie causes a render bug
- [x] Bug where adding an odd number of notes then deleting breaks it
- [x] Remove all the state.score = { ...state.score } from Controller
- [x] It is too easy to accidentally add notes
- [x] Gracenotes on triplets
- [x] Dotted note can get crushed into next gracenote
- [x] Make a script to generate gracenote icons
- [x] Preview note for current placement
- [x] When adding triplets, use notes on stave rather than creating new notes
- [x] Better time signature editing (it should only change as far as the time signature is the same)
- [x] Deleting bar doesn't work
- [x] Remove forced no-caching once images/js/e.t.c. is in a stable state
- [x] Better second timing usage - you should click to add, then be able to drag the sections around
- [x] Second timing dragging will be a bar ahead for start, since it uses beforeX whereas the others use afterX
- [x] Make second timing dragging immutable
- [x] Use correct previous note in all calls to widthOfAnacrusis
- [x] Clicking on gracenote button then clicking off should unhighlight box
- [x] Clicking on gracenote button then clicking on note button is really slow??
- [x] Deal with selection going over stave break
- [x] Replace plus icon with an icon that is a smaller size than the code :) bin icon too maybe
- [x] Cut time
- [x] Bars/staves should be selectable
- [x] Selection will be a bit weird with triplets - e.g. rawselection / selection mismatch
- [x] Deleting triplets
- [x] Add before/after capability for bars, staves, anacrusis
- [x] Clicking after gracenote should not add to the first note in the bar
- [x] Clicking/dragging on another text while first is selected breaks it
- [x] Clicking between notes should add gracenote
- [x] Delete should delete all selected things
- [x] Adding text should not be above other texts
- [x] Clicking on note head shouldn't change note value
- [x] Text font size
- [x] Note placing in middle of bar is bad
- [x] Copy/paste bars
- [x] Put copy/paste over correct bar
- [x] Adding 2nds could be better
- [x] Tripleting three notes makes them move to the left
- [x] Adding gracenotes to triplets by clicking in between
- [x] Beaming on compound time doesn't work
- [x] Copying bars
- [x] Adding stave/bar doesn't have the correct time signature
- [x] Copy/paste button
- [x] Landscape
- [x] Add time signature adding
- [x] Mouse events being blocked dragging single
  - [x] Note heads shouldn't sink mouse events if other notes/gracenotes are being dragged
- [x] - Stave After should add to end by default
- [x] Bin -> 'Remove Gracenote'
- [x] Negative time signatures should be disallowed
- [x] Better denominator input (not input number)
- [x] 1st/2nd should be higher
- [x] End/Start of part barline
- [x] Changing time signatures doesn't work (at start of stave)
- [x] Centred text box shouldn't be draggable
- [x] Highlight single notes being dragged
- [x] Tieing sometimes adds massive ties on the stave above
- [x] Note too far forward in lead-in with time signature
- [x] Making centred text more intuitive
- [x] Shouldn't be able to put second timings over each other
- [x] Tieing to first/second note in bar doesn't work, tieing to previous stave doesn't work
- [x] Make triplets removable
- [x] Ties to triplets
- [x] Work out a good way to have the first note go nearer to the start of the bar
- [x] Add option to force breaks (e.g. for irregular time signatures)
- [x] Set zoom on toggling landscape
- [x] Demo note is being blocked by note
- [x] Disable keyboard shortcuts when dialogue box is showing
- [x] Backspace should work as well as delete
- [x] Home button
- [x] 1.5, 2 doesn't work, also 0.5
- [x] Work in quavers rather than crotchets for grouping
- [x] Shift-right/left should expand selection
- [x] Widths:
  - [x] Gap before gracenotes
  - [x] Anacruses
  - [x] Gracenote not properly relying on note before
  - [x] Start of bar
  - [x] Note boxes at end of bar weirdness
- [x] If the last note in a bar is a high a, then the bar gets shorter...
- [x] Up/Down should move notes
- [x] Hoverable documentation
- [x] Fix bottom of sidebar overlapping with docs
- [x] Make general commands always be on the far right
- [x] Ties are squint
- [x] More gap before first note in lead in
- [x] Copy/Paste should highlight on click
- [x] Second Timings over multiple staves
- [x] Maximum width for gracenotes
- [x] Make TODO DWIM
- [x] Make gracenotes selectable (to delete)
- [x] Gracenotes seem to be closer to the note in front
- [x] Can't drag single before a triplet
- [x] Right/Left to move sideways
- [x] Escape should deselect
- [x] Ties in playback
- [x] Tie within groups not working
- [x] Short tails should not be present when there is a beam opposite them
- [x] Deleteable second timings
- [x] Custom embellishments should be possible by adding multiple single gracenotes
- [x] On Chrome, using max-width < 1000px doesn't work???
- [x] Header is wider on Scores page
- [x] Home page being cut off at comma
- [x] Can't add gracenote before very first note
- [x] Unify all the removeState thingummies into something that makes sense
- [x] Move state.gracenote.input into Demo and so encapsulate addNote
- [x] BUG - renderMultiple dispatches things on the notes (e.g. clickNote) but in the case of triplets, it should dispatch on the actual objects
- [x] Adding gracenotes to triplets now won't work since it doesn't use the addGracenoteToTriplet but just the general one. Easily fixable
- [x] Merge gracenote.selected and maybe dragged items? into selection
- [x] Hovering over end of bar previews gracenote on first note
- [x] Note input doesn't move on notes that have gracenotes
- [x] Selecting a gracenote then deleting retains the selection box
- [x] Single gracenote preview should allow for custom embellishments
- [x] Should be able to drag notes in custom embellishments and/or add notes inside them
- [x] Highlight barline buttons in UI if a single bar is selected
- [x] Fix copy/paste
- [x] Notes with many beams can interfere with gracenotes (e.g. taorluath). Make beams lower?
- [x] Second timings over multiple pages
- [x] Page numbers
- [x] Printing overlaps pages
- [x] Printing multiple pages
- [x] Make tails look nicer
- [x] Too large a gap before embellishments
- [x] If the width of gracenotes gets too large, it is limited. This should be taken into account when sizing the bar
- [x] Shift-left
- [x] Make it possible to input natural notes immediately
- [x] Deleting a note then moving the mouse moves the currently selected note
- [x] Selecting multiple bars as the paste target
- [x] Better time signature font
- [x] Move multiple bars to next/previous line easily
- [x] Can't move middle/end of timing closer than 1 bar towards front
- [x] Add back in gaps after sentences in help documentation
- [x] Can't drag barlines well when there's stuff in the bar

## Harmony stave bug list

- [x] Selecting doesn't select bar
- [x] Copying/pasting in Firefox
- [x] Updating .measure() references in copy/paste
- [x] Check fix to measures() (before, if you selected from bar to note, then changing e.g. barline would affect all bars afterwards)
- [x] Saving
- [x] UI
- [x] Documentation
- [x] Check it doesn't destroy old scores
- [x] Playback
