export type Token = {
  type: TokenType;
  value: RegExpExecArray;
};

export enum TokenType {
  SOFTWARE_NAME_AND_VERSION = 'SOFTWARE_NAME_AND_VERSION',
  MIDI_NOTE_MAPPINGS = 'MIDI_NOTE_MAPPINGS',
  FREQUENCY_MAPPINGS = 'FREQUENCY_MAPPINGS',
  INSTRUMENT_MAPPINGS = 'INSTRUMENT_MAPPINGS',
  GRACENOTE_DURATIONS = 'GRACENOTE_DURATIONS',
  FONT_SIZES = 'FONT_SIZES',
  TUNE_FORMAT = 'TUNE_FORMAT',
  TUNE_TEMPO = 'TUNE_TEMPO',
  TEXT_TAG = 'TEXT_TAG',
  CLEF = 'CLEF',
  BAR_LINE = 'BAR_LINE',
  TERMINATING_BAR_LINE = 'TERMINATING_BAR_LINE',
  ACCIDENTAL = 'ACCIDENTAL',
  FERMATA = 'FERMATA',
  TIME_SIGNATURE = 'TIME_SIGNATURE',
  PART_BEGINNING = 'PART_BEGINNING',
  PART_END = 'PART_END',
  MELODY_NOTE = 'MELODY_NOTE',
  REST = 'REST',
  DOTTED_NOTE = 'DOTTED_NOTE',
  GRACENOTE = 'GRACENOTE',
  DOUBLING = 'DOUBLING',
  STRIKE = 'STRIKE',
  REGULAR_GRIP = 'REGULAR_GRIP',
  COMPLEX_GRIP = 'COMPLEX_GRIP',
  TAORLUATH = 'TAORLUATH',
  BUBBLY = 'BUBBLY',
  EDRE = 'EDRE',
  BIRL = 'BIRL',
  THROW = 'THROW',
  PELE = 'PELE',
  DOUBLE_STRIKE = 'DOUBLE_STRIKE',
  TRIPLE_STRIKE = 'TRIPLE_STRIKE',
  DOUBLE_GRACENOTE = 'DOUBLE_GRACENOTE',
  TIE_END_OR_TIE_OLD_FORMAT = 'TIE_END_OR_TIE_OLD_FORMAT',
  TIE_START = 'TIE_START',
  IRREGULAR_GROUP_START = 'IRREGULAR_GROUP_START',
  IRREGULAR_GROUP_END = 'IRREGULAR_GROUP_END',
  TRIPLET_OLD_FORMAT = 'TRIPLET_OLD_FORMAT',
  TRIPLET_NEW_FORMAT = 'TRIPLET_NEW_FORMAT',
  TIME_LINE_START = 'TIME_LINE_START',
  TIME_LINE_END = 'TIME_LINE_END',
  SPACE = 'SPACE',
}
