var path = require('path')
var config = require('../config')
var utils = require('./utils')
var webpack = require('webpack')
var merge = require('webpack-merge')
var baseWebpackConfig = require('./webpack.build.base')

var webpackConfig = merge(baseWebpackConfig, {
  entry: {
    'vue-mui.min': ['./src/less/vue-mui.less', './src/index.js']
  },
  module: {
    loaders: utils.styleLoaders({ sourceMap: false, extract: true })
  },
  vue: {
    loaders: utils.cssLoaders({ sourceMap: false, extract: true })
  },
  plugins: [
    new webpack.optimize.UglifyJsPlugin({
      sourceMap: false,
      drop_console: true,
      compress: {
        warnings: false
      }
    })
  ]
})

module.exports = webpackConfig

