
!function (win, lib) {
    var timer,
        doc = win.document,
        docElem = doc.documentElement,

        vpMeta = doc.querySelector('meta[name="viewport"]'),
        flexMeta = doc.querySelector('meta[name="flexible"]'),

        dpr = 0,
        scale = 0,

        flexible = lib.flexible || (lib.flexible = {});

    //  viewport meta
    if (vpMeta) {

        console.warn("еmetaǩű");
        var initial = vpMeta.getAttribute("content").match(/initial\-scale=([\d\.]+)/);

        if (initial) {
            scale = parseFloat(initial[1]); // õ initialScale
            dpr = parseInt(1 / scale);      // 豸ر devicePixelRatio
        }

    }
        //  flexible Meta
    else if (flexMeta) {
        var flexMetaContent = flexMeta.getAttribute("content");
        if (flexMetaContent) {

            var initial = flexMetaContent.match(/initial\-dpr=([\d\.]+)/),
                maximum = flexMetaContent.match(/maximum\-dpr=([\d\.]+)/);

            if (initial) {
                dpr = parseFloat(initial[1]);
                scale = parseFloat((1 / dpr).toFixed(2));
            }

            if (maximum) {
                dpr = parseFloat(maximum[1]);
                scale = parseFloat((1 / dpr).toFixed(2));
            }
        }
    }

    // viewport  flexible
    // meta δ
    if (!dpr && !scale) {
        // QST
        //  һʲô ?
        //  Android ëϵ ?
        var u = (win.navigator.appVersion.match(/android/gi), win.navigator.appVersion.match(/iphone/gi)),
            _dpr = win.devicePixelRatio;

        // ƺǽ Android 豸Ϊ 1 
        dpr = u ? ((_dpr >= 3 && (!dpr || dpr >= 3))
                        ? 3
                        : (_dpr >= 2 && (!dpr || dpr >= 2))
                            ? 2
                            : 1
                  )
                : 1;

        scale = 1 / dpr;
    }

    docElem.setAttribute("data-dpr", dpr);

    //  viewport meta
    if (!vpMeta) {
        vpMeta = doc.createElement("meta");

        vpMeta.setAttribute("name", "viewport");
        vpMeta.setAttribute("content",
            "initial-scale=" + scale + ", maximum-scale=" + scale + ", minimum-scale=" + scale + ", user-scalable=no");

        if (docElem.firstElementChild) {
            docElem.firstElementChild.appendChild(vpMeta)
        } else {
            var div = doc.createElement("div");
            div.appendChild(vpMeta);
            doc.write(div.innerHTML);
        }
    }

    function setFontSize() {
        var winWidth = docElem.getBoundingClientRect().width;

        if (winWidth / dpr > 640) {
            (winWidth = 640 * dpr);
        }

        // ڵ fontSize ݿȾ
        var baseSize = winWidth / 10;

        docElem.style.fontSize = baseSize + "px";
        flexible.rem = win.rem = baseSize;
    }

    // ʱ
    win.addEventListener("resize", function () {
        clearTimeout(timer);
        timer = setTimeout(setFontSize, 300);
    }, false);


    // һԼӵ
    // orientationchange ʱҲҪ°
    win.addEventListener("orientationchange", function () {
        clearTimeout(timer);
        timer = setTimeout(setFontSize, 300);
    }, false);


    // pageshow
    // keyword:  
    win.addEventListener("pageshow", function (e) {
        if (e.persisted) {
            clearTimeout(timer);
            timer = setTimeout(setFontSize, 300);
        }
    }, false);

    // û׼
    if ("complete" === doc.readyState) {
        doc.body.style.fontSize = 12 * dpr + "px";
    } else {
        doc.addEventListener("DOMContentLoaded", function () {
            doc.body.style.fontSize = 12 * dpr + "px";
        }, false);
    }

    setFontSize();

    flexible.dpr = win.dpr = dpr;

    flexible.refreshRem = setFontSize;

    flexible.rem2px = function (d) {
        var c = parseFloat(d) * this.rem;
        if ("string" == typeof d && d.match(/rem$/)) {
            c += "px";
        }
        return c;
    };

    flexible.px2rem = function (d) {
        var c = parseFloat(d) / this.rem;

        if ("string" == typeof d && d.match(/px$/)) {
            c += "rem";
        }
        return c;
    }
}(window, window.lib || (window.lib = {}));


$(function(){
	$("#myself").click(function() {
		$("#myinfo").toggle();
		$("#sc1").hide();
	});
})

$(function(){
	$("#sc2").click(function() {
		$("#sc1").toggle();
		$("#myinfo").hide();
	});
})

$(function(){
	$("#bdsharebuttonbox").click(function() {
		$("#sc1").hide();
		$("#myinfo").hide();
	});
})


$(function(){
	$("#navabar").click(function() {
		$("#navaul").toggle();
	});
})

/**
 * Created by Administrator on 2015/12/17.
 */
/*ض*/
$(function(){
    $(window).scroll(function() {
        if ($(this).scrollTop() > 50) {
            $('#scrollUp').fadeIn();
        } else {
            $('#scrollUp').fadeOut();
        }
    });
    $('#scrollUp').click(function() {
        $('body,html').animate({
            scrollTop: 0
        }, 200);
        return false;
    });
})