﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using LaborEntryApp.DB;
using System.Web.UI.HtmlControls;
using System.Globalization;
using System.Diagnostics;
// API Toolkit Libraries
using Lsa.Data;


//-------------------------
//never trust the client  |
//-------------------------

namespace LaborEntryApp
{
    public partial class TimeTool : System.Web.UI.Page
    {
        List<Model.LaborTicketModel> tk = new List<Model.LaborTicketModel>();//stores the labor tickets displayed on the table
        Model.EmployeeModel employee = new Model.EmployeeModel(); //stores the employee based on the windows account name.
        public static int minHours = 8; //minimum amount of hours for BK or OT;
        public static int maxDayHours = 13; //maximum hours per day
        public static int maxBankingPerWeek = 4; //maximun hours of banking per week
        public static string version = "Version 1.0.1"; //this value is displayed inside the div 'divVersion'
        static string d = "instance";

        //this method is a workaround:
        //disabled buttons in ASP automatically ignore OnClientClick, so this method is disabling 
        //these two buttons (btnSaveEdit and btnDelete) using javascript on the client side AFTER the page is generated by the server.
        //this allows us to avoid the OnClickClick being ignored.
        protected void Page_PreRender(object sender, EventArgs e)
        {
            string script = @"document.getElementById('{0}').disabled = true;";
            script = string.Format(script, btnSaveEdit.ClientID);
            Page.ClientScript.RegisterStartupScript(GetType(), "btnSaveEdit_Disable", script, true);
            string script2 = @"document.getElementById('{0}').disabled = true;";
            script2 = string.Format(script2, btnDelete.ClientID);
            Page.ClientScript.RegisterStartupScript(GetType(), "btnDelete_Disable", script2, true);
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            //checks the browser
            checkBrowser();

            //closing any connection
            //Dbms.Close("VMFG80");
            //Dbms.Close(d);

            ////connecting to the API 
            //try
            //{
            //    //connection to the VISUAL database
            //    //change to "WCSSRV0286/PILOT" to connect to the backup db
            //    Dbms.OpenDirect(d, "SQLSERVER", "", "WCSSRV0286/PILOT", LaborDB.getUser(), LaborDB.getPassword());
            //    //this.Session["instanceName"] = d;
            //}
            //catch (Exception ex)
            //{
            //    errorRedirect(ex, "Could not connect to the database.");
            //}

            //displaying the version
            divVersion.InnerText = version;

            //gets the employee loading the page
            string name = HttpContext.Current.Request.LogonUserIdentity.Name.Substring(7);
            try { employee = LaborDB.getEmployeeID(name, d); } catch (Exception ex) { errorRedirect(ex, "Could not get the emloyee ID. "); }
            lblEmpInfo.Text = "<strong>Employee:</strong> " + employee.lastname + ", " + employee.firstname;

            //this block of code only works in the first page load.
            if (!IsPostBack)
            {
                //loading indirects from the INDIRECT table
                List<string> indirects = new List<string>();
                try { indirects = LaborDB.getIndirectIds(d); } catch (Exception ex) { errorRedirect(ex, "Could not load indirect list."); }
                ddlInd.Items.Add("-");
                foreach (var ind in indirects)
                {
                    ddlInd.Items.Add(ind);
                }

                //setting current date on the first page load
                HtmlInputGenericControl inputdate = iptDate;
                inputdate.Value = DateTime.Now.Date.ToString("yyyy-MM-dd");
                loadTicketsInput(DateTime.Now.Date.ToString("yyyy-MM-dd"));

                //setting the date range
                Model.DatePeriodModel dp = new Model.DatePeriodModel();
                try { dp = LaborDB.getDateRange(d); } catch (Exception ex) { errorRedirect(ex, "Could not load date range for the calendar picker."); }
                inputdate.Attributes.Add("min", dp.min.ToString("yyyy-MM-dd"));
                inputdate.Attributes.Add("max", dp.max.ToString("yyyy-MM-dd"));

                //loading workproduct and task in the last section
                loadWp();
                loadTask();
                loadMilestone();

                //making wopo disabled
                dplWoPo.Enabled = false;
            }

            //loading holiday table
            getHolidays();

            //making txtWopo read only
            dplWoPo.Attributes.Add("readonly", "readonly");

            //set the focus to the button
            btnCheck.Focus();

            //getting the last for the period
            try
            {
                lblPeriodInfo.Text = "<strong>Month End:<br><span style=\"color:red\"> " + LaborDB.getPeriodLastDay(d).ToString("dd-MM-yyyy") + "</span></strong>";
            }
            catch (Exception ex)
            {
                errorRedirect(ex, "Could not get the period last day. ");
            }
        }

        //this method is fired when check button is clicked. 
        //1 - get the PRODUCT_ID  for the bugzilla item typed by the user.
        //2 - tries to find a project in the WORK_ORDER table. It will try to find the work order matching BUGS.PRODUCT_ID with WORK_ORDER.USER_9,
        //this is the query: SELECT BASE_ID, LOT_ID, SPLIT_ID FROM WORK_ORDER WHERE USER_9 = *product_id_here*. Then, we put the result inside dplWoPo text box.
        //3 - if dplWoPo is empty (in this case it will be equal to "//") that means it is INDIRECT. 
        //4 - else it is direct, then the code loads the LEGS.
        protected void btnCheck_Click(object sender, EventArgs e)
        {
            //cleaning the dropboxes to avoid duplicate elements
            ddlLeg.Items.Clear();

            //getting PRODUCT_ID from the BUGS table
            string prodId = "";
            try { prodId = BugzillaDB.getProductId(tbxBz.Text); } catch (Exception ex) { errorRedirect(ex, "Could not get product id. "); }

            //check if prodId is null
            //if it is null = bugzilla is invalid
            if (prodId.Equals("")){
                HtmlGenericControl div = (HtmlGenericControl)divbuginfo;
                divbuginfo.Style.Add("Display", "none");
                tbxBz.Attributes.Remove("readonly");
                tbxBz.Text = "";
                btnCheck.Text = "Check";
                dplWoPo.Text = "";
                loadTicketsInput(Request["iptDate"]);
                alertError("Could not find a product for this bugzilla item. The ID for this bugzilla bug seems invalid.");
                return;
            }

            if (!prodId.Contains("failed"))
            {
                //loading product
                Model.WorkOrderModel workOrder = new Model.WorkOrderModel();
                try { workOrder = LaborDB.getWorkOrderId(prodId, d); } catch (Exception ex) { errorRedirect(ex, "Could not get the work order id. "); }

                //check if bugzilla item is linked to a invalid work order
                if(workOrder.baseId != null)
                {
                    if (!workOrder.status.Equals("R") && !workOrder.status.Equals("F"))
                    {
                        loadTickets();
                        alertError("The Work order for this bugzilla item is not available.<br/> " + workOrder.baseId + " is not a RELEASED OR FIRM work order.");
                        updatePanelTable.Update();
                        return;
                    }
                }
                
                dplWoPo.Text = workOrder.baseId + "/" + workOrder.lotId + "/" + workOrder.splitId;

                //checking if it is direct of indirect
                //--------------------
                //indirect
                if (dplWoPo.Text.Equals("//") || checkInd())
                {
                    try
                    {
                        tbxBz.Attributes.Add("readonly", "readonly");
                        btnCheck.Text = "Change bug";

                        //getting bug title
                        string desc = "";
                        try { desc = BugzillaDB.getDescription(tbxBz.Text); } catch (Exception ex) { errorRedirect(ex, "Could not get short description. "); }
                        Model.BugzillaProductModel bzProduct = new Model.BugzillaProductModel();
                        try { bzProduct = BugzillaDB.getProdDescription(prodId); } catch (Exception ex) { errorRedirect(ex, "Could not get indirect product details. "); }
                        bzProduct.name = bzProduct.name.Substring(1, bzProduct.name.IndexOf(']') - 1);

                        //try to get the indirect for the buzilla
                        //selecting the indirect value on indirect dropdownlist (ddlInd)
                        try
                        {
                            ddlInd.SelectedValue = LaborDB.getSimpleIndirect(bzProduct.name, d);
                        }
                        
                        catch
                        {
                            //if it fails = no match between products.id and work_order.user_9
                            divbuginfo.Style.Add("Display", "none");
                            tbxBz.Attributes.Remove("readonly");
                            tbxBz.Text = "";
                            btnCheck.Text = "Check";
                            dplWoPo.Text = "";
                            loadTickets();
                            alertError("Could not find the product id " + prodId + " for this bugzilla item in the user_9 field.");
                            updatePanelTable.Update();
                            loadTicketsInput(Request["iptDate"]);
                            return;
                        }

                        //disabling and cleaning 'no indirect' elements:
                        divbuginfo.Style.Add("Display", "block");
                        lblProductName.Text = desc.Length > 60 ? ("<strong>BUG title: </strong><a href=\"http://menu/bugzilla3/show_bug.cgi?id=" + tbxBz.Text + "\"target=\"_blank\">" + desc.Substring(0, 55) + "..." + "</a>") : ("<strong>BUG title: </strong><a href=\"http://menu/bugzilla3/show_bug.cgi?id=" + tbxBz.Text + "\"target=\"_blank\">" + desc + "</a>");
                        dplWoPo.Enabled = false;
                        dplWoPo.Text = "";
                        ddlLeg.Enabled = false;
                        ddlLeg.Items.Clear();
                        ddlOpn.Enabled = false;
                        ddlOpn.Items.Clear();

                        //disabling indirect dropdown 
                        ddlInd.Enabled = false;

                        //loadind the tickets
                        loadTicketsInput(Request["iptDate"]);

                        //checking for modfications in the bug
                        checkBugUpdates();

                    }
                    catch//all invalid bugzilla items land here
                    {
                        //HtmlGenericControl div = (HtmlGenericControl)divbuginfo;
                        divbuginfo.Style.Add("Display", "none");
                        tbxBz.Attributes.Remove("readonly");
                        tbxBz.Text = "";
                        btnCheck.Text = "Check";
                        dplWoPo.Text = "";
                        loadTicketsInput(Request["iptDate"]);
                        alertError("Could not find a product for this bugzilla item. The ID for this bugzilla bug seems invalid.");
                        return;
                    }

                }
                //a project was found in the WORK_ORDER table. 
                //what this method does: disabling and cleaning indirect elements; loading product name, description to label; 
                //displaying div that holds that information; enabling direct elements
                else
                {
                    //displaying bug info
                    tbxBz.Attributes.Add("readonly", "readonly");
                    btnCheck.Text = "Change bug";
                    string desc = "";
                    try { desc = BugzillaDB.getDescription(tbxBz.Text); } catch (Exception ex) { errorRedirect(ex, "Could not get short description. "); }
                    divbuginfo.Style.Add("Display", "block");
                    lblProductName.Text = desc.Length > 60 ? ("<strong>BUG title: </strong><a href=\"http://menu/bugzilla3/show_bug.cgi?id=" + tbxBz.Text + "\"target=\"_blank\">" + desc.Substring(0, 55) + "..." + "</a>") : ("<strong>BUG title: </strong><a href=\"http://menu/bugzilla3/show_bug.cgi?id=" + tbxBz.Text + "\"target=\"_blank\">" + desc + "</a>");

                    //enabling direct elements
                    dplWoPo.Enabled = true;
                    ddlLeg.Enabled = true;
                    ddlLeg.Items.Clear();
                    ddlOpn.Enabled = true;
                    ddlOpn.Items.Clear();

                    //disabling indirect elements
                    ddlInd.Enabled = false;
                    ddlInd.SelectedValue = "-";

                    //loading tickets
                    loadTicketsInput(Request["iptDate"]);

                    //loading the legs (insert the legs in the dropdown element (ddlLeg))
                    try
                    {
                        String finalWopo = dplWoPo.Text;
                        finalWopo = finalWopo.Substring(0, finalWopo.IndexOf('/'));
                        List<string> workOrders = LaborDB.getWorkOrderLegs(finalWopo, d);
                        if (workOrders.Count > 0)
                        {
                            foreach (var order in workOrders)
                            {
                                ddlLeg.Items.Add(order);
                            }
                        }
                        else
                        {
                            //cleaning legs and opn to avoid duplicated options
                            ddlLeg.Items.Clear();
                            ddlOpn.Items.Clear();
                        }

                        //check if the employee made any updates to the bug recently
                        checkBugUpdates();
                    }
                    catch (Exception ex)
                    {
                        errorRedirect(ex, "Could not get the work order legs. ");
                    }

                    //reload panel (leg and opn dropdown list are inside it). This is to avoid reloading the entire page again
                    updatePanelLeg.Update();
                }
            }
        }

        //load opn
        protected void ddlLeg_SelectedIndexChanged(object sender, EventArgs e)
        {
            ddlOpn.Items.Clear();
            string x = ddlLeg.SelectedValue.Substring(0, ddlLeg.SelectedValue.IndexOf(" "));

            try
            {
                String finalWopo = dplWoPo.Text;
                finalWopo = finalWopo.Substring(0, finalWopo.IndexOf('/'));
                List<string> seqNumbers = LaborDB.getSeqNumber(finalWopo, x, d);
                if (seqNumbers.Count > 0)
                {
                    foreach (var seqNumber in seqNumbers)
                    {
                        ddlOpn.Items.Add(seqNumber);
                    }
                }
            }
            catch (Exception ex)
            {
                alertError("We could not find the sequence numbers for this product. Details: " + ex.Message);
                ddlOpn.Items.Clear();
            }

            //reload panel (leg and opn dropdown list are inside it). This is to avoid reloading the entire page again
            updatePanelLeg.Update();

            //hide progress bar
            progressdiv.Style.Add("Visibility", "hidden");
        }

        //load Work products dropdown in the comment section
        public void loadWp()
        {
            ddlWp.Items.Clear();
            ddlWp.Items.Add("-");

            try
            {
                List<Model.GenericDropDownModel> workProductList = BachEngDB.getWorkProductList();

                for (var i = 0; i <= workProductList.Count - 1; i++)
                {
                    ddlWp.Items.Add(workProductList[i].label + "-" + workProductList[i].value);
                }
            }
            catch (Exception ex)
            {
                errorRedirect(ex, "Could not load Work Product list. ");
            }
        }

        //load Tasks dropdown in the comment section
        public void loadTask()
        {
            ddlTk.Items.Clear();
            ddlTk.Items.Add("-");

            try
            {
                List<Model.GenericDropDownModel> workTaskList = BachEngDB.getTaksList();

                for (var i = 0; i <= workTaskList.Count - 1; i++)
                {
                    ddlTk.Items.Add(workTaskList[i].label + "-" + workTaskList[i].value);
                }
            }
            catch (Exception ex)
            {
                errorRedirect(ex, "Could not load Task list. ");
            }

        }

        //load milestone dropdown in the comment section
        public void loadMilestone()
        {
            ddlMil.Items.Clear();
            ddlCurMil.Items.Clear();
            ddlMil.Items.Add("-");
            ddlCurMil.Items.Add("-");

            try
            {
                List<Model.GenericDropDownModel> workMilistoneList = BachEngDB.getMilestoneList();

                for (var i = 0; i <= workMilistoneList.Count - 1; i++)
                {
                    ddlMil.Items.Add(workMilistoneList[i].label + "-" + workMilistoneList[i].value);
                    ddlCurMil.Items.Add(workMilistoneList[i].label + "-" + workMilistoneList[i].value);
                }
            }
            catch (Exception ex)
            {
                errorRedirect(ex, "Could not load the Milestone lists. ");
            }
        }

        //fired when go button is cliked. This method gets all the tickets for a determinated date from the database
        //this method only loads the tickets to the list (List tk)
        public void loadTicketsInput(string date)
        {
            //updating information in the label
            lblTickets.Text = "List of Tickets for " + date;

            //cleaning the list of tickets 
            tk.Clear();

            date = date + " 00:00:00";//IMPORTANT! In the database the time is always zero.

            //getting the tickets from the db
            try { tk = LaborDB.listLaborTicket(date, employee.id, d); } catch (Exception ex) { errorRedirect(ex, "Could not load the tickets. "); }

            //check for updates on the bug again
            if (!tbxBz.Text.Equals(""))
                checkBugUpdates();

            //loading the tickets to the table
            loadTickets();
        }

        //this method loads the tickets to the html table
        public void loadTickets()
        {
            //cleaning the table before inserting new rows
            if (tblTickets.Rows.Count > 0)
            {
                for (var i = tblTickets.Rows.Count - 1; i >= 1; i--)
                {
                    tblTickets.Rows.RemoveAt(i);
                }
            }

            decimal count = 0; //counts only NO (normal) tickets
            decimal totalCount = 0; //counts all the hours for all the tickets
            foreach (var ticket in tk)
            {
                //counting the hours
                totalCount = totalCount + Decimal.Parse(ticket.hoursworked);
                
                //new row 
                TableRow row = new TableRow();

                //cells for the row
                TableCell cell1 = new TableCell();
                TableCell cell2 = new TableCell();
                TableCell cell3 = new TableCell();
                TableCell cell4 = new TableCell();
                TableCell cell5 = new TableCell();
                TableCell cell6 = new TableCell();
                TableCell cell7 = new TableCell();
                TableCell cell8 = new TableCell();

                //edit button
                cell1.Text = "<button type=\"button\" class=\"badge badge-info\">Edit</button>";
                cell1.Attributes.Add("onclick", "editTicketRow(this)"); //adding onclick js event

                //ticket number
                cell2.Text = ticket.ltnum;

                //if woind is "//" (null) it is indirect. 
                //we get the items from the indirect dropdownlist and search for the code in there
                //for example: "10012" is "10012-VACATION"
                if (ticket.woind.Equals("//"))
                {
                    List<String> allIndirectEle = new List<String>();
                    foreach (var item in ddlInd.Items)
                    {
                        allIndirectEle.Add(item.ToString());
                    }

                    foreach (var ind in allIndirectEle)
                    {
                        if (ind.Contains(ticket.indirectId))
                        {
                            cell3.Text = ind;
                        }
                    }
                }
                //in this case the ticket has a workproduct (no indirect)
                else
                {
                    cell3.Text = ticket.woind;
                }

                //gets the leg id
                if (!ticket.woind.Equals(""))
                {
                    try { cell4.Text = ticket.leg + " " + LaborDB.getSimpleLeg(ticket.woind.Substring(0, ticket.woind.IndexOf('/')), ticket.leg, d); } catch (Exception ex) { errorRedirect(ex, "Could not load the leg description. "); }
                    cell5.Text = ticket.seqNum + " " + ticket.resource;
                }
                else
                {
                    cell4.Text = ticket.leg;
                    cell5.Text = ticket.resource;
                }

                //hours 
                cell6.Text = ticket.hoursworked;

                //category of the ticket
                cell7.Text = (ticket.overtime.Equals("1.000")) ? "NO" : "OT";

                //spliting the description part of the comment
                string[] splitComment = ticket.description.Split(',');

                //checking if the comment has a bug item on it. If yes, a link is created
                cell8.Text = (splitComment[4].Equals("") || splitComment[4].Equals("-")) ? ticket.description : ("<a href=\"http://menu/bugzilla3/show_bug.cgi?id=" + splitComment[4].Substring(1) + "\"target=\"_blank\">" + ticket.description + "</a>");
                if (splitComment[5].Equals("BK"))
                {
                    cell7.Text = "BK";
                }

                //counting normal tickets
                if (ticket.overtime.Equals("1.000") && !splitComment[5].Equals("BK"))
                {
                    count = count + Decimal.Parse(ticket.hoursworked);
                }

                //background in red if a NO ticket is over 8 hours
                if (count > 8 && ticket.overtime.Equals("1.000") && !splitComment[5].Equals("BK"))
                {
                    cell6.BackColor = System.Drawing.ColorTranslator.FromHtml("#ff4d4d");
                }

                //adding all the cells to the row
                row.Cells.Add(cell1);
                row.Cells.Add(cell2);
                row.Cells.Add(cell3);
                row.Cells.Add(cell4);
                row.Cells.Add(cell5);
                row.Cells.Add(cell6);
                row.Cells.Add(cell7);
                row.Cells.Add(cell8);
                
                //adding the row to the table
                tblTickets.Rows.Add(row);
            }

            //displaing the total of hours 
            lblTotalHours.Text = "<strong>Today total hours:</strong> " + totalCount.ToString();

            //updating the panel
            updatePanelHours.Update();
        }

        //loads the tickets for a date. Fired by the load tickets button
        protected void btnGoDate_Click(object sender, EventArgs e)
        {
            //loading tickets
            loadTicketsInput(Request["iptDate"]);

            //updating the table panel
            updatePanelTable.Update();
        }

        //checks if the date is available to tickets
        public bool checkDateRange()
        {
            string date = Request["iptDate"];
            bool a = LaborDB.checkDate(date, d);
            return a;
        }

        //save event from save button
        protected void btnSave_Click(object sender, EventArgs e)
        {
            //checking if the date selected is allowed.
            //this is to catch client side modifications with javascript
            if (!checkDateRange())
            {
                alertError("Looks like you are trying to save a ticket for a date in a locked period. The current avaible period is between: " + iptDate.Attributes["min"] + " and " + iptDate.Attributes["max"] + "");
                return;
            }

            //checking hours requirements
            if (!checkNewTicket())
            {
                //reload tickets table, clean fields, hide labels
                loadTicketsInput(Request["iptDate"]);
                return;
            }

            //displaying the progress bar
            HtmlGenericControl div = progressdiv;
            progressdiv.Style.Add("Visibility", "visible");

            //removing any comma or & from the comment
            string finalComment = txtComment.Text;
            finalComment = finalComment.Replace(",", "");
            finalComment = finalComment.Replace("&", "");

            //preparing all the values. Basically from "CD-Customer Drawing" to "CD" for most of the fields
            string finalWorkProd = ddlWp.SelectedValue.Substring(0, ddlWp.SelectedValue.IndexOf('-'));
            finalWorkProd = (finalWorkProd.Equals("")) ? "-" : finalWorkProd;
            string finalTask = ddlTk.SelectedValue.Substring(0, ddlTk.SelectedValue.IndexOf('-'));
            finalTask = (finalTask.Equals("")) ? "-" : finalTask;
            string finalMilistone = ddlMil.SelectedValue.Substring(0, ddlMil.SelectedValue.IndexOf('-'));
            finalMilistone = (finalMilistone.Equals("")) ? "-" : finalMilistone;
            string finalCurMilistone = ddlCurMil.SelectedValue.Substring(0, ddlCurMil.SelectedValue.IndexOf('-'));
            finalCurMilistone = (finalCurMilistone.Equals("")) ? "-" : finalCurMilistone;

            string finalIndirect = "";
            if (!ddlInd.SelectedValue.Equals(""))
            {
                finalIndirect = ddlInd.SelectedValue.Substring(0, ddlInd.SelectedValue.IndexOf('-'));//from "10012-VACATION" to "10012"
            }

            //preparing to call the save functions:
            //if dplWoPo IS EMPTY = indirect ticket         
            if (dplWoPo.Text.Equals(""))
            {
                //saving ticket. Note that the date needs to have time added.
                //LaborDB.saveTikectInd(finalIndirect, tbxBz.Text, employee.id, txtHours.Text, ddlOver.SelectedValue, Request["iptDate"] + " 00:00:00", finalWorkProd, finalTask, finalMilistone, finalCurMilistone, finalComment, d);
                LaborDB.saveTikectInd(finalIndirect, tbxBz.Text, employee.id, txtHours.Text, ddlOver.SelectedValue, Request["iptDate"] + " 00:00:00", finalWorkProd, finalTask, finalMilistone, finalCurMilistone, finalComment, d);

            }
            //ELSE it is a direct ticket
            else
            {
                //preparing the workorder
                //eg.: "996-CTA_7000/1/0" to "996-CTA_7000" and "1" and "0"
                string[] splitWorkOrder = dplWoPo.Text.Split('/');
                string finalBaseId = splitWorkOrder[0];
                string finalLotId = splitWorkOrder[1];
                string finalSplitId = splitWorkOrder[2];

                string finalLeg = ddlLeg.SelectedValue.Substring(0, ddlLeg.SelectedValue.IndexOf(' '));//from "100 ASSEMBLY" to "100"
                string finalSeq = ddlOpn.SelectedValue.Substring(0, ddlOpn.SelectedValue.IndexOf(' '));//from "10 E1" to "10"
                Decimal hourlyCost = Decimal.Parse(LaborDB.getHourlyCost(finalBaseId, finalLeg, finalSeq, d));//getting hourlycost

                //saving ticket. Note that the date needs to have time added.
                LaborDB.saveTikect(tbxBz.Text, finalBaseId, finalLotId, finalSplitId, finalLeg, finalSeq, employee.id, hourlyCost, txtHours.Text, ddlOver.SelectedValue, Request["iptDate"] + " 00:00:00", finalWorkProd, finalTask, finalMilistone, finalCurMilistone, finalComment, d);
            }

            //reload tickets table, clean fields, hide labels
            clearFields();
            alertSucess("Ticket saved!");
        }

        //update method from update button
        //this method is basically the same as btnSave_Click() but this one only gets called when updating a ticket
        protected void btnSaveEdit_Click(object sender, EventArgs e)
        {

            //checking hours requirements
            if (!checkUpdateTicket())
            {
                //reload tickets table, clean fields, hide labels
                loadTicketsInput(Request["iptDate"]);
                return;
            }

            //preparing all the values. Basically from "CD-Customer Drawing" to "CD" for most of the fields
            string finalComment = txtComment.Text;
            finalComment = finalComment.Replace(",", "");
            finalComment = finalComment.Replace("&", "");
            string finalBzItem = tbxBz.Text;
            finalBzItem = (finalBzItem.Equals("")) ? "-" : finalBzItem;
            string finalWorkProd = ddlWp.SelectedValue.Substring(0, ddlWp.SelectedValue.IndexOf('-'));//FROM "CD-Customer Drawing" to "CD"
            finalWorkProd = (finalWorkProd.Equals("")) ? "-" : finalWorkProd;
            string finalTask = ddlTk.SelectedValue.Substring(0, ddlTk.SelectedValue.IndexOf('-'));
            finalTask = (finalTask.Equals("")) ? "-" : finalTask;
            string finalMilistone = ddlMil.SelectedValue.Substring(0, ddlMil.SelectedValue.IndexOf('-'));
            finalMilistone = (finalMilistone.Equals("")) ? "-" : finalMilistone;
            string finalCurMilistone = ddlCurMil.SelectedValue.Substring(0, ddlCurMil.SelectedValue.IndexOf('-'));
            finalCurMilistone = (finalCurMilistone.Equals("")) ? "-" : finalCurMilistone;
            string finalInd = "";
            if (!ddlInd.SelectedValue.Equals("-"))
            {
                finalInd = ddlInd.SelectedValue.Substring(0, ddlInd.SelectedValue.IndexOf('-'));
            }

            //displaying progress bar
            progressdiv.Visible = true;

            //getting the ticket id
            string finalTicketId = Request["ticketId"];

            try
            {
                LaborDB.updateTicket(Int32.Parse(finalTicketId), finalBzItem, finalInd, txtHours.Text, ddlOver.SelectedValue, finalWorkProd, finalTask, finalMilistone, finalCurMilistone, finalComment, d);
            }
            catch (Exception ex)
            {
                errorRedirect(ex, "Could not update the ticket. ");
            }

            //reload tickets table, clean fields, hide labels
            clearFields();
            alertSucess("Ticket updated!");
        }

        //this method checks for the requirements before saving a ticket
        //to change these values go to the constants at the beginning of this code
        //min hours before OT or BK = 8
        //max hours per day = 13
        //max Bk hours per week = 4
        public bool checkNewTicket()
        {
            //loading tickets
            List<Model.LaborTicketModel> list = new List<Model.LaborTicketModel>();
            try { list = LaborDB.listLaborTicket(Request["iptDate"] + " 00:00:00", employee.id, d); } catch (Exception ex) { errorRedirect(ex, "Could not load tickets. "); };

            //counting the hours for NORMAL and no NORMAL tickets
            decimal totalHours = 0;
            decimal totalNoHours = 0;

            //preparing all the fields
            //get all the tickets for the current day and then add the one made by the user,
            //then the amount of hours is checked
            string finalBzItem = tbxBz.Text;
            finalBzItem = (finalBzItem.Equals("")) ? "-" : finalBzItem;
            string finalWorkProd = ddlWp.SelectedValue.Substring(0, ddlWp.SelectedValue.IndexOf('-'));//FROM "CD-Customer Drawing" to "CD"
            finalWorkProd = (finalWorkProd.Equals("")) ? "-" : finalWorkProd;
            string finalTask = ddlTk.SelectedValue.Substring(0, ddlTk.SelectedValue.IndexOf('-'));
            finalTask = (finalTask.Equals("")) ? "-" : finalTask;
            string finalMilistone = ddlMil.SelectedValue.Substring(0, ddlMil.SelectedValue.IndexOf('-'));
            finalMilistone = (finalMilistone.Equals("")) ? "-" : finalMilistone;
            string finalCurMilistone = ddlCurMil.SelectedValue.Substring(0, ddlCurMil.SelectedValue.IndexOf('-'));
            finalCurMilistone = (finalCurMilistone.Equals("")) ? "-" : finalCurMilistone;

            Model.LaborTicketModel lt = new Model.LaborTicketModel();
            lt.hoursworked = txtHours.Text;
            lt.overtime = (ddlOver.SelectedValue.Equals("OT")) ? "1.500" : "1.000";

            if (ddlOver.SelectedValue.Equals("OT"))
            {
                lt.description = finalWorkProd + "," + finalTask + "," + finalMilistone + "," + finalCurMilistone + "," + finalBzItem + "," + "OT" + ",&" + txtComment.Text;
            }
            else if (ddlOver.SelectedValue.Equals("BK"))
            {
                lt.description = finalWorkProd + "," + finalTask + "," + finalMilistone + "," + finalCurMilistone + "," + finalBzItem + "," + "BK" + ",&" + txtComment.Text;
            }
            else
            {
                lt.description = finalWorkProd + "," + finalTask + "," + finalMilistone + "," + finalCurMilistone + "," + finalBzItem + "," + "" + ",&" + txtComment.Text;
            }

            //adding the ticket made by the user to the list of tickets
            list.Add(lt);

            //counting the hours
            foreach (var ticket in list)
            {
                string comment = ticket.description;
                comment = ReverseString(comment);
                comment = comment.Substring(comment.IndexOf('&') + 2, 2);

                //counting all the hours
                totalHours += Decimal.Parse(ticket.hoursworked);
                
                //counting all the NO hours 
                if (ticket.overtime.Equals("1.000") && !comment.Equals("TO") && !comment.Equals("KB"))//"TO" AND "BK" because the comment string is inverted
                {
                    totalNoHours += Decimal.Parse(ticket.hoursworked);
                }
            }

            //if the total of NO tickets is less than 8, there cannot be OT or BK tickets.
            //------------
            //if the total of hours is over the max per day
            if (totalHours > maxDayHours)
            {
                alertError("This ticket could not be saved because the maximum amount of hours per day is " + maxDayHours.ToString() + ". You are trying to save " + totalHours.ToString());
                return false;
            }
            //if NO tickets are less than 8 hours then check if it contains BK or OT tickets
            else if (totalNoHours < minHours)
            {
                foreach (var ticket in list)
                {
                    string comment = ticket.description;
                    comment = ReverseString(comment);
                    comment = comment.Substring(comment.IndexOf('&') + 2, 2);

                    //checking for OT and BK tickets
                    if (comment.Equals("TO") || comment.Equals("KB"))//"TO" AND "BK" because the comment string is inverted
                    {
                        alertError("This ticket could not be saved because there are not enough NO (Normal) hours. The minimum amount of NO (Normal) hours is " + minHours.ToString() + " before you can save an OT (Overtime) or BK (Banking) ticket.");
                        return false;
                    }
                }
            }
            //checks for BK tickets
            //then checks if there are available hours for BK
            else
            {
                //gets the total of BK tickets 
                decimal totalBkHr = 0;
                try { totalBkHr = LaborDB.checkBankingHr(Request["iptDate"], d); } catch (Exception ex) { errorRedirect(ex, "Could not check BK hours. "); }
                decimal count = 0;

                //searching for BK tickets
                foreach (var ticket in list)
                {
                    string comment = ticket.description;
                    comment = ReverseString(comment);
                    comment = comment.Substring(comment.IndexOf('&') + 2, 2);

                    //counting the BK tickets hours
                    if (comment.Equals("KB"))//"KB" because the comment string is inverted
                    {
                        count += Decimal.Parse(ticket.hoursworked);
                    }
                }

                //checks if the total is over the max of BK hours
                if (count > maxBankingPerWeek)
                {
                    alertError("This ticket could not be saved because there are not enough BK (Banking) hours avaible. You have: " + (maxBankingPerWeek - totalBkHr) + " BK (Banking) hours available. You are trying to save: " + count + " hours.");
                    return false;
                }
            }

            //ok to save the ticket
            return true;
        }

        //this method checks for the requirements before updating a ticket
        //this method is basically the same as checkNewTicket() but this one only gets called when edding a ticket
        public bool checkUpdateTicket()
        {
            List<Model.LaborTicketModel> list = new List<Model.LaborTicketModel>();
            list = LaborDB.listLaborTicket(Request["iptDate"] + " 00:00:00", employee.id, d);

            decimal totalHours = 0;
            decimal totalNoHours = 0;
            string finalBzItem = tbxBz.Text;
            finalBzItem = (finalBzItem.Equals("")) ? "-" : finalBzItem;
            string finalWorkProd = ddlWp.SelectedValue.Substring(0, ddlWp.SelectedValue.IndexOf('-'));//FROM "CD-Customer Drawing" to "CD"
            finalWorkProd = (finalWorkProd.Equals("")) ? "-" : finalWorkProd;
            string finalTask = ddlTk.SelectedValue.Substring(0, ddlTk.SelectedValue.IndexOf('-'));
            finalTask = (finalTask.Equals("")) ? "-" : finalTask;
            string finalMilistone = ddlMil.SelectedValue.Substring(0, ddlMil.SelectedValue.IndexOf('-'));
            finalMilistone = (finalMilistone.Equals("")) ? "-" : finalMilistone;
            string finalCurMilistone = ddlCurMil.SelectedValue.Substring(0, ddlCurMil.SelectedValue.IndexOf('-'));
            finalCurMilistone = (finalCurMilistone.Equals("")) ? "-" : finalCurMilistone;

            foreach (var ticket in list)
            {
                if (ticket.ltnum.Equals(Request["ticketId"]))
                {
                    ticket.hoursworked = txtHours.Text;
                    ticket.overtime = (ddlOver.SelectedValue.Equals("OT")) ? "1.500" : "1.000";
                    tbxBz.Text = tbxBz.Text.Equals("") ? "-" : "B" + tbxBz.Text;
                    if (ddlOver.SelectedValue.Equals("OT"))
                    {
                        ticket.description = finalWorkProd + "," + finalTask + "," + finalMilistone + "," + finalCurMilistone + "," + tbxBz.Text + "," + "OT" + ",&" + txtComment.Text;
                    }
                    else if (ddlOver.SelectedValue.Equals("BK"))
                    {
                        ticket.description = finalWorkProd + "," + finalTask + "," + finalMilistone + "," + finalCurMilistone + "," + tbxBz.Text + "," + "BK" + ",&" + txtComment.Text;
                    }
                    else
                    {
                        ticket.description = finalWorkProd + "," + finalTask + "," + finalMilistone + "," + finalCurMilistone + "," + tbxBz.Text + "," + "" + ",&" + txtComment.Text;
                    }
                }
            }

            foreach (var ticket in list)
            {
                string comment = ticket.description;
                comment = ReverseString(comment);
                comment = comment.Substring(comment.IndexOf('&') + 2, 2);
                totalHours += Decimal.Parse(ticket.hoursworked);

                if (ticket.overtime.Equals("1.000") && !comment.Equals("TO") && !comment.Equals("KB"))
                {
                    totalNoHours += Decimal.Parse(ticket.hoursworked);
                }
            }

            //if the total of NO tickets is lesst than 8, there cannot be OT or BK tickets.
            if (totalHours > maxDayHours)
            {
                alertError("This ticket could not be saved because the maximum amount of hours per day is " + maxDayHours.ToString() + ". You are trying to save " + totalHours.ToString());
                return false;
            }
            else if (totalNoHours < minHours)
            {
                foreach (var ticket in list)
                {
                    string comment = ticket.description;
                    comment = ReverseString(comment);
                    comment = comment.Substring(comment.IndexOf('&') + 2, 2);

                    if (comment.Equals("TO") || comment.Equals("KB"))
                    {
                        alertError("This ticket could not be saved because there are not enough NO (Normal) hours. The minimum amount of NO (Normal) hours is " + minHours.ToString() + " before you can save an OT (Overtime) or BK (Banking) ticket.");
                        return false;
                    }
                }
            }
            else
            {
                decimal totalBkHr = 0;
                try { totalBkHr = LaborDB.checkBankingHr(Request["iptDate"], d); } catch (Exception ex) { errorRedirect(ex, "Could not check BK hours. "); }
                decimal count = 0;

                foreach (var ticket in list)
                {
                    string comment = ticket.description;
                    comment = ReverseString(comment);
                    comment = comment.Substring(comment.IndexOf('&') + 2, 2);

                    if (comment.Equals("KB"))
                    {
                        count += Decimal.Parse(ticket.hoursworked);
                    }
                }

                if (count > maxBankingPerWeek)
                {
                    alertError("This ticket could not be saved because there are not enough BK (Banking) hours avaible. You have: " + (maxBankingPerWeek - totalBkHr) + " BK (Banking) hours available. You are trying to save: " + count + " hours.");
                    return false;
                }
            }
            return true;
        }

        //called when reset button is clicked
        protected void btnReset_Click(object sender, EventArgs e)
        {
            Response.Redirect(Request.RawUrl);
            tk = LaborDB.listLaborTicket(Request["iptDate"] + " 00:00:00", employee.id, d);
            loadTickets();
        }

        //delete method from delete button
        protected void btnDelete_Click(object sender, EventArgs e)
        {
            //getting the ticket id
            string finalTicketId = Request["ticketId"];

            //deleting the ticket
            try { LaborDB.deleteTicket(Int32.Parse(finalTicketId), d); } catch (Exception ex) { errorRedirect(ex, "Could not delete the ticket. "); }

            //cleaning fields
            clearFields();
            alertSucess("Ticket deleted!");
        }

        //checks for updates made by the employee on the bug
        public void checkBugUpdates()
        {
            //gets the number of the indirect prodject. Eg.: 10012-VACATION to 10012
            string indId = ddlInd.SelectedValue.Substring(0, ddlInd.SelectedValue.IndexOf('-'));

            //checks if the indirect is one of the excpetions. If yes we do not show the warning message.
            if (!indId.Equals("10011") && !indId.Equals("10012") && !indId.Equals("10013") && !indId.Equals("10016") && !indId.Equals("10017") && BugzillaDB.checkCfItemType(tbxBz.Text))
            {
                //getting the employee id
                string id = "";
                try { id = BugzillaDB.getEmployeeId(HttpContext.Current.Request.LogonUserIdentity.Name.Substring(7)); } catch (Exception ex) { errorRedirect(ex, "Could not get the employee id. "); }

                try
                {
                    //checking for modfications in the bug
                    DateTime finalDate = DateTime.ParseExact(Request["iptDate"], "yyyy-MM-dd", CultureInfo.InvariantCulture);//getting Date selected by the user
                    if (!BugzillaDB.checkBugModifications(tbxBz.Text, id, finalDate))
                    {
                        alertError("<strong>WARNING:</strong> You did not update this bug between " + finalDate.AddDays(-1).ToLongDateString() + " and " + finalDate.AddDays(+1).ToLongDateString() + ". Please add a comment on the item indicating the current status of this task and update the hours left field, if applicable.");
                    }
                }
                catch (Exception ex)
                {
                    errorRedirect(ex, "Could not check for updates on the bug. ");
                }   
            }
        }

        //checks if the bugzilla item is indirect
        //this is needed because in some ocasions dplWoPo is not going to be empty but it will be an indirect bug
        public bool checkInd()
        {
            if (!dplWoPo.Text.Equals("//"))
            {
                string wopo = "";
                try { wopo = dplWoPo.Text.Substring(0, dplWoPo.Text.IndexOf('-')); } catch { return false; }

                //checks if the dlpWoPo matches a value in ddlInd
                foreach (ListItem li in ddlInd.Items)
                {
                    if (li.Value.Substring(0, li.Value.IndexOf('-')) == wopo)
                    {
                        //it is indirect
                        return true;
                    }
                }
            }
            
            //not an indirect
            return false;
        }

        //load the holidays table
        public void getHolidays()
        {
            //loading holidays to the list
            List<Model.HolidayModel> hlist = new List<Model.HolidayModel>();
            try { hlist = BachEngDB.getHolidayList(); } catch (Exception ex) { alertError("Could not load holiday list. Error details: " + ex.Message.ToString()); }

            //check if there are records
            if (hlist.Count > 0)
            {
                foreach (var item in hlist)
                {
                    TableRow row = new TableRow();
                    TableCell cell1 = new TableCell();
                    TableCell cell2 = new TableCell();
                    TableCell cell3 = new TableCell();
                    cell1.Text = item.date.Substring(0, item.date.IndexOf(' '));
                    cell2.Text = item.day;
                    cell3.Text = item.description;
                    row.Cells.Add(cell1);
                    row.Cells.Add(cell2);
                    row.Cells.Add(cell3);
                    tblHolidays.Rows.Add(row);
                }
            }
            //no holidays found in the database
            else
            {
                TableRow row = new TableRow();
                TableCell cell1 = new TableCell();
                cell1.Text = "No dates found.";
                row.Cells.Add(cell1);
                tblHolidays.Rows.Add(row);
            }
        }

        //cleaning the fields
        public void clearFields()
        {
            tbxBz.Text = "";
            dplWoPo.Text = "";
            ddlLeg.Items.Clear();
            ddlOpn.Items.Clear();
            txtHours.Text = "";
            txtComment.Text = "";
            ddlWp.SelectedIndex = 0;
            ddlTk.SelectedIndex = 0;
            ddlMil.SelectedIndex = 0;
            ddlCurMil.SelectedIndex = 0;
            divbuginfo.Style.Add("Display", "none");
            lblProductName.Text = "";
            lblProductDesc.Text = "";
            ddlInd.Enabled = true;
            ddlInd.SelectedValue = "-";
            loadTicketsInput(Request["iptDate"]);
            progressdiv.Style.Add("Visibility", "hidden");
            tbxBz.Attributes.Remove("readonly");
            btnCheck.Text = "Check";
            dplWoPo.Enabled = false;
        }

        //check description size
        public bool checkDescLength()
        {
            string finalWorkProd = ddlWp.SelectedValue.Substring(0, ddlWp.SelectedValue.IndexOf('-'));
            finalWorkProd = (finalWorkProd.Equals("")) ? "-" : finalWorkProd;
            string finalTask = ddlTk.SelectedValue.Substring(0, ddlTk.SelectedValue.IndexOf('-'));
            finalTask = (finalTask.Equals("")) ? "-" : finalTask;
            string finalMilistone = ddlMil.SelectedValue.Substring(0, ddlMil.SelectedValue.IndexOf('-'));
            finalMilistone = (finalMilistone.Equals("")) ? "-" : finalMilistone;
            string finalCurMilistone = ddlCurMil.SelectedValue.Substring(0, ddlCurMil.SelectedValue.IndexOf('-'));
            finalCurMilistone = (finalCurMilistone.Equals("")) ? "-" : finalCurMilistone;

            string bzItem = tbxBz.Text;
            bzItem = bzItem.Equals("") ? "-" : "B" + bzItem;
            string finalComment = "";
            if (ddlOver.SelectedValue.Equals("OT"))
            {
                finalComment = finalWorkProd + "," + finalTask + "," + finalMilistone + "," + finalCurMilistone + "," + bzItem + "," + "OT" + ",&" + txtComment.Text;
            }
            else if (ddlOver.SelectedValue.Equals("BK"))
            {
                finalComment = finalWorkProd + "," + finalTask + "," + finalMilistone + "," + finalCurMilistone + "," + bzItem + "," + "BK" + ",&" + txtComment.Text;
            }
            else
            {
                finalComment = finalWorkProd + "," + finalTask + "," + finalMilistone + "," + finalCurMilistone + "," + bzItem + "," + "" + ",&" + txtComment.Text;
            }

            if(finalComment.Length > 80)
            {
                alertError("Your comment is " + (finalComment.Length - 80) + " characters too long.");
                return false;
            }
            else
            {
                return true;
            }
        }

        //handling the exceptions
        public void errorRedirect(Exception e, string msg)
        {
            Server.Transfer("ErrorPage.aspx?handler=" + msg + " " + e.Message + " METHOD: " + e.TargetSite);
        }

        public string ReverseString(string srtVarable)
        {
            return new string(srtVarable.Reverse().ToArray());
        }

        //sucess notification
        public void alertSucess(string message)
        {
            ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "Script", "alertify.success('" + message + "')", true);
        }

        //error notification
        public void alertError(string message)
        {
            ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "Script", "alertify.alert('" + message + "')", true);
        }

        //checks the browser before loading the page
        //right now only chrome is allowed
        public void checkBrowser()
        {
            if (!Request.Browser.Type.ToLower().Contains("chrome"))
            {
                Exception ex = new Exception();
                errorRedirect(ex, "Google Chrome is the only browser supported in the moment.");
            }
            else if (Request.UserAgent.ToLower().Contains("edge"))
            {
                Exception ex = new Exception();
                errorRedirect(ex, "Google Chrome is the only browser supported in the moment.");
            }
        }
    }
}