# 目录

- [Web3 示例项目](#web3-示例项目)
  - [在线预览](#在线预览)
  - [社区交流](#社区交流)
  - [VPN 推荐](#VPN-推荐)
  - [环境准备](#环境准备)
  - [本地运行](#本地运行)
    - [前端](#前端)
    - [智能合约](#智能合约)
- [学习资源](#学习资源)
  - [DApp & Solidity 智能合约学习资源](#dapp--solidity-智能合约学习资源)
  - [其他综合学习资源](#其他综合学习资源)
  - [区块链相关学习资源](#区块链相关学习资源)
  - [白皮书](#白皮书)
  - [官方文档](#官方文档)
  - [书籍](#书籍)
  - [铭文协议](#铭文协议)
- [招聘平台](#招聘平台)
  - [中文区](#中文区)
  - [英文区](#英文区)
- [撸毛](#撸毛)
  - [测试网水龙头](#测试网水龙头)
  - [指纹浏览器与 IP 代理推荐](#指纹浏览器与-IP-代理推荐)
  - [寻找项目-资讯媒体平台](#寻找项目-资讯媒体平台)
  - [寻找项目-空投信息网站](#寻找项目-空投信息网站)
  - [项目调研-专业网站](#项目调研-专业网站)
  - [项目调研-价值与安全](#项目调研-价值与安全)
- [脚本](#脚本)
  - [particle-network](#particle-network)
- [交易所注册手续费减免](#交易所注册手续费减免)
  - [币安 Binance](#币安-Binance)
  - [芝麻 Gate](#芝麻-Gate)
  - [欧易 OKX](#欧易-OKX)
  - [Bitget](#Bitget)
  - [火币 HTX](#火币-HTX)
  - [深币 DeepCoin](#深币-Deepcoin)

## Web3 示例项目

本仓库包含了一系列涵盖前端、智能合约和后端的 Web3 示例代码，旨在帮助开发者快速学习和应用到实际项目中。我们提供了多种常用场景的示例代码。

### 在线预览

预览地址：[https://examples.web3doc.xyz](https://examples.web3doc.xyz/)

### 社区交流

如果你对 Web3 感兴趣，想从事 Web3 开发或探讨相关话题，请加入 Noah 的人人都会 Web 社区: https://t.me/everyonesweb3

或者添加 Noah 的微信：`LZQ20130415`。

### VPN-推荐

以下是几个可靠的科学上网工具推荐：

- <https://www.taozijichang.xyz/#/register?code=nBCHS0pq>：性价比最高，很稳定，非常推荐。可以配合 SSR、Clash、Shadowrocket、V2Ray 等客户端使用。5 元优惠码：`HlX3Ygdu`；10 元优惠码：`yIqSm0jL`。
- <https://share.jsq888.com/raf?u=89716999>：性价比高，速度可以，比较稳定。一个账号支持 5 个设备。使用邀请码 89716999 可以获得优惠。
- <https://bitbucket.org/letsgo666/letsgo_en_1/src/main/README.md>：价格较高，一个账号支持 2 个设备。体验较好。使用邀请码 61922063 可以获得免费试用时长。

请注意，以上工具仅供学习使用。若利用这些工具从事违法犯罪行为，我们概不承担任何法律责任。

### 环境准备

由于部分服务可能需要翻墙访问，或依赖于需要翻墙的服务（如 Google 验证码），建议确保你的网络环境可以科学上网。

## 本地运行

### 前端

前端代码位于 `frontend` 目录下。在运行之前，请确保完成以下准备工作：

1. 将 `.env.example` 文件重命名为 `.env`，并补充完整配置信息。
2. 至少在 [alchemy](https://www.alchemy.com/) 上申请一个 API Key。

接下来，安装依赖并启动项目：

```bash
npm i
npm run dev
```

### 智能合约

智能合约代码位于 `contract` 目录下。在运行之前，请确保完成以下准备工作：

1. 将 `.env.example` 文件重命名为 `.env`，并补充完整配置信息。
2. 至少在 [infura](https://www.infura.io/) 上申请一个 Project Key。

然后，你可以使用 `truffle` 进行智能合约开发。

## TMA 训练营

Noah 近期上线了 Telegram Mini Apps 全栈训练营。如果你对 TMA 开发感兴趣，欢迎加入我们的训练营。报名费：299 元，报名方式：添加 Noah 的微信 `LZQ20130415`。

以下是 TMA 训练营的课程大纲：

![TMA 训练营](./assets/tma.jpg)

## 学习资源

为了帮助你更好的学习，我们整理了一份学习资源列表。如果你有新的资源推荐或发现列表中的资源已过时或质量不佳，请通过 issue 通知我们更新。

### DApp & Solidity 智能合约学习资源

- [CryptoZombies](https://cryptozombies.io/) - 通过游戏形式学习 Solidity，非常适合初学者。
- [CryptoZombies 中文课程](https://cryptozombies.io/zh/course/) - 加密僵尸游戏的中文课程。
- [Ethernaut by OpenZeppelin](https://ethernaut.openzeppelin.com/) - OpenZeppelin 推出的动手学习 Solidity 的平台。
- [Chainshot](https://www.chainshot.com/) - 通过动手实践学习智能合约开发。
- [FreeCodeCamp Solidity Tutorial](https://www.youtube.com/watch?v=M576WGiDBdQ) - FreeCodeCamp 的 Solidity 教程视频。
- [Ethereum 官方教程](https://ethereum.org/en/developers/tutorials/) - 以太坊官方提供的开发教程。
- [Ethereum 文档](https://ethereum.org/en/developers/docs/) - 以太坊官方开发文档。
- [Ethereum DApps 展示](https://ethereum.org/en/dapps/) - 以太坊官方的 DApp 展示页面。
- [WTF Academy](https://wtf.academy/) - 从 Solidity 基础到进阶的课程。
- [LearnWeb3.io](https://learnweb3.io/) - Web3 学习网站。
- [Pointer](https://www.pointer.gg/) - 同样是 Web3 学习网站。

### 其他综合学习资源

- [Continuum](https://continuum.xyz/) - 通过学习 Web3 基础获得 NFT 奖励的学习平台。
- [Dapp University](https://www.dappuniversity.com/) - 专注于 DApp 开发的系列教学视频。
- [Web3 University](https://www.web3.university/find) - 内容全面的 Web3 在线学习平台。
- [Hashnode Web3 Channel](https://web3.hashnode.com/) - Hashnode 的 Web3 专栏。
- [Mirror Developer Platform](https://dev.mirror.xyz/) - Mirror 上集合了众多优秀的 Web3 开发者的文章。
- [Ethereum Stack Exchange](https://ethereum.stackexchange.com/) - 官方的 Ethereum Q&A 社区。
- [EthResearch](https://ethresear.ch/) - Ethereum 技术论坛。
- [OpenSea Blog](https://opensea.io/blog) - OpenSea 的官方博客。
- [Reddit Web3](https://www.reddit.com/r/web3/) - Reddit 上的 Web3 频道。
- [Medium Web3 Topics](https://medium.com/tag/web3) - Medium 上关于 Web3 的讨论。

### 区块链相关学习资源

- [Coursera Blockchain Basics](https://www.coursera.org/learn/blockchain-basics) - Coursera 上的区块链基础课程。
- [Conflux 中文区块链论坛](https://forum.conflux.fun/c/Chinese) - Conflux 论坛的中文区。
- [Microsoft Blockchain Development Introduction](https://learn.microsoft.com/zh-cn/training/paths/ethereum-blockchain-development/) - 微软提供的区块链开发入门课程。
- [MIT Blockchain Course](https://ocw.mit.edu/courses/15-s12-blockchain-and-money-fall-2018/video_galleries/video-lectures/) - MIT 提供的关于区块链的课程。

### 白皮书

以下是几个重要项目的白皮书链接：

- [比特币白皮书](https://bitcoin.org/bitcoin.pdf)
- [以太坊白皮书](https://ethereum.org/en/whitepaper/)
- [Uniswap V2 白皮书](https://uniswap.org/whitepaper.pdf)
- [Uniswap V3 白皮书](https://uniswap.org/whitepaper-v3.pdf)

### 官方文档

以下是一些常用工具和库的官方文档链接：

- [Solidity 官方文档](https://docs.soliditylang.org/en/) - 智能合约编程语言。
- [OpenZeppelin](https://www.openzeppelin.com/) - Solidity 安全开发工具库。
- [Remix IDE 官方文档](https://remix.run/docs/en/v1) - Solidity 开发的在线 IDE。
- [Hardhat](https://hardhat.org/) - 用于智能合约开发的环境框架。
- [Truffle Suite](https://trufflesuite.com/) - 包含 Truffle、Ganache 和 Drizzle 的智能合约开发环境。
- [Ethers.js 官方文档](https://docs.ethers.org/) - 用于与智能合约交互的库。
- [Web3.js 官方文档](https://web3js.readthedocs.io/en/) - 另一种用于智能合约交互的库。
- [Viem](https://viem.sh/) - 最新的智能合约交库。
- [Wagmi](https://wagmi.sh/) - 提供 React Hooks 风格 API 的智能合约交互库。
- [RainbowKit](https://www.rainbowkit.com/zh-CN/docs/introduction) - 用于构建 Web3 钱包连接界面的库，支持 React。

### 书籍

以下是一些推荐的区块链和 Web3 相关书籍：

- [精通比特币](https://github.com/tianmingyun/MasterBitcoin2CN) - 对比特币深入讲解的书籍。
- [精通以太坊](https://github.com/inoutcode/ethereum_book) - 以太坊技术深入分析的书籍。
- [How to Defi](https://nigdaemon.gitbook.io/how-to-defi-advanced-zhogn-wen-b) - DeFi 技术深入分析的书籍。

### 铭文协议

- [Ordinals 协议](https://docs.ordinals.com/) - BRC20 背后的铭文协议。
- [Atomicals 协议](https://docs.atomicals.xyz) - ARC20 背后的铭文协议。

## 招聘平台

### 中文区

- [ABetterWeb3](https://abetterweb3.notion.site/abetterweb3/daa095830b624e96af46de63fb9771b9)

- [Foresight news](https://foresightnews.pro/job)

- [电鸭社区](https://eleduck.com/search?keyword=web3)

- [TinTin Job Board](https://attractive-spade-1e3.notion.site/37f6da2316a845fba6ff6f62f3c50289?v=e88aaffca0ee462db5e9daa53946059f)

- [Rebase who is hiring](https://github.com/rebase-network/who-is-hiring/issues)

- [BOSS 直聘](https://www.zhipin.com/shanghai/)

- [Block Job](https://twitter.com/blockjob2022)

### 英文区

- [upwork](https://www.upwork.com/)

- [Remote3](https://remote3.co/)

- [Web3 career](https://web3.career/)

- [CryptocurrencyJobs](https://cryptocurrencyjobs.co/)

- [Wellfound](https://wellfound.com/)

- [Crypto Recruit](https://www.cryptorecruit.com/)

- [Works Hub](https://blockchain.works-hub.com/)

- [Crypto job list](https://cryptojobslist.com/)

- [Dejob](https://www.dejob.top/)

- [Crypto Jobs](https://crypto.jobs/)

- [stablegram](https://stablegram.com/)

- [Froog](https://froog.co/)

- [RemoteOK](https://remoteok.com/)

## 撸毛

现在我们成立了 bc1 社区，请访问 [bc1.wiki](https://bc1.wiki/bc1) 了解并加入我们。

### 测试网水龙头

- <https://sepolia-faucet.pk910.de/> - 挖矿

- <https://www.alchemy.com/faucets/ethereum-sepolia> - Alchemy 的 Ethereum 水龙头

- <https://www.infura.io/faucet/sepolia> - Infura 的 Ethereum 水龙头

- <https://faucet.quicknode.com/ethereum/sepolia/> - QuickNode 的 Ethereum 水龙头

- <https://faucet.polygon.technology/> - Polygon

- <https://www.bsquared.network/faucet/> - B2 Network

- <https://www.bnbchain.org/en/testnet-faucet> - Binance Smart Chain

### 指纹浏览器与-IP-代理推荐

MoreLogin。

[https://www.morelogin.com/?from=AA3jnj3sJxy4](https://www.morelogin.com/?from=AA3jnj3sJxy4)

clonbrowser 支持多开，自带窗口同步器，IP 绑定简单方便。

[https://www.clonbrowser.net/?code=SSXf6Z](https://www.clonbrowser.net/?code=SSXf6Z)

### 寻找项目-资讯媒体平台

- [Foresight News](https://foresightnews.pro/)
- [币安新闻](https://www.binance.com/zh-CN/square/news/all)
- [Gate 深度](https://www.gate.io/zh/post?type=depth)
- [陀螺科技](https://www.tuoluo.cn/kuaixun/)
- [MarsBit 7x24H 快讯](https://news.marsbit.co/flash)
- [Odaily 快讯](https://www.odaily.news/newsflash)
- [律动快讯](https://www.theblockbeats.info/newsflash)
- [PANews 快讯&深度](https://www.panewslab.com/zh/news/index.html)
- [Chain Catcher 快讯](https://www.chaincatcher.com/news)
- [TechFlow 7x24H 快讯](https://www.techflowpost.com/newsletter/index.html)

### 寻找项目-空投信息网站

- <https://airdrops.io/>
- <https://dropsearn.com/airdrops/>
- <https://www.cosmosairdrops.io/claimable>
- <https://www.alphadrops.net/alpha>
- <https://galxe.com/>

### 项目调研-专业网站

- <https://coinmarketcap.com/> 最大的行情网站。
- <https://www.coingecko.com/> 也是一个非常大的行情网站。
- <https://www.rootdata.com/> 可以查询项目的投资情况。
- <https://geniidata.com/> 分析市场趋势的网站，特别是 Ordinals 和 BRC20 生态。
- <https://www.coincarp.com/zh/> 也是一个大型的行情网站。
- <https://defillama.com/> 可以查询 DeFi 协议的链上数据。
- <https://dune.com/home> 链上数据分析和数据可视化网站，可以查询链上数据。

### 项目调研-价值与安全

- <https://app.whales.market/?r=256788> 鲸鱼市场，可以查询和交易未上市代币、积分的场外交易价格。
- <https://gopluslabs.io/token-security> GoPlus，可以查询代币的安全性，有效避免貔貅盘。
- <https://www.oklink.com/zh-hans/approval> OKX 钱包授权检测。

## 脚本

### particle-network

- [particle-network](./script/particle-network)

## 交易所注册手续费减免

### 币安-Binance

币安 Binance 邀请码：`DYE5M7LZ`。币安官网：[https://www.binance.info/zh-CN/join?ref=DYE5M7LZ](https://www.binance.info/zh-CN/join?ref=DYE5M7LZ)

已开通币安联盟合作伙伴，现货合约均可享受最高等级 20% 返佣。

### 芝麻-Gate

芝麻 Gate 邀请码：`AlBNUAhe` 或 `BITCNOAH`。Gate 官网：[https://www.gate.io/signup/AlBNUAhe?ref_type=103](https://www.gate.io/signup/AlBNUAhe?ref_type=103)

已开通 Gate 最高级别合伙人，现货合约均可享受最高等级 20% 返佣。

### 欧易-OKX

欧易 OKX 邀请码：`NOAH666`。OKX 官网：[https://www.yyjiagou.com/join/noah666](https://www.yyjiagou.com/join/noah666)

已开通 OKX 节点，现货合约均可享受最高等级 20% 返佣。

### Bitget

Bitget 邀请码：`bc1666`。Bitget 官网：[https://partner.bitget.fit/bg/bc1666](https://partner.bitget.fit/bg/bc1666)

已开通 Bitget 1 级合伙人，现货合约均可享受最高等级 20% 返佣。

### 火币-HTX

火币 HTX 邀请码：`s2r99223`。火币官网：[https://www.htx.co.zw/invite/zh-cn/1h?invite_code=s2r99223](https://www.htx.co.zw/invite/zh-cn/1h?invite_code=s2r99223)

已开通火币合伙人，现货合约均可享受最高等级 30% 返佣。

### 深币-DeepCoin

深币 DeepCoin 邀请码：`S510498`。DeepCoin 官网：[https://s.deepcoin.com/sfbaeji](https://s.deepcoin.com/sfbaeji)

已开通 DeepCoin 高级合伙人，现货合约均可享受最高等级 30% 返佣。

## U 卡

如果你想使用加密货币进行消费。推荐使用 PokePay，Noah 已开通 KOL 专属邀请链接，注册就送 12.8 USDT 开卡抵扣券：

<https://app.pokepay.cc/pages/passport/invitation?r=162465>
