# Getting started

## Installation 

To install the NeoPHP framework we have to **run the following command (Composer required)**, assuming we want to start a new project named "MyApp":
```
composer create-project neogroup/neophp-project MyApp
```
This command will create an empty NeoPHP project. The structure of the created proyect will be as follows ...

```
MyApp                             Base application path
├─ config                         Directory where all config files are located
│  ├─ app.php                     General application configuration file
│  ├─ database.php                Database configuration file
│  ├─ logging.php                 Logging configuration file
│  ├─ resources.php               Resources configuration file
│  ├─ views.php                   Views configuration file
│  └─ models.php                  Models configuration file
├─ public                         Directory for all public resources (css, js, assets, etc)
│  ├─ bower_components            Directory for all bower components
│  ├─ components                  Directory for components (resources that have css, js, imges, etc)
│  ├─ css                         Directory for style sheet files
│  ├─ img                         Directory for images
│  ├─ js                          Directory for javascript files
│  ├─ .htaccess                   File that handles the site requests and redirect them to index.php
│  ├─ favicon.ico                 Icon the the application
│  ├─ index.php                   Starting main point for the application
│  └─ robots.txt                  Bot detector configuration file
├─ resources                      Directory for all the application resources
│  ├─ messages                    Base directory for translation bundles
│  └─ views                       Base directory for views (templates basically)
├─ src                            Base directory for source files (php classes)
├─ storage                        Base directory for all generated files
│  ├─ framework                   Directory for files that are generated by the framework
│  └─ logs                        Directory for the application logs
├─ vendor                         Base directory for composer packages
├─ .bowerrc                       Bower configuration file
├─ .gitignore                     Git ignrations file
├─ bower.json                     Bower json file for web requirements
├─ composer.json                  Composer json file for PHP requirements
├─ composer.lock                  Composer file the indicates the installed PHP dependencies
├─ LICENSE.md                     License file
└─ README.md                      Readme file
```

## Configuration

Some configuration is needed for NeoPHP to work property. First we have to **add write permissions to the folder "storage"** (this is the place where logs and compiled views are stored). In linux system you can run the following commands
```
cd MyApp
chmod 777 -R storage/
```
The next and final step is to configure the **public** directory. You should **configure your web server's document / web root to be the public directory**. The index.php in this directory serves as the front controller for all HTTP requests entering your application.
