//
// Copyright (c) Microsoft. All rights reserved.
// See https://aka.ms/csspeech/license for the full license information.
//
// speechapi_c_common.h: Public API declarations for global C definitions and typedefs
//

#pragma once

#include <spxdebug.h>
#include <azac_api_c_common.h> // must include after spxdebug.h or speechapi*.h (can NOT be included before)
#include <stdbool.h>
#include <spxerror.h>

#define SPX_EXTERN_C        AZAC_EXTERN_C
#ifndef SPXAPI_EXPORT
#define SPXAPI_EXPORT       AZAC_API_EXPORT
#endif

#define SPXAPI_NOTHROW      AZAC_API_NOTHROW
#define SPXAPI_RESULTTYPE   SPXHR
#define SPXAPI_CALLTYPE     AZAC_API_CALLTYPE
#define SPXAPI_VCALLTYPE    AZAC_VCALLTYPE

#define SPXDLL_EXPORT       AZAC_DLL_EXPORT

#define SPXAPI              SPX_EXTERN_C SPXAPI_EXPORT SPXAPI_RESULTTYPE SPXAPI_NOTHROW SPXAPI_CALLTYPE
#define SPXAPI_(type)       SPX_EXTERN_C SPXAPI_EXPORT type SPXAPI_NOTHROW SPXAPI_CALLTYPE
#define SPXAPI__(type)      SPX_EXTERN_C SPXAPI_EXPORT SPXAPI_NOTHROW type SPXAPI_CALLTYPE

#define SPXAPIV             SPX_EXTERN_C SPXAPI_EXPORT SPXAPI_NOTHROW SPXAPI_RESULTTYPE SPXAPI_VCALLTYPE
#define SPXAPIV_(type)      SPX_EXTERN_C SPXAPI_EXPORT SPXAPI_NOTHROW type SPXAPI_VCALLTYPE

#define SPXAPI_PRIVATE          SPX_EXTERN_C SPXAPI_RESULTTYPE SPXAPI_NOTHROW SPXAPI_CALLTYPE
#define SPXAPI_PRIVATE_(type)   SPX_EXTERN_C type SPXAPI_NOTHROW SPXAPI_CALLTYPE

#define _spx_empty      _azac_empty
#define _spxhandle      _azac_handle
#define SPXHANDLE       AZAC_HANDLE
#define SPXERRORHANDLE  AZAC_HANDLE

#define SPXPROPERTYBAGHANDLE AZAC_HANDLE
typedef SPXHANDLE SPXASYNCHANDLE;
typedef SPXHANDLE SPXFACTORYHANDLE;
typedef SPXHANDLE SPXRECOHANDLE;
typedef SPXHANDLE SPXSYNTHHANDLE;
typedef SPXHANDLE SPXRESULTHANDLE;
typedef SPXHANDLE SPXEVENTHANDLE;
typedef SPXHANDLE SPXSESSIONHANDLE;
typedef SPXHANDLE SPXTRIGGERHANDLE;
typedef SPXHANDLE SPXLUMODELHANDLE;
typedef SPXHANDLE SPXKEYWORDHANDLE;
typedef SPXHANDLE SPXAUDIOSTREAMFORMATHANDLE;
typedef SPXHANDLE SPXAUDIOSTREAMHANDLE;
typedef SPXHANDLE SPXAUDIOCONFIGHANDLE;
typedef SPXHANDLE SPXSPEECHCONFIGHANDLE;
typedef SPXHANDLE SPXCONNECTIONHANDLE;
typedef SPXHANDLE SPXCONNECTIONMESSAGEHANDLE;
typedef SPXHANDLE SPXACTIVITYHANDLE;
typedef SPXHANDLE SPXACTIVITYJSONHANDLE;
typedef SPXHANDLE SPXGRAMMARHANDLE;
typedef SPXHANDLE SPXPHRASEHANDLE;
typedef SPXHANDLE SPXUSERHANDLE;
typedef SPXHANDLE SPXPARTICIPANTHANDLE;
typedef SPXHANDLE SPXAUTODETECTSOURCELANGCONFIGHANDLE;
typedef SPXHANDLE SPXSOURCELANGCONFIGHANDLE;
typedef SPXHANDLE SPXCONVERSATIONHANDLE;
typedef SPXHANDLE SPXMEETINGHANDLE;
typedef SPXHANDLE SPXCONVERSATIONTRANSLATORHANDLE;
typedef SPXHANDLE SPXVOICEPROFILECLIENTHANDLE;
typedef SPXHANDLE SPXVOICEPROFILEHANDLE;
typedef SPXHANDLE SPXSPEAKERIDHANDLE;
typedef SPXHANDLE SPXSIMODELHANDLE;
typedef SPXHANDLE SPXSVMODELHANDLE;
typedef SPXHANDLE SPXPRONUNCIATIONASSESSMENTCONFIGHANDLE;
typedef SPXHANDLE SPXAUDIOPROCESSINGOPTIONSHANDLE;
typedef SPXHANDLE SPXSPEECHRECOMODELHANDLE;
typedef SPXHANDLE SPXREQUESTHANDLE;

#define SPXHANDLE_INVALID   ((SPXHANDLE)-1)
#define SPXHANDLE_RESERVED1 ((SPXHANDLE)+1)
