### Changes in 1.3.0

- Fixed: re-compilation time not resetting. [#1894](https://github.com/luckyframework/lucky/pull/1894)
- Fixed: missing `--with-page` flag in `gen.action.browser` task help text. [#1895](https://github.com/luckyframework/lucky/pull/1895)
- Refactor: lucky routes to pull from the router instead of holding a second array in memory. [#1898](https://github.com/luckyframework/lucky/pull/1898)
- Updated: error message when booting Lucky and the watcher config is missing. [#1896](https://github.com/luckyframework/lucky/pull/1896)
- Fixed: compatibility with Crystal 1.13.x and later. [#1900](https://github.com/luckyframework/lucky/pull/1900)
- Fixed: invalid query string for array params. [#1908](https://github.com/luckyframework/lucky/pull/1908)
- Refactor: make `form_method` public. [#1915](https://github.com/luckyframework/lucky/pull/1915)
- Added: new `MaximumRequestSizeHandler`. [#1916](https://github.com/luckyframework/lucky/pull/1916)
- Fixed: deprecation warning for Crystal 1.13. [#1918](https://github.com/luckyframework/lucky/pull/1918)
- Fixed: compilation error with updated ExceptionPage. [#1910](https://github.com/luckyframework/lucky/pull/1910)
- Updated: to latest ExceptionPage. [#1921](https://github.com/luckyframework/lucky/pull/1921)
- Added: support for Windows with the core `Lucky` shard. [#1919](https://github.com/luckyframework/lucky/pull/1919)
- Refactor: all built-in tasks are no longer precompiled. [#1919](https://github.com/luckyframework/lucky/pull/1919)
- Updated: url link to PostCSS in generated webpack.mix. [65f2d3df in LuckyCLI](https://github.com/luckyframework/lucky_cli/commit/65f2d3dfd0c572ba8a8015c36499ca2f61c742a8)
- Added: ability to run uncompiled tasks from Crystal files. [#871 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/871)
- Refactor: generated page templates with clear args. [#935 in Avram](https://github.com/luckyframework/avram/pull/935)
- Fixed: issue with type casting on `select_min/max`. [#1040 in Avram](https://github.com/luckyframework/avram/pull/1040)
- Added: `have_any` criteria method for array queries. [#1042 in Avram](https://github.com/luckyframework/avram/pull/1042)
- Added: `if_exists` option to DROP TABLE queries. [#1043 in Avram](https://github.com/luckyframework/avram/pull/1043)
- Added: support for camel case or snake case on `gen.migration` task. [#1046 in Avram](https://github.com/luckyframework/avram/pull/1046)
- Added: array param options for raw where query values. [#1044 in Avram](https://github.com/luckyframework/avram/pull/1044)
- Updated: error message when there's issues connecting to your DB. [#1047 in Avram](https://github.com/luckyframework/avram/pull/1047)
- Updated: DeleteOperations to run in a transaction. [#1055 in Avram](https://github.com/luckyframework/avram/pull/1055)
- Added: `have_error` expectation for specs with SaveOperations. [#1062 in Avram](https://github.com/luckyframework/avram/pull/1062)
- Refactor: use `postgres` as the default database for `db.create` and `db.drop` tasks. [#1058 in Avram](https://github.com/luckyframework/avram/pull/1058)
- Refactor: all calls to tables and column names are now quoted in constructed SQL queries. Allows for defining columns that may conflict with reserved SQL words. [#1059 in Avram](https://github.com/luckyframework/avram/pull/1059)
- Added: `validate_url_format` for operation validations. [#1065 in Avram](https://github.com/luckyframework/avram/pull/1065)
- Refactor: built-in db related tasks are no longer precompiled. [#1069 in Avram](https://github.com/luckyframework/avram/pull/1069)
- Refacor: built-in `gen.email` task is no longer precompiled. [#95 in Carbon](https://github.com/luckyframework/carbon/pull/95)



### Changes in 1.2.0 (2024-04-21)

- Updated: exception page which includes syntax highlighting now. [#1850](https://github.com/luckyframework/lucky/pull/1850)
- Refactor: Action call body with a clear compile error and ability to do short-circuit returns. [#1857](https://github.com/luckyframework/lucky/pull/1857)
- Added: new `-n` flag to `lucky gen.secret_key` to configure key size. [#1856](https://github.com/luckyframework/lucky/pull/1856)
- Refactor: routes with query params optimization. [#1854](https://github.com/luckyframework/lucky/pull/1854)
- Deprecated: Lucky now prefers Crystal 1.10 or later
- Added: overload to `distance_of_time_in_words` that takes a `Time::Span`. [#1860](https://github.com/luckyframework/lucky/pull/1860)
- Added: compilation time to terminal output during development. [#1855](https://github.com/luckyframework/lucky/pull/1855)
- Refactor: lucky gen tasks are now using [LuckyTemplate](https://github.com/luckyframework/lucky_template) for Windows compatibility. [#1861](https://github.com/luckyframework/lucky/pull/1861)
- Added: `Date` header to response output. [#1866](https://github.com/luckyframework/lucky/pull/1866)
- Added: LuckyCLI releases now include binary packages in the release since v1.1.1
- Fixed: entering `Y` or `y` in LuckyCLI Wizard. [#857 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/857)
- Updated: Generated Github Actions CI file with latest actions versions. Nexploit NPM is no longer required for SecTester. [#859 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/859)
- Added: new Scoop package installer for installing LuckyCLI on Windows. [Scoop it up](https://github.com/luckyframework/scoop-bucket)
- Fixed: a few compatibility issues with CockroachDB. [#980 in Avram](https://github.com/luckyframework/avram/pull/980)
- Added: `attrs` override for boolean attributes on `select_input` and `multi_select_input`. [#981 in Avram](https://github.com/luckyframework/avram/pull/981)
- Updated: DB connections now support a retry. [#990 in Avram](https://github.com/luckyframework/avram/pull/990)
- Updated: `select_input` and `multi_select_input` to include the `id` attribute. [#992 in Avram](https://github.com/luckyframework/avram/pull/992)
- Added: `if_not_exists` and `if_exists` options to migration `create` and `alter` macros. [#993 in Avram](https://github.com/luckyframework/avram/pull/993)
- Added: block overload for `preload` `has_one` methods. [#994 in Avram](https://github.com/luckyframework/avram/pull/994)
- Fixed: how the `verify_connection` task runs to catch some edge cases of it not working. [#995 in Avram](https://github.com/luckyframework/avram/pull/995)
- Updated: migrator commands no longer use `Process.run` with the `shell` option. [#997 in Avram](https://github.com/luckyframework/avram/pull/997)
- **Breaking change** Refactor: all Avram models now use `DB::Serializable` instead of the deprecated `DB.mapping`. [#996 in Avram](https://github.com/luckyframework/avram/pull/996)
- Updated: all "UPDATE" statements with a subquery are now wrapped allowing bulk updates when a join exists. [#998 in Avram](https://github.com/luckyframework/avram/pull/998)
- Added: an option to `add_belongs_to` to disable adding an index. [#1002 in Avram](https://github.com/luckyframework/avram/pull/1002)
- Added: `create_sequence` and `drop_sequence` migration methods. [#1003 in Avram](https://github.com/luckyframework/avram/pull/1003)
- Added: `refresh_view` query method and materialized view option for materialized view models. [#1004 in Avram](https://github.com/luckyframework/avram/pull/1004)
- Added: support for `String` primary keys in models. [#1000 in Avram](https://github.com/luckyframework/avram/pull/1000)
- Added: new `String`, `Int`, and `Float` criteria methods. `length`, `reverse`, `abs`, `ceil`, and `floor` respectively. [#1010 in Avram](https://github.com/luckyframework/avram/pull/1010)
- Added: an option to specify an alias for join tables with `Avram::Join`. [#1013 in Avram](https://github.com/luckyframework/avram/pull/1013)
- Added: support for `Array(SomeEnum)` columns. [#1009 in Avram](https://github.com/luckyframework/avram/pull/1009)
- Added: support for custom column converters. [#1009 in Avram](https://github.com/luckyframework/avram/pull/1009)
- Added: new `base_query_class` arg for `has_many` associations to specify which query class to use when an association is called. [#1006 in Avram](https://github.com/luckyframework/avram/pull/1006)
- Added: new `JSON::Any` critera methods `has_key`, `has_any_keys`, and `has_all_keys`. [#1015 in Avram](https://github.com/luckyframework/avram/pull/1015)
- Added: more new `JSON::Any` criteria methods `includes` and `in`. [#1016 in Avram](https://github.com/luckyframework/avram/pull/1016)
- Added: new `IGNORE` constant which is an instance of `Avram::Nothing` used for ignoring column updates in operations. [#1018 in Avram](https://github.com/luckyframework/avram/pull/1018)
- Added: new `String` criteria methods to convert to `to_tsquery` and `to_tsvector` along with a `match` for simple full-text search. [#1019 in Avram](https://github.com/luckyframework/avram/pull/1019)
- Added: new Firefox driver for LuckyFlow. [#162 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/162)
- Added: support for attachments in Carbon. [#88 in Carbon](https://github.com/luckyframework/carbon/pull/88)
- Fixed: Carbon emails can be JSON serialized. [#92 in Carbon](https://github.com/luckyframework/carbon/pull/92)
- Fixed: the location where Carbon emails are generated with `lucky gen.email`. [#93 in Carbon](https://github.com/luckyframework/carbon/pull/93)
- Updated: CarbonSMTP Adapter support on Email shard dependency. [#18 in CarbonSMTPAdapter](https://github.com/luckyframework/carbon_smtp_adapter/pull/18)
- Added: support for attachments in CarbonSMTPAdapter. [#20 in CarbonSMTPAdapter](https://github.com/luckyframework/carbon_smtp_adapter/pull/20)



### Changes in 1.1.0 (2023-10-29)

- Fixed: generated docs on `match` macro. [#1790](https://github.com/luckyframework/lucky/pull/1790)
- Fixed: memoized memthods that use an external arg name. [#1817](https://github.com/luckyframework/lucky/pull/1817)
- Added: configurable timeout for browser reload in development. [#1822](https://github.com/luckyframework/lucky/pull/1822)
- Added: config option to silence stacktraces from logs. [#1821](https://github.com/luckyframework/lucky/pull/1821)
- Added: new `--with-page` flag for `lucky gen.action.browser` task. [#1819](https://github.com/luckyframework/lucky/pull/1819)
- Refactor: `RequestBodyReader` with a performance boost in actions. [#1826](https://github.com/luckyframework/lucky/pull/1826)
- Refactor: action route generation with a performance boost. [#1829](https://github.com/luckyframework/lucky/pull/1829)
- Refactor: `html` macro for actions with simpler code. [#1836](https://github.com/luckyframework/lucky/pull/1836)
- Added: config option to configure default redirect statuses. [#1838](https://github.com/luckyframework/lucky/pull/1838)
- Refactor: The `lucky` CLI no longer compiles when running `-h`. [#771 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/771)
- Added: A new `lucky tasks` CLI command added to display available tasks.
- Fixed: The `lucky dev` command now shows in the CLI help menu.
- Updated: generated apps `docker-compose.yml`. [#799 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/799)
- Refactor: LuckyCLI app generation no longer ueses the `crystal init app` command. [#800 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/800)
- Added: initial work on getting the LuckyCLI to work on Windows. [#804 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/804)
- Refactor: pg client tools are no longer a requirement for Avram. [#942 in Avram](https://github.com/luckyframework/avram/pull/942)
- Fixed: queries not logging when turning up logger level. [#945 in Avram](https://github.com/luckyframework/avram/pull/945)
- Fixed: error message when using `validate_numeric` and passing a float. [#948 in Avram](https://github.com/luckyframework/avram/pull/948)
- Added: JSON serialized Array columns. [#949 in Avram](https://github.com/luckyframework/avram/pull/949)
- Updated: to PG v0.27.0. [#951 in Avram](https://github.com/luckyframework/avram/pull/951)
- Fixed: saving `nil` values when using Upsert operations. [#957 in Avram](https://github.com/luckyframework/avram/pull/957)
- Refactor: escape hatch to allow storing empty strings from param values. [#956 in Avram](https://github.com/luckyframework/avram/pull/956)
- Updated: the `validate_size_of` validation can now validate arrays. [#960 in Avram](https://github.com/luckyframework/avram/pull/960)
- Added: PG extension `PG::NumericFloatConverter` for converting `Float64` values from custom SQL. [#958 in Avram](https://github.com/luckyframework/avram/pull/958)
- Refactor: SaveOperation `insert` and `update` with small performance boost. [#962 in Avram](https://github.com/luckyframework/avram/pull/962)
- Added: new `X_preloaded?` methods to check if an association has already been preloaded. [#961 in Avram](https://github.com/luckyframework/avram/pull/961)
- **Breaking change** Removed: Avram's initialized logging and subscribing to Pulsar events by default. Each app will add this in to control when/if it happens. [#967 in Avram](https://github.com/luckyframework/avram/pull/967)
- Fixed: handing bytes outside of ASCII range for `bytea` columns. [#975 in Avram](https://github.com/luckyframework/avram/pull/975)
- Added: support for other postgres index types other than btree. [#971 in Avram](https://github.com/luckyframework/avram/pull/971)
- Updated: SecTester to v1.6 with new Crystal repeater. [#30 in LuckySecTester](https://github.com/luckyframework/lucky_sec_tester/pull/30)
- Updated: Carbon is now supported on Windows. [#82 in Carbon](https://github.com/luckyframework/carbon/pull/82)
- Updated: LuckyFlow is now supported on Windows. [#156 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/156)
- Fixed: support for Chrome v115+ with chromedriver in LuckyFlow. [#159 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/159)
- Added: Brand new `LuckyHXML` shard for generating [Hyperview](https://hyperview.org/) apps from Lucky. [View Shard](https://github.com/luckyframework/lucky_hxml)
- Added: Brand new `LuckyTemplate` shard for better template generation across platforms. [View Shard](https://github.com/luckyframework/lucky_template)
- Updated: LuckyTask is now supported on Windows. [#14 in LuckyTask](https://github.com/luckyframework/lucky_task/pull/14)
- **Breaking change** Refacor: LuckyTask API to avoid conflicts with common names used for CLI args. [#25 in LuckyTask](https://github.com/luckyframework/lucky_task/pull/25)
- Updated: Habitat is now supported on Windows. [#80 in Habitat](https://github.com/luckyframework/habitat/pull/80)
- Updated: LuckyEnv is now supported on Windows. [#28 in LuckyEnv](https://github.com/luckyframework/lucky_env/pull/28)
- Added: ability to reference previous ENV vars as variables in the `.env` file. [#31 in LuckyEnv](https://github.com/luckyframework/lucky_env/pull/31)
- Updated: LuckyRouter is now supported on Windows. [#63 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/63)
- Updated: LuckyCache is now supported on Windows. [#13 in LuckyCache](https://github.com/luckyframework/lucky_cache/pull/13)
- Updated: Pulsar is now supported on Windows. [#22 in Pulsar](https://github.com/luckyframework/pulsar/pull/22)
- Updated: Wordsmith is now supported on Windows. [#25 in Wordsmith](https://github.com/luckyframework/wordsmith/pull/25)


### Changes in 1.0.0 (2023-03-12)

- Added: Inline SVG files. [#1761](https://github.com/luckyframework/lucky/pull/1761)
- Added: `attrs` option to `sumbit` tag helper. [#1759](https://github.com/luckyframework/lucky/pull/1759)
- Fixed: `previous_url` helper when the referrer is the current page. [#1743](https://github.com/luckyframework/lucky/pull/1743)
- Fixed: issue with SSE Watcher for live reloading. [#1748](https://github.com/luckyframework/lucky/pull/1748)
- Fixed: issue with nil values in JSON params. [#1762](https://github.com/luckyframework/lucky/pull/1762)
- Fixed: issue with block HTML tags using a custom wrapper. [#1763](https://github.com/luckyframework/lucky/pull/1763)
- Removed: the optional `SkipUniqueRoute` check. All routes must be unique. [#1764](https://github.com/luckyframework/lucky/pull/1764)
- Updated: Accept header handling for more robustness. [#1769](https://github.com/luckyframework/lucky/pull/1769)
- Updated: Crystal minimum supported version to be 1.6.0 or later. [#1774](https://github.com/luckyframework/lucky/pull/1774)
- Updated: the Lucky watcher to always use the specified host in development. [#1786](https://github.com/luckyframework/lucky/pull/1786)
- Added: ENV `DEV_HOST` for overriding the development host with an ENV var. [#1788](https://github.com/luckyframework/lucky/pull/1788)
- Updated: generated Dockerfile for development with several fixes. [#787 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/787), [#793 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/793)
- Updated: generated `current_user` method is memoized by default now. [#508 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/508)
- Updated: generated apps are compliant with Crystal 1.7+ [#790 in LuckyCLI](https://github.com/luckyframework/lucky_cli/pull/790)
- Fixed: casting issue with AvramParams and Array values. [#895 in Avram](https://github.com/luckyframework/avram/pull/895)
- Fixed: multi select options with Arrays from columns. [#897 in Avram](https://github.com/luckyframework/avram/pull/897)
- Fixed: submitting only a file in a form with no other permitted params. [#894 in Avram](https://github.com/luckyframework/avram/pull/894)
- Updated: avoid refetching associations that have already been preloaded. [#901 in Avram](https://github.com/luckyframework/avram/pull/901)
- **Breaking change** Updated: Always pass the record to DeleteOperation blocks. [#887 in Avram](https://github.com/luckyframework/avram/pull/887)
- Updated: more support for CockroachDB with `.any?` query method. [#900 in Avram](https://github.com/luckyframework/avram/pull/900)
- Added: new `updated?` and `created?` SaveOperation methods. [#904 in Avram](https://github.com/luckyframework/avram/pull/904)
- Added: new function criteria with new `trim`, and `as_date` query methods. [#912 in Avram](https://github.com/luckyframework/avram/pull/912)
- Updated: more support for CockroachDB with `select_sum` query method. [#921 in Avram](https://github.com/luckyframework/avram/pull/921)
- Updated: better Int column support for CockroachDB. [#920 in Avram](https://github.com/luckyframework/avram/pull/920)
- Fixed: compilation issue with preloading optional associations. [#925 in Avram](https://github.com/luckyframework/avram/pull/925)
- Updated: Authentic with better primary key agnostic support. [#77 in Authentic](https://github.com/luckyframework/authentic/pull/77)
- Updated: Small performance boost with the router. [#60 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/60)
- Updated: to lastest Bright security SecTester. [#27 in LuckySecTester](https://github.com/luckyframework/lucky_sec_tester/pull/27)


### Changes in 1.0.0-rc1 (2022-10-2)

- **Breaking change** Removed: Avram is no longer a dependency of Lucky. [#1620](https://github.com/luckyframework/lucky/pull/1620)
- Fixed: path output when generating a component. [#1694](https://github.com/luckyframework/lucky/pull/1694)
- Updated: Lucky to run on Crystal 1.4 or later as a minimum. [#1696](https://github.com/luckyframework/lucky/pull/1696)
- Removed: the deprecated verifier code. [#1697](https://github.com/luckyframework/lucky/pull/1697)
- Added: new Live-Reload for `lucky watch` command as an alternative to browsersync. [#1693](https://github.com/luckyframework/lucky/pull/1693)
- Updated: Error actions now have access to `params`. [#1716](https://github.com/luckyframework/lucky/pull/1716)
- Updated: `lucky exec` allowing you to set your editor by `$EDITOR` env. [#1715](https://github.com/luckyframework/lucky/pull/1715)
- Added: ability to set custom content-type responses in actions. [#1719](https://github.com/luckyframework/lucky/pull/1719)
- Updated: exception page so javascript is no longer required for it. [#1723](https://github.com/luckyframework/lucky/pull/1723)
- Updated: the error message when you forget to add a type to args in a `memoize` method. [#1726](https://github.com/luckyframework/lucky/pull/1726)
- Added: new `exec_raw` escape hatch method for `ApiClient` to submit raw param data. [#1728](https://github.com/luckyframework/lucky/pull/1728)
- Fixed: `memoize` methods can now end in `?` or `!`. [#1727](https://github.com/luckyframework/lucky/pull/1727)
- Added: Experimental option to have type-safe assets built using [Vitejs](https://vitejs.dev/). [#1729](https://github.com/luckyframework/lucky/pull/1729)
- **Breaking change** Removed: default integration with Turbolinks. [#1737](https://github.com/luckyframework/lucky/pull/1737)
- Updated: generated apps using LuckyFlow are compatible with latest Flow updated. [#760 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/760)
- Updated: generated apps that specify "no auth" no longer include Authentic. [#761 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/761)
- Updated: generated apps now have the ability to remove Avram. [#764 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/764)
- Removed: the tasks file generation task. [#770 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/770)
- Fixed: issue with generated apps that would try to encrypt bad passwords. [#773 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/773)
- Updated: the error message when generating an app in a directory that doesn't exist. [#772 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/772)
- Fixed: issue with generated Dockerfile causing it to not boot. [#775 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/775)
- Updated: generated apps no longer include Turbolinks by default. [#779 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/779)
- **Breaking change** Added: Lucky as an optional extension to Avram. [#772 in Avram](https://github.com/luckyframework/avram/pull/772)
- **Breaking change** Added: Array param support to operations and changed how `Avram::Params` is constructed. [#847 in Avram](https://github.com/luckyframework/avram/pull/847)
- Updated: compile-time catch when specifying both `default` and `fill_existing_with` values in migrations. [#852 in Avram](https://github.com/luckyframework/avram/pull/852)
- Added: new `change_default` method for migrations to change the default value of a column. [#853 in Avram](https://github.com/luckyframework/avram/pull/853)
- Updated: references to `uuid-ossp` in favor of `pgcrypto`. [#855 in Avram](https://github.com/luckyframework/avram/pull/855)
- Added: the ability to use the `@[Flags]` annotation and `Int64` for enums. [#856 in Avram](https://github.com/luckyframework/avram/pull/856)
- Added: new `extract()` method for timestamp queries. [#861 in Avram](https://github.com/luckyframework/avram/pull/861)
- Added: new `Bytes` column support for `bytea` columns. [#860 in Avram](https://github.com/luckyframework/avram/pull/860)
- **Breaking change** Updated: named args to take precedence over param values when using Operations. [#862 in Avram](https://github.com/luckyframework/avram/pull/862)
- Added: new `grouped_checkbox` method for use with Array attributes. [#863 in Avram](https://github.com/luckyframework/avram/pull/863)
- Fixed: `change_type` so it can change from one nilable type to another nilable type. [#869 in Avram](https://github.com/luckyframework/avram/pull/869)
- Updated: Factory callbacks now return `self`. [#866 in Avram](https://github.com/luckyframework/avram/pull/866)
- Fixed: JSON::Any columns that are nilable to return nil properly. [#878 in Avram](https://github.com/luckyframework/avram/pull/878)
- Updated: the arg names to `validate_numeric` to avoid confusion. [#867 in Avram](https://github.com/luckyframework/avram/pull/867)
- Added: the ability to customize the session key used for sign-in with Authentic. [#75 in Authentic](https://github.com/luckyframework/authentic/pull/75)
- **Breaking change** Added: new Driver registration for LuckyFlow allowing for custom web drivers. [#133 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/133)
- **Breaking change** Updated: LuckyFlow to not depend directly on Selenium. [#135 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/135)
- Added: `find_xpath` method for LuckyFlow drivers. [#141 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/141)
- Added: "Webless" driver support to LuckyFlow. [#137 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/137)
- **Breaking change** Updated: and abstracted LuckyFlow extensions for Lucky, Avram, and Authentic. [#152 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/152)
- Added: the ability to add mailer layouts for HTML templates. [#70 in Carbon](https://github.com/luckyframework/carbon/pull/70)
- Added: `before_send` and `after_send` callbacks for emails with delivery short circuiting. [#72 in Carbon](https://github.com/luckyframework/carbon/pull/72)
- Fixed: issue when generating a new email and using the word "Email" duplicating it. [#74 in Carbon](https://github.com/luckyframework/carbon/pull/74)
- Updated: LuckySecTester is officially released with v0.1.0. [View Shard](https://github.com/luckyframework/lucky_sec_tester)
- Added: new `ws` CLI utility with Wordsmith allowing you to process words from the CLI. [#23 in Wordsmith](https://github.com/luckyframework/wordsmith/pull/23)


### Changes in 0.30.1 (2022-04-17)

- Fixed: compilation issue when using the `Lucky::Subdomain` module. [#1686](https://github.com/luckyframework/lucky/pull/1686)

### Changes in 0.30.0 (2022-04-07)

- Fixed: logging empty request_id [#1630](https://github.com/luckyframework/lucky/pull/1630)
- Updated: references to community chat and general housekeeping [#1633](https://github.com/luckyframework/lucky/pull/1633)
- Updated: error message on incorrect usage of `default_format` [#1638](https://github.com/luckyframework/lucky/pull/1638)
- Updated: error message on incorrect usage of routes [#1639](https://github.com/luckyframework/lucky/pull/1639)
- Added: new `previous_url` page helper method. [#1641](https://github.com/luckyframework/lucky/pull/1641)
- Added: ability to make requests to actions directly in specs. [#1644](https://github.com/luckyframework/lucky/pull/1644)
- Fixed: `time_ago_in_words` always rounding down. [#1651](https://github.com/luckyframework/lucky/pull/1651)
- Updated: Turbolinks redirect support to allow for replace in the future. [#1650](https://github.com/luckyframework/lucky/pull/1650)
- Updated: compiling "done" notice to be more prominent. [#1653](https://github.com/luckyframework/lucky/pull/1653)
- Added: ability to enable/disable forgery protection app-wide. [#1657](https://github.com/luckyframework/lucky/pull/1657)
- **Breaking change** Fixed: parsing JSON values for params. [#1661](https://github.com/luckyframework/lucky/pull/1661)
- **Breaking change** Updated: Lucky::ForceSSLHandler middleware to match X-Forwarded-Proto == https exactly, which previously accepted uppercase and only required https to be part of the value [#1662](https://github.com/luckyframework/lucky/pull/1662)
- **Breaking change** Updated: the primary branch name from "master" to "main". [#1667](https://github.com/luckyframework/lucky/pull/1667)
- Added: new Content-Security-Policy header module. [#1673](https://github.com/luckyframework/lucky/pull/1673)
- Added: new `remote_ip` method with a config to customize the header lookup. [#1675](https://github.com/luckyframework/lucky/pull/1675)
- **Breaking change** Updated: the remote_ip lookup to use the last valid IP instead of the first in the `X-Forward-For` list. [also #1675](https://github.com/luckyframework/lucky/pull/1675)
- Updated: `MessageVerifier` to handle different types of token data. [#1674](https://github.com/luckyframework/lucky/pull/1674)
- Added: `[]` and `[]=` Methods to `Lucky::CookieJar`. [#1678](https://github.com/luckyframework/lucky/pull/1678)
- Fixed: issue with generated CI not connecting to postgres. [#719 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/719)
- Added: built-in process runner [Nox](https://github.com/matthewmcgarvey/nox). [#710 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/710)
- **Breaking change** Removed: built-in support for other process runners like Overmind through `lucky dev`. [#720](https://github.com/luckyframework/lucky_cli/pull/720)
- Removed: references to TravisCI from old Crystal setup. [#722 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/722)
- Updated: default watcher port to use 3000 instead of 5000. [#727 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/727)
- Added: Docker setup for local development out-of-the-box. [#738 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/738)
- Fixed: ameba linting issue with new Lucky apps. [#739 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/739)
- Updated: default target name to be `app` instead of your app's name for easier building with Docker. [#742 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/742)
- Added: new integration with Bright Security (formerly Neuralegion) SecTester for Security specs out-of-the-box. [#743 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/743)
- Added: `random_order` for queries. [#765 in Avram](https://github.com/luckyframework/avram/pull/765)
- Removed: old compile-time deprecation errors. [#744 in Avram](https://github.com/luckyframework/avram/pull/774)
- Updated: running DB specs in a transaction instead of truncating. [#780 in Avram](https://github.com/luckyframework/avram/pull/780)
- Added: `group_count` method for grouped count queries. [#778 in Avram](https://github.com/luckyframework/avram/pull/778)
- Added: `AvramSlugify` is now integrated as `Avram::Slugify`. [#786 in Avram](https://github.com/luckyframework/avram/pull/786)
- Fixed: JSON parsing to/from the DB when the value was a String but should have been a JSON object. [#806 in Avram](https://github.com/luckyframework/avram/pull/806)
- Fixed: issue with some query cache methods not returning correctly. [#810 in Avram](https://github.com/luckyframework/avram/pull/810)
- Added: helpful error when required association is not loaded in preload. [#812 in Avram](https://github.com/luckyframework/avram/pull/812)
- Added: default time values in SQL for the default timestamps. [#820 in Avram](https://github.com/luckyframework/avram/pull/820)
- Added: a unique index to the migrations table to avoid duplicate migration versions. [#815 in Avram](https://github.com/luckyframework/avram/pull/815)
- Added: properties to error classes for better error customization with I18n. [#823 in Avram](https://github.com/luckyframework/avram/pull/823)
- Added: new `generate` method for `Avram::Slugify` to generate a slug without setting a value. [#821 in Avram](https://github.com/luckyframework/avram/pull/821)
- Added: `validate_format_of` and `validate_uniqueness_of` to `Avram::I18Backend` for better error message support. [#830 in Avram](https://github.com/luckyframework/avram/pull/830)
- Added: new [LuckySecTester](https://github.com/luckyframework/lucky_sec_tester) shard as a thing wrapper around the [NeuraLegion SecTester](https://github.com/NeuraLegion/sec_tester)
- Added: new task to generate email templates. [#60 in Carbon](https://github.com/luckyframework/carbon/pull/60)
- Added: new `size` method to LuckyCache. [#10 in LuckyCache](https://github.com/luckyframework/lucky_cache/pull/10)
- Added: `clear_subscribers` method to Pulsar to clear events of subscribers. [#18 in Pulsar](https://github.com/luckyframework/pulsar/pull/18)
- Added: extra log metadata when using `emit()` with Dexter. [#45 in Dexter](https://github.com/luckyframework/dexter/pull/45)
- Added: support for passing unsubscribe group data to Sendgrid. [#8 in Carbon Sendgrid Adapter](https://github.com/luckyframework/carbon_sendgrid_adapter/pull/8)


### v0.29 (2021-11-30)

- Fixed: the binary name generated for the `gen.secret_key` task. [#1556](https://github.com/luckyframework/lucky/pull/1556)
- Updated: the `html_with_status` to allow Numbers, Symbols, and HTTP::Status. [#1568](https://github.com/luckyframework/lucky/pull/1568)
- Updated: the `lucky routes` task to print within a table (again). Added a new flag option to print params. [#1569](https://github.com/luckyframework/lucky/pull/1569)
- Added: new `path_without_query_params` Action method. [#1572](https://github.com/luckyframework/lucky/pull/1572)
- Added: option to set a different manifest filename when not using laravel-mix. [#1578](https://github.com/luckyframework/lucky/pull/1578)
- Fixed: an issue when passing optional params that were not a String. [#1582](https://github.com/luckyframework/lucky/pull/1582)
- Fixed: Ameba always being installed even when your app doesn't depend on it. [#1589](https://github.com/luckyframework/lucky/pull/1589), [#736 in Avram](https://github.com/luckyframework/avram/pull/736), [#62 in Carbon](https://github.com/luckyframework/carbon/pull/62)
- Added: support for using namespaces when generating resources from the CLI. [#1588](https://github.com/luckyframework/lucky/pull/1588)
- Added: DeleteOperation when generating a model from the CLI. [#1594](https://github.com/luckyframework/lucky/pull/1594)
- Fixed: verifying secret messages that may contain "--". [#1596](https://github.com/luckyframework/lucky/pull/1596)
- Removed: `route` and `nested_route` macro helpers. [#1597](https://github.com/luckyframework/lucky/pull/1597)
- Fixed: the use of boolean attributes rendering invalid values in HTML. [#1598](https://github.com/luckyframework/lucky/pull/1598)
- Added: new Pulsar event to fire when an HTTP request is fully completed. [#1601](https://github.com/luckyframework/lucky/pull/1601)
- Updated: the `lucky watch` task to be less greedy on recompiles. [#1604](https://github.com/luckyframework/lucky/pull/1604)
- Added: the `ajax` desired client format option for actions. [#1603](https://github.com/luckyframework/lucky/pull/1603)
- Added: a better help message for `lucky exec` to include options. [#1602](https://github.com/luckyframework/lucky/pull/1602)
- Added: new `previous_page`, and `next_page` Paginator helper methods. [#1611](https://github.com/luckyframework/lucky/pull/1611)
- Fixed: writing to the response body when making a HEAD call. [#1609](https://github.com/luckyframework/lucky/pull/1609)
- **Breaking change** Removed: the `lucky build.release` task. [#1612](https://github.com/luckyframework/lucky/pull/1612)
- Updated: Avram is no longer required for parsing params. [#1616](https://github.com/luckyframework/lucky/pull/1616)
- **Breaking change** Removed: support for Crystal versions below 1.0.0. [#1618](https://github.com/luckyframework/lucky/pull/1618)
- **Breaking change** Updated: the `Lucky::BaseAppServer#listen` method to be abstract. [#1622](https://github.com/luckyframework/lucky/pull/1622)
- Added: new HTTP `context.request_id` and `RequestIdHandler`. [#1610](https://github.com/luckyframework/lucky/pull/1610)
- Added: documentation clarity for the route style checking. [#668 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/668)
- Updated: require position for the config directory to be higher in the stack. [#676 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/676)
- Updated: the `load_manifest` to use "public/mix-manifest.json" by default. [#679 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/679)
- Fixed: issue when booting a Lucky app would clash with Elixir's `mix`. [#682 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/682)
- Fixed: the error page returning a 200 response. [#684 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/684)
- Updated: the GithubActions CI for generated apps to allow for testing multiple versions of Crystal. [#685 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/685)
- Added: a max limit for password sized in Authentic password validations. [#692 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/692)
- Added: special "flow" tags to a generated app's specs. [#693 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/693)
- Added: new sample "app config" file for generated apps. [#694 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/694)
- Updated: the `AppServer#listen` code to be a bit more concise. [#699 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/699)
- Added: new `Lucky::RequestIdHandler` to generated apps. [#700 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/700)
- Fixed: issue when `select_count` was called before an update causing a failure. [#715 in Avram](https://github.com/luckyframework/avram/pull/715)
- Fixed: issue when inheritng from a SaveOperation that had attributes. [#718 in Avram](https://github.com/luckyframework/avram/pull/718)
- Fixed: issue when passing an enum number as a String. [#720 in Avram](https://github.com/luckyframework/avram/pull/720)
- **Breaking change** Removed: UUID generation on the Crystal side for the `id` column. [#725 in Avram](https://github.com/luckyframework/avram/pull/725)
- Updated: the error message for unpermitted columns to be a little clearer where they come from. [#723 in Avram](https://github.com/luckyframework/avram/pull/723)
- Added: new `includes()` query method for Array columns. [#733 in Avram](https://github.com/luckyframework/avram/pull/733)
- Added: compile-time catches for common mistakes with attribute usage. [#738 in Avram](https://github.com/luckyframework/avram/pull/738)
- Updated: the pending migration notice to be a lot more clear in development. [#737 in Avram](https://github.com/luckyframework/avram/pull/737)
- Updated: `add_belongs_to` to require the `references` option when using a namespace. [#742 in Avram](https://github.com/luckyframework/avram/pull/742)
- Updated: all validation methods to now return a Bool based on if they passed or not. [#744 in Avram](https://github.com/luckyframework/avram/pull/744)
- Updated: the `lucky db.schema.dump` task to include the migrations table data. [#743 in Avram](https://github.com/luckyframework/avram/pull/743)
- Fixed: missing low level DB methods. [#750 in Avram](https://github.com/luckyframework/avram/pull/750)
- Added: new escape hatch to skip default validations, and allow blank strings to be saved. [#746](https://github.com/luckyframework/avram/pull/746)
- Added: new `default_validations` block macro. [#751 in Avram](https://github.com/luckyframework/avram/pull/751)
- Added: new `validate_format_of` validation method. [#752 in Avram](https://github.com/luckyframework/avram/pull/752)
- Fixed: sort order of migrations. [#756 in Avram](https://github.com/luckyframework/avram/pull/756)
- Added: new `Avram::I18nBackend` for setting language translations. [#757 in Avram](https://github.com/luckyframework/avram/pull/757)
- **Breaking change** Renamed: `Operation::Status` enums to `Operation::OperationStatus`. [#759 in Avram](https://github.com/luckyframework/avram/pull/759)
- Added: new query cache mechanism. [#763 in Avram](https://github.com/luckyframework/avram/pull/763)
- Added: brand new [LuckyCache](https://github.com/luckyframework/lucky_cache) shard.
- Added: Dynamic Email templates with Carbon SendGrid adapter. [#5 in Carbon SendGrid](https://github.com/luckyframework/carbon_sendgrid_adapter/pull/5)
- Added: new `int32` and `float64` task args. [#3 in LuckyTask](https://github.com/luckyframework/lucky_task/pull/3)
- Added: faster routing! [#54 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/54), [#55 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/55)
- Updated: `ENV["LUCKY_TASK"]` to be nilable. [#21 in LuckyTask](https://github.com/luckyframework/lucky_env/pull/21)


### v0.28.0 (2021-07-22)

- Updated: The exception page to use new backtrace shard. [#1465](https://github.com/luckyframework/lucky/pull/1465)
- Updated: some Lucky internals with "Spring Cleaning". #1478, #1481, #1483, #1489, #1496, #1511, #1513, #1514, #1521, #1522, #1529, #1532, #1535, #1540, #1542, #1544, #1543
- Updated: components so they no longer require `context` to be passed in. [#1488](https://github.com/luckyframework/lucky/pull/1488)
- Added: new `time_from_now_in_words` text helper. [#1493](https://github.com/luckyframework/lucky/pull/1493)
- Added: new `multipart?` action request helper. [#1495](https://github.com/luckyframework/lucky/pull/1495)
- Updated: the generated delete action resource to use DeleteOperation. [#1497](https://github.com/luckyframework/lucky/pull/1497)
- Added: new `raw_json` Action response method. [#1492](https://github.com/luckyframework/lucky/pull/1492)
- Updated: `form_for` to allow passing boolean attributes. [#1506](https://github.com/luckyframework/lucky/pull/1506)
- Added: new module to disable FLoC. [#1508](https://github.com/luckyframework/lucky/pull/1508)
- Deprecated: `route` and `nested_route` from actions. [#1510](https://github.com/luckyframework/lucky/pull/1510)
- Updated: performance with `params`. It's now attached to `context`. [#1509](https://github.com/luckyframework/lucky/pull/1509)
- Updated: api actions generated will always be in the `api/` namespace. [#1512](https://github.com/luckyframework/lucky/pull/1512)
- Updated: `Lucky::Serializer` with abstract `render` method. [#1516](https://github.com/luckyframework/lucky/pull/1516)
- Added: new `html_with_status` method to render HTML pages with non-200 status. [#1507](https://github.com/luckyframework/lucky/pull/1507)
- **Breaking change**: HTML fields that require an Operation Array attribute will now generate a param name appended with `[]`. [#1523](https://github.com/luckyframework/lucky/pull/1523)
- Added: new `multi_select_input`. [#1518](https://github.com/luckyframework/lucky/pull/1518)
- Added: the ability to define Array query params in actions. [#1527](https://github.com/luckyframework/lucky/pull/1527)
- Added: standardized route style checked. [#1536](https://github.com/luckyframework/lucky/pull/1536)
- Added: native subdomain support for actions. [#1537](https://github.com/luckyframework/lucky/pull/1537)
- Added: new unique route enforcer. [#1538](https://github.com/luckyframework/lucky/pull/1538)
- Updated: Carbon sendgrid is now a separate adapter. [#624 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/624)
- Updated: default components no longer need `context`. [#641 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/641)
- Updated: some LuckyCli internals with "Spring Cleaning". #646, #647, #648, #651, #649, #666 (in Lucky CLI)
- Updated: generated apps will use `LuckyEnv` now. [#650 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/650)
- Removed: deprecated `normalize-css` package and replaced with `modern-normalize`. [#652 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/652)
- Added: new generated apps will enforce route styles by default. [#653 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/653)
- Updated: new generated apps will use case-insensitive email columns for the `User` model. [#657 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/657)
- Fixed: support for Crystal 1.1.0 when generating a new app. [#644 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/644)
- Removed: the `Lucky::Env` module and replaced with the `LuckyEnv` shard. [#655 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/655)
- Fixed: passing special args to precompiled tasks. [#656 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/656)
- Updated: some Avram internals with "Spring Cleaning". #669, #681, #683, #704, #705, #708 (in Avram)
- Updated: `validate_numeric` and `validate_size_of` methods to allow for a custom error message. [#670 in Avram](https://github.com/luckyframework/avram/pull/670)
- Updated: `db.drop` and `db.reset` tasks with a "quiet" option. [#675 in Avram](https://github.com/luckyframework/avram/pull/675)
- Fixed: edge case with migrations using `fill_existing_with: false`. [#676 in Avram](https://github.com/luckyframework/avram/pull/676)
- Added: new `Appdatabase.listen` method to listen for `pg_notify()` calls to any number of channels. [#677 in Avram](https://github.com/luckyframework/avram/pull/677)
- Added: `before_save` and `after_save` callbacks to `Avram::Factory`. [#678 in Avram](https://github.com/luckyframework/avram/pull/678)
- Fixed: `add_belongs_to` to support namespaced types. [#685 in Avram](https://github.com/luckyframework/avram/pull/685)
- Updated: how `select_count` works to allow counting with `distinct_on`. [#687 in Avram](https://github.com/luckyframework/avram/pull/687)
- Fixed: datetime parsing from form inputs. [#693 in Avram](https://github.com/luckyframework/avram/pull/693)
- Fixed: compile-time error when you have a typo in your constant name (i.e. Boolean instead of Bool). [#700 in Avram](https://github.com/luckyframework/avram/pull/700)
- Updated: the `validate_uniqueness_of` method to take a full query object. [#701 in Avram](https://github.com/luckyframework/avram/pull/701)
- Added: new `any?` and `none?` query methods to return a `Bool` value based on records existing. [#703 in Avram](https://github.com/luckyframework/avram/pull/703)
- **Breaking change**: removed `avram_enum`. You can now just use the native Crystal `enum` type. [#698 in Avram](https://github.com/luckyframework/avram/pull/698)
- Added: ability to use `CASCADE` when calling `truncate`. [#702 in Avram](https://github.com/luckyframework/avram/pull/702)
- Added: new `SaveOperation.upsert` methods. [#334 in Avram](https://github.com/luckyframework/avram/pull/334)
- **Breaking change**: renamed `DeleteOperation.destroy` to `DeleteOperation.delete`. [#707 in Avram](https://github.com/luckyframework/avram/pull/707)
- Fixed: compile-time error when no columns are defined in a model. [#706 in Avram](https://github.com/luckyframework/avram/pull/706)
- Added: new JSON serializable object columns. [#695 in Avram](https://github.com/luckyframework/avram/pull/695)
- Updated: the `current_user?` method to be memoized for performance. [#64 in Authentic](https://github.com/luckyframework/authentic/pull/64)
- Updated: Authentic to catch potential development issues when setting the `secret_key`. [#65 in Authentic](https://github.com/luckyframework/authentic/pull/65)
- Fixed: minor performance issue when setting a slug in AvramSlugify. [#10 in AvramSlugify](https://github.com/luckyframework/avram_slugify/pull/10)
- Updated: irregular inflects with `human -> humans`. [#14 in Wordsmith](https://github.com/luckyframework/wordsmith/pull/14)
- Fixed: customizing inflections with Wordsmith. [#18 in Wordsmith](https://github.com/luckyframework/wordsmith/pull/18)
- Fixed: URI decoding path parts in the Lucky Router, also a small performance gain. [#51 in Lucky Router](https://github.com/luckyframework/lucky_router/pull/51)
- Added: the environment predicate methods from `Lucky::Env` in to `LuckyEnv`. [#13 in LuckyEnv](https://github.com/luckyframework/lucky_env/pull/13)
- Updated: Email Previews in Breeze are easier to add in. [#41 in Breeze](https://github.com/luckyframework/breeze/pull/41)
- Fixed: using file uploads with Breeze requests. [#43 in Breeze](https://github.com/luckyframework/breeze/pull/43)
- Added: storing before/after pipes in Breeze. [#36 in Breeze](https://github.com/luckyframework/breeze/pull/36)
- Fixed: issue when running specs on an app using Breeze. [#42 in Breeze](https://github.com/luckyframework/breeze/pull/42)


### v0.27.2 (2021-04-12)

- Removed: legacy ecrypted cookies handling. [#1470](https://github.com/luckyframework/lucky/pull/1470)
- Updated: Cookies resulting in encryption failure are ignored. [#1470](https://github.com/luckyframework/lucky/pull/1470)

### v0.27.1 (2021-04-09)

- Fixed: support for previous versions (<= 0.26.0) of encrypted cookies. [#1467](https://github.com/luckyframework/lucky/pull/1467)

### v0.27.0 (2021-04-09)

- Added: support for Crystal 1.0 🥳 [#1445](https://github.com/luckyframework/lucky/pull/1445)
- Added: Pulsar events for tracking before/after action pipes. [#1423](https://github.com/luckyframework/lucky/pull/1423)
- Updated: `link` to raise an exception when passing both `to` and `href`. [#1428](https://github.com/luckyframework/lucky/pull/1428)
- Added: support for more HTML standard tags. [#1433](https://github.com/luckyframework/lucky/pull/1433)
- Added: new `mount_instance` method to mount an instance of a Component. [#1446](https://github.com/luckyframework/lucky/pull/1446)
- Fixed: bug when using VueJS type attributes on HTML tags. [#1452](https://github.com/luckyframework/lucky/pull/1452)
- Updated: the exception page to look like it belongs in Lucky. [#1451](https://github.com/luckyframework/lucky/pull/1451)
- Updated: HTML tags to allow passing in a raw hash of attributes. [#1453](https://github.com/luckyframework/lucky/pull/1453)
- Updated: the `lucky build.release` task to build in to the `bin` directory. [#1454](https://github.com/luckyframework/lucky/pull/1454)
- Fixed: error message when passing wrong type values to HTML tags. [#1456](https://github.com/luckyframework/lucky/pull/1456)
- Updated: `lucky_cli` dependency with new `lucky_task` shard. [#1459](https://github.com/luckyframework/lucky/pull/1459)
- Updated: generated apps so `LuckyFlow` is only a development dependency. [#608 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/608)
- Updated: Auth modules in generated apps to be in an `auth/` directory. [#618 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/618)
- Removed: `LuckyCli::Task` in to a separate shard. [#622 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/622)
- Added: new `LuckyTask` shard to the ecosystem. [View LuckyTask](https://github.com/luckyframework/lucky_task)
- Updated: `avram_enum` to allow parsing a String value. [#639 in Avram](https://github.com/luckyframework/avram/pull/639)
- Fixed: bug when a column is defined as a `DOUBLE`, and using `Float64`. [#637 in Avram](https://github.com/luckyframework/avram/pull/637)
- Updated: migrations to use `Int64` by default allowing for better CockroachDB support. [#641 in Avram](https://github.com/luckyframework/avram/pull/641)
- Fixed: database transactions to not require a `Bool` return type. [#626 in Avram](https://github.com/luckyframework/avram/pull/626)
- Removed: deprecated `raw_where` methods. [#653 in Avram](https://github.com/luckyframework/avram/pull/653)
- Added: new `where(&)` method for wrapping queries in parenthesis. [#652 in Avram](https://github.com/luckyframework/avram/pull/652)
- Added: new `drop_foreign_key` method. [#654 in Avram](https://github.com/luckyframework/avram/pull/654)
- Updated: how table names are stored internally paving the way for faster compilation. [#660 in Avram](https://github.com/luckyframework/avram/pull/660)
- Added: new `parameterize` method for string helpers. [#9 in Wordsmith](https://github.com/luckyframework/wordsmith/pull/9)
- Added: new `Habitat.extend` macro for extending existing configuration settings. [#59 in Habitat](https://github.com/luckyframework/habitat/pull/59)
- Added: new development dashboard shard `Breeze`. [View Breeze](https://github.com/luckyframework/breeze)
- Added: new .env parsing shard `LuckyEnv`. [View LuckyEnv](https://github.com/luckyframework/lucky_env)


### v0.26.0 (2021-02-06)

- Updated: the compile-error for missing Page args. [#1373](https://github.com/luckyframework/lucky/pull/1373)
- Fixed: flash messages to be discarded unless specifically kept. [#1374](https://github.com/luckyframework/lucky/pull/1374)
- Added: generating `JSON::Any` columns from `lucky gen.model` task. [#1375](https://github.com/luckyframework/lucky/pull/1375)
- Added: creating empty HTML tags passing in a Hash for options. [#1377](https://github.com/luckyframework/lucky/pull/1377)
- Updated: action generators to use actual route instead of the `route` or `nested_route` methods. [#1378](https://github.com/luckyframework/lucky/pull/1378)
- Updated: the compile-error for incorrect route helper usage. [#1372](https://github.com/luckyframework/lucky/pull/1372)
- Updated: `lucky gen.*.resource` task to not shadow outer local variable. [#1379](https://github.com/luckyframework/lucky/pull/1379)
- Fixed: uploaded files now have access to the tempfile before it's closed. [#1381](https://github.com/luckyframework/lucky/pull/1381)
- Added: new `lucky gen.task` task for generating a new Cli Task. [#1322](https://github.com/luckyframework/lucky/pull/1322)
- Added: new `params.get_all` method to get an Array of values from params. [#1389](https://github.com/luckyframework/lucky/pull/1389)
- Removed: broken `tag()` overloads. [#1394](https://github.com/luckyframework/lucky/pull/1394)
- Added: support for Crystal 0.36. [#1398](https://github.com/luckyframework/lucky/pull/1398)
- Fixed: empty HTML tags adding an extra space when generated. [#1400](https://github.com/luckyframework/lucky/pull/1400)
- Fixed: issue with wrong types for form HTML methods when passing in an Operation Attribute. [#1405](https://github.com/luckyframework/lucky/pull/1405)
- Updated: DB logging to be a little less excited. [#589 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/589)
- Removed: usage of the `route` and `nested_route` methods in generated apps. [#594 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/594)
- Added: some inline docs to using `ENV["LUCKY_TASK"]`. [#595 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/595/files)
- Added: ability to pass `--error-trace` flag to precompiled lucky tasks. [#596 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/596)
- Updated: to Laravel Mix 6 for generated apps. [#592 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/592)
- Fixed: issue with generated apps Github Actions CI failing. [#600 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/600)
- Updated: `Procfile` for generated apps to call a binary named by the project instead of "app". [#601 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/601)
- Added: a new Heroku Buildpack to build all proper targets. Accompanies #601 in Lucky CLI. [view Heroku Buildpack](https://github.com/luckyframework/heroku-buildpack-lucky)
- Added: equality operators (`==`, `===`) to `avram_enum`. [#566 in Avram](https://github.com/luckyframework/avram/pull/566)
- Fixed: bug in associations that returned more records than they should have. [#574 in Avram](https://github.com/luckyframework/avram/pull/574)
- Updated: error messages during migrations that were obscured. [#577 in Avram](https://github.com/luckyframework/avram/pull/577)
- Added: `UUID` primary keys are now generated in the database with a fallback using Crystal. [#578 in Avram](https://github.com/luckyframework/avram/pull/578)
- Updated: `validate_size_of` to only take a `String` attribute. [#579 in Avram](https://github.com/luckyframework/avram/pull/579)
- Added: new `validate_numeric` validation for validating numbers. [#580 in Avram](https://github.com/luckyframework/avram/pull/580)
- Fixed: issue with `has_one` preloads not loading the correct records. [#581 in Avram](https://github.com/luckyframework/avram/pull/581)
- Updated: compile-error for attempting to use nilable attributes. [#583 in Avram](https://github.com/luckyframework/avram/pull/583)
- Added: new `Avram::DeleteOperation` objects for handling complex delete logic. [#573 in Avram](https://github.com/luckyframework/avram/pull/573)
- Updated: how generics work in `Avram::Attribute`. [#586 in Avram](https://github.com/luckyframework/avram/pull/586)
- Updated: custom type support to allow for better 3rd-party support in the future. [#587 in Avram](https://github.com/luckyframework/avram/pull/587)
- Added: new `lucky db.console` task to enter PSQL for your app. [#592 in Avram](https://github.com/luckyframework/avram/pull/592)
- Updated: more support and transparency for custom DB types with new `criteria` method. [#591 in Avram](https://github.com/luckyframework/avram/pull/591)
- Fixed: using the `datetime-local` tag to persist the Time. [#603 in Avram](https://github.com/luckyframework/avram/pull/603)
- Updated: to the latest (0.23.x) crystal-pg version. [#605 in Avram](https://github.com/luckyframework/avram/pull/605)
- Added: support for using `citext` columns with new `case_sensitive: false` option. [#608 in Avram](https://github.com/luckyframework/avram/pull/608)
- Added: support for `Array(UUID)` columns. [#609 in Avram](https://github.com/luckyframework/avram/pull/609)
- Updated: SaveOperation `after_save` and `after_commit` callbacks to run even if no changes to the record are made. [#612 in Avram](https://github.com/luckyframework/avram/pull/612)
- Removed: the `after_completed` callback in SaveOperations. [also #612 in Avram](https://github.com/luckyframework/avram/pull/612)
- Rename: `Avram::Box` to `Avram::Factory`. [#614 in Avram](https://github.com/luckyframework/avram/pull/614)
- Added: new composite primary keys for migrations. [#616 in Avram](https://github.com/luckyframework/avram/pull/616)
- Fixed: issues with `has_one` in `SaveOperation` not updating the associated record when doing updates. [#596 in Avram](https://github.com/luckyframework/avram/pull/596)
- Updated: `Avram::Operation` to not call `run` if the operation is not `valid?`. [#621 in Avram](https://github.com/luckyframework/avram/pull/621)
- Updated: LuckyFlow ChromeDriver to run in non-headless mode (head mode?). [#112 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/112)
- Added: ability to use a non Chrome browser in LuckyFlow. [#112 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/113)
- Added: the `browser_binary` option back in which lets use specify a different Chrome based browser. [#114 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/114)
- Added: new `pause` method for LuckyFlow to pause execution of flow for debugging. [#117 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/117)
- Updated: runtime-error for duplicate defined routes. [#45 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/45)
- Added: `have_delivered_emails` spec expectation method for `Carbo`. [#45 in Carbon](https://github.com/luckyframework/carbon/pull/45)


### v0.25.0 (2020-12-18)

- Rename: component `with_defaults` renamed to `tag_defaults` [#1262](https://github.com/luckyframework/lucky/pull/1262)
- Fixed: send HSTS headers over HTTPS. [#1268](https://github.com/luckyframework/lucky/pull/1268)
- Updated: `memoize` can be used on any `Object` [#1270](https://github.com/luckyframework/lucky/pull/1270)
- Added: `tfoot()` tag method. [#1296](https://github.com/luckyframework/lucky/pull/1296)
- Added: routes now support glob routing [#1294](https://github.com/luckyframework/lucky/pull/1294)
- Fixed: passing a `UUID` in to a tag for text [#1280](https://github.com/luckyframework/lucky/pull/1280)
- Fixed: calling route helper methods on actions with `route_prefix` set. [#1298](https://github.com/luckyframework/lucky/pull/1298)
- Added: clearing cookies with specific options passed in [#966](https://github.com/luckyframework/lucky/pull/966)
- Fixed: passing a `name` prop to a custom tag. [#1309](https://github.com/luckyframework/lucky/pull/1309)
- Added: `blockquote()` and `cite()` tag methods. [#1317](https://github.com/luckyframework/lucky/pull/1317)
- Added: type name in error message for action classes [#1321](https://github.com/luckyframework/lucky/pull/1321)
- Fixed: params that use `Bool` with a default value of `false` [#1352](https://github.com/luckyframework/lucky/pull/1352)
- Updated: generated `start_server` binary is now output to the `bin` directory instead of top-level. [#1358](https://github.com/luckyframework/lucky/pull/1358)
- Fixed: HTTP status description in the log output. [#1362](https://github.com/luckyframework/lucky/pull/1362)
- Updated: reverted the `DATABASE_URL` ENV. [#551 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/551)
- Updated: emails will print to the log in development for easier debugging. [#555 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/555)
- Updated: Tasks can use the `output` property for easier testing. Added an `example` option to task args. [#557 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/557)
- Added: New generated Lucky projects will come with Github Actions out of the box. [#559 In Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/559)
- Updated: front-end `package.json` dependencies. [#553](https://github.com/luckyframework/lucky_cli/pull/553)
- Fixed: Signal trap is properly caught when running `lucky dev`. [#572 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/572)
- Updated: the built-in seed tasks to better match the common structure. [#584 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/584)
- Added: new `Lucky::Env.task?` method will return true if `ENV["LUCKY_TASK"] = "true"` is set. [#576 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/576)
- Updated: Query objects no longer mutate which fixes calling aggregate methods without needing to `clone`. [#411 in Avram](https://github.com/luckyframework/avram/pull/411)
- Updated: the error message when a required primary key is missing. [#454 in Avram](https://github.com/luckyframework/avram/pull/454)
- Updated: `fill_existing_with` to be used with nilable columns. [#452 in Avram](https://github.com/luckyframework/avram/pull/452)
- Fixed: `Bool` columns with a default `false` value. [#461 in Avram](https://github.com/luckyframework/avram/pull/461)
- Fixed: `belongs_to` using the wrong key in some cases. [#465 in Avram](https://github.com/luckyframework/avram/pull/465)
- Fixed: using optional Arrays in columns and migrations. [#471 in Avram](https://github.com/luckyframework/avram/pull/471)
- Fixed: calling `to_s` or `to_i` on an enum column to get the enum's proper value. [#474 in Avram](https://github.com/luckyframework/avram/pull/474)
- Updated: using `raw_where` will now be deprecated in favor of a unified `where`. [#460 in Avram](https://github.com/luckyframework/avram/pull/460)
- Fixed: issues with invalid SQL with joins. [#451 in Avram](https://github.com/luckyframework/avram/pull/451)
- Added: a whole new interface for `Avram::Operation`. [#469 in Avram](https://github.com/luckyframework/avram/pull/469)
- Updated: `Avram::SaveOperation` callback methods `after_save` and `after_commit` work with blocks, and more. [#481 in Avram](https://github.com/luckyframework/avram/pull/481)
- Added: a compile-time error catch when passing a raw hash in to a `SaveOperation`. [#485 in Avram](https://github.com/luckyframework/avram/pull/485)
- Removed: `register_setup_step` macro used for hooking in to the Avram model setup. [#486 in Avram](https://github.com/luckyframework/avram/pull/486)
- Added: new `or()` query method to perform `WHERE x OR y` SQL calls. [#442 in Avram](https://github.com/luckyframework/avram/pull/442)
- Updated: database calls to be optimized for speed. [#491 in Avram](https://github.com/luckyframework/avram/pull/491)
- Added: `params.has_key_for?` to check if params contains a key for an operation. [#500 in Avram](https://github.com/luckyframework/avram/pull/500)
- Added: conditional callbacks for `Avram::SaveOperation`. [#495 in Avram](https://github.com/luckyframework/avram/pull/495)
- Updated: the `has_many` count method to not preload when just a number is being returned. [#509 in Avram](https://github.com/luckyframework/avram/pull/509)
- Fixed: passing a `file_attribute` as a named arg to an operation. [#514 in Avram](https://github.com/luckyframework/avram/pull/514)
- Removed: unique filtering on `WHERE` clauses. [#518](https://github.com/luckyframework/avram/pull/518)
- Updated: error message when using `remove` incorrectly in migrations. [#524 in Avram](https://github.com/luckyframework/avram/pull/524)
- Added: error message when trying to generate a migration by a name that already exists. [#528 in Avram](https://github.com/luckyframework/avram/pull/528)
- Added: new custom errors for Operation objects. [#534 in Avram](https://github.com/luckyframework/avram/pull/534)
- Updated: `add_belongs_to` can now set a unique index. [#536 in Avram](https://github.com/luckyframework/avram/pull/536)
- Fixed: creating records by passing in values that match the default. [#540 in Avram](https://github.com/luckyframework/avram/pull/540)
- Updated: how `has_many through` associations are defined to fix has_many through a has_many through association. [#525 in Avram](https://github.com/luckyframework/avram/pull/525)
- Added: new `after_completed` callback on `Avram::SaveOperation` which is called even if no updates are made. [#544 in Avram](https://github.com/luckyframework/avram/pull/544)
- Added: `UUID` primary key checks to the SchemaEnforcer. [#546 in Avram](https://github.com/luckyframework/avram/pull/546)
- Added: records already loaded in to memory can now preload associations. [#542 in Avram](https://github.com/luckyframework/avram/pull/542), [#553 in Avram](https://github.com/luckyframework/avram/pull/553), [#561 in Avram](https://github.com/luckyframework/avram/pull/561)
- Added: support for models to use `VIEW`. [#555 in Avram](https://github.com/luckyframework/avram/pull/555)
- Added: new `defaults` method for defining default query methods on Query objects. [#564 in Avram](https://github.com/luckyframework/avram/pull/564)
- Fixed: setting two routes that use different path variable names. [#38 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/38)
- Added: route globbing. [#40 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/40)
- Fixed: catching when duplicate routes are defined. [#42 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/42)
- Added: flow spec matcher method `have_current_path`. [#96 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/96)
- Fixed: flow spec `have_text` matcher method to check if the text is included and not exact. [#99 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/99)
- Added: flow method to confirm and accept javascript modal boxes. [#101 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/101)
- Added: flow to fill a select field. [#104 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/104)
- Added: flow to select multiple values from a select field. [#106 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/106)
- Added: flow method `element.hover` to hover over an element. [#108 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/108)


### v0.24.0 (2020-09-05)

- Fixed: `send_text_response` default status to nil [#1214](https://github.com/luckyframework/lucky/pull/1214)
- Added: `data` method for Actions to return file contents [#1220](https://github.com/luckyframework/lucky/pull/1220)
- Updated: Component `m` is renamed to `mount` [#1226](https://github.com/luckyframework/lucky/pull/1226)
- Updated: Components with UrlHelpers like `current_page?` [#1228](https://github.com/luckyframework/lucky/pull/1228)
- Added: optional param routing [#1229](https://github.com/luckyframework/lucky/pull/1229)
- Updated: docs on `accept_format` [#1234](https://github.com/luckyframework/lucky/pull/1234)
- Updated: generator templates to use getter methods over instance variables [#1236](https://github.com/luckyframework/lucky/pull/1236)
- Updated: our community to use Discord for community [chat room](https://discord.gg/HeqJUcb) [#1237](https://github.com/luckyframework/lucky/pull/1237)
- Updated: compile-time error when path params are defined with dashes [#1238](https://github.com/luckyframework/lucky/pull/1238)
- Updated: path helpers to render query params even if default value is passed [#1239](https://github.com/luckyframework/lucky/pull/1239)
- Updated: `redirect_back` to disallow external referrers by default with config option [#1241](https://github.com/luckyframework/lucky/pull/1241)
- Updated: generated api apps will use `disable_cookies` by default [#535 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/535)
- Fixed: generating an app with the name "app" will raise an error [#543 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/543)
- Updated: `AppClient` renamed to `ApiClient` [#534 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/534)
- Updated: generated projects to use `--ignore-crystal-version` flag when running `shards install`. NOTE: this is a temporary update, and will be reverted in a future release. [Read Crystal Blog](https://crystal-lang.org/2020/08/20/preparing-our-shards-for-crystal-1.0.html) [See commit](https://github.com/luckyframework/lucky_cli/pull/547/files#diff-154806d6e0faa0b1aa1e518f3bbd3647R25)
- Added: ability to set default values on model columns [#424 in Avram](https://github.com/luckyframework/avram/pull/424)
- Added: `file_attribute` for operations to specify a file from params [#428 in Avram](https://github.com/luckyframework/avram/pull/428)
- Added: new `Database.delete` strategy for cleaning up data in specs [#426 in Avram](https://github.com/luckyframework/avram/pull/426)
- Added: `create_function` and `drop_function` to create SQL functions [#427 in Avram](https://github.com/luckyframework/avram/pull/427)
- Updated: `Avram::PostgresURL` renamed to `Avram::Credentials` with a new interface [#433 in Avram](https://github.com/luckyframework/avram/pull/433)
- Added: `create_trigger` and `drop_trigger` to create SQL triggers [#436 in Avram](https://github.com/luckyframework/avram/pull/436)
- Added: association `_count` method to easily return a count of a has_many association [#392 in Avram](https://github.com/luckyframework/avram/pull/392)
- Added: new `Pulsar` shard for pub/sub style communication in Lucky [See Pulsar](https://github.com/luckyframework/pulsar)
- Added: Pulsar instrumentation to Avram for subscribing to queries [#441 in Avram](https://github.com/luckyframework/avram/pull/441)
- Added: support for `Array(Float64)` in databases [#443 in Avram](https://github.com/luckyframework/avram/pull/443)
- Updated: `fill_existing_with` option on `add_belongs_to` in migrations [#444 in Avram](https://github.com/luckyframework/avram/pull/444)
- Added: `Box.build_attributes` method to build the attributes of a model in specs [#449 in Avram](https://github.com/luckyframework/avram/pull/449)
- Fixed: blank strings causing parse exceptions in save operations [#448 in Avram](https://github.com/luckyframework/avram/pull/448)
- Updated: LuckyRouter with many performance and structural refactors [#28](https://github.com/luckyframework/lucky_router/pull/28), [#30](https://github.com/luckyframework/lucky_router/pull/30), [#31](https://github.com/luckyframework/lucky_router/pull/31), [#32](https://github.com/luckyframework/lucky_router/pull/32)

### v0.23.1 (2020-07-07)

- Fixed: generated apps using deprecated `mount` instead of `m` [#531 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/531)

### v0.23.0 (2020-06-26)

- Updated: password reset tokens to be URL safe [#1118](https://github.com/luckyframework/lucky/pull/1118)
- Added: `radio` input helper [#1125](https://github.com/luckyframework/lucky/pull/1125)
- Added: component file paths to rendered comments in markup for development [#1126](https://github.com/luckyframework/lucky/pull/1126)
- Added: `query_param_declarations` method to Action classes [#1122](https://github.com/luckyframework/lucky/pull/1122)
- Fixed: generating a model that already exists now raises an error [#1127](https://github.com/luckyframework/lucky/pull/1127)
- Added: `select_prompt` helper method [#1124](https://github.com/luckyframework/lucky/pull/1124)
- Updated: `lucky routes` UI to now include query params [#1128](https://github.com/luckyframework/lucky/pull/1128)
- Added: `route_prefix` method for Actions to prefix all routes [#1121](https://github.com/luckyframework/lucky/pull/1121)
- Fixed: error when deleting cookies that don't exist [#1132](https://github.com/luckyframework/lucky/pull/1132)
- Fixed: handling ajax form submissions with TurboLinks [#1133](https://github.com/luckyframework/lucky/pull/1133)
- Fixed: issue with `ajax?` method not returning correct value [#1134](https://github.com/luckyframework/lucky/pull/1134)
- Fixed: security issue by escaping HTML helpers by default [#1135](https://github.com/luckyframework/lucky/pull/1135)
- Updated: `memoize` to allow for arguments, and `nil` and `false` values [#1139](https://github.com/luckyframework/lucky/pull/1139)
- Updated: model generator to provide more helpful error messages [#1140](https://github.com/luckyframework/lucky/pull/1140)
- Added: `get_raw` method to params along with striping blankspace on param `get` calls [#1144](https://github.com/luckyframework/lucky/pull/1144)
- Removed: `mount` with deprecation in favor of new `m` method.
- Added: `m` helper method as a `mount` replacement with a new interface. [#1151](https://github.com/luckyframework/lucky/pull/1151)
- Updated: `String#squish` method to be faster [#1159](https://github.com/luckyframework/lucky/pull/1159)
- Removed: `Lucky::SessionHandler` and `Lucky::FlashHandler`. [#518 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/518)
- Fixed: issue with session cookies not being written at the right time. [#1160](https://github.com/luckyframework/lucky/pull/1160)
- Added: `template` HTML method for `<template>` tags. [#1164](https://github.com/luckyframework/lucky/pull/1164)
- Fixed: flash messages being lost during multiple redirects. [#1169](https://github.com/luckyframework/lucky/pull/1169)
- Added: `redirect_back` for actions to redirect back to previous referrer [#1168](https://github.com/luckyframework/lucky/pull/1168)
- Added: `component` method to render a Component directly from an Action [#1172](https://github.com/luckyframework/lucky/pull/1172)
- Added: `canonical_link` HTML helper method. [#1182](https://github.com/luckyframework/lucky/pull/1182)
- Added: `disable_cookies` macro to stop cookies from being written on a specific action [#1180](https://github.com/luckyframework/lucky/pull/1180)
- Fixed: setting `samesite` on cookies in your `Lucky::CookieJar` `on_set` [#1183](https://github.com/luckyframework/lucky/pull/1183)
- Fixed: compilation bug in generated page when running `lucky gen.page` [#1191](https://github.com/luckyframework/lucky/pull/1191)
- Added: `multipart: true` option to `form_for` to set multipart enctype [#1200](https://github.com/luckyframework/lucky/pull/1200)
- Added: `Lucky.root` method to raise compile-time error directing people to use `Dir.current` instead. [#1206](https://github.com/luckyframework/lucky/pull/1206)
- Added: native CLI args to `LuckyCli::Task`. [#466 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/466)
- Updated: generated projects to disable StaticFileHandler directory listing by default. [#510 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/510)
- Updated: error action to return a 404 for `Avra::RecordNotFoundError` [#524 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/524)
- Fixed: `select_count` failing when postgres returns no counts. [#357 in Avram](https://github.com/luckyframework/avram/pull/357)
- Added: support for postgres extensions with `enable_extension`, `disable_extension`, and `update_extension`. [#356 in Avram](https://github.com/luckyframework/avram/pull/356)
- Added: enum support for models with `avram_enum` macro. [#339 in Avram](https://github.com/luckyframework/avram/pull/339)
- Fixed: the error message when using `remove` in migrations, and not passing a Symbol.
- Added: `rename` and `rename_belongs_to` in migrations [#366 in Avram](https://github.com/luckyframework/avram/pull/366)
- Added: new `lucky db.setup` task which runs `db.create` and `db.migrate`. [#361 in Avram](https://github.com/luckyframework/avram/pull/361)
- Added: ability to set a custom index name for table indices. [#386 in Avram](https://github.com/luckyframework/avram/pull/386)
- Fixed: using a custom primary key name of type `UUID`. [#401 in Avram](https://github.com/luckyframework/avram/pull/401)
- Added: checking for a connection to the PostgreSQL engine before running the `lucky db.create` task. [#397 in Avram](https://github.com/luckyframework/avram/pull/397)
- Fixed: logging issues related to Crystal 0.35.0. [#31 in Dexter](https://github.com/luckyframework/dexter/pull/31)
- Updated: which selenium library was being used for LuckyFlow. [#76 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/76)
- Added: initial work to support using other browsers aside from Chrome in LuckyFlow. [#79 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/79), [#88 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/88)
- Added: support to auto fetch latest webdrivers in LuckyFlow. [#80 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/80)
- Fixed: issue with really long stacktrace in LuckyFlow. [#83 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/83)
- Added: `have_text` expectation method for Flow specs. [#87 in LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/87)
- Added: optional path param routing. [#18 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/18)
- Update: routing to ensure matching dynamic fragments all work. [#23 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/23)
- Added: a little bit of speed to the routing lookup. [#26 in LuckyRouter](https://github.com/luckyframework/lucky_router/pull/26)
- Added: a new `validation` option to Habitat settings. [#49 in Habitat](https://github.com/luckyframework/habitat/pull/49)
- Renamed: the internal Habitat `Settings` class to `HabitatSettings` to avoid name conflicts in some Lucky apps. [#48 in Habitat](https://github.com/luckyframework/habitat/pull/48)
- Fixed: bug when setting a default value in a Habitat setting that could potentially raise an exception. [#51 in Habitat](https://github.com/luckyframework/habitat/pull/51)


### v0.22.0 (2020-06-17)

- Added: support for Crystal 0.35.0

### v0.21.0 (2020-04-19)

- Added: support for Crystal 0.34.0 `Log` class [#506 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/506/files)
- Added: `paginate_array` for paginating Arrays [#1108](https://github.com/luckyframework/lucky/pull/1108)
- Improve error logging [#1114](https://github.com/luckyframework/lucky/pull/1114)
- Improve http status logging [#1114](https://github.com/luckyframework/lucky/pull/1114)
- Upgraded: Dexter to v0.2.0
  - Type-safe log configuration
  - New JSON formatter
  - Helpers for testing logs
- Fix for issues with the system check in Procfile.dev [#505 in Lucky CLI](https://github.com/luckyframework/lucky_cli/pull/505)

### v0.20.0 (2020-04-08)

- Added: support for Crystal 0.34.0
- Fixed: error on some generated pages from missing sourcemap [#1019](https://github.com/luckyframework/lucky/pull/1019)
- Updated: `options_for_select` to accept more types [#295](https://github.com/luckyframework/lucky/pull/295)
- Added: ability to pass boolean attrs in link helper methods [#1032](https://github.com/luckyframework/lucky/pull/1032)
- Removed: setting `needs` with `?`. Lucky now generates a method ending in `?` for you when the type is `Bool` [#1034](https://github.com/luckyframework/lucky/pull/1034)
- Added: `needs` on pages can now be accessed by a method and not just instance variable [#1034](https://github.com/luckyframework/lucky/pull/1034)
- Removed: `link` helper method with a `String` path. [#1035](https://github.com/luckyframework/lucky/pull/1035)
- Added: new `Lucky::CookieNotFoundError` class. [#1038](https://github.com/luckyframework/lucky/pull/1038)
- Added: `cookies.deleted?()` method for checking if a cookie has been deleted. [#1040](https://github.com/luckyframework/lucky/pull/1040)
- Added: new `Lucky::Paginator` component with built-in styles for different different CSS frameworks. [#1020](https://github.com/luckyframework/lucky/pull/1020)
- Fixed: `needs` accidentally overwriting methods of the same name. [#1046](https://github.com/luckyframework/lucky/pull/1046)
- Updated: `label_for` to be a little more flexible with `nil` text. [#1047](https://github.com/luckyframework/lucky/pull/1047)
- Updated: resource generator to be a little easier to read and digest. [#1050](https://github.com/luckyframework/lucky/pull/1050)
- Updated: development `ENV` now uses `ENV["DEV_PORT"]` instead of `ENV["PORT"]` to fix issues with process managers. [#1051](https://github.com/luckyframework/lucky/pull/1051)
- Added: new `Lucky::CatchUnpermittedAttribute` mixin for `Shared::Field` component. [#1052](https://github.com/luckyframework/lucky/pull/1052)
- Added: new methods in Actions for accessing params from different sources like `from_json`, `from_query`, `from_form`, and `from_multipart`. [#1053](https://github.com/luckyframework/lucky/pull/1053)
- Updated: generated pages to have some default text pointing to the location of the file to edit. [#1057](https://github.com/luckyframework/lucky/pull/1057)
- Fixed: incorrect pluralization of resources on `NewPage`. [#1058](https://github.com/luckyframework/lucky/pull/1058)
- Updated: all action "callbacks" are officially named "pipes". All pipes only log when halted by default. [#1062](https://github.com/luckyframework/lucky/pull/1062)
- Updated: the `lucky dev` watcher does not print which file changes because you know you just changed that file. [#1065](https://github.com/luckyframework/lucky/pull/1065)
- Added: a new HTTP handler to set the `request.remote_address` if the `X-Forwarded-For` header is set. [#1059](https://github.com/luckyframework/lucky/pull/1059)
- Added: a `current_page?` helper method for pages. [#1074](https://github.com/luckyframework/lucky/pull/1074)
- Added: `FormFields` component for generated resources. [#1081](https://github.com/luckyframework/lucky/pull/1081)
- Updated: all HTML tag methods explicitly return `Nil` now. [#1083](https://github.com/luckyframework/lucky/pull/1083)
- Updated: page markup to render directly to the IO instead of creating an additional string. [#1084](https://github.com/luckyframework/lucky/pull/1084)
- Added: `String#squish` method. [#1085](https://github.com/luckyframework/lucky/pull/1085)
- Updated: error message from returning invalid type in Actions. [#1086](https://github.com/luckyframework/lucky/pull/1086)
- Added: ability to set custom directory when generating a new Lucky project [See LuckyCli](https://github.com/luckyframework/lucky_cli/pull/464)
- Added: ability to set your postgres DB port with ENV var. [See LuckyCli](https://github.com/luckyframework/lucky_cli/pull/469)
- Added: a `robots.txt` file to generated web apps by default. [See LuckyCli](https://github.com/luckyframework/lucky_cli/pull/472)
- Added: new compiling spinner graphic for a cleaner UX. [See LuckyCli](https://github.com/luckyframework/lucky_cli/pull/481)
- Updated: some comments on the generated main app file. [See LuckyCli](https://github.com/luckyframework/lucky_cli/pull/484)
- Added: lots of internal documentation. (many small commits to LuckyCli)
- Updated: generated `UserSerializer` to inherit from `BaseSerializer`. [See LuckyCli](https://github.com/luckyframework/lucky_cli/pull/489)
- Updated: cookies to default to `http_only`. [See LuckyCli](https://github.com/luckyframework/lucky_cli/pull/491)
- Updated: node dependencies in generated web apps. [See LuckyCli](https://github.com/luckyframework/lucky_cli/pull/493)
- Added: new `system_check` script along with some refactors to make checking that your app is setup a lot easier. [See LuckyCli](https://github.com/luckyframework/lucky_cli/pull/482)
- Removed: ability to pass a raw hash to an `Avram::SaveOperation`. [See Avram](https://github.com/luckyframework/avram/pull/312)
- Added: ability to `skip_schema_enforcer` for certain models. [See Avram](https://github.com/luckyframework/avram/pull/314)
- Added: `Avram::Model#reload` to reload all of the attributes that may have been updated since the instance was created. [See Avram](https://github.com/luckyframework/avram/pull/324)
- Added: `Query#reset_where` to reset the WHERE clause on a specific column. [See Avram](https://github.com/luckyframework/avram/pull/325)
- Added: logging queries that fail. [See Avram](https://github.com/luckyframework/avram/pull/326)
- Fixed: using `fill_existing_with` when you already had data in your table. [See Avram](https://github.com/luckyframework/avram/pull/328)
- Added: bulk updating records straight from a query object. [See Avram](https://github.com/luckyframework/avram/pull/329)
- Added: new "soft delete" feature. [See Avram](https://github.com/luckyframework/avram/pull/323)
- Fixed: saving empty array columns when the column can't be `nil`, but it can be `[]`. [See Avram](https://github.com/luckyframework/avram/pull/330)
- Updated: `SaveOperation.new` to set attributes directly. [See Avram](https://github.com/luckyframework/avram/pull/332)
- Removed: the `on` option for `needs` in `SaveOperation`. [See Avram](https://github.com/luckyframework/avram/pull/332)
- Fixed: connecting to databases running on a unix domain socket. [See Avram](https://github.com/luckyframework/avram/pull/333)
- Added: new shard for turning an Avram column in to a URL slug. [AvramSlugify](https://github.com/luckyframework/avram_slugify)

### v0.19.0 (2020-02-29)

- Added: missing docs for time helpers [#943](https://github.com/luckyframework/lucky/pull/943)
- Added: HTML boolean attributes to checkbox and textarea helpers [#955](https://github.com/luckyframework/lucky/pull/955)
- Fixed: generated templates with proper naming conventions [#956](https://github.com/luckyframework/lucky/pull/956)
- Added: `to_param` for `UUID` allowing UUID to be passed in params [#945](https://github.com/luckyframework/lucky/pull/945)
- Updated: watcher error message to be a little less abrupt [#968](https://github.com/luckyframework/lucky/pull/968)
- Updated: generated migrations using the `table_for` macro [#970](https://github.com/luckyframework/lucky/pull/970)
- Fixed: using `with_defaults` when the tag has content [#972](https://github.com/luckyframework/lucky/pull/972)
- Added: `any?` and `empty?` to `flash` [#977](https://github.com/luckyframework/lucky/pull/977)
- Fixed: allowing `false` values for `needs` [#979](https://github.com/luckyframework/lucky/pull/979)
- Updated: `needs` to now infer a value of `nil` when the type is nilable [#980](https://github.com/luckyframework/lucky/pull/980)
- Fixed: allowing the `-h` flag for the watch task [#958](https://github.com/luckyframework/lucky/pull/958)
- Added: gzip response for assets when it's configured [#983](https://github.com/luckyframework/lucky/pull/983)
- Added: Lucky API docs are now generated from the CI which is deployed to Github pages [#989](https://github.com/luckyframework/lucky/pull/989)
- Fixed: when using `needs` with different values in random order and Lucky would not compile [#993](https://github.com/luckyframework/lucky/pull/993)
- Added: more context to the resource generator [See commit](https://github.com/luckyframework/lucky/commit/ae7301750c9b49c99d5b530ddc93cda91e73f288)
- Added: ability to pass Crystal's `--error-tace` flag to `lucky watch` [#957](https://github.com/luckyframework/lucky/pull/957)
- Fixed: generating resource.browser when using a `JSON::Any` column type [#997](https://github.com/luckyframework/lucky/pull/997)
- Fixed: issue when using HTML boolean attributes with custom tags [#1010](https://github.com/luckyframework/lucky/pull/1010)
- Added: the option to define columns in the model generator [#1009](https://github.com/luckyframework/lucky/pull/1009)
- Updated: permitting columns generated from the resource generator [#1014](https://github.com/luckyframework/lucky/pull/1014)
- Added: new `to_prepared_sql` method to generate fully prepared sql for debugging [See Avram](https://github.com/luckyframework/avram/pull/264)
- Fixed: cloning distinct queries [See Avram](https://github.com/luckyframework/avram/pull/285)
- Added: new predicate methods variants for boolean columns [See Avram](https://github.com/luckyframework/avram/pull/300)
- Added: new `changed?`, `changes`, and `original_value` methods for attributes in Operations [See Avram](https://github.com/luckyframework/avram/pull/295)
- Updated: `validate_size_of` and `validate_inclusion_of` to allow `nil` values [See Avram](https://github.com/luckyframework/avram/pull/299)
- Updated: error messages on some callbacks [See Avram](https://github.com/luckyframework/avram/pull/282)
- Fixed: `select_sum` when the column is any number type [See Avram](https://github.com/luckyframework/avram/pull/304)
- Fixed: issues with `has_one` when your model is namespaced, and how it's queried [See Avram](https://github.com/luckyframework/avram/pull/263)
- Fixed: aggregate query methods to work on all number types [See Avram](https://github.com/luckyframework/avram/pull/307)
- Fixed: bug when using a Box that had no columns [See Avram](https://github.com/luckyframework/avram/pull/310)
- Updated: preloads to only call when there are parent records. This is a query optimization update. [See Avram](https://github.com/luckyframework/avram/pull/306)


### v0.18.3 (2020-02-17)

- Added: support for Crystal 0.33.0

### v0.18.2 (2019-12-13)

- Added: support for Crystal 0.32.0

### v0.18.1 (2019-10-18)

- Fixed: debug page in development with reset context
- Updated: lucky exec works more like a REPL
- Updated: Log time measured with monotonic
- Fixed: Record deletion when primary key is UUID
- Fixed: Setting empty array as default to array column
- Added: Overflow cast catch from Int64 to Int32
- Fixed: UUID primary key issue in SaveOperation
- Fixed: required attribute validations on custom before_save callbacks
- Added: New `reset_limit` query method
- Added: New `reset_offset` query method

### v0.18.0 (2019-10-03)

- Added: support for Crystal 0.31.1
- Fixed: how accept / content-type headers are handled [#869](https://github.com/luckyframework/lucky/pull/869)
- Added: `ParamParsingError` for when parsing JSON params fails [#874](https://github.com/luckyframework/lucky/pull/874)
- Updated: `Lucky::BaseHTTPClient` [#875](https://github.com/luckyframework/lucky/pull/875)
- Updated: shell scripts for POSIX compliance [#879](https://github.com/luckyframework/lucky/pull/879)
- Added: `date_input`, `time_input`, `datetime_input` [#877](https://github.com/luckyframework/lucky/pull/877)
- Added: support for HTTP `PATCH` [#885](https://github.com/luckyframework/lucky/pull/885)
- Added: `abbr` HTML tag [#886](https://github.com/luckyframework/lucky/pull/886)
- Fixed: missing primary_key and timestamps in generated migrations [#888](https://github.com/luckyframework/lucky/pull/888)
- Fixed: `pluralize` to take any Int [#890](https://github.com/luckyframework/lucky/pull/890)
- Fixed: generation of migrations with resource [see Commit](https://github.com/luckyframework/lucky/commit/31848d916bdba9d2e6333e508ae2e95d9788263a)
- Rename: `Lucky::HttpRespondable` to `Lucky::RenderableError` [see Commit](https://github.com/luckyframework/lucky/commit/026f2e3bf9c1085376537c27bc2a28bfde590eb1)
- Fixed: `accepts_format`, and a few other mime type issues [#896](https://github.com/luckyframework/lucky/pull/896)
- Fixed: default curl requests to server not responding properly [#899](https://github.com/luckyframework/lucky/pull/899)
- Rename: `handle_error` to `render` in `ErrorAction` [#903](https://github.com/luckyframework/lucky/pull/903)
- Rename: `render` to `html` in Actions [#905](https://github.com/luckyframework/lucky/pull/905)
- Update: error message when missing type declaration for `needs` [#907](https://github.com/luckyframework/lucky/pull/907)
- Fixed: model generation allowing for non alphanumeric characters [#910](https://github.com/luckyframework/lucky/pull/910)
- Updated: make more errors renderable [#911](https://github.com/luckyframework/lucky/pull/911)
- Fixed: help messages now display for precompiled tasks [#923](https://github.com/luckyframework/lucky/pull/923)
- Updated: default help messages for tasks [#923](https://github.com/luckyframework/lucky/pull/923)
- Fixed: issue with precompile tasks running in some directories [#924](https://github.com/luckyframework/lucky/pull/924)
- Added: SQL logging [see Avram](https://github.com/luckyframework/avram/pull/213)
- Updated: error message when postgres isn't running [see Avram](https://github.com/luckyframework/avram/pull/218)
- Updated: `Box.create_pair` allows for setting attributes, and returns instances [see Avram](https://github.com/luckyframework/avram/pull/215)
- Added: ability to `clone` a query [see Avram](https://github.com/luckyframework/avram/pull/214)
- Fixed: `add_belongs_to` in alter statement using wrong Int size [see Avram](https://github.com/luckyframework/avram/pull/224)
- Fixed: incorrect error message from `SaveOperation` updates in 0.17 [see Avram](https://github.com/luckyframework/avram/pull/225)
- Added: `between` query method [see Avram](https://github.com/luckyframework/avram/pull/227)
- Added: ordering queries by `NULLS FIRST` and `NULLS LAST` [see Avram](https://github.com/luckyframework/avram/pull/228)
- Fixed: missing attributes from SaveOperation [see Avram](https://github.com/luckyframework/avram/pull/232)
- Added: `db.schema.restore` and `db.schema.dump` tasks [see Avram](https://github.com/luckyframework/avram/pull/216)
- Added: `group` query method for doing GROUP BY [see Avram](https://github.com/luckyframework/avram/pull/234)
- Updated: SchemaEnforcer [see Avram](https://github.com/luckyframework/avram/pull/237)
- Fixed: issue when calling `before` in SaveOperation [see Avram](https://github.com/luckyframework/avram/pull/240)
- Added: JWT auth generation for API apps [see LuckyCli](https://github.com/luckyframework/lucky_cli/pull/395)
- Updated: Serializers to be smarter with collections [see LuckyCli](https://github.com/luckyframework/lucky_cli/pull/397)
- Updated: webpack to ignore `node_modules` directory [see LuckyCli](https://github.com/luckyframework/lucky_cli/pull/401)
- Removed: cli `lucky init` task args [see LuckyCli](https://github.com/luckyframework/lucky_cli/pull/420)
- Added: new `lucky init.custom` task to take args as `init` did before.
- Fixed: `lucky init` to catch invalid project names properly.
- Added: support for `browser_binary` in LuckyFlow [see LuckyFlow](https://github.com/luckyframework/lucky_flow/pull/59)


### v0.17 (2019-08-13)

- Rename: `Avram::BaseForm` to `Avram::SaveOperation` [see Avram](https://github.com/luckyframework/avram/pull/104)
- Rename: `Avram::Field` to `Avram::Attribute` [see Avram](https://github.com/luckyframework/avram/commit/d3503a161670077c1d7b14484382132ea3ab423d)
- Update: `number_to_currency` now returns `String` instead of writing to the view directly. [#809](https://github.com/luckyframework/lucky/pull/809)
- Fixed: bug in running `build.release` task.
- Update: mounted components render comments to show start and end of component. [#817](https://github.com/luckyframework/lucky/pull/817)
- Revert: returning `String` for `highlight` helper. [#818](https://github.com/luckyframework/lucky/pull/818)
- Update: text helpers that write to the view moved to their own module. [#820](https://github.com/luckyframework/lucky/pull/820)
- Rename: `fillable` to `permit_columns`. [see Avram](https://github.com/luckyframework/avram/commit/b32b5a9b53688762e22c063ebad9f858cba636c0)
- Added: `skip_if` option to `LogHandler`. [#824](https://github.com/luckyframework/lucky/pull/824)
- Rename: `Lucky::Exposeable` to `Lucky::Exposable`. [#827](https://github.com/luckyframework/lucky/pull/827)
- Rename: `Lucky::Routeable` to `Lucky::Routable`. [#827](https://github.com/luckyframework/lucky/pull/827)
- Added: `memoize` macro. [#832](https://github.com/luckyframework/lucky/pull/832)
- Added: `table_for` macro. [see Avram](https://github.com/luckyframework/avram/pull/127)
- Added: `xml` render method for Actions. [#838](https://github.com/luckyframework/lucky/pull/838)
- Rename: `text` render action to `plain_text`. [#838](https://github.com/luckyframework/lucky/pull/838)
- Update: `responsive_meta_tag` to be flexible. [#835](https://github.com/luckyframework/lucky/pull/835)
- Added: `Int16#to_param` and `Int64#to_param`.
- Fixed: `append/replace_class` with no default. [#842](https://github.com/luckyframework/lucky/pull/842)
- Added: multi database support. [see Avram](https://github.com/luckyframework/avram/pull/136)
- Rename: `form_name` to `param_key`. [see Avram](https://github.com/luckyframework/avram/pull/140)
- Fixed: 3rd party shards versions. [#855](https://github.com/luckyframework/lucky/pull/855)
- Added: JSON support. [see Avram](https://github.com/luckyframework/avram/pull/108)
- Update: calling `first` ensures proper order by. [see Avram](https://github.com/luckyframework/avram/pull/118)
- Update: specifying primary keys is more explicit now. [see Avram](https://github.com/luckyframework/avram/commit/c6fe426a455fc1bf397d0b3b32069a97cd89d2df)
- Added: custom primary key name support. [see Avram](https://github.com/luckyframework/avram/commit/a97c2b7dba359dda775bc587458a3d00571979e9)
- Added: column and primary key support for `Int16`. [see Avram](https://github.com/luckyframework/avram/pull/131)
- Rename: `Query.destroy_all` to `Query.truncate`. [see Avram](https://github.com/luckyframework/avram/pull/134)
- Fixed: model inference with table names. [see Avram](https://github.com/luckyframework/avram/pull/144)
- Rename: `virtual` to `attribute`. [see Avram](https://github.com/luckyframework/avram/pull/112)
- Rename: `VirtualForm` to `Operation`. [see Avram](https://github.com/luckyframework/avram/commit/daaf55955c8131dea8533584720257ca444f23a7)
- Added: support for `Array` fields. [see Avram](https://github.com/luckyframework/avram/pull/151)
- Rename: association query methods now prefixed with `where_`. [see Avram](https://github.com/luckyframework/avram/commit/f298b8a2be2b0d9b753f33517093c72c261cd148)
- Added: query method to bulk delete. [see Avram](https://github.com/luckyframework/avram/pull/169)
- Update: association query methods no longer take a block. [see Avram](https://github.com/luckyframework/avram/commit/a8112f3b0abca05c06da0c3ba3f599dc6b06110b)
- Added: support for polymorphic associations. [see Avram](https://github.com/luckyframework/avram/pull/165)
- Added: `db.rollback_to` task. [see Avram](https://github.com/luckyframework/avram/pull/133)
- Added: `db.migrations.status` task. [see Avram](https://github.com/luckyframework/avram/pull/135)
- Added: `db.verify_connection` task. [see Avram](https://github.com/luckyframework/avram/pull/167)
- Fixed: calling `lucky -v` from a lucky project failed. [see CLI](https://github.com/luckyframework/lucky_cli/pull/387)
- Update: name convention for operations to be `VerbNoun`. [see CLI](https://github.com/luckyframework/lucky_cli/pull/386)
- Added: `change_type` macro for migrations. [see Avram](https://github.com/luckyframework/avram/pull/209)

### v0.16 (2019-08-03)

- Added: support for Crystal 0.30.0

### v0.15 (2019-06-12)

- Removed `Lucky::Action::Status`. Use Crystal's `HTTP::Status` enum. [#769](https://github.com/luckyframework/lucky/pull/769)
- CookieOverflowError is now checked when the cookie is set instead of later in middleware. [#761](https://github.com/luckyframework/lucky/pull/761)
- Crystal 0.29.0 support added
- Rename `Lucky::BaseApp` to `Lucky::BaseAppServer`
- Rename `Sentry` to `LuckySentry`
- **Breaking change** - Many text helpers now return a `String` instead of appending to the view (`cycle`, `excerpt`, `highlight`, `pluralize`, `time_ago_in_words`, `to_sentence`, `word_wrap`) [#781](https://github.com/luckyframework/lucky/pull/781)
- Added new asset host option [#795](https://github.com/luckyframework/lucky/pull/795)
- Added new secure header modules [#735](https://github.com/luckyframework/lucky/pull/735)
- Added fallback routing [#731](https://github.com/luckyframework/lucky/pull/731)
- Updated SSL Handler with HSTS option [#734](https://github.com/luckyframework/lucky/pull/734)
- Components are now classes instead of modules [#714](https://github.com/luckyframework/lucky/pull/714)
- Fixed `BaseHTTPClient` params [#726](https://github.com/luckyframework/lucky/pull/726)
- Fixed passing `Symbol` for statuses in redirects [#730](https://github.com/luckyframework/lucky/pull/730)
- More helpful errors [#733](https://github.com/luckyframework/lucky/pull/733), [#732](https://github.com/luckyframework/lucky/pull/732)


### v.0.14 (2019-04-18)

- Crystal 0.28.0 support added


### v0.13 (2019-02-27)

- Use [`Dexter`](https://github.com/luckyframework/dexter) as the logger. https://github.com/luckyframework/lucky_cli/pull/300 and https://github.com/luckyframework/lucky_cli/pull/299

- Move scripts from `bin` to `script`. Ignore all of `bin` directory in `.gitignore`. See https://github.com/luckyframework/lucky_cli/pull/288 and https://github.com/luckyframework/lucky_cli/pull/301

- `App` in `src/app.cr` should now inherit from `Lucky::BaseApp`. See https://github.com/luckyframework/lucky_cli/pull/287/files for an example.

- Prefix id params with the resource name [#659](https://github.com/luckyframework/lucky/issues/659)

- Added Action#url_without_query_params [#662](https://github.com/luckyframework/lucky/pull/662)

- Added `Lucky::AssetHelpers.load_manifest` so that API apps don't need a blank manifest to compile.

- Pages ignore unused exposures [#666](https://github.com/luckyframework/lucky/issues/666)

- `unexpose` and `unexpose_if_exposed` have been removed because they are no
longer necessary now that pages ignore unused exposures.

- `is` in queries has been renamed to `eq`. For example: `UserQuery.new.name.not.is("Emily")` should now be `UserQuery.new.name.not.eq("Emily")`. If passing in something that could be `Nil`, one must use `nilable_eq` instead. [avram#46](https://github.com/luckyframework/avram/pull/46)
