#!/usr/bin/env python3

p = 155831742289574177497932292801255799412489270364625225682554305308900221657836128751720836589191744095817066854125966744991441971144540406663499350284791479855695395713609452582250356243902115792855703393194480587581382458321437227241770475708672879454962976495503453421697945717382341369085411056491171749621
g = 127549068465986644069792173341286054760543803092629024516470566207367085606942823589487742577171887124132196151850281616779964941949684322569116751328900163633142911244264379083268861646928438462910288257473680310790275223651313204132623045142961869600512971718282445164671463699270549930704992590565201261511
pubA = 116237772647153706400363933487590602579780034530224624118840461773641223613450476036482832397589812959292379653478448907495884334620281479641157351104100729523076348895805114323476486946859811100074827892562522448334580928689518066632255792202171019785923472634606546756623605576773171574825836134572208523143
pubB = 38454245889798233677514846227045609238645062107911531708477922562426813475614910795533505468939168826306610352395204139126621966229853188553426296234838216454070062223533409728957577767410447078969429834790147995731395622877461135355138996932881840579730807166027970840879393543924133521414532764824417426830

def brute_force(p, g, pub1, pub2):
    for i in range(0, 1025):
        candidate_pub = pow(g, i, p)
        if candidate_pub == pub1:
            shared_secret = pow(pub2, i, p)
            return i, shared_secret
    return None, None

privA, shared1 = brute_force(p, g, pubA, pubB)
privB, shared2 = brute_force(p, g, pubB, pubA)

assert shared1 == shared2
print(f'privA: {privA}')
print(f'privB: {privB}')
print(f'shared_secret: {shared1}')