# Awesome AIGC Tutorials 

[![Awesome](https://camo.githubusercontent.com/64f8905651212a80869afbecbf0a9c52a5d1e70beab750dea40a994fa9a9f3c6/68747470733a2f2f617765736f6d652e72652f62616467652e737667)](https://github.com/luban-agi/awesome-aigc-tutorials) 
[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT) 
![](https://img.shields.io/github/last-commit/luban-agi/Awesome-AIGC-Tutorials?color=green)
[![GitHub Repo stars](https://img.shields.io/github/stars/luban-agi/Awesome-AIGC-Tutorials?style=social)](https://github.com/luban-agi/Awesome-AIGC-Tutorials)


[English](README.md) | 中文版

这里收集了关于AIGC的各种精选教程和资源，既适合初学者也适合进阶AI爱好者。

## 🌱 如何参与
我们非常欢迎你的加入，不论是修正、建议还是分享相关资源。详细的参与指南，请参考 [CONTRIBUTING_ZH.md](CONTRIBUTING_ZH.md) 文件。

## 📜 目录
- [👋 入门](#-入门)
- [💬 大语言模型](#-大语言模型)
  - [💡 提示工程](#-提示工程)
  - [🔧 大语言模型实践](#-大语言模型实践)
  - [🔬 大语言模型理论](#-大语言模型理论)
- [🎨 AI绘画](#-ai绘画)
  - [🧑‍🎨 艺术基础与AI绘画技巧](#-艺术基础与ai绘画技巧)
  - [🌊 Stable Diffusion原理与应用](#-stable-diffusion原理与应用) 
- [🔊 AI音频](#-ai音频)
- [🌈 多模态](#-多模态)
- [🧠 深度学习](#-深度学习)
- [💻 AI系统](#-ai系统)
- [🗂 其他](#-其他)
  - [✨ 点赞历史](#-点赞历史)
  - [🤝 友情链接](#-友情链接)


## 👋 入门
- [AI for Everyone - 吴恩达](https://www.deeplearning.ai/courses/ai-for-everyone/)
  ![](https://img.shields.io/badge/Level-简单-green)
  ![](https://img.shields.io/badge/视频-blue)
- [Practical AI for Teachers and Students - 沃顿商学院](https://www.youtube.com/playlist?list=PLwRdpYzPkkn302_rL5RrXvQE8j0jLP02j)
  ![](https://img.shields.io/badge/Level-简单-green)
  ![](https://img.shields.io/badge/视频-blue)
- [Artificial Intelligence for Beginners - 微软](https://microsoft.github.io/AI-For-Beginners/)
  ![](https://img.shields.io/badge/Level-中等-yellow)
- [Generative AI learning path - 谷歌](https://www.cloudskillsboost.google/journeys/118)
  ![](https://img.shields.io/badge/Level-中等-yellow)
  ![](https://img.shields.io/badge/视频-blue)

## 💬 大语言模型

### 💡 提示工程
- [ChatGPT Prompt Engineering for Developers - DeepLearning.AI](https://www.deeplearning.ai/short-courses/chatgpt-prompt-engineering-for-developers/)
  ![](https://img.shields.io/badge/Level-简单-green)
  ![](https://img.shields.io/badge/视频-blue) 
- [Building Systems with the ChatGPT API - DeepLearning.AI](https://www.deeplearning.ai/short-courses/building-systems-with-chatgpt/)
  ![](https://img.shields.io/badge/Level-简单-green)
  ![](https://img.shields.io/badge/视频-blue)
- [LangChain for LLM Application Development - DeepLearning.AI](https://www.deeplearning.ai/short-courses/langchain-for-llm-application-development/)
  ![](https://img.shields.io/badge/Level-简单-green)
  ![](https://img.shields.io/badge/Video-blue)
- [LangChain: Chat with Your Data - DeepLearning.AI](https://www.deeplearning.ai/short-courses/langchain-chat-with-your-data/)
  ![](https://img.shields.io/badge/Level-简单-green)
  ![](https://img.shields.io/badge/视频-blue)
- [Prompt Engineering for ChatGPT - 范德堡大学](https://www.coursera.org/learn/prompt-engineering?utm_medium=sem&utm_source=gg&utm_campaign=B2C_EMEA_prompt-engineering_vanderbilt_FTCOF_learn_country-GB-country-UK&campaignid=20462816306&adgroupid=157715342052&device=c&keyword=prompt%20engineering%20coursera&matchtype=b&network=g&devicemodel=&adposition=&creativeid=670151312123&hide_mobile_promo&gclid=Cj0KCQjwuZGnBhD1ARIsACxbAVg8RCaUF0lwFyVnMuP7T7bHoH0jST0XXhQ3S1vmDxtZc8O1WlJ8FXQaAtG-EALw_wcB)
  ![](https://img.shields.io/badge/Level-简单-green)
  ![](https://img.shields.io/badge/视频-blue)
- [Learn Prompting](https://learnprompting.org/)
  ![](https://img.shields.io/badge/Level-中等-yellow)
- [LangChain AI Handbook - James Briggs, Francisco Ingham](https://www.pinecone.io/learn/series/langchain/)
  ![](https://img.shields.io/badge/Level-中等-yellow)
  ![](https://img.shields.io/badge/书籍-%2391672c)
  
### 🔧 大语言模型实践
- [LLM Bootcamp - The Full Stack](https://fullstackdeeplearning.com/llm-bootcamp/spring-2023/)
  ![](https://img.shields.io/badge/Level-中等-yellow)
  ![](https://img.shields.io/badge/视频-blue)
- [Finetuning Large Language Models - DeepLearning.AI](https://www.deeplearning.ai/short-courses/finetuning-large-language-models/)
  ![](https://img.shields.io/badge/Level-中等-yellow)
  ![](https://img.shields.io/badge/视频-blue)

### 🔬 大语言模型理论
- [CS324 - Advances in Foundation Models - 斯坦福大学](https://stanford-cs324.github.io/winter2023/)
  ![](https://img.shields.io/badge/Level-简单-green)
  - 斯坦福大学关于大模型的新课，主要材料是一些notes，介绍了大语言模型的基础知识、能力范围、训练部署以及一些大模型相关的问题（数据安全、法律、危害等），总体来说比较简单，适合入门。2023年的版本对课纲进行了更新，增加了关于图像-文本和多模态的大模型内容。
- [CS 601.471/671 NLP: Self-supervised Models - 约翰霍普金斯大学](https://self-supervised.cs.jhu.edu/sp2023/index.html)
  ![](https://img.shields.io/badge/Level-中等-yellow)
  - JHU也是NLP大牛校，这门课难度适中，课程主页上各类资源还挺多的，建议大家看一看。 
- [CS224N: Natural Language Processing with Deep Learning - 斯坦福大学](https://web.stanford.edu/class/cs224n/)
  ![](https://img.shields.io/badge/Level-中等-yellow)
  ![](https://img.shields.io/badge/视频-blue)
  - 这门课Christopher Manning在斯坦福开了很多年，很经典的课程。前面是NLP的基础知识，后面几节课会涉及到大语言模型。 
- [Speech and Language Processing - Dan Jurafsky and James H. Martin](https://web.stanford.edu/~jurafsky/slp3/)
  ![](https://img.shields.io/badge/Level-中等-yellow)
  ![](https://img.shields.io/badge/书籍-%2391672c)
  - 最经典的NLP教材，本来计划在大概三四年前就完稿的，但是由于近几年NLP领域发展实在太快，作者干脆就不设DDL了，一直在持续更新中。 
- [COS 597G (Fall 2022): Understanding Large Language Models - 普林斯顿大学](https://www.cs.princeton.edu/courses/archive/fall22/cos597G/)
  ![](https://img.shields.io/badge/Level-困难-red)
  - Danqi Chen的课，课程难度较高，主要材料是PPT和相关的论文，适合深入LLM某个方向的同学。 

## 🎨 AI绘画

### 🧑‍🎨 艺术基础与AI绘画技巧
- [系列讲座:每周一个关于艺术基础的有趣话题 - Niji Academy](https://www.niji.academy/work/lecture) [[中文版]](https://mp.weixin.qq.com/s/CxEv5NQF_wzAtqXnuNbKog) ![](https://img.shields.io/badge/Level-简单-green)
- [AIGCTalk-Midjourney学习手册](https://ciweicui.feishu.cn/docx/DPbidgdBeoNw55xKjO6c7ao3nbc) ![](https://img.shields.io/badge/Level-简单-green)
- [【Midjourney】保姆级AI绘画创作系列教学课程 - 莱森](https://space.bilibili.com/630876766/channel/collectiondetail?sid=1045607) ![](https://img.shields.io/badge/Level-简单-green) ![](https://img.shields.io/badge/视频-blue)

### 🌊 Stable Diffusion原理与应用
- [【AI绘画】Stable Diffusion 系列教程](https://space.bilibili.com/12566101/channel/seriesdetail?sid=2706990) ![](https://img.shields.io/badge/Level-简单-green) ![](https://img.shields.io/badge/视频-blue)
  - 秋葉aaaki大神喂饭级别Stable Diffusion 系列教程
- [How Diffusion Models Work - DeepLearning.AI](https://www.deeplearning.ai/short-courses/how-diffusion-models-work/) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
- [扩散模型 - Diffusion Model - 李宏毅](https://www.bilibili.com/video/BV14c411J7f2/?vd_source=a4218e1e16a294070cadf4eefa94fa32) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
  - 偏宏观，比较通俗易懂 
- [Diffusion扩散模型 - 唐宇迪](https://www.bilibili.com/video/BV1Re4y1s7uV/?p=1&vd_source=a4218e1e16a294070cadf4eefa94fa32) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
  - 唐宇迪老师讲stable diffusion和dalle推理讲的比较清楚
- [Hugging Face Diffusion Models Course](https://github.com/huggingface/diffusion-models-class) ![](https://img.shields.io/badge/Level-中等-yellow)

## 🔊 AI音频
- [Hugging Face Audio Course](https://huggingface.co/learn/audio-course/chapter0/introduction) ![](https://img.shields.io/badge/Level-中等-yellow)
- [CS224S: Spoken Language Processing - 斯坦福大学](http://web.stanford.edu/class/cs224s/) ![](https://img.shields.io/badge/Level-中等-yellow)

## 🌈 多模态
- [Tutorial on MultiModal Machine Learning (ICML 2023) - 卡耐基梅隆大学](https://cmu-multicomp-lab.github.io/mmml-tutorial/icml2023/) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
- [11-777: MultiModal Machine Learning (Fall 2022) - 卡耐基梅隆大学](https://cmu-multicomp-lab.github.io/mmml-course/fall2022/) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
- [11-877: Advanced Topics in MultiModal Machine Learning (Fall 2022) - 卡耐基梅隆大学](https://cmu-multicomp-lab.github.io/adv-mmml-course/spring2022/) ![](https://img.shields.io/badge/Level-困难-red)

## 🧠 深度学习
- [Neural Networks/Deep Learning - StatQuest](https://www.youtube.com/playlist?list=PLblh5JKOoLUIxGDQs4LFFD--41Vzf-ME1) ![](https://img.shields.io/badge/Level-简单-green) ![](https://img.shields.io/badge/视频-blue)
- [Neural Networks - 3Blue1Brown](https://www.3blue1brown.com/topics/neural-networks) ![](https://img.shields.io/badge/Level-简单-green) ![](https://img.shields.io/badge/视频-blue)
- [Neural Networks: Zero to Hero - Andrej Karpathy](https://karpathy.ai/zero-to-hero.html) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
- [Practical Deep Learning for Coders - fast.ai](https://course.fast.ai/) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
- [Deep Learning Specialization - 吴恩达](https://www.deeplearning.ai/courses/deep-learning-specialization/) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
- [6.S191: Introduction to Deep Learning - 麻省理工学院](http://introtodeeplearning.com/) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
- [CS25: Transformers United V2 - 斯坦福大学](https://web.stanford.edu/class/cs25/) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
- [Deep Learning Lecture Series 2020 - DeepMind x 伦敦大学学院](https://www.deepmind.com/learning-resources/deep-learning-lecture-series-2020) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
- [Reinforcement Learning Lecture Series 2021 - DeepMind x 伦敦大学学院](https://www.deepmind.com/learning-resources/reinforcement-learning-lecture-series-2021) ![](https://img.shields.io/badge/Level-困难-red) ![](https://img.shields.io/badge/视频-blue)

## 💻 AI系统
- [AI-Sys-Sp22 Machine Learning Systems - 加州大学伯克利分校](https://ucbrise.github.io/cs294-ai-sys-sp22/) ![](https://img.shields.io/badge/Level-中等-yellow)
- [Deep Learning Systems: Algorithms and Implementation - Tianqi Chen, Zico Kolter](https://dlsyscourse.org/) ![](https://img.shields.io/badge/Level-中等-yellow) ![](https://img.shields.io/badge/视频-blue)
- [CS 329S: Machine Learning Systems Design - 斯坦福大学](https://stanford-cs329s.github.io/) ![](https://img.shields.io/badge/Level-中等-yellow)
- [15-849: Machine Learning Systems - 卡耐基梅隆大学](https://www.cs.cmu.edu/~zhihaoj2/15-849/) ![](https://img.shields.io/badge/Level-困难-red)
- [Computer Science 598D - Systems and Machine Learning - 普林斯顿大学](https://www.cs.princeton.edu/courses/archive/spring21/cos598D/general.html) ![](https://img.shields.io/badge/Level-困难-red)

## 🗂 其他

### ✨ 点赞历史
[![Star History Chart](https://api.star-history.com/svg?repos=luban-agi/Awesome-AIGC-Tutorials&type=Date)](https://star-history.com/#luban-agi/Awesome-AIGC-Tutorials&Date)

### 🤝 友情链接
- [WayToAGI](http://waytoagi.com/)
  - WaytoAGI.com 是最全面的中文AIGC资源知识库，包括最新AI动态、提示词、学习指南等，长期保持活跃更新。
- [Awesome Tool Learning](https://github.com/luban-agi/Awesome-Tool-Learning)
  - Awesome Tool Learning 提供丰富的关于工具学习的资源，包括论文、框架和应用程序。
- [Awesome Domain LLM](https://github.com/luban-agi/Awesome-Domain-LLM)
  - 这个GitHub仓库是一个汇集和整理了自ChatGPT等大语言模型出现后，各种垂直领域开源模型、数据集和评测基准的列表，同时鼓励大家为其贡献未收录的资源。

