# Awesome AIGC Tutorials 

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/luban-agi/awesome-aigc-tutorials) 
[![License: MIT](https://img.shields.io/badge/License-MIT-green.svg)](https://opensource.org/licenses/MIT) 
![](https://img.shields.io/github/last-commit/luban-agi/Awesome-AIGC-Tutorials?color=green)
[![GitHub Repo stars](https://img.shields.io/github/stars/luban-agi/Awesome-AIGC-Tutorials?style=social)](https://github.com/luban-agi/Awesome-AIGC-Tutorials)

English | [中文版](README_zh.md)


Awesome AIGC Tutorials houses a curated collection of tutorials and resources spanning across Large Language Models, AI Painting, and related fields. Discover in-depth insights and knowledge catered for both beginners and advanced AI enthusiasts.

## 🔔 Recent Updates

- [2024-02-18] - 🌈 Added new course: [CSCI-GA.3033-102 Special Topic - Learning with Large Language and Vision Models](https://www.sainingxie.com/llvm-fall23/) in Multimodal.
- [2024-02-14] - 💬 Added new course: [CS11-711 Advanced Natural Language Processing](https://phontron.com/class/anlp2024/) in Large Language Models.
- [2024-02-14] - 💬 Added new seminar: [AI-Systems (LLM Edition) 294-162](https://learning-systems.notion.site/learning-systems/AI-Systems-LLM-Edition-294-162-Fall-2023-661887583bd340fa851e6a8da8e29abb) in AI System.

## 🌱 How to Contribute

We warmly welcome contributions from everyone, whether you've found a typo, a bug, have a suggestion, or want to share a resource related to AIGC. For detailed guidelines on how to contribute, please see our [CONTRIBUTING.md](CONTRIBUTING.md) file.

## 📜 Content
- [👋 Introduction](#-introduction)
- [💬 Large Language Models](#-large-language-models)
  - [💡 Prompt Engineering](#-prompt-engineering)
  - [🔧 LLMs in Practice](#-llms-in-practice)
  - [🔬 Theory of LLMs](#-theory-of-llms)
- [🎨 AI Painting](#-ai-painting)
  - [🧑‍🎨 Art Fundamentals and AI Painting Techniques](#-art-fundamentals-and-ai-painting-techniques)
  - [🌊 Stable Diffusion Principles and Applications](#-stable-diffusion-principles-and-applications)
- [🔊 AI Audio](#-ai-audio)
- [🌈 Multimodal](#-multimodal)
- [🧠 Deep Learning](#-deep-learning)
- [💻 AI System](#-ai-system)
- [🗂 Miscellaneous](#-miscellaneous)
  - [✨ Star History](#-star-history)
  - [🤝 Friendship Links](#-friendship-links)

## 👋 Introduction
- [AI for Everyone - Andrew Ng](https://www.deeplearning.ai/courses/ai-for-everyone/)
  ![](https://img.shields.io/badge/Level-Easy-green)
  ![](https://img.shields.io/badge/Video-blue)
  - "AI for Everyone" is a beginner's guide to understanding AI's practical applications, its limitations, and its societal impact, ideal for business professionals and leaders alike.
- [Practical AI for Teachers and Students - Wharton School](https://www.youtube.com/playlist?list=PLwRdpYzPkkn302_rL5RrXvQE8j0jLP02j)
  ![](https://img.shields.io/badge/Level-Easy-green)
  ![](https://img.shields.io/badge/Video-blue)
  - Wharton Interactive's crash course delves into the mechanics and impacts of LLMs, spotlighting models like OpenAI's ChatGPT4, Microsoft's Bing in Creative Mode, and Google's Bard. 
- [Artificial Intelligence for Beginners - Microsoft](https://microsoft.github.io/AI-For-Beginners/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  - This 12-week Microsoft curriculum dives deep into AI methodologies, spanning symbolic AI to neural networks, while highlighting TensorFlow and PyTorch frameworks, yet omits business applications, classic machine learning, and certain cloud-specific topics.
- [Generative AI learning path - Google Cloud](https://www.cloudskillsboost.google/journeys/118)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - This learning path offers a comprehensive journey from the basics of Large Language Models to deploying generative AI solutions on Google Cloud. 

## 💬 Large Language Models

### 💡 Prompt Engineering
- [ChatGPT Prompt Engineering for Developers - DeepLearning.AI](https://www.deeplearning.ai/short-courses/chatgpt-prompt-engineering-for-developers/) ![](https://img.shields.io/badge/Level-Easy-green)
  ![](https://img.shields.io/badge/Video-blue)
  ![](https://img.shields.io/badge/Notebook-orange)
  - Co-taught by OpenAI and DeepLearning.AI, this course guides learners in leveraging Large Language Models for tasks like summarizing and text transformation, with hands-on experiences in a Jupyter notebook environment.
- [Building Systems with the ChatGPT API - DeepLearning.AI](https://www.deeplearning.ai/short-courses/building-systems-with-chatgpt/)
  ![](https://img.shields.io/badge/Level-Easy-green)
  ![](https://img.shields.io/badge/Video-blue)
  ![](https://img.shields.io/badge/Notebook-orange)
  - Led by experts from OpenAI and DeepLearning.AI, this course teaches automating workflows using language models, creating prompt chains, integrating Python, and designing chatbots, all through hands-on Jupyter notebook exercises with just basic Python knowledge required.
- [LangChain for LLM Application Development - DeepLearning.AI](https://www.deeplearning.ai/short-courses/langchain-for-llm-application-development/)
  ![](https://img.shields.io/badge/Level-Easy-green)
  ![](https://img.shields.io/badge/Video-blue)
  ![](https://img.shields.io/badge/Notebook-orange)
  - Guided by the creator of LangChain and Andrew Ng, this course dives into advanced LLM techniques like chaining operations and using models as reasoning agents, empowering learners to craft robust applications quickly with foundational Python knowledge.
- [LangChain: Chat with Your Data - DeepLearning.AI](https://www.deeplearning.ai/short-courses/langchain-chat-with-your-data/)
  ![](https://img.shields.io/badge/Level-Easy-green)
  ![](https://img.shields.io/badge/Video-blue)
  ![](https://img.shields.io/badge/Notebook-orange)
  - Delve into Retrieval Augmented Generation and chatbot creation based on document content with LangChain, covering data loading, splitting, embeddings, advanced retrieval techniques, and interactive chatbot building, designed for Python-savvy developers keen on harnessing Large Language Models.
- [Prompt Engineering for ChatGPT - Vanderbilt University](https://www.coursera.org/learn/prompt-engineering?utm_medium=sem&utm_source=gg&utm_campaign=B2C_EMEA_prompt-engineering_vanderbilt_FTCOF_learn_country-GB-country-UK&campaignid=20462816306&adgroupid=157715342052&device=c&keyword=prompt%20engineering%20coursera&matchtype=b&network=g&devicemodel=&adposition=&creativeid=670151312123&hide_mobile_promo&gclid=Cj0KCQjwuZGnBhD1ARIsACxbAVg8RCaUF0lwFyVnMuP7T7bHoH0jST0XXhQ3S1vmDxtZc8O1WlJ8FXQaAtG-EALw_wcB)
  ![](https://img.shields.io/badge/Level-Easy-green)
  ![](https://img.shields.io/badge/Video-blue)
  - Unlock the potential of Large Language Models like ChatGPT by mastering prompt engineering, transitioning from basic to sophisticated prompts, enabling diverse applications ranging from writing to simulation, suitable for anyone with basic computer skills.
- [Prompt Engineering Guide - DAIR.AI](https://www.promptingguide.ai/)
  ![](https://img.shields.io/badge/Level-Easy-green) 
  - This guide introduces Prompt Engineering, a discipline that optimizes interactions with Large Language Models, offering extensive resources, research, and tools.
- [Learn Prompting](https://learnprompting.org/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  - Dive into a beginner-friendly guide on Generative AI and Prompt Engineering, offering insights from industry giants, and explore how these tools revolutionize content creation and the future of work.
- [LangChain AI Handbook - James Briggs and Francisco Ingham](https://www.pinecone.io/learn/series/langchain/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Book-%2391672c)
  - Explore the transformative world of LangChain, mastering core components, crafting effective prompts, and harnessing advanced AI agents, conversational memories, and custom tools for cutting-edge applications. 

### 🔧 LLMs in Practice
- [LLM Bootcamp - The Full Stack](https://fullstackdeeplearning.com/llm-bootcamp/spring-2023/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - Delve deep into prompt engineering, LLM operations, user experience design for language interfaces, augmented language model techniques, foundational LLM insights, hands-on projects, and the future of LLMs, complemented by expert talks from industry leaders on training and agent design.
- [Finetuning Large Language Models - DeepLearning.AI](https://www.deeplearning.ai/short-courses/finetuning-large-language-models/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  ![](https://img.shields.io/badge/Notebook-orange)
  - Learn the techniques of finetuning large language models (LLMs) with Sharon Zhou, gaining expertise in data preparation, training, and updating neural net weights for improved results tailored to your data.
- [CS25: Transformers United V3 - Stanford University](https://web.stanford.edu/class/cs25/index.html)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - This course delves into the transformative role of Transformers in deep learning, particularly their impact on the advancement of language models like ChatGPT and GPT-4.
- [Learn the fundamentals of generative AI for real-world applications - AWS x DeepLearning.AI](https://www.deeplearning.ai/courses/generative-ai-with-llms/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - This course, in partnership with AWS, offers deep insights into generative AI and Large Language Models (LLMs). Participants will learn the mechanics, optimization, and real-world applications of LLMs from AWS AI experts. Suitable for professionals in AI and machine learning, with a Coursera certificate upon completion. Basic Python and machine learning knowledge recommended.

### 🔬 Theory of LLMs
- [CS324 - Advances in Foundation Models - Stanford University](https://stanford-cs324.github.io/winter2023/)
  ![](https://img.shields.io/badge/Level-Easy-green)
  - CS 324 delves into foundation models like GPT-3 and DALL-E, covering their principles, systems, ethics, and application, and culminates in a hands-on research project or application design.
- [CS11-711 Advanced Natural Language Processing - Carnegie Mellon University](https://phontron.com/class/anlp2024/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  - CMU's Advanced NLP course explores modern neural methods for understanding and innovating in natural language processing.
- [CS 601.471/671 NLP: Self-supervised Models - Johns Hopkins University](https://self-supervised.cs.jhu.edu/sp2024/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  - This course offers an in-depth exploration of self-supervised learning techniques for NLP, training students to design and implement neural network models using PyTorch, with a focus on various language model architectures.
- [11-667: Large Language Models Methods and Applications - Carnegie Mellon University](https://cmu-llms.org/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  - This graduate course offers a comprehensive overview of large language models (LLMs), covering basics, emergent capabilities, applications, scaling techniques, deployment concerns, and future challenges, equipping students for research and applications in the AI era.
- [CS224N: Natural Language Processing with Deep Learning - Stanford University](https://web.stanford.edu/class/cs224n/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - This course provides a comprehensive insight into Deep Learning for NLP using PyTorch, emphasizing end-to-end neural models, eliminating the need for task-specific feature engineering, and equipping students with the skills to craft their own neural network solutions.
- [TinyML and Efficient Deep Learning Computing - Massachusetts Institute of Technology](https://hanlab.mit.edu/courses/2023-fall-65940?schedule)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - This course explores efficient AI computing techniques for deep learning on constrained devices, covering model compression, pruning, quantization, architecture search, distributed training, and quantum machine learning, with hands-on deployment of large models like LLaMA 2 on laptops.
- [Speech and Language Processing - Dan Jurafsky and James H. Martin](https://web.stanford.edu/~jurafsky/slp3/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Book-%2391672c)
  - Authored by leading experts in the field, this authoritative text provides an in-depth exploration of the algorithms and mathematical models for modern natural language processing and speech recognition, and is continually updated to reflect the rapid advancements in the NLP domain.
- [COS 597G (Fall 2022): Understanding Large Language Models - Princeton University](https://www.cs.princeton.edu/courses/archive/fall22/cos597G/)
  ![](https://img.shields.io/badge/Level-Hard-red)
  - An advanced exploration into the transformative realm of LLMs, discussing state-of-the-art models, their profound capabilities, and associated challenges, with an emphasis on in-depth research, ethical considerations, and hands-on project experience, tailored for seasoned students versed in machine learning and deep NLP frameworks.

## 🎨 AI Painting

### 🧑‍🎨 Art Fundamentals and AI Painting Techniques
- [Lecture Series: An interesting topic every week on the fundamentals of art - Niji Academy](https://www.niji.academy/work/lecture)
  ![](https://img.shields.io/badge/Level-Easy-green)
  - Niji Academy blends art fundamentals with AI, elevating painting skills and speeding up art learning.
 
### 🌊 Stable Diffusion Principles and Applications

- [How Diffusion Models Work - DeepLearning.AI](https://www.deeplearning.ai/short-courses/how-diffusion-models-work/)
  ![](https://img.shields.io/badge/Level-Medium-yellow) ![](https://img.shields.io/badge/Video-blue)
  ![](https://img.shields.io/badge/Notebook-orange)
  - Master generative AI in 'How Diffusion Models Work', an intermediate course by Sharon Zhou, where you'll craft diffusion models from scratch, enriched with hands-on coding and labs, ideal for those proficient in Python, Tensorflow, or Pytorch.
- [Hugging Face Diffusion Models Course](https://github.com/huggingface/diffusion-models-class)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Notebook-orange)
  - The Hugging Face course offers an in-depth look into diffusion models, guiding participants through media generation, hands-on training, and customization using the Diffusers library, with a foundational understanding of Python and Deep Learning essential for the best experience.
- [Practical Deep Learning for Coders part 2: Deep Learning Foundations to Stable Diffusion - fast.ai](https://course.fast.ai/Lessons/part2.html)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - This course offers an in-depth exploration of Stable Diffusion algorithms, covering advanced deep learning techniques and hands-on projects using PyTorch, empowering students with expertise in cutting-edge diffusion models. 

## 🔊 AI Audio
- [Hugging Face Audio Course](https://huggingface.co/learn/audio-course/chapter0/introduction)
  ![](https://img.shields.io/badge/Level-Medium-yellow) 
  - The Hugging Face Audio course teaches how to use transformers for various audio tasks, from speech recognition to generating speech from text, combining theory with hands-on exercises for learners familiar with deep learning.
- [CS224S: Spoken Language Processing - Stanford University](http://web.stanford.edu/class/cs224s/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  - An immersive course on spoken language technology, covering dialog systems, deep learning in speech recognition and synthesis, with hands-on projects using modern tools like PyTorch, Alexa Skills Kit, and SpeechBrain, culminating in student-driven research or system design projects. 
 
## 🌈 Multimodal
- [CSCI-GA.3033-102 Special Topic - Learning with Large Language and Vision Models](https://www.sainingxie.com/llvm-fall23/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  - Graduate course on the impact of large language and vision models, covering multimodal and generative AI, and preparing students for AI research.
- [Tutorial on MultiModal Machine Learning (ICML 2023) - Carnegie Mellon University](https://cmu-multicomp-lab.github.io/mmml-tutorial/icml2023/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - This course offers an in-depth look at Multimodal Machine Learning, drawing insights from the latest edition of a survey paper and CMU's academic teachings, addressing its unique challenges and future directions. 
- [11-777: MultiModal Machine Learning (Fall 2022) - Carnegie Mellon University](https://cmu-multicomp-lab.github.io/mmml-course/fall2022/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - This course delves into Multimodal Machine Learning (MMML), covering its mathematical foundations, state-of-the-art probabilistic models, and key challenges, while highlighting recent applications and techniques such as multimodal transformers and neuro-symbolic models. 
- [11-877: Advanced Topics in MultiModal Machine Learning (Fall 2022) - Carnegie Mellon University](https://cmu-multicomp-lab.github.io/adv-mmml-course/spring2022/)
  ![](https://img.shields.io/badge/Level-Hard-red)
  - This course explores Multimodal Machine Learning (MMML), covering technical challenges and recent achievements. It emphasizes critical thinking and future research trends, with weekly updates, discussion probes, and research highlights on the course website. 

## 🧠 Deep Learning
- [Neural Networks/Deep Learning - StatQuest](https://www.youtube.com/playlist?list=PLblh5JKOoLUIxGDQs4LFFD--41Vzf-ME1)
  ![](https://img.shields.io/badge/Level-Easy-green)
  ![](https://img.shields.io/badge/Video-blue)
  - Discover the intricacies of Neural Networks in this highly popular YouTube playlist, seamlessly blending informative graphics with expert teachings, captivating countless students from basics to advanced image classification with Convolutional Neural Networks.
- [Neural Networks - 3Blue1Brown](https://www.3blue1brown.com/topics/neural-networks)
  ![](https://img.shields.io/badge/Level-Easy-green)
  ![](https://img.shields.io/badge/Video-blue)
  - 3Blue1Brown unveils the magic of neural networks through vivid animations and clear explanations, diving deep into hand-written digit recognition, the nuances of gradient descent, and the intricate calculus behind backpropagation. 
- [Neural Networks: Zero to Hero - Andrej Karpathy](https://karpathy.ai/zero-to-hero.html)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - Andrej Karpathy's course guides students from the foundational backpropagation to advanced neural networks like GPT, emphasizing language models as a versatile gateway to mastering deep learning, with prerequisites in Python programming and basic math. 
- [Practical Deep Learning for Coders - fast.ai](https://course.fast.ai/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - Practical Deep Learning for Coders 2022 is a free course offering hands-on experience in building, training, and deploying deep learning models across various domains using tools like PyTorch and fastai, suitable for those with coding knowledge and without the need for advanced math. 
- [Deep Learning Specialization - Andrew Ng](https://www.deeplearning.ai/courses/deep-learning-specialization/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - Andrew Ng's Deep Learning Specialization is a top-rated, self-paced program on Coursera with over 1 million learners, offering clear modules and practical techniques in AI, supported by a vast community and breaking down the latest in machine learning into understandable content.
- [6.S191: Introduction to Deep Learning - Massachusetts Institute of Technology](http://introtodeeplearning.com/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - MIT's intensive bootcamp on deep learning fundamentals, covering applications from computer vision to biology, with hands-on TensorFlow practice and a culminating project competition. Basic calculus and linear algebra knowledge required; Python experience beneficial. 
- [CS25: Transformers United V2 - Stanford University](https://web.stanford.edu/class/cs25/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - Explore the transformative power of transformers in deep learning across diverse domains, from NLP to biology, in a seminar featuring expert lectures, breakthrough discussions, and insights from leading researchers, aiming to foster understanding and cross-collaborative innovation.
- [Deep Learning Lecture Series 2020 - DeepMind x University College London](https://www.deepmind.com/learning-resources/deep-learning-lecture-series-2020)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - DeepMind presents a 12-lecture series on Deep Learning, diving from foundational topics to advanced techniques, encompassing areas from object recognition to responsible AI innovation, all delivered by leading research experts.
- [Reinforcement Learning Lecture Series 2021 - DeepMind x University College London](https://www.deepmind.com/learning-resources/reinforcement-learning-lecture-series-2021)
  ![](https://img.shields.io/badge/Level-Hard-red)
  ![](https://img.shields.io/badge/Video-blue)
  - DeepMind and UCL present a comprehensive 13-lecture series on modern reinforcement learning, from foundational concepts to advanced deep RL techniques, led by expert researchers Hado van Hasselt, Diana Borsa, and Matteo Hessel.
  
## 💻 AI System
- [AI-Sys-Sp22 Machine Learning Systems - University of California, Berkeley](https://ucbrise.github.io/cs294-ai-sys-sp22/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  - Delve into the symbiotic relationship between cutting-edge AI applications and the systems supporting them, exploring advancements in hardware, software, and AI-driven optimization techniques, through lectures, discussions, and collaborative hands-on projects.
- [Deep Learning Systems: Algorithms and Implementation - Tianqi Chen, Zico Kolter](https://dlsyscourse.org/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  ![](https://img.shields.io/badge/Video-blue)
  - Explore the foundations of deep learning systems by constructing a complete library, understanding every layer from model design to efficient algorithms, utilizing Python and C/C++. 
- [CS 329S: Machine Learning Systems Design - Stanford University](https://stanford-cs329s.github.io/)
  ![](https://img.shields.io/badge/Level-Medium-yellow)
  - Master the intricacies of designing robust, scalable, and deployable machine learning systems, focusing on stakeholders, evolving requirements, and holistic system design, while addressing critical issues like privacy, fairness, and security.
- [AI-Systems (LLM Edition) 294-162 - University of California, Berkeley](https://learning-systems.notion.site/learning-systems/AI-Systems-LLM-Edition-294-162-Fall-2023-661887583bd340fa851e6a8da8e29abb)
  ![](https://img.shields.io/badge/Level-Hard-red)
  - This course delves into the nexus of hardware/software advancements and generative AI, emphasizing how these innovations propel the scaling and capabilities of AI models.
- [15-849: Machine Learning Systems - Carnegie Mellon University](https://www.cs.cmu.edu/~zhihaoj2/15-849/)
  ![](https://img.shields.io/badge/Level-Hard-red)
  - Dive into the architecture of modern ML systems, unraveling the journey from high-level model design to low-level kernel execution on heterogeneous hardware, while uncovering the principles and challenges of next-gen ML applications and platforms. 
- [Computer Science 598D - Systems and Machine Learning - Princeton University](https://www.cs.princeton.edu/courses/archive/spring21/cos598D/general.html)
  ![](https://img.shields.io/badge/Level-Hard-red)
  - Explore the synergy between systems and machine learning by dissecting recent research on efficient ML hardware/software and applying ML to system design, culminating in hands-on projects and deep discussions for graduate students.

## 🗂 Miscellaneous

### ✨ Star History
[![Star History Chart](https://api.star-history.com/svg?repos=luban-agi/Awesome-AIGC-Tutorials&type=Date)](https://star-history.com/#luban-agi/Awesome-AIGC-Tutorials&Date)

### 🤝 Friendship Links
- [WayToAGI](http://waytoagi.com/)
  - WaytoAGI.com is the most comprehensive Chinese resource hub for AIGC, guiding users on an optimized learning journey to understand and harness the power of AI.
- [Codefuse-ChatBot](https://github.com/codefuse-ai/codefuse-chatbot)
  - Codefuse-ChatBot is an open-source AI smart assistant designed to support the software development lifecycle with conversational access to tools, knowledge, and platform integration.
- [Codefuse DevOps Eval](https://github.com/codefuse-ai/codefuse-devops-eval)
  - DevOps-Eval is a GitHub repository offering a specialized suite for evaluating and improving foundation models in the DevOps sector, including a rich set of AIOps exercises.
