<?php
namespace app\common\validate;
use think\Validate;
// QQ群：1085343903
// 个人QQ：741957916
class Uservalidate extends BaseValidate
{
    protected $rule =   [
        'user_name'  => 'require|max:30|min:6|chsDash',
        'user_pwd'   => 'require|alphaDash',
        'user_email'=>'require|email',
      'user_phone'=>'require|phone',
      'user_id'=>'require|number',
       'code'=>'require|number',
      'token'=>'require',
      'user_oldpwd'   => 'require|alphaDash',
      'icon'=> 'image',
    ];

    protected $message  =   [
        'user_name.require' => '用户名不能为空',
        'user_name.max'     => '名称最多不能超过30个字符',
        'user_name.min'     => '名称最少不能低于6个字符',
        'user_pwd.require'   => '密码不能为空',
      'user_email.require'=>'邮箱不能为空',
      'user_email.email'=>'邮箱格式不正确',
      'user_pwd.alphaDash'=>'密码只能是字母、数字和下划线_及破折号-',
      'user_name.chsDash'=>'用户名只能是汉字、字母、数字和下划线_及破折号-',
      'user_phone.phone'=>'手机号格式不正确',
      'user_phone.require'=>'手机号不能为空',
      'user_id.require'=>'用户ID不能为空',
      'user_id.number'=>'用户ID只能是数字',
      'code.require'=>'验证码不能为空',
      'code.number'=>'验证码只能是数字',
      'token.require'=>'token不能为空',
      'user_oldpwd.require'   => '旧密码不能为空',
      'user_oldpwd.alphaDash'   => '旧密码只能是字母、数字和下划线_及破折号-',
      //'icon.require'=>'请选择头像',
      //'icon.image'=>'图片格式不正确',
      //'icon.fileSize'=>'图片最大5M',
      //'icon.fileExt'=>'格式不正确',
    ];

    protected $scene = [
      'login'  =>  ['user_name','user_pwd'],
      'reg'  =>  ['user_name','user_pwd','user_email','code'],
      'xgmm'  =>  ['user_name','user_oldpwd','user_pwd','token'],
      'wjmm'  =>  ['user_name','user_email','code','user_pwd'],
      'xgzl'  =>  ['user_name','token'],
      'out'  =>  ['user_name','token'],
      'upimg' => ['user_name','token'],
    ];

}