<?php
namespace app\common\validate;
use think\Validate;
// QQ群：1085343903
// 个人QQ：741957916
class User extends BaseValidate
{
    protected $rule =   [
        'user_name'  => 'require|max:30|min:6',
        'user_pwd'   => 'require',
    ];

    protected $message  =   [
        'user_name.require' => '名称必须',
        'user_name.max'     => '名称最多不能超过30个字符',
        'user_name.min'     => '名称最少不能低于6个字符',
        'user_pwd.require'   => '密码必须',
    ];

    protected $scene = [
        'login'  =>  ['user_name','user_pwd'],
        'edit'  =>  ['user_name'],
    ];

}