<?php
namespace app\common\validate;
use think\Validate;
// QQ群：1085343903
// 个人QQ：741957916
class Commentvalidate extends BaseValidate
{
    protected $rule =   [
        'comment_name'  => 'require|max:60',
        'comment_content'   => 'require|max:255',
        'comment_mid' => 'require',
        'comment_rid' => 'require',
      'comment_pid' => 'require',
      'token'=>'require',
      'user_id'=>'require',
    ];

    protected $message  =   [
        'comment_name.require' => '昵称必须',
        'comment_name.max'     => '昵称最多不能超过60个字符',
        'comment_content.require'   => '内容必须',
        'comment_content.max'   => '内容最多不能超过255个字符',
        'comment_mid.require'   => '模块类型必须',
        'comment_rid.require'   => '关联id必须',
      'comment_pid.require'=>'评论等级不能为空',
      'user_id.require'=>'用户id不能为空',
    ];

    protected $scene = [
        'pl'=> ['comment_name','comment_content','comment_rid','token','comment_pid','user_id'],
        'lb'=> ['comment_rid'],
    ];
}