<?php
namespace app\admin\controller;
use think\Db;

class Cash extends Base
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $param = input();
        $param['page'] = intval($param['page']) <1 ? 1 : $param['page'];
        $param['limit'] = intval($param['limit']) <1 ? $this->_pagesize : $param['limit'];
        $where=[];
        if($param['status']!=''){
            $where['cash_status'] = ['eq',$param['status']];
        }
        if(!empty($param['uid'])){
            $where['user_id'] = ['eq',$param['uid'] ];
        }
        if(!empty($param['wd'])){
            $where['cash_bank_no'] = ['like','%'.$param['wd'].'%' ];
        }

        $order='cash_id desc';
        $res = model('Cash')->listData($where,$order,$param['page'],$param['limit']);

        $this->assign('list',$res['list']);
        $this->assign('total',$res['total']);
        $this->assign('page',$res['page']);
        $this->assign('limit',$res['limit']);

        $param['page'] = '{page}';
        $param['limit'] = '{limit}';
        $this->assign('param',$param);

        $this->assign('title','提现管理');
        return $this->fetch('admin@cash/index');
    }

    public function del()
    {
        $param = input();
        $ids = $param['ids'];
        $all = $param['all'];
        if(!empty($ids)){
            $where=[];
            $where['cash_id'] = ['in',$ids];
            if($all==1){
                $where['cash_id'] = ['gt',0];
            }
            $res = model('Cash')->delData($where);
            if($res['code']>1){
                return $this->error($res['msg']);
            }
            return $this->success($res['msg']);
        }
        return $this->error('参数错误');
    }

    public function audit()
    {
        $param = input();
        $ids = $param['ids'];
        if(!empty($ids)){
            $where=[];
            $where['cash_id'] = ['in',$ids];
            $res = model('Cash')->auditData($where);
            if($res['code']>1){
                return $this->error($res['msg']);
            }
            return $this->success($res['msg']);
        }
        return $this->error('参数错误');
    }

}
