// Copyright (c) 2016/17/18/19/20/21/22 Leandro T. C. Melo <ltcmelo@gmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#include "MacroTranslations.h"

using namespace psy;
using namespace C;

MacroTranslations::MacroTranslations()
    : BF_all_(~0)
{}

#define DEFINE_ENABLE_ISENABLED(FLAG) \
    MacroTranslations& MacroTranslations::enable_##FLAG(bool enable) \
        { BF_.FLAG##_ = enable; return *this; } \
    bool MacroTranslations::isEnabled_##FLAG() const \
        { return BF_.FLAG##_; }

DEFINE_ENABLE_ISENABLED(Translate_static_assert_AsKeyword)
DEFINE_ENABLE_ISENABLED(Translate_complex_AsKeyword)
DEFINE_ENABLE_ISENABLED(Translate_operatorNames)
DEFINE_ENABLE_ISENABLED(Translate_alignas_AsKeyword)
DEFINE_ENABLE_ISENABLED(Translate_alignof_AsKeyword)
DEFINE_ENABLE_ISENABLED(Translate_va_arg_AsKeyword)
DEFINE_ENABLE_ISENABLED(Translate_offsetof_AsKeyword)
DEFINE_ENABLE_ISENABLED(Translate_bool_AsKeyword)
DEFINE_ENABLE_ISENABLED(Translate_thread_local_AsKeyword)

#undef DEFINE_ENABLE_ISENABLED
