# 树形选择

:::demo
```vue
<template>
  <div class="tree-demo">
      <el-card>
        <p>模式一： 提交最高级节点， 比如选中了北京下所有区，只会提交北京市；用于数据归并场景</p>
        <ks-tree-select :source="source" v-model="value1" mode="merge" />

        <p class="f-mt20">模式二： 提交叶子节点， 比如选中了北京市，会提交北京市下所有的区；用于数据抹平场景</p>
        <ks-tree-select :source="source" v-model="value2" mode="leaf" />

        <p class="f-mt20">模式三： 普通提交， 选中什么提交什么</p>
        <ks-tree-select :source="source" v-model="value3" :checkStrictly="true" mode="normal" />

        <p class="f-mt20">详情页面展示</p>
        <ks-tree-select :source="source" v-model="value4" :canEdit=false mode="leaf" />

        <p class="f-mt20">无操作按钮</p>
        <ks-tree-select :source="source" v-model="value5" :showButtons=false />

        <p class="f-mt20">无过滤功能</p>
        <ks-tree-select :source="source" v-model="value6" :canSearch=false />

        <p class="f-mt20">单选模式一： 记录选中节点</p>
        <ks-tree-select :source="source" v-model="value7" :multiple=false />

        <p class="f-mt20">单选模式二： 记录选中节点的路径</p>
        <ks-tree-select :source="source" v-model="value8" mode="normal" :multiple=false />
      </el-card>
    </div>
</template>
<script>
export default {
    data() {
      return {
        value1: [],
        value2: [],
        value3: [],
        value4: [],
        value5: [],
        value6: [],
        value7: [],
        value8: [],
        source: [
          {
            children: [
              {
                children: [
                  {
                    children: [
                      {
                        children: null,
                        id: 500103,
                        name: '渝中区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500102,
                        name: '涪陵区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500101,
                        name: '万州区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500111,
                        name: '大足区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500110,
                        name: '綦江区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500109,
                        name: '北碚区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500108,
                        name: '南岸区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500107,
                        name: '九龙坡区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500106,
                        name: '沙坪坝区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500105,
                        name: '江北区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500104,
                        name: '大渡口区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500119,
                        name: '南川区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500118,
                        name: '永川区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500117,
                        name: '合川区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500116,
                        name: '江津区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500115,
                        name: '长寿区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500114,
                        name: '黔江区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500113,
                        name: '巴南区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500112,
                        name: '渝北区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500127,
                        name: '璧山县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500126,
                        name: '荣昌县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500124,
                        name: '铜梁县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500123,
                        name: '潼南县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500121,
                        name: '高新区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500120,
                        name: '万盛区',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500135,
                        name: '云阳县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500134,
                        name: '开县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500133,
                        name: '忠县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500132,
                        name: '武隆县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500131,
                        name: '垫江县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500130,
                        name: '丰都县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500129,
                        name: '城口县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500128,
                        name: '梁平县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500143,
                        name: '彭水苗族土家族自治县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500142,
                        name: '酉阳土家族苗族自治县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500141,
                        name: '秀山土家族苗族自治县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500140,
                        name: '石柱土家族自治县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500138,
                        name: '巫溪县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500137,
                        name: '巫山县',
                        parentId: 500100,
                      },
                      {
                        children: null,
                        id: 500136,
                        name: '奉节县',
                        parentId: 500100,
                      },
                    ],
                    id: 500100,
                    name: '重庆市',
                    parentId: 500000,
                  },
                ],
                id: 500000,
                name: '重庆市',
                parentId: 13,
              },
              {
                children: [
                  {
                    children: [
                      {
                        children: null,
                        id: 410102,
                        name: '中原区',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410103,
                        name: '二七区',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410108,
                        name: '惠济区',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410106,
                        name: '上街区',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410104,
                        name: '管城回族区',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410105,
                        name: '金水区',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410122,
                        name: '中牟县',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410182,
                        name: '荥阳市',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410183,
                        name: '新密市',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410181,
                        name: '巩义市',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410186,
                        name: '高新区',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410187,
                        name: '郑东新区',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410184,
                        name: '新郑市',
                        parentId: 410100,
                      },
                      {
                        children: null,
                        id: 410185,
                        name: '登封市',
                        parentId: 410100,
                      },
                    ],
                    id: 410100,
                    name: '郑州市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 410204,
                        name: '鼓楼区',
                        parentId: 410200,
                      },
                      {
                        children: null,
                        id: 410205,
                        name: '禹王台区',
                        parentId: 410200,
                      },
                      {
                        children: null,
                        id: 410202,
                        name: '龙亭区',
                        parentId: 410200,
                      },
                      {
                        children: null,
                        id: 410203,
                        name: '顺河回族区',
                        parentId: 410200,
                      },
                      {
                        children: null,
                        id: 410212,
                        name: '祥符区',
                        parentId: 410200,
                      },
                      {
                        children: null,
                        id: 410211,
                        name: '金明区',
                        parentId: 410200,
                      },
                      {
                        children: null,
                        id: 410222,
                        name: '通许县',
                        parentId: 410200,
                      },
                      {
                        children: null,
                        id: 410223,
                        name: '尉氏县',
                        parentId: 410200,
                      },
                      {
                        children: null,
                        id: 410221,
                        name: '杞县',
                        parentId: 410200,
                      },
                      {
                        children: null,
                        id: 410224,
                        name: '开封县',
                        parentId: 410200,
                      },
                      {
                        children: null,
                        id: 410225,
                        name: '兰考县',
                        parentId: 410200,
                      },
                    ],
                    id: 410200,
                    name: '开封市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 410302,
                        name: '老城区',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410303,
                        name: '西工区',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410311,
                        name: '洛龙区',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410306,
                        name: '吉利区',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410304,
                        name: '瀍河回族区',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410305,
                        name: '涧西区',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410326,
                        name: '汝阳县',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410327,
                        name: '宜阳县',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410324,
                        name: '栾川县',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410325,
                        name: '嵩县',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410322,
                        name: '孟津县',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410323,
                        name: '新安县',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410328,
                        name: '洛宁县',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410329,
                        name: '伊川县',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410382,
                        name: '洛南新区',
                        parentId: 410300,
                      },
                      {
                        children: null,
                        id: 410381,
                        name: '偃师市',
                        parentId: 410300,
                      },
                    ],
                    id: 410300,
                    name: '洛阳市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 410404,
                        name: '石龙区',
                        parentId: 410400,
                      },
                      {
                        children: null,
                        id: 410402,
                        name: '新华区',
                        parentId: 410400,
                      },
                      {
                        children: null,
                        id: 410403,
                        name: '卫东区',
                        parentId: 410400,
                      },
                      {
                        children: null,
                        id: 410411,
                        name: '湛河区',
                        parentId: 410400,
                      },
                      {
                        children: null,
                        id: 410422,
                        name: '叶县',
                        parentId: 410400,
                      },
                      {
                        children: null,
                        id: 410423,
                        name: '鲁山县',
                        parentId: 410400,
                      },
                      {
                        children: null,
                        id: 410421,
                        name: '宝丰县',
                        parentId: 410400,
                      },
                      {
                        children: null,
                        id: 410425,
                        name: '郏县',
                        parentId: 410400,
                      },
                      {
                        children: null,
                        id: 410482,
                        name: '汝州市',
                        parentId: 410400,
                      },
                      {
                        children: null,
                        id: 410481,
                        name: '舞钢市',
                        parentId: 410400,
                      },
                    ],
                    id: 410400,
                    name: '平顶山市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 410502,
                        name: '文峰区',
                        parentId: 410500,
                      },
                      {
                        children: null,
                        id: 410503,
                        name: '北关区',
                        parentId: 410500,
                      },
                      {
                        children: null,
                        id: 410506,
                        name: '龙安区',
                        parentId: 410500,
                      },
                      {
                        children: null,
                        id: 410505,
                        name: '殷都区',
                        parentId: 410500,
                      },
                      {
                        children: null,
                        id: 410526,
                        name: '滑县',
                        parentId: 410500,
                      },
                      {
                        children: null,
                        id: 410527,
                        name: '内黄县',
                        parentId: 410500,
                      },
                      {
                        children: null,
                        id: 410522,
                        name: '安阳县',
                        parentId: 410500,
                      },
                      {
                        children: null,
                        id: 410523,
                        name: '汤阴县',
                        parentId: 410500,
                      },
                      {
                        children: null,
                        id: 410581,
                        name: '林州市',
                        parentId: 410500,
                      },
                    ],
                    id: 410500,
                    name: '安阳市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 410602,
                        name: '鹤山区',
                        parentId: 410600,
                      },
                      {
                        children: null,
                        id: 410603,
                        name: '山城区',
                        parentId: 410600,
                      },
                      {
                        children: null,
                        id: 410611,
                        name: '淇滨区',
                        parentId: 410600,
                      },
                      {
                        children: null,
                        id: 410622,
                        name: '淇县',
                        parentId: 410600,
                      },
                      {
                        children: null,
                        id: 410621,
                        name: '浚县',
                        parentId: 410600,
                      },
                    ],
                    id: 410600,
                    name: '鹤壁市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 410702,
                        name: '红旗区',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410703,
                        name: '卫滨区',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410711,
                        name: '牧野区',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410704,
                        name: '凤泉区',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410726,
                        name: '延津县',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410727,
                        name: '封丘县',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410724,
                        name: '获嘉县',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410725,
                        name: '原阳县',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410721,
                        name: '新乡县',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410728,
                        name: '长垣县',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410782,
                        name: '辉县市',
                        parentId: 410700,
                      },
                      {
                        children: null,
                        id: 410781,
                        name: '卫辉市',
                        parentId: 410700,
                      },
                    ],
                    id: 410700,
                    name: '新乡市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 410804,
                        name: '马村区',
                        parentId: 410800,
                      },
                      {
                        children: null,
                        id: 410802,
                        name: '解放区',
                        parentId: 410800,
                      },
                      {
                        children: null,
                        id: 410803,
                        name: '中站区',
                        parentId: 410800,
                      },
                      {
                        children: null,
                        id: 410811,
                        name: '山阳区',
                        parentId: 410800,
                      },
                      {
                        children: null,
                        id: 410822,
                        name: '博爱县',
                        parentId: 410800,
                      },
                      {
                        children: null,
                        id: 410823,
                        name: '武陟县',
                        parentId: 410800,
                      },
                      {
                        children: null,
                        id: 410821,
                        name: '修武县',
                        parentId: 410800,
                      },
                      {
                        children: null,
                        id: 410825,
                        name: '温县',
                        parentId: 410800,
                      },
                      {
                        children: null,
                        id: 410882,
                        name: '沁阳市',
                        parentId: 410800,
                      },
                      {
                        children: null,
                        id: 410883,
                        name: '孟州市',
                        parentId: 410800,
                      },
                    ],
                    id: 410800,
                    name: '焦作市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 419001,
                        name: '济源市',
                        parentId: 419000,
                      },
                    ],
                    id: 419000,
                    name: '济源市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 410902,
                        name: '华龙区',
                        parentId: 410900,
                      },
                      {
                        children: null,
                        id: 410926,
                        name: '范县',
                        parentId: 410900,
                      },
                      {
                        children: null,
                        id: 410927,
                        name: '台前县',
                        parentId: 410900,
                      },
                      {
                        children: null,
                        id: 410922,
                        name: '清丰县',
                        parentId: 410900,
                      },
                      {
                        children: null,
                        id: 410923,
                        name: '南乐县',
                        parentId: 410900,
                      },
                      {
                        children: null,
                        id: 410928,
                        name: '濮阳县',
                        parentId: 410900,
                      },
                    ],
                    id: 410900,
                    name: '濮阳市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 411002,
                        name: '魏都区',
                        parentId: 411000,
                      },
                      {
                        children: null,
                        id: 411023,
                        name: '许昌县',
                        parentId: 411000,
                      },
                      {
                        children: null,
                        id: 411024,
                        name: '鄢陵县',
                        parentId: 411000,
                      },
                      {
                        children: null,
                        id: 411025,
                        name: '襄城县',
                        parentId: 411000,
                      },
                      {
                        children: null,
                        id: 411082,
                        name: '长葛市',
                        parentId: 411000,
                      },
                      {
                        children: null,
                        id: 411081,
                        name: '禹州市',
                        parentId: 411000,
                      },
                    ],
                    id: 411000,
                    name: '许昌市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 411102,
                        name: '源汇区',
                        parentId: 411100,
                      },
                      {
                        children: null,
                        id: 411103,
                        name: '郾城区',
                        parentId: 411100,
                      },
                      {
                        children: null,
                        id: 411104,
                        name: '召陵区',
                        parentId: 411100,
                      },
                      {
                        children: null,
                        id: 411122,
                        name: '临颍县',
                        parentId: 411100,
                      },
                      {
                        children: null,
                        id: 411121,
                        name: '舞阳县',
                        parentId: 411100,
                      },
                    ],
                    id: 411100,
                    name: '漯河市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 411202,
                        name: '湖滨区',
                        parentId: 411200,
                      },
                      {
                        children: null,
                        id: 411203,
                        name: '陕州区',
                        parentId: 411200,
                      },
                      {
                        children: null,
                        id: 411222,
                        name: '陕县',
                        parentId: 411200,
                      },
                      {
                        children: null,
                        id: 411221,
                        name: '渑池县',
                        parentId: 411200,
                      },
                      {
                        children: null,
                        id: 411224,
                        name: '卢氏县',
                        parentId: 411200,
                      },
                      {
                        children: null,
                        id: 411282,
                        name: '灵宝市',
                        parentId: 411200,
                      },
                      {
                        children: null,
                        id: 411281,
                        name: '义马市',
                        parentId: 411200,
                      },
                    ],
                    id: 411200,
                    name: '三门峡市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 411302,
                        name: '宛城区',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411303,
                        name: '卧龙区',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411326,
                        name: '淅川县',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411327,
                        name: '社旗县',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411324,
                        name: '镇平县',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411325,
                        name: '内乡县',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411322,
                        name: '方城县',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411323,
                        name: '西峡县',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411321,
                        name: '南召县',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411330,
                        name: '桐柏县',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411328,
                        name: '唐河县',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411329,
                        name: '新野县',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411382,
                        name: '高新区',
                        parentId: 411300,
                      },
                      {
                        children: null,
                        id: 411381,
                        name: '邓州市',
                        parentId: 411300,
                      },
                    ],
                    id: 411300,
                    name: '南阳市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 411402,
                        name: '梁园区',
                        parentId: 411400,
                      },
                      {
                        children: null,
                        id: 411403,
                        name: '睢阳区',
                        parentId: 411400,
                      },
                      {
                        children: null,
                        id: 411422,
                        name: '睢县',
                        parentId: 411400,
                      },
                      {
                        children: null,
                        id: 411423,
                        name: '宁陵县',
                        parentId: 411400,
                      },
                      {
                        children: null,
                        id: 411421,
                        name: '民权县',
                        parentId: 411400,
                      },
                      {
                        children: null,
                        id: 411426,
                        name: '夏邑县',
                        parentId: 411400,
                      },
                      {
                        children: null,
                        id: 411424,
                        name: '柘城县',
                        parentId: 411400,
                      },
                      {
                        children: null,
                        id: 411425,
                        name: '虞城县',
                        parentId: 411400,
                      },
                      {
                        children: null,
                        id: 411481,
                        name: '永城市',
                        parentId: 411400,
                      },
                    ],
                    id: 411400,
                    name: '商丘市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 411502,
                        name: '浉河区',
                        parentId: 411500,
                      },
                      {
                        children: null,
                        id: 411503,
                        name: '平桥区',
                        parentId: 411500,
                      },
                      {
                        children: null,
                        id: 411526,
                        name: '潢川县',
                        parentId: 411500,
                      },
                      {
                        children: null,
                        id: 411527,
                        name: '淮滨县',
                        parentId: 411500,
                      },
                      {
                        children: null,
                        id: 411524,
                        name: '商城县',
                        parentId: 411500,
                      },
                      {
                        children: null,
                        id: 411525,
                        name: '固始县',
                        parentId: 411500,
                      },
                      {
                        children: null,
                        id: 411522,
                        name: '光山县',
                        parentId: 411500,
                      },
                      {
                        children: null,
                        id: 411523,
                        name: '新县',
                        parentId: 411500,
                      },
                      {
                        children: null,
                        id: 411521,
                        name: '罗山县',
                        parentId: 411500,
                      },
                      {
                        children: null,
                        id: 411528,
                        name: '息县',
                        parentId: 411500,
                      },
                    ],
                    id: 411500,
                    name: '信阳市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 411602,
                        name: '川汇区',
                        parentId: 411600,
                      },
                      {
                        children: null,
                        id: 411622,
                        name: '西华县',
                        parentId: 411600,
                      },
                      {
                        children: null,
                        id: 411623,
                        name: '商水县',
                        parentId: 411600,
                      },
                      {
                        children: null,
                        id: 411621,
                        name: '扶沟县',
                        parentId: 411600,
                      },
                      {
                        children: null,
                        id: 411628,
                        name: '鹿邑县',
                        parentId: 411600,
                      },
                      {
                        children: null,
                        id: 411626,
                        name: '淮阳县',
                        parentId: 411600,
                      },
                      {
                        children: null,
                        id: 411627,
                        name: '太康县',
                        parentId: 411600,
                      },
                      {
                        children: null,
                        id: 411624,
                        name: '沈丘县',
                        parentId: 411600,
                      },
                      {
                        children: null,
                        id: 411625,
                        name: '郸城县',
                        parentId: 411600,
                      },
                      {
                        children: null,
                        id: 411681,
                        name: '项城市',
                        parentId: 411600,
                      },
                    ],
                    id: 411600,
                    name: '周口市',
                    parentId: 410000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 411702,
                        name: '驿城区',
                        parentId: 411700,
                      },
                      {
                        children: null,
                        id: 411726,
                        name: '泌阳县',
                        parentId: 411700,
                      },
                      {
                        children: null,
                        id: 411727,
                        name: '汝南县',
                        parentId: 411700,
                      },
                      {
                        children: null,
                        id: 411724,
                        name: '正阳县',
                        parentId: 411700,
                      },
                      {
                        children: null,
                        id: 411725,
                        name: '确山县',
                        parentId: 411700,
                      },
                      {
                        children: null,
                        id: 411722,
                        name: '上蔡县',
                        parentId: 411700,
                      },
                      {
                        children: null,
                        id: 411723,
                        name: '平舆县',
                        parentId: 411700,
                      },
                      {
                        children: null,
                        id: 411721,
                        name: '西平县',
                        parentId: 411700,
                      },
                      {
                        children: null,
                        id: 411728,
                        name: '遂平县',
                        parentId: 411700,
                      },
                      {
                        children: null,
                        id: 411729,
                        name: '新蔡县',
                        parentId: 411700,
                      },
                    ],
                    id: 411700,
                    name: '驻马店市',
                    parentId: 410000,
                  },
                ],
                id: 410000,
                name: '河南省',
                parentId: 13,
              },
              {
                children: [
                  {
                    children: [
                      {
                        children: null,
                        id: 510108,
                        name: '成华区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510107,
                        name: '武侯区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510106,
                        name: '金牛区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510105,
                        name: '青羊区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510104,
                        name: '锦江区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510115,
                        name: '温江区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510114,
                        name: '新都区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510113,
                        name: '青白江区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510112,
                        name: '龙泉驿区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510124,
                        name: '郫县',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510122,
                        name: '双流县',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510121,
                        name: '金堂县',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510132,
                        name: '新津县',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510131,
                        name: '蒲江县',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510129,
                        name: '大邑县',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510183,
                        name: '邛崃市',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510182,
                        name: '彭州市',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510181,
                        name: '都江堰市',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510186,
                        name: '高新西区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510185,
                        name: '高新区',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 510184,
                        name: '崇州市',
                        parentId: 510100,
                      },
                      {
                        children: null,
                        id: 512081,
                        name: '简阳市',
                        parentId: 510100,
                      },
                    ],
                    id: 510100,
                    name: '成都市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 510303,
                        name: '贡井区',
                        parentId: 510300,
                      },
                      {
                        children: null,
                        id: 510302,
                        name: '自流井区',
                        parentId: 510300,
                      },
                      {
                        children: null,
                        id: 510311,
                        name: '沿滩区',
                        parentId: 510300,
                      },
                      {
                        children: null,
                        id: 510304,
                        name: '大安区',
                        parentId: 510300,
                      },
                      {
                        children: null,
                        id: 510322,
                        name: '富顺县',
                        parentId: 510300,
                      },
                      {
                        children: null,
                        id: 510321,
                        name: '荣县',
                        parentId: 510300,
                      },
                    ],
                    id: 510300,
                    name: '自贡市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 510403,
                        name: '西区',
                        parentId: 510400,
                      },
                      {
                        children: null,
                        id: 510402,
                        name: '东区',
                        parentId: 510400,
                      },
                      {
                        children: null,
                        id: 510411,
                        name: '仁和区',
                        parentId: 510400,
                      },
                      {
                        children: null,
                        id: 510422,
                        name: '盐边县',
                        parentId: 510400,
                      },
                      {
                        children: null,
                        id: 510421,
                        name: '米易县',
                        parentId: 510400,
                      },
                    ],
                    id: 510400,
                    name: '攀枝花市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 510503,
                        name: '纳溪区',
                        parentId: 510500,
                      },
                      {
                        children: null,
                        id: 510502,
                        name: '江阳区',
                        parentId: 510500,
                      },
                      {
                        children: null,
                        id: 510504,
                        name: '龙马潭区',
                        parentId: 510500,
                      },
                      {
                        children: null,
                        id: 510525,
                        name: '古蔺县',
                        parentId: 510500,
                      },
                      {
                        children: null,
                        id: 510524,
                        name: '叙永县',
                        parentId: 510500,
                      },
                      {
                        children: null,
                        id: 510522,
                        name: '合江县',
                        parentId: 510500,
                      },
                      {
                        children: null,
                        id: 510521,
                        name: '泸县',
                        parentId: 510500,
                      },
                    ],
                    id: 510500,
                    name: '泸州市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 510603,
                        name: '旌阳区',
                        parentId: 510600,
                      },
                      {
                        children: null,
                        id: 510623,
                        name: '中江县',
                        parentId: 510600,
                      },
                      {
                        children: null,
                        id: 510626,
                        name: '罗江县',
                        parentId: 510600,
                      },
                      {
                        children: null,
                        id: 510683,
                        name: '绵竹市',
                        parentId: 510600,
                      },
                      {
                        children: null,
                        id: 510682,
                        name: '什邡市',
                        parentId: 510600,
                      },
                      {
                        children: null,
                        id: 510681,
                        name: '广汉市',
                        parentId: 510600,
                      },
                    ],
                    id: 510600,
                    name: '德阳市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 510703,
                        name: '涪城区',
                        parentId: 510700,
                      },
                      {
                        children: null,
                        id: 510704,
                        name: '游仙区',
                        parentId: 510700,
                      },
                      {
                        children: null,
                        id: 510727,
                        name: '平武县',
                        parentId: 510700,
                      },
                      {
                        children: null,
                        id: 510726,
                        name: '北川羌族自治县',
                        parentId: 510700,
                      },
                      {
                        children: null,
                        id: 510725,
                        name: '梓潼县',
                        parentId: 510700,
                      },
                      {
                        children: null,
                        id: 510724,
                        name: '安县',
                        parentId: 510700,
                      },
                      {
                        children: null,
                        id: 510723,
                        name: '盐亭县',
                        parentId: 510700,
                      },
                      {
                        children: null,
                        id: 510722,
                        name: '三台县',
                        parentId: 510700,
                      },
                      {
                        children: null,
                        id: 510783,
                        name: '经开区',
                        parentId: 510700,
                      },
                      {
                        children: null,
                        id: 510782,
                        name: '高新区',
                        parentId: 510700,
                      },
                      {
                        children: null,
                        id: 510781,
                        name: '江油市',
                        parentId: 510700,
                      },
                    ],
                    id: 510700,
                    name: '绵阳市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 510802,
                        name: '利州区',
                        parentId: 510800,
                      },
                      {
                        children: null,
                        id: 510812,
                        name: '朝天区',
                        parentId: 510800,
                      },
                      {
                        children: null,
                        id: 510811,
                        name: '昭化区',
                        parentId: 510800,
                      },
                      {
                        children: null,
                        id: 510823,
                        name: '剑阁县',
                        parentId: 510800,
                      },
                      {
                        children: null,
                        id: 510822,
                        name: '青川县',
                        parentId: 510800,
                      },
                      {
                        children: null,
                        id: 510821,
                        name: '旺苍县',
                        parentId: 510800,
                      },
                      {
                        children: null,
                        id: 510824,
                        name: '苍溪县',
                        parentId: 510800,
                      },
                    ],
                    id: 510800,
                    name: '广元市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 510903,
                        name: '船山区',
                        parentId: 510900,
                      },
                      {
                        children: null,
                        id: 510904,
                        name: '安居区',
                        parentId: 510900,
                      },
                      {
                        children: null,
                        id: 510923,
                        name: '大英县',
                        parentId: 510900,
                      },
                      {
                        children: null,
                        id: 510922,
                        name: '射洪县',
                        parentId: 510900,
                      },
                      {
                        children: null,
                        id: 510921,
                        name: '蓬溪县',
                        parentId: 510900,
                      },
                    ],
                    id: 510900,
                    name: '遂宁市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 511002,
                        name: '市中区',
                        parentId: 511000,
                      },
                      {
                        children: null,
                        id: 511011,
                        name: '东兴区',
                        parentId: 511000,
                      },
                      {
                        children: null,
                        id: 511028,
                        name: '隆昌县',
                        parentId: 511000,
                      },
                      {
                        children: null,
                        id: 511025,
                        name: '资中县',
                        parentId: 511000,
                      },
                      {
                        children: null,
                        id: 511024,
                        name: '威远县',
                        parentId: 511000,
                      },
                    ],
                    id: 511000,
                    name: '内江市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 511102,
                        name: '市中区',
                        parentId: 511100,
                      },
                      {
                        children: null,
                        id: 511111,
                        name: '沙湾区',
                        parentId: 511100,
                      },
                      {
                        children: null,
                        id: 511113,
                        name: '金口河区',
                        parentId: 511100,
                      },
                      {
                        children: null,
                        id: 511112,
                        name: '五通桥区',
                        parentId: 511100,
                      },
                      {
                        children: null,
                        id: 511126,
                        name: '夹江县',
                        parentId: 511100,
                      },
                      {
                        children: null,
                        id: 511124,
                        name: '井研县',
                        parentId: 511100,
                      },
                      {
                        children: null,
                        id: 511123,
                        name: '犍为县',
                        parentId: 511100,
                      },
                      {
                        children: null,
                        id: 511133,
                        name: '马边彝族自治县',
                        parentId: 511100,
                      },
                      {
                        children: null,
                        id: 511132,
                        name: '峨边彝族自治县',
                        parentId: 511100,
                      },
                      {
                        children: null,
                        id: 511129,
                        name: '沐川县',
                        parentId: 511100,
                      },
                      {
                        children: null,
                        id: 511181,
                        name: '峨眉山市',
                        parentId: 511100,
                      },
                    ],
                    id: 511100,
                    name: '乐山市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 511303,
                        name: '高坪区',
                        parentId: 511300,
                      },
                      {
                        children: null,
                        id: 511302,
                        name: '顺庆区',
                        parentId: 511300,
                      },
                      {
                        children: null,
                        id: 511304,
                        name: '嘉陵区',
                        parentId: 511300,
                      },
                      {
                        children: null,
                        id: 511325,
                        name: '西充县',
                        parentId: 511300,
                      },
                      {
                        children: null,
                        id: 511324,
                        name: '仪陇县',
                        parentId: 511300,
                      },
                      {
                        children: null,
                        id: 511323,
                        name: '蓬安县',
                        parentId: 511300,
                      },
                      {
                        children: null,
                        id: 511322,
                        name: '营山县',
                        parentId: 511300,
                      },
                      {
                        children: null,
                        id: 511321,
                        name: '南部县',
                        parentId: 511300,
                      },
                      {
                        children: null,
                        id: 511381,
                        name: '阆中市',
                        parentId: 511300,
                      },
                    ],
                    id: 511300,
                    name: '南充市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 511402,
                        name: '东坡区',
                        parentId: 511400,
                      },
                      {
                        children: null,
                        id: 511423,
                        name: '洪雅县',
                        parentId: 511400,
                      },
                      {
                        children: null,
                        id: 511422,
                        name: '彭山县',
                        parentId: 511400,
                      },
                      {
                        children: null,
                        id: 511421,
                        name: '仁寿县',
                        parentId: 511400,
                      },
                      {
                        children: null,
                        id: 511425,
                        name: '青神县',
                        parentId: 511400,
                      },
                      {
                        children: null,
                        id: 511424,
                        name: '丹棱县',
                        parentId: 511400,
                      },
                    ],
                    id: 511400,
                    name: '眉山市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 511503,
                        name: '南溪区',
                        parentId: 511500,
                      },
                      {
                        children: null,
                        id: 511502,
                        name: '翠屏区',
                        parentId: 511500,
                      },
                      {
                        children: null,
                        id: 511501,
                        name: '宜宾市区',
                        parentId: 511500,
                      },
                      {
                        children: null,
                        id: 511527,
                        name: '筠连县',
                        parentId: 511500,
                      },
                      {
                        children: null,
                        id: 511526,
                        name: '珙县',
                        parentId: 511500,
                      },
                      {
                        children: null,
                        id: 511525,
                        name: '高县',
                        parentId: 511500,
                      },
                      {
                        children: null,
                        id: 511524,
                        name: '长宁县',
                        parentId: 511500,
                      },
                      {
                        children: null,
                        id: 511523,
                        name: '江安县',
                        parentId: 511500,
                      },
                      {
                        children: null,
                        id: 511521,
                        name: '宜宾县',
                        parentId: 511500,
                      },
                      {
                        children: null,
                        id: 511529,
                        name: '屏山县',
                        parentId: 511500,
                      },
                      {
                        children: null,
                        id: 511528,
                        name: '兴文县',
                        parentId: 511500,
                      },
                    ],
                    id: 511500,
                    name: '宜宾市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 511603,
                        name: '前锋区',
                        parentId: 511600,
                      },
                      {
                        children: null,
                        id: 511602,
                        name: '广安区',
                        parentId: 511600,
                      },
                      {
                        children: null,
                        id: 511623,
                        name: '邻水县',
                        parentId: 511600,
                      },
                      {
                        children: null,
                        id: 511622,
                        name: '武胜县',
                        parentId: 511600,
                      },
                      {
                        children: null,
                        id: 511621,
                        name: '岳池县',
                        parentId: 511600,
                      },
                      {
                        children: null,
                        id: 511681,
                        name: '华蓥市',
                        parentId: 511600,
                      },
                    ],
                    id: 511600,
                    name: '广安市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 511703,
                        name: '达川区',
                        parentId: 511700,
                      },
                      {
                        children: null,
                        id: 511702,
                        name: '通川区',
                        parentId: 511700,
                      },
                      {
                        children: null,
                        id: 511725,
                        name: '渠县',
                        parentId: 511700,
                      },
                      {
                        children: null,
                        id: 511724,
                        name: '大竹县',
                        parentId: 511700,
                      },
                      {
                        children: null,
                        id: 511723,
                        name: '开江县',
                        parentId: 511700,
                      },
                      {
                        children: null,
                        id: 511722,
                        name: '宣汉县',
                        parentId: 511700,
                      },
                      {
                        children: null,
                        id: 511721,
                        name: '达县',
                        parentId: 511700,
                      },
                      {
                        children: null,
                        id: 511781,
                        name: '万源市',
                        parentId: 511700,
                      },
                    ],
                    id: 511700,
                    name: '达州市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 511802,
                        name: '雨城区',
                        parentId: 511800,
                      },
                      {
                        children: null,
                        id: 511823,
                        name: '汉源县',
                        parentId: 511800,
                      },
                      {
                        children: null,
                        id: 511822,
                        name: '荥经县',
                        parentId: 511800,
                      },
                      {
                        children: null,
                        id: 511821,
                        name: '名山县',
                        parentId: 511800,
                      },
                      {
                        children: null,
                        id: 511827,
                        name: '宝兴县',
                        parentId: 511800,
                      },
                      {
                        children: null,
                        id: 511826,
                        name: '芦山县',
                        parentId: 511800,
                      },
                      {
                        children: null,
                        id: 511825,
                        name: '天全县',
                        parentId: 511800,
                      },
                      {
                        children: null,
                        id: 511824,
                        name: '石棉县',
                        parentId: 511800,
                      },
                    ],
                    id: 511800,
                    name: '雅安市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 511903,
                        name: '恩阳区',
                        parentId: 511900,
                      },
                      {
                        children: null,
                        id: 511902,
                        name: '巴州区',
                        parentId: 511900,
                      },
                      {
                        children: null,
                        id: 511923,
                        name: '平昌县',
                        parentId: 511900,
                      },
                      {
                        children: null,
                        id: 511922,
                        name: '南江县',
                        parentId: 511900,
                      },
                      {
                        children: null,
                        id: 511921,
                        name: '通江县',
                        parentId: 511900,
                      },
                    ],
                    id: 511900,
                    name: '巴中市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 512002,
                        name: '雁江区',
                        parentId: 512000,
                      },
                      {
                        children: null,
                        id: 512022,
                        name: '乐至县',
                        parentId: 512000,
                      },
                      {
                        children: null,
                        id: 512021,
                        name: '安岳县',
                        parentId: 512000,
                      },
                    ],
                    id: 512000,
                    name: '资阳市',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 513223,
                        name: '茂县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513222,
                        name: '理县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513221,
                        name: '汶川县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513231,
                        name: '阿坝县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513230,
                        name: '壤塘县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513229,
                        name: '马尔康县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513228,
                        name: '黑水县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513227,
                        name: '小金县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513226,
                        name: '金川县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513225,
                        name: '九寨沟县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513224,
                        name: '松潘县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513233,
                        name: '红原县',
                        parentId: 513200,
                      },
                      {
                        children: null,
                        id: 513232,
                        name: '若尔盖县',
                        parentId: 513200,
                      },
                    ],
                    id: 513200,
                    name: '阿坝藏族羌族自治州',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 513327,
                        name: '炉霍县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513326,
                        name: '道孚县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513325,
                        name: '雅江县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513324,
                        name: '九龙县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513323,
                        name: '丹巴县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513322,
                        name: '泸定县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513321,
                        name: '康定县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513335,
                        name: '巴塘县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513334,
                        name: '理塘县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513333,
                        name: '色达县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513332,
                        name: '石渠县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513331,
                        name: '白玉县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513330,
                        name: '德格县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513329,
                        name: '新龙县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513328,
                        name: '甘孜县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513338,
                        name: '得荣县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513337,
                        name: '稻城县',
                        parentId: 513300,
                      },
                      {
                        children: null,
                        id: 513336,
                        name: '乡城县',
                        parentId: 513300,
                      },
                    ],
                    id: 513300,
                    name: '甘孜藏族自治州',
                    parentId: 510000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 513401,
                        name: '西昌市',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513423,
                        name: '盐源县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513422,
                        name: '木里藏族自治县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513431,
                        name: '昭觉县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513430,
                        name: '金阳县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513429,
                        name: '布拖县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513428,
                        name: '普格县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513427,
                        name: '宁南县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513426,
                        name: '会东县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513425,
                        name: '会理县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513424,
                        name: '德昌县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513437,
                        name: '雷波县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513436,
                        name: '美姑县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513435,
                        name: '甘洛县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513434,
                        name: '越西县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513433,
                        name: '冕宁县',
                        parentId: 513400,
                      },
                      {
                        children: null,
                        id: 513432,
                        name: '喜德县',
                        parentId: 513400,
                      },
                    ],
                    id: 513400,
                    name: '凉山彝族自治州',
                    parentId: 510000,
                  },
                ],
                id: 510000,
                name: '四川省',
                parentId: 13,
              },
              {
                children: [
                  {
                    children: [
                      {
                        children: null,
                        id: 420102,
                        name: '江岸区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420103,
                        name: '江汉区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420111,
                        name: '洪山区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420106,
                        name: '武昌区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420107,
                        name: '青山区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420104,
                        name: '硚口区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420105,
                        name: '汉阳区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420118,
                        name: '武汉经济技术开发区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420116,
                        name: '黄陂区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420117,
                        name: '新洲区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420114,
                        name: '蔡甸区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420115,
                        name: '江夏区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420112,
                        name: '东西湖区',
                        parentId: 420100,
                      },
                      {
                        children: null,
                        id: 420113,
                        name: '汉南区',
                        parentId: 420100,
                      },
                    ],
                    id: 420100,
                    name: '武汉市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 420204,
                        name: '下陆区',
                        parentId: 420200,
                      },
                      {
                        children: null,
                        id: 420205,
                        name: '铁山区',
                        parentId: 420200,
                      },
                      {
                        children: null,
                        id: 420202,
                        name: '黄石港区',
                        parentId: 420200,
                      },
                      {
                        children: null,
                        id: 420203,
                        name: '西塞山区',
                        parentId: 420200,
                      },
                      {
                        children: null,
                        id: 420222,
                        name: '阳新县',
                        parentId: 420200,
                      },
                      {
                        children: null,
                        id: 420281,
                        name: '大冶市',
                        parentId: 420200,
                      },
                    ],
                    id: 420200,
                    name: '黄石市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 420302,
                        name: '茅箭区',
                        parentId: 420300,
                      },
                      {
                        children: null,
                        id: 420303,
                        name: '张湾区',
                        parentId: 420300,
                      },
                      {
                        children: null,
                        id: 420304,
                        name: '郧阳区',
                        parentId: 420300,
                      },
                      {
                        children: null,
                        id: 420324,
                        name: '竹溪县',
                        parentId: 420300,
                      },
                      {
                        children: null,
                        id: 420325,
                        name: '房县',
                        parentId: 420300,
                      },
                      {
                        children: null,
                        id: 420322,
                        name: '郧西县',
                        parentId: 420300,
                      },
                      {
                        children: null,
                        id: 420323,
                        name: '竹山县',
                        parentId: 420300,
                      },
                      {
                        children: null,
                        id: 420321,
                        name: '郧县',
                        parentId: 420300,
                      },
                      {
                        children: null,
                        id: 420381,
                        name: '丹江口市',
                        parentId: 420300,
                      },
                    ],
                    id: 420300,
                    name: '十堰市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 420502,
                        name: '西陵区',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420503,
                        name: '伍家岗区',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420506,
                        name: '夷陵区',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420504,
                        name: '点军区',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420505,
                        name: '猇亭区',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420526,
                        name: '兴山县',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420527,
                        name: '秭归县',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420525,
                        name: '远安县',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420528,
                        name: '长阳土家族自治县',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420529,
                        name: '五峰土家族自治县',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420582,
                        name: '当阳市',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420583,
                        name: '枝江市',
                        parentId: 420500,
                      },
                      {
                        children: null,
                        id: 420581,
                        name: '宜都市',
                        parentId: 420500,
                      },
                    ],
                    id: 420500,
                    name: '宜昌市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 420606,
                        name: '樊城区',
                        parentId: 420600,
                      },
                      {
                        children: null,
                        id: 420607,
                        name: '襄州区',
                        parentId: 420600,
                      },
                      {
                        children: null,
                        id: 420602,
                        name: '襄城区',
                        parentId: 420600,
                      },
                      {
                        children: null,
                        id: 420626,
                        name: '保康县',
                        parentId: 420600,
                      },
                      {
                        children: null,
                        id: 420624,
                        name: '南漳县',
                        parentId: 420600,
                      },
                      {
                        children: null,
                        id: 420625,
                        name: '谷城县',
                        parentId: 420600,
                      },
                      {
                        children: null,
                        id: 420684,
                        name: '宜城市',
                        parentId: 420600,
                      },
                      {
                        children: null,
                        id: 420682,
                        name: '老河口市',
                        parentId: 420600,
                      },
                      {
                        children: null,
                        id: 420683,
                        name: '枣阳市',
                        parentId: 420600,
                      },
                    ],
                    id: 420600,
                    name: '襄阳市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 420702,
                        name: '梁子湖区',
                        parentId: 420700,
                      },
                      {
                        children: null,
                        id: 420703,
                        name: '华容区',
                        parentId: 420700,
                      },
                      {
                        children: null,
                        id: 420704,
                        name: '鄂城区',
                        parentId: 420700,
                      },
                    ],
                    id: 420700,
                    name: '鄂州市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 420804,
                        name: '掇刀区',
                        parentId: 420800,
                      },
                      {
                        children: null,
                        id: 420802,
                        name: '东宝区',
                        parentId: 420800,
                      },
                      {
                        children: null,
                        id: 420822,
                        name: '沙洋县',
                        parentId: 420800,
                      },
                      {
                        children: null,
                        id: 420821,
                        name: '京山县',
                        parentId: 420800,
                      },
                      {
                        children: null,
                        id: 420881,
                        name: '钟祥市',
                        parentId: 420800,
                      },
                    ],
                    id: 420800,
                    name: '荆门市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 429007,
                        name: '天门市',
                        parentId: 429006,
                      },
                    ],
                    id: 429006,
                    name: '天门市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 420902,
                        name: '孝南区',
                        parentId: 420900,
                      },
                      {
                        children: null,
                        id: 420922,
                        name: '大悟县',
                        parentId: 420900,
                      },
                      {
                        children: null,
                        id: 420923,
                        name: '云梦县',
                        parentId: 420900,
                      },
                      {
                        children: null,
                        id: 420921,
                        name: '孝昌县',
                        parentId: 420900,
                      },
                      {
                        children: null,
                        id: 420982,
                        name: '安陆市',
                        parentId: 420900,
                      },
                      {
                        children: null,
                        id: 420981,
                        name: '应城市',
                        parentId: 420900,
                      },
                      {
                        children: null,
                        id: 420984,
                        name: '汉川市',
                        parentId: 420900,
                      },
                    ],
                    id: 420900,
                    name: '孝感市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 421002,
                        name: '沙市区',
                        parentId: 421000,
                      },
                      {
                        children: null,
                        id: 421003,
                        name: '荆州区',
                        parentId: 421000,
                      },
                      {
                        children: null,
                        id: 421022,
                        name: '公安县',
                        parentId: 421000,
                      },
                      {
                        children: null,
                        id: 421023,
                        name: '监利县',
                        parentId: 421000,
                      },
                      {
                        children: null,
                        id: 421024,
                        name: '江陵县',
                        parentId: 421000,
                      },
                      {
                        children: null,
                        id: 421087,
                        name: '松滋市',
                        parentId: 421000,
                      },
                      {
                        children: null,
                        id: 421083,
                        name: '洪湖市',
                        parentId: 421000,
                      },
                      {
                        children: null,
                        id: 421081,
                        name: '石首市',
                        parentId: 421000,
                      },
                    ],
                    id: 421000,
                    name: '荆州市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 421102,
                        name: '黄州区',
                        parentId: 421100,
                      },
                      {
                        children: null,
                        id: 421126,
                        name: '蕲春县',
                        parentId: 421100,
                      },
                      {
                        children: null,
                        id: 421127,
                        name: '黄梅县',
                        parentId: 421100,
                      },
                      {
                        children: null,
                        id: 421124,
                        name: '英山县',
                        parentId: 421100,
                      },
                      {
                        children: null,
                        id: 421125,
                        name: '浠水县',
                        parentId: 421100,
                      },
                      {
                        children: null,
                        id: 421122,
                        name: '红安县',
                        parentId: 421100,
                      },
                      {
                        children: null,
                        id: 421123,
                        name: '罗田县',
                        parentId: 421100,
                      },
                      {
                        children: null,
                        id: 421121,
                        name: '团风县',
                        parentId: 421100,
                      },
                      {
                        children: null,
                        id: 421182,
                        name: '武穴市',
                        parentId: 421100,
                      },
                      {
                        children: null,
                        id: 421181,
                        name: '麻城市',
                        parentId: 421100,
                      },
                    ],
                    id: 421100,
                    name: '黄冈市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 421202,
                        name: '咸安区',
                        parentId: 421200,
                      },
                      {
                        children: null,
                        id: 421222,
                        name: '通城县',
                        parentId: 421200,
                      },
                      {
                        children: null,
                        id: 421223,
                        name: '崇阳县',
                        parentId: 421200,
                      },
                      {
                        children: null,
                        id: 421221,
                        name: '嘉鱼县',
                        parentId: 421200,
                      },
                      {
                        children: null,
                        id: 421224,
                        name: '通山县',
                        parentId: 421200,
                      },
                      {
                        children: null,
                        id: 421281,
                        name: '赤壁市',
                        parentId: 421200,
                      },
                    ],
                    id: 421200,
                    name: '咸宁市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 421303,
                        name: '曾都区',
                        parentId: 421300,
                      },
                      {
                        children: null,
                        id: 421321,
                        name: '随县',
                        parentId: 421300,
                      },
                      {
                        children: null,
                        id: 421381,
                        name: '广水市',
                        parentId: 421300,
                      },
                    ],
                    id: 421300,
                    name: '随州市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 422802,
                        name: '利川市',
                        parentId: 422800,
                      },
                      {
                        children: null,
                        id: 422801,
                        name: '恩施市',
                        parentId: 422800,
                      },
                      {
                        children: null,
                        id: 422822,
                        name: '建始县',
                        parentId: 422800,
                      },
                      {
                        children: null,
                        id: 422823,
                        name: '巴东县',
                        parentId: 422800,
                      },
                      {
                        children: null,
                        id: 422828,
                        name: '鹤峰县',
                        parentId: 422800,
                      },
                      {
                        children: null,
                        id: 422826,
                        name: '咸丰县',
                        parentId: 422800,
                      },
                      {
                        children: null,
                        id: 422827,
                        name: '来凤县',
                        parentId: 422800,
                      },
                      {
                        children: null,
                        id: 422825,
                        name: '宣恩县',
                        parentId: 422800,
                      },
                    ],
                    id: 422800,
                    name: '恩施土家族苗族自治州',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 422901,
                        name: '仙桃市',
                        parentId: 422900,
                      },
                    ],
                    id: 422900,
                    name: '仙桃市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 423001,
                        name: '潜江市',
                        parentId: 423000,
                      },
                    ],
                    id: 423000,
                    name: '潜江市',
                    parentId: 420000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 423101,
                        name: '神农架林区',
                        parentId: 423100,
                      },
                    ],
                    id: 423100,
                    name: '神农架林区',
                    parentId: 420000,
                  },
                ],
                id: 420000,
                name: '湖北省',
                parentId: 13,
              },
              {
                children: [
                  {
                    children: [
                      {
                        children: null,
                        id: 430102,
                        name: '芙蓉区',
                        parentId: 430100,
                      },
                      {
                        children: null,
                        id: 430103,
                        name: '天心区',
                        parentId: 430100,
                      },
                      {
                        children: null,
                        id: 430111,
                        name: '雨花区',
                        parentId: 430100,
                      },
                      {
                        children: null,
                        id: 430104,
                        name: '岳麓区',
                        parentId: 430100,
                      },
                      {
                        children: null,
                        id: 430105,
                        name: '开福区',
                        parentId: 430100,
                      },
                      {
                        children: null,
                        id: 430112,
                        name: '望城区',
                        parentId: 430100,
                      },
                      {
                        children: null,
                        id: 430124,
                        name: '宁乡县',
                        parentId: 430100,
                      },
                      {
                        children: null,
                        id: 430121,
                        name: '长沙县',
                        parentId: 430100,
                      },
                      {
                        children: null,
                        id: 430181,
                        name: '浏阳市',
                        parentId: 430100,
                      },
                    ],
                    id: 430100,
                    name: '长沙市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 430204,
                        name: '石峰区',
                        parentId: 430200,
                      },
                      {
                        children: null,
                        id: 430202,
                        name: '荷塘区',
                        parentId: 430200,
                      },
                      {
                        children: null,
                        id: 430203,
                        name: '芦淞区',
                        parentId: 430200,
                      },
                      {
                        children: null,
                        id: 430211,
                        name: '天元区',
                        parentId: 430200,
                      },
                      {
                        children: null,
                        id: 430223,
                        name: '攸县',
                        parentId: 430200,
                      },
                      {
                        children: null,
                        id: 430221,
                        name: '株洲县',
                        parentId: 430200,
                      },
                      {
                        children: null,
                        id: 430224,
                        name: '茶陵县',
                        parentId: 430200,
                      },
                      {
                        children: null,
                        id: 430225,
                        name: '炎陵县',
                        parentId: 430200,
                      },
                      {
                        children: null,
                        id: 430281,
                        name: '醴陵市',
                        parentId: 430200,
                      },
                    ],
                    id: 430200,
                    name: '株洲市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 430302,
                        name: '雨湖区',
                        parentId: 430300,
                      },
                      {
                        children: null,
                        id: 430304,
                        name: '岳塘区',
                        parentId: 430300,
                      },
                      {
                        children: null,
                        id: 430321,
                        name: '湘潭县',
                        parentId: 430300,
                      },
                      {
                        children: null,
                        id: 430382,
                        name: '韶山市',
                        parentId: 430300,
                      },
                      {
                        children: null,
                        id: 430381,
                        name: '湘乡市',
                        parentId: 430300,
                      },
                    ],
                    id: 430300,
                    name: '湘潭市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 430406,
                        name: '雁峰区',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430407,
                        name: '石鼓区',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430405,
                        name: '珠晖区',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430412,
                        name: '南岳区',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430408,
                        name: '蒸湘区',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430422,
                        name: '衡南县',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430423,
                        name: '衡山县',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430421,
                        name: '衡阳县',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430426,
                        name: '祁东县',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430424,
                        name: '衡东县',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430482,
                        name: '常宁市',
                        parentId: 430400,
                      },
                      {
                        children: null,
                        id: 430481,
                        name: '耒阳市',
                        parentId: 430400,
                      },
                    ],
                    id: 430400,
                    name: '衡阳市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 430502,
                        name: '双清区',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430503,
                        name: '大祥区',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430511,
                        name: '北塔区',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430527,
                        name: '绥宁县',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430524,
                        name: '隆回县',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430525,
                        name: '洞口县',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430522,
                        name: '新邵县',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430523,
                        name: '邵阳县',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430521,
                        name: '邵东县',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430528,
                        name: '新宁县',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430529,
                        name: '城步苗族自治县',
                        parentId: 430500,
                      },
                      {
                        children: null,
                        id: 430581,
                        name: '武冈市',
                        parentId: 430500,
                      },
                    ],
                    id: 430500,
                    name: '邵阳市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 430602,
                        name: '岳阳楼区',
                        parentId: 430600,
                      },
                      {
                        children: null,
                        id: 430603,
                        name: '云溪区',
                        parentId: 430600,
                      },
                      {
                        children: null,
                        id: 430611,
                        name: '君山区',
                        parentId: 430600,
                      },
                      {
                        children: null,
                        id: 430623,
                        name: '华容县',
                        parentId: 430600,
                      },
                      {
                        children: null,
                        id: 430621,
                        name: '岳阳县',
                        parentId: 430600,
                      },
                      {
                        children: null,
                        id: 430626,
                        name: '平江县',
                        parentId: 430600,
                      },
                      {
                        children: null,
                        id: 430624,
                        name: '湘阴县',
                        parentId: 430600,
                      },
                      {
                        children: null,
                        id: 430682,
                        name: '临湘市',
                        parentId: 430600,
                      },
                      {
                        children: null,
                        id: 430681,
                        name: '汨罗市',
                        parentId: 430600,
                      },
                    ],
                    id: 430600,
                    name: '岳阳市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 430702,
                        name: '武陵区',
                        parentId: 430700,
                      },
                      {
                        children: null,
                        id: 430703,
                        name: '鼎城区',
                        parentId: 430700,
                      },
                      {
                        children: null,
                        id: 430726,
                        name: '石门县',
                        parentId: 430700,
                      },
                      {
                        children: null,
                        id: 430724,
                        name: '临澧县',
                        parentId: 430700,
                      },
                      {
                        children: null,
                        id: 430725,
                        name: '桃源县',
                        parentId: 430700,
                      },
                      {
                        children: null,
                        id: 430722,
                        name: '汉寿县',
                        parentId: 430700,
                      },
                      {
                        children: null,
                        id: 430723,
                        name: '澧县',
                        parentId: 430700,
                      },
                      {
                        children: null,
                        id: 430721,
                        name: '安乡县',
                        parentId: 430700,
                      },
                      {
                        children: null,
                        id: 430781,
                        name: '津市市',
                        parentId: 430700,
                      },
                    ],
                    id: 430700,
                    name: '常德市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 430802,
                        name: '永定区',
                        parentId: 430800,
                      },
                      {
                        children: null,
                        id: 430811,
                        name: '武陵源区',
                        parentId: 430800,
                      },
                      {
                        children: null,
                        id: 430822,
                        name: '桑植县',
                        parentId: 430800,
                      },
                      {
                        children: null,
                        id: 430821,
                        name: '慈利县',
                        parentId: 430800,
                      },
                    ],
                    id: 430800,
                    name: '张家界市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 430902,
                        name: '资阳区',
                        parentId: 430900,
                      },
                      {
                        children: null,
                        id: 430903,
                        name: '赫山区',
                        parentId: 430900,
                      },
                      {
                        children: null,
                        id: 430922,
                        name: '桃江县',
                        parentId: 430900,
                      },
                      {
                        children: null,
                        id: 430923,
                        name: '安化县',
                        parentId: 430900,
                      },
                      {
                        children: null,
                        id: 430921,
                        name: '南县',
                        parentId: 430900,
                      },
                      {
                        children: null,
                        id: 430981,
                        name: '沅江市',
                        parentId: 430900,
                      },
                    ],
                    id: 430900,
                    name: '益阳市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 431002,
                        name: '北湖区',
                        parentId: 431000,
                      },
                      {
                        children: null,
                        id: 431003,
                        name: '苏仙区',
                        parentId: 431000,
                      },
                      {
                        children: null,
                        id: 431022,
                        name: '宜章县',
                        parentId: 431000,
                      },
                      {
                        children: null,
                        id: 431023,
                        name: '永兴县',
                        parentId: 431000,
                      },
                      {
                        children: null,
                        id: 431021,
                        name: '桂阳县',
                        parentId: 431000,
                      },
                      {
                        children: null,
                        id: 431028,
                        name: '安仁县',
                        parentId: 431000,
                      },
                      {
                        children: null,
                        id: 431026,
                        name: '汝城县',
                        parentId: 431000,
                      },
                      {
                        children: null,
                        id: 431027,
                        name: '桂东县',
                        parentId: 431000,
                      },
                      {
                        children: null,
                        id: 431024,
                        name: '嘉禾县',
                        parentId: 431000,
                      },
                      {
                        children: null,
                        id: 431025,
                        name: '临武县',
                        parentId: 431000,
                      },
                      {
                        children: null,
                        id: 431081,
                        name: '资兴市',
                        parentId: 431000,
                      },
                    ],
                    id: 431000,
                    name: '郴州市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 431102,
                        name: '零陵区',
                        parentId: 431100,
                      },
                      {
                        children: null,
                        id: 431103,
                        name: '冷水滩区',
                        parentId: 431100,
                      },
                      {
                        children: null,
                        id: 431126,
                        name: '宁远县',
                        parentId: 431100,
                      },
                      {
                        children: null,
                        id: 431127,
                        name: '蓝山县',
                        parentId: 431100,
                      },
                      {
                        children: null,
                        id: 431124,
                        name: '道县',
                        parentId: 431100,
                      },
                      {
                        children: null,
                        id: 431125,
                        name: '江永县',
                        parentId: 431100,
                      },
                      {
                        children: null,
                        id: 431122,
                        name: '东安县',
                        parentId: 431100,
                      },
                      {
                        children: null,
                        id: 431123,
                        name: '双牌县',
                        parentId: 431100,
                      },
                      {
                        children: null,
                        id: 431121,
                        name: '祁阳县',
                        parentId: 431100,
                      },
                      {
                        children: null,
                        id: 431128,
                        name: '新田县',
                        parentId: 431100,
                      },
                      {
                        children: null,
                        id: 431129,
                        name: '江华瑶族自治县',
                        parentId: 431100,
                      },
                    ],
                    id: 431100,
                    name: '永州市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 431202,
                        name: '鹤城区',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431222,
                        name: '沅陵县',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431223,
                        name: '辰溪县',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431221,
                        name: '中方县',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431230,
                        name: '通道侗族自治县',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431228,
                        name: '芷江侗族自治县',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431229,
                        name: '靖州苗族侗族自治县',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431226,
                        name: '麻阳苗族自治县',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431227,
                        name: '新晃侗族自治县',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431224,
                        name: '溆浦县',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431225,
                        name: '会同县',
                        parentId: 431200,
                      },
                      {
                        children: null,
                        id: 431281,
                        name: '洪江市',
                        parentId: 431200,
                      },
                    ],
                    id: 431200,
                    name: '怀化市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 431302,
                        name: '娄星区',
                        parentId: 431300,
                      },
                      {
                        children: null,
                        id: 431322,
                        name: '新化县',
                        parentId: 431300,
                      },
                      {
                        children: null,
                        id: 431321,
                        name: '双峰县',
                        parentId: 431300,
                      },
                      {
                        children: null,
                        id: 431382,
                        name: '涟源市',
                        parentId: 431300,
                      },
                      {
                        children: null,
                        id: 431381,
                        name: '冷水江市',
                        parentId: 431300,
                      },
                    ],
                    id: 431300,
                    name: '娄底市',
                    parentId: 430000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 433101,
                        name: '吉首市',
                        parentId: 433100,
                      },
                      {
                        children: null,
                        id: 433126,
                        name: '古丈县',
                        parentId: 433100,
                      },
                      {
                        children: null,
                        id: 433127,
                        name: '永顺县',
                        parentId: 433100,
                      },
                      {
                        children: null,
                        id: 433124,
                        name: '花垣县',
                        parentId: 433100,
                      },
                      {
                        children: null,
                        id: 433125,
                        name: '保靖县',
                        parentId: 433100,
                      },
                      {
                        children: null,
                        id: 433122,
                        name: '泸溪县',
                        parentId: 433100,
                      },
                      {
                        children: null,
                        id: 433123,
                        name: '凤凰县',
                        parentId: 433100,
                      },
                      {
                        children: null,
                        id: 433130,
                        name: '龙山县',
                        parentId: 433100,
                      },
                    ],
                    id: 433100,
                    name: '湘西土家族苗族自治州',
                    parentId: 430000,
                  },
                ],
                id: 430000,
                name: '湖南省',
                parentId: 13,
              },
            ],
            id: 13,
            name: '华中',
            parentId: 0,
          },
          {
            children: [
              {
                children: [
                  {
                    children: [
                      {
                        children: null,
                        id: 320102,
                        name: '玄武区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320103,
                        name: '白下区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320111,
                        name: '浦口区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320104,
                        name: '秦淮区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320105,
                        name: '建邺区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320106,
                        name: '鼓楼区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320107,
                        name: '下关区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320116,
                        name: '六合区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320113,
                        name: '栖霞区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320114,
                        name: '雨花台区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320115,
                        name: '江宁区',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320124,
                        name: '溧水县',
                        parentId: 320100,
                      },
                      {
                        children: null,
                        id: 320125,
                        name: '高淳县',
                        parentId: 320100,
                      },
                    ],
                    id: 320100,
                    name: '南京市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 320204,
                        name: '北塘区',
                        parentId: 320200,
                      },
                      {
                        children: null,
                        id: 320205,
                        name: '锡山区',
                        parentId: 320200,
                      },
                      {
                        children: null,
                        id: 320206,
                        name: '惠山区',
                        parentId: 320200,
                      },
                      {
                        children: null,
                        id: 320202,
                        name: '崇安区',
                        parentId: 320200,
                      },
                      {
                        children: null,
                        id: 320203,
                        name: '南长区',
                        parentId: 320200,
                      },
                      {
                        children: null,
                        id: 320211,
                        name: '滨湖区',
                        parentId: 320200,
                      },
                      {
                        children: null,
                        id: 320281,
                        name: '江阴市',
                        parentId: 320200,
                      },
                      {
                        children: null,
                        id: 320282,
                        name: '宜兴市',
                        parentId: 320200,
                      },
                      {
                        children: null,
                        id: 320283,
                        name: '新区',
                        parentId: 320200,
                      },
                    ],
                    id: 320200,
                    name: '无锡市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 320302,
                        name: '鼓楼区',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320303,
                        name: '云龙区',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320311,
                        name: '泉山区',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320305,
                        name: '贾汪区',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320312,
                        name: '铜山区',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320324,
                        name: '睢宁县',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320321,
                        name: '丰县',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320322,
                        name: '沛县',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320381,
                        name: '新沂市',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320382,
                        name: '邳州市',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320383,
                        name: '金山桥开发区',
                        parentId: 320300,
                      },
                      {
                        children: null,
                        id: 320387,
                        name: '八段工业园区',
                        parentId: 320300,
                      },
                    ],
                    id: 320300,
                    name: '徐州市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 320404,
                        name: '钟楼区',
                        parentId: 320400,
                      },
                      {
                        children: null,
                        id: 320405,
                        name: '戚墅堰区',
                        parentId: 320400,
                      },
                      {
                        children: null,
                        id: 320402,
                        name: '天宁区',
                        parentId: 320400,
                      },
                      {
                        children: null,
                        id: 320412,
                        name: '武进区',
                        parentId: 320400,
                      },
                      {
                        children: null,
                        id: 320411,
                        name: '新北区',
                        parentId: 320400,
                      },
                      {
                        children: null,
                        id: 320481,
                        name: '溧阳市',
                        parentId: 320400,
                      },
                      {
                        children: null,
                        id: 320482,
                        name: '金坛市',
                        parentId: 320400,
                      },
                    ],
                    id: 320400,
                    name: '常州市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 320502,
                        name: '沧浪区',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320508,
                        name: '姑苏区',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320509,
                        name: '吴江区',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320504,
                        name: '金阊区',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320505,
                        name: '虎丘区',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320506,
                        name: '吴中区',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320507,
                        name: '相城区',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320581,
                        name: '常熟市',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320582,
                        name: '张家港市',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320583,
                        name: '昆山市',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320585,
                        name: '太仓市',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320586,
                        name: '工业园区',
                        parentId: 320500,
                      },
                      {
                        children: null,
                        id: 320599,
                        name: '平江区',
                        parentId: 320500,
                      },
                    ],
                    id: 320500,
                    name: '苏州市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 320602,
                        name: '崇川区',
                        parentId: 320600,
                      },
                      {
                        children: null,
                        id: 320612,
                        name: '通州区',
                        parentId: 320600,
                      },
                      {
                        children: null,
                        id: 320611,
                        name: '港闸区',
                        parentId: 320600,
                      },
                      {
                        children: null,
                        id: 320621,
                        name: '海安县',
                        parentId: 320600,
                      },
                      {
                        children: null,
                        id: 320623,
                        name: '如东县',
                        parentId: 320600,
                      },
                      {
                        children: null,
                        id: 320684,
                        name: '海门市',
                        parentId: 320600,
                      },
                      {
                        children: null,
                        id: 320685,
                        name: '南通经济技术开发区',
                        parentId: 320600,
                      },
                      {
                        children: null,
                        id: 320681,
                        name: '启东市',
                        parentId: 320600,
                      },
                      {
                        children: null,
                        id: 320682,
                        name: '如皋市',
                        parentId: 320600,
                      },
                    ],
                    id: 320600,
                    name: '南通市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 320703,
                        name: '连云区',
                        parentId: 320700,
                      },
                      {
                        children: null,
                        id: 320705,
                        name: '新浦区',
                        parentId: 320700,
                      },
                      {
                        children: null,
                        id: 320706,
                        name: '海州区',
                        parentId: 320700,
                      },
                      {
                        children: null,
                        id: 320724,
                        name: '灌南县',
                        parentId: 320700,
                      },
                      {
                        children: null,
                        id: 320721,
                        name: '赣榆县',
                        parentId: 320700,
                      },
                      {
                        children: null,
                        id: 320722,
                        name: '东海县',
                        parentId: 320700,
                      },
                      {
                        children: null,
                        id: 320723,
                        name: '灌云县',
                        parentId: 320700,
                      },
                    ],
                    id: 320700,
                    name: '连云港市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 320804,
                        name: '淮阴区',
                        parentId: 320800,
                      },
                      {
                        children: null,
                        id: 320802,
                        name: '清河区',
                        parentId: 320800,
                      },
                      {
                        children: null,
                        id: 320803,
                        name: '淮安区',
                        parentId: 320800,
                      },
                      {
                        children: null,
                        id: 320811,
                        name: '清浦区',
                        parentId: 320800,
                      },
                      {
                        children: null,
                        id: 320829,
                        name: '洪泽县',
                        parentId: 320800,
                      },
                      {
                        children: null,
                        id: 320830,
                        name: '盱眙县',
                        parentId: 320800,
                      },
                      {
                        children: null,
                        id: 320831,
                        name: '金湖县',
                        parentId: 320800,
                      },
                      {
                        children: null,
                        id: 320826,
                        name: '涟水县',
                        parentId: 320800,
                      },
                      {
                        children: null,
                        id: 320832,
                        name: '经济开发区',
                        parentId: 320800,
                      },
                    ],
                    id: 320800,
                    name: '淮安市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 320902,
                        name: '亭湖区',
                        parentId: 320900,
                      },
                      {
                        children: null,
                        id: 320903,
                        name: '盐都区',
                        parentId: 320900,
                      },
                      {
                        children: null,
                        id: 320924,
                        name: '射阳县',
                        parentId: 320900,
                      },
                      {
                        children: null,
                        id: 320925,
                        name: '建湖县',
                        parentId: 320900,
                      },
                      {
                        children: null,
                        id: 320921,
                        name: '响水县',
                        parentId: 320900,
                      },
                      {
                        children: null,
                        id: 320922,
                        name: '滨海县',
                        parentId: 320900,
                      },
                      {
                        children: null,
                        id: 320923,
                        name: '阜宁县',
                        parentId: 320900,
                      },
                      {
                        children: null,
                        id: 320981,
                        name: '东台市',
                        parentId: 320900,
                      },
                      {
                        children: null,
                        id: 320982,
                        name: '大丰市',
                        parentId: 320900,
                      },
                    ],
                    id: 320900,
                    name: '盐城市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 321002,
                        name: '广陵区',
                        parentId: 321000,
                      },
                      {
                        children: null,
                        id: 321003,
                        name: '邗江区',
                        parentId: 321000,
                      },
                      {
                        children: null,
                        id: 321012,
                        name: '江都区',
                        parentId: 321000,
                      },
                      {
                        children: null,
                        id: 321023,
                        name: '宝应县',
                        parentId: 321000,
                      },
                      {
                        children: null,
                        id: 321084,
                        name: '高邮市',
                        parentId: 321000,
                      },
                      {
                        children: null,
                        id: 321081,
                        name: '仪征市',
                        parentId: 321000,
                      },
                      {
                        children: null,
                        id: 321088,
                        name: '江都市',
                        parentId: 321000,
                      },
                    ],
                    id: 321000,
                    name: '扬州市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 321102,
                        name: '京口区',
                        parentId: 321100,
                      },
                      {
                        children: null,
                        id: 321111,
                        name: '润州区',
                        parentId: 321100,
                      },
                      {
                        children: null,
                        id: 321112,
                        name: '丹徒区',
                        parentId: 321100,
                      },
                      {
                        children: null,
                        id: 321181,
                        name: '丹阳市',
                        parentId: 321100,
                      },
                      {
                        children: null,
                        id: 321182,
                        name: '扬中市',
                        parentId: 321100,
                      },
                      {
                        children: null,
                        id: 321183,
                        name: '句容市',
                        parentId: 321100,
                      },
                      {
                        children: null,
                        id: 321184,
                        name: '镇江新区',
                        parentId: 321100,
                      },
                    ],
                    id: 321100,
                    name: '镇江市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 321202,
                        name: '海陵区',
                        parentId: 321200,
                      },
                      {
                        children: null,
                        id: 321203,
                        name: '高港区',
                        parentId: 321200,
                      },
                      {
                        children: null,
                        id: 321284,
                        name: '姜堰市',
                        parentId: 321200,
                      },
                      {
                        children: null,
                        id: 321281,
                        name: '兴化市',
                        parentId: 321200,
                      },
                      {
                        children: null,
                        id: 321282,
                        name: '靖江市',
                        parentId: 321200,
                      },
                      {
                        children: null,
                        id: 321283,
                        name: '泰兴市',
                        parentId: 321200,
                      },
                    ],
                    id: 321200,
                    name: '泰州市',
                    parentId: 320000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 321302,
                        name: '宿城区',
                        parentId: 321300,
                      },
                      {
                        children: null,
                        id: 321311,
                        name: '宿豫区',
                        parentId: 321300,
                      },
                      {
                        children: null,
                        id: 321324,
                        name: '泗洪县',
                        parentId: 321300,
                      },
                      {
                        children: null,
                        id: 321322,
                        name: '沭阳县',
                        parentId: 321300,
                      },
                      {
                        children: null,
                        id: 321323,
                        name: '泗阳县',
                        parentId: 321300,
                      },
                    ],
                    id: 321300,
                    name: '宿迁市',
                    parentId: 320000,
                  },
                ],
                id: 320000,
                name: '江苏省',
                parentId: 10,
              },
              {
                children: [
                  {
                    children: [
                      {
                        children: null,
                        id: 330103,
                        name: '下城区',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330102,
                        name: '上城区',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330109,
                        name: '萧山区',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330108,
                        name: '滨江区',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330110,
                        name: '余杭区',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330105,
                        name: '拱墅区',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330104,
                        name: '江干区',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330106,
                        name: '西湖区',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330127,
                        name: '淳安县',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330122,
                        name: '桐庐县',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330183,
                        name: '富阳市',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330182,
                        name: '建德市',
                        parentId: 330100,
                      },
                      {
                        children: null,
                        id: 330185,
                        name: '临安市',
                        parentId: 330100,
                      },
                    ],
                    id: 330100,
                    name: '杭州市',
                    parentId: 330000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 330205,
                        name: '江北区',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330204,
                        name: '江东区',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330206,
                        name: '北仑区',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330203,
                        name: '海曙区',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330212,
                        name: '鄞州区',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330211,
                        name: '镇海区',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330225,
                        name: '象山县',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330226,
                        name: '宁海县',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330285,
                        name: '宁波保税区',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330284,
                        name: '高新科技开发区',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330281,
                        name: '余姚市',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330283,
                        name: '奉化市',
                        parentId: 330200,
                      },
                      {
                        children: null,
                        id: 330282,
                        name: '慈溪市',
                        parentId: 330200,
                      },
                    ],
                    id: 330200,
                    name: '宁波市',
                    parentId: 330000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 330303,
                        name: '龙湾区',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330302,
                        name: '鹿城区',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330304,
                        name: '瓯海区',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330324,
                        name: '永嘉县',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330327,
                        name: '苍南县',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330326,
                        name: '平阳县',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330322,
                        name: '洞头县',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330329,
                        name: '泰顺县',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330328,
                        name: '文成县',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330381,
                        name: '瑞安市',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330383,
                        name: '温州茶山高教园区',
                        parentId: 330300,
                      },
                      {
                        children: null,
                        id: 330382,
                        name: '乐清市',
                        parentId: 330300,
                      },
                    ],
                    id: 330300,
                    name: '温州市',
                    parentId: 330000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 330402,
                        name: '南湖区',
                        parentId: 330400,
                      },
                      {
                        children: null,
                        id: 330411,
                        name: '秀洲区',
                        parentId: 330400,
                      },
                      {
                        children: null,
                        id: 330421,
                        name: '嘉善县',
                        parentId: 330400,
                      },
                      {
                        children: null,
                        id: 330424,
                        name: '海盐县',
                        parentId: 330400,
                      },
                      {
                        children: null,
                        id: 330481,
                        name: '海宁市',
                        parentId: 330400,
                      },
                      {
                        children: null,
                        id: 330483,
                        name: '桐乡市',
                        parentId: 330400,
                      },
                      {
                        children: null,
                        id: 330482,
                        name: '平湖市',
                        parentId: 330400,
                      },
                    ],
                    id: 330400,
                    name: '嘉兴市',
                    parentId: 330000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 330503,
                        name: '南浔区',
                        parentId: 330500,
                      },
                      {
                        children: null,
                        id: 330502,
                        name: '吴兴区',
                        parentId: 330500,
                      },
                      {
                        children: null,
                        id: 330521,
                        name: '德清县',
                        parentId: 330500,
                      },
                      {
                        children: null,
                        id: 330523,
                        name: '安吉县',
                        parentId: 330500,
                      },
                      {
                        children: null,
                        id: 330522,
                        name: '长兴县',
                        parentId: 330500,
                      },
                    ],
                    id: 330500,
                    name: '湖州市',
                    parentId: 330000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 330601,
                        name: '绍兴市区',
                        parentId: 330600,
                      },
                      {
                        children: null,
                        id: 330603,
                        name: '柯桥区',
                        parentId: 330600,
                      },
                      {
                        children: null,
                        id: 330602,
                        name: '越城区',
                        parentId: 330600,
                      },
                      {
                        children: null,
                        id: 330621,
                        name: '绍兴县',
                        parentId: 330600,
                      },
                      {
                        children: null,
                        id: 330624,
                        name: '新昌县',
                        parentId: 330600,
                      },
                      {
                        children: null,
                        id: 330684,
                        name: '袍江工业区',
                        parentId: 330600,
                      },
                      {
                        children: null,
                        id: 330681,
                        name: '诸暨市',
                        parentId: 330600,
                      },
                      {
                        children: null,
                        id: 330683,
                        name: '嵊州市',
                        parentId: 330600,
                      },
                      {
                        children: null,
                        id: 330682,
                        name: '上虞市',
                        parentId: 330600,
                      },
                    ],
                    id: 330600,
                    name: '绍兴市',
                    parentId: 330000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 330703,
                        name: '金东区',
                        parentId: 330700,
                      },
                      {
                        children: null,
                        id: 330702,
                        name: '婺城区',
                        parentId: 330700,
                      },
                      {
                        children: null,
                        id: 330727,
                        name: '磐安县',
                        parentId: 330700,
                      },
                      {
                        children: null,
                        id: 330726,
                        name: '浦江县',
                        parentId: 330700,
                      },
                      {
                        children: null,
                        id: 330723,
                        name: '武义县',
                        parentId: 330700,
                      },
                      {
                        children: null,
                        id: 330781,
                        name: '兰溪市',
                        parentId: 330700,
                      },
                      {
                        children: null,
                        id: 330783,
                        name: '东阳市',
                        parentId: 330700,
                      },
                      {
                        children: null,
                        id: 330782,
                        name: '义乌市',
                        parentId: 330700,
                      },
                      {
                        children: null,
                        id: 330784,
                        name: '永康市',
                        parentId: 330700,
                      },
                    ],
                    id: 330700,
                    name: '金华市',
                    parentId: 330000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 330803,
                        name: '衢江区',
                        parentId: 330800,
                      },
                      {
                        children: null,
                        id: 330802,
                        name: '柯城区',
                        parentId: 330800,
                      },
                      {
                        children: null,
                        id: 330822,
                        name: '常山县',
                        parentId: 330800,
                      },
                      {
                        children: null,
                        id: 330825,
                        name: '龙游县',
                        parentId: 330800,
                      },
                      {
                        children: null,
                        id: 330824,
                        name: '开化县',
                        parentId: 330800,
                      },
                      {
                        children: null,
                        id: 330881,
                        name: '江山市',
                        parentId: 330800,
                      },
                    ],
                    id: 330800,
                    name: '衢州市',
                    parentId: 330000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 330903,
                        name: '普陀区',
                        parentId: 330900,
                      },
                      {
                        children: null,
                        id: 330902,
                        name: '定海区',
                        parentId: 330900,
                      },
                      {
                        children: null,
                        id: 330921,
                        name: '岱山县',
                        parentId: 330900,
                      },
                      {
                        children: null,
                        id: 330922,
                        name: '嵊泗县',
                        parentId: 330900,
                      },
                    ],
                    id: 330900,
                    name: '舟山市',
                    parentId: 330000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 331004,
                        name: '路桥区',
                        parentId: 331000,
                      },
                      {
                        children: null,
                        id: 331003,
                        name: '黄岩区',
                        parentId: 331000,
                      },
                      {
                        children: null,
                        id: 331002,
                        name: '椒江区',
                        parentId: 331000,
                      },
                      {
                        children: null,
                        id: 331021,
                        name: '玉环县',
                        parentId: 331000,
                      },
                      {
                        children: null,
                        id: 331023,
                        name: '天台县',
                        parentId: 331000,
                      },
                      {
                        children: null,
                        id: 331022,
                        name: '三门县',
                        parentId: 331000,
                      },
                      {
                        children: null,
                        id: 331024,
                        name: '仙居县',
                        parentId: 331000,
                      },
                      {
                        children: null,
                        id: 331081,
                        name: '温岭市',
                        parentId: 331000,
                      },
                      {
                        children: null,
                        id: 331082,
                        name: '临海市',
                        parentId: 331000,
                      },
                    ],
                    id: 331000,
                    name: '台州市',
                    parentId: 330000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 331102,
                        name: '莲都区',
                        parentId: 331100,
                      },
                      {
                        children: null,
                        id: 331125,
                        name: '云和县',
                        parentId: 331100,
                      },
                      {
                        children: null,
                        id: 331124,
                        name: '松阳县',
                        parentId: 331100,
                      },
                      {
                        children: null,
                        id: 331127,
                        name: '景宁畲族自治县',
                        parentId: 331100,
                      },
                      {
                        children: null,
                        id: 331126,
                        name: '庆元县',
                        parentId: 331100,
                      },
                      {
                        children: null,
                        id: 331121,
                        name: '青田县',
                        parentId: 331100,
                      },
                      {
                        children: null,
                        id: 331123,
                        name: '遂昌县',
                        parentId: 331100,
                      },
                      {
                        children: null,
                        id: 331122,
                        name: '缙云县',
                        parentId: 331100,
                      },
                      {
                        children: null,
                        id: 331181,
                        name: '龙泉市',
                        parentId: 331100,
                      },
                    ],
                    id: 331100,
                    name: '丽水市',
                    parentId: 330000,
                  },
                ],
                id: 330000,
                name: '浙江省',
                parentId: 10,
              },
              {
                children: [
                  {
                    children: [
                      {
                        children: null,
                        id: 340103,
                        name: '庐阳区',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340102,
                        name: '瑶海区',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340111,
                        name: '包河区',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340105,
                        name: '新站综合开发试验区',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340104,
                        name: '蜀山区',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340124,
                        name: '庐江县',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340121,
                        name: '长丰县',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340123,
                        name: '肥西县',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340122,
                        name: '肥东县',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340181,
                        name: '巢湖市',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340183,
                        name: '高新技术开发区',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340182,
                        name: '经济技术开发区',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340185,
                        name: '滨湖新区',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340184,
                        name: '北城新区',
                        parentId: 340100,
                      },
                      {
                        children: null,
                        id: 340186,
                        name: '政务文化新区',
                        parentId: 340100,
                      },
                    ],
                    id: 340100,
                    name: '合肥市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 340207,
                        name: '鸠江区',
                        parentId: 340200,
                      },
                      {
                        children: null,
                        id: 340203,
                        name: '弋江区',
                        parentId: 340200,
                      },
                      {
                        children: null,
                        id: 340202,
                        name: '镜湖区',
                        parentId: 340200,
                      },
                      {
                        children: null,
                        id: 340208,
                        name: '三山区',
                        parentId: 340200,
                      },
                      {
                        children: null,
                        id: 340221,
                        name: '芜湖县',
                        parentId: 340200,
                      },
                      {
                        children: null,
                        id: 340223,
                        name: '南陵县',
                        parentId: 340200,
                      },
                      {
                        children: null,
                        id: 340222,
                        name: '繁昌县',
                        parentId: 340200,
                      },
                      {
                        children: null,
                        id: 340225,
                        name: '无为县',
                        parentId: 340200,
                      },
                    ],
                    id: 340200,
                    name: '芜湖市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 340303,
                        name: '蚌山区',
                        parentId: 340300,
                      },
                      {
                        children: null,
                        id: 340302,
                        name: '龙子湖区',
                        parentId: 340300,
                      },
                      {
                        children: null,
                        id: 340311,
                        name: '淮上区',
                        parentId: 340300,
                      },
                      {
                        children: null,
                        id: 340304,
                        name: '禹会区',
                        parentId: 340300,
                      },
                      {
                        children: null,
                        id: 340321,
                        name: '怀远县',
                        parentId: 340300,
                      },
                      {
                        children: null,
                        id: 340323,
                        name: '固镇县',
                        parentId: 340300,
                      },
                      {
                        children: null,
                        id: 340322,
                        name: '五河县',
                        parentId: 340300,
                      },
                    ],
                    id: 340300,
                    name: '蚌埠市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 340405,
                        name: '八公山区',
                        parentId: 340400,
                      },
                      {
                        children: null,
                        id: 340404,
                        name: '谢家集区',
                        parentId: 340400,
                      },
                      {
                        children: null,
                        id: 340406,
                        name: '潘集区',
                        parentId: 340400,
                      },
                      {
                        children: null,
                        id: 340403,
                        name: '田家庵区',
                        parentId: 340400,
                      },
                      {
                        children: null,
                        id: 340402,
                        name: '大通区',
                        parentId: 340400,
                      },
                      {
                        children: null,
                        id: 340421,
                        name: '凤台县',
                        parentId: 340400,
                      },
                      {
                        children: null,
                        id: 340422,
                        name: '淮南高新技术开发区',
                        parentId: 340400,
                      },
                      {
                        children: null,
                        id: 341521,
                        name: '寿县',
                        parentId: 340400,
                      },
                    ],
                    id: 340400,
                    name: '淮南市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 340503,
                        name: '花山区',
                        parentId: 340500,
                      },
                      {
                        children: null,
                        id: 340504,
                        name: '雨山区',
                        parentId: 340500,
                      },
                      {
                        children: null,
                        id: 340506,
                        name: '博望区',
                        parentId: 340500,
                      },
                      {
                        children: null,
                        id: 340521,
                        name: '当涂县',
                        parentId: 340500,
                      },
                      {
                        children: null,
                        id: 340523,
                        name: '和县',
                        parentId: 340500,
                      },
                      {
                        children: null,
                        id: 340522,
                        name: '含山县',
                        parentId: 340500,
                      },
                    ],
                    id: 340500,
                    name: '马鞍山市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 340604,
                        name: '烈山区',
                        parentId: 340600,
                      },
                      {
                        children: null,
                        id: 340603,
                        name: '相山区',
                        parentId: 340600,
                      },
                      {
                        children: null,
                        id: 340602,
                        name: '杜集区',
                        parentId: 340600,
                      },
                      {
                        children: null,
                        id: 340621,
                        name: '濉溪县',
                        parentId: 340600,
                      },
                    ],
                    id: 340600,
                    name: '淮北市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 340703,
                        name: '狮子山区',
                        parentId: 340700,
                      },
                      {
                        children: null,
                        id: 340702,
                        name: '铜官山区',
                        parentId: 340700,
                      },
                      {
                        children: null,
                        id: 340711,
                        name: '郊区',
                        parentId: 340700,
                      },
                      {
                        children: null,
                        id: 340721,
                        name: '铜陵县',
                        parentId: 340700,
                      },
                      {
                        children: null,
                        id: 340722,
                        name: '枞阳县',
                        parentId: 340700,
                      },
                    ],
                    id: 340700,
                    name: '铜陵市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 340803,
                        name: '大观区',
                        parentId: 340800,
                      },
                      {
                        children: null,
                        id: 340802,
                        name: '迎江区',
                        parentId: 340800,
                      },
                      {
                        children: null,
                        id: 340811,
                        name: '宜秀区',
                        parentId: 340800,
                      },
                      {
                        children: null,
                        id: 340822,
                        name: '怀宁县',
                        parentId: 340800,
                      },
                      {
                        children: null,
                        id: 340828,
                        name: '岳西县',
                        parentId: 340800,
                      },
                      {
                        children: null,
                        id: 340825,
                        name: '太湖县',
                        parentId: 340800,
                      },
                      {
                        children: null,
                        id: 340824,
                        name: '潜山县',
                        parentId: 340800,
                      },
                      {
                        children: null,
                        id: 340827,
                        name: '望江县',
                        parentId: 340800,
                      },
                      {
                        children: null,
                        id: 340826,
                        name: '宿松县',
                        parentId: 340800,
                      },
                      {
                        children: null,
                        id: 340881,
                        name: '桐城市',
                        parentId: 340800,
                      },
                      {
                        children: null,
                        id: 340882,
                        name: '安庆市开发区',
                        parentId: 340800,
                      },
                    ],
                    id: 340800,
                    name: '安庆市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 341004,
                        name: '徽州区',
                        parentId: 341000,
                      },
                      {
                        children: null,
                        id: 341003,
                        name: '黄山区',
                        parentId: 341000,
                      },
                      {
                        children: null,
                        id: 341002,
                        name: '屯溪区',
                        parentId: 341000,
                      },
                      {
                        children: null,
                        id: 341021,
                        name: '歙县',
                        parentId: 341000,
                      },
                      {
                        children: null,
                        id: 341023,
                        name: '黟县',
                        parentId: 341000,
                      },
                      {
                        children: null,
                        id: 341022,
                        name: '休宁县',
                        parentId: 341000,
                      },
                      {
                        children: null,
                        id: 341024,
                        name: '祁门县',
                        parentId: 341000,
                      },
                    ],
                    id: 341000,
                    name: '黄山市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 341103,
                        name: '南谯区',
                        parentId: 341100,
                      },
                      {
                        children: null,
                        id: 341102,
                        name: '琅琊区',
                        parentId: 341100,
                      },
                      {
                        children: null,
                        id: 341125,
                        name: '定远县',
                        parentId: 341100,
                      },
                      {
                        children: null,
                        id: 341124,
                        name: '全椒县',
                        parentId: 341100,
                      },
                      {
                        children: null,
                        id: 341126,
                        name: '凤阳县',
                        parentId: 341100,
                      },
                      {
                        children: null,
                        id: 341122,
                        name: '来安县',
                        parentId: 341100,
                      },
                      {
                        children: null,
                        id: 341181,
                        name: '天长市',
                        parentId: 341100,
                      },
                      {
                        children: null,
                        id: 341182,
                        name: '明光市',
                        parentId: 341100,
                      },
                    ],
                    id: 341100,
                    name: '滁州市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 341204,
                        name: '颍泉区',
                        parentId: 341200,
                      },
                      {
                        children: null,
                        id: 341203,
                        name: '颍东区',
                        parentId: 341200,
                      },
                      {
                        children: null,
                        id: 341202,
                        name: '颍州区',
                        parentId: 341200,
                      },
                      {
                        children: null,
                        id: 341221,
                        name: '临泉县',
                        parentId: 341200,
                      },
                      {
                        children: null,
                        id: 341222,
                        name: '太和县',
                        parentId: 341200,
                      },
                      {
                        children: null,
                        id: 341225,
                        name: '阜南县',
                        parentId: 341200,
                      },
                      {
                        children: null,
                        id: 341226,
                        name: '颍上县',
                        parentId: 341200,
                      },
                      {
                        children: null,
                        id: 341283,
                        name: '阜阳经济技术开发区',
                        parentId: 341200,
                      },
                      {
                        children: null,
                        id: 341282,
                        name: '界首市',
                        parentId: 341200,
                      },
                    ],
                    id: 341200,
                    name: '阜阳市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 341302,
                        name: '埇桥区',
                        parentId: 341300,
                      },
                      {
                        children: null,
                        id: 341325,
                        name: '经济开发区',
                        parentId: 341300,
                      },
                      {
                        children: null,
                        id: 341324,
                        name: '泗县',
                        parentId: 341300,
                      },
                      {
                        children: null,
                        id: 341321,
                        name: '砀山县',
                        parentId: 341300,
                      },
                      {
                        children: null,
                        id: 341323,
                        name: '灵璧县',
                        parentId: 341300,
                      },
                      {
                        children: null,
                        id: 341322,
                        name: '萧县',
                        parentId: 341300,
                      },
                    ],
                    id: 341300,
                    name: '宿州市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 341503,
                        name: '裕安区',
                        parentId: 341500,
                      },
                      {
                        children: null,
                        id: 341502,
                        name: '金安区',
                        parentId: 341500,
                      },
                      {
                        children: null,
                        id: 341525,
                        name: '霍山县',
                        parentId: 341500,
                      },
                      {
                        children: null,
                        id: 341524,
                        name: '金寨县',
                        parentId: 341500,
                      },
                      {
                        children: null,
                        id: 341523,
                        name: '舒城县',
                        parentId: 341500,
                      },
                      {
                        children: null,
                        id: 341522,
                        name: '霍邱县',
                        parentId: 341500,
                      },
                    ],
                    id: 341500,
                    name: '六安市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 341602,
                        name: '谯城区',
                        parentId: 341600,
                      },
                      {
                        children: null,
                        id: 341621,
                        name: '涡阳县',
                        parentId: 341600,
                      },
                      {
                        children: null,
                        id: 341623,
                        name: '利辛县',
                        parentId: 341600,
                      },
                      {
                        children: null,
                        id: 341622,
                        name: '蒙城县',
                        parentId: 341600,
                      },
                    ],
                    id: 341600,
                    name: '亳州市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 341702,
                        name: '贵池区',
                        parentId: 341700,
                      },
                      {
                        children: null,
                        id: 341721,
                        name: '东至县',
                        parentId: 341700,
                      },
                      {
                        children: null,
                        id: 341723,
                        name: '青阳县',
                        parentId: 341700,
                      },
                      {
                        children: null,
                        id: 341722,
                        name: '石台县',
                        parentId: 341700,
                      },
                    ],
                    id: 341700,
                    name: '池州市',
                    parentId: 340000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 341802,
                        name: '宣州区',
                        parentId: 341800,
                      },
                      {
                        children: null,
                        id: 341821,
                        name: '郎溪县',
                        parentId: 341800,
                      },
                      {
                        children: null,
                        id: 341823,
                        name: '泾县',
                        parentId: 341800,
                      },
                      {
                        children: null,
                        id: 341822,
                        name: '广德县',
                        parentId: 341800,
                      },
                      {
                        children: null,
                        id: 341825,
                        name: '旌德县',
                        parentId: 341800,
                      },
                      {
                        children: null,
                        id: 341824,
                        name: '绩溪县',
                        parentId: 341800,
                      },
                      {
                        children: null,
                        id: 341881,
                        name: '宁国市',
                        parentId: 341800,
                      },
                    ],
                    id: 341800,
                    name: '宣城市',
                    parentId: 340000,
                  },
                ],
                id: 340000,
                name: '安徽省',
                parentId: 10,
              },
              {
                children: [
                  {
                    children: [
                      {
                        children: null,
                        id: 310101,
                        name: '黄浦区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310108,
                        name: '闸北区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310109,
                        name: '虹口区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310104,
                        name: '徐汇区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310105,
                        name: '长宁区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310106,
                        name: '静安区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310107,
                        name: '普陀区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310116,
                        name: '金山区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310117,
                        name: '松江区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310118,
                        name: '青浦区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310112,
                        name: '闵行区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310113,
                        name: '宝山区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310114,
                        name: '嘉定区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310115,
                        name: '浦东新区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310120,
                        name: '奉贤区',
                        parentId: 310100,
                      },
                      {
                        children: null,
                        id: 310130,
                        name: '崇明县',
                        parentId: 310100,
                      },
                    ],
                    id: 310100,
                    name: '上海市',
                    parentId: 310000,
                  },
                ],
                id: 310000,
                name: '上海市',
                parentId: 10,
              },
              {
                children: [
                  {
                    children: [
                      {
                        children: null,
                        id: 360502,
                        name: '渝水区',
                        parentId: 360500,
                      },
                      {
                        children: null,
                        id: 360521,
                        name: '分宜县',
                        parentId: 360500,
                      },
                    ],
                    id: 360500,
                    name: '新余市',
                    parentId: 360000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 360602,
                        name: '月湖区',
                        parentId: 360600,
                      },
                      {
                        children: null,
                        id: 360622,
                        name: '余江县',
                        parentId: 360600,
                      },
                      {
                        children: null,
                        id: 360681,
                        name: '贵溪市',
                        parentId: 360600,
                      },
                    ],
                    id: 360600,
                    name: '鹰潭市',
                    parentId: 360000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 360702,
                        name: '章贡区',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360725,
                        name: '崇义县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360724,
                        name: '上犹县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360727,
                        name: '龙南县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360726,
                        name: '安远县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360721,
                        name: '赣县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360723,
                        name: '大余县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360722,
                        name: '信丰县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360733,
                        name: '会昌县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360732,
                        name: '兴国县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360735,
                        name: '石城县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360734,
                        name: '寻乌县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360729,
                        name: '全南县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360728,
                        name: '定南县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360731,
                        name: '于都县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360730,
                        name: '宁都县',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360781,
                        name: '瑞金市',
                        parentId: 360700,
                      },
                      {
                        children: null,
                        id: 360782,
                        name: '南康市',
                        parentId: 360700,
                      },
                    ],
                    id: 360700,
                    name: '赣州市',
                    parentId: 360000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 360803,
                        name: '青原区',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360802,
                        name: '吉州区',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360821,
                        name: '吉安县',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360823,
                        name: '峡江县',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360822,
                        name: '吉水县',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360829,
                        name: '安福县',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360828,
                        name: '万安县',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360830,
                        name: '永新县',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360825,
                        name: '永丰县',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360824,
                        name: '新干县',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360827,
                        name: '遂川县',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360826,
                        name: '泰和县',
                        parentId: 360800,
                      },
                      {
                        children: null,
                        id: 360881,
                        name: '井冈山市',
                        parentId: 360800,
                      },
                    ],
                    id: 360800,
                    name: '吉安市',
                    parentId: 360000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 360902,
                        name: '袁州区',
                        parentId: 360900,
                      },
                      {
                        children: null,
                        id: 360925,
                        name: '靖安县',
                        parentId: 360900,
                      },
                      {
                        children: null,
                        id: 360924,
                        name: '宜丰县',
                        parentId: 360900,
                      },
                      {
                        children: null,
                        id: 360926,
                        name: '铜鼓县',
                        parentId: 360900,
                      },
                      {
                        children: null,
                        id: 360921,
                        name: '奉新县',
                        parentId: 360900,
                      },
                      {
                        children: null,
                        id: 360923,
                        name: '上高县',
                        parentId: 360900,
                      },
                      {
                        children: null,
                        id: 360922,
                        name: '万载县',
                        parentId: 360900,
                      },
                      {
                        children: null,
                        id: 360981,
                        name: '丰城市',
                        parentId: 360900,
                      },
                      {
                        children: null,
                        id: 360983,
                        name: '高安市',
                        parentId: 360900,
                      },
                      {
                        children: null,
                        id: 360982,
                        name: '樟树市',
                        parentId: 360900,
                      },
                    ],
                    id: 360900,
                    name: '宜春市',
                    parentId: 360000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 361002,
                        name: '临川区',
                        parentId: 361000,
                      },
                      {
                        children: null,
                        id: 361021,
                        name: '南城县',
                        parentId: 361000,
                      },
                      {
                        children: null,
                        id: 361023,
                        name: '南丰县',
                        parentId: 361000,
                      },
                      {
                        children: null,
                        id: 361022,
                        name: '黎川县',
                        parentId: 361000,
                      },
                      {
                        children: null,
                        id: 361029,
                        name: '东乡县',
                        parentId: 361000,
                      },
                      {
                        children: null,
                        id: 361028,
                        name: '资溪县',
                        parentId: 361000,
                      },
                      {
                        children: null,
                        id: 361030,
                        name: '广昌县',
                        parentId: 361000,
                      },
                      {
                        children: null,
                        id: 361025,
                        name: '乐安县',
                        parentId: 361000,
                      },
                      {
                        children: null,
                        id: 361024,
                        name: '崇仁县',
                        parentId: 361000,
                      },
                      {
                        children: null,
                        id: 361027,
                        name: '金溪县',
                        parentId: 361000,
                      },
                      {
                        children: null,
                        id: 361026,
                        name: '宜黄县',
                        parentId: 361000,
                      },
                    ],
                    id: 361000,
                    name: '抚州市',
                    parentId: 360000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 361102,
                        name: '信州区',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361125,
                        name: '横峰县',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361124,
                        name: '铅山县',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361127,
                        name: '余干县',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361126,
                        name: '弋阳县',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361121,
                        name: '上饶县',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361123,
                        name: '玉山县',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361122,
                        name: '广丰县',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361129,
                        name: '万年县',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361128,
                        name: '鄱阳县',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361130,
                        name: '婺源县',
                        parentId: 361100,
                      },
                      {
                        children: null,
                        id: 361181,
                        name: '德兴市',
                        parentId: 361100,
                      },
                    ],
                    id: 361100,
                    name: '上饶市',
                    parentId: 360000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 330013,
                        name: '昌北区',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 330015,
                        name: '高新区',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 330014,
                        name: '红谷滩新区',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 360103,
                        name: '西湖区',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 360102,
                        name: '东湖区',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 360111,
                        name: '青山湖区',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 360105,
                        name: '湾里区',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 360104,
                        name: '青云谱区',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 360124,
                        name: '进贤县',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 360121,
                        name: '南昌县',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 360123,
                        name: '安义县',
                        parentId: 360100,
                      },
                      {
                        children: null,
                        id: 360122,
                        name: '新建县',
                        parentId: 360100,
                      },
                    ],
                    id: 360100,
                    name: '南昌市',
                    parentId: 360000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 360203,
                        name: '珠山区',
                        parentId: 360200,
                      },
                      {
                        children: null,
                        id: 360202,
                        name: '昌江区',
                        parentId: 360200,
                      },
                      {
                        children: null,
                        id: 360222,
                        name: '浮梁县',
                        parentId: 360200,
                      },
                      {
                        children: null,
                        id: 360281,
                        name: '乐平市',
                        parentId: 360200,
                      },
                    ],
                    id: 360200,
                    name: '景德镇市',
                    parentId: 360000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 360302,
                        name: '安源区',
                        parentId: 360300,
                      },
                      {
                        children: null,
                        id: 360313,
                        name: '湘东区',
                        parentId: 360300,
                      },
                      {
                        children: null,
                        id: 360321,
                        name: '莲花县',
                        parentId: 360300,
                      },
                      {
                        children: null,
                        id: 360323,
                        name: '芦溪县',
                        parentId: 360300,
                      },
                      {
                        children: null,
                        id: 360322,
                        name: '上栗县',
                        parentId: 360300,
                      },
                    ],
                    id: 360300,
                    name: '萍乡市',
                    parentId: 360000,
                  },
                  {
                    children: [
                      {
                        children: null,
                        id: 360481,
                        name: '瑞昌市',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360482,
                        name: '共青城市',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360403,
                        name: '浔阳区',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360402,
                        name: '庐山区',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360421,
                        name: '九江县',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360423,
                        name: '武宁县',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360429,
                        name: '湖口县',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360428,
                        name: '都昌县',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360430,
                        name: '彭泽县',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360425,
                        name: '永修县',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360424,
                        name: '修水县',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360427,
                        name: '星子县',
                        parentId: 360400,
                      },
                      {
                        children: null,
                        id: 360426,
                        name: '德安县',
                        parentId: 360400,
                      },
                    ],
                    id: 360400,
                    name: '九江市',
                    parentId: 360000,
                  },
                ],
                id: 360000,
                name: '江西省',
                parentId: 10,
              },
            ],
            id: 10,
            name: '华东',
            parentId: 0,
          },
        ],
      }
    }
}
</script>
```
:::