/*
YARA rules generated with peid2yara.py
BY: Jaume Martin
GITHUB: https://git.todoparami.net/Xumeiquer/PEiD_to_Yara
GENERATED ON: 2020-03-13 12:16:31.981125

*/

import "pe"

rule RLPack_120_Basic_Edition_LZMA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_120_Basic_Edition_LZMA"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 9C 0C 00 00 EB 0C 8B 85 98 0C 00 00 89 85 9C 0C 00 00 8D B5 C4 0C 00 00 8D 9D 82 04 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 2D 0C 00 00 89 85 94 0C 00 00 E8 59 01 00 00 EB 20 60 8B 85 9C 0C 00 00 FF B5 94 0C 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 }
        $b = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 9C 0C 00 00 EB 0C 8B 85 98 0C 00 00 89 85 9C 0C 00 00 8D B5 C4 0C 00 00 8D 9D 82 04 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 2D 0C 00 00 89 85 94 0C 00 00 E8 59 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule CipherWall_Self_ExtratorDecryptor_GUI_v15: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CipherWall_Self_ExtratorDecryptor_GUI_v15"
        weight = 1
    strings:
        $a = { 90 61 BE 00 10 42 00 8D BE 00 00 FE FF C7 87 C0 20 02 00 F9 89 C7 6A 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 83 C1 02 81 FD 00 F3 FF FF 83 D1 01 8D 14 2F 83 FD FC 76 0F 8A 02 42 88 07 47 49 75 F7 E9 63 FF FF FF 90 8B 02 83 C2 04 89 07 83 C7 04 83 E9 04 77 F1 01 CF E9 4C FF FF FF 5E 89 F7 B9 52 10 00 00 8A 07 47 2C E8 3C 01 77 F7 80 3F 0E 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Basic_v60: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Basic_v60"
        weight = 1
    strings:
        $a = { FF 25 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? FF FF FF ?? ?? ?? ?? ?? ?? 30 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_31_North_Star_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_31_North_Star_h"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? ?? ?? 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEnguinCrypt_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEnguinCrypt_v10"
        weight = 1
    strings:
        $a = { B8 93 ?? ?? 00 55 50 67 64 FF 36 00 00 67 64 89 26 00 00 BD 4B 48 43 42 B8 04 00 00 00 CC 3C 04 75 04 90 90 C3 90 67 64 8F 06 00 00 58 5D BB 00 00 40 00 33 C9 33 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_bartxt_WinRAR_SFX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_bartxt_WinRAR_SFX"
        weight = 1
    strings:
        $a = { 50 B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 02 00 72 ?? B4 09 BA ?? ?? CD 21 B8 01 4C CD 21 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 59 2D ?? ?? 8E D0 51 2D ?? ?? 8E C0 50 B9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEQuake_v006_by_fORGAT: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEQuake_v006_by_fORGAT"
        weight = 1
    strings:
        $a = { E8 A5 00 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 3D ?? 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4A ?? 00 00 5B ?? 00 00 6E ?? 00 00 00 00 00 00 6B 45 72 4E 65 4C 33 32 2E 64 4C 6C 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 ?? ?? 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 5D 81 ED 05 00 00 00 8D 75 3D 56 FF 55 31 8D B5 81 00 00 00 56 50 FF 55 2D 89 85 8E 00 00 00 6A 04 68 00 10 00 00 68 ?? ?? 00 00 6A 00 FF 95 8E 00 00 00 50 8B 9D 7D 00 00 00 03 DD 50 53 E8 04 00 00 00 5A 55 FF E2 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_410_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_410_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 F8 8E 4C 00 68 D0 EA 49 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4C 00 33 D2 8A D4 89 15 7C A5 4C 00 8B C8 81 E1 FF 00 00 00 89 0D 78 A5 4C 00 C1 E1 08 03 CA 89 0D 74 A5 4C 00 C1 E8 10 A3 70 A5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SafeDisc_v4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SafeDisc_v4"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 42 6F 47 5F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Armor_049_Hying: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Armor_049_Hying"
        weight = 1
    strings:
        $a = { 56 52 51 53 55 E8 15 01 00 00 32 ?? ?? 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CI_Crypt_V01_FearlesS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CI_Crypt_V01_FearlesS"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Crunch_V50_Bitarts: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Crunch_V50_Bitarts"
        weight = 1
    strings:
        $a = { EB 15 03 00 00 00 06 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Graphics_Interface_Driver: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Graphics_Interface_Driver"
        weight = 1
    strings:
        $a = { 46 42 47 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Elicense_System_V4000_ViaTech_Inc: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Elicense_System_V4000_ViaTech_Inc"
        weight = 1
    strings:
        $a = { 00 00 00 00 63 79 62 00 65 6C 69 63 65 6E 34 30 2E 64 6C 6C 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nBinder_v361: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nBinder_v361"
        weight = 1
    strings:
        $a = { 6E 35 36 34 35 36 35 33 32 33 34 35 34 33 5F 6E 62 33 5C 00 5C 6E 35 36 34 35 36 35 33 32 33 34 35 34 33 5F 6E 62 33 5C }
        $b = { 6E 73 70 61 63 6B 24 40 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Upack_v024_v028_Alpha_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v024_v028_Alpha_Dwing"
        weight = 1
    strings:
        $a = { BE 88 01 40 00 AD ?? ?? 95 AD 91 F3 A5 AD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_C_for_Windows: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_C_for_Windows"
        weight = 1
    strings:
        $a = { 33 ED 55 9A ?? ?? ?? ?? 0B C0 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v1061b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v1061b"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED EA A8 43 ?? B8 E4 A8 43 ?? 03 C5 2B 85 78 AD 43 ?? 89 85 84 AD 43 ?? 80 BD 6E AD 43 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PUNiSHER_v15_DEMO_FEUERRADERAHTeam: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PUNiSHER_v15_DEMO_FEUERRADERAHTeam"
        weight = 1
    strings:
        $a = { EB 04 83 A4 BC CE 60 EB 04 80 BC 04 11 E8 00 00 00 00 81 2C 24 CA C2 41 00 EB 04 64 6B 88 18 5D E8 00 00 00 00 EB 04 64 6B 88 18 81 2C 24 86 00 00 00 EB 04 64 6B 88 18 8B 85 9C C2 41 00 EB 04 64 6B 88 18 29 04 24 EB 04 64 6B 88 18 EB 04 64 6B 88 18 8B 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v10801: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v10801"
        weight = 1
    strings:
        $a = { 60 EB 0A 5D EB 02 FF 25 45 FF E5 E8 E9 E8 F1 FF FF FF E9 81 ?? ?? ?? 44 00 BB 10 ?? 44 00 03 DD 2B 9D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v10802: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v10802"
        weight = 1
    strings:
        $a = { 90 90 75 01 90 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v10803: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v10803"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 0A 4A 44 00 BB 04 4A 44 00 03 DD 2B 9D B1 50 44 00 83 BD AC 50 44 00 00 89 9D BB 4E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v10804: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v10804"
        weight = 1
    strings:
        $a = { 60 E8 41 06 00 00 EB 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Fusion_10_jaNooNi: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Fusion_10_jaNooNi"
        weight = 1
    strings:
        $a = { 68 04 30 40 00 68 04 30 40 00 E8 09 03 00 00 68 04 30 40 00 E8 C7 02 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_v16x_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_v16x_Vaska"
        weight = 1
    strings:
        $a = { 60 90 61 61 80 7F F0 45 90 60 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pe123_v200644_412: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pe123_v200644_412"
        weight = 1
    strings:
        $a = { 8B C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF ?? ?? ?? 45 ?? 50 E8 ?? FF FF FF ?? ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 45 }
        $b = { 8B C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Nuts_Bolts_Disk_Image: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nuts_Bolts_Disk_Image"
        weight = 1
    strings:
        $a = { 4E 42 69 6D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_020_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_020_beta_Dwing"
        weight = 1
    strings:
        $a = { BE 88 01 40 00 AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Yodas_Protector_102: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Yodas_Protector_102"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 90 90 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Symantec_Visual_Cafe_v30: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Symantec_Visual_Cafe_v30"
        weight = 1
    strings:
        $a = { 53 FF 15 ?? ?? ?? 00 B3 22 38 18 74 03 80 C3 FE 8A 48 01 40 33 D2 3A CA 74 0A 3A CB 74 06 8A 48 01 40 EB F2 38 10 74 01 40 ?? ?? ?? ?? FF 15 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Stones_PE_Encruptor_v113: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Stones_PE_Encruptor_v113"
        weight = 1
    strings:
        $a = { 55 57 56 52 51 53 E8 ?? ?? ?? ?? 5D 8B D5 81 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yzpack_112_UsAr: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yzpack_112_UsAr"
        weight = 1
    strings:
        $a = { 5A 52 45 60 83 EC 18 8B EC 8B FC 33 C0 64 8B 40 30 78 0C 8B 40 0C 8B 70 1C AD 8B 40 08 EB 09 8B 40 34 83 C0 7C 8B 40 3C AB E9 ?? ?? ?? ?? B4 09 BA 00 00 1F CD 21 B8 01 4C CD 21 40 00 00 00 50 45 00 00 4C 01 02 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 E0 00 ?? ?? 0B 01 ?? ?? ?? ?? 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TXT2COM_Read_A_Matic_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TXT2COM_Read_A_Matic_v10"
        weight = 1
    strings:
        $a = { B8 ?? ?? 8E D8 8C 06 ?? ?? FA 8E D0 BC ?? ?? FB B4 ?? CD 21 A3 ?? ?? 06 50 B4 34 CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ARM_Protector_01_by_SMoKE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ARM_Protector_01_by_SMoKE"
        weight = 1
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 5E 1F 40 00 EB 02 83 09 8D B5 EF 1F 40 00 EB 02 83 09 BA A3 11 00 00 EB 01 00 8D 8D 92 31 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4 }
        $b = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 5E 1F 40 00 EB 02 83 09 8D B5 EF 1F 40 00 EB 02 83 09 BA A3 11 00 00 EB 01 00 8D 8D 92 31 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule RLPack_118_aPlib_043_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_118_aPlib_043_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 ?? 83 C7 ?? 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 BD 0A 04 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 A7 03 00 00 89 85 16 04 00 00 5B FF B5 16 04 00 00 56 FF D3 83 C4 ?? 8B B5 16 04 00 00 8B C6 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule XWD_graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID XWD_graphics_format"
        weight = 1
    strings:
        $a = { 00 00 00 71 00 00 00 07 00 00 00 02 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_CAB_SFX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_CAB_SFX"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC 44 56 FF 15 ?? 10 00 01 8B F0 8A 06 3C 22 75 14 8A 46 01 46 84 C0 74 04 3C 22 75 F4 80 3E 22 75 0D ?? EB 0A 3C 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_118_LZMA_430_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_118_LZMA_430_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A 00 00 FF 34 37 FF 74 37 04 FF D3 61 83 C7 ?? 83 3C 37 00 75 E6 83 BD 0D 0B 00 00 00 74 0E 83 BD 11 0B 00 00 00 74 05 E8 F6 01 00 00 8D 74 37 04 53 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 95 AA 0A 00 00 89 85 1D 0B 00 00 5B 60 FF B5 F9 0A 00 00 56 FF B5 1D 0B 00 00 FF D3 61 8B B5 1D 0B 00 00 8B C6 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AntiDote_v14_osCE_Sing_by_osCppCoDeR: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiDote_v14_osCE_Sing_by_osCppCoDeR"
        weight = 1
    strings:
        $a = { 68 95 01 00 00 E8 D0 FD FF FF 68 95 01 00 00 E8 C3 FD FF FF 68 90 03 00 00 E8 BC FD FF FF 68 90 03 00 00 E8 B2 FD FF FF 50 E8 AC FD FF FF 50 E8 A6 FD FF FF 68 69 D6 00 00 E8 9C FD FF FF 50 E8 96 FD FF FF 50 E8 90 FD FF FF 83 C4 20 E8 78 FF FF FF 84 C0 74 4F 68 04 01 00 00 68 10 22 60 00 6A 00 FF 15 08 10 60 00 68 90 03 00 00 E8 68 FD FF FF 68 69 D6 00 00 E8 5E FD FF FF 50 E8 58 FD FF FF 50 E8 52 FD FF FF E8 DD FE FF FF 50 68 A4 10 60 00 68 94 10 60 00 68 10 22 60 00 E8 58 FD FF FF 83 C4 20 33 C0 C2 10 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VPacker_ttui: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VPacker_ttui"
        weight = 1
    strings:
        $a = { 89 C6 C7 45 E0 01 00 00 00 F7 03 00 00 FF FF 75 18 0F B7 03 50 8B 45 D8 50 FF 55 F8 89 07 8B C3 E8 ?? FE FF FF 8B D8 EB 13 53 8B 45 D8 50 FF 55 F8 89 07 8B C3 E8 ?? FE FF FF 8B D8 83 C7 04 FF 45 E0 4E 75 C4 8B F3 83 3E 00 75 88 8B 45 E4 8B 40 10 03 45 DC 8B 55 14 83 C2 20 89 02 68 00 80 00 00 6A 00 8B 45 D4 50 FF 55 EC 8B 55 DC 8B 42 3C 03 45 DC 83 C0 04 8B D8 83 C3 14 8D 45 E0 50 6A 40 68 00 10 00 00 52 FF 55 E8 8D 43 60 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1342_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1342_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 24 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 01 ?? EB 03 ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 01 ?? E8 C3 27 00 00 }
        $b = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 24 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 50 EB 04 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ASProtect_v123_RC1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v123_RC1"
        weight = 1
    strings:
        $a = { 53 60 BD ?? ?? ?? ?? 8D 45 ?? 8D 5D ?? E8 ?? ?? ?? ?? 8D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V07_cyberbobnbsp_nbsp_SignByfly_20080312: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V07_cyberbobnbsp_nbsp_SignByfly_20080312"
        weight = 1
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 EB 04 ?? EB 04 00 EB FB FF 8B ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? EB 01 ?? 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 ?? EB FB ?? 83 04 24 0C C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_PESHiELD_025_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_PESHiELD_025_emadicius"
        weight = 1
    strings:
        $a = { EB 06 68 2E A8 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v029_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v029_beta_Dwing"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 4C 01 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 29 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_13013_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_13013_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 01 ?? E8 26 00 00 00 EB 02 ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 01 ?? 33 C0 EB 03 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Simple_UPX_Cryptor_v3042005_One_layer_encryption: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Simple_UPX_Cryptor_v3042005_One_layer_encryption"
        weight = 1
    strings:
        $a = { 60 B8 ?? ?? ?? 00 B9 ?? 01 00 00 80 34 08 ?? E2 FA 61 68 ?? ?? ?? 00 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSVCpp_DLL_v8_typical_OEP_recognized_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSVCpp_DLL_v8_typical_OEP_recognized_h"
        weight = 1
    strings:
        $a = { 8B FF 55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 75 09 83 3D ?? ?? ?? ?? 00 EB 26 83 FE 01 74 05 83 FE 02 75 22 A1 ?? ?? ?? ?? 85 C0 74 09 57 56 53 FF D0 85 C0 74 0C 57 56 53 E8 ?? ?? ?? FF 85 C0 75 04 33 C0 EB 4E 57 56 53 E8 ?? ?? ?? FF 83 FE 01 89 45 0C 75 0C 85 C0 75 37 57 50 53 E8 ?? ?? ?? FF 85 F6 74 05 83 FE 03 75 26 57 56 53 E8 ?? ?? ?? FF 85 C0 75 03 21 45 0C 83 7D 0C 00 74 11 A1 ?? ?? ?? ?? 85 C0 74 08 57 56 53 FF D0 89 45 0C 8B 45 0C 5F 5E 5B 5D C2 0C 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule muckis_protector: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID muckis_protector"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8A 06 F6 D0 88 06 46 E2 F7 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RSCs_Process_Patcher_v151: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RSCs_Process_Patcher_v151"
        weight = 1
    strings:
        $a = { 68 00 20 40 00 E8 C3 01 00 00 80 38 00 74 0D 66 81 78 FE 22 20 75 02 EB 03 40 EB EE 8B F8 B8 04 60 40 00 68 C4 20 40 00 68 D4 20 40 00 6A 00 6A 00 6A 04 6A 00 6A 00 6A 00 57 50 E8 9F 01 00 00 85 C0 0F 84 39 01 00 00 BE 00 60 40 00 8B 06 A3 28 21 40 00 83 C6 40 83 7E FC 00 0F 84 8F 00 00 00 8B 3E 83 C6 04 85 FF 0F 84 E5 00 00 00 81 FF 72 21 73 63 74 7A 0F B7 1E 8B CF 8D 7E 02 C7 05 24 21 40 00 00 00 00 00 83 05 24 21 40 00 01 50 A1 28 21 40 00 39 05 24 21 40 00 58 0F 84 D8 00 00 00 60 6A 00 53 68 2C 21 40 00 51 FF 35 C4 20 40 00 E8 0A 01 00 00 61 60 FC BE 2C 21 40 00 8B CB F3 A6 61 75 C2 03 FB 60 E8 3E 00 00 00 6A 00 53 57 51 FF 35 C4 20 40 00 E8 FB 00 00 00 85 C0 0F 84 A2 00 00 00 61 03 FB 8B F7 E9 71 FF FF FF 60 FF 35 C8 20 40 00 E8 CB 00 00 00 61 C7 05 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule COP_v10_c_1988: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID COP_v10_c_1988"
        weight = 1
    strings:
        $a = { BF ?? ?? BE ?? ?? B9 ?? ?? AC 32 ?? ?? ?? AA E2 ?? 8B ?? ?? ?? EB ?? 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DOS_Device_Driver: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DOS_Device_Driver"
        weight = 1
    strings:
        $a = { FF FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V13betaX_cyberbobnbsp_nbsp_SignByfly_20080311: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V13betaX_cyberbobnbsp_nbsp_SignByfly_20080311"
        weight = 1
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 71 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 EB 04 ?? EB 04 ?? EB FB ?? ?? ?? ?? ?? ?? ?? 8B 42 3C 03 C2 ?? ?? ?? ?? ?? ?? EB 02 ?? ?? F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_60_SFX_Custom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_60_SFX_Custom"
        weight = 1
    strings:
        $a = { E8 21 48 00 00 E9 16 FE FF FF 51 C7 01 08 B4 00 30 E8 A4 48 00 00 59 C3 56 8B F1 E8 EA FF FF FF F6 ?? ?? ?? ?? 74 07 56 E8 F6 04 00 00 59 8B C6 5E C2 04 00 8B 44 24 04 83 C1 09 51 83 C0 09 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ANDpakk2_006_Dmitry_Andreev: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ANDpakk2_006_Dmitry_Andreev"
        weight = 1
    strings:
        $a = { 60 FC BE D4 00 40 00 BF 00 10 00 01 57 83 CD FF 33 C9 F9 EB 05 A4 02 DB 75 05 8A 1E 46 12 DB 72 F4 33 C0 40 02 DB 75 05 8A 1E 46 12 DB 13 C0 02 DB 75 05 8A 1E 46 12 DB 72 0E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Alex_Protector_10_beta_2_by_Alex: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Alex_Protector_10_beta_2_by_Alex"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 10 40 00 E8 24 00 00 00 EB 01 E9 8B 44 24 0C EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 83 80 B8 00 00 00 02 33 C0 EB 01 E9 C3 58 83 C4 04 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 EB 01 E9 FF FF 60 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 0F 31 8B D8 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 8B CA EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 0F 31 2B C3 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 1B D1 0F 31 03 C3 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 13 D1 0F 31 2B C3 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 EB 05 68 F0 0F C7 C8 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 1B D1 EB 03 EB 03 C7 EB FB E8 01 00 00 00 A8 83 C4 04 85 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AsCrypt_v01_SToRM: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AsCrypt_v01_SToRM"
        weight = 1
    strings:
        $a = { 81 ?? ?? ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? ?? ?? 83 ?? ?? E2 ?? EB }
        $b = { 83 ?? ?? E2 ?? ?? E2 ?? FF }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule eXcalibur_v103_forgotus_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXcalibur_v103_forgotus_h"
        weight = 1
    strings:
        $a = { E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 EB 39 20 45 78 63 61 6C 69 62 75 72 20 28 63 29 20 62 79 20 66 6F 72 67 6F 74 2F 75 53 2F 44 46 43 47 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0D 0A 60 9C 9C 6A 63 73 0B EB 02 E8 E8 E8 06 00 00 00 E8 E8 73 F7 E8 E8 83 C4 04 EB 02 E8 E8 FF 0C 24 71 01 E8 79 E0 7A 01 E8 83 C4 04 9D EB 01 E8 E8 01 00 00 00 E9 5D 81 ED AE 28 40 00 9C 6A 63 73 0B EB 02 69 69 E8 06 00 00 00 69 69 73 F7 69 69 83 C4 04 EB 02 69 69 FF 0C 24 71 01 69 79 E0 7A 01 69 83 C4 04 9D EB 01 69 E8 E7 02 00 00 E8 9C 6A 63 73 0B EB 02 69 69 E8 06 00 00 00 69 69 73 F7 69 69 83 C4 04 EB 02 69 69 FF 0C 24 71 01 69 79 E0 7A 01 69 83 C4 04 9D EB 01 69 E8 B4 02 00 00 E8 60 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v25_Retail_Slim_Loader_Bitsum_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v25_Retail_Slim_Loader_Bitsum_Technologies"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? 01 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 32 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_nSPack_13_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_nSPack_13_emadicius"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 D3 FE FF FF 8B 06 83 F8 00 74 11 8D B5 DF FE FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1350_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1350_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 03 ?? ?? ?? E8 ?? ?? ?? ?? EB 02 ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 20 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 01 ?? E8 ?? ?? ?? ?? EB 01 ?? EB 02 ?? ?? 58 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 02 ?? ?? 83 C4 04 EB 01 ?? E8 }
        $b = { EB 03 ?? ?? ?? E8 ?? ?? ?? ?? EB 02 ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 20 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 04 ?? ?? ?? ?? 50 EB }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule MoleBox_v230_Teggo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MoleBox_v230_Teggo"
        weight = 1
    strings:
        $a = { 42 04 E8 ?? ?? 00 00 A3 ?? ?? ?? 00 8B 4D F0 8B 11 89 15 ?? ?? ?? 00 ?? 45 FC A3 ?? ?? ?? 00 5F 5E 8B E5 5D C3 CC CC CC CC CC CC CC CC CC CC CC E8 EB FB FF FF 58 E8 ?? 07 00 00 58 89 44 24 20 61 58 FF D0 E8 ?? ?? 00 00 CC CC CC CC CC CC CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimbiOZ_PolyCryptor_vxx_Extranger: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimbiOZ_PolyCryptor_vxx_Extranger"
        weight = 1
    strings:
        $a = { 55 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_239_minimum_protection_wwwstrongbitcom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_239_minimum_protection_wwwstrongbitcom"
        weight = 1
    strings:
        $a = { 51 68 ?? ?? ?? ?? 59 81 F1 12 3C CB 98 E9 53 2C 00 00 F7 D7 E9 EB 60 00 00 83 45 F8 02 E9 E3 36 00 00 F6 45 F8 20 0F 84 1E 21 00 00 55 E9 80 62 00 00 87 0C 24 8B E9 ?? ?? ?? ?? 00 00 23 C1 81 E9 ?? ?? ?? ?? 57 E9 ED 00 00 00 0F 88 ?? ?? ?? ?? E9 2C 0D 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Wise_Installer_Stub_v11010291: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Wise_Installer_Stub_v11010291"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 40 0F 00 00 53 56 57 6A 04 FF 15 F4 30 40 00 FF 15 74 30 40 00 8A 08 89 45 E8 80 F9 22 75 48 8A 48 01 40 89 45 E8 33 F6 84 C9 74 0E 80 F9 22 74 09 8A 48 01 40 89 45 E8 EB EE 80 38 22 75 04 40 89 45 E8 80 38 20 75 09 40 80 38 20 74 FA 89 45 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEncrypt_v30: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEncrypt_v30"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 5D 81 ED 05 10 40 00 8D B5 24 10 40 00 8B FE B9 0F 00 00 00 BB ?? ?? ?? ?? AD 33 C3 E2 FA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_16c_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_16c_Vaska"
        weight = 1
    strings:
        $a = { 8B C7 03 04 24 2B C7 80 38 50 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MinGW_32x_main: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MinGW_32x_main"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 18 89 75 FC 8B 75 0C 89 5D F8 83 FE 01 74 5C 89 74 24 04 8B 55 10 89 54 24 08 8B 55 08 89 14 24 E8 76 01 00 00 83 EC 0C 83 FE 01 89 C3 74 2C 85 F6 75 0C 8B 0D 00 30 00 10 85 C9 75 10 31 DB 89 D8 8B 5D F8 8B 75 FC 89 EC 5D C2 0C 00 E8 59 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Private_Personal_Packer_PPP_103_ConquestOfTroycom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_Personal_Packer_PPP_103_ConquestOfTroycom"
        weight = 1
    strings:
        $a = { E8 19 00 00 00 90 90 E8 68 00 00 00 FF 35 2C 37 00 10 E8 ED 01 00 00 6A 00 E8 2E 04 00 00 E8 41 04 00 00 A3 74 37 00 10 6A 64 E8 5F 04 00 00 E8 30 04 00 00 A3 78 37 00 10 6A 64 E8 4E 04 00 00 E8 1F 04 00 00 A3 7C 37 00 10 A1 74 37 00 10 8B 1D 78 37 00 10 2B D8 8B 0D 7C 37 00 10 2B C8 83 FB 64 73 0F 81 F9 C8 00 00 00 73 07 6A 00 E8 D9 03 00 00 C3 6A 0A 6A 07 6A 00 E8 D3 03 00 00 A3 20 37 00 10 50 6A 00 E8 DE 03 00 00 A3 24 37 00 10 FF 35 20 37 00 10 6A 00 E8 EA 03 00 00 A3 30 37 00 10 FF 35 24 37 00 10 E8 C2 03 00 00 A3 28 37 00 10 8B 0D 30 37 00 10 8B 3D 28 37 00 10 EB 09 49 C0 04 39 55 80 34 39 24 0B C9 }
        $b = { E8 19 00 00 00 90 90 E8 68 00 00 00 FF 35 2C 37 00 10 E8 ED 01 00 00 6A 00 E8 2E 04 00 00 E8 41 04 00 00 A3 74 37 00 10 6A 64 E8 5F 04 00 00 E8 30 04 00 00 A3 78 37 00 10 6A 64 E8 4E 04 00 00 E8 1F 04 00 00 A3 7C 37 00 10 A1 74 37 00 10 8B 1D 78 37 00 10 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Armadillo_V520_Silicon_Realms_Toolworks_SignByfly_20080214: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_V520_Silicon_Realms_Toolworks_SignByfly_20080214"
        weight = 1
    strings:
        $a = { E8 38 3D 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 98 1E 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 EC 1C 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 7D 1C 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? ?? 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 FE 1A 00 00 59 89 7D FC FF 75 08 E8 56 45 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 96 D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 C0 FA FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 A4 19 00 00 59 C3 3B DF 75 0D 8B 45 10 3B C7 74 06 C7 00 0C 00 00 00 8B C3 E8 CC 1D 00 00 C3 55 8B EC 51 83 65 FC 00 57 8D 45 FC 50 FF 75 0C FF 75 08 E8 CA FE FF FF 8B F8 83 C4 0C 85 FF 75 19 56 8B 75 FC 85 F6 74 10 E8 C9 1B 00 00 85 C0 74 07 E8 C0 1B 00 00 89 30 5E 8B C7 5F C9 C3 6A 0C 68 ?? ?? ?? ?? E8 3B 1D 00 00 8B 75 08 85 F6 74 75 83 3D ?? ?? ?? ?? ?? 75 43 6A 04 E8 FF 19 00 00 59 83 65 FC 00 56 E8 84 3C 00 00 59 89 45 E4 85 C0 74 09 56 50 E8 A0 3C 00 00 59 59 C7 45 FC FE FF FF FF E8 0B 00 00 00 83 7D E4 00 75 37 FF 75 08 EB 0A 6A 04 E8 ED 18 00 00 59 C3 }
        $b = { E8 38 3D 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 98 1E 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 EC 1C 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 7D 1C 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_02_FSG_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_FSG_10"
        weight = 1
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 BB D0 01 40 00 BF 00 10 40 00 BE 90 90 90 90 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule bambam_001_bedrock: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID bambam_001_bedrock"
        weight = 1
    strings:
        $a = { 6A 14 E8 9A 05 00 00 8B D8 53 68 ?? ?? ?? ?? E8 6C FD FF FF B9 05 00 00 00 8B F3 BF ?? ?? ?? ?? 53 F3 A5 E8 8D 05 00 00 8B 3D ?? ?? ?? ?? A1 ?? ?? ?? ?? 66 8B 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? 2B CF 89 45 E8 89 0D ?? ?? ?? ?? 66 89 55 EC 8B 41 3C 33 D2 03 C1 83 C4 10 66 8B 48 06 66 8B 50 14 81 E1 FF FF 00 00 8D 5C 02 18 8D 41 FF 85 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPack_v011: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPack_v011"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 ?? F3 AB C1 E0 ?? B5 ?? F3 AB AD 50 97 51 AD 87 F5 58 8D 54 86 5C FF D5 72 5A 2C ?? 73 ?? B0 ?? 3C ?? 72 02 2C ?? 50 0F B6 5F FF C1 E3 ?? B3 ?? 8D 1C 5B 8D ?? ?? ?? ?? ?? ?? B0 ?? 67 E3 29 8B D7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MacroMedia_ShockWave_Movie_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MacroMedia_ShockWave_Movie_file"
        weight = 1
    strings:
        $a = { 46 57 53 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V115_V116_aPlib_043_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V115_V116_aPlib_043_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 45 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ThemidaWinLicense_V1X_Oreans_Technologies_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ThemidaWinLicense_V1X_Oreans_Technologies_SignByfly"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 43 4F 4D 43 54 4C 33 32 2E 64 6C 6C 00 00 00 49 6E 69 74 43 6F 6D 6D 6F 6E 43 6F 6E 74 72 6F 6C 73 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule The_aPE_Inline_Patch_ExtraStealth_SuperStealth: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID The_aPE_Inline_Patch_ExtraStealth_SuperStealth"
        weight = 1
    strings:
        $a = { E8 02 ?? ?? ?? EB 01 C3 3E 8B 44 24 FC 50 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASYLUM_Music_File_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASYLUM_Music_File_v10"
        weight = 1
    strings:
        $a = { 41 53 59 4C 55 4D 20 4D 75 73 69 63 20 46 6F 72 6D 61 74 20 56 31 2E 30 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule hmimys_Packer_10_hmimys: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID hmimys_Packer_10_hmimys"
        weight = 1
    strings:
        $a = { 5E 83 C6 64 AD 50 AD 50 83 EE 6C AD 50 AD 50 AD 50 AD 50 AD 50 E8 E7 07 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ThemidaWinLicense_V18X_V19X_Oreans_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ThemidaWinLicense_V18X_V19X_Oreans_Technologies"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D ?? ?? ?? ?? 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 ?? 39 1A 74 07 2D ?? ?? ?? ?? EB DA 8B F8 B8 ?? ?? ?? ?? 03 C7 B9 ?? ?? ?? ?? 03 CF EB 0A B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 50 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 58 2D ?? ?? ?? ?? B9 ?? ?? ?? ?? C6 00 E9 83 E9 05 89 48 01 61 E9 }
        $b = { B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D ?? ?? ?? ?? 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PE_Armor_0760_0765_hying: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Armor_0760_0765_hying"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 00 08 00 00 00 00 00 00 00 60 E8 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule aPack_v098b_com: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID aPack_v098b_com"
        weight = 1
    strings:
        $a = { BE ?? ?? BF ?? ?? 8B CF FC 57 F3 A4 C3 BF ?? ?? 57 57 BE ?? ?? B2 ?? BD ?? ?? 50 A4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPAck_1061b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPAck_1061b"
        weight = 1
    strings:
        $a = { 90 90 75 00 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Embedded_2545_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_2545_Jitit"
        weight = 1
    strings:
        $a = { E8 F2 FF FF FF 50 68 ?? ?? ?? ?? 68 40 1B 00 00 E8 42 FF FF FF E9 9D FF FF FF 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Embedded_2620_2623_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_2620_2623_Jitit"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 58 BB AC 1E 00 00 2B C3 50 68 ?? ?? ?? ?? 68 B0 21 00 00 68 C4 00 00 00 E8 C3 FE FF FF E9 99 FF FF FF 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Naked_Packer_V1X_BigBoote: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Naked_Packer_V1X_BigBoote"
        weight = 1
    strings:
        $a = { 6A ?? E8 9A 05 00 00 8B D8 53 68 ?? ?? ?? ?? E8 6C FD FF FF B9 05 00 00 00 8B F3 BF ?? ?? ?? ?? 53 F3 A5 E8 8D 05 00 00 8B 3D ?? ?? ?? ?? A1 ?? ?? ?? ?? 66 8B 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? 2B CF 89 45 E8 89 0D ?? ?? ?? ?? 66 89 55 EC 8B 41 3C 33 D2 03 C1 83 C4 10 66 8B 48 06 66 8B 50 14 81 E1 FF FF 00 00 8D 5C 02 18 8D 41 FF E8 00 00 00 00 EB 01 ?? 89 45 F0 C6 45 FF 00 8D 7D E8 8B F3 8A 0E 8A 17 8A C1 3A CA 75 1E 84 C0 74 16 8A 56 01 8A 4F 01 8A C2 3A D1 75 0E 83 C6 02 83 C7 02 84 C0 75 DC 33 C0 EB 05 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_118_Dll_LZMA_430_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_118_Dll_LZMA_430_ap0x"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 9F 01 00 00 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A 00 00 FF 34 37 FF 74 37 04 FF D3 61 83 C7 08 83 3C 37 00 75 E6 83 BD 0D 0B 00 00 00 74 0E 83 BD 11 0B 00 00 00 74 05 E8 F6 01 00 00 8D 74 37 04 53 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 AA 0A 00 00 89 85 1D 0B 00 00 5B 60 FF B5 F9 0A 00 00 56 FF B5 1D 0B 00 00 FF D3 61 8B B5 1D 0B 00 00 8B C6 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_108: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_108"
        weight = 1
    strings:
        $a = { 90 90 90 75 01 90 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SVKP_v143_Pavol_Cerven_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SVKP_v143_Pavol_Cerven_h"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 49 DC CE 05 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 2D 67 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 2D 67 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 39 67 00 00 5D 6A FF FF 95 31 67 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Delphi_v20_Unit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Delphi_v20_Unit"
        weight = 1
    strings:
        $a = { 44 43 55 32 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_FSG_131: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_FSG_131"
        weight = 1
    strings:
        $a = { BE 90 90 90 00 BF 90 90 90 00 BB 90 90 90 00 53 BB 90 90 90 00 B2 80 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Windows_Shortcut_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Windows_Shortcut_file"
        weight = 1
    strings:
        $a = { 4C 00 00 00 01 14 02 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SCRAM_vC5: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SCRAM_vC5"
        weight = 1
    strings:
        $a = { B8 ?? ?? 50 9D 9C 58 25 ?? ?? 75 ?? BA ?? ?? B4 09 CD 21 CD 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule InterLok_V551_PACE_Anti_Piracy_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID InterLok_V551_PACE_Anti_Piracy_SignByfly"
        weight = 1
    strings:
        $a = { EB 03 ?? ?? ?? 55 EB 03 ?? ?? ?? EB 04 ?? EB 06 ?? 8B EC EB F9 ?? EB 02 ?? ?? 81 EC A8 00 00 00 EB 02 ?? ?? EB 01 ?? 53 EB 03 ?? ?? ?? EB 05 ?? ?? EB 15 ?? EB 03 ?? ?? ?? 56 EB 04 ?? EB F2 ?? EB 01 ?? EB F8 ?? ?? ?? EB 0F ?? 33 F6 EB 10 ?? ?? ?? EB F7 ?? ?? EB FA ?? EB 01 ?? EB F8 ?? EB 01 ?? 57 EB 03 ?? ?? ?? EB 11 ?? ?? ?? EB 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 08 ?? EB F0 ?? EB 07 ?? ?? EB FA ?? ?? ?? EB 02 ?? ?? BB ?? ?? ?? ?? EB 03 ?? ?? ?? 0F 85 ?? ?? ?? ?? EB 07 }
        $b = { EB 03 ?? ?? ?? 55 EB 03 ?? ?? ?? EB 04 ?? EB 06 ?? 8B EC EB F9 ?? EB 02 ?? ?? 81 EC A8 00 00 00 EB 02 ?? ?? EB 01 ?? 53 EB 03 ?? ?? ?? EB 05 ?? ?? EB 15 ?? EB 03 ?? ?? ?? 56 EB 04 ?? EB F2 ?? EB 01 ?? EB F8 ?? ?? ?? EB 0F ?? 33 F6 EB 10 ?? ?? ?? EB F7 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_01_Borland_Delphi_60_70: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Borland_Delphi_60_70"
        weight = 1
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 53 8B D8 33 C0 A3 09 09 09 00 6A 00 E8 09 09 00 FF A3 09 09 09 00 A1 09 09 09 00 A3 09 09 09 00 33 C0 A3 09 09 09 00 33 C0 A3 09 09 09 00 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _MSLRH_v031a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _MSLRH_v031a"
        weight = 1
    strings:
        $a = { 60 D1 CB 0F CA C1 CA E0 D1 CA 0F C8 EB 01 F1 0F C0 C9 D2 D1 0F C1 C0 D3 DA C0 D6 A8 EB 01 DE D0 EC 0F C1 CB D0 CF 0F C1 D1 D2 DB 0F C8 EB 01 BC C0 E9 C6 C1 D0 91 0F CB EB 01 73 0F CA 87 D9 87 D2 D0 CF 87 D9 0F C8 EB 01 C1 EB 01 A2 86 CA D0 E1 0F C0 CB 0F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_Yodas_Protector_102: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Yodas_Protector_102"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule mPack_V003_DeltaAziz: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID mPack_V003_DeltaAziz"
        weight = 1
    strings:
        $a = { 55 8B EC 83 ?? ?? 33 C0 89 45 F0 B8 ?? ?? ?? ?? E8 67 C4 FF FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 33 C0 E8 93 C8 FF FF 8B 45 F0 E8 87 CB FF FF A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? E8 FA C9 FF FF 83 F8 FF 75 0A E8 88 B2 FF FF E9 1B 01 00 00 C7 05 ?? ?? ?? ?? 32 00 00 00 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 C9 C9 FF FF BA ?? ?? ?? ?? A1 ?? ?? ?? ?? B9 04 00 00 00 E8 C5 C9 FF FF 83 3D ?? ?? ?? ?? 32 77 0A E8 47 B2 FF FF E9 DA 00 00 00 A1 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 92 C9 FF FF BA 18 A5 00 10 A1 ?? ?? ?? ?? B9 04 00 00 00 E8 8E C9 FF FF 83 F8 04 74 0A E8 14 B2 FF FF E9 A7 00 00 00 E8 0A CB FF FF A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 63 C9 FF FF 83 F8 FF 75 0A E8 F1 B1 FF FF E9 84 00 00 00 6A 00 6A 00 B8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 D4 CD FF FF 84 C0 75 07 E8 CF B1 FF FF EB 65 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 0F FA FF FF 3B 05 ?? ?? ?? ?? 75 0D A1 ?? ?? ?? ?? 8B 40 3C E8 6E FB FF FF 6A 03 E8 07 C4 FF FF A1 ?? ?? ?? ?? E8 C1 C6 FF FF 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 AA C6 FF FF A1 ?? ?? ?? ?? E8 A0 C6 FF FF C3 E9 AE B0 FF FF EB E4 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 A7 B5 FF FF C3 E9 91 B0 FF FF EB F0 E8 62 B4 FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VMProtect_0x_PolyTech: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VMProtect_0x_PolyTech"
        weight = 1
    strings:
        $a = { 5B 20 56 4D 50 72 6F 74 65 63 74 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ID_Application_Protector_12_ID_Security_Suite: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ID_Application_Protector_12_ID_Security_Suite"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED F2 0B 47 00 B9 19 22 47 00 81 E9 EA 0E 47 00 89 EA 81 C2 EA 0E 47 00 8D 3A 89 FE 31 C0 E9 D3 02 00 00 CC CC CC CC E9 CA 02 00 00 43 3A 5C 57 69 6E 64 6F 77 73 5C 53 6F 66 74 57 61 72 65 50 72 6F 74 65 63 74 6F 72 5C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_11_Cyberbob_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_11_Cyberbob_h"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 C8 DC 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v110b3: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v110b3"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 95 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 BB 95 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v110b2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v110b2"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 94 60 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v110b4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v110b4"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 40 ?? 87 DD 8B 85 95 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 BB 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NME_11_Public_by_redlime: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NME_11_Public_by_redlime"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 56 B8 30 35 14 13 E8 9A E6 FF FF 33 C0 55 68 6C 36 14 13 64 FF 30 64 89 20 B8 08 5C 14 13 BA 84 36 14 13 E8 7D E2 FF FF E8 C0 EA FF FF 8B 15 CC 45 14 13 A1 C8 45 14 13 E8 04 F8 FF FF 8B 15 D0 45 14 13 A1 C8 45 14 13 E8 F4 F7 FF FF 8B 15 CC 45 14 13 A1 C8 45 14 13 E8 2C F9 FF FF A3 F8 5A 14 13 8B 15 D0 45 14 13 A1 C8 45 14 13 E8 17 F9 FF FF A3 FC 5A 14 13 B8 04 5C 14 13 E8 20 FB FF FF 8B D8 85 DB 74 48 B8 00 5B 14 13 8B 15 C4 45 14 13 E8 1E E7 FF FF A1 04 5C 14 13 E8 A8 DA FF FF ?? ?? ?? ?? 5C 14 13 50 8B CE 8B D3 B8 00 5B 14 13 ?? ?? ?? ?? FF 8B C6 E8 DF FB FF FF 8B C6 E8 9C DA FF FF B8 00 5B 14 13 E8 72 E7 FF FF 33 C0 5A 59 59 64 89 10 68 73 36 14 13 C3 E9 0F DF FF FF EB F8 5E 5B E8 7E E0 FF FF 00 00 FF FF FF FF 0C 00 00 00 4E 4D 45 20 31 2E 31 20 53 74 75 62 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v110b6: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v110b6"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 60 ?? 00 87 DD 8B 85 9A 60 40 ?? 01 85 03 60 40 ?? 66 C7 85 ?? 60 40 ?? 90 90 01 85 92 60 40 ?? BB B7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_LTC_13: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_LTC_13"
        weight = 1
    strings:
        $a = { 54 E8 00 00 00 00 5D 8B C5 81 ED F6 73 40 00 2B 85 87 75 40 00 83 E8 06 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_LCC_Win32_1x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_LCC_Win32_1x"
        weight = 1
    strings:
        $a = { 64 A1 01 00 00 00 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 90 50 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BJFnt_v13: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BJFnt_v13"
        weight = 1
    strings:
        $a = { EB ?? 3A ?? ?? 1E EB ?? CD 20 9C EB ?? CD 20 EB ?? CD 20 60 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule E2C_by_DoP: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID E2C_by_DoP"
        weight = 1
    strings:
        $a = { BE ?? ?? BF ?? ?? B9 ?? ?? FC 57 F3 A5 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Securom7_Sony_DADC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Securom7_Sony_DADC"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 8B ?? ?? ?? ?? 0A ?? ?? ?? ?? ?? ?? E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_70_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Microsoft_Visual_Cpp_70_DLL"
        weight = 1
    strings:
        $a = { 55 8D 6C 01 00 81 EC 00 00 00 00 8B 45 90 83 F8 01 56 0F 84 00 00 00 00 85 C0 0F 84 ?? ?? ?? ?? E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule mPack_003_DeltaAziz: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID mPack_003_DeltaAziz"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 33 C0 89 45 F0 B8 A8 76 00 10 E8 67 C4 FF FF 33 C0 55 68 C2 78 00 10 64 FF 30 64 89 20 8D 55 F0 33 C0 E8 93 C8 FF FF 8B 45 F0 E8 87 CB FF FF A3 08 A5 00 10 33 C0 55 68 A5 78 00 10 64 FF 30 64 89 20 A1 08 A5 00 10 E8 FA C9 FF FF 83 F8 FF 75 0A E8 88 B2 FF FF E9 1B 01 00 00 C7 05 14 A5 00 10 32 00 00 00 A1 08 A5 00 10 8B 15 14 A5 00 10 E8 C9 C9 FF FF BA 14 A5 00 10 A1 08 A5 00 10 B9 04 00 00 00 E8 C5 C9 FF FF 83 3D 14 A5 00 10 32 77 0A E8 47 B2 FF FF E9 DA 00 00 00 A1 08 A5 00 10 8B 15 14 A5 00 10 E8 92 C9 FF FF BA 18 A5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v080_v084: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v080_v084"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 ?? ?? ?? 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 77 EF 75 09 8B 1E 83 EE FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SPLayer_v008: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SPLayer_v008"
        weight = 1
    strings:
        $a = { 8D 40 00 B9 ?? ?? ?? ?? 6A ?? 58 C0 0C ?? ?? 48 ?? ?? 66 13 F0 91 3B D9 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WARNING_TROJAN_XiaoHui: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WARNING_TROJAN_XiaoHui"
        weight = 1
    strings:
        $a = { 60 9C E8 00 00 00 00 5D B8 ?? 85 40 00 2D ?? 85 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Zylom_encrypted_game_Zylom_games_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Zylom_encrypted_game_Zylom_games_h"
        weight = 1
    strings:
        $a = { 2E 74 65 78 74 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2E 72 64 61 74 61 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2E 64 61 74 61 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2E 72 73 72 63 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2E 7A 79 6C 6D 73 00 00 00 10 00 00 ?? ?? ?? ?? 00 10 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 60 2E 7A 79 6C 6D 69 00 00 00 10 00 00 ?? ?? ?? ?? 00 10 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Lattice_C_v101: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Lattice_C_v101"
        weight = 1
    strings:
        $a = { FA B8 ?? ?? 05 ?? ?? B1 ?? D3 E8 8C CB 03 C3 8E D8 8E D0 26 ?? ?? ?? ?? 2B D8 F7 ?? ?? ?? 75 ?? B1 ?? D3 E3 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V035_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V035_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { 58 8D 54 83 58 FF 16 72 5C 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 6F FF ?? ?? ?? ?? ?? ?? 8D 6C 6D 00 8D AC AB 08 10 00 00 B0 01 E3 2A 8B D7 2B 53 08 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 54 95 00 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E3 B4 00 33 C9 B5 01 FF 56 AC 33 C9 E9 03 01 00 00 B1 30 8B 6B 08 03 D1 FF 16 73 51 03 D1 FF 16 72 1B 03 D1 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 43 08 8A 00 E9 D5 00 00 00 83 C2 60 FF 16 87 6B 0C 73 0C 03 D1 FF 16 87 6B 10 73 03 87 6B 14 3C 07 B0 08 72 02 B0 0B 50 55 8D 93 78 07 00 00 FF 56 B0 5D 91 E9 99 00 00 00 3C 07 B0 07 72 02 B0 0A 50 87 6B 0C 87 6B 10 89 6B 14 8D 93 C0 0B 00 00 FF 56 B0 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D AC 83 78 03 00 00 FF 56 A8 3C 04 8B E8 72 5C 33 ED D1 E8 13 ED 48 45 91 45 D3 E5 80 F9 05 8D 94 AB 78 01 00 00 76 2B 80 E9 04 33 C0 8B 53 FC D1 2B 8B 12 0F CA 2B 53 04 03 C0 3B 13 72 06 8B 13 40 01 53 04 FF 56 88 E2 E3 B1 04 D3 E0 03 E8 8D 53 18 33 C0 55 40 51 D3 E0 8B EA 91 FF 56 A8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Patch_Creation_Wizard_12_Memory_Patch: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Patch_Creation_Wizard_12_Memory_Patch"
        weight = 1
    strings:
        $a = { E8 7F 03 00 00 6A 00 E8 24 03 00 00 A3 B8 33 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 2C 03 00 00 6A 00 E8 EF 02 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 B8 33 40 00 E8 1B 03 00 00 50 6A 01 68 80 00 00 00 FF 75 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_VCL_encrypted: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_VCL_encrypted"
        weight = 1
    strings:
        $a = { 01 B9 ?? ?? 81 34 ?? ?? 46 46 E2 F8 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Themida_10xx_18xx_no_compression_Oreans_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Themida_10xx_18xx_no_compression_Oreans_Technologies"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 D8 60 }
        $b = { 55 8B EC 83 C4 D8 60 E8 00 00 00 00 5A 81 EA ?? ?? ?? ?? 8B DA C7 45 D8 00 00 00 00 8B 45 D8 40 89 45 D8 81 7D D8 80 00 00 00 74 0F 8B 45 08 89 83 ?? ?? ?? ?? FF 45 08 43 EB E1 89 45 DC 61 8B 45 DC C9 C2 04 00 55 8B EC 81 C4 7C FF FF FF 60 E8 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule FreeJoiner_Small_build_031032_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeJoiner_Small_build_031032_GlOFF"
        weight = 1
    strings:
        $a = { 50 32 ?? 66 8B C3 58 E8 }
        $b = { 50 32 ?? 66 8B C3 58 E8 ?? FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Software_Compress_V12_BG_Software_Protect_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Software_Compress_V12_BG_Software_Protect_Technologies"
        weight = 1
    strings:
        $a = { E9 BE 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SuperDAT: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SuperDAT"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 40 F3 42 00 68 A4 BF 42 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 08 F2 42 00 33 D2 8A D4 89 15 60 42 43 00 8B C8 81 E1 FF 00 00 00 89 0D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unnamed_Scrambler_25A_p0ke: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unnamed_Scrambler_25A_p0ke"
        weight = 1
    strings:
        $a = { 55 8B EC B9 0B 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 B8 6C 3E 40 00 E8 F7 EA FF FF 33 C0 55 68 60 44 40 00 64 FF 30 64 89 20 BA 70 44 40 00 B8 B8 6C 40 00 E8 62 F3 FF FF 8B D8 85 DB 75 07 6A 00 E8 A1 EB FF FF BA E8 64 40 00 8B C3 8B 0D B8 6C 40 00 E8 37 D3 FF FF C7 05 BC 6C 40 00 0A 00 00 00 BB 68 6C 40 00 BE 90 6C 40 00 BF E8 64 40 00 B8 C0 6C 40 00 BA 04 00 00 00 E8 07 EC FF FF 83 3B 00 74 04 33 C0 89 03 8B D7 8B C6 E8 09 F3 FF FF 89 03 83 3B 00 0F 84 BB 04 00 00 B8 C0 6C 40 00 8B 16 E8 06 E2 FF FF B8 C0 6C 40 00 E8 24 E1 FF FF 8B D0 8B 03 8B 0E E8 D1 D2 FF FF 8B C7 A3 20 6E 40 00 8D 55 EC 33 C0 E8 0C D4 FF FF 8B 45 EC B9 1C 6E 40 00 BA 18 6E 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ReversingLabsProtector_074_beta_Ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ReversingLabsProtector_074_beta_Ap0x"
        weight = 1
    strings:
        $a = { 68 00 00 41 00 E8 01 00 00 00 C3 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Petite_14_c1998_99_Ian_Luck_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Petite_14_c1998_99_Ian_Luck_h"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? 66 9C 60 50 8B D8 03 00 68 54 BC 00 00 6A 00 FF 50 14 8B CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SkD_Undetectabler_Pro_20_No_UPX_Method_SkD: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SkD_Undetectabler_Pro_20_No_UPX_Method_SkD"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 FC 26 00 10 E8 EC F3 FF FF 6A 0F E8 15 F5 FF FF E8 64 FD FF FF E8 BB ED FF FF 8D 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VProtector_11X_vcasm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VProtector_11X_vcasm"
        weight = 1
    strings:
        $a = { EB 0B 5B 56 50 72 6F 74 65 63 74 5D 00 E8 24 00 00 00 8B 44 24 04 8B 00 3D 04 00 00 80 75 08 8B 64 24 08 EB 04 58 EB 0C E9 64 8F 05 00 00 00 00 74 F3 75 F1 EB 24 64 FF 35 00 00 00 00 EB 12 FF 9C 74 03 75 01 E9 81 0C 24 00 01 00 00 9D 90 EB F4 64 89 25 00 00 00 00 EB E6 E8 16 00 00 00 8B 5C 24 0C 8B A3 C4 00 00 00 64 8F 05 00 00 00 00 83 C4 04 EB 14 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C9 99 F7 F1 E9 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 16 00 00 00 8B 5C 24 0C 8B A3 C4 00 00 00 64 8F 05 00 00 00 00 83 C4 04 EB 14 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C9 99 F7 F1 E9 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_32Lite_003: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_32Lite_003"
        weight = 1
    strings:
        $a = { 60 06 FC 1E 07 BE 90 90 90 90 6A 04 68 90 10 90 90 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V1304_cyberbobnbsp_nbsp_SignByfly_20080310: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V1304_cyberbobnbsp_nbsp_SignByfly_20080310"
        weight = 1
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 ?? EB 01 ?? EB 0D ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 EB 04 ?? EB 04 ?? EB FB ?? ?? ?? ?? ?? ?? ?? 8B 42 3C 03 C2 ?? ?? ?? ?? ?? ?? EB 02 ?? ?? F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 ?? ?? ?? ?? EB 06 ?? ?? ?? ?? ?? ?? F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SafeGuard_V10X_simonzh2000: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SafeGuard_V10X_simonzh2000"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 EB 29 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 59 9C 81 C1 E2 FF FF FF EB 01 ?? 9D FF E1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEX_v099: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEX_v099"
        weight = 1
    strings:
        $a = { E9 F5 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESPin_v13_Cyberbob_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESPin_v13_Cyberbob_h"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 CD 4E 40 00 8B 42 3C 03 C2 89 85 D7 4E 40 00 EB 02 12 77 F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 9A 72 ED 1F EB 07 F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D EB 4E 40 00 53 8F 85 E1 4C 40 00 EB 07 FA EB 01 FF EB 04 E3 EB F8 69 8B 59 38 03 DA 8B 3B 89 BD 90 4F 40 00 8D 5B 04 8B 1B 89 9D 95 4F 40 00 E8 00 00 00 00 58 01 68 05 68 D3 65 0F E2 B8 77 CE 2F B1 35 73 CE 2F B1 03 E0 F7 D8 81 2C 04 13 37 CF E1 FF 64 24 FC FF 25 10 BB ?? 00 00 00 B9 84 12 00 00 8D BD C6 4F 40 00 4F EB 07 FA EB 01 FF EB 04 E3 EB F8 69 30 1C 39 FE CB 49 9C EB 04 01 EB 04 CD EB FB 2B C1 2C 24 06 F7 14 24 83 24 24 01 50 52 B8 79 B2 DC 12 05 44 4D 23 ED F7 64 24 08 8D 84 28 20 2F 40 00 89 44 24 08 5A 58 8D 64 24 04 FF 64 24 FC FF EA EB EB 01 C8 E8 01 00 00 00 68 58 FE 48 1F 0F 84 94 02 00 00 75 01 9A 81 70 03 E8 98 68 EA 83 C0 21 80 40 FB EB A2 40 02 00 E0 91 32 68 CB 00 00 00 59 8D BD 7E 61 40 00 E8 03 00 00 00 EB 04 FA EB FB 68 83 04 24 0C C3 8D C0 0C 39 02 49 9C E8 03 00 00 00 EB 04 8D EB FB FF 83 04 24 0C C3 A3 C1 2C 24 06 F7 14 24 83 24 24 01 50 52 B8 61 B2 DC 12 05 44 4D 23 ED F7 64 24 08 8D 84 28 B2 2F 40 00 89 44 24 08 5A 58 8D 64 24 04 FF 64 24 FC 9A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_FaxFreeTopo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_FaxFreeTopo"
        weight = 1
    strings:
        $a = { FA 06 33 C0 8E C0 B8 ?? ?? 26 ?? ?? ?? ?? 50 8C C8 26 ?? ?? ?? ?? 50 CC 58 9D 58 26 ?? ?? ?? ?? 58 26 ?? ?? ?? ?? 07 FB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule iPB_Protect_013_017_forgot: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID iPB_Protect_013_017_forgot"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 4B 43 55 46 68 54 49 48 53 64 A1 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreePascal_104_Win32_DLL_Berczi_Gabor_Pierre_Muller_Peter_Vreman: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreePascal_104_Win32_DLL_Berczi_Gabor_Pierre_Muller_Peter_Vreman"
        weight = 1
    strings:
        $a = { C6 05 ?? ?? ?? ?? 00 55 89 E5 53 56 57 8B 7D 08 89 3D ?? ?? ?? ?? 8B 7D 0C 89 3D ?? ?? ?? ?? 8B 7D 10 89 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 0C 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Protection_Plus_vxx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Protection_Plus_vxx"
        weight = 1
    strings:
        $a = { 50 60 29 C0 64 FF 30 E8 ?? ?? ?? ?? 5D 83 ED 3C 89 E8 89 A5 14 ?? ?? ?? 2B 85 1C ?? ?? ?? 89 85 1C ?? ?? ?? 8D 85 27 03 ?? ?? 50 8B ?? 85 C0 0F 85 C0 ?? ?? ?? 8D BD 5B 03 ?? ?? 8D B5 43 03 ?? ?? E8 DD ?? ?? ?? 89 85 1F 03 ?? ?? 6A 40 68 ?? 10 ?? ?? 8B 85 28 ?? ?? ?? 50 6A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Zortech_C: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Zortech_C"
        weight = 1
    strings:
        $a = { E8 ?? ?? 2E FF ?? ?? ?? FC 06 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Studio_NET: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Studio_NET"
        weight = 1
    strings:
        $a = { FF 25 00 20 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_29_North_Star: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_29_North_Star"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 8A 06 3C 00 74 12 8B F5 8D B5 ?? ?? FF FF 8A 06 3C 01 0F 84 42 02 00 00 C6 06 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 68 03 00 00 03 D9 50 53 E8 B1 02 00 00 61 8B 36 8B FD 03 BD ?? ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 36 }
        $b = { 9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 8A 06 3C 00 74 12 8B F5 8D B5 ?? ?? FF FF 8A 06 3C 01 0F 84 42 02 00 00 C6 06 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule EXECryptor_226_minimum_protection: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_226_minimum_protection"
        weight = 1
    strings:
        $a = { 50 68 ?? ?? ?? ?? 58 81 E0 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 0C 24 59 E8 ?? ?? ?? 00 89 45 F8 E9 ?? ?? ?? ?? 0F 83 ?? ?? ?? 00 E9 ?? ?? ?? ?? 87 14 24 5A 57 68 ?? ?? ?? ?? E9 ?? ?? ?? ?? 58 81 C0 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? 81 C8 ?? ?? ?? ?? 81 E0 ?? ?? ?? ?? E9 ?? ?? ?? 00 C3 E9 ?? ?? ?? ?? C3 BF ?? ?? ?? ?? 81 CB ?? ?? ?? ?? BA ?? ?? ?? ?? 52 E9 ?? ?? ?? 00 E8 ?? ?? ?? 00 E9 ?? ?? ?? 00 E9 ?? ?? ?? ?? 87 34 24 5E 66 8B 00 66 25 ?? ?? E9 ?? ?? ?? ?? 8B CD 87 0C 24 8B EC 51 89 EC 5D 8B 05 ?? ?? ?? ?? 09 C0 E9 ?? ?? ?? ?? 59 81 C1 ?? ?? ?? ?? C1 C1 ?? 23 0D ?? ?? ?? ?? 81 F9 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 E9 ?? ?? ?? 00 13 D0 0B F9 E9 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 8B 64 24 08 31 C0 64 8F 05 00 00 00 00 5A E9 ?? ?? ?? ?? 3C A4 0F 85 ?? ?? ?? 00 8B 45 FC 66 81 38 ?? ?? 0F 84 05 00 00 00 E9 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? E9 ?? ?? ?? ?? 87 3C 24 5F 31 DB 31 C9 31 D2 68 ?? ?? ?? ?? E9 ?? ?? ?? ?? 89 45 FC 33 C0 89 45 F4 83 7D FC 00 E9 ?? ?? ?? ?? 53 52 8B D1 87 14 24 81 C0 ?? ?? ?? ?? 0F 88 ?? ?? ?? ?? 3B CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_XCR_011: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_XCR_011"
        weight = 1
    strings:
        $a = { 60 8B F0 33 DB 83 C3 01 83 C0 01 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TheHypers_protector_TheHyper: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TheHypers_protector_TheHyper"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC 14 8B FC E8 14 00 00 00 ?? ?? 01 01 ?? ?? 01 01 ?? ?? ?? 00 ?? ?? 01 01 ?? ?? 02 01 5E E8 0D 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8B 46 04 FF 10 8B D8 E8 0D 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 07 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_70: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_70"
        weight = 1
    strings:
        $a = { F7 D8 40 49 EB 02 E0 0A 8D 35 80 ?? ?? ?? 0F B6 C2 EB 01 9C 8D 1D F4 00 00 00 EB 01 3C 80 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPolyx_04_by_delikon: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPolyx_04_by_delikon"
        weight = 1
    strings:
        $a = { C3 ?? ?? ?? ?? ?? 83 EC 04 89 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPacK_V34_V35_LiuXingPing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPacK_V34_V35_LiuXingPing"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? ?? ?? 80 38 01 0F 84 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressor_v14_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_v14_CGSoftLabs"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC ?? 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 34 2E 2E B8 }
        $b = { 66 9C 60 50 8B D8 03 00 68 54 BC 00 00 6A 00 FF 50 14 8B CC }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule SLVc0deProtector_v061_SLV: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SLVc0deProtector_v061_SLV"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 02 FA 04 E8 49 00 00 00 69 E8 49 00 00 00 95 E8 4F 00 00 00 68 E8 1F 00 00 00 49 E8 E9 FF FF FF 67 E8 1F 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Hasp_dongle_Alladin: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Hasp_dongle_Alladin"
        weight = 1
    strings:
        $a = { 50 53 51 52 57 56 8B 75 1C 8B 3E ?? ?? ?? ?? ?? 8B 5D 08 8A FB ?? ?? 03 5D 10 8B 45 0C 8B 4D 14 8B 55 18 80 FF 32 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_Ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_Ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 2C 0A 00 00 8D 9D 22 02 00 00 33 FF E8 83 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 CD 09 00 00 89 85 14 0A 00 00 EB 14 60 FF B5 14 0A }
        $b = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 EB 03 0C 00 00 EB 03 0C 00 00 8D B5 CB 22 00 00 8D 9D F0 02 00 00 33 FF E8 47 02 00 00 EB 03 15 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 9B 0A }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Prepared_by_SLR_OPTLINK: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Prepared_by_SLR_OPTLINK"
        weight = 1
    strings:
        $a = { 87 C0 55 56 57 52 51 53 50 9C FC 8C DA 83 ?? ?? 16 07 0E 1F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Armor_046_China_Cracking_Group: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Armor_046_China_Cracking_Group"
        weight = 1
    strings:
        $a = { E8 AA 00 00 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 3D ?? ?? 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 5C ?? ?? 00 6F ?? ?? 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 A2 01 00 00 ?? ?? 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 5D 81 ED 05 00 00 00 8D 75 3D 56 FF 55 31 8D B5 86 00 00 00 56 50 FF 55 2D 89 85 93 00 00 00 6A 04 68 00 10 00 00 FF B5 82 00 00 00 6A 00 FF 95 93 00 00 00 50 8B 9D 7E 00 00 00 03 DD 50 53 E8 04 00 00 00 5A 55 FF E2 60 8B 74 24 24 8B 7C 24 28 FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_70_ASM: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_70_ASM"
        weight = 1
    strings:
        $a = { E8 01 00 00 00 5A 5E E8 02 00 00 00 BA DD 5E 03 F2 EB 01 64 BB 80 ?? ?? 00 8B FA EB 01 A8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_v20_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_v20_Vaska"
        weight = 1
    strings:
        $a = { F7 D1 83 F1 FF 6A 00 F7 D1 83 F1 FF 81 04 24 ?? 02 00 00 F7 D1 83 F1 FF 59 BA 32 21 ?? 00 F7 D1 83 F1 FF F7 D1 83 F1 FF 80 02 E3 F7 D1 83 F1 FF C0 0A 05 F7 D1 83 F1 FF 80 02 6F F7 D1 83 F1 FF 80 32 A4 F7 D1 83 F1 FF 80 02 2D F7 D1 83 F1 FF 42 49 85 C9 75 CD 1C 4F 8D 5B FD 62 1E 1C 4F 8D 5B FD 4D 9D B9 ?? ?? ?? 1E 1C 4F 8D 5B FD 22 1C 4F 8D 5B FD 8E A2 B9 B9 E2 83 DB E2 E5 4D CD 1E BF 60 AB 1F 4D DB 1E 1E 3D 1E 92 1B 8E DC 7D EC A4 E2 4D E5 20 C6 CC B2 8E EC 2D 7D DC 1C 4F 8D 5B FD 83 56 8E E0 3A 7D D0 8E 9D 6E 7D D6 4D 25 06 C2 AB 20 CC 3A 4D 2D 9D 6B 0B 81 45 CC 18 4D 2D 1F A1 A1 6B C2 CC F7 E2 4D 2D 9E 8B 8B CC DE 2E 2D F7 1E AB 7D 45 92 30 8E E6 B9 7D D6 8E 9D 27 DA FD FD 1E 1E 8E DF B8 7D CF 8E A3 4D 7D DC 1C 4F 8D 5B FD 33 D7 1E 1E 1E A6 0B 41 A1 A6 42 61 6B 41 6B 4C 45 1E 21 F6 26 BC E2 62 1E 62 1E 62 1E 23 63 59 ?? 1E 62 1E 62 1E 33 D7 1E 1E 1E 85 6B C2 41 AB C2 9F 23 6B C2 41 A1 1E C0 FD F0 FD 30 20 33 9E 1E 1E 1E 85 A2 0B 8B C2 27 41 EB A1 A2 C2 1E C0 FD F0 FD 30 62 1E 33 7E 1E 1E 1E C6 2D 42 AB 9F 23 6B C2 41 A1 1E C0 FD F0 FD 30 C0 FD F0 8E 1D 1C 4F 8D 5B FD E0 00 33 5E 1E 1E 1E BF 0B EC C2 E6 42 A2 C2 45 1E C0 FD F0 FD 30 CE 36 CC F2 1C 4F 8D 5B FD }
        $b = { F7 D1 83 F1 FF 6A 00 F7 D1 83 F1 FF 81 04 24 ?? 02 00 00 F7 D1 83 F1 FF 59 BA 32 21 ?? 00 F7 D1 83 F1 FF F7 D1 83 F1 FF 80 02 E3 F7 D1 83 F1 FF C0 0A 05 F7 D1 83 F1 FF 80 02 6F F7 D1 83 F1 FF 80 32 A4 F7 D1 83 F1 FF 80 02 2D F7 D1 83 F1 FF 42 49 85 C9 75 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Borland_Delphi_Setup_Module: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_Setup_Module"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 ?? 53 56 57 33 C0 89 45 F0 89 45 D4 89 45 D0 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MPRESS_V097_V099_MATCODE_Softwarenbsp_nbsp_SignByfly_20080416: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MPRESS_V097_V099_MATCODE_Softwarenbsp_nbsp_SignByfly_20080416"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 58 05 49 01 00 00 8B 30 03 F0 2B C0 8B FE 66 AD C1 E0 0C 8B C8 50 AD 2B C8 03 F1 8B C8 57 49 8A 44 39 06 74 05 88 04 31 EB F4 88 04 31 2B C0 3B FE 73 28 AC 0A C0 74 23 8A C8 24 3F C1 E0 10 66 AD 80 E1 40 74 0F 8B D6 8B CF 03 F0 E8 60 00 00 00 03 F8 EB D8 8B C8 F3 A4 EB D2 5E 5A 83 EA 05 2B C9 3B CA 73 26 8B D9 AC 41 24 FE 3C E8 75 F2 43 83 C1 04 AD 0B C0 78 06 3B C2 73 E5 EB 06 03 C3 78 DF 03 C2 2B C3 89 46 FC EB D6 E8 00 00 00 00 5F 81 C7 69 FF FF FF B0 E9 AA B8 45 01 00 00 AB E8 00 00 00 00 58 05 A3 00 00 00 E9 93 00 00 00 53 56 57 8B F9 8B F2 8B DA 03 D8 51 55 33 C0 8B EB 8B DE 2B D2 2B C9 EB 4F 3B DD 73 6C 2B C9 66 8B 03 8D 5B 02 8A CC 80 E4 0F 0B C0 75 02 B4 10 C0 E9 04 80 C1 03 80 F9 12 72 19 8A 0B 66 83 C1 12 43 66 81 F9 11 01 72 0B 66 8B 0B 81 C1 11 01 00 00 43 43 8B F7 2B F0 F3 A4 12 D2 74 0A 72 B9 8A 03 43 88 07 47 EB F2 3B DD 73 1D 0A 13 F9 74 03 43 EB E6 8B 43 01 89 07 8B 43 05 89 47 04 8D 5B 09 8D 7F 08 33 C0 EB DF 5D 8B C7 59 2B C1 5F 5E 5B C3 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HSI_JPEG_graphics_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HSI_JPEG_graphics_file"
        weight = 1
    strings:
        $a = { 68 73 69 31 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V037_V039_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V037_V039_Dwing"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? 83 C6 01 FF E6 00 00 00 ?? ?? ?? 00 03 00 00 00 ?? ?? ?? ?? 00 10 00 00 00 00 ?? ?? ?? ?? 00 00 ?? F6 ?? 00 B2 4F 45 00 ?? F9 ?? 00 EF 4F 45 00 ?? F6 ?? 00 8C D1 42 00 ?? 56 ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 24 ?? 00 ?? ?? ?? 00 34 50 45 00 ?? ?? ?? 00 FF FF 00 00 ?? 24 ?? 00 ?? 24 ?? 00 ?? ?? ?? 00 40 00 00 C0 00 00 ?? ?? ?? ?? 00 00 ?? 00 00 00 ?? 1E ?? 00 ?? F7 ?? 00 A6 4E 43 00 ?? 56 ?? 00 AD D1 42 00 ?? F7 ?? 00 A1 D2 42 00 ?? 56 ?? 00 0B 4D 43 00 ?? F7 ?? 00 ?? F7 ?? 00 ?? 56 ?? 00 ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? 77 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 77 ?? ?? 00 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPXHiT_001_DJ_Siba: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPXHiT_001_DJ_Siba"
        weight = 1
    strings:
        $a = { E2 FA 94 FF E0 61 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule hmimys_Protect_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID hmimys_Protect_v10"
        weight = 1
    strings:
        $a = { E8 BA 00 00 00 ?? 00 00 00 00 ?? ?? 00 00 10 40 00 ?? ?? ?? 00 ?? ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 5E 83 C6 64 AD 50 AD 50 83 EE 6C AD 50 AD 50 AD 50 AD 50 AD 50 E8 E7 07 00 00 AD 8B DE 8B F0 83 C3 44 AD 85 C0 74 32 8B F8 56 FF 13 8B E8 AC 84 C0 75 FB AC 84 C0 74 EA 4E AD A9 00 00 00 }
        $b = { 5E 83 C6 64 AD 50 AD 50 83 EE 6C AD 50 AD 50 AD 50 AD 50 AD 50 E8 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule id_Softwares_WAD_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID id_Softwares_WAD_file"
        weight = 1
    strings:
        $a = { 50 57 41 44 0B 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_42: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_42"
        weight = 1
    strings:
        $a = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 ?? ?? ?? ?? ?? ?? 83 ?? ?? 53 56 57 89 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Alex_Protector_v04_beta_1_by_Alex: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Alex_Protector_v04_beta_1_by_Alex"
        weight = 1
    strings:
        $a = { 60 E8 01 00 00 00 C7 83 C4 04 33 C9 E8 01 00 00 00 68 83 C4 04 E8 01 00 00 00 68 83 C4 04 B9 ?? 00 00 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 01 00 00 00 C7 83 C4 04 8B 2C 24 83 C4 04 E8 01 00 00 00 A9 83 C4 04 81 ED 3C 13 40 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 00 00 00 00 49 E8 01 00 00 00 68 83 C4 04 85 C9 75 DF E8 B9 02 00 00 E8 01 00 00 00 C7 83 C4 04 8D 95 63 14 40 00 E8 01 00 00 00 C7 83 C4 04 90 90 90 E8 CA 01 00 00 01 02 03 04 05 68 90 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EPack_14_lite_final_by_6aHguT: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EPack_14_lite_final_by_6aHguT"
        weight = 1
    strings:
        $a = { 33 C0 8B C0 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Interplays_MVE_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Interplays_MVE_file"
        weight = 1
    strings:
        $a = { 49 6E 74 65 72 70 6C 61 79 20 4D 56 45 20 46 69 6C 65 1A 00 1A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UnoPiX_103_110_BaGiE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UnoPiX_103_110_BaGiE"
        weight = 1
    strings:
        $a = { 83 EC 04 C7 04 24 00 ?? ?? ?? C3 00 ?? ?? 00 00 00 00 00 00 00 }
        $b = { 83 EC 04 C7 04 24 00 ?? ?? ?? C3 00 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 00 ?? ?? 00 00 10 00 00 00 00 00 00 02 00 00 ?? 00 00 ?? 00 00 ?? ?? 00 00 00 10 00 00 10 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule NSPack_Nort_Star_Software_urlwwwnsdsncom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NSPack_Nort_Star_Software_urlwwwnsdsncom"
        weight = 1
    strings:
        $a = { 83 F9 00 74 28 43 8D B5 ?? ?? FF FF 8B 16 56 51 53 52 56 FF 33 FF 73 04 8B 43 08 03 C2 50 FF 95 ?? ?? FF FF 5A 5B 59 5E 83 C3 0C E2 E1 61 9D E9 ?? ?? ?? FF 8B B5 ?? ?? FF FF 0B F6 0F 84 97 00 00 00 8B 95 ?? ?? FF FF 03 F2 83 3E 00 75 0E 83 7E 04 00 75 08 83 7E 08 00 75 02 EB 7A 8B 5E 08 03 DA 53 52 56 8D BD ?? ?? FF FF 03 7E 04 83 C6 0C 57 }
        $b = { 83 F9 00 74 28 43 8D B5 ?? ?? FF FF 8B 16 56 51 53 52 56 FF 33 FF 73 04 8B 43 08 03 C2 50 FF 95 ?? ?? FF FF 5A 5B 59 5E 83 C3 0C E2 E1 61 9D E9 ?? ?? ?? FF 8B B5 ?? ?? FF FF 0B F6 0F 84 97 00 00 00 8B 95 ?? ?? FF FF 03 F2 83 3E 00 75 0E 83 7E 04 00 75 08 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule MaskPE_V20_yzkzero: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MaskPE_V20_yzkzero"
        weight = 1
    strings:
        $a = { B8 18 00 00 00 64 8B 18 83 C3 30 C3 40 3E 0F B6 00 C1 E0 ?? 83 C0 ?? 36 01 04 24 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_119_Basic_Edition: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_119_Basic_Edition"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 ?? ?? 00 00 EB 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nSPack_2x3x_NET_North_StarLiu_Xing_Ping: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nSPack_2x3x_NET_North_StarLiu_Xing_Ping"
        weight = 1
    strings:
        $a = { FF 25 A4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v062: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v062"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 95 01 00 00 60 E8 00 00 00 00 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PS_AdobeFont_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PS_AdobeFont_v10"
        weight = 1
    strings:
        $a = { 80 01 ?? ?? 00 00 25 21 50 53 2D 41 64 6F 62 65 46 6F 6E 74 2D 31 2E 30 3A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_4x_LCC_Win32_1x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_4x_LCC_Win32_1x"
        weight = 1
    strings:
        $a = { B8 ?? ?? 8E D8 B8 ?? ?? CD 21 A3 ?? ?? 3C 03 7D ?? B4 09 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Fly_Crypter_10_ut1lz: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Fly_Crypter_10_ut1lz"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 B8 18 22 44 44 E8 7F F7 FF FF E8 0A F1 FF FF B8 09 00 00 00 E8 5C F1 FF FF 8B D8 85 DB 75 05 E8 85 FD FF FF 83 FB 01 75 05 E8 7B FD FF FF 83 FB 02 75 05 E8 D1 FD FF FF 83 FB 03 75 05 E8 87 FE FF FF 83 FB 04 75 05 E8 5D FD FF FF 83 FB 05 75 05 E8 B3 FD FF FF 83 FB 06 75 05 E8 69 FE FF FF 83 FB 07 75 05 E8 5F FE FF FF 83 FB 08 75 05 E8 95 FD FF FF 83 FB 09 75 05 E8 4B FE FF FF 5B E8 9D F2 FF FF 90 }
        $b = { 53 56 57 55 BB 2C ?? ?? 44 BE 00 30 44 44 BF 20 ?? ?? 44 80 7B 28 00 75 16 83 3F 00 74 11 8B 17 89 D0 33 D2 89 17 8B E8 FF D5 83 3F 00 75 EF 83 3D 04 30 44 44 00 74 06 FF 15 58 30 44 44 80 7B 28 02 75 0A 83 3E 00 75 05 33 C0 89 43 0C FF 15 20 30 44 44 80 7B 28 01 76 05 83 3E 00 74 22 8B 43 10 85 C0 74 1B FF 15 18 30 44 44 8B 53 10 8B 42 10 3B 42 04 74 0A 85 C0 74 06 50 E8 2F FA FF FF FF 15 24 30 44 44 80 7B 28 01 75 03 FF 53 24 80 7B 28 00 74 05 E8 35 FF FF FF 83 3B 00 75 17 83 3D 10 ?? ?? 44 00 74 06 FF 15 10 ?? ?? 44 8B 06 50 E8 51 FA FF FF 8B 03 56 8B F0 8B FB B9 0B 00 00 00 F3 A5 5E E9 73 FF FF FF 5D 5F 5E 5B C3 A3 00 30 44 44 E8 26 FF FF FF C3 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Vx_GRUNT1Family: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_GRUNT1Family"
        weight = 1
    strings:
        $a = { 01 B9 ?? 00 31 17 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ThemidaWinLicense_V1000_V1800_Oreans_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ThemidaWinLicense_V1000_V1800_Oreans_Technologies"
        weight = 1
    strings:
        $a = { B8 00 00 00 00 60 0B C0 74 58 E8 00 00 00 00 58 05 ?? 00 00 00 80 38 E9 75 ?? 61 EB ?? E8 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_SKE_23_Alexey_Solodovnikov_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_SKE_23_Alexey_Solodovnikov_h"
        weight = 1
    strings:
        $a = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 E5 0B 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Stealth_v27: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Stealth_v27"
        weight = 1
    strings:
        $a = { EB 00 EB 17 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 60 90 E8 00 00 00 00 5D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MetaWare_High_C_Run_Time_Library_p_Phar_Lap_DOS_Extender_1983_89: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MetaWare_High_C_Run_Time_Library_p_Phar_Lap_DOS_Extender_1983_89"
        weight = 1
    strings:
        $a = { B8 ?? ?? 50 B8 ?? ?? 50 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_PENightMare_2_Beta: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_PENightMare_2_Beta"
        weight = 1
    strings:
        $a = { 60 E9 10 00 00 00 EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PseudoSigner_01_ACProtect_109: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PseudoSigner_01_ACProtect_109"
        weight = 1
    strings:
        $a = { 60 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 08 00 90 90 90 EB 06 00 00 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V0b_cyberbobnbsp_nbsp_SignByfly_20080312: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V0b_cyberbobnbsp_nbsp_SignByfly_20080312"
        weight = 1
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 72 C8 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 26 E8 01 00 00 00 ?? 5A 33 C9 ?? ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B ?? ?? ?? ?? ?? ?? 8B 59 24 03 DA 8B 1B ?? ?? ?? ?? ?? ?? 53 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 0C 5B 6A 17 59 30 0C 03 02 CB 4B 75 F8 40 8D 9D 41 8F 4E 00 50 53 81 2C 24 01 78 0E 00 ?? ?? ?? ?? ?? ?? C3 92 EB 15 68 ?? ?? ?? ?? ?? B9 ?? 08 00 00 ?? ?? ?? ?? ?? ?? 4F 30 1C 39 FE CB E2 F9 68 1D 01 00 00 59 ?? ?? ?? ?? ?? ?? C0 0C 39 02 E2 FA 68 ?? ?? ?? ?? 50 01 6C 24 04 E8 BD 09 00 00 33 C0 0F 84 C0 08 00 00 ?? ?? ?? ?? ?? ?? 50 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF E0 C3 8D 64 24 04 E8 53 0A 00 00 D7 58 5B 51 C3 F7 F3 32 DA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 81 2C 24 A3 00 00 00 58 ?? ?? ?? ?? ?? ?? 53 FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimplePack_V11X_V12X_Method2_bagie: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimplePack_V11X_V12X_Method2_bagie"
        weight = 1
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 ?? 01 00 00 50 45 00 00 4C 01 02 00 }
        $b = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PeX_099_bartCrackPl: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PeX_099_bartCrackPl"
        weight = 1
    strings:
        $a = { E9 F5 ?? ?? ?? 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 }
        $b = { E9 F5 00 00 00 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule WATCOM_CCpp_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WATCOM_CCpp_DLL"
        weight = 1
    strings:
        $a = { 53 56 57 55 8B 74 24 14 8B 7C 24 18 8B 6C 24 1C 83 FF 03 0F 87 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TPAV_Cryptor_V11_msaha_dev_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TPAV_Cryptor_V11_msaha_dev_SignByfly"
        weight = 1
    strings:
        $a = { 8D 85 08 FF FF FF 50 8D 85 C4 FE FF FF 50 6A 00 6A 00 6A 04 6A 00 6A 00 6A 00 8D 95 C0 FE FF FF 33 C0 E8 ?? ?? FF FF 8B 85 C0 FE FF FF E8 ?? ?? FF FF 50 6A 00 FF 15 2C ?? ?? 70 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_HTML_Help_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_HTML_Help_file"
        weight = 1
    strings:
        $a = { 49 54 53 46 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule IBM_IOCA_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID IBM_IOCA_Graphics_format"
        weight = 1
    strings:
        $a = { 00 11 D3 A6 FB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MESS_v120: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MESS_v120"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? FA B9 ?? ?? F3 ?? ?? E3 ?? EB ?? EB ?? B6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_XRCV1015: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_XRCV1015"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5E 83 ?? ?? 53 51 1E 06 B4 99 CD 21 80 FC 21 ?? ?? ?? ?? ?? 33 C0 50 8C D8 48 8E C0 1F A1 ?? ?? 8B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v20_Markus_Laszlo_Reiser: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v20_Markus_Laszlo_Reiser"
        weight = 1
    strings:
        $a = { 55 FF 96 ?? ?? ?? ?? 09 C0 74 07 89 03 83 C3 04 EB ?? FF 96 ?? ?? ?? ?? 8B AE ?? ?? ?? ?? 8D BE 00 F0 FF FF BB 00 10 00 00 50 54 6A 04 53 57 FF D5 8D 87 ?? ?? 00 00 80 20 7F 80 60 28 7F 58 50 54 50 53 57 FF D5 58 61 8D 44 24 80 6A 00 39 C4 75 FA 83 EC 80 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXEStealth_v275a_WebtoolMaster: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXEStealth_v275a_WebtoolMaster"
        weight = 1
    strings:
        $a = { EB 58 53 68 61 72 65 77 61 72 65 2D 56 65 72 73 69 6F 6E 20 45 78 65 53 74 65 61 6C 74 68 2C 20 63 6F 6E 74 61 63 74 20 73 75 70 70 6F 72 74 40 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 00 90 60 90 E8 00 00 00 00 5D 81 ED F7 27 40 00 B9 15 00 00 00 83 C1 04 83 C1 01 EB 05 EB FE 83 C7 56 EB 00 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9 96 0C 00 00 90 8D BD 74 28 40 00 8B F7 AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 C5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v253b3: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v253b3"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 D8 ?? ?? ?? 68 14 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AntiDote_12_Beta_Demo_SIS_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiDote_12_Beta_Demo_SIS_Team"
        weight = 1
    strings:
        $a = { 68 69 D6 00 00 E8 C6 FD FF FF 68 69 D6 00 00 E8 BC FD FF FF 83 C4 08 E8 A4 FF FF FF 84 C0 74 2F 68 04 01 00 00 68 B0 21 60 00 6A 00 FF 15 08 10 60 00 E8 29 FF FF FF 50 68 88 10 60 00 68 78 10 60 00 68 B0 21 60 00 E8 A4 FD FF FF 83 C4 10 33 C0 C2 10 00 90 90 90 90 90 90 90 90 90 90 90 90 8B 4C 24 08 56 8B 74 24 08 33 D2 8B C6 F7 F1 8B C6 85 D2 74 08 33 D2 F7 F1 40 0F AF C1 5E C3 90 8B 44 24 04 53 55 56 8B 48 3C 57 03 C8 33 D2 8B 79 54 8B 71 38 8B C7 F7 F6 85 D2 74 0C 8B C7 33 D2 F7 F6 8B F8 47 0F AF FE 33 C0 33 DB 66 8B 41 14 8D 54 08 18 33 C0 }
        $b = { 68 69 D6 00 00 E8 C6 FD FF FF 68 69 D6 00 00 E8 BC FD FF FF 83 C4 08 E8 A4 FF FF FF 84 C0 74 2F 68 04 01 00 00 68 B0 21 60 00 6A 00 FF 15 08 10 60 00 E8 29 FF FF FF 50 68 88 10 60 00 68 78 10 60 00 68 B0 21 60 00 E8 A4 FD FF FF 83 C4 10 33 C0 C2 10 00 90 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PseudoSigner_01_Microsoft_Visual_Cpp_60_Debug_Version: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PseudoSigner_01_Microsoft_Visual_Cpp_60_Debug_Version"
        weight = 1
    strings:
        $a = { 55 8B EC 51 90 90 90 01 01 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 10 01 90 90 90 90 90 90 90 90 E8 00 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_120_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_120_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp"
        weight = 1
    strings:
        $a = { 0F BE C1 EB 01 0E 8D 35 C3 BE B6 22 F7 D1 68 43 ?? ?? 22 EB 02 B5 15 5F C1 F1 15 33 F7 80 E9 F9 BB F4 00 00 00 EB 02 8F D0 EB 02 08 AD 8A 16 2B C7 1B C7 80 C2 7A 41 80 EA 10 EB 01 3C 81 EA CF AE F1 AA EB 01 EC 81 EA BB C6 AB EE 2C E3 32 D3 0B CB 81 EA AB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_DEF_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_DEF_10"
        weight = 1
    strings:
        $a = { BE 00 01 40 00 6A 05 59 80 7E 07 00 74 11 8B 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 83 C1 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RosAsm_2050a_Betov: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RosAsm_2050a_Betov"
        weight = 1
    strings:
        $a = { 55 8B EC 60 8B 5D 08 B9 08 00 00 00 BF ?? ?? ?? ?? 83 C7 07 FD 8A C3 24 0F 04 30 3C 39 76 02 04 07 AA C1 EB 04 E2 EE FC 68 00 10 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 FF 15 ?? ?? ?? ?? 61 8B E5 5D C2 04 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Reg2Exe_220221_by_Jan_Vorel: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Reg2Exe_220221_by_Jan_Vorel"
        weight = 1
    strings:
        $a = { 6A 00 E8 7D 12 00 00 A3 A0 44 40 00 E8 79 12 00 00 6A 0A 50 6A 00 FF 35 A0 44 40 00 E8 0F 00 00 00 50 E8 69 12 00 00 CC CC CC CC CC CC CC CC CC 68 2C 02 00 00 68 00 00 00 00 68 B0 44 40 00 E8 3A 12 00 00 83 C4 0C 8B 44 24 04 A3 B8 44 40 00 68 00 00 00 00 68 A0 0F 00 00 68 00 00 00 00 E8 32 12 00 00 A3 B0 44 40 00 68 F4 01 00 00 68 BC 44 40 00 FF 35 B8 44 40 00 E8 1E 12 00 00 B8 BC 44 40 00 89 C1 8A 30 40 80 FE 5C 75 02 89 C1 80 FE 00 75 F1 C6 01 00 E8 EC 18 00 00 E8 28 16 00 00 E8 4A 12 00 00 68 00 FA 00 00 68 08 00 00 00 FF 35 B0 44 40 00 E8 E7 11 00 00 A3 B4 44 40 00 8B 15 D4 46 40 00 E8 65 0A 00 00 BB 00 00 10 00 B8 01 00 00 00 E8 72 0A 00 00 74 09 C7 00 01 00 00 00 83 C0 04 A3 D4 46 40 00 FF 35 B4 44 40 00 E8 26 05 00 00 8D 0D B8 46 40 00 5A E8 CF 0F 00 00 FF 35 B4 44 40 00 FF 35 B8 46 40 00 E8 EE 06 00 00 8D 0D B4 46 40 00 5A E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V029_V031_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V029_V031_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? AD 8B F8 95 AD 91 F3 A5 AD ?? ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 57 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF ?? ?? ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 01 E3 29 8B D7 2B 55 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 56 08 33 C9 FF 66 24 B1 30 8B 5D 0C 03 D1 FF 16 73 4B 03 D1 FF 16 72 19 03 D1 FF 16 72 29 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 45 0C 8A 00 FF 66 20 83 C2 60 FF 16 87 5D 10 73 0C 03 D1 FF 16 87 5D 14 73 03 87 5D 18 3C 07 B0 08 72 02 B0 0B 50 53 8B D5 03 56 14 FF 56 0C 5B 91 FF 66 3C 07 B0 07 72 02 B0 0A 50 87 5D 10 87 5D 14 89 5D 18 8B D5 03 56 18 FF 56 0C 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D 9C 85 7C 03 00 00 FF 56 04 3C 04 8B D8 72 5F 33 DB D1 E8 13 DB 48 43 91 43 D3 E3 80 F9 05 8D 94 9D 7C 01 00 00 76 2E 80 E9 04 33 C0 8B 55 00 D1 6D 08 8B 12 0F CA 2B 55 04 03 C0 3B 55 08 72 07 8B 55 08 40 01 55 04 FF 56 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Noon1163: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Noon1163"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5B 50 56 B4 CB CD 21 3C 07 ?? ?? 81 ?? ?? ?? 2E ?? ?? 4D 5A ?? ?? BF 00 01 89 DE FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_V102_Ashkbiz_Danehkar_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_V102_Ashkbiz_Danehkar_Sign_by_fly"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED 23 3F 42 00 8B D5 81 C2 72 3F 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 35 66 42 00 81 E9 1D 40 42 00 8B D5 81 C2 1D 40 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 BE 1F 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Stelth_PE_101: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Stelth_PE_101"
        weight = 1
    strings:
        $a = { 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 BA ?? ?? ?? ?? FF E2 BA E0 10 40 00 B8 68 24 1A 40 89 02 83 C2 03 B8 40 00 E8 EE 89 02 83 C2 FD FF E2 2D 3D 5B 20 48 69 64 65 50 45 20 5D 3D 2D 90 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEArmor_V07X_Hying: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEArmor_V07X_Hying"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 79 01 00 00 90 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RAR_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RAR_Archive"
        weight = 1
    strings:
        $a = { 52 61 72 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule JAM_v211: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID JAM_v211"
        weight = 1
    strings:
        $a = { 50 06 16 07 BE ?? ?? 8B FE B9 ?? ?? FD FA F3 2E A5 FB 06 BD ?? ?? 55 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Software_Compress_V14_BG_Software_Protect_Technologies_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Software_Compress_V14_BG_Software_Protect_Technologies_SignByfly"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 81 2C 24 AA 1A 41 00 5D E8 00 00 00 00 83 2C 24 6E 8B 85 5D 1A 41 00 29 04 24 8B 04 24 89 85 5D 1A 41 00 58 8B 85 5D 1A 41 00 8B 50 3C 03 D0 8B 92 80 00 00 00 03 D0 8B 4A 58 89 8D 49 1A 41 00 8B 4A 5C 89 8D 4D 1A 41 00 8B 4A 60 89 8D 55 1A 41 00 8B 4A 64 89 8D 51 1A 41 00 8B 4A 74 89 8D 59 1A 41 00 68 00 20 00 00 E8 D2 00 00 00 50 8D 8D 00 1C 41 00 50 51 E8 1B 00 00 00 83 C4 08 58 8D 78 74 8D B5 49 1A 41 00 B9 18 00 00 00 F3 A4 05 A4 00 00 00 50 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule dePACK_deNULL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID dePACK_deNULL"
        weight = 1
    strings:
        $a = { EB 01 DD 60 68 00 ?? ?? ?? 68 ?? ?? 00 00 E8 ?? 00 00 00 }
        $b = { EB 01 DD 60 68 00 ?? ?? ?? 68 ?? ?? ?? 00 E8 ?? 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule v02Packer_ttt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID v02Packer_ttt"
        weight = 1
    strings:
        $a = { 60 E8 36 FE FF FF C3 90 ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Sentinel_UltraPro_Dongle_V110_SafeNet_Inc_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Sentinel_UltraPro_Dongle_V110_SafeNet_Inc_SignByfly"
        weight = 1
    strings:
        $a = { A1 ?? ?? ?? ?? 85 C0 0F 85 59 06 00 00 55 56 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 25 FE ?? ?? ?? 0D 01 ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 50 C7 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 BD 0F 00 00 83 C4 04 83 F8 64 7C E7 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 A1 ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 66 8B 4D 00 83 C5 08 ?? ?? ?? ?? ?? ?? ?? 66 8B 75 FA ?? ?? ?? ?? ?? ?? 66 ?? ?? ?? ?? ?? ?? 8B 55 FC 81 E1 FF FF 00 00 81 F9 }
        $b = { A1 ?? ?? ?? ?? 85 C0 0F 85 59 06 00 00 55 56 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 25 FE ?? ?? ?? 0D 01 ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 50 C7 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 BD 0F 00 00 83 C4 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PE_Diminisher_v01: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Diminisher_v01"
        weight = 1
    strings:
        $a = { 5D 8B D5 81 ED A2 30 40 ?? 2B 95 91 33 40 ?? 81 EA 0B ?? ?? ?? 89 95 9A 33 40 ?? 80 BD 99 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule XMI_music_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID XMI_music_file"
        weight = 1
    strings:
        $a = { 46 4F 52 4D ?? ?? ?? ?? 58 4D 49 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nPack_v113002006_Beta: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nPack_v113002006_Beta"
        weight = 1
    strings:
        $a = { 83 3D 4C ?? ?? 00 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Backfont900: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Backfont900"
        weight = 1
    strings:
        $a = { E8 ?? ?? B4 30 CD 21 3C 03 ?? ?? B8 ?? ?? BA ?? ?? CD 21 81 FA ?? ?? ?? ?? BA ?? ?? 8C C0 48 8E C0 8E D8 80 ?? ?? ?? 5A ?? ?? 03 ?? ?? ?? 40 8E D8 80 ?? ?? ?? 5A ?? ?? 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MoleBox_Pro_v261: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MoleBox_Pro_v261"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 60 E8 4F 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E9 2A 6A 00 00 E9 3E 6A 00 00 E9 39 6A 00 00 E8 6E FB FF FF 7E 04 01 00 ?? 96 00 00 ?? ?? ?? ?? ?? ?? F1 ?? ?? ?? A4 ?? ?? ?? A1 ?? ?? ?? E0 ?? ?? ?? 19 ?? ?? ?? BE ?? ?? ?? 13 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Petite_14: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Petite_14"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? 66 9C 60 50 8B D8 03 00 68 54 BC 00 00 6A 00 FF 50 14 8B CC 8D A0 54 BC 00 00 50 8B C3 8D 90 ?? 16 00 00 68 00 00 ?? ?? 51 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 D8 14 00 00 8B 44 24 18 F6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Petite_12: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Petite_12"
        weight = 1
    strings:
        $a = { 66 9C 60 E8 CA 00 00 00 03 00 04 00 05 00 06 00 07 00 08 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Petite_13: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Petite_13"
        weight = 1
    strings:
        $a = { 66 9C 60 50 8D 88 00 F0 00 00 8D 90 04 16 00 00 8B DC 8B E1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V119_Dll_LZMA_430_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V119_Dll_LZMA_430_ap0x"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 C7 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76 01 00 00 EB 20 60 8B 85 49 0B 00 00 FF B5 41 0B 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD 55 0B 00 00 00 74 0E 83 BD 59 0B 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 DA 0A 00 00 89 85 69 0B 00 00 5B 60 FF B5 41 0B 00 00 56 FF B5 69 0B 00 00 FF D3 61 8B B5 69 0B 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 E9 98 00 00 00 56 FF 95 D2 0A 00 00 89 85 61 0B 00 00 85 C0 0F 84 C8 00 00 00 8B C6 EB 5F 8B 85 65 0B 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 65 0B 00 00 C7 00 20 20 20 00 EB 06 FF B5 65 0B 00 00 FF B5 61 0B 00 00 FF 95 D6 0A 00 00 85 C0 0F 84 87 00 00 00 89 07 83 C7 04 8B 85 65 0B 00 00 EB 01 40 80 38 00 75 FA 40 89 85 65 0B 00 00 66 81 78 02 00 80 74 A1 80 38 00 75 9C EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 80 3E 01 0F 85 5F FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 69 0B 00 00 FF 95 DE 0A 00 00 68 00 40 00 00 68 00 20 0C 00 FF B5 41 0B 00 00 FF 95 DE 0A 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CrunchPE_v30xx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CrunchPE_v30xx"
        weight = 1
    strings:
        $a = { 03 D6 B4 40 CD 21 B8 02 42 33 D2 33 C9 CD 21 8B D6 B9 78 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PolyBox_C_Anskya: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PolyBox_C_Anskya"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED DE 26 40 00 8B BD 05 28 40 00 8B 8D 0D 28 40 00 B8 25 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 09 28 40 00 31 C0 51 31 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 09 28 40 00 8B 85 11 }
        $b = { 55 8B EC 83 C4 F0 53 56 B8 E4 41 00 10 E8 3A E1 FF FF 33 C0 55 68 11 44 00 10 64 FF 30 64 89 20 EB 08 FC FC FC FC FC FC 27 54 6A 0A 68 20 44 00 10 A1 1C 71 00 10 50 E8 CC E1 ?? ?? ?? ?? 85 DB 0F 84 77 01 00 00 53 A1 1C 71 00 10 50 E8 1E E2 FF FF 8B F0 85 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Microsoft_Visual_Cpp_80_MFC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_80_MFC"
        weight = 1
    strings:
        $a = { 48 83 EC 28 E8 ?? ?? 00 00 48 83 C4 28 E9 0E FD FF FF CC CC CC CC CC CC CC CC CC CC CC CC CC CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Bitmap_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Bitmap_Graphics_format"
        weight = 1
    strings:
        $a = { 01 00 09 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_v11_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_v11_Vaska"
        weight = 1
    strings:
        $a = { 90 58 90 50 90 8B 00 90 3C 50 90 58 0F 85 67 D6 EF 11 50 68 00 10 14 13 B8 00 10 14 13 3D 00 64 14 13 74 06 80 30 BC 40 EB F3 E8 00 00 00 00 C3 }
        $b = { 8B 04 24 83 E8 4F 68 ?? ?? ?? ?? FF D0 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule FSG_v133: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v133"
        weight = 1
    strings:
        $a = { BE A4 01 40 00 AD 93 AD 97 AD 56 96 B2 80 A4 B6 80 FF 13 73 F9 33 C9 FF 13 73 16 33 C0 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v301_v305: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v301_v305"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 60 33 C9 75 02 EB 15 EB 33 C9 75 18 7A 0C 70 0E EB 0D E8 72 0E 79 F1 FF 15 00 79 09 74 F0 EB 87 DB 7A F0 A0 33 61 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 A0 8B 04 24 EB 03 7A 29 E9 C6 00 90 C3 E8 70 F0 87 D2 71 07 E9 00 40 8B DB 7A 11 EB 08 E9 EB F7 EB C3 E8 7A E9 70 DA 7B D1 71 F3 E9 7B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi_v60_v70: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_v60_v70"
        weight = 1
    strings:
        $a = { BA ?? ?? ?? ?? 83 7D 0C 01 75 ?? 50 52 C6 05 ?? ?? ?? ?? ?? 8B 4D 08 89 0D ?? ?? ?? ?? 89 4A 04 }
        $b = { 55 8B EC 83 C4 F0 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Upack_022_023_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_022_023_beta_Dwing"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? AD 8B F8 59 95 F3 A5 AD B5 ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 ?? 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 }
        $b = { 6A 07 BE 88 01 40 00 AD 8B F8 59 95 F3 A5 AD B5 ?? F3 AB AD 50 97 51 58 8D 54 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PESpin_13beta_Cyberbob_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_13beta_Cyberbob_h"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Packman_v0001: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Packman_v0001"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 58 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 8D ?? ?? 48 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_FullEdition_V120_LZMA_430_ap0x_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_FullEdition_V120_LZMA_430_ap0x_SignByfly"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 10 00 00 08 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Kbys_Packer_028_Beta_shoooo314: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Kbys_Packer_028_Beta_shoooo314"
        weight = 1
    strings:
        $a = { 68 85 AE 01 01 E8 01 00 00 00 C3 C3 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Free_Pascal_v09910: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Free_Pascal_v09910"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 00 6E 00 00 55 89 E5 8B 7D 0C 8B 75 08 89 F8 8B 5D 10 29 }
        $b = { C6 05 ?? ?? 40 00 ?? E8 ?? ?? 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule tElock_099_10_private_tE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_099_10_private_tE"
        weight = 1
    strings:
        $a = { E9 ?? ?? FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Necropolis: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Necropolis"
        weight = 1
    strings:
        $a = { B4 30 CD 21 3C 03 ?? ?? B8 00 12 CD 2F 3C FF B8 ?? ?? ?? ?? B4 4A BB 40 01 CD 21 ?? ?? FA 0E 17 BC ?? ?? E8 ?? ?? FB A1 ?? ?? 0B C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MinGW_v32x_Dll_WinMain: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MinGW_v32x_Dll_WinMain"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 18 89 75 FC 8B 75 0C 89 5D F8 83 FE 01 74 5C 89 74 24 04 8B 55 10 89 54 24 08 8B 55 08 89 14 24 E8 76 01 00 00 83 EC 0C 83 FE 01 89 C3 74 2C 85 F6 75 0C 8B 0D 00 30 00 10 85 C9 75 10 31 DB 89 D8 8B 5D F8 8B 75 FC 89 EC 5D C2 0C 00 E8 59 00 00 00 EB EB 8D B4 26 00 00 00 00 85 C0 75 D0 E8 47 00 00 00 EB C9 90 8D 74 26 00 C7 04 24 80 00 00 00 E8 A4 05 00 00 A3 00 30 00 10 85 C0 74 1A C7 00 00 00 00 00 A3 10 30 00 10 E8 1B 02 00 00 E8 A6 01 00 00 E9 75 FF FF FF E8 6C 05 00 00 C7 00 0C 00 00 00 31 C0 EB 98 89 F6 55 89 E5 83 EC 08 89 5D FC 8B 15 00 30 00 10 85 D2 74 29 8B 1D 10 30 00 10 83 EB 04 39 D3 72 0D 8B 03 85 C0 75 2A 83 EB 04 39 D3 73 F3 89 14 24 E8 1B 05 00 00 31 C0 A3 00 30 00 10 C7 04 24 00 00 00 00 E8 F8 04 00 00 8B 5D FC 89 EC 5D C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressor_v13_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_v13_CGSoftLabs"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC ?? 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 33 2E 2E B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 13 A1 ?? ?? ?? ?? 03 05 ?? ?? ?? ?? 89 ?? ?? E9 ?? ?? 00 00 C7 05 }
        $b = { 45 78 50 72 2D 76 2E 31 2E 33 2E }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule COMPACK_v51: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID COMPACK_v51"
        weight = 1
    strings:
        $a = { BD ?? ?? 50 06 8C CB 03 DD 8C D2 4B 8E DB BE ?? ?? BF ?? ?? 8E C2 B9 ?? ?? F3 A5 4A 4D 75 ?? 8B F7 8E DA 0E 07 06 16 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RIX_graphics_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RIX_graphics_file"
        weight = 1
    strings:
        $a = { 52 49 58 33 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Themida_1201_compressed_Oreans_Technologies_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Themida_1201_compressed_Oreans_Technologies_h"
        weight = 1
    strings:
        $a = { B8 00 00 ?? ?? 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 ?? ?? ?? 00 03 C7 B9 ?? ?? ?? 00 03 CF EB 0A B8 ?? ?? ?? ?? B9 5A ?? ?? ?? 50 51 E8 84 00 00 00 E8 00 00 00 00 58 2D 26 00 00 00 B9 EF 01 00 00 C6 00 E9 83 E9 05 89 48 01 61 E9 AF 01 00 00 02 00 00 00 91 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_v16_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_v16_Vaska"
        weight = 1
    strings:
        $a = { 33 D0 68 ?? ?? ?? ?? FF D2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AcidCrypt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AcidCrypt"
        weight = 1
    strings:
        $a = { 60 B9 ?? ?? ?? 00 BA ?? ?? ?? 00 BE ?? ?? ?? 00 02 38 40 4E 75 FA 8B C2 8A 18 32 DF C0 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeBundle_v30_small_loader: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeBundle_v30_small_loader"
        weight = 1
    strings:
        $a = { 00 00 00 00 60 BE 00 F0 40 00 8D BE 00 20 FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NoName_Packer: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NoName_Packer"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 2E 34 46 00 B9 55 4A 46 00 81 E9 26 37 46 00 89 EA 81 C2 26 37 46 00 8D 3A 89 FE 31 C0 E9 D3 02 00 00 CC CC CC CC E9 CA 02 00 00 43 3A 5C 57 69 6E 64 6F 77 73 5C 53 6F 66 74 57 61 72 65 50 72 6F 74 65 63 74 6F 72 5C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PC_Shrinker_v029: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PC_Shrinker_v029"
        weight = 1
    strings:
        $a = { ?? BD ?? ?? ?? ?? 01 AD 55 39 40 ?? 8D B5 35 39 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_Run_Time_Library_1988_04: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Run_Time_Library_1988_04"
        weight = 1
    strings:
        $a = { 1E B8 ?? ?? 8E D8 B4 30 CD 21 3C 02 73 ?? BA ?? ?? E8 ?? ?? 06 33 C0 50 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NET_DLL_Microsoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NET_DLL_Microsoft"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 5F 43 6F 72 44 6C 6C 4D 61 69 6E 00 6D 73 63 6F 72 65 65 2E 64 6C 6C 00 00 ?? 00 00 FF 25 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_098_Special_Build_forgot_heXer: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_098_Special_Build_forgot_heXer"
        weight = 1
    strings:
        $a = { E9 99 D7 FF FF 00 00 00 ?? ?? ?? ?? AA ?? ?? 00 00 00 00 00 00 00 00 00 CA }
        $b = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ActiveMARK_5x_Trymedia_Systems_Inc_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ActiveMARK_5x_Trymedia_Systems_Inc_h"
        weight = 1
    strings:
        $a = { 20 2D 2D 4D 50 52 4D 4D 47 56 41 2D 2D 00 75 73 65 72 33 32 2E 64 6C 6C 00 4D 65 73 73 61 67 65 42 6F 78 41 00 54 68 69 73 20 61 70 70 6C 69 63 61 74 69 6F 6E 20 63 61 6E 6E 6F 74 20 72 75 6E 20 77 69 74 68 20 61 6E 20 61 63 74 69 76 65 20 64 65 62 75 67 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Gem_VDI_Image_graphics_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Gem_VDI_Image_graphics_file"
        weight = 1
    strings:
        $a = { 00 01 00 ?? 00 ?? 00 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Armor_046_Hying: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Armor_046_Hying"
        weight = 1
    strings:
        $a = { E8 AA 00 00 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 3D ?? ?? 00 2D ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 5C ?? ?? 00 6F ?? ?? 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_UPX_modifyer: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_UPX_modifyer"
        weight = 1
    strings:
        $a = { E8 02 00 00 00 CD 03 5A 81 C2 ?? ?? ?? ?? 81 C2 ?? ?? ?? ?? 89 D1 81 C1 3C 05 00 00 52 81 2A 33 53 45 12 83 C2 04 39 CA 7E F3 89 CA 8B 42 04 8D 18 29 02 BB 78 56 00 00 83 EA 04 3B 14 24 7D EC C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CRYPToCRACks_PE_Protector_v093_Lucas_Fleischer_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CRYPToCRACks_PE_Protector_v093_Lucas_Fleischer_h"
        weight = 1
    strings:
        $a = { 5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 33 8B F3 03 73 3C 81 3E 50 45 00 00 75 26 0F B7 46 18 8B C8 69 C0 AD 0B 00 00 F7 E0 2D AB 5D 41 4B 69 C9 DE C0 00 00 03 C1 75 09 83 EC 04 0F 85 DD 00 00 00 81 EB 00 01 00 00 75 BE 90 72 ?? ?? ?? ?? 00 00 00 00 00 00 00 7A ?? ?? ?? 72 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 C1 00 46 61 74 61 6C 45 78 69 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SC_Obfuscator_SuperCRacker: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SC_Obfuscator_SuperCRacker"
        weight = 1
    strings:
        $a = { 60 33 C9 8B 1D 00 ?? ?? ?? 03 1D 08 ?? ?? ?? 8A 04 19 84 C0 74 09 3C ?? 74 05 34 ?? 88 04 19 41 3B 0D 04 ?? ?? ?? 75 E7 A1 08 ?? ?? ?? 01 05 0C ?? ?? ?? 61 FF 25 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PrivateEXE_v20a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PrivateEXE_v20a"
        weight = 1
    strings:
        $a = { 06 60 C8 ?? ?? ?? 0E 68 ?? ?? 9A ?? ?? ?? ?? 3D ?? ?? 0F ?? ?? ?? 50 50 0E 68 ?? ?? 9A ?? ?? ?? ?? 0E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Caz1204: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Caz1204"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5E 83 EE 03 1E 06 B8 FF FF CD 2F 3C 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BobSoft_Mini_Delphi_BoB_BobSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BobSoft_Mini_Delphi_BoB_BobSoft"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 B8 ?? ?? ?? ?? E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_099c_Private_ECLIPSE_tE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_099c_Private_ECLIPSE_tE"
        weight = 1
    strings:
        $a = { E9 3F DF FF FF 00 00 00 ?? ?? ?? ?? 04 ?? ?? 00 00 00 00 00 00 00 00 00 24 ?? ?? 00 14 ?? ?? 00 0C ?? ?? 00 00 00 00 00 00 00 00 00 31 ?? ?? 00 1C ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 3C ?? ?? 00 00 00 00 00 4F ?? ?? 00 00 00 00 00 3C ?? ?? 00 00 00 00 00 4F ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 75 73 65 }
        $b = { E9 3F DF FF FF 00 00 00 ?? ?? ?? ?? 04 ?? ?? 00 00 00 00 00 00 00 00 00 24 ?? ?? 00 14 ?? ?? 00 0C ?? ?? 00 00 00 00 00 00 00 00 00 31 ?? ?? 00 1C ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 3C ?? ?? 00 00 00 00 00 4F ?? ?? 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule UltraPro_V10_SafeNet: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UltraPro_V10_SafeNet"
        weight = 1
    strings:
        $a = { A1 ?? ?? ?? ?? 85 C0 0F 85 3B 06 00 00 55 56 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_30x_3300_Thinstall_Inc: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Virtualization_Suite_30x_3300_Thinstall_Inc"
        weight = 1
    strings:
        $a = { CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 ?? ?? ?? 33 DB BA ?? ?? ?? ?? 43 33 C0 E8 19 01 ?? ?? 73 0E 8B 4D F8 E8 27 01 ?? ?? 02 45 F7 AA EB E9 E8 04 01 ?? ?? 0F 82 96 ?? ?? ?? E8 F9 ?? ?? ?? 73 5B B9 04 ?? ?? ?? E8 05 01 ?? ?? 48 74 DE 0F 89 ?? ?? ?? ?? E8 DF ?? ?? ?? 73 1B 55 BD ?? ?? ?? ?? E8 DF ?? ?? ?? 88 07 47 4D 75 F5 E8 C7 ?? ?? ?? 72 E9 5D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi_v50_KOL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_v50_KOL"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 ?? ?? 40 00 E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF 8B C0 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MPRESS_V107_V125_MATCODE_Softwarenbsp_nbsp_SignByfly_20080730: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MPRESS_V107_V125_MATCODE_Softwarenbsp_nbsp_SignByfly_20080730"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 58 05 9E 02 00 00 8B 30 03 F0 2B C0 8B FE 66 AD C1 E0 0C 8B C8 50 AD 2B C8 03 F1 8B C8 57 51 49 8A 44 39 06 74 05 88 04 31 EB F4 88 04 31 8B D6 8B CF E8 56 00 00 00 5E 5A 83 EA 05 2B C9 3B CA 73 26 8B D9 AC 41 24 FE 3C E8 75 F2 43 83 C1 04 AD 0B C0 78 06 3B C2 73 E5 EB 06 03 C3 78 DF 03 C2 2B C3 89 46 FC EB D6 E8 00 00 00 00 5F 81 C7 8D FF FF FF B0 E9 AA B8 9A 02 00 00 AB E8 00 00 00 00 58 05 1C 02 00 00 E9 0C 02 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_PE_Lock_NT_204_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_PE_Lock_NT_204_emadicius"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 5B 83 EB 05 EB 04 52 4E 44 21 85 C0 73 02 F7 05 50 E8 08 00 00 00 EA FF 58 EB 18 EB 01 0F EB 02 CD 20 EB 03 EA CD 20 58 58 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule APatch_GUI_v11: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID APatch_GUI_v11"
        weight = 1
    strings:
        $a = { 52 31 C0 E8 FF FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Enigma_Protector_v112_LITE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Enigma_Protector_v112_LITE"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ED 06 81 ED ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RPolyCrypt_v_10_personal_polycryptor_sign_from_pinch: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RPolyCrypt_v_10_personal_polycryptor_sign_from_pinch"
        weight = 1
    strings:
        $a = { 50 58 97 97 60 61 8B 04 24 80 78 F3 6A E8 00 00 00 00 58 E8 00 00 00 00 58 91 91 EB 00 0F 85 6B F4 76 6F E8 00 00 00 00 83 C4 04 E8 00 00 00 00 58 90 E8 00 00 00 00 83 C4 04 8B 04 24 80 78 F1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nPack_V115002008_Beta_NEOxnbsp_nbsp_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nPack_V115002008_Beta_NEOxnbsp_nbsp_SignByfly"
        weight = 1
    strings:
        $a = { 83 3D ?? ?? ?? ?? ?? 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 9C 00 00 00 E8 48 02 00 00 E8 F8 06 00 00 E8 47 06 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? C3 C3 56 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 5F A3 ?? ?? ?? ?? 5E C3 56 57 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 8B F0 BF ?? ?? ?? ?? 56 57 E8 23 FE FF FF 6A ?? 56 57 E8 F4 FC FF FF 83 C4 14 68 ?? ?? ?? ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 5F 5E C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_31_by_North_Star_Liu_Xing_Ping: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_31_by_North_Star_Liu_Xing_Ping"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? FF FF 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 }
        $b = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? FF FF 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Hyings_PE_Armor_076_Hying_CCG_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Hyings_PE_Armor_076_Hying_CCG_h"
        weight = 1
    strings:
        $a = { 01 00 ?? ?? 00 00 00 00 00 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 56 69 72 74 75 61 6C 46 72 65 65 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 61 ?? ?? ?? 59 ?? ?? ?? ?? 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 8D ?? ?? ?? ?? 00 00 00 00 00 00 00 9D ?? ?? ?? 8D ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 00 08 00 00 00 00 00 00 00 60 E8 00 00 00 00 5D 81 ED F0 00 00 00 8D B5 07 01 00 00 55 56 81 C5 ?? ?? ?? ?? 55 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_emadicius_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_emadicius_h"
        weight = 1
    strings:
        $a = { E9 ?? 00 00 00 0D 0A 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 50 45 2D 50 52 4F 54 45 43 54 20 30 2E 39 20 28 43 29 6F 70 79 72 69 67 68 74 20 62 79 20 43 48 52 69 53 54 4F 50 48 20 47 41 42 4C 45 52 20 69 6E 20 31 39 39 38 21 0D 0A 52 65 67 69 73 74 65 72 65 64 20 74 6F 20 3A 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_V031_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_V031_emadicius"
        weight = 1
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? C7 87 ?? ?? ?? ?? ?? ?? ?? ?? 57 83 CD FF EB 0E ?? ?? ?? ?? 8A 06 46 88 07 47 01 DB 75 07 8B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Protect_Shareware_V11_eCompserv_CMS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Protect_Shareware_V11_eCompserv_CMS"
        weight = 1
    strings:
        $a = { 53 00 74 00 72 00 69 00 6E 00 67 00 46 00 69 00 6C 00 65 00 49 00 6E 00 66 00 6F 00 00 00 ?? 01 00 00 01 00 30 00 34 00 30 00 39 00 30 00 34 00 42 00 30 00 00 00 34 00 ?? 00 01 00 43 00 6F 00 6D 00 70 00 61 00 6E 00 79 00 4E 00 61 00 6D 00 65 00 00 00 00 00 4A 00 76 00 77 00 }
        $b = { 53 00 74 00 72 00 69 00 6E 00 67 00 46 00 69 00 6C 00 65 00 49 00 6E 00 66 00 6F 00 00 00 ?? 01 00 00 01 00 30 00 34 00 30 00 39 00 30 00 34 00 42 00 30 00 00 00 34 00 ?? 00 01 00 43 00 6F 00 6D 00 70 00 61 00 6E 00 79 00 4E 00 61 00 6D 00 65 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Unknown_SFX_Archive_aWAW: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_SFX_Archive_aWAW"
        weight = 1
    strings:
        $a = { 61 57 41 57 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Celsius_Crypt_21_Z3r0: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Celsius_Crypt_21_Z3r0"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 84 92 44 00 E8 C8 FE FF FF 90 8D B4 26 00 00 00 00 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 84 92 44 00 E8 A8 FE FF FF 90 8D B4 26 00 00 00 00 55 8B 0D C4 92 44 00 89 E5 5D FF E1 8D 74 26 00 55 8B 0D AC 92 44 00 89 E5 5D FF E1 90 90 90 90 55 89 E5 5D E9 77 C2 00 00 90 90 90 90 90 90 90 55 89 E5 83 EC 28 8B 45 10 89 04 24 E8 3F 14 01 00 48 89 45 FC 8B 45 0C 48 89 45 F4 8D 45 F4 89 44 24 04 8D 45 FC 89 04 24 E8 12 A3 03 00 8B 00 89 45 F8 8B 45 FC 89 45 F0 C6 45 EF 01 C7 45 E8 00 00 00 00 8B 45 E8 3B 45 F8 73 39 80 7D EF 00 74 33 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 1C 1A 01 00 89 C1 8B 45 08 8B 55 E8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 8D 45 E8 FF 00 EB BF 83 7D F0 00 74 34 80 7D EF 00 74 2E 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 DD 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 EB C6 C7 44 24 04 00 00 00 00 8B 45 10 89 04 24 E8 AE 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 7F 0C 0F B6 45 EF 83 E0 01 88 45 E7 EB 04 C6 45 E7 00 0F B6 45 E7 88 45 EF 0F B6 45 EF C9 C3 }
        $b = { 55 89 E5 83 EC 28 8B 45 10 89 04 24 E8 3F 14 01 00 48 89 45 FC 8B 45 0C 48 89 45 F4 8D 45 F4 89 44 24 04 8D 45 FC 89 04 24 E8 12 A3 03 00 8B 00 89 45 F8 8B 45 FC 89 45 F0 C6 45 EF 01 C7 45 E8 00 00 00 00 8B 45 E8 3B 45 F8 73 39 80 7D EF 00 74 33 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 1C 1A 01 00 89 C1 8B 45 08 8B 55 E8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 8D 45 E8 FF 00 EB BF 83 7D F0 00 74 34 80 7D EF 00 74 2E 8B 45 F0 89 44 24 04 8B 45 10 89 04 24 E8 DD 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 0F 94 C0 88 45 EF 8D 45 F0 FF 08 EB C6 C7 44 24 04 00 00 00 00 8B 45 10 89 04 24 E8 AE 19 01 00 89 C1 8B 45 08 8B 55 F8 01 C2 0F B6 01 3A 02 7F 0C 0F B6 45 EF 83 E0 01 88 45 E7 EB 04 C6 45 E7 00 0F B6 45 E7 88 45 EF 0F B6 45 EF C9 C3 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Upack_v031_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v031_beta_Dwing"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 4C 01 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 31 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MicroJoiner_11_coban2k: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MicroJoiner_11_coban2k"
        weight = 1
    strings:
        $a = { BE 0C 70 40 00 BB F8 11 40 00 33 ED 83 EE 04 39 2E 74 11 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1361_Obsidium_Softwarenbsp_nbsp_SignByfly_20080521: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1361_Obsidium_Softwarenbsp_nbsp_SignByfly_20080521"
        weight = 1
    strings:
        $a = { EB 04 ?? ?? ?? ?? 50 EB 02 ?? ?? E8 ?? 00 00 00 EB 03 ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 ?? EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? EB 01 ?? 33 C0 EB 04 ?? ?? ?? ?? 64 FF 30 EB 04 ?? ?? ?? ?? 64 89 20 EB 01 ?? EB 03 ?? ?? ?? 8B 00 EB 02 ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 01 ?? E8 ?? FF FF FF EB 01 ?? EB 03 ?? ?? ?? EB 01 ?? EB 03 ?? ?? ?? 64 8F 00 EB 03 ?? ?? ?? 83 C4 04 EB 01 ?? 58 EB 02 ?? ?? E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Adlib_Sample_Audio_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Adlib_Sample_Audio_file"
        weight = 1
    strings:
        $a = { 47 4F 4C 44 20 53 41 4D 50 4C 45 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_v13_v14_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_v13_v14_Vaska"
        weight = 1
    strings:
        $a = { 55 8B EC 8B 44 24 04 83 E8 4F 68 ?? ?? ?? ?? FF D0 58 59 50 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Img_Software_Set_graphics_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Img_Software_Set_graphics_file"
        weight = 1
    strings:
        $a = { 53 43 4D 49 20 20 20 31 41 54 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_Install_System_20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_Install_System_20"
        weight = 1
    strings:
        $a = { 83 EC 20 53 55 56 33 DB 57 89 5C 24 18 C7 44 24 10 ?? ?? ?? ?? C6 44 24 14 20 FF 15 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 02 23 00 00 BE ?? ?? ?? ?? 56 }
        $b = { 83 EC 0C 53 55 56 57 C7 44 24 10 70 92 40 00 33 DB C6 44 24 14 20 FF 15 2C 70 40 00 53 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 2D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Obsidium_V1353_Obsidium_Software_SignByfly_20080120: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1353_Obsidium_Software_SignByfly_20080120"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 2B 00 00 00 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 24 EB 02 ?? ?? 33 C0 EB 02 ?? ?? C3 EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 01 ?? EB 01 ?? 58 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 02 ?? ?? E8 }
        $b = { EB 02 ?? ?? E8 2B 00 00 00 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 24 EB 02 ?? ?? 33 C0 EB 02 ?? ?? C3 EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 04 ?? ?? ?? ?? EB 04 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Winkript_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Winkript_v10"
        weight = 1
    strings:
        $a = { 33 C0 8B B8 00 ?? ?? ?? 8B 90 04 ?? ?? ?? 85 FF 74 1B 33 C9 50 EB 0C 8A 04 39 C0 C8 04 34 1B 88 04 39 41 3B CA 72 F0 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule USERNAME_v300: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID USERNAME_v300"
        weight = 1
    strings:
        $a = { FB 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 8C C8 2B C1 8B C8 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 33 C0 8E D8 06 0E 07 FC 33 F6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_SHiELD_02: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_SHiELD_02"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 41 4E 41 4B 49 4E 5D 83 ED 06 EB 02 EA 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule InterLok_V5X_PACE_Anti_Piracy_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID InterLok_V5X_PACE_Anti_Piracy_SignByfly"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC A4 00 00 00 53 56 33 F6 57 39 35 ?? ?? ?? ?? 75 53 8D 45 DC 6A 1C 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 05 8B 45 E0 EB 22 8B 7D 08 6A 02 57 FF 15 ?? ?? ?? ?? 85 C0 75 0B 66 81 3F 4D 5A 75 04 8B C7 EB 07 56 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 48 3C 03 C8 89 ?? ?? ?? ?? ?? EB 06 8B ?? ?? ?? ?? ?? 66 8B 59 16 C1 EB 0D 83 E3 01 74 0A 83 7D 0C 01 0F 85 38 01 00 00 8D 45 F8 50 8D 45 FC 50 E8 47 01 00 00 8B F8 59 3B FE 59 75 52 83 7D FC FF FF 75 F8 75 17 8D 85 5C FF FF FF 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 0C EB 18 FF 75 FC 8D 85 5C FF FF FF 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 10 6A 30 8D 85 5C FF FF FF 68 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? E9 BB 00 00 00 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 57 FF D7 57 6A 01 8B F0 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 F6 0F 84 96 00 00 00 83 FE F6 7F 32 74 29 83 FE 97 74 75 83 FE F3 74 18 83 FE F4 74 0C 83 FE F5 75 2B B8 ?? ?? ?? ?? EB 4F B8 ?? ?? ?? ?? EB 48 B8 ?? ?? ?? ?? EB 41 B8 ?? ?? ?? ?? EB 3A 83 FE FA 74 30 83 FE FC 74 24 83 FE FD 74 18 56 8D 45 E0 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 0C 8D 45 E0 EB 13 B8 ?? ?? ?? ?? EB 0C B8 ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? 6A 30 68 ?? ?? ?? ?? 50 6A 00 FF 15 ?? ?? ?? ?? 85 DB 75 08 6A 01 FF 15 ?? ?? ?? ?? 33 C0 5F 5E 5B C9 C2 0C 00 }
        $b = { 55 8B EC 81 EC A4 00 00 00 53 56 33 F6 57 39 35 ?? ?? ?? ?? 75 53 8D 45 DC 6A 1C 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 05 8B 45 E0 EB 22 8B 7D 08 6A 02 57 FF 15 ?? ?? ?? ?? 85 C0 75 0B 66 81 3F 4D 5A 75 04 8B C7 EB 07 56 FF 15 ?? ?? ?? ?? A3 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_01_JDPack_1x_JDProtect_09: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_JDPack_1x_JDProtect_09"
        weight = 1
    strings:
        $a = { 60 E8 22 00 00 00 5D 8B D5 81 ED 90 90 90 90 2B 95 90 90 90 90 81 EA 06 90 90 90 89 95 90 90 90 90 83 BD 45 00 01 00 01 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Sentinel_SuperPro_Automatic_Protection_v640_Safenet: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Sentinel_SuperPro_Automatic_Protection_v640_Safenet"
        weight = 1
    strings:
        $a = { A1 ?? ?? ?? ?? 55 8B ?? ?? ?? 85 C0 74 ?? 85 ED 75 ?? A1 ?? ?? ?? ?? 50 55 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 55 51 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 6A 00 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 01 00 00 00 5D C2 0C 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule The_Norton_Antivirus_Information_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID The_Norton_Antivirus_Information_file"
        weight = 1
    strings:
        $a = { 54 68 65 20 4E 6F 72 74 6F 6E 20 41 6E 74 69 56 69 72 75 73 20 49 6E 66 6F 72 6D 61 74 69 6F 6E 20 46 69 6C 65 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Soft_Defender_v112: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Soft_Defender_v112"
        weight = 1
    strings:
        $a = { 74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD 00 59 9C 50 74 0A 75 08 E8 59 C2 04 00 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 BE 01 00 00 03 C8 74 BD 75 BB E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1311_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1311_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 25 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 23 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 01 ?? 33 C0 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Dropper_Creator_V01_Conflict: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Dropper_Creator_V01_Conflict"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 8D 05 ?? ?? ?? ?? 29 C5 8D 85 ?? ?? ?? ?? 31 C0 64 03 40 30 78 0C 8B 40 0C 8B 70 1C AD 8B 40 08 EB 09 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreePascal_200_Win32_Berczi_Gabor_Pierre_Muller_Peter_Vreman: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreePascal_200_Win32_Berczi_Gabor_Pierre_Muller_Peter_Vreman"
        weight = 1
    strings:
        $a = { 55 89 E5 C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? 6A 00 64 FF 35 00 00 00 00 89 E0 A3 ?? ?? ?? ?? 55 31 ED 89 E0 A3 ?? ?? ?? ?? 66 8C D5 89 2D ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 ED E8 ?? ?? ?? ?? 5D E8 ?? ?? ?? ?? C9 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WWPACK_v302_v302a_Extractable: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WWPACK_v302_v302a_Extractable"
        weight = 1
    strings:
        $a = { B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 33 C9 B1 ?? 51 06 06 BB ?? ?? 53 8C D3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeCryptor_01_build_001_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeCryptor_01_build_001_GlOFF"
        weight = 1
    strings:
        $a = { 8B 04 24 40 90 83 C0 07 80 38 90 90 74 02 EB FF 68 26 ?? ?? 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 FF E4 90 8B 04 24 64 A3 00 00 00 00 8B 64 24 08 90 83 C4 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Real_Networks_VideoAudio_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Real_Networks_VideoAudio_file"
        weight = 1
    strings:
        $a = { 2E 52 4D 46 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NTkrnl_Secure_Suite_NTkrnl_team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NTkrnl_Secure_Suite_NTkrnl_team"
        weight = 1
    strings:
        $a = { 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v50_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v50_DLL"
        weight = 1
    strings:
        $a = { ?? ?? 24 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? 8B ?? 24 0C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PcShare_v40_: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PcShare_v40_"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 90 34 40 00 68 B6 28 40 00 64 A1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LCC_Win32_v1x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LCC_Win32_v1x"
        weight = 1
    strings:
        $a = { 64 A1 ?? ?? ?? ?? 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 ?? 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AntiVirus_Vaccine_v103: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiVirus_Vaccine_v103"
        weight = 1
    strings:
        $a = { FA 33 DB B9 ?? ?? 0E 1F 33 F6 FC AD 35 ?? ?? 03 D8 E2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule KBys_Packer_028_Beta_Shoooo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID KBys_Packer_028_Beta_Shoooo"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5E 83 EE 0A 8B 06 03 C2 8B 08 89 4E F3 83 EE 0F 56 52 8B F0 AD AD 03 C2 8B D8 6A 04 BF 00 10 00 00 57 57 6A 00 FF 53 08 5A 59 BD 00 80 00 00 55 6A 00 50 51 52 50 89 06 AD AD 03 C2 50 AD 03 C2 FF D0 6A 04 57 AD 50 6A 00 FF 53 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_SKE_21x_dll_Alexey_Solodovnikov_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_SKE_21x_dll_Alexey_Solodovnikov_h"
        weight = 1
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v212: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v212"
        weight = 1
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_500_Dll_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_500_Dll_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 83 7C 24 08 01 75 05 E8 DE 4B 00 00 FF 74 24 04 8B 4C 24 10 8B 54 24 0C E8 ED FE FF FF 59 C2 0C 00 6A 0C 68 ?? ?? ?? ?? E8 E5 24 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 8F 15 00 00 C7 00 0C 00 00 00 57 57 57 57 57 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v211: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v211"
        weight = 1
    strings:
        $a = { 60 E9 3D 04 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_Macromedia_Flash_Projector_60: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Macromedia_Flash_Projector_60"
        weight = 1
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 83 EC 44 56 FF 15 24 81 49 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pack_Master_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pack_Master_v10"
        weight = 1
    strings:
        $a = { 60 E8 01 ?? ?? ?? E8 83 C4 04 E8 01 ?? ?? ?? E9 5D 81 ED D3 22 40 ?? E8 04 02 ?? ?? E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Neolite_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Neolite_v20"
        weight = 1
    strings:
        $a = { E9 A6 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WWPACK_v303: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WWPACK_v303"
        weight = 1
    strings:
        $a = { B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 BB ?? ?? 53 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MEW_11_SE_v10_Northfox: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MEW_11_SE_v10_Northfox"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? 00 00 00 02 00 00 00 0C ?0 }
        $b = { E9 ?? ?? ?? FF 0C ?? 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 0C ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Crypto_Lock_V202_Eng_Ryan_Thian: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Crypto_Lock_V202_Eng_Ryan_Thian"
        weight = 1
    strings:
        $a = { 60 BE 15 90 40 00 8D BE EB 7F FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Stirling_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Stirling_Archive"
        weight = 1
    strings:
        $a = { 13 5D 65 8C 3A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NTPacker_V2X_ErazerZ: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NTPacker_V2X_ErazerZ"
        weight = 1
    strings:
        $a = { 4B 57 69 6E 64 6F 77 73 00 10 55 54 79 70 65 73 00 00 3F 75 6E 74 4D 61 69 6E 46 75 6E 63 74 69 6F 6E 73 00 00 47 75 6E 74 42 79 70 61 73 73 00 00 B7 61 50 4C 69 62 75 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_v1300_Obsidium_Software_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_v1300_Obsidium_Software_h"
        weight = 1
    strings:
        $a = { EB 03 CD 20 EB EB 01 EB 1E EB 01 EB EB 02 CD 20 9C EB 03 CD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Norton_Speed_Disk_Configuration_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Norton_Speed_Disk_Configuration_file"
        weight = 1
    strings:
        $a = { 4E 6F 72 74 6F 6E 20 53 70 65 65 64 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPXHiT_v001: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPXHiT_v001"
        weight = 1
    strings:
        $a = { 94 BC ?? ?? ?? 00 B9 ?? 00 00 00 80 34 0C ?? E2 FA 94 FF E0 61 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ass_crypter_by_santasdad: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ass_crypter_by_santasdad"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 EC 53 ?? ?? ?? ?? 89 45 EC B8 98 40 00 10 E8 AC EA FF FF 33 C0 55 68 78 51 00 10 64 ?? ?? ?? ?? 20 6A 0A 68 88 51 00 10 A1 E0 97 00 10 50 E8 D8 EA FF FF 8B D8 53 A1 E0 97 00 10 50 E8 12 EB FF FF 8B F8 53 A1 E0 97 00 10 50 E8 DC EA FF FF 8B D8 53 E8 DC EA FF FF 8B F0 85 F6 74 26 8B D7 4A B8 F0 97 00 10 E8 C9 E7 FF FF B8 F0 97 00 10 E8 B7 E7 FF FF 8B CF 8B D6 E8 EE EA FF FF 53 E8 98 EA FF FF 8D 4D EC BA 9C 51 00 10 A1 F0 97 00 10 E8 22 EB FF FF 8B 55 EC B8 F0 97 00 10 E8 89 E6 FF FF B8 F0 97 00 10 E8 7F E7 FF FF E8 6E EC FF FF 33 C0 5A 59 59 64 89 10 68 7F 51 00 10 8D 45 EC E8 11 E6 FF FF C3 E9 FF DF FF FF EB F0 5F 5E 5B E8 0D E5 FF FF 00 53 45 54 54 49 4E 47 53 00 00 00 00 FF FF FF FF 1C 00 00 00 45 4E 54 45 52 20 59 4F 55 52 20 4F 57 4E 20 50 41 53 53 57 4F 52 44 20 48 45 52 45 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NoodleCrypt_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NoodleCrypt_v20"
        weight = 1
    strings:
        $a = { EB 01 9A E8 3D 00 00 00 EB 01 9A E8 EB 01 00 00 EB 01 9A E8 2C 04 00 00 EB 01 }
        $b = { EB 01 9A E8 ?? 00 00 00 EB 01 9A E8 ?? ?? 00 00 EB 01 9A E8 ?? ?? 00 00 EB 01 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Upack_Upack_030_032_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_Upack_030_032_beta_Dwing"
        weight = 1
    strings:
        $a = { 8A 07 47 04 18 3C 02 73 F7 8B 07 3C ?? 75 F1 B0 00 0F C8 03 46 1C 2B C7 AB E2 E5 8B 5E 34 8B 76 38 46 AD ?? C0 0F 84 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Wicat_GED_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Wicat_GED_Graphics_format"
        weight = 1
    strings:
        $a = { 0D 00 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Scitech_Software_Display_Driver: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Scitech_Software_Display_Driver"
        weight = 1
    strings:
        $a = { 56 42 45 41 46 2E 44 52 56 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v2xx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v2xx"
        weight = 1
    strings:
        $a = { A8 03 00 00 61 75 08 B8 01 00 00 00 C2 0C 00 68 00 00 00 00 C3 8B 85 26 04 00 00 8D 8D 3B 04 00 00 51 50 FF 95 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SVK_Protector_v132_Eng_Pavol_Cerven: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SVK_Protector_v132_Eng_Pavol_Cerven"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 0C 61 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 18 61 00 00 5D 6A FF FF 95 10 61 00 00 44 65 62 75 67 67 65 72 20 6F 72 20 74 6F 6F 6C 20 66 6F 72 20 6D 6F 6E 69 74 6F 72 69 6E 67 20 64 65 74 65 63 74 65 64 21 21 21 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 ?? ?? 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule BamBam_001: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BamBam_001"
        weight = 1
    strings:
        $a = { 6A 14 E8 9A 05 00 00 8B D8 53 68 FB ?? ?? 00 E8 6C FD FF FF B9 05 00 00 00 8B F3 BF FB ?? ?? 00 53 F3 A5 E8 8D 05 00 00 8B 3D 03 ?? ?? 00 A1 2B ?? ?? 00 66 8B 15 2F ?? ?? 00 B9 80 ?? ?? 00 2B CF 89 45 E8 89 0D 6B ?? ?? 00 66 89 55 EC 8B 41 3C 33 D2 03 C1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_ExeSmasher: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_ExeSmasher"
        weight = 1
    strings:
        $a = { 9C FE 03 90 60 BE 90 90 41 90 8D BE 90 10 FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FE 0B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SDProtector_BasicPro_Edition_110_Randy_Li: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SDProtector_BasicPro_Edition_110_Randy_Li"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 50 83 EC 08 64 A1 00 00 00 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 83 C4 08 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 64 8F 05 00 00 00 00 64 A3 00 00 00 00 83 C4 08 58 74 07 75 05 19 32 67 E8 E8 74 27 75 25 EB 00 EB FC 68 39 44 CD 00 59 9C 50 74 0F 75 0D E8 59 C2 04 00 55 8B EC E9 FA FF FF 0E E8 EF FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 59 03 00 00 03 C8 74 B8 75 B6 E8 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_50: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_50"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Hyings_PE_Armor_075exe_Hying_CCG_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Hyings_PE_Armor_075exe_Hying_CCG_h"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 42 6F 47 5F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Alex_Protector_04_beta_1_by_Alex: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Alex_Protector_04_beta_1_by_Alex"
        weight = 1
    strings:
        $a = { 60 E8 01 00 00 00 C7 83 C4 04 33 C9 E8 01 00 00 00 68 83 C4 04 E8 01 00 00 00 68 83 C4 04 B9 ?? 00 00 00 E8 01 00 00 00 68 83 C4 04 E8 00 00 00 00 E8 01 00 00 00 C7 83 C4 04 8B 2C 24 83 C4 04 E8 01 00 00 00 A9 83 C4 04 81 ED 3C 13 40 00 E8 01 00 00 00 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPolyX_03_by_delikon: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPolyX_03_by_delikon"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? 8B ?? B9 ?? ?? ?? ?? 80 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressor_V1451_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_V1451_CGSoftLabs"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC ?? 53 56 57 83 65 ?? 00 F3 EB 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_50p_MFC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Microsoft_Visual_Cpp_50p_MFC"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_ASPack_2xx_Heuristic: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_ASPack_2xx_Heuristic"
        weight = 1
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 A8 03 00 00 61 75 08 B8 01 00 00 00 C2 0C 00 68 00 00 00 00 C3 8B 85 26 04 00 00 8D 8D 3B 04 00 00 51 50 FF 95 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_FORTRAN_Library_19: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_FORTRAN_Library_19"
        weight = 1
    strings:
        $a = { FC 1E B8 ?? ?? 8E D8 9A ?? ?? ?? ?? 81 ?? ?? ?? 8B EC 8C DB 8E C3 BB ?? ?? 9A ?? ?? ?? ?? 9B DB E3 9B D9 2E ?? ?? 33 C9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PeCompact_253_DLL_BitSum_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PeCompact_253_DLL_BitSum_Technologies"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_102_103_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_102_103_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 }
        $b = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ThemidaWinLicense_V1802_p_Oreans_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ThemidaWinLicense_V1802_p_Oreans_Technologies"
        weight = 1
    strings:
        $a = { B8 00 00 00 00 60 0B C0 74 68 E8 00 00 00 00 58 05 ?? 00 00 00 80 38 E9 75 ?? 61 EB ?? DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D 40 E8 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_16d_by_Vaska_UsAr_sign_21032007_2222: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_16d_by_Vaska_UsAr_sign_21032007_2222"
        weight = 1
    strings:
        $a = { 8B C7 03 04 24 2B C7 80 38 50 0F 85 1B 8B 1F FF 68 40 A1 14 13 B8 00 10 14 13 3D 24 C0 14 13 74 06 80 30 F2 40 EB F3 B8 8C 20 18 13 3D B9 27 18 13 74 06 80 30 E8 40 EB F3 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DWC_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DWC_Archive"
        weight = 1
    strings:
        $a = { 44 57 43 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Adys_Glue_110: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Adys_Glue_110"
        weight = 1
    strings:
        $a = { 2E ?? ?? ?? ?? 0E 1F BF ?? ?? 33 DB 33 C0 AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Encrypted_by_RSCC286_v101: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Encrypted_by_RSCC286_v101"
        weight = 1
    strings:
        $a = { FE 52 53 43 43 2F 31 2E 30 31 FE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Encrypted_by_RSCC286_v102: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Encrypted_by_RSCC286_v102"
        weight = 1
    strings:
        $a = { FE 52 53 43 43 2F 31 2E 30 32 FE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule IMP_Packer_10_Mahdi_Hezavehi_IMPOSTER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID IMP_Packer_10_Mahdi_Hezavehi_IMPOSTER"
        weight = 1
    strings:
        $a = { 28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 }
        $b = { 28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ExeShield_Protector_36_wwwexeshieldcom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeShield_Protector_36_wwwexeshieldcom"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 CE 1E 42 AF F8 D6 CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Goats_PE_Mutilator_16: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Goats_PE_Mutilator_16"
        weight = 1
    strings:
        $a = { E8 EA 0B 00 00 ?? ?? ?? 8B 1C 79 F6 63 D8 8D 22 B0 BF F6 49 08 C3 02 BD 3B 6C 29 46 13 28 5D 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0F 53 0F DE 0F 55 0F 60 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SDProtector_Pro_Edition_116_Randy_Li: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SDProtector_Pro_Edition_116_Randy_Li"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 18 33 C0 89 41 04 89 41 08 89 41 0C 89 41 10 59 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 33 C0 64 FF 30 64 89 20 9C 80 4C 24 01 01 9D 90 90 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 64 8F 00 58 74 07 75 05 19 32 67 E8 E8 74 27 75 25 EB 00 EB FC 68 39 44 CD 00 59 9C 50 74 0F 75 0D E8 59 C2 04 00 55 8B EC E9 FA FF FF 0E E8 EF FF FF FF 56 57 53 78 03 79 01 E8 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 93 03 00 00 03 C8 74 C4 75 C2 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nBinder_v40: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nBinder_v40"
        weight = 1
    strings:
        $a = { 5C 6E 62 34 5F 74 6D 70 5F 30 31 33 32 34 35 34 33 35 30 5C 00 00 00 00 00 00 00 00 00 E9 55 43 4C FF 01 1A 00 00 00 00 96 30 07 77 2C 61 0E EE BA 51 09 99 19 C4 6D 07 8F F4 6A 70 35 A5 63 E9 A3 95 64 9E 32 88 DB 0E A4 B8 DC 79 }
        $b = { 5C 6E 6D 72 5F 74 65 6D 70 2E 6E 6D 72 00 00 00 72 62 00 00 58 C7 41 00 10 F8 41 00 11 01 00 00 00 00 00 00 46 E1 00 00 46 E1 00 00 35 00 00 00 F6 88 41 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Exe_Shield_v27b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Exe_Shield_v27b"
        weight = 1
    strings:
        $a = { 03 DE EB 01 F8 B8 80 ?? 42 00 EB 02 CD 20 68 17 A0 B3 AB EB 01 E8 59 0F B6 DB 68 0B A1 B3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_3X_5X_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_3X_5X_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule GZIP_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID GZIP_Archive"
        weight = 1
    strings:
        $a = { 1F 8B 08 08 ?? ?? ?? 35 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_Alternative_stub: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_Alternative_stub"
        weight = 1
    strings:
        $a = { B9 ?? ?? BE ?? ?? BF C0 FF FD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Windows_PIF_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Windows_PIF_file"
        weight = 1
    strings:
        $a = { 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 80 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LY_WGKX_V2X_wwwszleyucom_SignByfly_20080122: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LY_WGKX_V2X_wwwszleyucom_SignByfly_20080122"
        weight = 1
    strings:
        $a = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C 59 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 01 00 4D 79 46 75 6E 00 62 73 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeHand_8_document: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeHand_8_document"
        weight = 1
    strings:
        $a = { 41 47 44 33 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v092a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v092a"
        weight = 1
    strings:
        $a = { E9 7E E9 FF FF 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_FSG_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_FSG_10"
        weight = 1
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 BB D0 01 40 00 BF 00 10 40 00 BE 90 90 90 90 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PCIENC_Cryptor: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PCIENC_Cryptor"
        weight = 1
    strings:
        $a = { 06 50 43 49 45 4E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EmbedPE_113_cyclotron: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EmbedPE_113_cyclotron"
        weight = 1
    strings:
        $a = { 83 EC 50 60 68 5D B9 52 5A E8 2F 99 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v123b3_v1241: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v123b3_v1241"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 A6 70 40 ?? 01 85 03 70 40 ?? 66 C7 85 70 40 90 ?? 90 01 85 9E 70 40 BB ?? D2 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule IProtect_10_FxSubdll_mode_by_FuXdas: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID IProtect_10_FxSubdll_mode_by_FuXdas"
        weight = 1
    strings:
        $a = { EB 33 2E 46 55 58 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 46 78 53 75 62 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 60 E8 00 00 00 00 5D 81 ED B6 13 40 00 FF 74 24 20 E8 40 00 00 00 0B C0 74 2F 89 85 A8 13 40 00 8D 85 81 13 40 00 50 FF B5 A8 13 40 00 E8 92 00 00 00 0B C0 74 13 89 85 A4 13 40 00 8D 85 8E 13 40 00 50 FF 95 A4 13 40 00 8B 85 AC 13 40 00 89 44 24 1C 61 FF E0 8B 7C 24 04 8D 85 00 10 40 00 50 64 FF 35 00 00 00 00 8D 85 98 13 40 00 89 20 89 68 04 8D 9D 4F 14 40 00 89 58 08 64 89 25 00 00 00 00 81 E7 00 00 FF FF 66 81 3F 4D 5A 75 0F 8B F7 03 76 3C 81 3E 50 45 00 00 75 02 EB 17 81 EF 00 00 01 00 81 FF 00 00 00 70 73 07 BF 00 00 F7 BF EB 02 EB D3 97 64 8F 05 00 00 00 00 83 C4 04 C2 04 00 8D 85 00 10 40 00 50 64 FF 35 00 00 00 00 8D 85 98 13 40 00 89 20 89 68 04 8D 9D 4F 14 40 00 89 58 08 64 89 25 00 00 00 00 8B 74 24 0C 66 81 3E 4D 5A 74 05 E9 8A 00 00 00 03 76 3C 81 3E 50 45 00 00 74 02 EB 7D 8B 7C 24 10 B9 96 00 00 00 32 C0 F2 AE 8B CF 2B 4C 24 10 8B 56 78 03 54 24 0C 8B 5A 20 03 5C 24 0C 33 C0 8B 3B 03 7C 24 0C 8B 74 24 10 51 F3 A6 75 05 83 C4 04 EB 0A 59 83 C3 04 40 3B 42 18 75 E2 3B 42 18 75 02 EB 35 8B 72 24 03 74 24 0C 52 BB 02 00 00 00 33 D2 F7 E3 5A 03 C6 33 C9 66 8B 08 8B 7A 1C 33 D2 BB 04 00 00 00 8B C1 F7 E3 03 44 24 0C 03 C7 8B 00 03 44 24 0C EB 02 33 C0 64 8F 05 00 00 00 00 83 C4 04 C2 08 00 E8 B5 FA FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Windows_Type_1_font_metric_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Windows_Type_1_font_metric_file"
        weight = 1
    strings:
        $a = { 00 01 ?? ?? 00 00 43 6F 70 79 72 69 67 68 74 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SLVc0deProtector_v11_SLV_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SLVc0deProtector_v11_SLV_h"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED 94 73 42 00 8B D5 81 C2 E3 73 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_WATCOM_CCpp_EXE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_WATCOM_CCpp_EXE"
        weight = 1
    strings:
        $a = { E9 00 00 00 00 90 90 90 90 57 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TMT_Pascals_Unit_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TMT_Pascals_Unit_file"
        weight = 1
    strings:
        $a = { 50 00 00 00 53 50 46 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_WATCOM_CCpp_EXE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_WATCOM_CCpp_EXE"
        weight = 1
    strings:
        $a = { E9 00 00 00 00 90 90 90 90 57 41 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_300a_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_300a_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 33 FF 47 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 EB 87 ?? 7A F0 ?? ?? 61 8B 9C BD 26 42 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_Joiner_sign_from_pinch_26032007_0212: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_Joiner_sign_from_pinch_26032007_0212"
        weight = 1
    strings:
        $a = { 44 90 4C 90 B9 DE 00 00 00 BA 00 10 40 00 83 C2 03 44 90 4C B9 07 00 00 00 44 90 4C 33 C9 C7 05 08 30 40 00 00 00 00 00 90 68 00 01 00 00 68 21 30 40 00 6A 00 E8 C5 02 00 00 90 6A 00 68 80 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TIFF_Graphics_file_Macintosh: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TIFF_Graphics_file_Macintosh"
        weight = 1
    strings:
        $a = { 4D 4D 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1342_Obsidium_Softwarenbsp_nbsp_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1342_Obsidium_Softwarenbsp_nbsp_SignByfly"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 2C 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 27 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ZCode_Win32PE_Protector_v101: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ZCode_Win32PE_Protector_v101"
        weight = 1
    strings:
        $a = { 25 ?? ?? ?? ?? 61 87 CC 55 45 45 55 81 ED CA 00 00 00 55 A4 B3 02 FF 14 24 73 F8 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 1F B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3C AA EB DC FF 54 24 04 2B CB 75 0F FF 54 24 08 EB 27 AC D1 E8 74 30 13 C9 EB 1B 91 48 C1 E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_010_012_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_010_012_beta_Dwing"
        weight = 1
    strings:
        $a = { BE 48 01 40 00 AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB AD 50 97 51 AD 87 F5 58 8D 54 86 5C FF D5 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Cracked_by_AutoHack_1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Cracked_by_AutoHack_1"
        weight = 1
    strings:
        $a = { FA 50 51 57 56 1E 06 2E 80 3E ?? ?? ?? 74 ?? 8E 06 ?? ?? 2B FF FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v098: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v098"
        weight = 1
    strings:
        $a = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? 1E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Petite_21: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Petite_21"
        weight = 1
    strings:
        $a = { 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 8B D8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule StarForce_V1X_V3X_StarForce_Copy_Protection_System: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID StarForce_V1X_V3X_StarForce_Copy_Protection_System"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CodeCrypt_v016b_v0163b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CodeCrypt_v016b_v0163b"
        weight = 1
    strings:
        $a = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 75 73 65 72 33 32 2E 64 6C 6C 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 00 00 00 00 00 00 00 00 00 00 00 08 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WWPACK_v305c4_Extractable: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WWPACK_v305c4_Extractable"
        weight = 1
    strings:
        $a = { 03 05 00 1A B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_239_minimum_protection: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_239_minimum_protection"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? E9 ?? ?? ?? FF 50 C1 C8 18 89 05 ?? ?? ?? ?? C3 C1 C0 18 51 E9 ?? ?? ?? FF 84 C0 0F 84 6A F9 FF FF E9 ?? ?? ?? FF C3 E9 ?? ?? ?? FF E8 CF E9 FF FF B8 01 00 00 00 E9 ?? ?? ?? FF 2B D0 68 A0 36 80 D4 59 81 C9 64 98 FF 99 E9 ?? ?? ?? FF 84 C0 0F 84 8E EC FF FF E9 ?? ?? ?? FF C3 87 3C 24 5F 8B 00 03 45 FC 83 C0 18 E9 ?? ?? ?? FF 87 0C 24 59 B8 01 00 00 00 D3 E0 23 D0 E9 02 18 00 00 0F 8D DB 00 00 00 C1 E8 14 E9 CA 00 00 00 9D 87 0C 24 59 87 1C 24 68 AE 73 B9 96 E9 C5 10 00 00 0F 8A ?? ?? ?? ?? E9 ?? ?? ?? FF 81 FD F5 FF 8F 07 E9 4F 10 00 00 C3 E9 5E 12 00 00 87 3C 24 E9 ?? ?? ?? FF E8 ?? ?? ?? FF 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 55 EC B8 ?? ?? ?? ?? E9 ?? ?? ?? FF E8 A7 1A 00 00 E8 2A CB FF FF E9 ?? ?? ?? FF C3 E9 ?? ?? ?? FF 59 89 45 E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SecurePE_1X: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SecurePE_1X"
        weight = 1
    strings:
        $a = { 8B 04 24 E8 00 00 00 00 5D 81 ED 4C 2F 40 00 89 85 61 2F 40 00 8D 9D 65 2F 40 00 53 C3 00 00 00 00 8D B5 BA 2F 40 00 8B FE BB 65 2F 40 00 B9 C6 01 00 00 AD 2B C3 C1 C0 03 33 C3 AB 43 81 FB 8E 2F 40 00 75 05 BB 65 2F 40 00 E2 E7 89 AD 1A 31 40 00 89 AD 55 34 40 00 89 AD 68 34 40 00 8D 85 BA 2F 40 00 50 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Hide_PE_101_BGCorp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Hide_PE_101_BGCorp"
        weight = 1
    strings:
        $a = { ?? BA ?? ?? ?? 00 B8 ?? ?? ?? ?? 89 02 83 C2 04 B8 ?? ?? ?? ?? 89 02 83 C2 04 B8 ?? ?? ?? ?? 89 02 83 C2 F8 FF E2 0D 0A 2D 3D 5B 20 48 69 64 65 50 45 20 62 79 20 42 47 43 6F 72 70 20 5D 3D 2D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_Patch_or_any_Version_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_Patch_or_any_Version_Dwing"
        weight = 1
    strings:
        $a = { 60 E8 09 00 00 00 ?? ?? ?? 00 E9 06 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Setup_Factory_6x_Custom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Setup_Factory_6x_Custom"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? 61 40 00 68 ?? 43 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? 61 40 00 33 D2 8A D4 89 15 A0 A9 40 00 8B C8 81 E1 FF 00 00 00 89 0D }
        $b = { 55 8B EC 6A FF 68 90 61 40 00 68 70 3B 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 14 61 40 00 33 D2 8A D4 89 15 5C 89 40 00 8B C8 81 E1 FF 00 00 00 89 0D 58 89 40 00 C1 E1 08 03 CA 89 0D 54 89 40 00 C1 E8 10 A3 50 89 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Upack_V020_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V020_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A ?? ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 ?? ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 01 67 E3 29 8B D7 2B 55 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 56 08 33 C9 E9 07 01 00 00 8B 5D 0C 83 C2 30 FF 16 73 53 83 C2 30 FF 16 72 1B 83 C2 30 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 45 0C B1 80 8A 00 EB CF 83 C2 60 FF 16 87 5D 10 73 0D 83 C2 30 FF 16 87 5D 14 73 03 87 5D 18 3C 07 B0 08 72 02 B0 0B 50 53 8D 95 7C 07 00 00 FF 56 0C 5B 91 E9 9C 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Anti007_V25_V26_LiuXingPing_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Anti007_V25_V26_LiuXingPing_SignByfly"
        weight = 1
    strings:
        $a = { 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 53 79 73 74 65 6D 44 69 72 65 63 74 6F 72 79 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 57 72 69 74 65 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_131_Eng_dulekxt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_131_Eng_dulekxt"
        weight = 1
    strings:
        $a = { C1 E0 06 EB 02 CD 20 EB 01 27 EB 01 24 BE 80 ?? 42 00 49 EB 01 99 8D 1D F4 00 00 00 EB 01 5C F7 D8 1B CA EB 01 31 8A 16 80 E9 41 EB 01 C2 C1 E0 0A EB 01 A1 81 EA A8 8C 18 A1 34 46 E8 01 00 00 00 62 59 32 D3 C1 C9 02 EB 01 68 80 F2 1A 0F BE C9 F7 D1 2A D3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MarjinZ_EXE_Scrambler_SE_by_MarjinZ: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MarjinZ_EXE_Scrambler_SE_by_MarjinZ"
        weight = 1
    strings:
        $a = { E8 A3 02 00 00 E9 35 FD FF FF FF 25 C8 20 00 10 6A 14 68 C0 21 00 10 E8 E4 01 00 00 FF 35 7C 33 00 10 8B 35 8C 20 00 10 FF D6 59 89 45 E4 83 F8 FF 75 0C FF 75 08 FF 15 88 20 00 10 59 EB 61 6A 08 E8 02 03 00 00 59 83 65 FC 00 FF 35 7C 33 00 10 FF D6 89 45 E4 FF 35 78 33 00 10 FF D6 89 45 E0 8D 45 E0 50 8D 45 E4 50 FF 75 08 E8 D1 02 00 00 89 45 DC FF 75 E4 8B 35 74 20 00 10 FF D6 A3 7C 33 00 10 FF 75 E0 FF D6 83 C4 1C A3 78 33 00 10 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 DC E8 A0 01 00 00 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pksmart_10b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pksmart_10b"
        weight = 1
    strings:
        $a = { BA ?? ?? 8C C8 8B C8 03 C2 81 ?? ?? ?? 51 B9 ?? ?? 51 1E 8C D3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TheHypers_protector_TheHyper_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TheHypers_protector_TheHyper_h"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC 14 8B FC E8 14 00 00 00 ?? ?? 01 01 ?? ?? 01 01 ?? ?? ?? 00 ?? ?? 01 01 ?? ?? 02 01 5E E8 0D 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8B 46 04 FF 10 8B D8 E8 0D 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 07 E8 0C 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 53 8B 06 FF 10 89 47 04 E8 0F 00 00 00 47 65 74 50 72 6F 63 65 73 73 48 65 61 70 00 53 8B 06 FF 10 89 47 08 E8 0A 00 00 00 48 65 61 70 41 6C 6C 6F 63 00 53 8B 06 FF 10 89 47 0C E8 09 00 00 00 48 65 61 70 46 72 65 65 00 53 8B 06 FF 10 89 47 10 57 FF 76 08 FF 76 0C FF 56 10 8B E5 5D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule X_Pack_v142: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID X_Pack_v142"
        weight = 1
    strings:
        $a = { 72 ?? C3 8B DE 83 ?? ?? C1 ?? ?? 8C D8 03 C3 8E D8 8B DF 83 ?? ?? C1 ?? ?? 8C C0 03 C3 8E C0 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_Modified_Stub_c_Farb_rausch_Consumer_Consulting: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_Modified_Stub_c_Farb_rausch_Consumer_Consulting"
        weight = 1
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF FC B2 80 E8 00 00 00 00 5B 83 C3 66 A4 FF D3 73 FB 31 C9 FF D3 73 14 31 C0 FF D3 73 1D 41 B0 10 FF D3 10 C0 73 FA 75 3C AA EB E2 E8 4A 00 00 00 49 E2 10 E8 40 00 00 00 EB 28 AC D1 E8 74 45 11 C9 EB 1C 91 48 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPXLock_v11_CyberDoom_Bob: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPXLock_v11_CyberDoom_Bob"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? 00 60 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACProtect_v190g_Risco_software_Inc: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtect_v190g_Risco_software_Inc"
        weight = 1
    strings:
        $a = { 60 0F 87 02 00 00 00 1B F8 E8 01 00 00 00 73 83 04 24 06 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule JRC_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID JRC_Archive"
        weight = 1
    strings:
        $a = { 4A 52 63 68 69 76 65 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeTools_COM2EXE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeTools_COM2EXE"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5D 83 ED ?? 8C DA 2E 89 96 ?? ?? 83 C2 ?? 8E DA 8E C2 2E 01 96 ?? ?? 60 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BamBam_v001: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BamBam_v001"
        weight = 1
    strings:
        $a = { 6A 14 E8 9A 05 00 00 8B D8 53 68 FB ?? ?? 00 E8 6C FD FF FF B9 05 00 00 00 8B F3 BF FB ?? ?? 00 53 F3 A5 E8 8D 05 00 00 8B 3D 03 ?? ?? 00 A1 2B ?? ?? 00 66 8B 15 2F ?? ?? 00 B9 80 ?? ?? 00 2B CF 89 45 E8 89 0D 6B ?? ?? 00 66 89 55 EC 8B 41 3C 33 D2 03 C1 83 C4 10 66 8B 48 06 66 8B 50 14 81 E1 FF FF 00 00 8D 5C 02 18 8D 41 FF 85 C0 0F 8E 39 01 00 00 89 45 F0 C6 45 FF 00 8D 7D E8 8B F3 8A 0E 8A 17 8A C1 3A CA 75 1E 84 C0 74 16 8A 56 01 8A 4F 01 8A C2 3A D1 75 0E 83 C6 02 83 C7 02 84 C0 75 DC 33 C0 EB 05 1B C0 83 D8 FF 85 C0 75 04 C6 45 FF 01 8B 43 10 85 C0 0F 84 DD 00 00 00 8B 43 08 50 E8 D7 04 00 00 8A 4D FF 83 C4 04 84 C9 8B 4B 08 89 45 F8 C7 45 F4 00 00 00 00 74 61 8B 15 07 ?? ?? 00 8B 35 6B ?? ?? 00 8B 7B 0C 2B CA 03 F2 8B D1 03 F7 8B F8 C1 E9 02 F3 A5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule COMPACK_v45_2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID COMPACK_v45_2"
        weight = 1
    strings:
        $a = { BE ?? ?? E8 ?? ?? 5D 83 ?? ?? 55 50 53 51 52 0E 07 0E 1F 8B CE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V119_LZMA_430_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V119_LZMA_430_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76 01 00 00 EB 20 60 8B 85 49 0B 00 00 FF B5 41 0B 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD 55 0B 00 00 00 74 0E 83 BD 59 0B 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 DA 0A 00 00 89 85 69 0B 00 00 5B 60 FF B5 41 0B 00 00 56 FF B5 69 0B 00 00 FF D3 61 8B B5 69 0B 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 E9 98 00 00 00 56 FF 95 D2 0A 00 00 89 85 61 0B 00 00 85 C0 0F 84 C8 00 00 00 8B C6 EB 5F 8B 85 65 0B 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 65 0B 00 00 C7 00 20 20 20 00 EB 06 FF B5 65 0B 00 00 FF B5 61 0B 00 00 FF 95 D6 0A 00 00 85 C0 0F 84 87 00 00 00 89 07 83 C7 04 8B 85 65 0B 00 00 EB 01 40 80 38 00 75 FA 40 89 85 65 0B 00 00 66 81 78 02 00 80 74 A1 80 38 00 75 9C EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 80 3E 01 0F 85 5F FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 69 0B 00 00 FF 95 DE 0A 00 00 68 00 40 00 00 68 00 20 0C 00 FF B5 41 0B 00 00 FF 95 DE 0A 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AZProtect_0001_by_AlexZ_aka_AZCRC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AZProtect_0001_by_AlexZ_aka_AZCRC"
        weight = 1
    strings:
        $a = { EB 70 FC 60 8C 80 4D 11 00 70 25 81 00 40 0D 91 BB 60 8C 80 4D 11 00 70 21 81 1D 61 0D 81 00 40 CE 60 8C 80 4D 11 00 70 25 81 25 81 25 81 25 81 29 61 41 81 31 61 1D 61 00 40 B7 30 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 60 BE 00 ?? ?? 00 BF 00 00 40 00 EB 17 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 00 00 00 00 FF 25 ?? ?? ?? 00 8B C6 03 C7 8B F8 57 55 8B EC 05 7F 00 00 00 50 E8 E5 FF FF FF BA 8C ?? ?? 00 89 02 E9 1A 01 00 00 ?? 00 00 00 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 47 65 74 56 6F 6C 75 6D 65 49 6E 66 6F 72 6D 61 74 69 6F 6E 41 00 4D 65 73 73 61 67 65 42 6F 78 41 00 45 78 69 74 50 72 6F 63 65 73 73 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Blade_Joiner_v15: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Blade_Joiner_v15"
        weight = 1
    strings:
        $a = { 55 8B EC 81 C4 E4 FE FF FF 53 56 57 33 C0 89 45 F0 89 85 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v20"
        weight = 1
    strings:
        $a = { 87 25 ?? ?? ?? 00 61 94 55 A4 B6 80 FF 13 }
        $b = { 87 25 ?? ?? ?? ?? 61 94 55 A4 B6 80 FF 13 73 F9 33 C9 FF 13 73 16 33 C0 FF 13 73 1F B6 80 41 B0 10 FF 13 12 C0 73 FA 75 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule dUP2_diablo2oo2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID dUP2_diablo2oo2"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? A2 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 3C 01 75 19 BE ?? ?? ?? ?? 68 00 02 00 00 56 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_vxx_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_vxx_DLL"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Delphi_v10_Unit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Delphi_v10_Unit"
        weight = 1
    strings:
        $a = { 44 43 55 31 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEZip_v10_by_BaGIE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEZip_v10_by_BaGIE"
        weight = 1
    strings:
        $a = { D9 D0 F8 74 02 23 DB F5 F5 50 51 52 53 8D 44 24 10 50 55 56 57 D9 D0 22 C9 C1 F7 A0 55 66 C1 C8 B0 5D 81 E6 FF FF FF FF F8 77 07 52 76 03 72 01 90 5A C1 E0 60 90 BD 1F 01 00 00 87 E8 E2 07 E3 05 17 5D 47 E4 42 41 7F 06 50 66 83 EE 00 58 25 FF FF FF FF 51 0F B6 C9 66 83 F6 00 3D CB 60 47 92 50 40 58 FC E2 EE 59 F8 7C 08 53 74 04 78 02 84 C9 5B 66 0B ED F8 F5 BA 9F FA FF FF 52 57 77 04 78 02 84 E4 5F 5A 50 80 EF 00 58 50 81 E0 FF FF FF FF 58 3C EF FC 7A 05 3D DF DA AC D1 05 00 00 00 00 73 05 71 03 7E 01 90 EB 02 EB 05 E8 F9 FF FF FF 83 C0 00 7B 06 53 66 BB 74 EF 5B F8 8B 3C 24 83 C4 04 51 0F B6 C9 66 C1 C7 30 0B D2 53 66 83 FD F6 5B 55 6A 97 83 C4 04 5D E2 E8 59 53 55 51 66 83 E9 00 59 5D 5B F8 01 FA 22 C9 7A 02 8D 3F 79 08 71 06 52 66 A9 6E E3 5A 51 0F B6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PowerBASICWin_70x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PowerBASICWin_70x"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 ?? 40 00 66 2E F7 05 ?? ?? 40 00 04 00 0F 85 DB 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_R_Full_text_index_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_R_Full_text_index_file"
        weight = 1
    strings:
        $a = { 6C 6C 2D 74 65 78 74 20 69 6E 64 65 78 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Inno_Setup_Module_v109a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Inno_Setup_Module_v109a"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 C0 53 56 57 33 C0 89 45 F0 89 45 C4 89 45 C0 E8 A7 7F FF FF E8 FA 92 FF FF E8 F1 B3 FF FF 33 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Windows_9x_User_password_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Windows_9x_User_password_file"
        weight = 1
    strings:
        $a = { E3 82 85 96 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_Lockless_Intro_Pack: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Lockless_Intro_Pack"
        weight = 1
    strings:
        $a = { 2C E8 EB 1A 90 90 5D 8B C5 81 ED F6 73 90 90 2B 85 90 90 90 90 83 E8 06 89 85 FF 01 EC AD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unpacked_BS_SFX_Archive_v19: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unpacked_BS_SFX_Archive_v19"
        weight = 1
    strings:
        $a = { 1E 33 C0 50 B8 ?? ?? 8E D8 FA 8E D0 BC ?? ?? FB B8 ?? ?? CD 21 3C 03 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_v03_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_v03_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_v153: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_v153"
        weight = 1
    strings:
        $a = { E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 ?? ?? 00 31 C0 89 41 14 89 41 18 80 A1 C1 00 00 00 FE C3 31 C0 64 FF 30 64 89 20 CC C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HideProtect_V1016C_SoftWar_Company_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HideProtect_V1016C_SoftWar_Company_SignByfly"
        weight = 1
    strings:
        $a = { 90 90 90 E9 D8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ORiEN_V1X_V2X_Fisun_AV: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ORiEN_V1X_V2X_Fisun_AV"
        weight = 1
    strings:
        $a = { 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F 74 65 63 74 69 6F 6E 20 73 79 73 74 65 6D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ENIGMA_Protector_V10_V12_Sukhov_Vladimir: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ENIGMA_Protector_V10_V12_Sukhov_Vladimir"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ?? ?? 81 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Intro_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Intro_v10"
        weight = 1
    strings:
        $a = { 8A 16 02 00 8A 07 32 C2 88 07 43 FE C2 81 FB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH"
        weight = 1
    strings:
        $a = { 60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 }
        $b = { EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF 0F 00 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Themida_1920: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Themida_1920"
        weight = 1
    strings:
        $a = { BE ?? ?? BF ?? ?? B9 ?? ?? 56 FC F3 A5 5F E9 }
        $b = { 8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 89 B5 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? 00 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? ?? ?? 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25 4B 89 0A E8 D5 00 00 00 E9 14 02 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_02_ASProtect: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_ASProtect"
        weight = 1
    strings:
        $a = { 60 90 90 90 90 90 90 5D 90 90 90 90 90 90 90 90 90 90 90 03 DD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PENinja_modified: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PENinja_modified"
        weight = 1
    strings:
        $a = { 5D 83 ED 06 EB 02 EA 04 8D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEncrypt_10_JunkCode: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEncrypt_10_JunkCode"
        weight = 1
    strings:
        $a = { 60 9C BE 00 10 40 00 8B FE B9 ?? ?? ?? ?? BB 78 56 34 12 AD 33 C3 AB E2 FA 9D 61 E9 ?? ?? ?? FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V071_cyberbob: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V071_cyberbob"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_PE_Intro_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_PE_Intro_10"
        weight = 1
    strings:
        $a = { 8B 04 24 9C 60 E8 14 00 00 00 5D 81 ED 0A 45 40 90 80 BD 67 44 40 90 90 0F 85 48 FF ED 0A E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule theWRAP_by_TronDoc: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID theWRAP_by_TronDoc"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 56 57 33 C0 89 45 F0 B8 48 D2 4B 00 E8 BC 87 F4 FF BB 04 0B 4D 00 33 C0 55 68 E8 D5 4B 00 64 FF 30 64 89 20 E8 9C F4 FF FF E8 F7 FB FF FF 6A 40 8D 55 F0 A1 F0 ED 4B 00 8B 00 E8 42 2E F7 FF 8B 4D F0 B2 01 A1 F4 C2 40 00 E8 F7 20 F5 FF 8B F0 B2 01 A1 B4 C3 40 00 E8 F1 5B F4 FF 89 03 33 D2 8B 03 E8 42 1E F5 FF 66 B9 02 00 BA FC FF FF FF 8B C6 8B 38 FF 57 0C BA B8 A7 4D 00 B9 04 00 00 00 8B C6 8B 38 FF 57 04 83 3D B8 A7 4D 00 00 0F 84 5E 01 00 00 8B 15 B8 A7 4D 00 83 C2 04 F7 DA 66 B9 02 00 8B C6 8B 38 FF 57 0C 8B 0D B8 A7 4D 00 8B D6 8B 03 E8 2B 1F F5 FF 8B C6 E8 B4 5B F4 FF 33 D2 8B 03 E8 DF 1D F5 FF BA F0 44 4E 00 B9 01 00 00 00 8B 03 8B 30 FF 56 04 80 3D F0 44 4E 00 0A 75 3F BA B8 A7 4D 00 B9 04 00 00 00 8B 03 8B 30 FF 56 04 8B 15 B8 A7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Crypter: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Crypter"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D EB 26 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_Visual_Cpp_v8_DLL_h_small_sig1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Visual_Cpp_v8_DLL_h_small_sig1"
        weight = 1
    strings:
        $a = { 8B FF 55 8B EC 83 7D 0C 01 75 05 E8 ?? ?? ?? FF 5D E9 D6 FE FF FF CC CC CC CC CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Morphine_33_Holy_Father_Ratter29A: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Morphine_33_Holy_Father_Ratter29A"
        weight = 1
    strings:
        $a = { 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_Visual_Cpp_v8_DLL_h_small_sig2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Visual_Cpp_v8_DLL_h_small_sig2"
        weight = 1
    strings:
        $a = { 8B FF 55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 0F 84 ?? ?? 00 00 83 FE 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BeRoEXEPacker_V100_BeRo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BeRoEXEPacker_V100_BeRo"
        weight = 1
    strings:
        $a = { BA ?? ?? ?? ?? 8D B2 ?? ?? ?? ?? 8B 46 ?? 85 C0 74 51 03 C2 8B 7E ?? 8B 1E 85 DB 75 02 8B DF 03 DA 03 FA 52 57 50 FF 15 ?? ?? ?? ?? 5F 5A 85 C0 74 2F 8B C8 8B 03 85 C0 74 22 0F BA F0 1F 72 04 8D 44 ?? ?? 51 52 57 50 51 FF 15 ?? ?? ?? ?? 5F 5A 59 85 C0 74 0B AB 83 C3 04 EB D8 83 C6 14 EB AA 61 C3 }
        $b = { BA ?? ?? ?? ?? 8D B2 ?? ?? ?? ?? 8B 46 ?? 85 C0 74 51 03 C2 8B 7E ?? 8B 1E 85 DB 75 02 8B DF 03 DA 03 FA 52 57 50 FF 15 ?? ?? ?? ?? 5F 5A 85 C0 74 2F 8B C8 8B 03 85 C0 74 22 0F BA F0 1F 72 04 8D 44 ?? ?? 51 52 57 50 51 FF 15 ?? ?? ?? ?? 5F 5A 59 85 C0 74 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Sentinel_SuperPro_Automatic_Protection_v641_Safenet: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Sentinel_SuperPro_Automatic_Protection_v641_Safenet"
        weight = 1
    strings:
        $a = { A1 ?? ?? ?? ?? 55 8B ?? ?? ?? 85 C0 74 ?? 85 ED 75 ?? A1 ?? ?? ?? ?? 50 55 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 55 51 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 6A 00 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 01 00 00 00 5D C2 0C 00 68 ?? ?? ?? ?? 6A 01 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C9 3D B7 00 00 00 A1 ?? ?? ?? ?? 0F 94 C1 85 C0 89 0D ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 56 C7 05 ?? ?? ?? ?? 01 00 00 00 FF 15 ?? ?? ?? ?? 01 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 25 FE FF DF 3F 0D 01 00 20 00 A3 ?? ?? ?? ?? 33 C0 50 C7 04 ?? ?? ?? ?? ?? 00 00 00 00 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Launcher_Generator_v103: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Launcher_Generator_v103"
        weight = 1
    strings:
        $a = { 68 00 20 40 00 68 10 20 40 00 6A 00 6A 00 6A 20 6A 00 6A 00 6A 00 68 F0 22 40 00 6A 00 E8 93 00 00 00 85 C0 0F 84 7E 00 00 00 B8 00 00 00 00 3B 05 68 20 40 00 74 13 6A ?? 68 60 23 40 00 68 20 23 40 00 6A 00 E8 83 00 00 00 A1 58 20 40 00 3B 05 6C 20 40 00 74 51 C1 E0 02 A3 5C 20 40 00 BB 70 21 40 00 03 C3 8B 18 68 60 20 40 00 53 B8 F0 21 40 00 03 05 5C 20 40 00 8B D8 8B 03 05 70 20 40 00 50 B8 70 22 40 00 03 05 5C 20 40 00 FF 30 FF 35 00 20 40 00 E8 26 00 00 00 A1 58 20 40 00 40 A3 58 20 40 00 EB A2 6A FF E8 00 00 00 00 FF 25 5C 30 40 00 FF 25 60 30 40 00 FF 25 64 30 40 00 FF 25 68 30 40 00 FF 25 6C 30 40 00 FF 25 74 30 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Hardlock_dongle_Alladin: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Hardlock_dongle_Alladin"
        weight = 1
    strings:
        $a = { 5C 5C 2E 5C 48 41 52 44 4C 4F 43 4B 2E 56 58 44 00 00 00 00 5C 5C 2E 5C 46 45 6E 74 65 44 65 76 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1339_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1339_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 28 EB 02 ?? ?? 33 C0 EB 02 ?? ?? C3 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 01 ?? 50 EB 03 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PKLITE32_v11: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PKLITE32_v11"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 00 00 00 E8 }
        $b = { 55 8B EC A1 ?? ?? ?? ?? 85 C0 74 09 B8 01 ?? ?? ?? 5D C2 0C ?? 8B 45 0C 57 56 53 8B 5D 10 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule SLVc0deProtector_060_SLV_ICU: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SLVc0deProtector_060_SLV_ICU"
        weight = 1
    strings:
        $a = { EB 02 FA 04 E8 49 00 00 00 69 E8 49 00 00 00 95 E8 4F 00 00 00 68 E8 1F 00 00 00 49 E8 E9 FF FF FF 67 E8 1F 00 00 00 93 E8 31 00 00 00 78 E8 DD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_WAV_Audio_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_WAV_Audio_file"
        weight = 1
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 57 41 56 45 66 6D 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FakeNinja_v28_Spirit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FakeNinja_v28_Spirit"
        weight = 1
    strings:
        $a = { BA ?? ?? ?? ?? FF E2 64 11 40 00 FF 35 84 11 40 00 E8 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AutoDesk_Animation_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AutoDesk_Animation_file"
        weight = 1
    strings:
        $a = { ?? ?? ?? 00 12 AF ?? ?? 40 01 C8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_60: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_60"
        weight = 1
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 ?? ?? 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Alex_Protector_10_Alex: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Alex_Protector_10_Alex"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 10 40 00 E8 24 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Enigma_Protector_112_Vladimir_Sukhov: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Enigma_Protector_112_Vladimir_Sukhov"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 C5 FA 81 ED ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 C0 C3 83 C0 08 EB 02 FF 15 89 C4 61 EB 2E EA EB 2B 83 04 24 03 EB 01 00 31 C0 EB 01 85 64 FF 30 EB 01 83 64 89 20 EB 02 CD 20 89 00 9A 64 8F 05 00 00 00 00 EB 02 C1 90 58 61 EB 01 3E EB 04 }
        $b = { 60 E8 00 00 00 00 5D 83 ED 06 81 ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 C0 C3 83 C0 08 EB 02 FF 15 89 C4 61 EB 2E EA EB 2B 83 04 24 03 EB 01 00 31 C0 EB 01 85 64 FF 30 EB 01 83 64 89 20 EB 02 CD 20 89 00 9A 64 8F 05 00 00 00 00 EB 02 C1 90 58 61 EB 01 3E EB 04 ?? ?? ?? ?? B8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 01 E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 05 F6 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 B9 44 1A }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Reg2Exe_225_by_Jan_Vorel: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Reg2Exe_225_by_Jan_Vorel"
        weight = 1
    strings:
        $a = { 68 68 00 00 00 68 00 00 00 00 68 70 7D 40 00 E8 AE 20 00 00 83 C4 0C 68 00 00 00 00 E8 AF 52 00 00 A3 74 7D 40 00 68 00 00 00 00 68 00 10 00 00 68 00 00 00 00 E8 9C 52 00 00 A3 70 7D 40 00 E8 24 50 00 00 E8 E2 48 00 00 E8 44 34 00 00 E8 54 28 00 00 E8 98 27 00 00 E8 93 20 00 00 68 01 00 00 00 68 D0 7D 40 00 68 00 00 00 00 8B 15 D0 7D 40 00 E8 89 8F 00 00 B8 00 00 10 00 68 01 00 00 00 E8 9A 8F 00 00 FF 35 A4 7F 40 00 68 00 01 00 00 E8 3A 23 00 00 8D 0D A8 7D 40 00 5A E8 5E 1F 00 00 FF 35 A8 7D 40 00 68 00 01 00 00 E8 2A 52 00 00 A3 B4 7D 40 00 FF 35 A4 7F 40 00 FF 35 B4 7D 40 00 FF 35 A8 7D 40 00 E8 5C 0C 00 00 8D 0D A0 7D 40 00 5A E8 26 1F 00 00 FF 35 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v21: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v21"
        weight = 1
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ENIGMA_Protector_V112_Sukhov_Vladimir: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ENIGMA_Protector_V112_Sukhov_Vladimir"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 C5 FA 81 ED ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_022_023_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_022_023_Dwing"
        weight = 1
    strings:
        $a = { 6A 07 BE 88 01 40 00 AD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_ZCode_101_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_ZCode_101_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 E9 12 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E9 FB FF FF FF C3 68 00 00 00 00 64 FF 35 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreePascal_200_Win32: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreePascal_200_Win32"
        weight = 1
    strings:
        $a = { C6 05 00 80 40 00 01 E8 74 00 00 00 C6 05 00 80 40 00 00 E8 68 00 00 00 50 E8 00 00 00 00 FF 25 D8 A1 40 00 90 90 90 90 90 90 90 90 90 90 90 90 55 89 E5 83 EC 04 89 5D FC E8 92 00 00 00 E8 ED 00 00 00 89 C3 B9 ?? 70 40 00 89 DA B8 00 00 00 00 E8 0A 01 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule InterGraph_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID InterGraph_Graphics_format"
        weight = 1
    strings:
        $a = { 08 09 FE 01 18 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PowerBASICCC_40: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PowerBASICCC_40"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 ?? 40 00 66 2E F7 05 ?? ?? 40 00 04 00 75 05 E9 68 05 00 00 E9 6E 03 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DrHalo_or_DrGenius_Palette_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DrHalo_or_DrGenius_Palette_Graphics_format"
        weight = 1
    strings:
        $a = { 41 48 E3 00 00 00 0A 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BDC_HelpSystem_Help_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BDC_HelpSystem_Help_file"
        weight = 1
    strings:
        $a = { 42 44 43 20 48 65 6C 70 53 79 73 74 65 6D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EPExE_Pack_V10_6aHguT_g_l_u_k: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EPExE_Pack_V10_6aHguT_g_l_u_k"
        weight = 1
    strings:
        $a = { 60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 6A 40 FF D0 89 05 ?? ?? ?? ?? 89 C7 BE ?? ?? ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HPA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HPA"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5E 8B D6 83 ?? ?? 83 ?? ?? 06 0E 1E 0E 1F 33 FF 8C D3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_50_Dll_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_50_Dll_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 83 7C 24 08 01 75 05 E8 DE 4B 00 00 FF 74 24 04 8B 4C 24 10 8B 54 24 0C E8 ED FE FF FF 59 C2 0C 00 6A 0C 68 ?? ?? ?? ?? E8 E5 24 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 8F 15 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 20 15 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? 03 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 D7 23 00 00 59 89 7D FC FF 75 08 E8 EC 53 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 2B C5 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 19 ED FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 7D 22 00 00 59 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MEW_11_SE_v11_Northfox_HCC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MEW_11_SE_v11_Northfox_HCC"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? FF 0C ?0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeSplitter_10_Bill_Prisoner_TPOC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeSplitter_10_Bill_Prisoner_TPOC"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? 00 4D 5A ?? 00 ?? 00 00 00 04 00 ?? 00 FF FF 00 00 B8 00 00 00 00 00 00 00 40 00 ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Exe_Locker_v10_IonIce: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Exe_Locker_v10_IonIce"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 60 8B 6C 24 20 81 ED 05 00 00 00 3E 8F 85 6C 00 00 00 3E 8F 85 68 00 00 00 3E 8F 85 64 00 00 00 3E 8F 85 60 00 00 00 3E 8F 85 5C 00 00 00 3E 8F 85 58 00 00 00 3E 8F 85 54 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Packer: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Packer"
        weight = 1
    strings:
        $a = { FC 8B 35 70 01 40 ?? 83 EE 40 6A 40 68 ?? 30 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Silicon_Realms_Install_Stub: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Silicon_Realms_Install_Stub"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? 92 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? ?? 40 00 33 D2 8A D4 89 15 ?? ?? 40 00 8B C8 81 E1 FF 00 00 00 89 0D ?? ?? 40 00 C1 E1 08 03 CA 89 0D ?? ?? 40 00 C1 E8 10 A3 ?? ?? 40 00 33 F6 56 E8 ?? ?? 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 ?? ?? 00 00 FF 15 ?? 91 40 00 A3 ?? ?? 40 00 E8 ?? ?? 00 00 A3 ?? ?? 40 00 E8 ?? ?? 00 00 E8 ?? ?? 00 00 E8 ?? ?? FF FF 89 75 D0 8D 45 A4 50 FF 15 ?? 91 40 00 E8 ?? ?? 00 00 89 45 9C F6 45 D0 01 74 06 0F B7 45 D4 EB 03 6A 0A 58 50 FF 75 9C 56 56 FF 15 ?? 91 40 00 50 E8 ?? ?? FF FF 89 45 A0 50 E8 ?? ?? FF FF 8B 45 EC 8B 08 8B 09 89 4D 98 50 51 E8 ?? ?? 00 00 59 59 C3 8B 65 E8 FF 75 98 E8 ?? ?? FF FF 83 3D ?? ?? 40 00 01 75 05 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PKLITE_v100_v103: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PKLITE_v100_v103"
        weight = 1
    strings:
        $a = { B8 ?? ?? BA ?? ?? 8C DB 03 D8 3B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V11_cyberbob: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V11_cyberbob"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BlackEnergy_DDoS_Bot_Crypter: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BlackEnergy_DDoS_Bot_Crypter"
        weight = 1
    strings:
        $a = { 55 ?? ?? 81 EC 1C 01 00 00 53 56 57 6A 04 BE 00 30 00 00 56 FF 35 00 20 11 13 6A 00 E8 ?? 03 00 00 ?? ?? 83 C4 10 ?? FF 89 7D F4 0F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CRYPToCRACKs_PE_Protector_V092_Lukas_Fleischer: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CRYPToCRACKs_PE_Protector_V092_Lukas_Fleischer"
        weight = 1
    strings:
        $a = { E8 01 00 00 00 E8 58 5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 37 84 DB 75 33 8B F3 03 ?? ?? 81 3E 50 45 00 00 75 26 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FishPE_V10X_hellfish_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FishPE_V10X_hellfish_Sign_by_fly"
        weight = 1
    strings:
        $a = { 60 E8 EA FD FF FF FF D0 C3 8D 40 00 ?? 00 00 00 2C 00 00 00 ?? ?? ?? 00 ?? ?? 00 00 ?? ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? 00 00 00 00 ?? ?? 00 00 10 00 00 ?? ?? ?? 00 40 ?? ?? ?? 00 00 ?? ?? 00 00 ?? ?? 00 ?? ?? ?? 00 40 ?? ?? ?? 00 00 ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_V1033_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_V1033_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8E 00 00 00 E8 03 00 00 00 EB 01 ?? E8 81 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B7 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AA 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2D E8 03 00 00 00 EB 01 ?? 60 E8 00 00 00 00 5D 81 ED 07 E2 40 00 8B D5 81 C2 56 E2 40 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule File_Analyzer_Compiled_Datafile_Version: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID File_Analyzer_Compiled_Datafile_Version"
        weight = 1
    strings:
        $a = { 46 69 6C 65 20 41 6E 61 6C 79 7A 65 72 20 43 6F 6D 70 69 6C 65 64 20 44 61 74 61 66 69 6C 65 20 56 65 72 73 69 6F 6E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pohernah_101_by_Kas: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pohernah_101_by_Kas"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED F1 26 40 00 8B BD 18 28 40 00 8B 8D 20 28 40 00 B8 38 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 1C 28 40 00 31 C0 51 31 C9 66 B9 FA 00 66 83 F9 00 74 49 8B 57 0C 03 95 1C 28 40 00 8B 85 24 28 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 89 CE E8 27 00 00 00 89 C1 5F B8 38 28 40 00 01 E8 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 14 28 40 00 89 44 24 1C 61 FF E0 56 57 4F F7 D7 21 FE 89 F0 5F 5E C3 60 83 F0 05 40 90 48 83 F0 05 89 C6 89 D7 60 E8 0B 00 00 00 61 83 C7 08 83 E9 07 E2 F1 61 C3 57 8B 1F 8B 4F 04 68 B9 79 37 9E 5A 42 89 D0 48 C1 E0 05 BF 20 00 00 00 4A 89 DD C1 E5 04 29 E9 8B 6E 08 31 DD 29 E9 89 DD C1 ED 05 31 C5 29 E9 2B 4E 0C 89 CD C1 E5 04 29 EB 8B 2E 31 CD 29 EB 89 CD C1 ED 05 31 C5 29 EB 2B 5E 04 29 D0 4F 75 C8 5F 89 1F 89 4F 04 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_V12003318_V12003518_WFS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_V12003318_V12003518_WFS"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 79 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 53 79 73 74 65 6D 44 69 72 65 63 74 6F 72 79 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v70_64_Bit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v70_64_Bit"
        weight = 1
    strings:
        $a = { ?? ?? 41 00 00 00 00 00 00 00 63 00 00 00 00 00 ?? 00 ?? ?? ?? ?? ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? 20 ?? ?? 00 ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Shrinker_34: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Shrinker_34"
        weight = 1
    strings:
        $a = { 55 8B EC 56 57 75 6B 68 00 01 00 00 E8 11 0B 00 00 83 C4 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Shrinker_33: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Shrinker_33"
        weight = 1
    strings:
        $a = { 00 00 55 8B EC 56 57 75 65 68 00 01 00 00 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Shrinker_32: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Shrinker_32"
        weight = 1
    strings:
        $a = { 55 8B EC 56 57 75 65 68 00 01 00 00 E8 F1 E6 FF FF 83 C4 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CipherWall_Self_ExtratorDecryptor_Console_v15: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CipherWall_Self_ExtratorDecryptor_Console_v15"
        weight = 1
    strings:
        $a = { 90 61 BE 00 10 42 00 8D BE 00 00 FE FF C7 87 C0 20 02 00 0B 6E 5B 9B 57 83 CD FF EB 0E 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 83 C1 02 81 FD 00 F3 FF FF 83 D1 01 8D 14 2F 83 FD FC 76 0F 8A 02 42 88 07 47 49 75 F7 E9 63 FF FF FF 90 8B 02 83 C2 04 89 07 83 C7 04 83 E9 04 77 F1 01 CF E9 4C FF FF FF 5E 89 F7 B9 12 10 00 00 8A 07 47 2C E8 3C 01 77 F7 80 3F 06 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PeCompact2_253_276_BitSum_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PeCompact2_253_276_BitSum_Technologies"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 55 53 51 57 56 52 8D 98 C9 11 00 10 8B 53 18 52 8B E8 6A 40 68 00 10 00 00 FF 73 04 6A 00 8B 4B 10 03 CA 8B 01 FF D0 5A 8B F8 50 52 8B 33 8B 43 20 03 C2 8B 08 89 4B 20 8B 43 1C 03 C2 8B 08 89 4B 1C 03 F2 8B 4B 0C 03 CA 8D 43 1C 50 57 56 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yzpack_V20_UsAr_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yzpack_V20_UsAr_Sign_by_fly"
        weight = 1
    strings:
        $a = { 5A 52 45 60 83 EC 18 8B EC 8B FC 33 C0 64 8B 40 30 78 0C 8B 40 0C 8B 70 1C AD 8B 40 08 EB 09 8B 40 34 83 C0 7C 8B 40 3C AB E9 ?? ?? ?? ?? B4 09 BA 00 00 1F CD 21 B8 01 4C CD 21 40 00 00 00 50 45 00 00 4C 01 02 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 E0 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 ?? ?? 45 00 E8 ?? ?? ?? FF A1 ?? ?? 45 00 8B 00 E8 ?? ?? FF FF 8B 0D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Histogram_graphics_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Histogram_graphics_file"
        weight = 1
    strings:
        $a = { 6D 68 77 61 6E 68 00 04 01 02 01 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_2x_beta_version_Jeremy_Collake: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_2x_beta_version_Jeremy_Collake"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? 00 80 00 28 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_PEtite_21_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_PEtite_21_emadicius"
        weight = 1
    strings:
        $a = { 60 E8 2B 00 00 00 0D 0A 0D 0A 0D 0A 52 65 67 69 73 74 41 72 65 64 20 74 6F 3A 20 4E 4F 4E 2D 43 4F 4D 4D 45 52 43 49 41 4C 21 21 0D 0A 0D 0A 0D 00 58 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V10beta_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V10beta_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8D 64 24 04 8B 6C 24 FC 8D B5 4C 02 00 00 8D 9D 13 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Borland_Delphi_50_KOLMCK: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Borland_Delphi_50_KOLMCK"
        weight = 1
    strings:
        $a = { 55 8B EC 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 FF 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 EB 04 00 00 00 01 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule GIF89a_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID GIF89a_Graphics_format"
        weight = 1
    strings:
        $a = { 47 49 46 38 39 61 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Name_of_the_Packer_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Name_of_the_Packer_v10"
        weight = 1
    strings:
        $a = { 50 E8 ?? ?? ?? ?? 58 25 ?? F0 FF FF 8B C8 83 C1 60 51 83 C0 40 83 EA 06 52 FF 20 9D C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Banners_font_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Banners_font_file"
        weight = 1
    strings:
        $a = { AB CD 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V038_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V038_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { 58 8D 54 83 58 FF 16 72 5B 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 6F FF ?? ?? ?? 69 ED 00 0C 00 00 8D AC 2B 08 10 00 00 B0 01 E3 2A 8B D7 2B 53 08 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 54 95 00 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E3 B4 00 33 C9 B5 01 FF 56 50 33 C9 E9 FB 00 00 00 04 F9 1A C0 B1 30 8B 6B 08 03 D1 FF 16 73 49 03 D1 FF 16 72 17 03 D1 FF 16 72 27 24 02 04 09 50 8B C7 2B 43 08 8A 00 E9 CD 00 00 00 83 C2 60 FF 16 87 6B 0C 73 0C 03 D1 FF 16 87 6B 10 73 03 87 6B 14 24 03 04 08 50 55 8D 93 78 07 00 00 FF 56 54 5D 91 E9 95 00 00 00 24 03 04 07 50 87 6B 0C 87 6B 10 89 6B 14 8D 93 C0 0B 00 00 FF 56 54 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D AC 83 78 03 00 00 FF 56 4C 3C 04 8B E8 72 5C 33 ED D1 E8 13 ED 48 45 91 45 D3 E5 80 F9 05 8D 94 AB 78 01 00 00 76 2B 80 E9 04 33 C0 8B 53 FC D1 2B 8B 12 0F CA 2B 53 04 03 C0 3B 13 72 06 8B 13 40 01 53 04 FF 56 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXpressor_Version_1501: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXpressor_Version_1501"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 50 02 00 00 53 56 57 83 A5 D0 FD FF FF 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ESO_Eclipse_Operating_System_v208_p_DOS_Extender: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ESO_Eclipse_Operating_System_v208_p_DOS_Extender"
        weight = 1
    strings:
        $a = { 8C C8 8E D8 BA ?? ?? E8 ?? ?? BB ?? ?? 8C C0 2B D8 B4 4A CD 21 BA ?? ?? 73 ?? E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_WWPack32_1x_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_WWPack32_1x_emadicius"
        weight = 1
    strings:
        $a = { 53 55 8B E8 33 DB EB 60 0D 0A 0D 0A 57 57 50 61 63 6B 33 32 20 64 65 63 6F 6D 70 72 65 73 73 69 6F 6E 20 72 6F 75 74 69 6E 65 20 76 65 72 73 69 6F 6E 20 31 2E 31 32 0D 0A 28 63 29 20 31 39 39 38 20 50 69 6F 74 72 20 57 61 72 65 7A 61 6B 20 61 6E 64 20 52 61 66 61 6C 20 57 69 65 72 7A 62 69 63 6B 69 0D 0A 0D 0A 5D 5B 90 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Morphine_v27_Holy_Father_Ratter29A_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Morphine_v27_Holy_Father_Ratter29A_h"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_60_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_60_DLL"
        weight = 1
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 75 09 83 3D ?? ?? ?? ?? ?? EB 26 83 FE 01 74 05 83 FE 02 75 22 A1 ?? ?? ?? ?? 85 C0 74 09 57 56 53 FF D0 85 C0 74 0C 57 56 53 E8 15 FF FF FF 85 C0 75 04 33 C0 EB 4E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LZEXE_v091_v100a_1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LZEXE_v091_v100a_1"
        weight = 1
    strings:
        $a = { 06 0E 1F 8B ?? ?? ?? 8B F1 4E 89 F7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule aPack_v062: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID aPack_v062"
        weight = 1
    strings:
        $a = { 1E 06 8C C8 8E D8 ?? ?? ?? 8E C0 50 BE ?? ?? 33 FF FC B6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CalComp_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CalComp_Graphics_format"
        weight = 1
    strings:
        $a = { 02 50 0A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v20"
        weight = 1
    strings:
        $a = { 68 01 ?? 40 00 E8 01 00 00 00 C3 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v103_v104: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v103_v104"
        weight = 1
    strings:
        $a = { 01 DB ?? 07 8B 1E 83 EE FC 11 DB 8A 07 ?? EB B8 01 00 00 00 01 DB ?? 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_42_2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_42_2"
        weight = 1
    strings:
        $a = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 ?? ?? ?? ?? ?? ?? 83 ?? ?? 53 56 57 89 ?? ?? C7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VProtector_V10_Build_20041213: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VProtector_V10_Build_20041213"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 1A 89 40 00 68 56 89 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule codeCrypter_031_Tibbar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID codeCrypter_031_Tibbar"
        weight = 1
    strings:
        $a = { 50 58 53 5B 90 BB ?? ?? ?? 00 FF E3 90 CC CC CC 55 8B EC 5D C3 CC CC CC CC CC CC CC CC CC CC CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PureBasic_DLL_Neil_Hodgson: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PureBasic_DLL_Neil_Hodgson"
        weight = 1
    strings:
        $a = { 83 7C 24 08 01 75 ?? 8B 44 24 04 A3 ?? ?? ?? 10 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PoPa_001_Packer_on_Pascal_bagie: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PoPa_001_Packer_on_Pascal_bagie"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 A4 3E 00 10 E8 30 F6 FF FF 33 C0 55 68 BE 40 00 10 ?? ?? ?? ?? 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 33 C0 E8 62 E7 FF FF 8B 45 EC E8 32 F2 FF FF 50 E8 B4 F6 FF FF A3 64 66 00 10 33 D2 55 68 93 40 00 10 64 FF 32 64 89 22 83 3D 64 66 00 10 FF 0F 84 3A 01 00 00 6A 00 6A 00 6A 00 A1 64 66 00 10 50 E8 9B F6 FF FF 83 E8 10 50 A1 64 66 00 10 50 E8 BC F6 FF FF 6A 00 68 80 66 00 10 6A 10 68 68 66 00 10 A1 64 66 00 10 50 E8 8B F6 FF FF }
        $b = { 55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 A4 3E 00 10 E8 30 F6 FF FF 33 C0 55 68 BE 40 00 10 ?? ?? ?? ?? 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 33 C0 E8 62 E7 FF FF 8B 45 EC E8 32 F2 FF FF 50 E8 B4 F6 FF FF A3 64 66 00 10 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_01_Anorganix: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Anorganix"
        weight = 1
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Crunch_v5_Bit_Arts: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Crunch_v5_Bit_Arts"
        weight = 1
    strings:
        $a = { EB 15 03 00 00 00 06 00 00 00 00 00 00 00 00 00 00 00 68 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 1D 00 00 00 8B C5 55 60 9C 2B 85 FC 07 00 00 89 85 E8 07 00 00 FF 74 24 2C E8 20 02 00 00 0F 82 94 06 00 00 E8 F3 04 00 00 49 0F 88 88 06 00 00 8B B5 E8 07 00 00 8B 56 3C 8D 8C 32 C8 00 00 00 83 39 00 74 50 8B D9 53 68 BB D4 C3 79 33 C0 50 E8 0E 04 00 00 50 8D 95 EC 07 00 00 52 6A 04 68 00 10 00 00 FF B5 E8 07 00 00 FF D0 58 5B C7 03 00 00 00 00 C7 43 04 00 00 00 00 8D 95 F0 07 00 00 52 FF B5 EC 07 00 00 68 00 10 00 00 FF B5 E8 07 00 00 FF D0 68 6C D9 B2 96 33 C0 50 E8 C1 03 00 00 89 85 ?? 46 00 00 68 EC 49 7B 79 33 C0 50 E8 AE 03 00 00 89 85 ?? 46 00 00 E8 04 06 00 00 E9 F3 05 00 00 51 52 53 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PolyBox_D_Anskya: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PolyBox_D_Anskya"
        weight = 1
    strings:
        $a = { 55 8B EC 33 C9 51 51 51 51 51 53 33 C0 55 68 84 2C 40 00 64 FF 30 64 89 20 C6 45 FF 00 B8 B8 46 40 00 BA 24 00 00 00 E8 8C F3 FF FF 6A 24 BA B8 46 40 00 8B 0D B0 46 40 00 A1 94 46 40 00 E8 71 FB FF FF 84 C0 0F 84 6E 01 00 00 8B 1D D0 46 40 00 8B C3 83 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_30xx_Jitit_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Virtualization_Suite_30xx_Jitit_Software"
        weight = 1
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 00 00 00 01 68 00 ?? 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule A_program_by_Jupiter_: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID A_program_by_Jupiter_"
        weight = 1
    strings:
        $a = { 2B C0 74 05 68 ?? ?? ?? ?? 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nakedbind_10_nakedcrew: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nakedbind_10_nakedcrew"
        weight = 1
    strings:
        $a = { 64 8B 38 48 8B C8 F2 AF AF 8B 1F 66 33 DB 66 81 3B 4D 5A 74 08 81 EB 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_01x_020_021_024_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_01x_020_021_024_beta_Dwing"
        weight = 1
    strings:
        $a = { BE 88 01 ?? ?? AD 8B F8 ?? ?? ?? ?? 33 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Shield_V05_Smoke: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Shield_V05_Smoke"
        weight = 1
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED BC 1A 40 00 EB 01 00 8D B5 46 1B 40 00 BA B3 0A 00 00 EB 01 00 8D 8D F9 25 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_10_Cyberbob_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_10_Cyberbob_h"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimbiOZ_13_Extranger: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimbiOZ_13_Extranger"
        weight = 1
    strings:
        $a = { 57 57 8D 7C 24 04 50 B8 00 ?? ?? ?? AB 58 5F C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BeRoEXEPacker_v100_DLL_LZBRS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BeRoEXEPacker_v100_DLL_LZBRS"
        weight = 1
    strings:
        $a = { 83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC AD 8D 1C 07 B0 80 3B FB 73 3B E8 1C 00 00 00 72 03 A4 EB F2 E8 1A 00 00 00 8D 51 FF E8 12 00 00 00 56 8B F7 2B F2 F3 A4 5E EB DB 02 C0 75 03 AC 12 C0 C3 33 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressor_1451_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_1451_CGSoftLabs"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC 58 53 56 57 83 65 DC 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 2E 00 A1 00 ?? ?? 00 05 00 ?? ?? 00 A3 08 ?? ?? 00 A1 08 ?? ?? 00 B9 81 ?? ?? 00 2B 48 18 89 0D 0C ?? ?? 00 83 3D 10 ?? ?? 00 00 74 16 A1 08 ?? ?? 00 8B 0D 0C ?? ?? 00 03 48 14 89 4D CC E9 97 04 00 00 C7 05 10 ?? ?? 00 01 00 00 00 ?? ?? 68 54 ?? ?? 00 68 18 ?? ?? 00 6A 00 FF 15 E4 ?? ?? 00 83 7D 0C 01 74 04 83 65 08 00 6A 04 68 00 10 00 00 68 04 01 00 00 6A 00 FF 15 C4 ?? ?? 00 89 45 EC 68 04 01 00 00 FF 75 EC FF 75 08 FF 15 DC ?? ?? 00 8B 4D EC 8D 44 01 FF 89 45 AC 8B 45 AC 0F BE 00 83 F8 5C 74 09 8B 45 AC 48 89 45 AC EB EC 8B 45 AC 40 89 45 AC 8B 45 AC 2B 45 EC 89 45 B0 6A 04 68 00 10 00 00 68 04 01 00 00 6A 00 FF 15 C4 ?? ?? 00 89 45 FC 8B 4D B0 8B 75 EC 8B 7D FC 8B C1 C1 E9 02 }
        $b = { 55 8B EC 83 EC 58 53 56 57 83 65 DC 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 2E 00 A1 00 ?? ?? ?? 05 00 ?? ?? ?? A3 08 ?? ?? ?? A1 08 ?? ?? ?? B9 81 ?? ?? ?? 2B 48 18 89 0D 0C ?? ?? ?? 83 3D 10 ?? ?? ?? 00 74 16 A1 08 ?? ?? ?? 8B 0D 0C ?? ?? ?? 03 48 14 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule VProtector_10X_vcasm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VProtector_10X_vcasm"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 07 00 00 00 C7 83 83 C0 13 EB 0B 58 EB 02 CD 20 83 C0 02 EB 01 E9 50 C3 E8 B9 04 00 00 00 E8 1F 00 00 00 EB FA E8 16 00 00 00 E9 EB F8 00 00 58 EB 09 0F 25 E8 F2 FF FF FF 0F B9 49 75 F1 EB 05 EB F9 EB F0 D6 EB 01 0F 31 F0 EB 0C 33 C8 EB 03 EB 09 0F 59 74 05 75 F8 51 EB F1 E8 16 00 00 00 8B 5C 24 0C 8B A3 C4 00 00 00 64 8F 05 00 00 00 00 83 C4 04 EB 14 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C9 99 F7 F1 E9 E8 05 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DotFix_Nice_Protect_21_GPcH_Soft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DotFix_Nice_Protect_21_GPcH_Soft"
        weight = 1
    strings:
        $a = { E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 B8 ?? ?? ?? ?? 03 C5 50 B8 ?? ?? ?? ?? 03 C5 FF 10 BB ?? ?? ?? ?? 03 DD 83 C3 0C 53 50 B8 ?? ?? ?? ?? 03 C5 FF 10 6A 40 68 00 10 00 00 FF 74 24 2C 6A 00 FF D0 89 44 24 1C 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_15_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_15_Vaska"
        weight = 1
    strings:
        $a = { 83 2C 24 4F 68 ?? ?? ?? ?? FF 54 24 04 83 44 24 04 4F B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? ?? EB F3 B8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_ARCV4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_ARCV4"
        weight = 1
    strings:
        $a = { E8 00 00 5D 81 ED 06 01 81 FC 4F 50 74 0B 8D B6 86 01 BF 00 01 57 A4 EB 11 1E 06 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AI1_Creator_1_Beta_2_by_MZ: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AI1_Creator_1_Beta_2_by_MZ"
        weight = 1
    strings:
        $a = { E8 FE FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_CrunchPE_Heuristic: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_CrunchPE_Heuristic"
        weight = 1
    strings:
        $a = { 55 E8 0E 00 00 00 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Special_EXE_Pasword_Protector_v101_Eng_Pavol_Cerven: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Special_EXE_Pasword_Protector_v101_Eng_Pavol_Cerven"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 89 AD 8C 01 00 00 8B C5 2B 85 FE 75 00 00 89 85 3E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_239_DLL_compressed_resources_wwwstrongbitcom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_239_DLL_compressed_resources_wwwstrongbitcom"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? E9 ?? ?? ?? FF 50 C1 C8 18 89 05 ?? ?? ?? ?? C3 C1 C0 18 51 E9 ?? ?? ?? FF 84 C0 0F 84 6A F9 FF FF E9 ?? ?? ?? FF C3 E9 ?? ?? ?? FF E8 CF E9 FF FF B8 01 00 00 00 E9 ?? ?? ?? FF 2B D0 68 A0 36 80 D4 59 81 C9 64 98 FF 99 E9 ?? ?? ?? FF 84 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PolyCryptor_by_SMT_Version_v3v4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PolyCryptor_by_SMT_Version_v3v4"
        weight = 1
    strings:
        $a = { EB ?? 28 50 6F 6C 79 53 63 72 79 70 74 20 ?? ?? ?? 20 62 79 20 53 4D 54 29 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pelles_C_2x_4x_DLL_Pelle_Orinius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pelles_C_2x_4x_DLL_Pelle_Orinius"
        weight = 1
    strings:
        $a = { 55 89 E5 53 56 57 8B 5D 0C 8B 75 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Themida_Oreans_Technologies_2004: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Themida_Oreans_Technologies_2004"
        weight = 1
    strings:
        $a = { B8 00 00 00 00 60 0B C0 74 58 E8 00 00 00 00 58 05 43 00 00 00 80 38 E9 75 03 61 EB 35 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TXT2COM: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TXT2COM"
        weight = 1
    strings:
        $a = { E8 ?? ?? CD 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Anslym_FUD_Crypter: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Anslym_FUD_Crypter"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 56 B8 38 17 05 10 E8 5A 45 FB FF 33 C0 55 68 21 1C 05 10 64 FF 30 64 89 20 EB 08 FC FC FC FC FC FC 27 54 E8 85 4C FB FF 6A 00 E8 0E 47 FB FF 6A 0A E8 27 49 FB FF E8 EA 47 FB FF 6A 0A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Horse1776: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Horse1776"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5D 83 ?? ?? 06 1E 26 ?? ?? ?? ?? BF ?? ?? 1E 0E 1F 8B F7 01 EE B9 ?? ?? FC F3 A6 1F 1E 07 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NakedPacker_10_by_BigBoote: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NakedPacker_10_by_BigBoote"
        weight = 1
    strings:
        $a = { 60 FC 0F B6 05 34 ?? ?? ?? 85 C0 75 31 B8 50 ?? ?? ?? 2B 05 04 ?? ?? ?? A3 30 ?? ?? ?? A1 00 ?? ?? ?? 03 05 30 ?? ?? ?? A3 38 ?? ?? ?? E8 9A 00 00 00 A3 50 ?? ?? ?? C6 05 34 ?? ?? ?? 01 83 3D 50 ?? ?? ?? 00 75 07 61 FF 25 38 ?? ?? ?? 61 FF 74 24 04 6A 00 FF 15 44 ?? ?? ?? 50 FF 15 40 ?? ?? ?? C3 FF 74 24 04 6A 00 FF 15 44 ?? ?? ?? 50 FF 15 48 ?? ?? ?? C3 8B 4C 24 04 56 8B 74 24 10 57 85 F6 8B F9 74 0D 8B 54 24 10 8A 02 88 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Windows_9x_registry_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Windows_9x_registry_file"
        weight = 1
    strings:
        $a = { 43 52 45 47 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Eddie1530: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Eddie1530"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5E 81 EE ?? ?? FC 2E ?? ?? ?? ?? 4D 5A ?? ?? FA 8B E6 81 C4 ?? ?? FB 3B ?? ?? ?? ?? ?? 2E ?? ?? ?? ?? 50 06 56 1E 33 C0 50 1F C4 ?? ?? ?? 2E ?? ?? ?? ?? 2E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Shegerd_Dongle_V478_MSCo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Shegerd_Dongle_V478_MSCo"
        weight = 1
    strings:
        $a = { E8 32 00 00 00 B8 ?? ?? ?? ?? 8B 18 C1 CB 05 89 DA 36 8B 4C 24 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V118_Basic_Edition_LZMA_430_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V118_Basic_Edition_LZMA_430_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A 40 68 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V12X_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V12X_Obsidium_Software"
        weight = 1
    strings:
        $a = { E8 0E 00 00 00 33 C0 8B 54 24 0C 83 82 B8 00 00 00 0D C3 64 67 FF 36 00 00 64 67 89 26 00 00 50 33 C0 8B 00 C3 E9 FA 00 00 00 E8 D5 FF FF FF 58 64 67 8F 06 00 00 83 C4 04 E8 2B 13 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DBPE_vxxx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DBPE_vxxx"
        weight = 1
    strings:
        $a = { 03 05 80 1A B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LSI_C_86_Run_Time_Libray: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LSI_C_86_Run_Time_Libray"
        weight = 1
    strings:
        $a = { B8 ?? ?? 8E C0 06 17 BC ?? ?? 26 8C ?? ?? ?? B4 30 CD 21 26 A3 ?? ?? FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACProtectUltraProtect_10X_20X_RiSco: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtectUltraProtect_10X_20X_RiSco"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressor_120_Beta_PE_Packer: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_120_Beta_PE_Packer"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 EB ?? 45 78 50 72 2D 76 2E 31 2E 32 2E 2E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Private_exe_Protector_V18_SetiSoft_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_exe_Protector_V18_SetiSoft_Team"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v031a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v031a"
        weight = 1
    strings:
        $a = { 60 D1 CB 0F CA C1 CA E0 D1 CA 0F C8 EB 01 F1 0F C0 C9 D2 D1 0F C1 C0 D3 DA C0 D6 A8 EB 01 DE D0 EC 0F C1 CB D0 CF 0F C1 D1 D2 DB 0F C8 EB 01 BC C0 E9 C6 C1 D0 91 0F CB EB 01 73 0F CA 87 D9 87 D2 D0 CF 87 D9 0F C8 EB 01 C1 EB 01 A2 86 CA D0 E1 0F C0 CB 0F CA C0 C7 91 0F CB C1 D9 0C 86 F9 86 D7 D1 D9 EB 01 A5 EB 01 11 EB 01 1D 0F C1 C2 0F CB 0F C1 C2 EB 01 A1 C0 E9 FD 0F C1 D1 EB 01 E3 0F CA 87 D9 EB 01 F3 0F CB 87 C2 0F C0 F9 D0 F7 EB 01 2F 0F C9 C0 DC C4 EB 01 35 0F CA D3 D1 86 C8 EB 01 01 0F C0 F5 87 C8 D0 DE EB 01 95 EB 01 E1 EB 01 FD EB 01 EC 87 D3 0F CB C1 DB 35 D3 E2 0F C8 86 E2 86 EC C1 FB 12 D2 EE 0F C9 D2 F6 0F CA 87 C3 C1 D3 B3 EB 01 BF D1 CB 87 C9 0F CA 0F C1 DB EB 01 44 C0 CA F2 0F C1 D1 0F CB EB 01 D3 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LamerStop_v10c_c_Stefan_Esser: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LamerStop_v10c_c_Stefan_Esser"
        weight = 1
    strings:
        $a = { E8 ?? ?? 05 ?? ?? CD 21 33 C0 8E C0 26 ?? ?? ?? 2E ?? ?? ?? 26 ?? ?? ?? 2E ?? ?? ?? BA ?? ?? FA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EYouDiDai_YueHeiFengGao: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EYouDiDai_YueHeiFengGao"
        weight = 1
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 53 56 57 0F 31 8B D8 0F 31 8B D0 2B D3 C1 EA 10 B8 ?? ?? ?? ?? 0F 6E C0 B8 ?? ?? ?? ?? 0F 6E C8 0F F5 C1 0F 7E C0 0F 77 03 C2 ?? ?? ?? ?? ?? FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_kkryptor_9kryptor_a_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_kkryptor_9kryptor_a_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 60 E8 ?? ?? ?? ?? 5E B9 00 00 00 00 2B C0 02 04 0E D3 C0 49 79 F8 41 8D 7E 2C 33 46 ?? 66 B9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ChinaProtect_dummy: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ChinaProtect_dummy"
        weight = 1
    strings:
        $a = { C3 E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 C3 56 8B ?? ?? ?? 6A 40 68 00 10 00 00 8D ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 89 30 83 C0 04 5E C3 8B 44 ?? ?? 56 8D ?? ?? 68 00 40 00 00 FF 36 56 E8 ?? ?? ?? ?? 68 00 80 00 00 6A 00 56 E8 ?? ?? ?? ?? 5E C3 }
        $b = { 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule EXEPACK_LINK_v360_v364_v365_or_50121: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXEPACK_LINK_v360_v364_v365_or_50121"
        weight = 1
    strings:
        $a = { 8C C0 05 ?? ?? 0E 1F A3 ?? ?? 03 ?? ?? ?? 8E C0 8B ?? ?? ?? 8B ?? 4F 8B F7 FD F3 A4 50 B8 ?? ?? 50 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Hafen1641: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Hafen1641"
        weight = 1
    strings:
        $a = { E8 ?? ?? 01 ?? ?? ?? CE CC 25 ?? ?? 25 ?? ?? 25 ?? ?? 40 51 D4 ?? ?? ?? CC 47 CA ?? ?? 46 8A CC 44 88 CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_2x_Jeremy_Collake: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_2x_Jeremy_Collake"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NTkrnl_Secure_Suite_NTkrnl_team_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NTkrnl_Secure_Suite_NTkrnl_team_h"
        weight = 1
    strings:
        $a = { 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule XXPack_01_bagie: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID XXPack_01_bagie"
        weight = 1
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 5E 1F 40 00 EB 02 83 09 8D B5 EF 1F 40 00 EB 02 83 09 BA A3 11 00 00 EB 00 68 00 ?? ?? ?? C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NeoLite_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NeoLite_v20"
        weight = 1
    strings:
        $a = { E9 A6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Embedded_2609_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_2609_Jitit"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 58 BB AD 19 00 00 2B C3 50 68 ?? ?? ?? ?? 68 B0 1C 00 00 68 80 00 00 00 E8 35 FF FF FF E9 99 FF FF FF 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v120_Eng_dulekxt_MASM32_TASM32: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v120_Eng_dulekxt_MASM32_TASM32"
        weight = 1
    strings:
        $a = { 33 C2 2C FB 8D 3D 7E 45 B4 80 E8 02 00 00 00 8A 45 58 68 02 ?? 8C 7F EB 02 CD 20 5E 80 C9 16 03 F7 EB 02 40 B0 68 F4 00 00 00 80 F1 2C 5B C1 E9 05 0F B6 C9 8A 16 0F B6 C9 0F BF C7 2A D3 E8 02 00 00 00 99 4C 58 80 EA 53 C1 C9 16 2A D3 E8 02 00 00 00 9D CE 58 80 EA 33 C1 E1 12 32 D3 48 80 C2 26 EB 02 CD 20 88 16 F7 D8 46 EB 01 C0 4B 40 8D 0D 00 00 00 00 3B D9 75 B7 EB 01 14 EB 01 0A CF C5 93 53 90 DA 96 67 54 8D CC ?? ?? 51 8E 18 74 53 82 83 80 47 B4 D2 41 FB 64 31 6A AF 7D 89 BC 0A 91 D7 83 37 39 43 50 A2 32 DC 81 32 3A 4B 97 3D D9 63 1F 55 42 F0 45 32 60 9A 28 51 61 4B 38 4B 12 E4 49 C4 99 09 47 F9 42 8C 48 51 4E 70 CF B8 12 2B 78 09 06 07 17 55 D6 EA 10 8D 3F 28 E5 02 0E A2 58 B8 D6 0F A8 E5 10 EB E8 F1 23 EF 61 E5 E2 54 EA A9 2A 22 AF 17 A1 23 97 9A 1C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1332_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1332_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 01 ?? E8 2B 00 00 00 EB 02 ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 02 ?? ?? 50 EB 02 ?? ?? 33 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DJoin_v07_public_RC4_encryption_drmist: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DJoin_v07_public_RC4_encryption_drmist"
        weight = 1
    strings:
        $a = { C6 05 ?? ?? 40 00 00 C6 05 ?? ?? 40 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule N_Joiner_01_Asm_Version_NEX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID N_Joiner_01_Asm_Version_NEX"
        weight = 1
    strings:
        $a = { 6A 00 68 00 14 40 00 68 00 10 40 00 6A 00 E8 14 00 00 00 6A 00 E8 13 00 00 00 CC FF 25 AC 12 40 00 FF 25 B0 12 40 00 FF 25 B4 12 40 00 FF 25 B8 12 40 00 FF 25 BC 12 40 00 FF 25 C0 12 40 00 FF 25 C4 12 40 00 FF 25 C8 12 40 00 FF 25 CC 12 40 00 FF 25 D0 12 40 00 FF 25 D4 12 40 00 FF 25 D8 12 40 00 FF 25 DC 12 40 00 FF 25 E4 12 40 00 FF 25 EC 12 40 00 }
        $b = { 6A 00 68 00 14 40 00 68 00 10 40 00 6A 00 E8 14 00 00 00 6A 00 E8 13 00 00 00 CC FF 25 AC 12 40 00 FF 25 B0 12 40 00 FF 25 B4 12 40 00 FF 25 B8 12 40 00 FF 25 BC 12 40 00 FF 25 C0 12 40 00 FF 25 C4 12 40 00 FF 25 C8 12 40 00 FF 25 CC 12 40 00 FF 25 D0 12 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule MSLRH_032a_fake_PC_Guard_4xx_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_PC_Guard_4xx_emadicius"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 D3 FE FF FF 8B 06 83 F8 00 74 11 8D B5 DF FE FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_SVKP_13x_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_SVKP_13x_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 00 00 00 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 }
        $b = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 00 00 00 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule EP_ExE_Pack_V10_Elite_Coding_Group: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EP_ExE_Pack_V10_Elite_Coding_Group"
        weight = 1
    strings:
        $a = { 60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACProtect_V14X_risco: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtect_V14X_risco"
        weight = 1
    strings:
        $a = { 60 E8 01 00 00 00 7C 83 04 24 06 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thunderbolt_V002_deXep_forgot_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thunderbolt_V002_deXep_forgot_SignByfly"
        weight = 1
    strings:
        $a = { E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 E8 AA 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5D 68 00 FE 9F 07 53 E8 5D 00 00 00 EB FF 71 E8 C2 50 00 EB D6 5E F3 68 89 74 24 48 74 24 58 FF 8D 74 24 58 5E 83 C6 4C 75 F4 59 8D 71 E8 75 09 81 F6 EB FF 51 B9 01 00 83 EE FC 49 FF 71 C7 75 19 8B 74 24 00 00 81 36 50 56 8B 36 EB FF 77 C4 36 81 F6 EB 87 34 24 8B 8B 1C 24 83 EC FC EB 01 E8 83 EC FC E9 E7 00 00 00 5B EB FF F3 EB FF C3 }
        $b = { E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 E8 AA 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Spalsher_10_30_Amok: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Spalsher_10_30_Amok"
        weight = 1
    strings:
        $a = { 9C 60 8B 44 24 24 E8 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_12003318_12003518_WFS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_12003318_12003518_WFS"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 79 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 53 79 73 74 65 6D 44 69 72 65 63 74 6F 72 79 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v120_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v120_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp"
        weight = 1
    strings:
        $a = { 0F B6 D0 E8 01 00 00 00 0C 5A B8 80 ?? ?? 00 EB 02 00 DE 8D 35 F4 00 00 00 F7 D2 EB 02 0E EA 8B 38 EB 01 A0 C1 F3 11 81 EF 84 88 F4 4C EB 02 CD 20 83 F7 22 87 D3 33 FE C1 C3 19 83 F7 26 E8 02 00 00 00 BC DE 5A 81 EF F7 EF 6F 18 EB 02 CD 20 83 EF 7F EB 01 F7 2B FE EB 01 7F 81 EF DF 30 90 1E EB 02 CD 20 87 FA 88 10 80 EA 03 40 EB 01 20 4E EB 01 3D 83 FE 00 75 A2 EB 02 CD 20 EB 01 C3 78 73 42 F7 35 6C 2D 3F ED 33 97 ?? ?? ?? 5D F0 45 29 55 57 55 71 63 02 72 E9 1F 2D 67 B1 C0 91 FD 10 58 A3 90 71 6C 83 11 E0 5D 20 AE 5C 71 83 D0 7B 10 97 54 17 11 C0 0E 00 33 76 85 33 3C 33 21 31 F5 50 CE 56 6C 89 C8 F7 CD 70 D5 E3 DD 08 E8 4E 25 FF 0D F3 ED EF C8 0B 89 A6 CD 77 42 F0 A6 C8 19 66 3D B2 CD E7 89 CB 13 D7 D5 E3 1E DF 5A E3 D5 50 DF B3 39 32 C0 2D B0 3F B4 B4 43 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Packer_v70_by_TurboPower_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Packer_v70_by_TurboPower_Software"
        weight = 1
    strings:
        $a = { 1E 06 8C C3 83 ?? ?? 2E ?? ?? ?? ?? B9 ?? ?? 8C C8 8E D8 8B F1 4E 8B FE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Libraries_by_John_Socha: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Libraries_by_John_Socha"
        weight = 1
    strings:
        $a = { BB ?? ?? 8E DB 2E 89 ?? ?? ?? 8D ?? ?? ?? 25 ?? ?? FA 8E D3 8B E0 FB 26 A1 A3 ?? ?? B4 30 CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LX_Exe_Executable_Image: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LX_Exe_Executable_Image"
        weight = 1
    strings:
        $a = { 4C 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MASM_TASM: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MASM_TASM"
        weight = 1
    strings:
        $a = { 6A 00 E8 ?? ?? 00 00 A3 ?? 32 40 00 E8 ?? ?? 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Trivial46: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Trivial46"
        weight = 1
    strings:
        $a = { B4 4E B1 20 BA ?? ?? CD 21 BA ?? ?? B8 ?? 3D CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_30_by_North_Star_Liu_Xing_Ping: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_30_by_North_Star_Liu_Xing_Ping"
        weight = 1
    strings:
        $a = { FF 25 A4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { 9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 55 F9 FF FF 66 8B 06 66 83 F8 00 74 15 8B F5 8D B5 7D F9 FF FF 66 8B 06 66 83 F8 01 0F 84 42 02 00 00 C6 06 01 8B D5 2B 95 11 F9 FF FF 89 95 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule nbuild_v10_soft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nbuild_v10_soft"
        weight = 1
    strings:
        $a = { B9 ?? ?? BB ?? ?? C0 ?? ?? 80 ?? ?? 43 E2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_v13037_Obsidium_Software_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_v13037_Obsidium_Software_h"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Crinkler_V01_V02_Rune_LHStubbe_and_Aske_Simon_Christensen: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Crinkler_V01_V02_Rune_LHStubbe_and_Aske_Simon_Christensen"
        weight = 1
    strings:
        $a = { B9 ?? ?? ?? ?? 01 C0 68 ?? ?? ?? ?? 6A 00 58 50 6A 00 5F 48 5D BB 03 00 00 00 BE ?? ?? ?? ?? E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_V14_LiuXingPing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_V14_LiuXingPing"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B1 85 40 00 2D AA 85 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Berio_200_beta_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Berio_200_beta_h"
        weight = 1
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 E9 01 74 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACE_SFX_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACE_SFX_Archive"
        weight = 1
    strings:
        $a = { 2A 2A 41 43 45 2A 2A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V119_aPlib_043_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V119_aPlib_043_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 3C 04 00 00 EB 0C 8B 85 38 04 00 00 89 85 3C 04 00 00 8D B5 60 04 00 00 8D 9D EB 02 00 00 33 FF E8 52 01 00 00 EB 1B 8B 85 3C 04 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 48 04 00 00 00 74 0E 83 BD 4C 04 00 00 00 74 05 E8 B8 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 D1 03 00 00 89 85 5C 04 00 00 5B FF B5 5C 04 00 00 56 FF D3 83 C4 08 8B B5 5C 04 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 E9 94 00 00 00 56 FF 95 C9 03 00 00 85 C0 0F 84 B4 00 00 00 89 85 54 04 00 00 8B C6 EB 5B 8B 85 58 04 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 58 04 00 00 C7 00 20 20 20 00 EB 06 FF B5 58 04 00 00 FF B5 54 04 00 00 FF 95 CD 03 00 00 85 C0 74 71 89 07 83 C7 04 8B 85 58 04 00 00 EB 01 40 80 38 00 75 FA 40 89 85 58 04 00 00 66 81 78 02 00 80 74 A5 80 38 00 75 A0 EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 80 3E 01 0F 85 63 FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 5C 04 00 00 FF 95 D5 03 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v037_v038_Beta_Strip_base_relocation_table_Option_Sign_by_hot_UNP: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v037_v038_Beta_Strip_base_relocation_table_Option_Sign_by_hot_UNP"
        weight = 1
    strings:
        $a = { 52 CC 00 00 00 00 ?? ?? ?? ?? 09 ?? 08 ?? 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TPPpack_clane: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TPPpack_clane"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 5D 81 ED F5 8F 40 00 60 33 ?? E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressor_V1451_CGSoftLabs_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_V1451_CGSoftLabs_SignByfly"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC ?? 53 56 57 83 65 ?? 00 F3 EB 0C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A1 ?? ?? ?? ?? 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? B9 ?? ?? ?? ?? 2B 48 18 89 ?? ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 74 16 A1 ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 03 48 14 89 4D ?? E9 ?? ?? ?? ?? C7 05 }
        $b = { 55 8B EC 83 EC ?? 53 56 57 83 65 ?? 00 F3 EB 0C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A1 ?? ?? ?? ?? 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? B9 ?? ?? ?? ?? 2B 48 18 89 ?? ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 74 16 A1 ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 03 48 14 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Packanoid_v1_Arkanoid: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Packanoid_v1_Arkanoid"
        weight = 1
    strings:
        $a = { BF ?? ?? ?? ?? BE ?? ?? ?? ?? E8 9D 00 00 00 B8 ?? ?? ?? ?? 8B 30 8B 78 04 BB ?? ?? ?? ?? 8B 43 04 91 E3 1F 51 FF D6 56 96 8B 13 8B 02 91 E3 0D 52 51 56 FF D7 5A 89 02 83 C2 04 EB EE 83 C3 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_MEW_11_SE_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_MEW_11_SE_10"
        weight = 1
    strings:
        $a = { E9 09 00 00 00 00 00 00 02 00 00 00 0C 90 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MicroDog_Win32Shell_V4X_SafeNet_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MicroDog_Win32Shell_V4X_SafeNet_SignByfly"
        weight = 1
    strings:
        $a = { 60 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 33 C0 B9 3F ?? ?? ?? F3 AB C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 33 C0 B9 3F ?? ?? ?? F3 AB C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 66 C7 ?? ?? ?? ?? ?? ?? ?? E9 13 09 00 00 ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 ?? ?? 89 ?? ?? 83 ?? ?? ?? 75 05 E9 C1 11 00 00 68 ?? ?? ?? ?? A1 ?? ?? ?? ?? 50 8B ?? ?? 50 E8 ?? ?? ?? ?? 83 ?? ?? A1 ?? ?? ?? ?? 33 ?? ?? ?? ?? ?? 89 ?? ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 89 ?? ?? E9 CE 0E 00 00 E9 36 11 00 00 E9 3D 11 00 00 E9 38 11 00 00 66 ?? ?? ?? ?? ?? EB 04 66 ?? ?? ?? 8B ?? ?? 25 FF FF 00 00 83 ?? ?? 0F 8D DF 00 00 00 8B ?? ?? 25 FF FF 00 00 8B ?? ?? 81 E1 FF FF 00 00 0F AF C1 8B ?? ?? 81 E1 FF FF 00 00 0F AF C1 8B ?? ?? 81 E1 FF FF 00 00 0F AF C1 83 ?? ?? 89 ?? ?? ?? ?? ?? EB 7E }
        $b = { 60 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 33 C0 B9 3F ?? ?? ?? F3 AB C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule FOXSQZ_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FOXSQZ_Archive"
        weight = 1
    strings:
        $a = { 46 4F 58 53 51 5A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPack_Alt_Stub_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPack_Alt_Stub_Dwing"
        weight = 1
    strings:
        $a = { 60 E8 09 00 00 00 C3 F6 00 00 E9 06 02 00 00 33 C9 5E 87 0E E3 F4 2B F1 8B DE AD 2B D8 AD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_096_tE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_096_tE"
        weight = 1
    strings:
        $a = { E9 59 E4 FF FF 00 00 00 00 00 00 00 ?? ?? ?? ?? EE ?? ?? 00 00 00 00 00 00 00 00 00 0E ?? ?? 00 FE ?? ?? 00 F6 ?? ?? 00 00 00 00 00 00 00 00 00 1B ?? ?? 00 06 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 26 ?? ?? 00 00 00 00 00 39 ?? ?? 00 00 00 00 00 26 ?? ?? 00 00 00 00 00 39 ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C }
        $b = { E9 59 E4 FF FF 00 00 00 00 00 00 00 ?? ?? ?? ?? EE ?? ?? 00 00 00 00 00 00 00 00 00 0E ?? ?? 00 FE ?? ?? 00 F6 ?? ?? 00 00 00 00 00 00 00 00 00 1B ?? ?? 00 06 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 26 ?? ?? 00 00 00 00 00 39 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ACProtect_13x_14x_DLL_Risco_Software_Inc: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtect_13x_14x_DLL_Risco_Software_Inc"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPolyX_V01_Delikon: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPolyX_V01_Delikon"
        weight = 1
    strings:
        $a = { E2 ?? FF ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v122: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v122"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 A6 70 40 ?? 01 85 03 70 40 ?? 66 C7 85 ?? 70 40 ?? 90 90 01 85 9E 70 40 ?? BB F3 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_012_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_012_beta_Dwing"
        weight = 1
    strings:
        $a = { BE 48 01 40 00 AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A B5 1C F3 AB AD 50 97 51 AD 87 F5 58 8D 54 86 5C FF D5 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 03 B3 00 8D 1C 5B 8D 9C 9E 0C 10 00 00 B0 01 67 E3 29 8B D7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PC_Guard_for_Win32_v500_SofProBlagoje_Ceklic_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PC_Guard_for_Win32_v500_SofProBlagoje_Ceklic_h"
        weight = 1
    strings:
        $a = { FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 30 D2 40 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 89 85 E1 EA 41 00 9C EB 01 D5 9D EB 01 0B 58 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 89 85 F9 EA 41 00 9C EB 01 D5 9D EB 01 0B 89 9D E5 EA 41 00 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 89 8D E9 EA 41 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 89 95 ED EA 41 00 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 89 B5 F1 EA 41 00 9C EB 01 D5 9D EB 01 0B 89 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressorFullSupport_V1601_CGSoftLabsnbsp_nbsp_SignByfly_20080308: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressorFullSupport_V1601_CGSoftLabsnbsp_nbsp_SignByfly_20080308"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 74 02 00 00 53 56 57 83 A5 C8 FD FF FF 00 F3 EB 0C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A1 ?? ?? ?? ?? 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 40 04 25 ?? ?? ?? ?? 85 C0 74 5C 83 7D 0C 01 75 2A 8B 45 08 A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 75 19 6A 04 68 00 10 00 00 68 20 03 00 00 6A 00 FF ?? ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 7D 0C 00 75 0E 83 3D ?? ?? ?? ?? ?? 74 05 E9 F4 0A 00 00 83 3D ?? ?? ?? ?? ?? 74 05 E9 BB 09 00 00 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 78 60 00 75 1C 6A 10 6A 00 E8 E8 19 00 00 59 50 6A 01 E8 DF 19 00 00 59 50 6A 00 FF 15 ?? ?? ?? ?? E8 27 FF FF FF A3 ?? ?? ?? ?? 6A 04 68 00 10 00 00 68 80 00 00 00 6A 00 FF 15 ?? ?? ?? ?? 89 85 E8 FD FF FF 68 04 01 00 00 8D 85 F0 FD FF FF 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 84 05 EF FD FF FF 89 85 D4 FD FF FF 8B 85 D4 FD FF FF 0F BE 00 83 F8 5C 74 0F 8B 85 D4 FD FF FF 48 89 85 D4 FD FF FF EB E3 8B 85 D4 FD FF FF 40 89 85 D4 FD FF FF 8B 85 D4 FD FF FF 8D 8D F0 FD FF FF 2B C1 89 85 AC FD FF FF 8B 8D AC FD FF FF 8D B5 F0 FD FF FF 8D BD FC FE FF FF 8B C1 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 8B 85 AC FD FF FF 80 A4 05 FD FE FF FF 00 83 A5 D8 FD FF FF 00 A1 ?? ?? ?? ?? 8B 40 04 25 ?? ?? ?? ?? 85 C0 75 11 A1 ?? ?? ?? ?? 8B 40 04 25 ?? ?? ?? ?? 85 C0 74 43 E8 11 0C 00 00 89 85 D8 FD FF FF A1 ?? ?? ?? ?? 8B 40 04 25 ?? ?? ?? ?? 85 C0 74 27 83 BD D8 FD FF FF 00 74 1E 6A 10 FF B5 D4 FD FF FF 6A 18 E8 C3 18 00 00 59 50 6A 00 FF 15 ?? ?? ?? ?? E9 8F 09 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v60_SPx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v60_SPx"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC 44 56 FF 15 ?? ?? ?? ?? 6A 01 8B F0 FF 15 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yC_v13_by_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yC_v13_by_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC C0 00 00 00 53 56 57 8D BD 40 FF FF FF B9 30 00 00 00 B8 CC CC CC CC F3 AB 60 E8 00 00 00 00 5D 81 ED 84 52 41 00 B9 75 5E 41 00 81 E9 DE 52 41 00 8B D5 81 C2 DE 52 41 00 8D 3A 8B F7 33 C0 EB 04 90 EB 01 C2 AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_PECompact_14x_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_PECompact_14x_emadicius"
        weight = 1
    strings:
        $a = { 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 30 40 00 87 DD 83 BD 9C 38 40 00 01 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Gotcha879: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Gotcha879"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5B 81 EB ?? ?? 9C FC 2E ?? ?? ?? ?? ?? ?? ?? 8C D8 05 ?? ?? 2E ?? ?? ?? ?? 50 2E ?? ?? ?? ?? ?? ?? 8B C3 05 ?? ?? 8B F0 BF 00 01 B9 20 00 F3 A4 0E B8 00 01 50 B8 DA DA CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_420_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_420_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 F8 8E 4C 00 68 F0 EA 49 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4C 00 33 D2 8A D4 89 15 84 A5 4C 00 8B C8 81 E1 FF 00 00 00 89 0D 80 A5 4C 00 C1 E1 08 03 CA 89 0D 7C A5 4C 00 C1 E8 10 A3 78 A5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v100: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v100"
        weight = 1
    strings:
        $a = { E9 E5 E2 FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Cpp_for_Win32_1994: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Cpp_for_Win32_1994"
        weight = 1
    strings:
        $a = { A1 ?? ?? ?? ?? C1 ?? ?? A3 ?? ?? ?? ?? 83 ?? ?? ?? ?? 75 ?? 57 51 33 C0 BF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Cpp_for_Win32_1995: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Cpp_for_Win32_1995"
        weight = 1
    strings:
        $a = { A1 ?? ?? ?? ?? C1 ?? ?? A3 ?? ?? ?? ?? 57 51 33 C0 BF ?? ?? ?? ?? B9 ?? ?? ?? ?? 3B CF 76 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ActiveMARKTM: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ActiveMARKTM"
        weight = 1
    strings:
        $a = { 79 11 7F AB 9A 4A 83 B5 C9 6B 1A 48 F9 27 B4 25 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule GEM_Image_graphics_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID GEM_Image_graphics_file"
        weight = 1
    strings:
        $a = { 00 01 00 08 00 04 00 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DrHalo_or_DrGenius_Image_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DrHalo_or_DrGenius_Image_Graphics_format"
        weight = 1
    strings:
        $a = { ?? ?? 3A 03 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Cpp_for_Win32_1999: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Cpp_for_Win32_1999"
        weight = 1
    strings:
        $a = { EB 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 18 00 00 00 8B C5 55 60 9C 2B 85 E9 06 00 00 89 85 E1 06 00 00 FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24 03 00 00 89 85 D9 41 00 00 68 EC 49 7B 79 33 C0 50 E8 11 03 00 00 89 85 D1 41 00 00 E8 67 05 00 00 E9 56 05 00 00 51 52 53 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 D8 73 09 66 35 20 83 66 81 F3 B8 ED FE CE 75 EB 33 C8 33 D3 4F 75 D5 F7 D2 F7 D1 5B 8B C2 C1 C0 10 66 8B C1 5A 59 C3 68 03 02 00 00 E8 80 04 00 00 0F 82 A8 02 00 00 96 8B 44 24 04 0F C8 8B D0 25 0F 0F 0F 0F 33 D0 C1 C0 08 0B C2 8B D0 25 33 33 33 33 33 D0 C1 C0 04 0B C2 8B D0 25 55 55 55 55 33 D0 C1 C0 02 0B C2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MingWin32_GCC_3x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MingWin32_GCC_3x"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 ?? 00 00 00 FF 15 ?? ?? 40 00 E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pohernah_103_by_Kas: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pohernah_103_by_Kas"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 2A 27 40 00 31 C0 40 83 F0 06 40 3D 40 1F 00 00 75 07 BE 6A 27 40 00 EB 02 EB EB 8B 85 9E 28 40 00 83 F8 01 75 17 31 C0 01 EE 3D 99 00 00 00 74 0C 8B 8D 86 28 40 00 30 0E 40 46 EB ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 56 57 4F F7 D7 21 FE 89 F0 5F 5E C3 60 83 F0 05 40 90 48 83 F0 05 89 C6 89 D7 60 E8 0B 00 00 00 61 83 C7 08 83 E9 07 E2 F1 61 C3 57 8B 1F 8B 4F 04 68 B9 79 37 9E 5A 42 89 D0 48 C1 E0 05 BF 20 00 00 00 4A 89 DD C1 E5 04 29 E9 8B 6E 08 31 DD 29 E9 89 DD C1 ED 05 31 C5 29 E9 2B 4E 0C 89 CD C1 E5 04 29 EB 8B 2E 31 CD 29 EB 89 CD C1 ED 05 31 C5 29 EB 2B 5E 04 29 D0 4F 75 C8 5F 89 1F 89 4F 04 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule aPack_v098b_exe: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID aPack_v098b_exe"
        weight = 1
    strings:
        $a = { 93 07 1F 05 ?? ?? 8E D0 BC ?? ?? EA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Alias_PIXVivid_IMG_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Alias_PIXVivid_IMG_Graphics_format"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? 00 00 ?? ?? 00 18 ?? ?? ?? ?? 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Phoenix927: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Phoenix927"
        weight = 1
    strings:
        $a = { E8 00 00 5E 81 C6 ?? ?? BF 00 01 B9 04 00 F3 A4 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Video_Lan_Client: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Video_Lan_Client"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 90 90 90 90 90 90 90 90 90 90 90 90 90 90 01 FF FF 01 01 01 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 00 01 00 01 90 90 00 01 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule GHF_Protector_pack_only_GPcH: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID GHF_Protector_pack_only_GPcH"
        weight = 1
    strings:
        $a = { 60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 68 00 00 00 00 6A 40 FF D0 89 05 ?? ?? ?? ?? 89 C7 BE ?? ?? ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3 31 C9 41 E8 EE FF FF FF 11 C9 E8 E7 FF FF FF 72 F2 C3 61 B9 FC FF FF FF 8B 1C 08 89 99 ?? ?? ?? ?? E2 F5 90 90 BA ?? ?? ?? ?? BE ?? ?? ?? ?? 01 D6 8B 46 0C 85 C0 0F 84 87 00 00 00 01 D0 89 C3 50 B8 ?? ?? ?? ?? FF 10 85 C0 75 08 53 B8 ?? ?? ?? ?? FF 10 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 BA ?? ?? ?? ?? 8B 06 85 C0 75 03 8B 46 10 01 D0 03 05 ?? ?? ?? ?? 8B 18 8B 7E 10 01 D7 03 3D ?? ?? ?? ?? 85 DB 74 2B F7 C3 00 00 00 80 75 04 01 D3 43 43 81 E3 FF FF FF 0F 53 FF 35 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 89 07 83 05 ?? ?? ?? ?? 04 EB AE 83 C6 14 BA ?? ?? ?? ?? E9 6E FF FF FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 8B 15 ?? ?? ?? ?? 52 FF D0 61 BA ?? ?? ?? ?? FF E2 90 C3 }
        $b = { 60 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF 10 68 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? FF 10 68 00 A0 00 00 6A 40 FF D0 89 05 ?? ?? ?? ?? 89 C7 BE ?? ?? ?? ?? 60 FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Upack_v032_Beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v032_Beta_Dwing"
        weight = 1
    strings:
        $a = { BE 88 01 ?? ?? AD 50 ?? ?? AD 91 F3 A5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_041_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_041_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 90 90 90 FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeJoiner_Small_build_017_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeJoiner_Small_build_017_GlOFF"
        weight = 1
    strings:
        $a = { E8 0E FE FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00 }
        $b = { 55 8B EC 83 C4 F0 86 FF 86 DB 86 FF 68 00 01 00 00 68 18 20 40 00 6A 00 E8 FF 01 00 00 8A E4 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 18 20 40 00 E8 D5 01 00 00 A3 00 20 40 00 40 0F 84 97 01 00 00 8A E4 6A 02 6A 00 6A FB FF 35 00 20 40 00 E8 E0 01 00 00 86 FF 86 DB 86 FF 6A 00 8D 45 FC 50 6A 04 8D 45 F8 50 FF 35 00 20 40 00 E8 BD 01 00 00 8A E4 6A 00 8D 45 FC 50 6A 01 8D 45 F3 50 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule NeoLite_v200: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NeoLite_v200"
        weight = 1
    strings:
        $a = { E9 ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_098_tE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_098_tE"
        weight = 1
    strings:
        $a = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? 1E ?? ?? 00 00 00 00 00 00 00 00 00 3E ?? ?? 00 2E ?? ?? 00 26 ?? ?? 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 36 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 56 ?? ?? 00 00 00 00 00 69 ?? ?? 00 00 00 00 00 56 ?? ?? 00 00 00 00 00 69 ?? ?? 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 75 73 65 }
        $b = { E9 25 E4 FF FF 00 00 00 ?? ?? ?? ?? 1E ?? ?? 00 00 00 00 00 00 00 00 00 3E ?? ?? 00 2E ?? ?? 00 26 ?? ?? 00 00 00 00 00 00 00 00 00 4B ?? ?? 00 36 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 56 ?? ?? 00 00 00 00 00 69 ?? ?? 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PE_Armor_0460_0759_hying: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Armor_0460_0759_hying"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V10_cyberbobnbsp_nbsp_SignByfly_20080312: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V10_cyberbobnbsp_nbsp_SignByfly_20080312"
        weight = 1
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 C8 DC 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 ?? ?? ?? ?? ?? ?? ?? C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 EB 04 ?? EB 04 ?? EB FB FF 8B ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? EB 02 ?? ?? F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 ?? ?? ?? ?? 83 04 24 0C C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule kryptor_3: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID kryptor_3"
        weight = 1
    strings:
        $a = { EB 66 87 DB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule kryptor_6: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID kryptor_6"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED 94 73 42 00 8B D5 81 C2 E3 73 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 BF A4 42 00 81 E9 8E 74 42 00 8B D5 81 C2 8E 74 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 63 29 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 9C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule kryptor_5: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID kryptor_5"
        weight = 1
    strings:
        $a = { E8 03 ?? ?? ?? E9 EB 68 58 33 D2 74 02 E9 E9 40 42 75 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule kryptor_9: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID kryptor_9"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5E B9 ?? ?? ?? ?? 2B C0 02 04 0E D3 C0 49 79 F8 41 8D 7E 2C 33 46 ?? 66 B9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule kryptor_8: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID kryptor_8"
        weight = 1
    strings:
        $a = { EB 6A 87 DB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ORiEN_V1X_V2X_Fisun_AV_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ORiEN_V1X_V2X_Fisun_AV_Sign_by_fly"
        weight = 1
    strings:
        $a = { E9 5D 01 00 00 CE D1 CE ?? 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_C_for_Windows_2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_C_for_Windows_2"
        weight = 1
    strings:
        $a = { 8C D8 ?? 45 55 8B EC 1E 8E D8 57 56 89 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Duals_eXe_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Duals_eXe_10"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E 00 00 00 8D 85 08 03 00 00 89 28 33 FF 8D 85 7D 02 00 00 8D 8D 08 03 00 00 2B C8 8B 9D 58 03 00 00 E8 1C 02 00 00 8D 9D 61 02 00 00 8D B5 7C 02 00 00 46 80 3E 00 74 24 56 FF 95 0A 04 00 00 46 80 3E 00 75 FA 46 80 3E 00 74 E7 50 56 50 FF 95 0E 04 00 00 89 03 58 83 C3 04 EB E3 8D 85 24 03 00 00 50 68 1F 00 02 00 6A 00 8D 85 48 03 00 00 50 68 01 00 00 80 FF 95 69 02 00 00 83 BD 24 03 00 00 00 0F 84 8B 00 00 00 C7 85 28 03 00 00 04 00 00 00 8D 85 28 03 00 00 50 8D 85 20 03 00 00 50 8D 85 6C 03 00 00 50 6A 00 8D 85 62 03 00 00 50 FF B5 24 03 00 00 FF 95 71 02 00 00 83 BD 20 03 00 00 01 7E 02 EB 20 6A 40 8D 85 73 03 00 00 50 8D 85 82 03 00 00 50 6A 00 FF 95 61 02 00 00 6A 00 FF 95 65 02 00 00 FF 8D 20 03 00 00 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Imaging_Technology_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Imaging_Technology_Graphics_format"
        weight = 1
    strings:
        $a = { 49 4D 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AdFlt2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AdFlt2"
        weight = 1
    strings:
        $a = { 68 00 01 9C 0F A0 0F A8 60 FD 6A 00 0F A1 BE ?? ?? AD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Inno_Setup_Module_v5: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Inno_Setup_Module_v5"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 CC 53 56 57 33 C0 89 45 F0 89 45 DC E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? ?? FF FF E8 ?? F3 FF FF E8 ?? F4 FF FF 33 C0 55 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TXT2COM_v206: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TXT2COM_v206"
        weight = 1
    strings:
        $a = { 8D 26 ?? ?? E8 ?? ?? B8 ?? ?? CD 21 CD 20 54 58 54 32 43 4F 4D 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v039_final_Sign_by_hot_UNP: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v039_final_Sign_by_hot_UNP"
        weight = 1
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 39 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SoftDefender_1x_Randy_Li: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SoftDefender_1x_Randy_Li"
        weight = 1
    strings:
        $a = { 74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD 00 59 9C 50 74 0A 75 08 E8 59 C2 04 00 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 E6 01 00 00 03 C8 74 BD 75 BB E8 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VMProtect_07x_08_PolyTech: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VMProtect_07x_08_PolyTech"
        weight = 1
    strings:
        $a = { 5B 20 56 4D 50 72 6F 74 65 63 74 20 76 20 30 2E 38 20 28 43 29 20 50 6F 6C 79 54 65 63 68 20 5D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v01x_v02x_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v01x_v02x_Dwing"
        weight = 1
    strings:
        $a = { BE 88 01 ?? ?? AD 8B F8 95 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_120_Basic_Edition_aPLib: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_120_Basic_Edition_aPLib"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 92 05 00 00 EB 0C 8B 85 8E 05 00 00 89 85 92 05 00 00 8D B5 BA 05 00 00 8D 9D 41 04 00 00 33 FF E8 38 01 00 00 EB 1B 8B 85 92 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 9E 05 00 00 00 74 0E 83 BD A2 05 00 00 00 74 05 E8 D6 01 00 00 }
        $b = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 92 05 00 00 EB 0C 8B 85 8E 05 00 00 89 85 92 05 00 00 8D B5 BA 05 00 00 8D 9D 41 04 00 00 33 FF E8 38 01 00 00 EB 1B 8B 85 92 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule DiskDupe_c_MSD_Configuration_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DiskDupe_c_MSD_Configuration_file"
        weight = 1
    strings:
        $a = { 4D 53 44 20 44 61 74 61 20 56 65 72 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Dev_Cpp_v4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Dev_Cpp_v4"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 83 C4 F4 6A ?? A1 ?? ?? ?? 00 FF D0 E8 ?? FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_EXE32Pack_13x_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_EXE32Pack_13x_emadicius"
        weight = 1
    strings:
        $a = { 3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC 56 3B D2 74 02 81 85 57 E8 00 00 00 00 3B DB 74 01 90 83 C4 14 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_V13_LiuXingPing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_V13_LiuXingPing"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PROTECT_EXECOM_v50: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PROTECT_EXECOM_v50"
        weight = 1
    strings:
        $a = { 1E 0E 0E 1F 07 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_V21X_SoftCompletecom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_V21X_SoftCompletecom"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 4C 01 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 32 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule InstallShield_Cabinet_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID InstallShield_Cabinet_Archive"
        weight = 1
    strings:
        $a = { 49 53 63 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Eddie2000: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Eddie2000"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5E 81 EE ?? ?? FC 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 4D 5A ?? ?? FA 8B E6 81 C4 ?? ?? FB 3B ?? ?? ?? ?? ?? 50 06 56 1E 8B FE 33 C0 50 8E D8 C5 ?? ?? ?? B4 30 CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V119_Dll_LZMA_430_ap0x_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V119_Dll_LZMA_430_ap0x_SignByfly"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 C7 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76 01 00 00 EB 20 60 8B 85 49 0B 00 00 FF B5 41 0B 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD 55 0B 00 00 00 74 0E 83 BD 59 0B 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 DA 0A 00 00 89 85 69 0B 00 00 5B 60 FF B5 41 0B 00 00 56 FF B5 69 0B 00 00 FF D3 61 8B B5 69 0B 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 49 0B 00 00 83 C0 04 89 85 65 0B 00 00 E9 98 00 00 00 56 FF 95 D2 0A 00 00 89 85 61 0B 00 00 85 C0 0F 84 C8 00 00 00 8B C6 EB 5F 8B 85 65 0B 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 65 0B 00 00 C7 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule KGB_SFX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID KGB_SFX"
        weight = 1
    strings:
        $a = { 60 BE 00 A0 46 00 8D BE 00 70 F9 FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FIDO_mail_packet: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FIDO_mail_packet"
        weight = 1
    strings:
        $a = { 03 00 03 00 CD 07 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_1031_Ashkibiz_Danehlar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_1031_Ashkibiz_Danehlar"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED 74 72 42 00 8B D5 81 C2 C3 72 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 3F A9 42 00 81 E9 6E 73 42 00 8B D5 81 C2 6E 73 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 98 2E 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v042: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v042"
        weight = 1
    strings:
        $a = { C1 EE 00 66 8B C9 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 52 8B FE 68 79 01 59 EB 01 EB AC 54 E8 03 5C EB 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Spin_v0b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Spin_v0b"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 72 C8 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 26 E8 01 00 00 00 EA 5A 33 C9 8B 95 68 20 40 00 8B 42 3C 03 C2 89 85 76 20 40 00 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 9D 8A 20 40 00 8B 59 24 03 DA 8B 1B 89 9D 8E 20 40 00 53 8F 85 E2 1F 40 00 8D 85 92 20 40 00 6A 0C 5B 6A 17 59 30 0C 03 02 CB 4B 75 F8 40 8D 9D 41 8F 4E 00 50 53 81 2C 24 01 78 0E 00 FF B5 8A 20 40 00 C3 92 EB 15 68 BB ?? 00 00 00 B9 90 08 00 00 8D BD FF 20 40 00 4F 30 1C 39 FE CB E2 F9 68 1D 01 00 00 59 8D BD 2F 28 40 00 C0 0C 39 02 E2 FA 68 A0 20 40 00 50 01 6C 24 04 E8 BD 09 00 00 33 C0 0F 84 C0 08 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DrWeb_Virus_Finding_Engine_InSoft_EDV_Systeme: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DrWeb_Virus_Finding_Engine_InSoft_EDV_Systeme"
        weight = 1
    strings:
        $a = { B8 01 00 00 00 C2 0C 00 8D 80 00 00 00 00 8B D2 8B ?? 24 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PseudoSigner_01_Anorganix: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PseudoSigner_01_Anorganix"
        weight = 1
    strings:
        $a = { 55 8B EC B9 04 00 00 00 6A 00 6A 00 49 75 F9 51 53 ?? ?? ?? ?? 10 E8 2D F3 FF FF 33 C0 55 68 E8 31 00 10 64 FF 30 64 89 20 8D 45 E0 E8 53 F5 FF FF 8B 45 E0 8D 55 E4 E8 30 F6 FF FF 8B 45 E4 8D 55 E8 E8 A9 F4 FF FF 8B 45 E8 8D 55 EC E8 EE F7 FF FF 8B 55 EC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v1xx_v2xx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v1xx_v2xx"
        weight = 1
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Shield_V06_SMoKE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Shield_V06_SMoKE"
        weight = 1
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED D4 1A 40 00 EB 01 00 8D B5 5E 1B 40 00 BA A1 0B 00 00 EB 01 00 8D 8D FF 26 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Krypton_v02: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Krypton_v02"
        weight = 1
    strings:
        $a = { 8B 0C 24 E9 0A 7C 01 ?? AD 42 40 BD BE 9D 7A 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WATCOM_CCpp_32_Run_Time_System_1988_1995: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WATCOM_CCpp_32_Run_Time_System_1988_1995"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? ?? ?? ?? ?? 57 41 54 43 4F 4D 20 43 2F 43 2B 2B 33 32 20 52 75 6E 2D 54 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WATCOM_CCpp_32_Run_Time_System_1988_1994: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WATCOM_CCpp_32_Run_Time_System_1988_1994"
        weight = 1
    strings:
        $a = { FB 83 ?? ?? 89 E3 89 ?? ?? ?? ?? ?? 89 ?? ?? ?? ?? ?? 66 ?? ?? ?? 66 ?? ?? ?? ?? ?? BB ?? ?? ?? ?? 29 C0 B4 30 CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Can2Exe_v001: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Can2Exe_v001"
        weight = 1
    strings:
        $a = { 0E 1F 0E 07 E8 ?? ?? E8 ?? ?? 3A C6 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FixupPak_v120: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FixupPak_v120"
        weight = 1
    strings:
        $a = { 55 E8 00 00 00 00 5D 81 ED ?? ?? 00 00 BE 00 ?? 00 00 03 F5 BA 00 00 ?? ?? 2B D5 8B DD 33 C0 AC 3C 00 74 3D 3C 01 74 0E 3C 02 74 0E 3C 03 74 0D 03 D8 29 13 EB E7 66 AD EB F6 AD EB F3 AC 0F B6 C8 3C 00 74 06 3C 01 74 09 EB 0A 66 AD 0F B7 C8 EB 03 AD 8B C8 AC 0F B6 C0 03 D8 29 13 E2 FA EB BC 8D 85 ?? ?? 00 00 5D FF E0 00 00 00 00 08 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Krypton_v05: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Krypton_v05"
        weight = 1
    strings:
        $a = { 55 50 E8 ?? ?? ?? ?? 5D EB 01 E3 60 E8 03 ?? ?? ?? D2 EB 0B 58 EB 01 48 40 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Krypton_v04: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Krypton_v04"
        weight = 1
    strings:
        $a = { 54 E8 ?? ?? ?? ?? 5D 8B C5 81 ED 61 34 ?? ?? 2B 85 60 37 ?? ?? 83 E8 06 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule KByS_V028_shoooo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID KByS_V028_shoooo"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_2403_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_2403_Jitit"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 56 57 33 C0 89 45 F0 B8 48 D2 4B 00 E8 BC 87 F4 FF BB 04 0B 4D 00 33 C0 55 68 E8 D5 4B 00 64 FF 30 64 89 20 E8 9C F4 FF FF E8 F7 FB FF FF 6A 40 8D 55 F0 A1 F0 ED 4B 00 8B 00 E8 42 2E F7 FF 8B 4D F0 B2 01 A1 F4 C2 40 00 E8 F7 20 F5 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeSplitter_12_Bill_Prisoner_TPOC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeSplitter_12_Bill_Prisoner_TPOC"
        weight = 1
    strings:
        $a = { E9 95 02 00 00 64 A1 00 00 00 00 83 38 FF 74 04 8B 00 EB F7 8B 40 04 C3 55 8B EC B8 00 00 00 00 8B 75 08 81 E6 00 00 FF FF B9 06 00 00 00 56 56 E8 B0 00 00 00 5E 83 F8 01 75 06 8B C6 C9 C2 04 00 81 EE 00 00 01 00 E2 E5 C9 C2 04 00 55 8B EC 8B 75 0C 8B DE 03 76 3C 8D 76 18 8D 76 60 8B 36 03 F3 56 8B 76 20 03 F3 33 D2 8B C6 8B 36 03 F3 8B 7D 08 B9 0E 00 00 00 FC F3 A6 0B C9 75 02 EB 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_v20"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 0A ?? ?? ?? B8 ?? ?? ?? ?? C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_packer_03: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_packer_03"
        weight = 1
    strings:
        $a = { 06 1E 57 56 50 53 51 52 BD ?? ?? 0E 1F 8C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Kuku448: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Kuku448"
        weight = 1
    strings:
        $a = { AE 75 ED E2 F8 89 3E ?? ?? BA ?? ?? 0E 07 BF ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Joiner_sign_from_pinch_25032007_2010: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Joiner_sign_from_pinch_25032007_2010"
        weight = 1
    strings:
        $a = { 0F C8 0F CF C6 C4 8B 0F AC EA 99 0F AD D8 13 F5 0F BD EF 85 EF 85 DA 69 FE ?? ?? ?? ?? 21 F9 BE ?? ?? ?? ?? 23 CF 0F BC FE D2 DC 85 EF B9 ?? ?? ?? ?? C6 C0 F7 8D 35 ?? ?? ?? ?? 8D 0D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v131_Eng_dulekxt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v131_Eng_dulekxt"
        weight = 1
    strings:
        $a = { BB ?? ?? BA ?? ?? 81 C3 07 00 B8 40 B4 B1 04 D3 E8 03 C3 8C D9 49 8E C1 26 03 0E 03 00 2B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_V22X_softcompletecom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_V22X_softcompletecom"
        weight = 1
    strings:
        $a = { FF E0 E8 04 00 00 00 FF FF FF FF 5E C3 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_13017_Obsidium_software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_13017_Obsidium_software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 28 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 25 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SEA_AXE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SEA_AXE"
        weight = 1
    strings:
        $a = { FC BC ?? ?? 0E 1F A3 ?? ?? E8 ?? ?? A1 ?? ?? 8B ?? ?? ?? 2B C3 8E C0 B1 03 D3 E3 8B CB BF ?? ?? 8B F7 F3 A5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_dulekxt_Microsoft_Visual_Cpp_60_70: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_dulekxt_Microsoft_Visual_Cpp_60_70"
        weight = 1
    strings:
        $a = { F7 DB 80 EA BF B9 2F 40 67 BA EB 01 01 68 AF ?? A7 BA 80 EA 9D 58 C1 C2 09 2B C1 8B D7 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WWPACK_v300_v301_Extractable: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WWPACK_v300_v301_Extractable"
        weight = 1
    strings:
        $a = { B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 6A ?? 06 06 8C D3 83 ?? ?? 53 6A ?? FC }
        $b = { 55 8B EC 81 EC ?? ?? 00 00 53 56 57 6A 01 5E 6A 04 89 75 E8 FF 15 ?? 40 40 00 FF 15 ?? 40 40 00 8B F8 89 7D ?? 8A 07 3C 22 0F 85 ?? 00 00 00 8A 47 01 47 89 7D ?? 33 DB 3A C3 74 0D 3C 22 74 09 8A 47 01 47 89 7D ?? EB EF 80 3F 22 75 04 47 89 7D ?? 80 3F 20 75 09 47 80 3F 20 74 FA 89 7D ?? 53 FF 15 ?? 40 40 00 80 3F 2F 89 45 ?? 75 ?? 8A 47 01 3C 53 74 04 3C 73 75 06 89 35 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule App_Encryptor_Silent_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID App_Encryptor_Silent_Team"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 1F 1F 40 00 B9 7B 09 00 00 8D BD 67 1F 40 00 8B F7 AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Inno_Setup_Module: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Inno_Setup_Module"
        weight = 1
    strings:
        $a = { 49 6E 6E 6F 53 65 74 75 70 4C 64 72 57 69 6E 64 6F 77 00 00 53 54 41 54 49 43 }
        $b = { 55 8B EC 83 C4 B8 53 56 57 33 C0 89 45 F0 89 45 BC 89 45 B8 E8 B3 70 FF FF E8 1A 85 FF FF E8 25 A7 FF FF E8 6C }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Microsoft_Visual_Cpp_70: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_70"
        weight = 1
    strings:
        $a = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 40 89 45 E4 8B 75 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_71: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_71"
        weight = 1
    strings:
        $a = { 8B FF 55 8B EC 56 33 F6 39 75 0C 75 0E 39 35 ?? ?? ?? ?? 7E 2D FF 0D ?? ?? ?? ?? 83 7D 0C 01 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 75 3D 68 80 00 00 00 FF 15 ?? ?? ?? ?? 3B C6 59 A3 ?? ?? ?? ?? 75 04 33 C0 EB 67 89 30 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 }
        $b = { 8B FF 55 8B EC 56 33 F6 39 75 0C 0F 84 ?? ?? ?? ?? 83 7D 0C 01 A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 68 80 00 00 00 FF 15 ?? ?? ?? ?? 3B C6 59 A3 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 89 30 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? 59 59 33 C0 40 5E 5D C2 0C 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Armadillo_36x_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_36x_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 33 FF 47 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 EB 87 ?? 7A F0 ?? ?? 61 8B 9C BD AB 76 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_239_compressed_resources_wwwstrongbitcom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_239_compressed_resources_wwwstrongbitcom"
        weight = 1
    strings:
        $a = { CC ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? B4 ?? ?? ?? 08 ?? ?? ?? 00 00 00 00 FF FF FF FF E8 ?? ?? ?? 04 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1336_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1336_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? ?? ?? ?? ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 26 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? C3 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 50 EB 01 ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 01 ?? EB 03 ?? ?? ?? 58 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_105b_by: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_105b_by"
        weight = 1
    strings:
        $a = { 75 00 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule codeCrypter_031: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID codeCrypter_031"
        weight = 1
    strings:
        $a = { 50 58 53 5B 90 BB ?? ?? 40 00 FF E3 90 CC CC CC 55 8B EC 5D C3 CC CC CC CC CC CC CC CC CC CC CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Splash_Bitmap_v100_BoB_Bobsoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Splash_Bitmap_v100_BoB_Bobsoft"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 60 8B 6C 24 20 55 81 ED ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 29 F9 31 C0 FC F3 AA 8B 04 24 48 66 25 00 F0 66 81 38 4D 5A 75 F4 8B 48 3C 81 3C 01 50 45 00 00 75 E8 89 85 ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 6A 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_3035_Jtit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_3035_Jtit"
        weight = 1
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 28 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3 A4 5E E9 F0 FE FF FF 33 C0 EB 05 8B C7 2B 45 0C 5E 5F 5B C9 C2 08 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 C3 B9 08 00 00 00 E8 01 00 00 00 C3 33 C0 E8 E1 FF FF FF 13 C0 E2 F7 C3 33 C9 41 E8 D4 FF FF FF 13 C9 E8 CD FF FF FF 72 F2 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v104b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v104b"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5 2B 85 ?? 12 9D ?? 89 85 1E 9D ?? ?? 80 BD 08 9D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SoftProtect_SoftProtectbyru: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SoftProtect_SoftProtectbyru"
        weight = 1
    strings:
        $a = { E8 0C 15 00 00 8D 85 2F 14 00 00 C7 00 00 00 00 00 E8 29 0F 00 00 E8 F6 14 00 00 8D 85 20 01 00 00 50 E8 AA 16 00 00 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Symantec_C_v400_p_Libraries: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Symantec_C_v400_p_Libraries"
        weight = 1
    strings:
        $a = { FA B8 ?? ?? DB E3 8E D8 8C 06 ?? ?? 8B D8 2B 1E ?? ?? 89 1E ?? ?? 26 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_10b_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_10b_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 4C 32 40 00 E8 03 00 00 00 EB 01 ?? B9 EA 47 40 00 81 E9 E9 32 40 00 8B D5 81 C2 E9 32 40 00 8D 3A 8B F7 33 C0 E8 04 00 00 00 90 EB 01 ?? E8 03 00 00 00 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_CodeSafe_20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_CodeSafe_20"
        weight = 1
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0B 83 EC 10 53 56 57 E8 C4 01 00 85 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_131_dulekxt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_131_dulekxt"
        weight = 1
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 BB ?? ?? ?? 00 B2 80 A4 B6 80 FF D3 73 F9 33 C9 FF D3 73 16 33 C0 FF D3 73 23 B6 80 41 B0 10 FF D3 12 C0 73 FA 75 42 AA EB E0 E8 46 00 00 00 02 F6 83 D9 01 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 48 13 C9 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_encryptor_2_PK7Tjrvx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_encryptor_2_PK7Tjrvx"
        weight = 1
    strings:
        $a = { 06 B4 52 CD 21 07 E8 ?? ?? B4 62 CD 21 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Petite_v21_1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Petite_v21_1"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 ?? ?? ?? ?? ?? ?? 64 ?? ?? ?? ?? ?? ?? 66 9C 60 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CAN2EXE_v001: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CAN2EXE_v001"
        weight = 1
    strings:
        $a = { 26 8E 06 ?? ?? B9 ?? ?? 33 C0 8B F8 F2 AE E3 ?? 26 38 05 75 ?? EB ?? E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_MEW_11_SE_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_MEW_11_SE_10"
        weight = 1
    strings:
        $a = { E9 09 00 00 00 00 00 00 02 00 00 00 0C 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEBundle_v02_v20x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEBundle_v02_v20x"
        weight = 1
    strings:
        $a = { 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB ?? ?? 40 ?? 87 DD 6A 04 68 ?? 10 ?? ?? 68 ?? 02 ?? ?? 6A ?? FF 95 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Crunch_5_Fusion_4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Crunch_5_Fusion_4"
        weight = 1
    strings:
        $a = { EB 15 03 ?? ?? ?? 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 55 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SDC_12_Self_Decrypting_Binary_Generator_by_Claes_M_Nyberg: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SDC_12_Self_Decrypting_Binary_Generator_by_Claes_M_Nyberg"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 A0 91 40 00 E8 DB FE FF FF 55 89 E5 53 83 EC 14 8B 45 08 8B 00 8B 00 3D 91 00 00 C0 77 3B 3D 8D 00 00 C0 72 4B BB 01 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 08 00 00 00 E8 CE 24 00 00 83 F8 01 0F 84 C4 00 00 00 85 C0 0F 85 A9 00 00 00 31 C0 83 C4 14 5B 5D C2 04 00 3D 94 00 00 C0 74 56 3D 96 00 00 C0 74 1E 3D 93 00 00 C0 75 E1 EB B5 3D 05 00 00 C0 8D B4 26 00 00 00 00 74 43 3D 1D 00 00 C0 75 CA C7 44 24 04 00 00 00 00 C7 04 24 04 00 00 00 E8 73 24 00 00 83 F8 01 0F 84 99 00 00 00 85 C0 74 A9 C7 04 24 04 00 00 00 FF D0 B8 FF FF FF FF EB 9B 31 DB 8D 74 26 00 E9 69 FF FF FF C7 44 24 04 00 00 00 00 C7 04 24 0B 00 00 00 E8 37 24 00 00 83 F8 01 74 7F 85 C0 0F 84 6D FF FF FF C7 04 24 0B 00 00 00 8D 76 00 FF D0 B8 FF FF FF FF E9 59 FF FF FF C7 04 24 08 00 00 00 FF D0 B8 FF FF FF FF E9 46 FF FF FF C7 44 24 04 01 00 00 00 C7 04 24 08 00 00 00 E8 ED 23 00 00 B8 FF FF FF FF 85 DB 0F 84 25 FF FF FF E8 DB 15 00 00 B8 FF FF FF FF E9 16 FF FF FF C7 44 24 04 01 00 00 00 C7 04 24 04 00 00 00 E8 BD 23 00 00 B8 FF FF FF FF E9 F8 FE FF FF C7 44 24 04 01 00 00 00 C7 04 24 0B 00 00 00 E8 9F 23 00 00 B8 FF FF FF FF E9 DA FE FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Resource_Cursors_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Resource_Cursors_file"
        weight = 1
    strings:
        $a = { 00 00 02 00 01 00 20 20 00 00 ?? 00 ?? 00 E8 02 00 00 16 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HACKSTOP_v111c: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HACKSTOP_v111c"
        weight = 1
    strings:
        $a = { B4 30 CD 21 86 E0 3D ?? ?? 73 ?? B4 ?? CD 21 B0 ?? B4 4C CD 21 53 BB ?? ?? 5B EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Crypter_31_SLESH: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Crypter_31_SLESH"
        weight = 1
    strings:
        $a = { 68 FF 64 24 F0 68 58 58 58 58 FF D4 50 8B 40 F2 05 B0 95 F6 95 0F 85 01 81 BB FF 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Crunch_5_Bit_Arts: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Crunch_5_Bit_Arts"
        weight = 1
    strings:
        $a = { EB 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 55 E8 00 00 00 00 5D 81 ED 18 00 00 00 8B C5 55 60 9C 2B 85 E9 06 00 00 89 85 E1 06 00 00 FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Anti007_NsPacK_Private: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Anti007_NsPacK_Private"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 10 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 60 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 60 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 60 00 00 E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WordPerfect_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WordPerfect_Graphics_format"
        weight = 1
    strings:
        $a = { FF 57 50 43 10 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_v12_Alexey_Solodovnikov_h1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v12_Alexey_Solodovnikov_h1"
        weight = 1
    strings:
        $a = { 90 ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V120_Dll_LZMA_430_ap0xnbsp_nbsp_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V120_Dll_LZMA_430_ap0xnbsp_nbsp_SignByfly"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 AA 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 9C 0C 00 00 EB 0C 8B 85 98 0C 00 00 89 85 9C 0C 00 00 8D B5 C4 0C 00 00 8D 9D 82 04 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 2D 0C 00 00 89 85 94 0C 00 00 E8 59 01 00 00 EB 20 60 8B 85 9C 0C 00 00 FF B5 94 0C 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD A8 0C 00 00 00 74 0E 83 BD AC 0C 00 00 00 74 05 E8 F2 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 2D 0C 00 00 89 85 C0 0C 00 00 5B 60 FF B5 94 0C 00 00 56 FF B5 C0 0C 00 00 FF D3 61 8B B5 C0 0C 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 9C 0C 00 00 83 C0 04 89 85 BC 0C 00 00 EB 72 56 FF 95 25 0C 00 00 0B C0 75 05 E8 E6 02 00 00 85 C0 0F 84 AB 00 00 00 89 85 B8 0C 00 00 8B C6 EB 2E 8B 85 BC 0C 00 00 8B 00 50 FF B5 B8 0C 00 00 E8 2E 02 00 00 85 C0 0F 84 85 00 00 00 89 07 83 85 BC 0C 00 00 04 83 C7 04 8B 85 BC 0C 00 00 83 38 00 75 CD EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD 9C 0C 00 00 83 C0 04 89 85 BC 0C 00 00 80 3E 01 75 89 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 C0 0C 00 00 FF 95 31 0C 00 00 68 00 80 00 00 6A 00 FF B5 C0 0C 00 00 FF 95 31 0C 00 00 68 00 80 00 00 6A 00 FF B5 94 0C 00 00 FF 95 31 0C 00 00 E8 61 00 00 00 E8 5C 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SWAG_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SWAG_Archive"
        weight = 1
    strings:
        $a = { ?? ?? 2D 73 77 31 2D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DSHIELD: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DSHIELD"
        weight = 1
    strings:
        $a = { 06 E8 ?? ?? 5E 83 EE ?? 16 17 9C 58 B9 ?? ?? 25 ?? ?? 2E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EEXE_Version_112: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EEXE_Version_112"
        weight = 1
    strings:
        $a = { B4 30 CD 21 3C 03 73 ?? BA 1F 00 0E 1F B4 09 CD 21 B8 FF 4C CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ICrypt_10_by_BuGGz: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ICrypt_10_by_BuGGz"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 EC 53 56 57 33 C0 89 45 EC B8 70 3B 00 10 E8 3C FA FF FF 33 C0 55 68 6C 3C 00 10 64 FF 30 64 89 20 6A 0A 68 7C 3C 00 10 A1 50 56 00 10 50 E8 D8 FA FF FF 8B D8 53 A1 50 56 00 10 50 E8 0A FB FF FF 8B F8 53 A1 50 56 00 10 50 E8 D4 FA FF FF 8B D8 53 E8 D4 FA FF FF 8B F0 85 F6 74 26 8B D7 4A B8 64 56 00 10 E8 25 F6 FF FF B8 64 56 00 10 E8 13 F6 FF FF 8B CF 8B D6 E8 E6 FA FF FF 53 E8 90 FA FF FF 8D 4D EC BA 8C 3C 00 10 A1 64 56 00 10 E8 16 FB FF FF 8B 55 EC B8 64 56 00 10 E8 C5 F4 FF FF B8 64 56 00 10 E8 DB F5 FF FF E8 56 FC FF FF 33 C0 5A 59 59 64 89 10 68 73 3C 00 10 8D 45 EC E8 4D F4 FF FF C3 E9 E3 EE FF FF EB F0 5F 5E 5B E8 4D F3 FF FF 00 53 45 54 ?? ?? ?? ?? 00 FF FF FF FF 08 00 00 00 76 6F 74 72 65 63 6C 65 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_Protected_Mode_compiler_2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_Protected_Mode_compiler_2"
        weight = 1
    strings:
        $a = { FA FC 0E 1F E8 ?? ?? 8C C0 66 0F B7 C0 66 C1 E0 ?? 66 67 A3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_Protected_Mode_compiler_1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_Protected_Mode_compiler_1"
        weight = 1
    strings:
        $a = { FA BC ?? ?? 8C C8 8E D8 E8 ?? ?? E8 ?? ?? E8 ?? ?? 66 B8 ?? ?? ?? ?? 66 C1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v30_EXE_LZMA_Markus_Oberhumer_Laszlo_Molnar_John_Reiser: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v30_EXE_LZMA_Markus_Oberhumer_Laszlo_Molnar_John_Reiser"
        weight = 1
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? FF 57 89 E5 8D 9C 24 80 C1 FF FF 31 C0 50 39 DC 75 FB 46 46 53 68 ?? ?? ?? 00 57 83 C3 04 53 68 ?? ?? ?? 00 56 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_ASPack_212_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_ASPack_212_emadicius"
        weight = 1
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 73 00 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B }
        $b = { 60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule LTC_v13: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LTC_v13"
        weight = 1
    strings:
        $a = { 54 E8 00 00 00 00 5D 8B C5 81 ED F6 73 40 00 2B 85 87 75 40 00 83 E8 06 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_110_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_110_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp"
        weight = 1
    strings:
        $a = { 2B C2 E8 02 00 00 00 95 4A 59 8D 3D 52 F1 2A E8 C1 C8 1C BE 2E ?? ?? 18 EB 02 AB A0 03 F7 EB 02 CD 20 68 F4 00 00 00 0B C7 5B 03 CB 8A 06 8A 16 E8 02 00 00 00 8D 46 59 EB 01 A4 02 D3 EB 02 CD 20 02 D3 E8 02 00 00 00 57 AB 58 81 C2 AA 87 AC B9 0F BE C9 80 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_MSVCpp_60_DLL_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_MSVCpp_60_DLL_emadicius"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 CA 37 41 00 68 06 38 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 64 8F 05 00 00 00 00 83 C4 0C 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Open_Source_Code_Crypter_p0ke: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Open_Source_Code_Crypter_p0ke"
        weight = 1
    strings:
        $a = { 55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 B8 34 44 40 00 E8 28 F8 FF FF 33 C0 55 68 9F 47 40 00 64 FF 30 64 89 20 BA B0 47 40 00 B8 1C 67 40 00 E8 07 FD FF FF 8B D8 85 DB 75 07 6A 00 E8 C2 F8 FF FF BA 28 67 40 00 8B C3 8B 0D 1C 67 40 00 E8 F0 }
        $b = { 55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 B8 34 44 40 00 E8 28 F8 FF FF 33 C0 55 68 9F 47 40 00 64 FF 30 64 89 20 BA B0 47 40 00 B8 1C 67 40 00 E8 07 FD FF FF 8B D8 85 DB 75 07 6A 00 E8 C2 F8 FF FF BA 28 67 40 00 8B C3 8B 0D 1C 67 40 00 E8 F0 E0 FF FF BE 01 00 00 00 B8 2C 68 40 00 E8 E1 F0 FF FF BF 0A 00 00 00 8D 55 EC 8B C6 E8 92 FC FF FF 8B 4D EC B8 2C 68 40 00 BA BC 47 40 00 E8 54 F2 FF FF A1 2C 68 40 00 E8 52 F3 FF FF 8B D0 B8 20 67 40 00 E8 A2 FC FF FF 8B D8 85 DB 0F 84 52 02 00 00 B8 24 67 40 00 8B 15 20 67 40 00 E8 78 F4 FF FF B8 24 67 40 00 E8 7A F3 FF FF 8B D0 8B C3 8B 0D 20 67 40 00 E8 77 E0 FF FF 8D 55 E8 A1 24 67 40 00 E8 42 FD FF FF 8B 55 E8 B8 24 67 40 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Microsoft_Basic_Compiler_v560_1982_97: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Basic_Compiler_v560_1982_97"
        weight = 1
    strings:
        $a = { 9A ?? ?? ?? ?? 9A ?? ?? ?? ?? 9A ?? ?? ?? ?? 33 DB BA ?? ?? 9A ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 33 DB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ORiEN_v211_212_Fisun_Alexander: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ORiEN_v211_212_Fisun_Alexander"
        weight = 1
    strings:
        $a = { E9 5D 01 00 00 CE D1 CE ?? 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 20 4F 52 69 45 4E 20 65 78 65 63 75 74 61 62 6C 65 20 66 69 6C 65 73 20 70 72 6F 74 65 63 74 69 6F 6E 20 73 79 73 74 65 6D 20 2D 0D 0A 2D 2D 2D 2D 2D 2D 20 43 72 65 61 74 65 64 20 62 79 20 41 2E 20 46 69 73 75 6E 2C 20 31 39 39 34 2D 32 30 30 33 20 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 20 57 57 57 3A 20 68 74 74 70 3A 2F 2F 7A 61 6C 65 78 66 2E 6E 61 72 6F 64 2E 72 75 2F 20 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 20 65 2D 6D 61 69 6C 3A 20 7A 61 6C 65 78 66 40 68 6F 74 6D 61 69 6C 2E 72 75 20 2D 2D 2D 2D 2D 2D 2D 2D 2D 0D 0A 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D 2D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SecureEXE_30_ZipWorx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SecureEXE_30_ZipWorx"
        weight = 1
    strings:
        $a = { E9 B8 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_C_v70_Basic_NET: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_C_v70_Basic_NET"
        weight = 1
    strings:
        $a = { FF 25 00 20 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HASP_HL_Protection_V1X_Aladdin: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HASP_HL_Protection_V1X_Aladdin"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 60 8B C4 A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 15 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 83 C4 04 E9 A5 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 15 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Pascal_70_for_Windows: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Pascal_70_for_Windows"
        weight = 1
    strings:
        $a = { 9A FF FF 00 00 9A FF FF 00 00 55 89 E5 31 C0 9A FF FF 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_Run_Time_Library_1992_14: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Run_Time_Library_1992_14"
        weight = 1
    strings:
        $a = { 1E 06 8C C8 8E D8 8C C0 A3 ?? ?? 83 C0 ?? A3 ?? ?? B4 30 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RTPatch_software_update_package_data_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RTPatch_software_update_package_data_file"
        weight = 1
    strings:
        $a = { 4B 2A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V036_V037_DLL_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V036_V037_DLL_Dwing"
        weight = 1
    strings:
        $a = { 60 E8 09 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? 33 C9 5E 87 0E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v20_beta_Jeremy_Collake: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v20_beta_Jeremy_Collake"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? 01 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Aase_Crypter_by_santasdad: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Aase_Crypter_by_santasdad"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 B8 A0 3E 00 10 E8 93 DE FF FF 68 F8 42 00 10 E8 79 DF FF FF 68 00 43 00 10 68 0C 43 00 10 E8 42 DF FF FF 50 E8 44 DF FF FF A3 98 66 00 10 83 3D 98 66 00 10 00 75 13 6A 00 68 18 43 00 10 68 1C 43 00 10 6A 00 E8 4B DF FF FF 68 2C 43 00 10 68 0C 43 ?? ?? ?? ?? DF FF FF 50 E8 0E DF FF FF A3 94 66 00 10 83 3D 94 66 00 10 00 75 13 6A 00 68 18 43 00 10 68 38 43 00 10 6A 00 E8 15 DF FF FF 68 48 43 00 10 68 0C 43 00 10 E8 D6 DE FF FF 50 E8 D8 DE FF FF A3 A0 66 00 10 83 3D A0 66 00 10 00 75 13 6A 00 68 18 43 00 10 68 58 43 00 10 6A 00 E8 DF DE FF FF 68 6C 43 00 10 68 0C 43 00 10 E8 A0 DE FF FF 50 E8 A2 DE FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1200_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1200_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 3F 1E 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Themida_1201_Oreans_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Themida_1201_Oreans_Technologies"
        weight = 1
    strings:
        $a = { 8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? 35 09 89 95 ?? ?? 35 09 89 B5 ?? ?? 35 09 89 85 ?? ?? 35 09 83 BD ?? ?? 35 09 00 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? 35 09 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HideProtect_V10X_SoftWar_Company: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HideProtect_V10X_SoftWar_Company"
        weight = 1
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_SKE_2122_dll_Alexey_Solodovnikov_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_SKE_2122_dll_Alexey_Solodovnikov_h"
        weight = 1
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 ED 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00 }
        $b = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 ED 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ASProtect_v11_BRS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v11_BRS"
        weight = 1
    strings:
        $a = { 60 E9 ?? 05 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_EXE32Pack_13x_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_EXE32Pack_13x_emadicius"
        weight = 1
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 A0 02 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NeoLite_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NeoLite_v10"
        weight = 1
    strings:
        $a = { E9 9B 00 00 00 A0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Windows_Metafile: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Windows_Metafile"
        weight = 1
    strings:
        $a = { D7 CD C6 9A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE2COM_Method_1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE2COM_Method_1"
        weight = 1
    strings:
        $a = { 8C DB BE ?? ?? 8B C6 B1 ?? D3 E8 03 C3 03 ?? ?? A3 ?? ?? 8C C8 05 ?? ?? A3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Access_Database_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Access_Database_file"
        weight = 1
    strings:
        $a = { 00 01 00 00 53 74 61 6E 64 61 72 64 20 4A 65 74 20 44 42 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_Patch_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_Patch_Dwing"
        weight = 1
    strings:
        $a = { 81 3A 00 00 00 02 00 00 00 00 }
        $b = { 2A A3 F2 54 CE }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule eXpressor_v11_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXpressor_v11_CGSoftLabs"
        weight = 1
    strings:
        $a = { E9 15 13 00 00 E9 F0 12 00 00 E9 58 12 00 00 E9 AF 0C 00 00 E9 AE 02 00 00 E9 B4 0B 00 00 E9 E0 0C 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Portable_BitMap_PBM_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Portable_BitMap_PBM_Graphics_format"
        weight = 1
    strings:
        $a = { 50 36 0A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Lotus_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Lotus_Graphics_format"
        weight = 1
    strings:
        $a = { 01 00 00 00 01 00 08 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_239_DLL_minimum_protection: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_239_DLL_minimum_protection"
        weight = 1
    strings:
        $a = { 51 68 ?? ?? ?? ?? 87 2C 24 8B CD 5D 81 E1 ?? ?? ?? ?? E9 ?? ?? ?? 00 89 45 F8 51 68 ?? ?? ?? ?? 59 81 F1 ?? ?? ?? ?? 0B 0D ?? ?? ?? ?? 81 E9 ?? ?? ?? ?? E9 ?? ?? ?? 00 81 C2 ?? ?? ?? ?? E8 ?? ?? ?? 00 87 0C 24 59 51 64 8B 05 30 00 00 00 8B 40 0C 8B 40 0C E9 ?? ?? ?? 00 F7 D6 2B D5 E9 ?? ?? ?? 00 87 3C 24 8B CF 5F 87 14 24 1B CA E9 ?? ?? ?? 00 83 C4 08 68 ?? ?? ?? ?? E9 ?? ?? ?? 00 C3 E9 ?? ?? ?? 00 E9 ?? ?? ?? 00 50 8B C5 87 04 24 8B EC 51 0F 88 ?? ?? ?? 00 FF 05 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 0C 24 59 99 03 04 24 E9 ?? ?? ?? 00 C3 81 D5 ?? ?? ?? ?? 9C E9 ?? ?? ?? 00 81 FA ?? ?? ?? ?? E9 ?? ?? ?? 00 C1 C3 15 81 CB ?? ?? ?? ?? 81 F3 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 87 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_10_beta_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_10_beta_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 4C 32 40 00 E8 03 00 00 00 EB 01 ?? B9 EA 47 40 00 81 E9 E9 32 40 00 8B D5 81 C2 E9 32 40 00 8D 3A 8B F7 33 C0 E8 04 00 00 00 90 EB 01 ?? E8 03 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESPin_13_Cyberbob_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESPin_13_Cyberbob_h"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Private_Personal_Packer_PPP_v102_ConquestOfTroycom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_Personal_Packer_PPP_v102_ConquestOfTroycom"
        weight = 1
    strings:
        $a = { E8 17 00 00 00 E8 68 00 00 00 FF 35 2C 37 00 10 E8 ED 01 00 00 6A 00 E8 2E 04 00 00 E8 41 04 00 00 A3 74 37 00 10 6A 64 E8 5F 04 00 00 E8 30 04 00 00 A3 78 37 00 10 6A 64 E8 4E 04 00 00 E8 1F 04 00 00 A3 7C 37 00 10 A1 74 37 00 10 8B 1D 78 37 00 10 2B D8 8B 0D 7C 37 00 10 2B C8 83 FB 64 73 0F 81 F9 C8 00 00 00 73 07 6A 00 E8 D9 03 00 00 C3 6A 0A 6A 07 6A 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Cpp_1999: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Borland_Cpp_1999"
        weight = 1
    strings:
        $a = { EB 02 CD 20 2B C8 68 80 ?? ?? 00 EB 02 1E BB 5E EB 02 CD 20 68 B1 2B 6E 37 40 5B 0F B6 C9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule KGCrypt_vxx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID KGCrypt_vxx"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? 64 A1 30 ?? ?? ?? 84 C0 74 ?? 64 A1 20 ?? ?? ?? 0B C0 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_Microsoft_Visual_Basic_50_60: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Microsoft_Visual_Basic_50_60"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? E8 0A 00 00 00 00 00 00 00 00 00 30 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEShit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEShit"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 83 F9 00 7E 06 80 30 ?? 40 E2 F5 E9 ?? ?? ?? FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DBPE_v210: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DBPE_v210"
        weight = 1
    strings:
        $a = { EB 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9C 55 57 56 52 51 53 9C E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? EB 58 75 73 65 72 33 32 2E 64 6C 6C ?? 4D 65 73 73 61 67 65 42 6F 78 41 ?? 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C ?? 53 6C 65 65 70 ?? 47 65 74 54 69 63 6B 43 6F 75 6E 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Neolite_20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Neolite_20"
        weight = 1
    strings:
        $a = { E9 A6 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_Install_System_v20b2_v20b3: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_Install_System_v20b2_v20b3"
        weight = 1
    strings:
        $a = { 83 EC 0C 53 55 56 57 FF 15 ?? 70 40 00 8B 35 ?? 92 40 00 05 E8 03 00 00 89 44 24 14 B3 20 FF 15 2C 70 40 00 BF 00 04 00 00 68 ?? ?? ?? 00 57 FF 15 ?? ?? 40 00 57 FF 15 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ARC_SFX_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ARC_SFX_Archive"
        weight = 1
    strings:
        $a = { 8C C8 8C DB 8E D8 8E C0 89 ?? ?? ?? 2B C3 A3 ?? ?? 89 ?? ?? ?? BE ?? ?? B9 ?? ?? BF ?? ?? BA ?? ?? FC AC 32 C2 8A D8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AZProtect_0x0001_AlexZ_aka_AZCRC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AZProtect_0x0001_AlexZ_aka_AZCRC"
        weight = 1
    strings:
        $a = { EB 70 FC 60 8C 80 4D 11 00 70 25 81 00 40 0D 91 BB 60 8C 80 4D 11 00 70 21 81 1D 61 0D 81 00 40 CE 60 8C 80 4D 11 00 70 25 81 25 81 25 81 25 81 29 61 41 81 31 61 1D 61 00 40 B7 30 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CodeCrypt_v015b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CodeCrypt_v015b"
        weight = 1
    strings:
        $a = { E9 31 03 00 00 EB 02 83 3D 58 EB 02 FF 1D 5B EB 02 0F C7 5F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1300_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1300_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 04 ?? ?? ?? ?? E8 29 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_2117_Strongbit_SoftComplete_Development_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_2117_Strongbit_SoftComplete_Development_h"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F4 56 57 53 BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_PEBundle_02_3x_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_PEBundle_02_3x_emadicius"
        weight = 1
    strings:
        $a = { EB 03 CD 20 C7 1E EB 03 CD 20 EA 9C EB 02 EB 01 EB 01 EB 60 EB 03 CD 20 EB EB 01 EB E8 03 00 00 00 E9 EB 04 58 40 50 C3 EB 03 CD 20 EB EB 03 CD 20 03 61 9D 83 C4 04 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PCPEC_alpha_preview: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PCPEC_alpha_preview"
        weight = 1
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 5D 8B CD 81 ED 33 30 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PIRIT_v15: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PIRIT_v15"
        weight = 1
    strings:
        $a = { B4 4D CD 21 E8 ?? ?? FD E8 ?? ?? B4 51 CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VProtector_13X_vcasm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VProtector_13X_vcasm"
        weight = 1
    strings:
        $a = { E9 B9 16 00 00 55 8B EC 81 EC 74 04 00 00 57 68 00 00 00 00 68 00 00 C2 14 68 FF FF 00 00 68 ?? ?? ?? ?? 9C 81 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9D 54 FF 14 24 68 00 00 00 00 68 00 00 C2 10 68 ?? ?? ?? ?? 9C 81 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9D 54 FF 14 24 68 00 00 00 00 68 ?? ?? ?? ?? 9C 81 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9D 54 FF 14 24 68 00 00 00 00 68 FF FF C2 10 68 ?? ?? ?? ?? 9C 81 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9D 54 FF 14 24 68 00 00 00 00 68 ?? ?? ?? ?? 9C 81 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9D 54 FF 14 24 68 00 00 00 00 68 00 00 C2 14 68 FF FF 00 00 68 ?? ?? ?? ?? 9C 81 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9D 54 FF 14 24 68 00 00 00 00 68 ?? ?? ?? ?? 9C 81 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9D 54 FF 14 24 68 00 00 00 00 }
        $b = { 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 60 8B B4 24 24 00 00 00 8B BC 24 28 00 00 00 FC C6 C2 80 33 DB A4 C6 C3 02 E8 A9 00 00 00 0F 83 F1 FF FF FF 33 C9 E8 9C 00 00 00 0F 83 2D 00 00 00 33 C0 E8 8F 00 00 00 0F 83 37 00 00 00 C6 C3 02 41 C6 C0 10 E8 7D 00 00 00 10 C0 0F 83 F3 FF FF FF }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule EXECryptor_22x_SoftComplete_Developement: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_22x_SoftComplete_Developement"
        weight = 1
    strings:
        $a = { E8 F7 FE FF FF 05 ?? ?? 00 00 FF E0 E8 EB FE FF FF 05 ?? ?? 00 00 FF E0 E8 04 00 00 00 FF FF FF FF }
        $b = { 50 8B C6 87 04 24 68 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? 85 C8 E9 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 0F 81 ?? ?? ?? 00 81 FA ?? ?? ?? ?? 33 D0 E9 ?? ?? ?? 00 0F 8D ?? ?? ?? 00 81 D5 ?? ?? ?? ?? F7 D1 0B 15 ?? ?? ?? ?? C1 C2 ?? 81 C2 ?? ?? ?? ?? 9D E9 ?? ?? ?? ?? C1 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Gardian_Angel_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Gardian_Angel_10"
        weight = 1
    strings:
        $a = { 06 8C C8 8E D8 8E C0 FC BF ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SOFTWrapper_for_Win9xNT_Evaluation_Version: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SOFTWrapper_for_Win9xNT_Evaluation_Version"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 5D 8B C5 2D ?? ?? ?? 00 50 81 ED 05 00 00 00 8B C5 2B 85 03 0F 00 00 89 85 03 0F 00 00 8B F0 03 B5 0B 0F 00 00 8B F8 03 BD 07 0F 00 00 83 7F 0C 00 74 2B 56 57 8B 7F 10 03 F8 8B 76 10 03 F0 83 3F 00 74 0C 8B 1E 89 1F 83 C6 04 83 C7 04 EB EF 5F 5E 83 C6 14 83 C7 14 EB D3 00 00 00 00 8B F5 81 C6 0D 0A 00 00 B9 0C 00 00 00 8B 85 03 0F 00 00 01 46 02 83 C6 06 E2 F8 E8 06 08 00 00 68 00 01 00 00 8D 85 DD 0D 00 00 50 6A 00 E8 95 09 00 00 8B B5 03 0F 00 00 66 81 3E 4D 5A 75 33 03 76 3C 81 3E 50 45 00 00 75 28 8B 46 28 03 85 03 0F 00 00 3B C5 74 1B 6A 30 E8 99 09 00 00 6A 30 8D 85 DD 0D 00 00 50 8D 85 2B 0F 00 00 E9 55 03 00 00 66 8B 85 9D 0A 00 00 F6 C4 80 74 31 E8 6A 07 00 00 0B C0 75 23 6A 40 E8 69 09 00 00 6A 40 8D 85 DD 0D 00 00 50 8B 9D 17 0F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Shield_V01b_V08_SMoKE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Shield_V01b_V08_SMoKE"
        weight = 1
    strings:
        $a = { E8 04 00 00 00 83 ?? ?? ?? 5D EB 05 45 55 EB 04 ?? EB F9 ?? C3 E8 00 00 00 00 5D EB 01 ?? 81 ?? ?? ?? ?? ?? EB 02 ?? ?? 8D ?? ?? ?? ?? ?? EB 02 ?? ?? BA 9F 11 00 00 EB 01 ?? 8D ?? ?? ?? ?? ?? 8B 09 E8 14 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 58 40 50 C3 }
        $b = { E8 04 00 00 00 83 ?? ?? ?? 5D EB 05 45 55 EB 04 ?? EB F9 ?? C3 E8 00 00 00 00 5D EB 01 ?? 81 ?? ?? ?? ?? ?? EB 02 ?? ?? 8D ?? ?? ?? ?? ?? EB 02 ?? ?? BA 9F 11 00 00 EB 01 ?? 8D ?? ?? ?? ?? ?? 8B 09 E8 14 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule AntiDote_14_SE_SIS_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiDote_14_SE_SIS_Team"
        weight = 1
    strings:
        $a = { 68 90 03 00 00 E8 C6 FD FF FF 68 90 03 00 00 E8 BC FD FF FF 68 90 03 00 00 E8 B2 FD FF FF 50 E8 AC FD FF FF 50 E8 A6 FD FF FF 68 69 D6 00 00 E8 9C FD FF FF 50 E8 96 FD FF FF 50 E8 90 FD FF FF 83 C4 20 E8 78 FF FF FF 84 C0 74 4F 68 04 01 00 00 68 10 22 60 00 6A 00 FF 15 08 10 60 00 68 90 03 00 00 E8 68 FD FF FF 68 69 D6 00 00 E8 5E FD FF FF 50 E8 58 FD FF FF 50 E8 52 FD FF FF E8 DD FE FF FF 50 68 A4 10 60 00 68 94 10 60 00 68 10 22 60 00 E8 58 FD FF FF 83 C4 20 33 C0 C2 10 00 8B 4C 24 08 56 8B 74 24 08 33 D2 8B C6 F7 F1 8B C6 85 D2 74 08 33 D2 F7 F1 40 0F AF C1 5E C3 }
        $b = { 68 90 03 00 00 E8 C6 FD FF FF 68 90 03 00 00 E8 BC FD FF FF 68 90 03 00 00 E8 B2 FD FF FF 50 E8 AC FD FF FF 50 E8 A6 FD FF FF 68 69 D6 00 00 E8 9C FD FF FF 50 E8 96 FD FF FF 50 E8 90 FD FF FF 83 C4 20 E8 78 FF FF FF 84 C0 74 4F 68 04 01 00 00 68 10 22 60 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule VOB_ProtectCD: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VOB_ProtectCD"
        weight = 1
    strings:
        $a = { 36 3E 26 8A C0 60 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v09781: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v09781"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 ?? 87 DD 8B 85 E6 90 40 ?? 01 85 33 90 40 ?? 66 C7 85 ?? 90 40 ?? 90 90 01 85 DA 90 40 ?? 01 85 DE 90 40 ?? 01 85 E2 90 40 ?? BB 5B 11 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v09782: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v09782"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB C4 84 40 ?? 87 DD 8B 85 49 85 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v120_Eng_dulekxt_Borland_Delphi_Borland_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v120_Eng_dulekxt_Borland_Delphi_Borland_Cpp"
        weight = 1
    strings:
        $a = { 0F BE C1 EB 01 0E 8D 35 C3 BE B6 22 F7 D1 68 43 ?? ?? 22 EB 02 B5 15 5F C1 F1 15 33 F7 80 E9 F9 BB F4 00 00 00 EB 02 8F D0 EB 02 08 AD 8A 16 2B C7 1B C7 80 C2 7A 41 80 EA 10 EB 01 3C 81 EA CF AE F1 AA EB 01 EC 81 EA BB C6 AB EE 2C E3 32 D3 0B CB 81 EA AB EE 90 14 2C 77 2A D3 EB 01 87 2A D3 E8 01 00 00 00 92 59 88 16 EB 02 52 08 46 EB 02 CD 20 4B 80 F1 C2 85 DB 75 AE C1 E0 04 EB 00 DA B2 82 5C 9B C7 89 98 4F 8A F7 ?? ?? ?? B1 4D DF B8 AD AC AB D4 07 27 D4 50 CF 9A D5 1C EC F2 27 77 18 40 4E A4 A8 B4 CB 9F 1D D9 EC 1F AD BC 82 AA C0 4C 0A A2 15 45 18 8F BB 07 93 BE C0 BC A3 B0 9D 51 D4 F1 08 22 62 96 6D 09 73 7E 71 A5 3A E5 7D 94 A3 96 99 98 72 B2 31 57 7B FA AE 9D 28 4F 99 EF A3 25 49 60 03 42 8B 54 53 5E 92 50 D4 52 4D C1 55 76 FD F7 8A FC 78 0C 82 87 0F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VProtector_V13X_vcasm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VProtector_V13X_vcasm"
        weight = 1
    strings:
        $a = { 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 76 63 61 73 6D 5F 70 72 6F 74 65 63 74 5F 32 30 30 35 5F 33 5F 31 38 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 33 F6 E8 10 00 00 00 8B 64 24 08 64 8F 05 00 00 00 00 }
        $b = { 00 00 00 00 55 73 65 72 33 32 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 47 64 69 33 32 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule RLPack_V115_V117_Dll_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V115_V117_Dll_ap0x"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TaiShanXiangYu_LockSoft_V10_zlocksoft_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TaiShanXiangYu_LockSoft_V10_zlocksoft_SignByfly"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED E3 00 42 00 8B D5 81 C2 32 01 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 ?? ?? ?? ?? 81 ?? ?? ?? ?? ?? 8B D5 81 ?? ?? ?? ?? ?? 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 ?? ?? ?? E9 ?? ?? ?? ?? 33 C0 64 FF 30 64 89 20 43 CC C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Duals_eXe_Encryptor_10b_Dual: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Duals_eXe_Encryptor_10b_Dual"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E 00 00 00 8D 85 3A 04 00 00 89 28 33 FF 8D 85 80 03 00 00 8D 8D 3A 04 00 00 2B C8 8B 9D 8A 04 00 00 E8 24 02 00 00 8D 9D 58 03 00 00 8D B5 7F 03 00 00 46 80 3E 00 74 24 56 FF 95 58 05 00 00 46 80 3E 00 75 FA 46 80 3E 00 74 E7 50 56 50 FF 95 5C 05 00 00 89 03 58 83 C3 04 EB E3 8D 85 69 02 00 00 FF D0 8D 85 56 04 00 00 50 68 1F 00 02 00 6A 00 8D 85 7A 04 00 00 50 }
        $b = { 55 8B EC 81 EC 00 05 00 00 E8 00 00 00 00 5D 81 ED 0E 00 00 00 8D 85 3A 04 00 00 89 28 33 FF 8D 85 80 03 00 00 8D 8D 3A 04 00 00 2B C8 8B 9D 8A 04 00 00 E8 24 02 00 00 8D 9D 58 03 00 00 8D B5 7F 03 00 00 46 80 3E 00 74 24 56 FF 95 58 05 00 00 46 80 3E 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule HP_48sx_graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HP_48sx_graphics_format"
        weight = 1
    strings:
        $a = { 48 50 48 50 34 38 2D 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACE_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACE_Archive"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? 2A 2A 41 43 45 2A 2A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nSpack_V11_LiuXingPing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nSpack_V11_LiuXingPing"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 57 84 40 00 2D 50 84 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BGI_Stroked_Font_v11: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BGI_Stroked_Font_v11"
        weight = 1
    strings:
        $a = { 50 4B 08 08 42 47 49 20 53 74 72 6F 6B 65 64 20 46 6F 6E 74 20 56 31 2E 31 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_v102b_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_v102b_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DEF_10_bartxt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DEF_10_bartxt"
        weight = 1
    strings:
        $a = { BE ?? ?? 40 00 6A ?? 59 80 7E 07 00 74 11 8B 46 0C 05 00 00 40 00 8B 56 10 30 10 40 4A 75 FA 83 C6 28 E2 E4 68 ?? ?? 40 00 C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WWPACK_v305c4_Unextractable_p_Password_checking: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WWPACK_v305c4_Unextractable_p_Password_checking"
        weight = 1
    strings:
        $a = { 03 05 80 1B B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_Full_Edition_117_DLL_aPLib: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_Full_Edition_117_DLL_aPLib"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 53 03 00 00 8D 9D 02 02 00 00 33 FF E8 ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VX_TibsZhelatin_StormWorm_variant: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VX_TibsZhelatin_StormWorm_variant"
        weight = 1
    strings:
        $a = { FF 74 24 1C 58 8D 80 ?? ?? 77 04 50 68 62 34 35 04 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Petite_14_c1998_99_Ian_Luck: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Petite_14_c1998_99_Ian_Luck"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? 66 9C 60 50 8B D8 03 00 68 54 BC 00 00 6A 00 FF 50 14 8B CC 8D A0 54 BC 00 00 50 8B C3 8D 90 ?? 16 00 00 68 00 00 ?? ?? 51 50 80 04 24 08 50 80 04 24 42 50 80 04 24 61 50 80 04 24 9D 50 80 04 24 BB 83 3A 00 0F 84 D8 14 00 00 8B 44 24 18 F6 42 03 80 74 19 FD 80 72 03 80 8B F0 8B F8 03 72 04 03 7A 08 8B 0A F3 A5 83 C2 0C FC EB D4 8B 7A 08 03 F8 8B 5A 04 85 DB 74 13 52 53 57 03 02 50 E8 79 00 00 00 85 C0 74 30 5F 5F 58 5A 8B 4A 0C C1 F9 02 33 C0 F3 AB 8B 4A 0C 83 E1 03 F3 AA 83 C2 10 EB 9E 45 52 52 4F 52 21 00 43 6F 72 72 75 70 74 20 44 61 74 61 21 00 8B 64 24 24 8B 04 24 83 C4 26 8B D0 66 81 C2 7E 01 6A 10 8B D8 66 05 77 01 50 52 6A 00 03 1B FF 13 6A FF FF 53 08 56 57 8B 7C 24 0C 8B 74 24 10 8B 4C 24 14 C1 F9 02 F3 A5 8B 4C 24 14 83 E1 03 F3 A4 5F 5E C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Delphi_20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Borland_Delphi_20"
        weight = 1
    strings:
        $a = { EB 01 56 E8 02 00 00 00 B2 D9 59 68 80 ?? 41 00 E8 02 00 00 00 65 32 59 5E EB 02 CD 20 BB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1331_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1331_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 01 ?? E8 29 00 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 02 ?? ?? 50 EB 01 ?? 33 C0 EB 04 ?? ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 02 ?? ?? E8 D5 FF FF FF EB 01 ?? EB 04 ?? ?? ?? ?? 58 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 02 ?? ?? E8 5F 27 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BeRoEXEPacker_v100_LZBRS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BeRoEXEPacker_v100_LZBRS"
        weight = 1
    strings:
        $a = { 60 BE ?? ?? ?? ?? BF ?? ?? ?? ?? FC AD 8D 1C 07 B0 80 3B FB 73 3B E8 1C 00 00 00 72 03 A4 EB F2 E8 1A 00 00 00 8D 51 FF E8 12 00 00 00 56 8B F7 2B F2 F3 A4 5E EB DB 02 C0 75 03 AC 12 C0 C3 33 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule GameGuard_nProtect: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID GameGuard_nProtect"
        weight = 1
    strings:
        $a = { 31 FF 74 06 61 E9 4A 4D 50 30 5A BA 7D 00 00 00 80 7C 24 08 01 E9 00 00 00 00 60 BE ?? ?? ?? ?? 31 FF 74 06 61 E9 4A 4D 50 30 8D BE ?? ?? ?? ?? 31 C9 74 06 61 E9 4A 4D 50 30 B8 7D 00 00 00 39 C2 B8 4C 00 00 00 F7 D0 75 3F 64 A1 30 00 00 00 85 C0 78 23 8B 40 0C 8B 40 0C C7 40 20 00 10 00 00 64 A1 18 00 00 00 8B 40 30 0F B6 40 02 85 C0 75 16 E9 12 00 00 00 31 C0 64 A0 20 00 00 00 85 C0 75 05 E9 01 00 00 00 61 57 83 CD FF EB 0B 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule pirit_v15: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID pirit_v15"
        weight = 1
    strings:
        $a = { ?? ?? ?? 5B 24 55 50 44 FB 32 2E 31 5D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Shrink_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Shrink_v10"
        weight = 1
    strings:
        $a = { 50 9C FC BE ?? ?? BF ?? ?? 57 B9 ?? ?? F3 A4 8B ?? ?? ?? BE ?? ?? BF ?? ?? F3 A4 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_SVKP_111_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_SVKP_111_emadicius"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 64 A0 23 00 00 00 83 C5 06 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PKLITE_v114_v115_v120_3: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PKLITE_v114_v115_v120_3"
        weight = 1
    strings:
        $a = { B8 ?? ?? BA ?? ?? 05 ?? ?? 3B ?? ?? ?? 72 ?? B4 09 BA ?? 01 CD 21 CD 20 4E 6F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimplePack_V11X_Method2_bagie: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimplePack_V11X_Method2_bagie"
        weight = 1
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 }
        $b = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Reflexive_Arcade_Wrapper: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Reflexive_Arcade_Wrapper"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 98 68 42 00 68 14 FA 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 F8 50 42 00 33 D2 8A D4 89 15 3C E8 42 00 8B C8 81 E1 FF 00 00 00 89 0D 38 E8 42 00 C1 E1 08 03 CA 89 0D 34 E8 42 00 C1 E8 10 A3 30 E8 42 00 33 F6 56 E8 58 43 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 23 40 00 00 FF 15 18 51 42 00 A3 44 FE 42 00 E8 E1 3E 00 00 A3 78 E8 42 00 E8 8A 3C 00 00 E8 CC 3B 00 00 E8 3E F5 FF FF 89 75 D0 8D 45 A4 50 FF 15 14 51 42 00 E8 5D 3B 00 00 89 45 9C F6 45 D0 01 74 06 0F B7 45 D4 EB 03 6A 0A 58 50 FF 75 9C 56 56 FF 15 10 51 42 00 50 E8 0D 6E FE FF 89 45 A0 50 E8 2C F5 FF FF 8B 45 EC 8B 08 8B 09 89 4D 98 50 51 E8 9B 39 00 00 59 59 C3 8B 65 E8 FF 75 98 E8 1E F5 FF FF 83 3D 80 E8 42 00 01 75 05 E8 F3 43 00 00 FF 74 24 04 E8 23 44 00 00 68 FF 00 00 00 FF 15 B0 B8 42 00 59 59 C3 83 3D 80 E8 42 00 01 75 05 E8 CE 43 00 00 FF 74 24 04 E8 FE 43 00 00 59 68 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule XCR_v013: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID XCR_v013"
        weight = 1
    strings:
        $a = { 93 71 08 ?? ?? ?? ?? ?? ?? ?? ?? 8B D8 78 E2 ?? ?? ?? ?? 9C 33 C3 ?? ?? ?? ?? 60 79 CE ?? ?? ?? ?? E8 01 ?? ?? ?? ?? 83 C4 04 E8 AB FF FF FF ?? ?? ?? ?? 2B E8 ?? ?? ?? ?? 03 C5 FF 30 ?? ?? ?? ?? C6 ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule kkrunchy_Ryd: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID kkrunchy_Ryd"
        weight = 1
    strings:
        $a = { BD 08 ?? ?? 00 C7 45 00 ?? ?? ?? 00 FF 4D 08 C6 45 0C 05 8D 7D 14 31 C0 B4 04 89 C1 F3 AB BF ?? ?? ?? 00 57 BE ?? ?? ?? 00 31 C9 41 FF 4D 0C 8D 9C 8D A0 00 00 00 FF D6 10 C9 73 F3 FF 45 0C 91 AA 83 C9 FF 8D 5C 8D 18 FF D6 74 DD E3 17 8D 5D 1C FF D6 74 10 8D 9D A0 08 00 00 E8 EB 00 00 00 8B 45 10 EB 42 8D 9D A0 04 00 00 E8 DB 00 00 00 49 49 78 40 8D 5D 20 74 03 83 C3 40 31 D2 42 E8 BD 00 00 00 8D 0C 48 F6 C2 10 74 F3 41 91 8D 9D A0 08 00 00 E8 B2 00 00 00 3D 00 08 00 00 83 D9 FF 83 F8 60 83 D9 FF 89 45 10 56 89 FE 29 C6 F3 A4 5E EB 90 BE ?? ?? ?? 00 BB ?? ?? ?? 00 55 46 AD 85 C0 74 29 97 56 FF 13 85 C0 74 16 95 AC 84 C0 75 FB 38 06 74 E8 78 0D 56 55 FF 53 04 AB 85 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PolyCrypt_PE_214b215_JLab_Software_Creations_h_signed: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PolyCrypt_PE_214b215_JLab_Software_Creations_h_signed"
        weight = 1
    strings:
        $a = { 50 6F 6C 79 43 72 79 70 74 20 50 45 20 28 63 29 20 32 30 30 34 2D 32 30 30 35 2C 20 4A 4C 61 62 53 6F 66 74 77 61 72 65 2E 00 50 00 43 00 50 00 45 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule YZPack_12_UsAr: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID YZPack_12_UsAr"
        weight = 1
    strings:
        $a = { 4D 5A 52 45 60 83 EC 18 8B EC 8B FC 33 C0 64 8B 40 30 78 0C 8B 40 0C 8B 70 1C AD 8B 40 08 EB 09 8B 40 34 83 C0 7C 8B 40 3C AB E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule StarForce_V3X_DLL_StarForce_Copy_Protection_System: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID StarForce_V3X_DLL_StarForce_Copy_Protection_System"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? 5E 83 EE ?? B8 CF 7B CD 21 3D CF 7B ?? ?? 0E 1F 81 C6 ?? ?? BF ?? ?? B9 ?? ?? FC F3 A4 06 1F 06 B8 ?? ?? 50 CB B4 48 BB 2C 00 CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Anti007_V25_V26_NsPacK_Private: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Anti007_V25_V26_NsPacK_Private"
        weight = 1
    strings:
        $a = { 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 53 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_PiMP_Install_System: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_PiMP_Install_System"
        weight = 1
    strings:
        $a = { 83 EC ?? 53 55 56 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_Full_Edition_V11X_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_Full_Edition_V11X_ap0x"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 4C 6F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule muckis_protector_II_mucki: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID muckis_protector_II_mucki"
        weight = 1
    strings:
        $a = { E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 00 00 00 31 C0 89 41 14 89 41 18 80 6A 00 E8 85 C0 74 12 64 8B 3D 18 00 00 00 8B 7F 30 0F B6 47 02 85 C0 74 01 C3 C7 04 24 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8A 06 F6 D0 88 06 46 E2 F7 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_226_DLL_minimum_protection: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_226_DLL_minimum_protection"
        weight = 1
    strings:
        $a = { 50 8B C6 87 04 24 68 ?? ?? ?? ?? 5E E9 ?? ?? ?? ?? 85 C8 E9 ?? ?? ?? ?? 81 C3 ?? ?? ?? ?? 0F 81 ?? ?? ?? 00 81 FA ?? ?? ?? ?? 33 D0 E9 ?? ?? ?? 00 0F 8D ?? ?? ?? 00 81 D5 ?? ?? ?? ?? F7 D1 0B 15 ?? ?? ?? ?? C1 C2 ?? 81 C2 ?? ?? ?? ?? 9D E9 ?? ?? ?? ?? C1 E2 ?? C1 E8 ?? 81 EA ?? ?? ?? ?? 13 DA 81 E9 ?? ?? ?? ?? 87 04 24 8B C8 E9 ?? ?? ?? ?? 55 8B EC 83 C4 F8 89 45 FC 8B 45 FC 89 45 F8 8B 45 08 E9 ?? ?? ?? ?? 8B 45 E0 C6 00 00 FF 45 E4 E9 ?? ?? ?? ?? FF 45 E4 E9 ?? ?? ?? 00 F7 D3 0F 81 ?? ?? ?? ?? E9 ?? ?? ?? ?? 87 34 24 5E 8B 45 F4 E8 ?? ?? ?? 00 8B 45 F4 8B E5 5D C3 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_ASProtect_10_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_ASProtect_10_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 60 E8 01 00 00 00 90 5D 81 ED 00 00 00 00 BB 00 00 00 00 03 DD 2B 9D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Minke_V101_Codius_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Minke_V101_Codius_Sign_by_fly"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 ?? ?? ?? ?? ?? 10 E8 7A F6 FF FF BE 68 66 00 10 33 C0 55 68 DB 40 00 10 64 FF 30 64 89 20 E8 FA F8 FF FF BA EC 40 00 10 8B C6 E8 F2 FA FF FF 8B D8 B8 6C 66 00 10 8B 16 E8 88 F2 FF FF B8 6C 66 00 10 E8 76 F2 FF FF 8B D0 8B C3 8B 0E E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Stelth_PE_101_BGCorp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Stelth_PE_101_BGCorp"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? BA ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_Microsoft_Visual_Cpp_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_Microsoft_Visual_Cpp_emadicius"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 CA 37 41 00 68 06 38 41 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 64 8F 05 00 00 00 00 83 C4 0C 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SafeDiscSafeCast_2xx_3xx_Macrovision: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SafeDiscSafeCast_2xx_3xx_Macrovision"
        weight = 1
    strings:
        $a = { 55 8B EC 60 BB ?? ?? ?? ?? 33 C9 8A 0D 3D ?? ?? ?? 85 C9 74 0C B8 ?? ?? ?? ?? 2B C3 83 E8 05 EB 0E 51 B9 ?? ?? ?? ?? 8B C1 2B C3 03 41 01 59 C6 03 E9 89 43 01 51 68 09 ?? ?? ?? 33 C0 85 C9 74 05 8B 45 08 EB 00 50 E8 76 00 00 00 83 C4 08 59 83 F8 00 74 1C C6 03 C2 C6 43 01 0C 85 C9 74 09 61 5D B8 00 00 00 00 EB 97 50 A1 29 ?? ?? ?? ?? D0 61 5D EB 46 80 7C 24 08 00 75 3F 51 8B 4C 24 04 89 0D ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 4C 24 04 59 EB 28 50 B8 2D ?? ?? ?? ?? 70 08 8B 40 0C FF D0 B8 2D ?? ?? ?? ?? 30 8B 40 04 FF D0 58 FF 35 ?? ?? ?? ?? C3 72 16 61 13 60 0D E9 ?? ?? ?? ?? CC CC 81 EC E8 02 00 00 53 55 56 57 }
        $b = { 55 8B EC 60 BB ?? ?? ?? ?? 33 C9 8A 0D 3D ?? ?? ?? 85 C9 74 0C B8 ?? ?? ?? ?? 2B C3 83 E8 05 EB 0E 51 B9 ?? ?? ?? ?? 8B C1 2B C3 03 41 01 59 C6 03 E9 89 43 01 51 68 09 ?? ?? ?? 33 C0 85 C9 74 05 8B 45 08 EB 00 50 E8 76 00 00 00 83 C4 08 59 83 F8 00 74 1C }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PECompact_v133: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v133"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 80 40 ?? 87 DD 8B 85 A6 80 40 ?? 01 85 03 80 40 ?? 66 C7 85 00 80 40 ?? 90 90 01 85 9E 80 40 ?? BB E8 0E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PocketPC_SHA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PocketPC_SHA"
        weight = 1
    strings:
        $a = { 86 2F 96 2F A6 2F B6 2F 22 4F 43 68 53 6B 63 6A 73 69 F0 7F 0B D0 0B 40 09 00 09 D0 B3 65 A3 66 93 67 0B 40 83 64 03 64 04 D0 0B 40 09 00 10 7F 26 4F F6 6B F6 6A F6 69 0B 00 F6 68 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 22 4F F0 7F 0A D0 06 D4 06 D5 0B 40 09 00 08 D0 05 D4 06 D5 0B 40 09 00 10 7F 26 4F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Watcom_CCpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Watcom_CCpp"
        weight = 1
    strings:
        $a = { E9 ?? ?? 00 00 03 10 40 00 57 41 54 43 4F 4D 20 43 2F 43 2B 2B 33 32 20 52 75 6E 2D 54 69 6D 65 20 73 79 73 74 65 6D 2E 20 28 63 29 20 43 6F 70 79 72 69 67 68 74 20 62 79 20 57 41 54 43 4F 4D 20 49 6E 74 65 72 6E 61 74 69 6F 6E 61 6C 20 43 6F 72 70 2E 20 31 39 38 38 2D 31 39 39 35 2E 20 41 6C 6C 20 72 69 67 68 74 73 20 72 65 73 65 72 76 65 64 2E 00 00 00 00 00 00 }
        $b = { E9 ?? ?? 00 00 03 10 40 00 57 41 54 43 4F 4D 20 43 2F 43 2B 2B 33 32 20 52 75 6E 2D 54 69 6D 65 20 73 79 73 74 65 6D 2E 20 28 63 29 20 43 6F 70 79 72 69 67 68 74 20 62 79 20 57 41 54 43 4F 4D 20 49 6E 74 65 72 6E 61 74 69 6F 6E 61 6C 20 43 6F 72 70 2E 20 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_02_LCC_Win32_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_LCC_Win32_DLL"
        weight = 1
    strings:
        $a = { 55 89 E5 53 56 57 83 7D 0C 01 75 05 E8 17 90 90 90 FF 75 10 FF 75 0C FF 75 08 A1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Shrinker_v32: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Shrinker_v32"
        weight = 1
    strings:
        $a = { 83 3D ?? ?? ?? ?? ?? 55 8B EC 56 57 75 65 68 00 01 ?? ?? E8 ?? E6 FF FF 83 C4 04 8B 75 08 A3 ?? ?? ?? ?? 85 F6 74 1D 68 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Explosion1000: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Explosion1000"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5E 1E 06 50 81 ?? ?? ?? 56 FC B8 21 35 CD 21 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? 26 ?? ?? ?? ?? ?? ?? 74 ?? 8C D8 48 8E D8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPolyX_0x_Delikon: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPolyX_0x_Delikon"
        weight = 1
    strings:
        $a = { 81 FD 00 FB FF FF 83 D1 ?? 8D 14 2F 83 FD FC 76 ?? 8A 02 42 88 07 47 49 75 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1341_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1341_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 01 ?? E8 2A 00 00 00 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 02 ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 02 ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Alpha_BMP_graphics_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Alpha_BMP_graphics_file"
        weight = 1
    strings:
        $a = { FF FF 00 01 64 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v100b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v100b"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED 92 1A 44 ?? B8 8C 1A 44 ?? 03 C5 2B 85 CD 1D 44 ?? 89 85 D9 1D 44 ?? 80 BD C4 1D 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ANDpakk2_006_by_Dmitry_AND_Andreev: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ANDpakk2_006_by_Dmitry_AND_Andreev"
        weight = 1
    strings:
        $a = { 60 FC BE D4 00 40 00 BF 00 10 00 01 57 83 CD FF 33 C9 F9 EB 05 A4 02 DB 75 05 8A 1E 46 12 DB 72 F4 33 C0 40 02 DB 75 05 8A 1E 46 12 DB 13 C0 02 DB 75 05 8A 1E 46 12 DB 72 0E 48 02 DB 75 05 8A 1E 46 12 DB 13 C0 EB DC 83 E8 03 72 0F C1 E0 08 AC 83 F0 FF 74 4D D1 F8 8B E8 EB 09 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 13 C9 75 1A 41 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 73 EA 83 C1 02 81 FD 00 FB FF FF 83 D1 01 56 8D 34 2F F3 A4 5E E9 73 FF FF FF C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ST_Protector_V15_Silent_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ST_Protector_V15_Silent_Software"
        weight = 1
    strings:
        $a = { 68 00 1A 40 00 E8 EE FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 ?? ?? ?? ?? ?? ?? 50 72 6F 6A 65 63 74 31 00 ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 06 00 00 00 AC }
        $b = { 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule HQR_data_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HQR_data_file"
        weight = 1
    strings:
        $a = { 48 00 00 00 ?? 02 00 00 ?? ?? 00 00 ?? ?? 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v051: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v051"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 58 83 E8 3D 50 8D B8 ?? ?? ?? FF 57 8D B0 D8 01 ?? ?? 83 CD FF 31 DB ?? ?? ?? ?? 01 DB 75 07 8B 1E 83 EE FC 11 DB 73 0B 8A 06 46 88 07 47 EB EB 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi_vxx_Component: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_vxx_Component"
        weight = 1
    strings:
        $a = { C1 F0 07 EB 02 CD 20 BE 80 ?? ?? 00 1B C6 8D 1D F4 00 00 00 0F B6 06 EB 02 CD 20 8A 16 0F B6 C3 E8 01 00 00 00 DC 59 80 EA 37 EB 02 CD 20 2A D3 EB 02 CD 20 80 EA 73 1B CF 32 D3 C1 C8 0E 80 EA 23 0F B6 C9 02 D3 EB 01 B5 02 D3 EB 02 DB 5B 81 C2 F6 56 7B F6 EB 02 56 7B 2A D3 E8 01 00 00 00 ED 58 88 16 13 C3 46 EB 02 CD 20 4B EB 02 CD 20 2B C9 3B D9 75 A1 E8 02 00 00 00 D7 6B 58 EB 00 9E 96 6A 28 67 AB 69 54 03 3E 7F ?? ?? ?? 31 0D 63 44 35 38 37 18 87 9F 10 8C 37 C6 41 80 4C 5E 8B DB 60 4C 3A 28 08 30 BF 93 05 D1 58 13 2D B8 86 AE C8 58 16 A6 95 C5 94 03 33 6F FF 92 20 98 87 9C E5 B9 20 B5 68 DE 16 4A 15 C1 7F 72 71 65 3E A9 85 20 AF 5A 59 54 26 66 E9 3F 27 DE 8E 7D 34 53 61 F7 AF 09 29 5C F7 36 83 60 5F 52 92 5C D0 56 55 C9 61 7A FD EF 7E E8 70 F8 6E 7B EF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeStealth_WebToolMaster: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeStealth_WebToolMaster"
        weight = 1
    strings:
        $a = { EB 58 53 68 61 72 65 77 61 72 65 2D 56 65 72 73 69 6F 6E 20 45 78 65 53 74 65 61 6C 74 68 2C 20 63 6F 6E 74 61 63 74 20 73 75 70 70 6F 72 74 40 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BeRoEXEPacker_v100_DLL_BeRo_Farbrausch: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BeRoEXEPacker_v100_DLL_BeRo_Farbrausch"
        weight = 1
    strings:
        $a = { 83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8 BA ?? ?? ?? ?? 8D B2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_R_Incremental_Linker_Version_5128078_MASMTASM: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_R_Incremental_Linker_Version_5128078_MASMTASM"
        weight = 1
    strings:
        $a = { 6A 00 68 00 30 40 00 68 1E 30 40 00 6A 00 E8 0D 00 00 00 6A 00 E8 00 00 00 00 FF 25 00 20 40 00 FF 25 08 20 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V119_Dll_aPlib_043_ap0xnbsp_nbsp_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V119_Dll_aPlib_043_ap0xnbsp_nbsp_Sign_by_fly"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 89 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 3C 04 00 00 EB 0C 8B 85 38 04 00 00 89 85 3C 04 00 00 8D B5 60 04 00 00 8D 9D EB 02 00 00 33 FF E8 52 01 00 00 EB 1B 8B 85 3C 04 00 00 FF 74 37 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimplePack_10X_bagie: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimplePack_10X_bagie"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5B 8D 5B FA 6A 00 FF 93 ?? ?? 00 00 89 C5 8B 7D 3C 8D 74 3D 00 8D BE F8 00 00 00 8B 86 88 00 00 00 09 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_116_LZMA_compression_ap0x_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_116_LZMA_compression_ap0x_h"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 5A 0A 00 00 8D 9D 40 02 00 00 33 FF E8 83 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 EB 09 00 00 89 85 3A 0A 00 00 EB 14 60 FF B5 3A 0A 00 00 FF 34 37 FF 74 37 04 FF D3 61 83 C7 08 83 3C 37 00 75 E6 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 EB 09 00 00 89 85 56 0A 00 00 5B 60 FF B5 3A 0A 00 00 56 FF B5 56 0A 00 00 FF D3 61 8B B5 56 0A 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 E8 E7 00 00 00 83 C0 04 89 85 52 0A 00 00 E9 97 00 00 00 56 FF 95 E3 09 00 00 89 85 4E 0A 00 00 85 C0 0F 84 C2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Hasp_4_envelope_dongle_Alladin: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Hasp_4_envelope_dongle_Alladin"
        weight = 1
    strings:
        $a = { 10 02 D0 51 0F 00 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Warning_may_be_SimbyOZ_polycryptor_by_3xpl01t_ver_2xx_25032007_2200: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Warning_may_be_SimbyOZ_polycryptor_by_3xpl01t_ver_2xx_25032007_2200"
        weight = 1
    strings:
        $a = { 57 57 8D 7C 24 04 50 B8 00 D0 17 13 AB 58 5F C3 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v030_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v030_beta_Dwing"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 4C 01 02 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 30 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_2x_SoftComplete_Developement: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_2x_SoftComplete_Developement"
        weight = 1
    strings:
        $a = { A4 ?? ?? 00 00 00 00 00 FF FF FF FF 3C ?? ?? 00 94 ?? ?? 00 D8 ?? ?? 00 00 00 00 00 FF FF FF FF }
        $b = { 51 68 ?? ?? ?? ?? 87 2C 24 8B CD 5D 81 E1 ?? ?? ?? ?? E9 ?? ?? ?? 00 89 45 F8 51 68 ?? ?? ?? ?? 59 81 F1 ?? ?? ?? ?? 0B 0D ?? ?? ?? ?? 81 E9 ?? ?? ?? ?? E9 ?? ?? ?? 00 81 C2 ?? ?? ?? ?? E8 ?? ?? ?? 00 87 0C 24 59 51 64 8B 05 30 00 00 00 8B 40 0C 8B 40 0C }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule RLPack_Full_Edition_117_DLL_Ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_Full_Edition_117_DLL_Ap0x"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v265b1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v265b1"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 38 ?? ?? ?? 68 40 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 28 ?? ?? ?? 33 D2 8A D4 89 15 F4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Anskya_Binder_v11_Anskya: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Anskya_Binder_v11_Anskya"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? 00 BB F8 11 40 00 33 ED 83 EE 04 39 2E 74 11 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v310: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v310"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 E0 97 44 00 68 20 C0 42 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 4C 41 44 00 33 D2 8A D4 89 15 90 A1 44 00 8B C8 81 E1 FF 00 00 00 89 0D 8C A1 44 00 C1 E1 08 03 CA 89 0D 88 A1 44 00 C1 E8 10 A3 84 A1 44 00 33 F6 56 E8 72 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 3D 13 00 00 FF 15 30 40 44 00 A3 84 B7 44 00 E8 FB 11 00 00 A3 E0 A1 44 00 E8 A4 0F 00 00 E8 E6 0E 00 00 E8 4E F6 FF FF 89 75 D0 8D 45 A4 50 FF 15 38 40 44 00 E8 77 0E 00 00 89 45 9C F6 45 D0 01 74 06 0F B7 45 D4 EB 03 6A 0A 58 50 FF 75 9C 56 56 FF 15 7C 41 44 00 50 E8 49 D4 FE FF 89 45 A0 50 E8 3C F6 FF FF 8B 45 EC 8B 08 8B 09 89 4D 98 50 51 E8 B5 0C 00 00 59 59 C3 8B 65 E8 FF 75 98 E8 2E F6 FF FF 83 3D E8 A1 44 00 01 75 05 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule StarForce_ProActive_11_StarForce_Technology: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID StarForce_ProActive_11_StarForce_Technology"
        weight = 1
    strings:
        $a = { 53 55 8B E8 33 DB EB 60 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Stones_PE_Encryptor_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Stones_PE_Encryptor_v10"
        weight = 1
    strings:
        $a = { 60 6A 00 6A 20 6A 02 6A 00 6A 03 68 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_Install_System_20b4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_Install_System_20b4"
        weight = 1
    strings:
        $a = { 83 EC 0C 53 56 57 FF 15 B4 10 40 00 05 E8 03 00 00 BE E0 E3 41 00 89 44 24 10 B3 20 FF 15 28 10 40 00 68 00 04 00 00 FF 15 14 11 40 00 50 56 FF 15 10 11 40 00 80 3D E0 E3 41 00 22 75 08 80 C3 02 BE E1 E3 41 00 8A 06 8B 3D 14 12 40 00 84 C0 74 19 3A C3 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_123_RC4_build_0807_dll_Alexey_Solodovnikov_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_123_RC4_build_0807_dll_Alexey_Solodovnikov_h"
        weight = 1
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Enigma_protector_v102_Vladimir_Sukhov: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Enigma_protector_v102_Vladimir_Sukhov"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ED 06 81 ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 C0 C3 83 C0 08 EB 02 FF 15 89 C4 61 EB 2E EA EB 2B 83 04 24 03 EB 01 00 31 C0 EB 01 85 64 FF 30 EB 01 83 64 89 20 EB 02 CD 20 89 00 9A 64 8F 05 00 00 00 00 EB 02 C1 90 58 61 EB 01 3E BE 01 00 00 00 C1 E6 02 83 EC 04 87 DE 89 1C 24 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEiD_845_624_Six_to_Four_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID 624_Six_to_Four_v10"
        weight = 1
    strings:
        $a = { 50 55 4C 50 83 ?? ?? FC BF ?? ?? BE ?? ?? B5 ?? 57 F3 A5 C3 33 ED }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Ultra_Compressors_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Ultra_Compressors_Archive"
        weight = 1
    strings:
        $a = { 55 43 32 1A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Morphine_v27_Holy_Father_Ratter29A: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Morphine_v27_Holy_Father_Ratter29A"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_PCGuard_403_415_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_PCGuard_403_415_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 }
        $b = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 FC 55 50 E8 00 00 00 00 5D EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule AntiDote_12Demo_SIS_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiDote_12Demo_SIS_Team"
        weight = 1
    strings:
        $a = { E8 F7 FE FF FF 05 CB 22 00 00 FF E0 E8 EB FE FF FF 05 BB 19 00 00 FF E0 E8 BD 00 00 00 08 B2 62 00 01 52 17 0C 0F 2C 2B 20 7F 52 79 01 30 07 17 29 4F 01 3C 30 2B 5A 3D C7 26 11 26 06 59 0E 78 2E 10 14 0B 13 1A 1A 3F 64 1D 71 33 57 21 09 24 8B 1B 09 37 08 61 0F 1D 1D 2A 01 87 35 4C 07 39 0B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v30_DLL_LZMA_Markus_Oberhumer_Laszlo_Molnar_John_Reiser: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v30_DLL_LZMA_Markus_Oberhumer_Laszlo_Molnar_John_Reiser"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 C7 0B 00 00 60 BE 00 ?? ?? ?? 8D BE 00 ?? ?? FF 57 89 E5 8D 9C 24 80 C1 FF FF 31 C0 50 39 DC 75 FB 46 46 53 68 ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Kofax_Group_4_graphics_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Kofax_Group_4_graphics_file"
        weight = 1
    strings:
        $a = { 2E 4B 46 68 80 00 01 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Windows_Write_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Windows_Write_file"
        weight = 1
    strings:
        $a = { ?? BE 00 00 00 AB 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Sun_Icon_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Sun_Icon_Graphics_format"
        weight = 1
    strings:
        $a = { 2F 2A 20 46 6F 72 6D 61 74 5F 76 65 72 73 69 6F 6E 3D 31 2C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v177: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v177"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 B0 71 40 00 68 6C 37 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v171: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v171"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_80: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_80"
        weight = 1
    strings:
        $a = { 48 83 EC 28 E8 ?? ?? 00 00 48 83 C4 28 E9 ?? ?? FF FF CC CC CC CC CC CC CC CC CC CC CC CC CC CC }
        $b = { 83 3D ?? ?? ?? ?? 00 74 1A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 74 0B FF 74 24 04 FF 15 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 75 54 56 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 8B C6 BF ?? ?? ?? ?? 3B C7 59 73 0F 8B 06 85 C0 74 02 FF D0 83 C6 04 3B F7 72 F1 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Obsidium_V130X_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V130X_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 03 ?? ?? ?? E8 2E 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B ?? ?? ?? EB 04 ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? ?? EB 01 ?? 33 C0 EB 04 ?? ?? ?? ?? C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MASMTASM_sig4_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MASMTASM_sig4_h"
        weight = 1
    strings:
        $a = { FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 }
        $b = { C3 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 FF 25 ?? ?? ?? 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule AsCrypt_v01_SToRM_4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AsCrypt_v01_SToRM_4"
        weight = 1
    strings:
        $a = { 80 ?? ?? ?? 83 ?? ?? ?? ?? 90 90 90 E2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AsCrypt_v01_SToRM_2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AsCrypt_v01_SToRM_2"
        weight = 1
    strings:
        $a = { 80 ?? ?? ?? 83 ?? ?? ?? ?? 90 90 90 83 ?? ?? E2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AsCrypt_v01_SToRM_3: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AsCrypt_v01_SToRM_3"
        weight = 1
    strings:
        $a = { 80 ?? ?? ?? 83 ?? ?? ?? ?? 90 90 90 51 ?? ?? ?? 01 00 00 00 83 ?? ?? E2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v108: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v108"
        weight = 1
    strings:
        $a = { 60 EB 03 5D FF E5 E8 F8 FF FF FF 81 ED 1B 6A 44 00 BB 10 6A 44 00 03 DD 2B 9D 2A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CubiComp_PictureMaker_graphics_format_red: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CubiComp_PictureMaker_graphics_format_red"
        weight = 1
    strings:
        $a = { 16 0C FF 02 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v160_v165: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v160_v165"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 80 40 ?? 87 DD 8B 85 D2 80 40 ?? 01 85 33 80 40 ?? 66 C7 85 ?? 80 40 ?? 90 90 01 85 CE 80 40 ?? BB BB 12 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v146: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v146"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 5B 12 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MASM32_TASM32: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MASM32_TASM32"
        weight = 1
    strings:
        $a = { 2B C0 50 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_VCL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_VCL"
        weight = 1
    strings:
        $a = { AC B9 00 80 F2 AE B9 04 00 AC AE 75 ?? E2 FA 89 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Metrowerks_CodeWarrior_DLL_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Metrowerks_CodeWarrior_DLL_v20"
        weight = 1
    strings:
        $a = { 55 89 E5 53 56 57 8B 75 0C 8B 5D 10 83 FE 01 74 05 83 FE 02 75 12 53 56 FF 75 08 E8 6E FF FF FF 09 C0 75 04 31 C0 EB 21 53 56 FF 75 08 E8 ?? ?? ?? ?? 89 C7 09 F6 74 05 83 FE 03 75 0A 53 56 FF 75 08 E8 47 FF FF FF 89 F8 8D 65 F4 5F 5E 5B 5D C2 0C 00 C9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pohernah_Crypter_V102_Kas: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pohernah_Crypter_V102_Kas"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED DE 26 40 00 8B BD 05 28 40 00 8B 8D 0D 28 40 00 B8 25 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 09 28 40 00 31 C0 51 31 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 09 28 40 00 8B 85 11 28 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 89 CE E8 27 00 00 00 89 C1 5F B8 25 28 40 00 01 E8 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 01 28 40 00 89 44 24 1C 61 FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_C_1987: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_C_1987"
        weight = 1
    strings:
        $a = { FB 8C CA 2E 89 16 ?? ?? B4 30 CD 21 8B 2E ?? ?? 8B 1E ?? ?? 8E DA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Video_Lan_Client: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Video_Lan_Client"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Code_Lock: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Code_Lock"
        weight = 1
    strings:
        $a = { 43 4F 44 45 2D 4C 4F 43 4B 2E 4F 43 58 00 01 28 01 50 4B 47 05 4C 3F B4 04 4D 4C 47 4B E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_v31_North_Star: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_v31_North_Star"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? FF FF 8A 03 3C 00 74 10 8D 9D ?? ?? FF FF 8A 03 3C 01 0F 84 42 02 00 00 C6 03 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 68 03 00 00 03 D9 50 53 E8 B1 02 00 00 61 8B 36 8B FD 03 BD ?? ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 36 01 13 8B 33 03 7B 04 57 51 52 53 FF B5 ?? ?? FF FF FF B5 ?? ?? FF FF 8B D6 8B CF 8B 85 ?? ?? FF FF 05 AA 05 00 00 FF D0 5B 5A 59 5F 83 F9 00 74 05 83 C3 08 EB C5 68 00 80 00 00 6A 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_C_1988: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_C_1988"
        weight = 1
    strings:
        $a = { 8C D8 BB ?? ?? 8E DB 8C D3 8B CC FA 8E ?? ?? ?? BC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEBundle_v244: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEBundle_v244"
        weight = 1
    strings:
        $a = { 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB ?? ?? 40 ?? 87 DD 83 BD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SciFax_Graphics_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SciFax_Graphics_file"
        weight = 1
    strings:
        $a = { 44 54 3D 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PolyEnE_001p_by_Lennart_Hedlund: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PolyEnE_001p_by_Lennart_Hedlund"
        weight = 1
    strings:
        $a = { 60 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 60 00 00 E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Solidshield_Protector_V1X_DLL_Solidshield_Technologies_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Solidshield_Protector_V1X_DLL_Solidshield_Technologies_SignByfly"
        weight = 1
    strings:
        $a = { 8B 44 24 08 48 75 0A FF 74 24 04 E8 ?? ?? ?? ?? 59 33 C0 40 C2 0C 00 55 8B EC 56 8B 75 08 85 F6 75 28 68 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 59 59 6A ?? 68 ?? ?? ?? ?? 56 6A ?? FF ?? ?? ?? ?? ?? E9 80 00 00 00 83 FE 01 75 07 5E 5D E9 D2 F6 FF FF 83 FE 02 57 8B 7D 10 75 53 FF 75 24 FF 75 20 FF 75 1C FF 75 18 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 20 3C 01 75 04 8B C6 EB 6A 57 FF 75 0C E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 14 3C 01 74 DF 6A 03 5E 83 FE 03 75 1B 57 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 6A 00 FF 15 ?? ?? ?? ?? 83 FE 04 75 0D FF 75 2C FF 75 28 E8 ?? ?? ?? ?? 59 59 83 FE 05 75 11 FF 75 30 FF 75 2C FF 75 28 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 5F 5E 5D C3 }
        $b = { 8B 44 24 08 48 75 0A FF 74 24 04 E8 ?? ?? ?? ?? 59 33 C0 40 C2 0C 00 55 8B EC 56 8B 75 08 85 F6 75 28 68 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 59 59 6A ?? 68 ?? ?? ?? ?? 56 6A ?? FF ?? ?? ?? ?? ?? E9 80 00 00 00 83 FE 01 75 07 5E 5D E9 D2 F6 FF }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule RLPack_V120_aPlib_043_ap0x_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V120_aPlib_043_ap0x_SignByfly"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 92 05 00 00 EB 0C 8B 85 8E 05 00 00 89 85 92 05 00 00 8D B5 BA 05 00 00 8D 9D 41 04 00 00 33 FF E8 38 01 00 00 EB 1B 8B 85 92 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 9E 05 00 00 00 74 0E 83 BD A2 05 00 00 00 74 05 E8 D6 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 27 05 00 00 89 85 B6 05 00 00 5B FF B5 B6 05 00 00 56 FF D3 83 C4 08 8B B5 B6 05 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 92 05 00 00 83 C0 04 89 85 B2 05 00 00 EB 6E 56 FF 95 1F 05 00 00 0B C0 75 05 E8 C9 02 00 00 85 C0 0F 84 94 00 00 00 89 85 AE 05 00 00 8B C6 EB 2A 8B 85 B2 05 00 00 8B 00 50 FF B5 AE 05 00 00 E8 11 02 00 00 85 C0 74 72 89 07 83 85 B2 05 00 00 04 83 C7 04 8B 85 B2 05 00 00 83 38 00 75 D1 EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD 92 05 00 00 83 C0 04 89 85 B2 05 00 00 80 3E 01 75 8D 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 B6 05 00 00 FF 95 2B 05 00 00 68 00 80 00 00 6A 00 FF B5 B6 05 00 00 FF 95 2B 05 00 00 E8 61 00 00 00 E8 5C 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_v1304_Cyberbob: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_v1304_Cyberbob"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 88 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Soft_Defender_v10_v11: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Soft_Defender_v10_v11"
        weight = 1
    strings:
        $a = { 74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 CD ?? 59 9C 50 74 0A 75 08 E8 59 C2 04 ?? 55 8B EC E8 F4 FF FF FF 56 57 53 78 0F 79 0D E8 34 99 47 49 34 33 EF 31 34 52 47 23 68 A2 AF 47 01 59 E8 ?? ?? ?? ?? 58 05 BA 01 ?? ?? 03 C8 74 BE 75 BC E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Software_Compress_v14_LITE_BG_Software_Protect_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Software_Compress_v14_LITE_BG_Software_Protect_Technologies"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 81 2C 24 AA 1A 41 00 5D E8 00 00 00 00 83 2C 24 6E 8B 85 5D 1A 41 00 29 04 24 8B 04 24 89 85 5D 1A 41 00 58 8B 85 5D 1A 41 00 8B 50 3C 03 D0 8B 92 80 00 00 00 03 D0 8B 4A 58 89 8D 49 1A 41 00 8B 4A 5C 89 8D 4D 1A 41 00 8B 4A 60 89 8D 55 1A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Inno_Installer_v512_collides_with_Borland_Delphi_20_Overlay: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Inno_Installer_v512_collides_with_Borland_Delphi_20_Overlay"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 CC 53 56 57 33 C0 89 45 F0 89 45 DC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Limit_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Limit_Archive"
        weight = 1
    strings:
        $a = { 4C 4D 1A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V121_aPlib_043_ap0xnbsp_nbsp_SignByfly_20080504: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V121_aPlib_043_ap0xnbsp_nbsp_SignByfly_20080504"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 D6 05 00 00 EB 0C 8B 85 D2 05 00 00 89 85 D6 05 00 00 E8 4C 01 00 00 8D B5 FE 05 00 00 8D 9D 85 04 00 00 33 FF E8 77 01 00 00 EB 1B 8B 85 D6 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD E2 05 00 00 00 74 0E 83 BD E6 05 00 00 00 74 05 E8 15 02 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 6B 05 00 00 89 85 FA 05 00 00 5B FF B5 FA 05 00 00 56 FF D3 83 C4 08 8B B5 FA 05 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD D6 05 00 00 83 C0 04 89 85 F6 05 00 00 EB 6E 56 FF 95 63 05 00 00 0B C0 75 05 E8 08 03 00 00 85 C0 0F 84 95 00 00 00 89 85 F2 05 00 00 8B C6 EB 2A 8B 85 F6 05 00 00 8B 00 50 FF B5 F2 05 00 00 E8 50 02 00 00 85 C0 74 73 89 07 83 85 F6 05 00 00 04 83 C7 04 8B 85 F6 05 00 00 83 38 00 75 D1 EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD D6 05 00 00 83 C0 04 89 85 F6 05 00 00 80 3E 01 75 8D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF B5 FA 05 00 00 FF 95 6F 05 00 00 68 ?? ?? ?? ?? 6A 00 FF B5 FA 05 00 00 FF 95 6F 05 00 00 E8 A0 00 00 00 E8 9B 01 00 00 61 E9 ?? ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_LCC_Win32_1x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_LCC_Win32_1x"
        weight = 1
    strings:
        $a = { 64 A1 01 00 00 00 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 9A 10 40 90 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Exe_Guarder_v18_Exeiconcom_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Exe_Guarder_v18_Exeiconcom_h"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 C0 53 56 57 33 C0 89 45 F0 89 45 EC 89 45 C0 E8 5B 73 FF FF E8 D6 87 FF FF E8 C5 A9 FF FF E8 E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_226_DLL_minimum_protection_wwwstrongbitcom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_226_DLL_minimum_protection_wwwstrongbitcom"
        weight = 1
    strings:
        $a = { 50 68 ?? ?? ?? ?? 58 81 E0 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 0C 24 59 E8 ?? ?? ?? 00 89 45 F8 E9 ?? ?? ?? ?? 0F 83 ?? ?? ?? 00 E9 ?? ?? ?? ?? 87 14 24 5A 57 68 ?? ?? ?? ?? E9 ?? ?? ?? ?? 58 81 C0 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? 81 C8 ?? ?? ?? ?? 81 E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v028_039_relocated_image_base_Delphi_NET_DLL_or_something_else_Dwing_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v028_039_relocated_image_base_Delphi_NET_DLL_or_something_else_Dwing_h"
        weight = 1
    strings:
        $a = { 60 E8 09 00 00 00 ?? ?? ?? 00 E9 06 02 00 00 33 C9 5E 87 0E E3 F4 2B F1 8B DE AD 2B D8 AD 03 C3 50 97 AD 91 F3 A5 5E AD 56 91 01 1E AD E2 FB AD 8D 6E 10 01 5D 00 8D 7D 1C B5 ?? F3 AB 5E AD 53 50 51 97 58 8D 54 85 5C FF 16 72 57 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 01 E3 29 8B D7 2B 55 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 56 08 33 C9 FF 66 1C B1 30 8B 5D 0C 03 D1 FF 16 73 4C 03 D1 FF 16 72 19 03 D1 FF 16 72 29 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 45 0C 8A 00 FF 66 18 83 C2 60 FF 16 87 5D 10 73 0C 03 D1 FF 16 87 5D 14 73 03 87 5D 18 3C 07 B0 08 72 02 B0 0B 50 53 8B D5 03 56 38 FF 56 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_v01_Cyberbob: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_v01_Cyberbob"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 8B 95 B3 28 40 00 8B 42 3C 03 C2 89 85 BD 28 40 00 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 9D D1 28 40 00 53 8F 85 C4 27 40 00 BB ?? 00 00 00 B9 A5 08 00 00 8D BD 75 29 40 00 4F 30 1C 39 FE CB E2 F9 68 2D 01 00 00 59 8D BD AA 30 40 00 C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 07 4F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D C4 28 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00 00 00 00 59 81 C1 1D 00 00 00 52 51 C1 E9 05 23 D1 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Encapsulated_Postscript_graphics_file_v30_EPSF_30: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Encapsulated_Postscript_graphics_file_v30_EPSF_30"
        weight = 1
    strings:
        $a = { 25 21 50 53 2D 41 64 6F 62 65 2D 33 2E 30 20 45 50 53 46 2D 33 2E 30 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Crypt_v100v101: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Crypt_v100v101"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? 5B 83 EB 05 EB 04 52 4E 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule C_Cpp_Library_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID C_Cpp_Library_file"
        weight = 1
    strings:
        $a = { F0 0D 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule D1NS1G_D1N: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID D1NS1G_D1N"
        weight = 1
    strings:
        $a = { 18 37 00 00 00 00 00 00 01 00 0A 00 00 00 18 00 00 80 00 00 00 00 ?? ?? 18 37 00 00 00 00 02 00 00 00 88 00 00 80 38 00 00 80 96 00 00 80 50 00 00 80 00 00 00 00 ?? ?? 18 37 00 00 00 00 00 00 01 00 00 00 00 00 68 00 00 00 00 00 00 00 ?? ?? 18 37 00 00 00 00 00 00 01 00 00 00 00 00 78 00 00 00 B0 F0 00 00 10 00 00 00 00 00 00 00 00 00 00 00 C0 F0 00 00 60 00 00 00 00 00 00 00 00 00 00 00 06 00 44 00 56 00 43 00 4C 00 41 00 4C 00 0B 00 50 00 41 00 43 00 4B 00 41 00 47 00 45 00 49 00 4E 00 46 00 4F 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_V194_Markus_Oberhumer_Laszlo_Molnar_John_Reiser: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_V194_Markus_Oberhumer_Laszlo_Molnar_John_Reiser"
        weight = 1
    strings:
        $a = { FF D5 80 A7 ?? ?? ?? ?? ?? 58 50 54 50 53 57 FF D5 58 61 8D 44 24 ?? 6A 00 39 C4 75 FA 83 EC 80 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CrypKey_Kenonic_Controls_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CrypKey_Kenonic_Controls_h"
        weight = 1
    strings:
        $a = { 8B 1D ?? ?? 3E 00 83 FB 00 75 0A E8 3C 00 00 00 E8 ?? 0A 00 00 8B 44 24 08 50 E8 ?? 02 00 00 A1 ?? ?? 3E 00 83 F8 01 74 06 FF 25 14 ?? 3E 00 C3 C8 00 00 00 53 8B 5D 08 33 C0 8B 4D 0C 8B 13 33 D3 83 C3 04 03 C2 49 75 F4 5B C9 C3 56 68 ?? ?? 3E 00 E8 ?? 16 00 00 8B F0 68 ?? ?? 3E 00 56 E8 ?? 16 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? 16 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 ?? ?? 00 00 A3 ?? ?? 3E 00 68 ?? ?? 3E 00 56 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1300_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1300_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 25 00 00 00 }
        $b = { EB 04 25 80 34 CA E8 29 00 00 00 EB 02 C1 81 EB 01 3A 8B 54 24 0C EB 02 32 92 83 82 B8 00 00 00 22 EB 02 F2 7F 33 C0 EB 04 65 7E 14 79 C3 EB 04 05 AD 7F 45 EB 04 05 65 0B E8 64 67 FF 36 00 00 EB 04 0D F6 A8 7F 64 67 89 26 00 00 EB 04 8D 68 C7 FB EB 01 6B }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ASPack_v107b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v107b"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D ?? ?? ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Private_exe_Protector_V25X_V26X_SetiSoft_Team_SignByfly_20080116: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_exe_Protector_V25X_V26X_SetiSoft_Team_SignByfly_20080116"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 10 00 00 ?? ?? ?? ?? 00 04 00 00 00 00 00 00 00 00 00 00 00 00 00 00 20 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 04 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACProtect_v141: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtect_v141"
        weight = 1
    strings:
        $a = { 60 76 03 77 01 7B 74 03 75 01 78 47 87 EE E8 01 00 00 00 76 83 C4 04 85 EE EB 01 7F 85 F2 EB 01 79 0F 86 01 00 00 00 FC EB 01 78 79 02 87 F2 61 51 8F 05 19 38 01 01 60 EB 01 E9 E9 01 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DotFix_Nice_Protect_V21_GPcH_Soft_SignByhaggar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DotFix_Nice_Protect_V21_GPcH_Soft_SignByhaggar"
        weight = 1
    strings:
        $a = { E9 FF 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Embedded_V2422_V2428_Jitit_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_V2422_V2428_Jitit_Sign_by_fly"
        weight = 1
    strings:
        $a = { 6A 00 FF 15 ?? ?? ?? ?? E8 D4 F8 FF FF E9 E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Feokt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Feokt"
        weight = 1
    strings:
        $a = { 89 25 A8 11 40 00 BF ?? ?? ?? 00 31 C0 B9 ?? ?? ?? 00 29 F9 FC F3 AA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? 00 00 BE ?? ?? 40 00 BF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Macromedia_Windows_Flash_ProjectorPlayer_v40: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Macromedia_Windows_Flash_ProjectorPlayer_v40"
        weight = 1
    strings:
        $a = { 83 EC 44 56 FF 15 24 41 43 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule KByS_V022_shoooo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID KByS_V022_shoooo"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3 11 55 07 8B EC B8 ?? ?? ?? ?? E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v098b1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v098b1"
        weight = 1
    strings:
        $a = { E9 25 E4 FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v098b2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v098b2"
        weight = 1
    strings:
        $a = { E9 1B E4 FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule dUP_v2x_Patcher_wwwdiablo2oo2cjbnet: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID dUP_v2x_Patcher_wwwdiablo2oo2cjbnet"
        weight = 1
    strings:
        $a = { 54 68 69 73 20 70 72 6F 67 72 61 6D 20 63 61 6E 6E 6F 74 20 62 65 20 72 75 6E 20 69 6E 20 44 4F 53 20 6D 6F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Themida_18xx_Oreans_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Themida_18xx_Oreans_Technologies"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D 37 ?? ?? ?? FF FF FF FF FF FF FF FF 3D 40 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pe123_v200644: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pe123_v200644"
        weight = 1
    strings:
        $a = { 8B C0 EB 01 34 60 EB 01 2A 9C EB 02 EA C8 E8 0F 00 00 00 EB 03 3D 23 23 EB 01 4A EB 01 5B C3 8D 40 00 53 EB 01 6C EB 01 7E EB 01 8F E8 15 01 00 00 50 E8 67 04 00 00 EB 01 9A 8B D8 FF D3 5B C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 55 8B EC 60 8B 4D 10 8B 7D 0C 8B 75 08 F3 A4 61 5D C2 0C 00 E8 00 00 00 00 58 83 E8 05 C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 E8 00 00 00 00 58 C1 E8 0C C1 E0 0C 66 81 38 4D 5A 74 0C 2D 00 10 00 00 66 81 38 4D 5A 75 F4 C3 E8 00 00 00 00 58 83 E8 05 C3 8B C0 55 8B EC 81 C4 B8 FE FF FF 6A 40 8D 45 B0 50 E8 C0 FF FF FF 50 E8 8E FF FF FF 68 F8 00 00 00 8D 85 B8 FE FF FF 50 E8 A9 FF FF FF 03 45 EC 50 E8 74 FF FF FF E8 9B FF FF FF 03 85 38 FF FF FF 83 C0 34 89 45 FC E8 8A FF FF FF 03 85 38 FF FF FF 83 C0 38 89 45 F4 8B 45 FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule APEX_C_BLT_Apex_40_500mhz: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID APEX_C_BLT_Apex_40_500mhz"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? B9 FF FF FF 00 01 D0 F7 E2 72 01 48 E2 F7 B9 FF 00 00 00 8B 34 24 80 36 FD 46 E2 FA C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_BJFNT_13_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_BJFNT_13_emadicius"
        weight = 1
    strings:
        $a = { EB 03 3A 4D 3A 1E EB 02 CD 20 9C EB 02 CD 20 EB 02 CD 20 60 EB 02 C7 05 EB 02 CD 20 E8 03 00 00 00 E9 EB 04 58 40 50 C3 61 9D 1F EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule bambam_004_bedrock: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID bambam_004_bedrock"
        weight = 1
    strings:
        $a = { BF ?? ?? ?? ?? 83 C9 FF 33 C0 68 ?? ?? ?? ?? F2 AE F7 D1 49 51 68 ?? ?? ?? ?? E8 11 0A 00 00 83 C4 0C 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 BF ?? ?? ?? ?? 83 C9 FF 33 C0 F2 AE F7 D1 49 BF ?? ?? ?? ?? 8B D1 68 ?? ?? ?? ?? C1 E9 02 F3 AB 8B CA 83 E1 03 F3 AA BF ?? ?? ?? ?? 83 C9 FF 33 C0 F2 AE F7 D1 49 51 68 ?? ?? ?? ?? E8 C0 09 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_Pascal_v55_Unit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_Pascal_v55_Unit"
        weight = 1
    strings:
        $a = { 54 50 55 36 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Cpp"
        weight = 1
    strings:
        $a = { A1 ?? ?? ?? ?? C1 E0 02 A3 ?? ?? ?? ?? 57 51 33 C0 BF ?? ?? ?? ?? B9 ?? ?? ?? ?? 3B CF 76 05 2B CF FC F3 AA 59 5F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HPACK_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HPACK_Archive"
        weight = 1
    strings:
        $a = { 48 50 41 4B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule North_Star_PE_Shrinker_v13_by_Liuxingping: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID North_Star_PE_Shrinker_v13_by_Liuxingping"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 73 ?? FF FF 8B 06 83 F8 00 74 11 8D B5 7F ?? FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 C7 06 01 00 00 00 8B D5 8B 85 4F ?? FF FF 2B D0 89 95 4F ?? FF FF 01 95 67 ?? FF FF 8D B5 83 ?? FF FF 01 16 8B 36 8B FD 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 A3 ?? FF FF 85 C0 0F 84 06 03 00 00 89 85 63 ?? FF FF E8 00 00 00 00 5B B9 31 89 40 00 81 E9 2E 86 40 00 03 D9 50 53 E8 3D 02 00 00 61 03 BD 47 ?? FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 2D 01 13 8B 33 03 7B 04 57 51 52 53 FF B5 A7 ?? FF FF FF B5 A3 ?? FF FF 56 57 FF 95 63 ?? FF FF 5B 5A 59 5F 83 F9 00 74 05 83 C3 08 EB CE 68 00 80 00 00 6A 00 FF B5 63 ?? FF FF FF 95 A7 ?? FF FF 8D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_MSVCpp_70_DLL_Method_3_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_MSVCpp_70_DLL_Method_3_emadicius"
        weight = 1
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 5F 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressor_13_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_13_CGSoftLabs"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC ?? 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 33 2E 2E }
        $b = { 55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 32 2E 2E B8 ?? ?? ?? 00 2B 05 84 ?? ?? 00 A3 ?? ?? ?? 00 83 3D ?? ?? ?? 00 00 74 16 A1 ?? ?? ?? 00 03 05 80 ?? ?? 00 89 85 54 FE FF FF E9 ?? 07 00 00 C7 05 ?? ?? ?? 00 01 00 00 00 68 04 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Microsoft_Visual_Cpp_70_80: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_70_80"
        weight = 1
    strings:
        $a = { 53 56 8B 44 24 18 0B C0 75 18 8B 4C 24 14 8B 44 24 10 33 D2 F7 F1 8B D8 8B 44 24 0C F7 F1 8B D3 EB 41 8B C8 8B 5C 24 14 8B 54 24 10 8B 44 24 0C D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 18 8B C8 8B 44 24 14 F7 E6 03 D1 72 0E 3B 54 24 10 77 08 72 07 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Installer_VISE_Custom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Installer_VISE_Custom"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 ?? ?? 40 00 33 D2 8A D4 89 15 ?? ?? 40 00 8B C8 81 E1 FF 00 00 00 89 0D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _Protector_v1111_DDeM_PE_Engine_v09_DDeM_CI_v092: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _Protector_v1111_DDeM_PE_Engine_v09_DDeM_CI_v092"
        weight = 1
    strings:
        $a = { 53 51 56 E8 00 00 00 00 5B 81 EB 08 10 00 00 8D B3 34 10 00 00 B9 F3 03 00 00 BA 63 17 2A EE 31 16 83 C6 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_099_tE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_099_tE"
        weight = 1
    strings:
        $a = { E9 5E DF FF FF 00 00 00 ?? ?? ?? ?? E5 ?? ?? 00 00 00 00 00 00 00 00 00 05 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeJoiner_153_Stub_engine_171_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeJoiner_153_Stub_engine_171_GlOFF"
        weight = 1
    strings:
        $a = { E8 02 FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A8 10 40 00 }
        $b = { 86 D6 90 86 F2 B9 93 60 08 FE 90 86 D6 90 86 F2 B9 9D 13 45 01 86 D6 90 86 F2 81 C2 93 60 08 FE 33 C9 B9 30 74 4D FF 86 D6 90 86 F2 33 C9 C7 05 B4 17 40 00 00 00 00 00 90 68 00 01 00 00 68 D1 17 40 00 6A 00 E8 CE 02 00 00 90 33 C9 86 D6 90 86 F2 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 D1 17 40 00 E8 9E 02 00 00 A3 CD 17 40 00 86 D6 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PESpin_07_Cyberbob_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_07_Cyberbob_h"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 B7 CD 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LZEXE_v091_v100a_3: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LZEXE_v091_v100a_3"
        weight = 1
    strings:
        $a = { 50 06 0E 1F 8B 0E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LZEXE_v091_v100a_2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LZEXE_v091_v100a_2"
        weight = 1
    strings:
        $a = { BF ?? ?? 06 89 F9 0E 41 1F 8C CB 89 FE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_13037_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_13037_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 01 ?? 58 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_500_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_500_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { E8 E3 40 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 44 15 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 36 13 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 C7 12 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? 03 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 48 11 00 00 59 89 7D FC FF 75 08 E8 01 49 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 66 D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 AF F9 FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 EE 0F 00 00 59 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_bartxt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_bartxt"
        weight = 1
    strings:
        $a = { 80 E9 A1 C1 C1 13 68 E4 16 75 46 C1 C1 05 5E EB 01 9D 68 64 86 37 46 EB 02 8C E0 5F F7 D0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VcAsm_Protector_V10X_VcAsm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VcAsm_Protector_V10X_VcAsm"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Free_Pascal_v1010_win32_console: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Free_Pascal_v1010_win32_console"
        weight = 1
    strings:
        $a = { C6 05 ?? ?? ?? 00 01 E8 ?? ?? 00 00 C6 05 ?? ?? ?? 00 00 E8 ?? ?? 00 00 50 E8 00 00 00 00 FF 25 ?? ?? ?? 00 55 89 E5 ?? EC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V112_LZMA_430_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V112_LZMA_430_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB ?? 60 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEEncrypt_v40b_JunkCode: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEEncrypt_v40b_JunkCode"
        weight = 1
    strings:
        $a = { 66 ?? ?? 00 66 83 ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MASM32: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MASM32"
        weight = 1
    strings:
        $a = { 6A ?? 68 00 30 40 00 68 ?? 30 40 00 6A 00 E8 07 00 00 00 6A 00 E8 06 00 00 00 FF 25 08 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Free_Pascal_09910: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Free_Pascal_09910"
        weight = 1
    strings:
        $a = { E8 00 6E 00 00 55 89 E5 8B 7D 0C 8B 75 08 89 F8 8B 5D 10 29 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NTkrnl_Secure_Suite_01_015_NTkrnl_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NTkrnl_Secure_Suite_01_015_NTkrnl_Software"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 68 ?? ?? ?? ?? E8 01 00 00 00 C3 C3 }
        $b = { 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 79 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule RCryptor_v20_Hide_EP_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_v20_Hide_EP_Vaska"
        weight = 1
    strings:
        $a = { F7 D1 83 F1 FF 6A 00 F7 D1 83 F1 FF 81 04 24 DC 20 ?? 00 F7 D1 83 F1 FF E8 00 00 00 00 F7 D1 83 F1 FF C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_v1304_Obsidium_Software_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_v1304_Obsidium_Software_h"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 25 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 23 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_C_20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_C_20"
        weight = 1
    strings:
        $a = { 53 56 57 BB ?? ?? ?? ?? 8B ?? ?? ?? 55 3B FB 75 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeShield_Protector_V36_wwwexeshieldcom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeShield_Protector_V36_wwwexeshieldcom"
        weight = 1
    strings:
        $a = { 2C 71 1B CA EB 01 2A EB 01 65 8D 35 80 ?? ?? 00 80 C9 84 80 C9 68 BB F4 00 00 00 EB 01 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v3xx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v3xx"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 58 83 ?? ?? 50 8D ?? ?? ?? ?? ?? 57 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 ?? ?? 31 DB ?? ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WWPACK_v300_v301_Relocations_pack: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WWPACK_v300_v301_Relocations_pack"
        weight = 1
    strings:
        $a = { BE ?? ?? BA ?? ?? BF ?? ?? B9 ?? ?? 8C CD 8E DD 81 ED ?? ?? 06 06 8B DD 2B DA 8B D3 FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V039_V0399_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V039_V0399_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { 58 8D 54 83 58 FF 16 72 4F 04 FD 1A D2 22 C2 3C 07 73 F6 50 0F B6 6F FF ?? ?? ?? 66 69 ED 00 03 8D AC AB 08 10 00 00 57 B0 01 E3 1F 2B 7B 08 84 0F 0F 95 C4 FE C4 8D 54 85 00 FF 16 12 C0 D0 E9 74 0E 2A E0 80 E4 01 75 E6 33 C9 B5 01 FF 56 50 33 C9 5F E9 F2 00 00 00 04 F9 1A C0 B1 30 24 03 8B 6B 08 04 08 03 D1 FF 16 73 42 03 D1 FF 16 72 14 03 D1 FF 16 72 24 0C 01 50 8B C7 2B 43 08 B1 80 8A 00 EB CE 83 C2 60 FF 16 87 6B 0C 73 0C 03 D1 FF 16 87 6B 10 73 03 87 6B 14 50 55 8D 93 78 07 00 00 FF 56 54 5D 91 E9 8F 00 00 00 48 87 6B 0C 50 87 6B 10 8D 93 C0 0B 00 00 89 6B 14 FF 56 54 6A 03 59 50 48 3B C1 72 02 8B C1 B1 40 F6 E1 8D AC 83 78 03 00 00 FF 56 4C 3C 04 8B E8 72 5A 33 ED D1 E8 83 D5 02 48 91 D3 E5 80 F9 05 8D 94 AB 78 01 00 00 76 2B 80 E9 04 33 C0 8B 53 FC D1 2B 8B 12 0F CA 2B 53 04 03 C0 3B 13 72 06 8B 13 40 01 53 04 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unnamed_Scrambler_20_p0ke: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unnamed_Scrambler_20_p0ke"
        weight = 1
    strings:
        $a = { 55 8B EC B9 0A 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 B8 1C 2F 40 00 E8 C8 F1 FF FF 33 C0 55 68 FB 33 40 00 64 FF 30 64 89 20 BA 0C 34 40 00 B8 E4 54 40 00 E8 EF FE FF FF 8B D8 85 DB 75 07 6A 00 E8 5A F2 FF FF BA E8 54 40 00 8B C3 8B 0D E4 54 40 00 E8 74 E2 FF FF C7 05 20 6B 40 00 09 00 00 00 BB 98 69 40 00 C7 45 EC E8 54 40 00 C7 45 E8 31 57 40 00 C7 45 E4 43 60 40 00 BE D3 6A 40 00 BF E0 6A 40 00 83 7B 04 00 75 0B 83 3B 00 0F 86 AA 03 00 00 EB 06 0F 8E A2 03 00 00 8B 03 8B D0 B8 0C 6B 40 00 E8 C1 EE FF FF B8 0C 6B 40 00 E8 6F EE FF FF 8B D0 8B 45 EC 8B 0B E8 0B E2 FF FF 6A 00 6A 1E 6A 00 6A 2C A1 0C 6B 40 00 E8 25 ED FF FF 8D 55 E0 E8 15 FE FF FF 8B 55 E0 B9 10 6B 40 00 A1 0C 6B 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_Full_Edition_117_iBox_LZMA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_Full_Edition_117_iBox_LZMA"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 67 30 00 00 8D 9D 66 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_099: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_099"
        weight = 1
    strings:
        $a = { E9 5E DF FF FF 00 00 00 ?? ?? ?? ?? E5 ?? ?? 00 00 00 00 00 00 00 00 00 05 ?? ?? 00 F5 ?? ?? 00 ED ?? ?? 00 00 00 00 00 00 00 00 00 12 ?? ?? 00 FD ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 1D ?? ?? 00 00 00 00 00 30 ?? ?? 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXEPACK_v531009_LINK_v369: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXEPACK_v531009_LINK_v369"
        weight = 1
    strings:
        $a = { 8B E8 8C C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_16c_by_Vaska_UsAr_sign_21032007_2225: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_16c_by_Vaska_UsAr_sign_21032007_2225"
        weight = 1
    strings:
        $a = { 33 D0 68 40 A1 14 13 FF D2 B8 00 10 14 13 3D 24 C0 14 13 74 06 80 30 BB 40 EB F3 33 C0 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Gleam_100: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Gleam_100"
        weight = 1
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0B 83 EC 0C 53 56 57 E8 24 02 00 FF E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DEF_v100_Eng_bartxt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DEF_v100_Eng_bartxt"
        weight = 1
    strings:
        $a = { BE ?? 01 40 00 6A ?? 59 80 7E 07 00 74 11 8B 46 0C 05 00 00 40 00 8B 56 10 30 10 40 4A 75 FA 83 C6 28 E2 E4 68 ?? ?? 40 00 C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_V50X_Silicon_Realms_Toolworks_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_V50X_Silicon_Realms_Toolworks_SignByfly"
        weight = 1
    strings:
        $a = { E8 E3 40 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 44 15 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 36 13 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 C7 12 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? 03 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 48 11 00 00 59 89 7D FC ?? 75 08 E8 01 49 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 66 D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 AF F9 FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 EE 0F 00 00 59 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule kkrunchy_023_alpha_2_Ryd: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID kkrunchy_023_alpha_2_Ryd"
        weight = 1
    strings:
        $a = { BD ?? ?? ?? ?? C7 45 00 ?? ?? ?? 00 B8 ?? ?? ?? 00 89 45 04 89 45 54 50 C7 45 10 ?? ?? ?? 00 FF 4D 0C FF 45 14 FF 45 58 C6 45 1C 08 B8 00 08 00 00 8D 7D 30 AB AB AB AB BB 00 00 D8 00 BF ?? ?? ?? 01 31 C9 41 8D 74 09 01 B8 CA 8E 2A 2E 99 F7 F6 01 C3 89 D8 C1 E8 15 AB FE C1 75 E8 BE }
        $b = { BD ?? ?? ?? ?? C7 45 00 ?? ?? ?? 00 B8 ?? ?? ?? 00 89 45 04 89 45 54 50 C7 45 10 ?? ?? ?? 00 FF 4D 0C FF 45 14 FF 45 58 C6 45 1C 08 B8 00 08 00 00 8D 7D 30 AB AB AB AB BB 00 00 D8 00 BF ?? ?? ?? 01 31 C9 41 8D 74 09 01 B8 CA 8E 2A 2E 99 F7 F6 01 C3 89 D8 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ICE_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ICE_Archive"
        weight = 1
    strings:
        $a = { ?? ?? 2D 6C 68 ?? 2D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_Install_System_v198: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_Install_System_v198"
        weight = 1
    strings:
        $a = { 83 EC 0C 53 56 57 FF 15 2C 81 40 }
        $b = { 83 EC 14 83 64 24 04 00 53 55 56 57 C6 44 24 13 20 FF 15 30 70 40 00 BE 00 20 7A 00 BD 00 04 00 00 56 55 FF 15 C4 70 40 00 56 E8 7D 2B 00 00 8B 1D 8C 70 40 00 6A 00 56 FF D3 BF 80 92 79 00 56 57 E8 15 26 00 00 85 C0 75 38 68 F8 91 40 00 55 56 FF 15 60 71 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Armadillo_310: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_310"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 E0 97 44 00 68 20 C0 42 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 4C 41 44 00 33 D2 8A D4 89 15 90 A1 44 00 8B C8 81 E1 FF 00 00 00 89 0D 8C A1 44 00 C1 E1 08 03 CA 89 0D 88 A1 44 00 C1 E8 10 A3 84 A1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_22004810_22005314_WFS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_22004810_22005314_WFS"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 7A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AZProtect: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AZProtect"
        weight = 1
    strings:
        $a = { EB 70 FC 60 8C 80 4D 11 00 70 25 81 00 40 0D 91 BB 60 8C 80 4D 11 00 70 21 81 1D 61 0D 81 00 40 CE 60 8C 80 4D 11 00 70 25 81 25 81 25 81 25 81 29 61 41 81 31 61 1D 61 00 40 B7 30 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEQuake_v006_forgotus_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEQuake_v006_forgotus_h"
        weight = 1
    strings:
        $a = { E8 A5 00 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 3D ?? 00 00 2D ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4A ?? 00 00 5B ?? 00 00 6E ?? 00 00 00 00 00 00 6B 45 72 4E 65 4C 33 32 2E 64 4C 6C 00 00 00 47 65 74 50 72 6F 63 41 64 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v71_EXE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v71_EXE"
        weight = 1
    strings:
        $a = { 6A ?? 68 ?? ?? ?? 01 E8 ?? ?? 00 00 66 81 3D 00 00 00 01 4D 5A 75 ?? A1 3C 00 00 01 ?? ?? 00 00 00 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SND_music_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SND_music_file"
        weight = 1
    strings:
        $a = { 00 00 F8 2A ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Sc_Obfuscator_SuperCRacker: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Sc_Obfuscator_SuperCRacker"
        weight = 1
    strings:
        $a = { 60 33 C9 8B 1D 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Mew_10_exe_coder_10_Northfox_HCC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Mew_10_exe_coder_10_Northfox_HCC"
        weight = 1
    strings:
        $a = { 33 C0 E9 ?? ?? FF FF 6A ?? ?? ?? ?? ?? 70 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nSpack_V23_LiuXingPing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nSpack_V23_LiuXingPing"
        weight = 1
    strings:
        $a = { 9C 60 70 61 63 6B 24 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Private_EXE_Protector_20_SetiSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_EXE_Protector_20_SetiSoft"
        weight = 1
    strings:
        $a = { 89 ?? ?? 38 00 00 00 8B ?? 00 00 00 00 81 ?? ?? ?? ?? ?? 89 ?? 00 00 00 00 81 ?? 04 00 00 00 81 ?? 04 00 00 00 81 ?? 00 00 00 00 0F 85 D6 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_20x_Heuristic_Mode_Jeremy_Collake: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_20x_Heuristic_Mode_Jeremy_Collake"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v260c: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v260c"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 40 ?? ?? ?? 68 F4 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 6C ?? ?? ?? 33 D2 8A D4 89 15 F4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_110_Eng_dulekxt_Borland_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_110_Eng_dulekxt_Borland_Cpp"
        weight = 1
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pelles_C_300_400_450_EXE_X86_CRT_LIB: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pelles_C_300_400_450_EXE_X86_CRT_LIB"
        weight = 1
    strings:
        $a = { 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 53 56 57 89 65 E8 68 00 00 00 02 E8 ?? ?? ?? ?? 59 A3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CreateInstall_Stub_vxx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CreateInstall_Stub_vxx"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 20 02 00 00 53 56 57 6A 00 FF 15 18 61 40 00 68 00 70 40 00 89 45 08 FF 15 14 61 40 00 85 C0 74 27 6A 00 A1 00 20 40 00 50 FF 15 3C 61 40 00 8B F0 6A 06 56 FF 15 38 61 40 00 6A 03 56 FF 15 38 61 40 00 E9 36 03 00 00 68 02 7F 00 00 33 F6 56 BF 00 30 00 00 FF 15 20 61 40 00 50 FF 15 2C 61 40 00 6A 04 57 68 00 FF 01 00 56 FF 15 CC 60 40 00 6A 04 A3 CC 35 40 00 57 68 00 0F 01 00 56 FF 15 CC 60 40 00 68 00 01 00 00 BE B0 3F 40 00 56 A3 C4 30 40 00 FF 75 08 FF 15 10 61 40 00 }
        $b = { 81 EC 0C 04 00 00 53 56 57 55 68 60 50 40 00 6A 01 6A 00 FF 15 D8 80 40 00 8B F0 FF 15 D4 80 40 00 3D B7 00 00 00 75 0F 56 FF 15 B8 80 40 00 6A 02 FF 15 A4 80 40 00 33 DB E8 F2 FE FF FF 68 02 7F 00 00 89 1D 94 74 40 00 53 89 1D 98 74 40 00 FF 15 E4 80 40 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule MS_Run_Time_Library_1992_11: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Run_Time_Library_1992_11"
        weight = 1
    strings:
        $a = { B4 51 CD 21 8E DB B8 ?? ?? 83 E8 ?? 8E C0 33 F6 33 FF B9 ?? ?? FC F3 A5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_Run_Time_Library_1992_13: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Run_Time_Library_1992_13"
        weight = 1
    strings:
        $a = { BF ?? ?? 8E DF FA 8E D7 81 C4 ?? ?? FB 33 DB B8 ?? ?? CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEiD_973_3DMark_Database_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID 3DMark_Database_file"
        weight = 1
    strings:
        $a = { 33 44 4D 61 72 6B 20 44 61 74 61 62 61 73 65 20 46 69 6C 65 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_vxx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_vxx"
        weight = 1
    strings:
        $a = { 90 60 ?? ?? ?? 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeShield_36_wwwexeshieldcom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeShield_36_wwwexeshieldcom"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? 00 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 6F 6D 70 61 63 74 32 00 CE 1E 42 AF F8 D6 CC E9 FB C8 4F 1B 22 7C B4 C8 0D BD 71 A9 C8 1F 5F B1 29 8F 11 73 8F 00 D1 88 87 A9 3F 4D 00 6C 3C BF C0 80 F7 AD 35 23 EB 84 82 6F 8C B9 0A FC EC E4 82 97 AE 0F 18 D2 47 1B 65 EA 46 A5 FD 3E 9D 75 2A 62 80 60 F9 B0 0D E1 AC 12 0E 9D 24 D5 43 CE 9A D6 18 BF 22 DA 1F 72 76 B0 98 5B C2 64 BC AE D8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FakeNinja_V28_Private_Spirit_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FakeNinja_V28_Private_Spirit_SignByfly"
        weight = 1
    strings:
        $a = { 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 17 E5 FF 60 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule fEaRzCrypter_v10_fEaRz: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID fEaRzCrypter_v10_fEaRz"
        weight = 1
    strings:
        $a = { 55 8B EC B9 09 00 00 00 6A 00 6A 00 49 75 ?? 53 56 57 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 85 DB 75 ?? 6A 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CodeCrypt_v014b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CodeCrypt_v014b"
        weight = 1
    strings:
        $a = { E9 C5 02 00 00 EB 02 83 3D 58 EB 02 FF 1D 5B EB 02 0F C7 5F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSVCpp_v8_procedure_1_recognized_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSVCpp_v8_procedure_1_recognized_h"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 83 65 F8 00 83 65 FC 00 53 57 BF 4E E6 40 BB 3B C7 BB 00 00 FF FF 74 0D 85 C3 74 09 F7 D0 A3 ?? ?? ?? ?? EB 60 56 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 75 FC 33 75 F8 FF 15 ?? ?? ?? ?? 33 F0 FF 15 ?? ?? ?? ?? 33 F0 FF 15 ?? ?? ?? ?? 33 F0 8D 45 F0 50 FF 15 ?? ?? ?? ?? 8B 45 F4 33 45 F0 33 F0 3B F7 75 07 BE 4F E6 40 BB EB 0B 85 F3 75 07 8B C6 C1 E0 10 0B F0 89 35 ?? ?? ?? ?? F7 D6 89 35 ?? ?? ?? ?? 5E 5F 5B C9 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v099: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v099"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 2F 85 40 ?? 87 DD 8B 85 B4 85 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v090: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v090"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? 40 00 C3 9C 60 BD ?? ?? 00 00 B9 02 00 00 00 B0 90 8D BD 7A 42 40 00 F3 AA 01 AD D9 43 40 00 FF B5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v092: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v092"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 BD ?? ?? ?? ?? B9 02 ?? ?? ?? B0 90 8D BD A5 4F 40 ?? F3 AA 01 AD 04 51 40 ?? FF B5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v094: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v094"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 ?? ?? ?? ?? 5D 55 58 81 ED ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 01 85 ?? ?? ?? ?? 50 B9 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_PENightMare_2_Beta: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_PENightMare_2_Beta"
        weight = 1
    strings:
        $a = { 60 E9 10 00 00 00 EF 40 03 A7 07 8F 07 1C 37 5D 43 A7 04 B9 2C 3A E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_VIRUSI_Worm_Hybris_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_VIRUSI_Worm_Hybris_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 EB 16 A8 54 00 00 47 41 42 4C 4B 43 47 43 00 00 00 00 00 00 52 49 53 00 FC 68 4C 70 40 00 FF 15 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Safedisc_V450000_Macrovision_Corporation_SignByfly_20080117: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Safedisc_V450000_Macrovision_Corporation_SignByfly_20080117"
        weight = 1
    strings:
        $a = { 55 8B EC 60 BB 6E ?? ?? ?? B8 0D ?? ?? ?? 33 C9 8A 08 85 C9 74 0C B8 E4 ?? ?? ?? 2B C3 83 E8 05 EB 0E 51 B9 2B ?? ?? ?? 8B C1 2B C3 03 41 01 59 C6 03 E9 89 43 01 51 68 D9 ?? ?? ?? 33 C0 85 C9 74 05 8B 45 08 EB 00 50 E8 25 FC FF FF 83 C4 08 59 83 F8 00 74 1C C6 03 C2 C6 43 01 0C 85 C9 74 09 61 5D B8 00 00 00 00 EB 96 50 B8 F9 ?? ?? ?? FF 10 61 5D EB 47 80 7C 24 08 00 75 40 51 8B 4C 24 04 89 0D ?? ?? ?? ?? B9 02 ?? ?? ?? 89 4C 24 04 59 EB 29 50 B8 FD ?? ?? ?? FF 70 08 8B 40 0C FF D0 B8 FD ?? ?? ?? FF 30 8B 40 04 FF D0 58 B8 25 ?? ?? ?? FF 30 C3 72 16 61 13 60 0D E9 ?? ?? ?? ?? 66 83 3D ?? ?? ?? ?? ?? 74 05 E9 91 FE FF FF C3 }
        $b = { 55 8B EC 60 BB 6E ?? ?? ?? B8 0D ?? ?? ?? 33 C9 8A 08 85 C9 74 0C B8 E4 ?? ?? ?? 2B C3 83 E8 05 EB 0E 51 B9 2B ?? ?? ?? 8B C1 2B C3 03 41 01 59 C6 03 E9 89 43 01 51 68 D9 ?? ?? ?? 33 C0 85 C9 74 05 8B 45 08 EB 00 50 E8 25 FC FF FF 83 C4 08 59 83 F8 00 74 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule tElock_v041x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v041x"
        weight = 1
    strings:
        $a = { E9 ?? ?? FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? 02 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? 02 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeSafeguard_v10_simonzh: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeSafeguard_v10_simonzh"
        weight = 1
    strings:
        $a = { C0 5D EB 4E EB 47 DF 69 4E 58 DF 59 74 F3 EB 01 DF 75 EE 9A 59 9C 81 C1 E2 FF FF FF EB 01 DF 9D FF E1 E8 51 E8 EB FF FF FF DF 22 3F 9A C0 81 ED 19 18 40 00 EB 48 EB 47 DF 69 4E 58 DF 59 79 EE EB 01 DF 78 E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF DF BA A3 22 3F 9A C0 60 EB 4D EB 47 DF 69 4E 58 DF 59 79 F3 EB 01 DF 78 EE DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF E8 BA A3 22 3F 9A C0 8D B5 EE 19 40 00 EB 47 EB 47 DF 69 4E 58 DF 59 7A EE EB 01 DF 7B E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF DF 22 3F 9A C0 8B FE EB 4C EB 47 DF 69 4E 58 DF 59 74 F2 EB 01 DF 75 ED 0F 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE FF FF FF E8 BA A3 22 3F 9A C0 B9 2B CB 00 00 EB 4B EB 47 DF 69 4E 58 DF 59 78 EF }
        $b = { C0 5D EB 4E EB 47 DF 69 4E 58 DF 59 74 F3 EB 01 DF 75 EE 9A 59 9C 81 C1 E2 FF FF FF EB 01 DF 9D FF E1 E8 51 E8 EB FF FF FF DF 22 3F 9A C0 81 ED 19 18 40 00 EB 48 EB 47 DF 69 4E 58 DF 59 79 EE EB 01 DF 78 E9 DF 59 9C 81 C1 E5 FF FF FF 9D FF E1 EB 51 E8 EE }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Microsoft_Visual_Cpp_vxx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_vxx"
        weight = 1
    strings:
        $a = { 55 8B EC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WinZip_32_bit_6x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WinZip_32_bit_6x"
        weight = 1
    strings:
        $a = { FF 15 ?? ?? ?? 00 B1 22 38 08 74 02 B1 20 40 80 38 00 74 10 38 08 74 06 40 80 38 00 75 F6 80 38 00 74 01 40 33 C9 ?? ?? ?? ?? FF 15 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ProActivate_V10X_TurboPower_Software_Company: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ProActivate_V10X_TurboPower_Software_Company"
        weight = 1
    strings:
        $a = { 55 8B EC B9 0E 00 00 00 6A 00 6A 00 49 75 F9 51 53 56 57 B8 ?? ?? ?? ?? 90 90 90 90 90 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? 83 C0 05 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 0D 00 00 00 E8 85 E2 FF FF 81 3D ?? ?? ?? ?? 21 7E 7E 40 75 7A 81 3D ?? ?? ?? ?? 43 52 43 33 75 6E 81 3D ?? ?? ?? ?? 32 40 7E 7E 75 62 81 3D ?? ?? ?? ?? 21 7E 7E 40 75 56 81 3D ?? ?? ?? ?? 43 52 43 33 75 4A 81 3D ?? ?? ?? ?? 32 40 7E 7E 75 3E 81 3D ?? ?? ?? ?? 21 7E 7E 40 75 32 81 3D ?? ?? ?? ?? 43 52 43 33 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_C_19881989: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_C_19881989"
        weight = 1
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? CD 20 BF ?? ?? 8B ?? ?? ?? 2B F7 81 ?? ?? ?? 72 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Inno_Installer_v512: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Inno_Installer_v512"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 58 BB DC 1E 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 50 00 00 68 D8 00 00 00 E8 C1 FE FF FF E9 97 FF FF FF CC CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule aPack_v098b_DS_ES_not_saved: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID aPack_v098b_DS_ES_not_saved"
        weight = 1
    strings:
        $a = { 8C CB BA ?? ?? 03 DA FC 33 F6 33 FF 4B 8E DB 8D ?? ?? ?? 8E C0 B9 ?? ?? F3 A5 4A 75 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VBOX_v42_MTE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VBOX_v42_MTE"
        weight = 1
    strings:
        $a = { 8C E0 0B C5 8C E0 0B C4 03 C5 74 00 74 00 8B C5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PseudoSigner_01_Morphine_12: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PseudoSigner_01_Morphine_12"
        weight = 1
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 EB 08 E8 90 00 00 00 66 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 51 66 90 90 90 59 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 E2 90 90 90 EB 08 82 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 01 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pohernah_102_by_Kas: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pohernah_102_by_Kas"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED DE 26 40 00 8B BD 05 28 40 00 8B 8D 0D 28 40 00 B8 25 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 09 28 40 00 31 C0 51 31 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 09 28 40 00 8B 85 11 28 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 89 CE E8 27 00 00 00 89 C1 5F B8 25 28 40 00 01 E8 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 01 28 40 00 89 44 24 1C 61 FF E0 56 57 4F F7 D7 21 FE 89 F0 5F 5E C3 60 83 F0 05 40 90 48 83 F0 05 89 C6 89 D7 60 E8 0B 00 00 00 61 83 C7 08 83 E9 07 E2 F1 61 C3 57 8B 1F 8B 4F 04 68 B9 79 37 9E 5A 42 89 D0 48 C1 E0 05 BF 20 00 00 00 4A 89 DD C1 E5 04 29 E9 8B 6E 08 31 DD 29 E9 89 DD C1 ED 05 31 C5 29 E9 2B 4E 0C 89 CD C1 E5 04 29 EB 8B 2E 31 CD 29 EB 89 CD C1 ED 05 31 C5 29 EB 2B 5E 04 29 D0 4F 75 C8 5F 89 1F 89 4F 04 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule X_Hider_10_GlobaL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID X_Hider_10_GlobaL"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 EC 33 C0 89 45 EC B8 54 20 44 44 E8 DF F8 FF FF 33 C0 55 68 08 21 44 44 64 FF 30 64 89 20 8D 55 EC B8 1C 21 44 44 E8 E0 F9 FF FF 8B 55 EC B8 40 ?? ?? 44 E8 8B F5 FF FF 6A 00 6A 00 6A 02 6A 00 6A 01 68 00 00 00 40 A1 40 ?? ?? 44 E8 7E F6 FF FF 50 E8 4C F9 FF FF 6A 00 50 E8 4C F9 FF FF A3 28 ?? ?? 44 E8 CE FE FF FF 33 C0 5A 59 59 64 89 10 68 0F 21 44 44 8D 45 EC E8 F1 F4 FF FF C3 E9 BB F2 FF FF EB F0 E8 FC F3 FF FF FF FF FF FF 0E 00 00 00 63 3A 5C 30 30 30 30 30 30 31 2E 64 61 74 00 }
        $b = { 85 D2 74 23 8B 4A F8 41 7F 1A 50 52 8B 42 FC E8 30 00 00 00 89 C2 58 52 8B 48 FC E8 48 FB FF FF 5A 58 EB 03 FF 42 F8 87 10 85 D2 74 13 8B 4A F8 49 7C 0D FF 4A F8 75 08 8D 42 F8 E8 5C FA FF FF C3 8D 40 00 85 C0 7E 24 50 83 C0 0A 83 E0 FE 50 E8 2F FA FF FF 5A 66 C7 44 02 FE 00 00 83 C0 08 5A 89 50 FC C7 40 F8 01 00 00 00 C3 31 C0 C3 90 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Vx_Heloween1172: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Heloween1172"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5E 81 EE ?? ?? 56 50 06 0E 1F 8C C0 01 ?? ?? 01 ?? ?? 80 ?? ?? ?? ?? 8B ?? ?? A3 ?? ?? 8A ?? ?? A2 ?? ?? B8 ?? ?? CD 21 3D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_PACK_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_PACK_10"
        weight = 1
    strings:
        $a = { 74 00 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CrypKey_V61X_DLL_CrypKey_Canada_Inc: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CrypKey_V61X_DLL_CrypKey_Canada_Inc"
        weight = 1
    strings:
        $a = { 83 3D ?? ?? ?? ?? 00 75 34 68 ?? ?? ?? ?? E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Mew_501_NorthFox_HCC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Mew_501_NorthFox_HCC"
        weight = 1
    strings:
        $a = { BE 5B 00 40 00 AD 91 AD 93 53 AD 96 56 5F AC C0 C0 ?? 04 ?? C0 C8 ?? AA E2 F4 C3 00 ?? ?? 00 ?? ?? ?? 00 00 10 40 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D }
        $b = { BE 5B 00 40 00 AD 91 AD 93 53 AD 96 56 5F AC C0 C0 ?? 04 ?? C0 C8 ?? AA E2 F4 C3 00 ?? ?? 00 ?? ?? ?? 00 00 10 40 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E 31 20 62 79 20 4E 6F 72 74 68 66 6F 78 00 4D 45 57 20 30 2E }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PEBundle_v310: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEBundle_v310"
        weight = 1
    strings:
        $a = { 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 20 40 00 87 DD ?? ?? ?? ?? 40 00 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_C_19901992: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_C_19901992"
        weight = 1
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? 33 C0 06 50 CB BF ?? ?? 8B 36 ?? ?? 2B F7 81 FE ?? ?? 72 ?? BE ?? ?? FA 8E D7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ARM_Protector_03_by_SMoKE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ARM_Protector_03_by_SMoKE"
        weight = 1
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 13 24 40 00 EB 02 83 09 8D B5 A4 24 40 00 EB 02 83 09 BA 4B 15 00 00 EB 01 00 8D 8D EF 39 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 50 C3 8A 06 46 EB 01 00 D0 C8 E8 14 00 00 00 83 EB 01 00 2A C2 E8 00 00 00 00 5B 83 C3 07 53 C3 00 EB 04 5B 43 53 C3 EB 01 00 32 C2 E8 0B 00 00 00 00 32 C1 EB 01 00 C0 C0 02 EB 09 2A C2 5B EB 01 00 43 53 C3 88 07 EB 01 00 47 4A 75 B4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PC_Shrinker_v071: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PC_Shrinker_v071"
        weight = 1
    strings:
        $a = { 9C 60 BD ?? ?? ?? ?? 01 ?? ?? ?? ?? ?? FF ?? ?? ?? ?? ?? 6A ?? FF ?? ?? ?? ?? ?? 50 50 2D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BJFnt_v11b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BJFnt_v11b"
        weight = 1
    strings:
        $a = { EB 01 EA 9C EB 01 EA 53 EB 01 EA 51 EB 01 EA 52 EB 01 EA 56 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_REALBasic: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_REALBasic"
        weight = 1
    strings:
        $a = { 55 89 E5 90 90 90 90 90 90 90 90 90 90 50 90 90 90 90 90 00 01 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACProtect_141_AntiCrack_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtect_141_AntiCrack_Software"
        weight = 1
    strings:
        $a = { E8 01 00 00 00 ?? 83 }
        $b = { E8 01 00 00 00 A0 5D EB 01 69 81 ED 5F 1A 40 00 8D 85 92 1A 40 00 F3 8D 95 83 1A 40 00 8B C0 8B D2 2B C2 83 E8 05 89 42 01 E8 FB FF FF FF 69 83 C4 08 E8 06 00 00 00 69 E8 F2 FF FF FF F3 B9 05 00 00 00 51 8D B5 BF 1A 40 00 8B FE B9 58 15 00 00 AC 32 C1 F6 D0 EB 01 00 D0 C0 FE C8 02 C1 AA E2 EF 59 E2 DE B7 FE AB E1 24 C8 0C 88 7A E1 B1 6A F7 95 83 1B A8 7F F8 A8 B0 1A 8B 08 91 47 6C 5A 88 6C 65 39 85 DB CB 54 3D B9 24 CF 4C AE C6 63 74 2C 63 F0 C8 18 0B 97 6B 79 63 A8 AB B8 78 A9 30 2F 2B DA 18 AC 35 45 36 BC 0D 7D 24 D1 51 3C E6 34 11 5A 43 06 24 89 FA 74 30 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule DzA_Patcher_v13_Loader: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DzA_Patcher_v13_Loader"
        weight = 1
    strings:
        $a = { BF 00 40 40 00 99 68 48 20 40 00 68 00 20 40 00 52 52 52 52 52 52 52 57 E8 15 01 00 00 85 C0 75 1C 99 52 52 57 52 E8 CB 00 00 00 FF 35 4C 20 40 00 E8 D2 00 00 00 6A 00 E8 BF 00 00 00 99 68 58 20 40 00 52 52 68 63 10 40 00 52 52 E8 DB 00 00 00 6A FF FF 35 48 20 40 00 E8 C2 00 00 00 E8 C8 FF FF FF BF 40 40 40 00 FF 35 4C 20 40 00 E8 A1 00 00 00 8B 0F 83 F9 00 74 B1 60 6A 00 6A 04 6A 01 51 FF 35 48 20 40 00 E8 75 00 00 00 61 60 BB 5C 20 40 00 6A 00 6A 01 53 51 FF 35 48 20 40 00 E8 75 00 00 00 61 A0 5C 20 40 00 8A 5F 05 3A C3 74 14 FF 35 4C 20 40 00 E8 4B 00 00 00 6A 03 E8 4A 00 00 00 EB A2 60 8D 5F 04 6A 00 6A 01 53 51 FF 35 48 20 40 00 E8 4B 00 00 00 61 83 C7 06 FF 35 4C 20 40 00 E8 1E 00 00 00 6A 03 E8 1D 00 00 00 E9 72 FF FF FF FF 25 70 30 40 00 FF 25 78 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PowerBASICWin_800: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PowerBASICWin_800"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 ?? ?? 00 66 2E F7 05 ?? ?? 40 00 04 00 75 05 E9 14 04 00 00 E9 19 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule XJ_XPAL_LiNSoN: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID XJ_XPAL_LiNSoN"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? 40 00 68 ?? ?? 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 44 53 56 57 66 9C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_v13037_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_v13037_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 26 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 26 EB 01 ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 04 ?? ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 03 ?? ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 01 ?? 58 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule GX_Protector_12_GurueXe: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID GX_Protector_12_GurueXe"
        weight = 1
    strings:
        $a = { 60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeCryptor_01_build_002_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeCryptor_01_build_002_GlOFF"
        weight = 1
    strings:
        $a = { 8B 04 24 40 90 83 C0 07 80 38 90 90 74 02 EB FF 90 68 27 ?? ?? 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 FF E4 90 8B 04 24 64 A3 00 00 00 00 8B 64 24 08 90 83 C4 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v032_Beta_Patch_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v032_Beta_Patch_Dwing"
        weight = 1
    strings:
        $a = { BE 88 01 ?? ?? AD 50 ?? AD 91 F3 A5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PeCompact_253_DLL_Slim_Loader_BitSum_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PeCompact_253_DLL_Slim_Loader_BitSum_Technologies"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C0 89 08 50 45 43 32 00 00 08 0C 00 48 E1 01 56 57 53 55 8B 5C 24 1C 85 DB 0F 84 AB 21 E8 BD 0E E6 60 0D 0B 6B 65 72 6E 6C 33 32 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_20betastudent_version_Jeremy_Collake: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_20betastudent_version_Jeremy_Collake"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 80 B8 BF 10 00 10 01 74 7A C6 80 BF 10 00 10 01 9C 55 53 51 57 52 56 8D 98 0F 10 00 10 8B 53 14 8B E8 6A 40 68 00 10 00 00 FF 73 04 6A 00 8B 4B 10 03 CA 8B 01 FF D0 8B F8 50 8B 33 8B 53 14 03 F2 8B 4B 0C 03 CA 8D 85 B7 10 00 10 FF 73 04 8F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Compiled_InstallSHIELD_Installation_Script: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Compiled_InstallSHIELD_Installation_Script"
        weight = 1
    strings:
        $a = { B8 C9 0C 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_v11_MTE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v11_MTE"
        weight = 1
    strings:
        $a = { 60 E9 ?? ?? ?? ?? 91 78 79 79 79 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Protector_093_CRYPToCRACk: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Protector_093_CRYPToCRACk"
        weight = 1
    strings:
        $a = { 5B 81 E3 00 FF FF FF 66 81 3B 4D 5A 75 33 8B F3 03 73 3C 81 3E 50 45 00 00 75 26 0F B7 46 18 8B C8 69 C0 AD 0B 00 00 F7 E0 2D AB 5D 41 4B 69 C9 DE C0 00 00 03 C1 75 09 83 EC 04 0F 85 DD 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SEN_Debug_Protector: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SEN_Debug_Protector"
        weight = 1
    strings:
        $a = { 8B 04 24 E8 00 00 00 00 5D 81 ED 4C 2F 40 00 89 85 61 2F 40 00 8D 9D 65 2F 40 00 53 C3 00 00 00 00 8D B5 BA 2F 40 00 8B FE BB 65 2F 40 00 B9 C6 01 00 00 AD 2B C3 C1 C0 03 33 C3 AB 43 81 FB 8E 2F 40 00 75 05 BB 65 2F 40 00 E2 E7 89 AD 1A 31 40 00 89 AD 55 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V041_cyberbobnbsp_nbsp_SignByfly_20080312: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V041_cyberbobnbsp_nbsp_SignByfly_20080312"
        weight = 1
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 02 D2 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 8B ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 ?? ?? ?? ?? ?? 53 8F ?? ?? ?? ?? ?? BB ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 4F EB 01 AB 30 1C 39 FE CB E2 F9 EB 01 ?? 68 3C 01 00 00 59 8D ?? ?? ?? ?? ?? C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 ?? ?? ?? ?? 59 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 ?? E8 1A 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MicroDog_Win32Shell_V4093_Dll_SafeNet_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MicroDog_Win32Shell_V4093_Dll_SafeNet_SignByfly"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 19 FF FF FF E9 AF EC FF FF 90 90 90 90 90 55 8B EC 83 EC 18 53 56 57 8B 45 08 8B 00 C1 E8 10 89 45 FC 8B 45 08 8B 00 25 FF FF 00 00 89 45 F8 C7 45 F4 5A 01 00 00 C7 45 EC 35 4E 00 00 8B 45 F4 0F AF 45 F8 25 FF FF 00 00 89 45 F0 83 7D FC 00 74 0F 8B 45 EC 0F AF 45 FC 25 FF FF 00 00 01 45 F0 8B 45 EC 0F AF 45 F8 8B 4D F0 C1 E1 10 81 E1 00 00 FF FF 03 C1 40 89 45 E8 8B 45 E8 8B 4D 08 89 01 C1 6D E8 10 81 65 E8 FF 7F 00 00 66 8B 45 E8 EB 00 5F 5E 5B C9 C3 }
        $b = { 80 7C 24 08 01 0F 85 19 FF FF FF E9 AF EC FF FF 90 90 90 90 90 55 8B EC 83 EC 18 53 56 57 8B 45 08 8B 00 C1 E8 10 89 45 FC 8B 45 08 8B 00 25 FF FF 00 00 89 45 F8 C7 45 F4 5A 01 00 00 C7 45 EC 35 4E 00 00 8B 45 F4 0F AF 45 F8 25 FF FF 00 00 89 45 F0 83 7D }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Armadillo_v300: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v300"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 60 33 C9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PKZIP_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PKZIP_Archive"
        weight = 1
    strings:
        $a = { 50 4B 03 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Embedded_2312_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_2312_Jitit"
        weight = 1
    strings:
        $a = { 6A 00 FF 15 ?? ?? ?? ?? E8 D4 F8 FF FF E9 E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 14 80 00 00 00 C2 04 00 55 8B EC 53 56 57 33 C0 33 FF 39 45 0C 8B F1 76 0C 8B 4D 08 03 3C 81 40 3B 45 0C 72 F4 8B CE E8 43 00 00 00 8B 46 14 33 D2 F7 F7 8B 5E 10 33 D2 8B F8 8B C3 F7 F7 89 7E 18 89 45 0C 33 C0 33 C9 8B 55 08 03 0C 82 40 39 4D 0C 73 F4 48 8B 14 82 2B CA 0F AF CF 2B D9 0F AF FA 89 7E 14 89 5E 10 5F 5E 5B 5D C2 08 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule mkfpack_llydd: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID mkfpack_llydd"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 5B 81 EB 05 00 00 00 8B 93 9F 08 00 00 53 6A 40 68 00 10 00 00 52 6A 00 FF 93 32 08 }
        $b = { E8 00 00 00 00 5B 81 EB 05 00 00 00 8B 93 9F 08 00 00 53 6A 40 68 00 10 00 00 52 6A 00 FF 93 32 08 00 00 5B 8B F0 8B BB 9B 08 00 00 03 FB 56 57 E8 86 08 00 00 83 C4 08 8D 93 BB 08 00 00 52 53 FF E6 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule EXE2COM_Packed: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE2COM_Packed"
        weight = 1
    strings:
        $a = { BD ?? ?? 89 ?? ?? ?? 81 ?? ?? ?? ?? ?? 8C ?? ?? ?? 8C C8 05 ?? ?? 8E C0 BE ?? ?? 8B FE 0E 57 54 59 F3 A4 06 68 ?? ?? CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Audio_CD_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Audio_CD_file"
        weight = 1
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 43 44 44 41 66 6D 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AntiDote_10_Beta_SIS_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiDote_10_Beta_SIS_Team"
        weight = 1
    strings:
        $a = { E8 BB FF FF FF 84 C0 74 2F 68 04 01 00 00 68 C0 23 60 00 6A 00 FF 15 08 10 60 00 E8 40 FF FF FF 50 68 78 11 60 00 68 68 11 60 00 68 C0 23 60 00 E8 AB FD FF FF 83 C4 10 33 C0 C2 10 00 90 90 90 8B 4C 24 08 56 8B 74 24 08 33 D2 8B C6 F7 F1 8B C6 85 D2 74 08 33 D2 F7 F1 40 0F AF C1 5E C3 90 8B 44 24 04 53 55 56 8B 48 3C 57 03 C8 33 D2 8B 79 54 8B 71 38 8B C7 F7 F6 85 D2 74 0C 8B C7 33 D2 F7 F6 8B F8 47 0F AF FE 33 C0 33 DB 66 8B 41 14 8D 54 08 18 33 C0 66 8B 41 06 89 54 24 14 8D 68 FF 85 ED 7C 37 33 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v099_tE_TMD: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v099_tE_TMD"
        weight = 1
    strings:
        $a = { E9 ?? ?? FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? 02 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? 02 00 00 00 00 00 ?? ?? 02 00 00 00 00 00 ?? ?? 02 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? 00 00 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? 02 00 ?? ?? 02 00 ?? ?? 02 00 ?? ?? 02 00 ?? ?? 02 00 ?? ?? 02 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? 00 00 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 00 00 ?? 00 00 ?? ?? 00 ?? ?? 00 00 ?? ?? ?? 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_DxPack_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_DxPack_10"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 8B FD 81 ED 90 90 90 90 2B B9 00 00 00 00 81 EF 90 90 90 90 83 BD 90 90 90 90 90 0F 84 00 00 00 00 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_v10_: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_v10_"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 08 4B 40 00 68 36 3A 40 00 64 A1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE2COM_With_CRC_check: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE2COM_With_CRC_check"
        weight = 1
    strings:
        $a = { B3 ?? B9 ?? ?? 33 D2 BE ?? ?? 8B FE AC 32 C3 AA 43 49 32 E4 03 D0 E3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Number_One: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Number_One"
        weight = 1
    strings:
        $a = { F9 07 3C 53 6D 69 6C 65 3E E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Windows_Group_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Windows_Group_file"
        weight = 1
    strings:
        $a = { 50 4D 43 43 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v029_Beta_v031_Beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v029_Beta_v031_Beta_Dwing"
        weight = 1
    strings:
        $a = { BE 88 01 ?? ?? AD 8B F8 95 AD 91 F3 A5 AD B5 ?? F3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Mew_10_v10_Northfox: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Mew_10_v10_Northfox"
        weight = 1
    strings:
        $a = { 33 C0 E9 ?? ?? FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v10"
        weight = 1
    strings:
        $a = { 60 E8 01 ?? ?? ?? 90 5D 81 ED ?? ?? ?? ?? BB ?? ?? ?? ?? 03 DD 2B 9D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_v11: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v11"
        weight = 1
    strings:
        $a = { 60 E9 ?? 04 ?? ?? E9 ?? ?? ?? ?? ?? ?? ?? EE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_v12: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v12"
        weight = 1
    strings:
        $a = { 68 01 ?? ?? ?? C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_Shit_v01_500mhz: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_Shit_v01_500mhz"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 5E 83 C6 14 AD 89 C7 AD 89 C1 AD 30 07 47 E2 FB AD FF E0 C3 00 ?? ?? 00 ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule with_added_PK_signature: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID with_added_PK_signature"
        weight = 1
    strings:
        $a = { C7 ?? ?? ?? ?? ?? 8C D8 05 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_ASPack_212_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_ASPack_212_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule App_Protector_Silent_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID App_Protector_Silent_Team"
        weight = 1
    strings:
        $a = { E9 97 00 00 00 0D 0A 53 69 6C 65 6E 74 20 54 65 61 6D 20 41 70 70 20 50 72 6F 74 65 63 74 6F 72 0D 0A 43 72 65 61 74 65 64 20 62 79 20 53 69 6C 65 6E 74 20 53 6F 66 74 77 61 72 65 0D 0A 54 68 65 6E 6B 7A 20 74 6F 20 44 6F 63 68 74 6F 72 20 58 0D 0A 0D 0A 54 68 69 73 20 69 73 20 53 50 61 6B 65 64 20 41 70 70 6C 69 63 61 74 69 6F 6E 0D 0A 53 50 41 4B 20 63 6F 6D 70 72 69 6D 61 74 69 6F 6E 20 73 79 73 74 65 6D 20 69 73 20 AE 53 69 6C 65 6E 74 20 54 65 61 6D 99 0D 0A 60 E8 01 00 00 00 E8 83 C4 04 E8 01 00 00 00 E9 5D 81 ED 76 22 40 00 E8 04 02 00 00 E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46 E8 01 00 00 00 9A 59 8D 95 C8 22 40 00 E8 01 00 00 00 69 58 66 BF 4D 4A E8 BF 01 00 00 8D 52 F9 E8 01 00 00 00 E8 5B 68 CC FF E2 9A FF E4 69 FF A5 E4 24 40 00 E9 E8 B9 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEtite_v22: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEtite_v22"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 66 9C 60 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V033_V034_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V033_V034_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { 57 51 58 8D 54 83 58 FF 16 72 5C 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 6F FF C1 ED ?? C1 E5 08 8D 6C 6D 00 8D AC AB 08 10 00 00 B0 01 E3 2A 8B D7 2B 53 08 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 54 95 00 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E3 B4 00 33 C9 B5 01 FF 56 AC 33 C9 E9 03 01 00 00 B1 30 8B 6B 08 03 D1 FF 16 73 51 03 D1 FF 16 72 1B 03 D1 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 43 08 8A 00 E9 D5 00 00 00 83 C2 60 FF 16 87 6B 0C 73 0C 03 D1 FF 16 87 6B 10 73 03 87 6B 14 3C 07 B0 08 72 02 B0 0B 50 55 8D 93 78 07 00 00 FF 56 B0 5D 91 E9 99 00 00 00 3C 07 B0 07 72 02 B0 0A 50 87 6B 0C 87 6B 10 89 6B 14 8D 93 C0 0B 00 00 FF 56 B0 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D AC 83 78 03 00 00 FF 56 A8 3C 04 8B E8 72 5C 33 ED D1 E8 13 ED 48 45 91 45 D3 E5 80 F9 05 8D 94 AB 78 01 00 00 76 2B 80 E9 04 33 C0 8B 53 FC D1 2B 8B 12 0F CA 2B 53 04 03 C0 3B 13 72 06 8B 13 40 01 53 04 FF 56 88 E2 E3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule A3E_TXT2COM: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID A3E_TXT2COM"
        weight = 1
    strings:
        $a = { 1E 33 C0 50 BE ?? ?? 81 C6 ?? ?? B8 ?? ?? 8E C0 BF ?? ?? B9 ?? ?? F3 A5 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NTKrnlPacker_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NTKrnlPacker_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 10 00 00 50 10 00 00 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEtite_v21: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEtite_v21"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 6A 00 68 ?? ?? ?? ?? 64 ?? ?? ?? ?? ?? ?? 64 ?? ?? ?? ?? ?? ?? 66 9C 60 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_v_If_you_know_this_version_post_on_PEiD_board_h2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v_If_you_know_this_version_post_on_PEiD_board_h2"
        weight = 1
    strings:
        $a = { 33 C0 E9 ?? ?? FF FF ?? 1C ?? ?? 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_440_Silicon_Realms_Toolworks_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_440_Silicon_Realms_Toolworks_h"
        weight = 1
    strings:
        $a = { 30 31 2E 30 31 00 00 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Patch_Creation_Wizard_v12_Byte_Patch: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Patch_Creation_Wizard_v12_Byte_Patch"
        weight = 1
    strings:
        $a = { E8 7F 03 00 00 6A 00 E8 24 03 00 00 A3 B8 33 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 2C 03 00 00 6A 00 E8 EF 02 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 B8 33 40 00 E8 1B 03 00 00 50 6A 01 68 80 00 00 00 FF 75 08 E8 1D 03 00 00 68 5F 30 40 00 6A 65 FF 75 08 E8 14 03 00 00 68 B0 30 40 00 6A 67 FF 75 08 E8 05 03 00 00 68 01 31 40 00 6A 66 FF 75 08 E8 F6 02 00 00 6A 00 FF 75 08 E8 C8 02 00 00 A3 B4 33 40 00 C7 05 BC 33 40 00 2C 00 00 00 C7 05 C0 33 40 00 10 00 00 00 C7 05 C4 33 40 00 00 08 00 00 68 BC 33 40 00 6A 01 6A FF FF 35 B4 33 40 00 E8 97 02 00 00 C7 05 C4 33 40 00 00 00 00 00 C7 05 E0 33 40 00 00 30 40 00 C7 05 E4 33 40 00 01 00 00 00 68 BC 33 40 00 6A 01 6A FF FF 35 B4 33 40 00 E8 65 02 00 00 EB 5F EB 54 }
        $b = { E8 C5 05 00 00 6A 00 E8 5E 05 00 00 A3 CE 39 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 72 05 00 00 6A 00 E8 2F 05 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 CE 39 40 00 E8 61 05 00 00 50 6A 01 68 80 00 00 00 FF 75 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Exact_Audio_Copy: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Exact_Audio_Copy"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? 00 31 ED 55 89 E5 81 EC ?? 00 00 00 8D BD ?? FF FF FF B9 ?? 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WWPACK_v302_v302a_v304_Relocations_pack: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WWPACK_v302_v302a_v304_Relocations_pack"
        weight = 1
    strings:
        $a = { BE ?? ?? BF ?? ?? B9 ?? ?? 8C CD 81 ED ?? ?? 8B DD 81 EB ?? ?? 8B D3 FC FA 1E 8E DB 01 15 33 C0 2E AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v106b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v106b"
        weight = 1
    strings:
        $a = { 90 90 90 75 00 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MZ_Crypt_10_by_BrainSt0rm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MZ_Crypt_10_by_BrainSt0rm"
        weight = 1
    strings:
        $a = { EB CA 89 03 83 C3 04 87 FE 32 C0 AE 75 FD 87 FE 80 3E FF 75 E2 46 5B 83 C3 04 53 8B 1B 80 3F FF 75 C9 8B E5 61 68 ?? ?? ?? ?? C3 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v010_v012Beta_Sign_by_hot_UNP: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v010_v012Beta_Sign_by_hot_UNP"
        weight = 1
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 3A 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_precompiled_header_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_precompiled_header_file"
        weight = 1
    strings:
        $a = { 54 50 53 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_FSG_131: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_FSG_131"
        weight = 1
    strings:
        $a = { BE 90 90 90 00 BF 90 90 90 00 BB 90 90 90 00 53 BB 90 90 90 00 B2 80 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CorelPhotoPaint_Image: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CorelPhotoPaint_Image"
        weight = 1
    strings:
        $a = { 43 50 54 37 46 49 4C 45 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PKLITE_v200b_extra: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PKLITE_v200b_extra"
        weight = 1
    strings:
        $a = { 50 B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 02 00 72 ?? B4 09 BA ?? ?? CD 21 B8 01 4C CD 21 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EA ?? ?? ?? ?? F3 A5 C3 59 2D ?? ?? 8E D0 51 2D ?? ?? 50 80 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_v118_Basic_DLL_aPLib_Ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_v118_Basic_DLL_aPLib_Ap0x"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_MinGW_GCC_2x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_MinGW_GCC_2x"
        weight = 1
    strings:
        $a = { 55 89 E5 E8 02 00 00 00 C9 C3 90 90 45 58 45 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NeoLite_vxx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NeoLite_vxx"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9E 37 00 00 ?? ?? 48 ?? ?? ?? 6F 4C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 61 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v430_440_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v430_440_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 9D 0F C9 8B CA F7 D1 59 58 50 51 0F CA F7 D2 9C F7 D2 0F CA EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 }
        $b = { 55 8B EC 6A FF 68 40 ?? ?? 00 68 80 ?? ?? 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 ?? ?? 00 33 D2 8A D4 89 15 30 ?? ?? 00 8B C8 81 E1 FF 00 00 00 89 0D 2C ?? ?? 00 C1 E1 08 03 CA 89 0D 28 ?? ?? 00 C1 E8 10 A3 24 ?? ?? 00 33 F6 56 E8 78 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 43 13 00 00 FF 15 8C ?? ?? 00 A3 24 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule MSLRH_v032a_fake_MSVCpp_70_DLL_Method_3_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_MSVCpp_70_DLL_Method_3_emadicius"
        weight = 1
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PerlApp_602_ActiveState: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PerlApp_602_ActiveState"
        weight = 1
    strings:
        $a = { 68 2C EA 40 00 FF D3 83 C4 0C 85 C0 0F 85 CD 00 00 00 6A 09 57 68 20 EA 40 00 FF D3 83 C4 0C 85 C0 75 12 8D 47 09 50 FF 15 1C D1 40 00 59 A3 B8 07 41 00 EB 55 6A 08 57 68 14 EA 40 00 FF D3 83 C4 0C 85 C0 75 11 8D 47 08 50 FF 15 1C D1 40 00 59 89 44 24 10 EB 33 6A 09 57 68 08 EA 40 00 FF D3 83 C4 0C 85 C0 74 22 6A 08 57 68 FC E9 40 00 FF D3 83 C4 0C 85 C0 74 11 6A 0B 57 68 F0 E9 40 00 FF D3 83 C4 0C 85 C0 75 55 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Crypt32_v102: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Crypt32_v102"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 5B 83 ?? ?? EB ?? 52 4E 44 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WinRAR_32_bit_SFX_Module: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WinRAR_32_bit_SFX_Module"
        weight = 1
    strings:
        $a = { E9 ?? ?? 00 00 00 00 00 00 90 90 90 ?? ?? ?? ?? ?? ?? 00 ?? 00 ?? ?? ?? ?? ?? FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Petite_22_c1998_99_Ian_Luck_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Petite_22_c1998_99_Ian_Luck_h"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? 66 9C 60 50 8D 88 ?? F0 ?? ?? 8D 90 04 16 ?? ?? 8B DC 8B E1 68 ?? ?? ?? ?? 53 50 80 04 24 08 50 80 04 24 42 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_v23_North_Star: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_v23_North_Star"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 07 00 00 00 2B E8 8D B5 ?? ?? FF FF 8B 06 83 F8 00 74 11 8D B5 ?? ?? FF FF 8B 06 83 F8 01 0F 84 4B 02 00 00 C7 06 01 00 00 00 8B D5 8B 85 ?? ?? FF FF 2B D0 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 8B 36 8B FD 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 56 03 00 00 89 85 ?? ?? FF FF E8 00 00 00 00 5B B9 54 03 00 00 03 D9 50 53 E8 9D 02 00 00 61 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Stealth_v25: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Stealth_v25"
        weight = 1
    strings:
        $a = { 60 90 EB 22 45 78 65 53 74 65 61 6C 74 68 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D E8 00 00 00 00 5D 81 ED 40 1E 40 00 B9 99 09 00 00 8D BD 88 1E 40 00 8B F7 AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AntiDote_V12Demo_SIS_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiDote_V12Demo_SIS_Team"
        weight = 1
    strings:
        $a = { E8 F7 FE FF FF 05 CB 22 00 00 FF E0 E8 EB FE FF FF 05 BB 19 00 00 FF E0 E8 BD 00 00 00 08 B2 62 00 01 52 17 0C 0F 2C 2B 20 7F 52 79 01 30 07 17 29 4F 01 3C 30 2B 5A 3D C7 26 11 26 06 59 0E 78 2E 10 14 0B 13 1A 1A 3F 64 1D 71 33 57 21 09 24 8B 1B 09 37 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1400Beta_Obsidium_Software_SignByfly_20080102: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1400Beta_Obsidium_Software_SignByfly_20080102"
        weight = 1
    strings:
        $a = { EB 01 ?? E8 2F 00 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 01 ?? C3 EB 01 ?? E9 ?? ?? ?? ?? EB 01 ?? E8 D5 FF FF FF EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 }
        $b = { EB 01 ?? E8 2F 00 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 21 EB 04 ?? ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule VIRUS_I_WormHybris: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VIRUS_I_WormHybris"
        weight = 1
    strings:
        $a = { EB 16 A8 54 ?? ?? 47 41 42 4C 4B 43 47 43 ?? ?? ?? ?? ?? ?? 52 49 53 ?? FC 68 4C 70 40 ?? FF 15 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_UPX_0896_102_105_124_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_UPX_0896_102_105_124_emadicius"
        weight = 1
    strings:
        $a = { 60 BE 00 90 8B 00 8D BE 00 80 B4 FF 57 83 CD FF EB 3A 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 0B 75 19 8B 1E 83 EE FC 11 DB 72 10 58 61 90 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_ACME_Clonewar_Mutant: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_ACME_Clonewar_Mutant"
        weight = 1
    strings:
        $a = { FC AD 3D FF FF 74 20 E6 42 8A C4 E6 42 E4 61 0C 03 E6 61 AD B9 40 1F E2 FE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_32Lite_003: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_32Lite_003"
        weight = 1
    strings:
        $a = { 60 06 FC 1E 07 BE 90 90 90 90 6A 04 68 90 10 90 90 68 ?? ?? ?? ?? E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_V1032_Ashkbiz_Danehkar_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_V1032_Ashkbiz_Danehkar_Sign_by_fly"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED 94 73 42 00 8B D5 81 C2 E3 73 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 BF A4 42 00 81 E9 8E 74 42 00 8B D5 81 C2 8E 74 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 63 29 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v071_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v071_DLL"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 95 01 00 00 60 E8 00 00 00 00 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v60: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v60"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC ?? 53 56 57 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule KByS_V028_DLL_shoooo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID KByS_V028_DLL_shoooo"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? BA ?? ?? ?? ?? 03 C2 FF E0 ?? ?? ?? ?? 60 E8 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule StarForce_30_StarForce_Technology: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID StarForce_30_StarForce_Technology"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? FF 25 ?? ?? 63 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CDS_SS_10_beta1_CyberDoom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CDS_SS_10_beta1_CyberDoom"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED CA 47 40 00 FF 74 24 20 E8 D3 03 00 00 0B C0 0F 84 13 03 00 00 89 85 B8 4E 40 00 66 8C D8 A8 04 74 0C C7 85 8C 4E 40 00 01 00 00 00 EB 12 64 A1 30 00 00 00 0F B6 40 02 0A C0 0F 85 E8 02 00 00 8D 85 F6 4C 40 00 50 FF B5 B8 4E 40 00 E8 FC 03 00 00 0B C0 0F 84 CE 02 00 00 E8 1E 03 00 00 89 85 90 4E 40 00 8D 85 03 4D 40 00 50 FF B5 B8 4E 40 00 E8 D7 03 00 00 0B C0 0F 84 A9 02 00 00 E8 F9 02 00 00 89 85 94 4E 40 00 8D 85 12 4D 40 00 50 }
        $b = { 60 E8 00 00 00 00 5D 81 ED CA 47 40 00 FF 74 24 20 E8 D3 03 00 00 0B C0 0F 84 13 03 00 00 89 85 B8 4E 40 00 66 8C D8 A8 04 74 0C C7 85 8C 4E 40 00 01 00 00 00 EB 12 64 A1 30 00 00 00 0F B6 40 02 0A C0 0F 85 E8 02 00 00 8D 85 F6 4C 40 00 50 FF B5 B8 4E 40 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule CrunchPE_v50: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CrunchPE_v50"
        weight = 1
    strings:
        $a = { EB 15 03 ?? ?? ?? 06 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_200_30X_Markus_Oberhumer_Laszlo_Molnar_John_Reiser: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_200_30X_Markus_Oberhumer_Laszlo_Molnar_John_Reiser"
        weight = 1
    strings:
        $a = { 5E 89 F7 B9 ?? ?? ?? ?? 8A 07 47 2C E8 3C 01 77 F7 80 3F ?? 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07 83 C7 05 88 D8 E2 D9 8D ?? ?? ?? ?? ?? 8B 07 09 C0 74 3C 8B 5F 04 8D ?? ?? ?? ?? ?? ?? 01 F3 50 83 C7 08 FF ?? ?? ?? ?? ?? 95 8A 07 47 08 C0 74 DC 89 F9 57 48 F2 AE 55 FF ?? ?? ?? ?? ?? 09 C0 74 07 89 03 83 C3 04 EB E1 FF ?? ?? ?? ?? ?? 8B AE ?? ?? ?? ?? 8D BE 00 F0 FF FF BB 00 10 00 00 50 54 6A 04 53 57 FF D5 8D 87 ?? ?? ?? ?? 80 20 7F 80 60 28 7F 58 50 54 50 53 57 FF D5 58 61 8D 44 24 80 6A 00 39 C4 75 FA 83 EC 80 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V037_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V037_Dwing"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? AD 50 FF ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_MSVCpp_60_DLL_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_MSVCpp_60_DLL_emadicius"
        weight = 1
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 57 8B 7D 10 85 F6 5F 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Trivial25: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Trivial25"
        weight = 1
    strings:
        $a = { B4 4E FE C6 CD 21 B8 ?? 3D BA ?? 00 CD 21 93 B4 40 CD }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v420_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v420_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 F8 8E 4C 00 68 F0 EA 49 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4C 00 33 D2 8A D4 89 15 84 A5 4C 00 8B C8 81 E1 FF 00 00 00 89 0D 80 A5 4C 00 C1 E1 08 03 CA 89 0D 7C A5 4C 00 C1 E8 10 A3 78 A5 4C 00 33 F6 56 E8 78 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 43 13 00 00 FF 15 8C 30 4C 00 A3 84 BB 4C 00 E8 01 12 00 00 A3 D8 A5 4C 00 E8 AA 0F 00 00 E8 EC 0E 00 00 E8 2D FA FF FF 89 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXpressor_v10_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXpressor_v10_CGSoftLabs"
        weight = 1
    strings:
        $a = { E9 35 14 00 00 E9 31 13 00 00 E9 98 12 00 00 E9 EF 0C 00 00 E9 42 13 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Cruncher_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Cruncher_v10"
        weight = 1
    strings:
        $a = { 2E ?? ?? ?? ?? 2E ?? ?? ?? B4 30 CD 21 3C 03 73 ?? BB ?? ?? 8E DB 8D ?? ?? ?? B4 09 CD 21 06 33 C0 50 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_239_DLL_compressed_resources: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_239_DLL_compressed_resources"
        weight = 1
    strings:
        $a = { 50 68 ?? ?? ?? ?? 58 C1 C0 0F E9 ?? ?? ?? 00 87 04 24 58 89 45 FC E9 ?? ?? ?? FF FF 05 ?? ?? ?? ?? E9 ?? ?? ?? 00 C1 C3 18 E9 ?? ?? ?? ?? 8B 55 08 09 42 F8 E9 ?? ?? ?? FF 83 7D F0 01 0F 85 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 34 24 5E 8B 45 FC 33 D2 56 8B F2 E9 ?? ?? ?? 00 BA ?? ?? ?? ?? E8 ?? ?? ?? 00 A3 ?? ?? ?? ?? C3 E9 ?? ?? ?? 00 C3 83 C4 04 C3 E9 ?? ?? ?? FF 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 E8 ?? ?? ?? 00 E9 ?? ?? ?? FF C1 C2 03 81 CA ?? ?? ?? ?? 81 C2 ?? ?? ?? ?? 03 C2 5A E9 ?? ?? ?? FF 81 E7 ?? ?? ?? ?? 81 EF ?? ?? ?? ?? 81 C7 ?? ?? ?? ?? 89 07 E9 ?? ?? ?? ?? 0F 89 ?? ?? ?? ?? 87 14 24 5A 50 C1 C8 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Macromedia_Windows_Flash_ProjectorPlayer_v50: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Macromedia_Windows_Flash_ProjectorPlayer_v50"
        weight = 1
    strings:
        $a = { 83 EC 44 56 FF 15 24 81 49 00 8B F0 8A 06 3C 22 75 1C 8A 46 01 46 3C 22 74 0C 84 C0 74 08 8A 46 01 46 3C 22 75 F4 80 3E 22 75 0F 46 EB 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Crypto_Lock_202_Eng_Ryan_Thian: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Crypto_Lock_202_Eng_Ryan_Thian"
        weight = 1
    strings:
        $a = { 60 BE 15 90 40 00 8D BE EB 7F FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pohernah_100_by_Kas: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pohernah_100_by_Kas"
        weight = 1
    strings:
        $a = { 58 60 E8 00 00 00 00 5D 81 ED 20 25 40 00 8B BD 86 25 40 00 8B 8D 8E 25 40 00 6B C0 05 83 F0 04 89 85 92 25 40 00 83 F9 00 74 2D 81 7F 1C AB 00 00 00 75 1E 8B 77 0C 03 B5 8A 25 40 00 31 C0 3B 47 10 74 0E 50 8B 85 92 25 40 00 30 06 58 40 46 EB ED 83 C7 28 49 EB CE 8B 85 82 25 40 00 89 44 24 1C 61 FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _MSLRH_v01_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _MSLRH_v01_emadicius"
        weight = 1
    strings:
        $a = { 60 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C 00 00 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V036_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V036_Dwing"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? FF 36 E9 C3 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Packed_with_PKLITE_v150_with_CRC_check_1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Packed_with_PKLITE_v150_with_CRC_check_1"
        weight = 1
    strings:
        $a = { 1F B4 09 BA ?? ?? CD 21 B8 ?? ?? CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TrueType_Font_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TrueType_Font_file"
        weight = 1
    strings:
        $a = { 00 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 4C 54 53 48 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi_40: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_40"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ARM_Protector_02_SMoKE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ARM_Protector_02_SMoKE"
        weight = 1
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D EB 01 00 81 ED 09 20 40 00 EB 02 83 09 8D B5 9A 20 40 00 EB 02 83 09 BA 0B 12 00 00 EB 01 00 8D 8D A5 32 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V111_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V111_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 4A 02 00 00 8D 9D 11 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Spalsher_v10_v30: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Spalsher_v10_v30"
        weight = 1
    strings:
        $a = { 9C 60 8B 44 24 24 E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? 50 E8 ED 02 ?? ?? 8C C0 0F 84 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PolyEnE_V001p_Lennart_Hedlund: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PolyEnE_V001p_Lennart_Hedlund"
        weight = 1
    strings:
        $a = { 50 6F 6C 79 45 6E 45 00 4D 65 73 73 61 67 65 42 6F 78 41 00 55 53 45 52 33 32 2E 64 6C 6C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_Run_Time_Library_1990_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Run_Time_Library_1990_10"
        weight = 1
    strings:
        $a = { E8 ?? ?? 2E FF 2E ?? ?? BB ?? ?? E8 ?? ?? CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Lattice_C_v30: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Lattice_C_v30"
        weight = 1
    strings:
        $a = { FA B8 ?? ?? 8E D8 B8 ?? ?? 8E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_V220070411_WFS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_V220070411_WFS"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 1B 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 54 65 6D 70 50 61 74 68 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AntiDote_V12_SIS_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiDote_V12_SIS_Team"
        weight = 1
    strings:
        $a = { 00 00 00 00 09 01 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 DB 01 47 65 74 56 65 72 73 69 6F 6E 45 78 41 00 73 01 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 00 7A 03 57 61 69 74 46 6F 72 53 69 6E 67 6C 65 4F 62 6A 65 63 74 00 BF 02 52 65 73 75 6D 65 54 68 72 65 61 64 00 00 29 03 53 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 94 03 57 72 69 74 65 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 00 6B 03 56 69 72 74 75 61 6C 41 6C 6C 6F 63 45 78 00 00 A6 02 52 65 61 64 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 CA 01 47 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 62 00 43 72 65 61 74 65 50 72 6F 63 65 73 73 41 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 26 00 43 68 61 72 4C 6F 77 65 72 41 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 00 5E 02 66 72 65 65 00 00 4C 02 66 63 6C 6F 73 65 00 00 DA 00 5F 66 69 6C 62 75 66 00 91 02 6D 61 6C 6C 6F 63 00 00 64 02 66 74 65 6C 6C 00 62 02 66 73 65 65 6B 00 57 02 66 6F 70 65 6E 00 C5 02 73 74 72 73 74 72 00 00 4D 53 56 43 52 54 2E 64 6C 6C 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V118_LZMA_430_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V118_LZMA_430_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 ?? 83 C7 ?? 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 BD 0A 04 00 00 00 74 05 E8 D7 01 00 00 8D 74 37 04 53 6A ?? 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v07x_v084: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v07x_v084"
        weight = 1
    strings:
        $a = { 60 E8 00 00 C3 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Inset_Systems_PIX_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Inset_Systems_PIX_Graphics_format"
        weight = 1
    strings:
        $a = { 03 00 ?? 00 00 00 20 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Mew_10_v10_Eng_Northfox: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Mew_10_v10_Eng_Northfox"
        weight = 1
    strings:
        $a = { 33 C0 E9 ?? ?? ?? FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Embedded_20X_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_20X_Jitit"
        weight = 1
    strings:
        $a = { B8 EF BE AD DE 50 6A 00 FF 15 ?? ?? ?? ?? E9 AD FF FF FF 8B C1 8B 4C 24 04 89 88 29 04 00 00 C7 40 0C 01 00 00 00 0F B6 49 01 D1 E9 89 48 10 C7 40 14 80 00 00 00 C2 04 00 8B 44 24 04 C7 41 0C 01 00 00 00 89 81 29 04 00 00 0F B6 40 01 D1 E8 89 41 10 C7 41 14 80 00 00 00 C2 04 00 55 8B EC 53 56 57 33 C0 33 FF 39 45 0C 8B F1 76 0C 8B 4D 08 03 3C 81 40 3B 45 0C 72 F4 8B CE E8 43 00 00 00 8B 46 14 33 D2 F7 F7 8B 5E 10 33 D2 8B F8 8B C3 F7 F7 89 7E 18 89 45 0C 33 C0 33 C9 8B 55 08 03 0C 82 40 39 4D 0C 73 F4 48 8B 14 82 2B CA 0F AF CF 2B D9 0F AF FA 89 7E 14 89 5E 10 5F 5E 5B 5D C2 08 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CopyMinder_MicrocosmLtd: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CopyMinder_MicrocosmLtd"
        weight = 1
    strings:
        $a = { 83 25 ?? ?? ?? ?? EF 6A 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 ?? ?? ?? ?? FF 25 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unnamed_Scrambler_11C_p0ke: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unnamed_Scrambler_11C_p0ke"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 EC 53 56 33 C0 89 45 ?? ?? ?? ?? 40 00 E8 11 F4 FF FF BE 30 6B 40 00 33 C0 55 68 C9 42 40 00 64 FF 30 64 89 20 E8 C9 FA FF FF BA D8 42 40 00 8B ?? ?? ?? ?? FF FF 8B D8 B8 28 6B 40 00 8B 16 E8 37 F0 FF FF B8 2C 6B 40 00 8B 16 E8 2B F0 FF FF }
        $b = { 55 8B EC 83 C4 E4 53 56 33 C0 89 45 E4 89 45 E8 89 45 EC B8 C0 47 00 10 E8 4F F3 FF FF BE 5C 67 00 10 33 C0 55 68 D2 4A 00 10 64 FF 30 64 89 20 E8 EB DE FF FF E8 C6 F8 FF FF BA E0 4A 00 10 B8 CC 67 00 10 E8 5F F8 FF FF 8B D8 8B D6 8B C3 8B 0D CC 67 00 10 E8 3A DD FF FF 8B 46 50 8B D0 B8 D4 67 00 10 E8 5B EF FF FF B8 D4 67 00 10 E8 09 EF FF FF 8B D0 8D 46 14 8B 4E 50 E8 14 DD FF FF 8B 46 48 8B D0 B8 D8 67 00 ?? ?? ?? ?? ?? FF B8 D8 67 00 10 E8 E3 EE FF FF 8B D0 8B C6 8B 4E 48 E8 EF DC FF FF FF 76 5C FF 76 58 FF 76 64 FF 76 60 B9 D4 67 00 10 8B 15 D8 67 00 10 A1 D4 67 00 10 E8 76 F6 FF FF A1 D4 67 00 10 E8 5C EE FF FF 8B D0 B8 CC 67 00 10 E8 CC F7 FF FF 8B D8 B8 DC 67 00 10 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_02_PESHiELD_025: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_PESHiELD_025"
        weight = 1
    strings:
        $a = { 60 E8 2B 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 CC CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v25x_v26x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v25x_v26x"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 58 ?? ?? ?? 33 D2 8A D4 89 15 EC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_C_1990_or_Turbo_C_1988: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_C_1990_or_Turbo_C_1988"
        weight = 1
    strings:
        $a = { BA ?? ?? 2E 89 ?? ?? ?? B4 30 CD 21 8B ?? ?? ?? 8B ?? ?? ?? 8E DA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ZOO_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ZOO_Archive"
        weight = 1
    strings:
        $a = { 5A 4F 4F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEMangle: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEMangle"
        weight = 1
    strings:
        $a = { 60 9C BE ?? ?? ?? ?? 8B FE B9 ?? ?? ?? ?? BB 44 52 4F 4C AD 33 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Splice_11_by_Tw1sted_L0gic: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Splice_11_by_Tw1sted_L0gic"
        weight = 1
    strings:
        $a = { 68 00 1A 40 00 E8 EE FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 ?? ?? ?? ?? ?? ?? 50 72 6F 6A 65 63 74 31 00 ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 06 00 00 00 AC 29 40 00 07 00 00 00 BC 28 40 00 07 00 00 00 74 28 40 00 07 00 00 00 2C 28 40 00 07 00 00 00 08 23 40 00 01 00 00 00 38 21 40 00 00 00 00 00 FF FF FF FF FF FF FF FF 00 00 00 00 8C 21 40 00 08 ?? 40 00 01 00 00 00 AC 19 40 00 00 00 00 00 00 00 00 00 00 00 00 00 AC 19 40 00 4F 00 43 00 50 00 00 00 E7 AF 58 2F 9A 4C 17 4D B7 A9 CA 3E 57 6F F7 76 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_14_Liuxingping: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_14_Liuxingping"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 ?? ?? 40 00 2D ?? ?? 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v20_bartxt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v20_bartxt"
        weight = 1
    strings:
        $a = { 86 2F 96 2F A6 2F B6 2F 22 4F 43 68 53 6B 63 6A 73 69 F0 7F 0B D0 0B 40 09 00 09 D0 B3 65 A3 66 93 67 0B 40 83 64 03 64 04 D0 0B 40 09 00 10 7F 26 4F F6 6B F6 6A F6 69 0B 00 F6 68 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 22 4F F0 7F 0A D0 06 D4 06 D5 0B 40 09 00 08 D0 05 D4 06 D5 0B 40 09 00 10 7F 26 4F 0B 00 09 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7F ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 }
        $b = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? ?? 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 00 00 00 EB 28 AC D1 E8 74 41 13 C9 EB 1C 91 48 C1 E0 08 AC E8 22 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 96 33 C9 41 FF 54 24 04 13 C9 FF 54 24 04 72 F4 C3 5F 5B 0F B7 3B 4F 74 08 4F 74 13 C1 E7 0C EB 07 8B 7B 02 57 83 C3 04 43 43 E9 52 FF FF FF 5F BB ?? ?? ?? ?? 47 8B 37 AF 57 FF 13 95 33 C0 AE 75 FD FE ?? 74 EF FE }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ACProtect_V20_risco: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtect_V20_risco"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? C3 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Enigma_Protector_11X_13X_Sukhov_Vladimir_Serge_N_Markin: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Enigma_Protector_11X_13X_Sukhov_Vladimir_Serge_N_Markin"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 00 10 40 00 E8 01 00 00 00 9A 83 C4 10 8B E5 5D E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_VBOX_43_MTE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_VBOX_43_MTE"
        weight = 1
    strings:
        $a = { 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 0B C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MinGW_GCC_DLL_v2xx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MinGW_GCC_DLL_v2xx"
        weight = 1
    strings:
        $a = { 55 89 E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PPC_PROTECT_10_Alexey_Gorchakov: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PPC_PROTECT_10_Alexey_Gorchakov"
        weight = 1
    strings:
        $a = { FF 5F 2D E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_PEX_099_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_PEX_099_emadicius"
        weight = 1
    strings:
        $a = { 60 E8 01 00 00 00 E8 83 C4 04 E8 01 00 00 00 E9 5D 81 ED FF 22 40 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PackItBitch_V10_archphase: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PackItBitch_V10_archphase"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Embedded_2547_V2600_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_2547_V2600_Jitit"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 58 BB BC 18 00 00 2B C3 50 68 ?? ?? ?? ?? 68 60 1B 00 00 68 60 00 00 00 E8 35 FF FF FF E9 99 FF FF FF 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Armadillo_300: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Armadillo_300"
        weight = 1
    strings:
        $a = { 60 E8 2A 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 85 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Anti007_V27_V35_NsPacK_Private: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Anti007_V27_V35_NsPacK_Private"
        weight = 1
    strings:
        $a = { 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 54 65 6D 70 50 61 74 68 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 57 72 69 74 65 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXEStealth_276_Unregistered_WebtoolMaster: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXEStealth_276_Unregistered_WebtoolMaster"
        weight = 1
    strings:
        $a = { EB ?? 45 78 65 53 74 65 61 6C 74 68 20 56 32 20 53 68 61 72 65 77 61 72 65 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_430_440_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_430_440_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 40 ?? ?? 00 68 80 ?? ?? 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 ?? ?? 00 33 D2 8A D4 89 15 30 ?? ?? 00 8B C8 81 E1 FF 00 00 00 89 0D 2C ?? ?? 00 C1 E1 08 03 CA 89 0D 28 ?? ?? 00 C1 E8 10 A3 24 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Basic_v60_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Basic_v60_DLL"
        weight = 1
    strings:
        $a = { 5A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 52 E9 ?? ?? FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ShellModify_01_pll621: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ShellModify_01_pll621"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 98 66 41 00 68 3C 3D 41 00 64 A1 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V119_aPlib_043_ap0x_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V119_aPlib_043_ap0x_Sign_by_fly"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF E8 9F 01 00 00 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A 00 00 FF 34 37 FF 74 37 04 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECrc32_088_ZhouJinYu: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECrc32_088_ZhouJinYu"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED B6 A4 45 00 8D BD B0 A4 45 00 81 EF 82 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_120_Eng_dulekxt_Borland_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_120_Eng_dulekxt_Borland_Cpp"
        weight = 1
    strings:
        $a = { 03 DE EB 01 F8 B8 80 ?? 42 00 EB 02 CD 20 68 17 A0 B3 AB EB 01 E8 59 0F B6 DB 68 0B A1 B3 AB EB 02 CD 20 5E 80 CB AA 2B F1 EB 02 CD 20 43 0F BE 38 13 D6 80 C3 47 2B FE EB 01 F4 03 FE EB 02 4F 4E 81 EF 93 53 7C 3C 80 C3 29 81 F7 8A 8F 67 8B 80 C3 C7 2B FE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AVP_Antiviral_Database: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AVP_Antiviral_Database"
        weight = 1
    strings:
        $a = { 41 56 50 20 41 6E 74 69 76 69 72 61 6C 20 44 61 74 61 62 61 73 65 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule N_Joy_10_NEX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID N_Joy_10_NEX"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 9C 3B 40 00 E8 8C FC FF FF 6A 00 68 E4 39 40 00 6A 0A 6A 00 E8 40 FD FF FF E8 EF F5 FF FF 8D 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BookManager_v9510: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BookManager_v9510"
        weight = 1
    strings:
        $a = { FC A3 ?? ?? 89 1E ?? ?? 49 89 0E ?? ?? BB ?? ?? 8C 1F 83 ?? ?? 89 ?? ?? B8 ?? ?? 50 89 ?? ?? F7 D0 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_2021_wwwstrongbitcom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_2021_wwwstrongbitcom"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F4 56 57 53 BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 D0 03 45 F4 8B 18 8B 7E 10 01 D7 03 7D F4 09 DB 0F 84 ?? 00 00 00 F7 C3 00 00 00 80 0F 85 04 00 00 00 8D 5C 13 02 81 E3 FF FF FF ?? 53 FF 75 F8 FF 15 9C ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 07 83 45 F4 04 E9 A6 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AverCryptor_10_os1r1s: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AverCryptor_10_os1r1s"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 75 17 40 00 8B BD 9C 18 40 00 8B 8D A4 18 40 00 B8 BC 18 40 00 03 C5 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 A0 18 40 00 33 C0 51 33 C9 66 B9 FA 00 66 83 F9 00 74 49 8B 57 0C 03 95 A0 18 40 00 8B 85 A8 18 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 8B F1 E8 27 00 00 00 8B C8 5F B8 BC 18 40 00 03 C5 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 98 18 40 00 89 44 24 1C 61 FF E0 56 57 4F F7 D7 23 F7 8B C6 5F 5E C3 }
        $b = { 60 E8 00 00 00 00 5D 81 ED 75 17 40 00 8B BD 9C 18 40 00 8B 8D A4 18 40 00 B8 BC 18 40 00 03 C5 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 A0 18 40 00 33 C0 51 33 C9 66 B9 FA 00 66 83 F9 00 74 49 8B 57 0C 03 95 A0 18 40 00 8B 85 A8 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule UPX_v0761_dos_exe: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v0761_dos_exe"
        weight = 1
    strings:
        $a = { B9 ?? ?? BE ?? ?? 89 F7 1E A9 ?? ?? 8C C8 05 ?? ?? 8E D8 05 ?? ?? 8E C0 FD F3 A5 FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_42_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_42_DLL"
        weight = 1
    strings:
        $a = { 53 B8 ?? ?? ?? ?? 8B ?? ?? ?? 56 57 85 DB 55 75 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1355_Obsidium_Softwarenbsp_nbsp_SignByfly_20080411: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1355_Obsidium_Softwarenbsp_nbsp_SignByfly_20080411"
        weight = 1
    strings:
        $a = { EB 01 ?? E8 2B 00 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 23 EB 03 ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 03 ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 02 ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 ?? ?? ?? ?? EB 01 ?? E8 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? EB 01 ?? 58 EB 03 ?? ?? ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 01 ?? E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Interchange_Format_File_IFF_type_WVQA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Interchange_Format_File_IFF_type_WVQA"
        weight = 1
    strings:
        $a = { 46 4F 52 4D ?? ?? ?? ?? 57 56 51 41 56 51 48 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PC_Guard_for_Win32_v500_SofProBlagoje_Ceklic: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PC_Guard_for_Win32_v500_SofProBlagoje_Ceklic"
        weight = 1
    strings:
        $a = { FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 ?? ?? ?? 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CopyControl_v303: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CopyControl_v303"
        weight = 1
    strings:
        $a = { CC 90 90 EB 0B 01 50 51 52 53 54 61 33 61 2D 35 CA D1 07 52 D1 A1 3C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_PE_Crypt_102_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_PE_Crypt_102_emadicius"
        weight = 1
    strings:
        $a = { FC 55 50 E8 00 00 00 00 5D EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 58 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PACKWIN_v101p: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PACKWIN_v101p"
        weight = 1
    strings:
        $a = { 8C C0 FA 8E D0 BC ?? ?? FB 06 0E 1F 2E ?? ?? ?? ?? 8B F1 4E 8B FE 8C DB 2E ?? ?? ?? ?? 8E C3 FD F3 A4 53 B8 ?? ?? 50 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EPW_v130: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EPW_v130"
        weight = 1
    strings:
        $a = { 06 57 1E 56 55 52 51 53 50 2E 8C 06 08 00 8C C0 83 C0 10 2E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v140_v145: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v140_v145"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 8A 11 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1258_V133X_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1258_V133X_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 01 ?? E8 ?? 00 00 00 EB 02 ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ENIGMA_Protector_V11_Sukhov_Vladimir: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ENIGMA_Protector_V11_Sukhov_Vladimir"
        weight = 1
    strings:
        $a = { 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4C 6F 61 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SVKP_v142_Pavol_Cerven_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SVKP_v142_Pavol_Cerven_h"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 49 DC EC 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 2D 67 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 2D 67 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 39 67 00 00 5D 6A FF FF 95 31 67 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeJoiner_Small_build_023_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeJoiner_Small_build_023_GlOFF"
        weight = 1
    strings:
        $a = { E8 E1 FD FF FF 6A 00 E8 0C 00 00 00 FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00 }
        $b = { E8 E1 FD FF FF 6A 00 E8 0C 00 00 00 FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Upx_v12_Marcus_Lazlo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upx_v12_Marcus_Lazlo"
        weight = 1
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF EB 05 A4 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 F2 31 C0 40 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 75 07 8B 1E 83 EE FC 11 DB 73 E6 31 C9 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_PE_Pack_099: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_PE_Pack_099"
        weight = 1
    strings:
        $a = { 60 E8 11 00 00 00 5D 83 ED 06 80 BD E0 04 90 90 01 0F 84 F2 FF CC 0A E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule N_Joy_12_NEX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID N_Joy_12_NEX"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 A4 32 40 00 E8 E8 F1 FF FF 6A 00 68 54 2A 40 00 6A 0A 6A 00 E8 A8 F2 FF FF E8 C7 EA FF FF 8D 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PureBasic_4x_DLL_Neil_Hodgson: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PureBasic_4x_DLL_Neil_Hodgson"
        weight = 1
    strings:
        $a = { 83 7C 24 08 01 75 0E 8B 44 24 04 A3 ?? ?? ?? 10 E8 22 00 00 00 83 7C 24 08 02 75 00 83 7C 24 08 00 75 05 E8 ?? 00 00 00 83 7C 24 08 03 75 00 B8 01 00 00 00 C2 0C 00 68 00 00 00 00 68 00 10 00 00 68 00 00 00 00 E8 ?? 0F 00 00 A3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACProtect_109g_Risco_software_Inc: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtect_109g_Risco_software_Inc"
        weight = 1
    strings:
        $a = { 60 F9 50 E8 01 00 00 00 7C 58 58 49 50 E8 01 00 00 00 7E 58 58 79 04 66 B9 B8 72 E8 01 00 00 00 7A 83 C4 04 85 C8 EB 01 EB C1 F8 BE 72 03 73 01 74 0F 81 01 00 00 00 F9 EB 01 75 F9 E8 01 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule T_PACK_v05c_m1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID T_PACK_v05c_m1"
        weight = 1
    strings:
        $a = { 68 ?? ?? FD 60 BE ?? ?? BF ?? ?? B9 ?? ?? F3 A4 8B F7 BF ?? ?? FC 46 E9 8E FE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Borland_Cpp"
        weight = 1
    strings:
        $a = { 23 CA EB 02 5A 0D E8 02 00 00 00 6A 35 58 C1 C9 10 BE 80 ?? ?? 00 0F B6 C9 EB 02 CD 20 BB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BeRoEXEPacker_v100_BeRo_Farbrausch: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BeRoEXEPacker_v100_BeRo_Farbrausch"
        weight = 1
    strings:
        $a = { 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 04 00 00 00 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8 BA ?? ?? ?? ?? 8D B2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule bambam_V004_bedrock: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID bambam_V004_bedrock"
        weight = 1
    strings:
        $a = { BF ?? ?? ?? ?? 83 C9 FF 33 C0 68 ?? ?? ?? ?? F2 AE F7 D1 49 51 68 ?? ?? ?? ?? E8 11 0A 00 00 83 C4 0C 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 BF ?? ?? ?? ?? 83 C9 FF 33 C0 F2 AE F7 D1 49 BF ?? ?? ?? ?? 8B D1 68 ?? ?? ?? ?? C1 E9 02 F3 AB 8B CA 83 E1 03 F3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEncrypt_20_junkcode: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEncrypt_20_junkcode"
        weight = 1
    strings:
        $a = { EB 25 00 00 F7 BF 00 00 00 00 00 00 00 00 00 00 12 00 E8 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 00 00 E8 00 00 00 00 5D 81 ED 2C 10 40 00 8D B5 14 10 40 00 E8 33 00 00 00 89 85 10 10 40 00 BF 00 00 40 00 8B F7 03 7F 3C 8B 4F 54 51 56 8D 85 23 10 40 00 50 6A 04 51 56 FF 95 10 10 40 00 5E 59 C6 06 00 46 E2 FA E9 AE 00 00 00 55 E8 00 00 00 00 5D 81 ED 77 10 40 00 8B D6 80 3E 00 74 03 46 EB F8 46 2B F2 8B CE 33 C0 66 89 85 06 10 40 00 8B B5 02 10 40 00 83 C6 3C 66 AD 03 85 02 10 40 00 8B 70 78 03 B5 02 10 40 00 83 C6 1C AD 03 85 02 10 40 00 89 85 08 10 40 00 AD 03 85 02 10 40 00 50 AD 03 85 02 10 40 00 89 85 0C 10 40 00 5E 56 AD 03 85 02 10 40 00 8B F0 8B FA 51 FC F3 A6 59 74 0D 5E 83 C6 04 66 FF 85 06 10 40 00 EB E0 5E 0F B7 85 06 10 40 00 D1 E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v19x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v19x"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 98 ?? ?? ?? 68 10 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_2xx_max_compressed_resources_wwwstrongbitcom_SignByhaggar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_2xx_max_compressed_resources_wwwstrongbitcom_SignByhaggar"
        weight = 1
    strings:
        $a = { 56 57 53 31 DB 89 C6 89 D7 0F B6 06 89 C2 83 E0 1F C1 EA 05 74 2D 4A 74 15 8D 5C 13 02 46 C1 E0 08 89 FA 0F B6 0E 46 29 CA 4A 29 C2 EB 32 C1 E3 05 8D 5C 03 04 46 89 FA 0F B7 0E 29 CA 4A 83 C6 02 EB 1D C1 E3 04 46 89 C1 83 E1 0F 01 CB C1 E8 05 73 07 43 89 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule North_Star_PE_Shrinker_13_Liuxingping: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID North_Star_PE_Shrinker_13_Liuxingping"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_packer_02: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_packer_02"
        weight = 1
    strings:
        $a = { FA 8C DE 8C CF 8E DF 8E C7 83 C7 ?? BB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v037_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v037_beta_Dwing"
        weight = 1
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 37 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 ?? 00 00 ?? 00 00 ?? 00 00 ?? ?? 00 00 00 10 00 00 10 00 00 00 00 00 00 0A 00 00 00 00 00 00 00 00 00 00 00 EE ?? ?? ?? 14 00 00 00 00 ?? ?? ?? ?? ?? ?? 00 FF 76 38 AD 50 8B 3E BE F0 ?? ?? ?? 6A 27 59 F3 A5 FF 76 04 83 C8 FF 8B DF AB EB 1C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? ?? ?? ?? ?? 00 00 00 40 AB 40 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB 8B 7E 0C 57 51 E9 ?? ?? ?? ?? E3 B1 04 D3 E0 03 E8 8D 53 18 33 C0 55 40 51 D3 E0 8B EA 91 FF 56 4C 33 D2 59 D1 E8 13 D2 E2 FA 5D 03 EA 45 59 89 6B 08 56 8B F7 2B F5 F3 A4 AC 5E B1 80 AA 3B 7E 34 0F 82 8E FE FF FF 58 5F 59 E3 1B 8A 07 47 04 18 3C 02 73 F7 8B 07 3C ?? 75 F1 B0 00 0F C8 03 46 38 2B C7 AB E2 E5 5E 5D 59 51 59 46 AD 85 C0 74 1F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Pack_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Pack_v10"
        weight = 1
    strings:
        $a = { 74 ?? E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PluginToExe_v100_BoB_BobSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PluginToExe_v100_BoB_BobSoft"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 29 C0 5D 81 ED D1 40 40 00 50 FF 95 B8 40 40 00 89 85 09 40 40 00 FF 95 B4 40 40 00 89 85 11 40 40 00 50 FF 95 C0 40 40 00 8A 08 80 F9 22 75 07 50 FF 95 C4 40 40 00 89 85 0D 40 40 00 8B 9D 09 40 40 00 60 6A 00 6A 01 53 81 C3 ?? ?? ?? 00 FF D3 61 6A 00 68 44 69 45 50 FF B5 0D 40 40 00 6A 00 81 C3 ?? ?? ?? 00 FF D3 83 C4 10 FF 95 B0 40 40 00 }
        $b = { E8 00 00 00 00 29 C0 5D 81 ED D1 40 40 00 50 FF 95 B8 40 40 00 89 85 09 40 40 00 FF 95 B4 40 40 00 89 85 11 40 40 00 50 FF 95 C0 40 40 00 8A 08 80 F9 22 75 07 50 FF 95 C4 40 40 00 89 85 0D 40 40 00 8B 9D 09 40 40 00 60 6A 00 6A 01 53 81 C3 ?? ?? ?? 00 FF }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Unknown_packer_05: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_packer_05"
        weight = 1
    strings:
        $a = { FA BB ?? ?? B9 ?? ?? 87 E5 87 27 03 E3 91 8A CB 80 E1 ?? D3 C4 91 33 E3 87 27 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_packer_04: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_packer_04"
        weight = 1
    strings:
        $a = { BC ?? ?? C3 2E FF 2E ?? ?? CF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_packer_08: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_packer_08"
        weight = 1
    strings:
        $a = { 8B C4 2D ?? ?? 24 00 8B F8 57 B9 ?? ?? BE ?? ?? F3 A5 FD C3 97 4F 4F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp"
        weight = 1
    strings:
        $a = { C1 C8 10 EB 01 0F BF 03 74 66 77 C1 E9 1D 68 83 ?? ?? 77 EB 02 CD 20 5E EB 02 CD 20 2B F7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_v118_Basic_aPLib_Ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_v118_Basic_aPLib_Ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_Neolite_20_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_Neolite_20_emadicius"
        weight = 1
    strings:
        $a = { 55 8B EC 56 57 BF 01 00 00 00 8B 75 0C 85 F6 5F 5E 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Copy_Protector_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Copy_Protector_v20"
        weight = 1
    strings:
        $a = { 2E A2 ?? ?? 53 51 52 1E 06 B4 ?? 1E 0E 1F BA ?? ?? CD 21 1F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BAFF_BMPs_graphics_library: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BAFF_BMPs_graphics_library"
        weight = 1
    strings:
        $a = { 42 41 46 46 01 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_Pascal_v30_1985: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_Pascal_v30_1985"
        weight = 1
    strings:
        $a = { ?? ?? ?? 90 90 CD AB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 38 35 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_SKE_2122_exe_Alexey_Solodovnikov_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_SKE_2122_exe_Alexey_Solodovnikov_h"
        weight = 1
    strings:
        $a = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 ED 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C 00 }
        $b = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 ED 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 B8 F8 C0 A5 23 50 50 03 45 4E 5B 85 C0 74 1C EB 01 E8 81 FB F8 C0 A5 23 74 35 33 D2 56 6A 00 56 FF 75 4E FF D0 5E 83 FE 00 75 24 33 D2 8B 45 41 85 C0 74 07 52 52 FF 75 35 FF D0 8B 45 35 85 C0 74 0D 68 00 80 00 00 6A 00 FF 75 35 FF 55 3D 5B 0B DB 61 75 06 6A 01 58 C2 0C 00 33 C0 F7 D8 1B C0 40 C2 0C }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Phoenix_Protector_v10v11_NTCorecom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Phoenix_Protector_v10v11_NTCorecom"
        weight = 1
    strings:
        $a = { 02 6F ?? ?? ?? 0A 0A 06 8D ?? ?? ?? 01 0B 16 0C 38 36 00 00 00 02 08 6F ?? ?? ?? 0A 0D 09 06 08 59 61 D2 13 04 09 1E 63 08 61 D2 13 05 07 08 11 05 1E 62 11 04 60 D1 9D 08 17 58 0C 08 07 8E 69 38 0B 00 00 00 28 ?? ?? ?? 0A 2A 38 EC FF FF FF 3F C0 FF FF FF 07 73 ?? ?? ?? 0A 38 E5 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_110_Eng_dulekxt_Microsoft_Visual_Cpp_60: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_110_Eng_dulekxt_Microsoft_Visual_Cpp_60"
        weight = 1
    strings:
        $a = { 03 F7 23 FE 33 FB EB 02 CD 20 BB 80 ?? 40 00 EB 01 86 EB 01 90 B8 F4 00 00 00 83 EE 05 2B F2 81 F6 EE 00 00 00 EB 02 CD 20 8A 0B E8 02 00 00 00 A9 54 5E C1 EE 07 F7 D7 EB 01 DE 81 E9 B7 96 A0 C4 EB 01 6B EB 02 CD 20 80 E9 4B C1 CF 08 EB 01 71 80 E9 1C EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPacK_V33_LiuXingPing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPacK_V33_LiuXingPing"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? ?? ?? 80 38 00 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Windows_Update_CAB_SFX_module: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Windows_Update_CAB_SFX_module"
        weight = 1
    strings:
        $a = { E9 C5 FA FF FF 55 8B EC 56 8B 75 08 68 04 08 00 00 FF D6 59 33 C9 3B C1 75 0F 51 6A 05 FF 75 28 E8 2E 11 00 00 33 C0 EB 69 8B 55 0C 83 88 88 00 00 00 FF 83 88 84 00 00 00 FF 89 50 04 8B 55 10 89 50 0C 8B 55 14 89 50 10 8B 55 18 89 50 14 8B 55 1C 89 50 18 8B 55 20 89 50 1C 8B 55 24 89 50 20 8B 55 28 89 48 48 89 48 44 89 48 4C B9 FF FF 00 00 89 70 08 89 10 66 C7 80 B2 00 00 00 0F 00 89 88 A0 00 00 00 89 88 A8 00 00 00 89 88 A4 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pi_Cryptor_10_by_Scofield: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pi_Cryptor_10_by_Scofield"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 EC 53 56 57 31 C0 89 45 EC B8 40 1E 06 00 E8 48 FA FF FF 33 C0 55 68 36 1F 06 00 64 FF 30 64 89 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 31 C0 E8 4E F4 FF FF 8B 45 EC E8 F6 F7 FF FF 50 E8 CC FA FF FF 8B D8 83 FB FF 74 4E 6A 00 53 E8 CD FA FF FF 8B F8 81 EF AC 26 00 00 6A 00 6A 00 68 AC 26 00 00 53 E8 DE FA FF FF 89 F8 E8 E3 F1 FF FF 89 C6 6A 00 68 28 31 06 00 57 56 53 E8 AE FA FF FF 53 E8 80 FA FF FF 89 FA 81 EA 72 01 00 00 8B C6 E8 55 FE FF FF 89 C6 89 F0 09 C0 74 05 E8 A8 FB FF FF 31 C0 5A 59 59 64 89 10 68 3D 1F 06 00 8D 45 EC E8 C3 F6 FF FF C3 }
        $b = { 89 55 F8 BB 01 00 00 00 8A 04 1F 24 0F 8B 55 FC 8A 14 32 80 E2 0F 32 C2 8A 14 1F 80 E2 F0 02 D0 88 14 1F 46 8D 45 F4 8B 55 FC E8 ?? ?? ?? ?? 8B 45 F4 E8 ?? ?? ?? ?? 3B F0 7E 05 BE 01 00 00 00 43 FF 4D F8 75 C2 ?? ?? ?? ?? 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F4 E8 ?? ?? ?? ?? C3 E9 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Cracked_by_Autohack_2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Cracked_by_Autohack_2"
        weight = 1
    strings:
        $a = { 0E 1F B4 09 BA ?? ?? CD 21 FA 8E 06 ?? ?? BE ?? ?? 8B 0E ?? ?? 83 F9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Macs_StuffIt_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Macs_StuffIt_Archive"
        weight = 1
    strings:
        $a = { 53 49 54 21 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LCC_Win32_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LCC_Win32_DLL"
        weight = 1
    strings:
        $a = { 55 89 E5 53 56 57 83 7D 0C 01 75 05 E8 17 ?? ?? ?? FF 75 10 FF 75 0C FF 75 08 A1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HACKSTOP_v119: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HACKSTOP_v119"
        weight = 1
    strings:
        $a = { 52 BA ?? ?? 5A EB ?? 9A ?? ?? ?? ?? 30 CD 21 ?? ?? ?? D6 02 ?? ?? CD 20 0E 1F 52 BA ?? ?? 5A EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HACKSTOP_v118: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HACKSTOP_v118"
        weight = 1
    strings:
        $a = { 52 BA ?? ?? 5A EB ?? 9A ?? ?? ?? ?? 30 CD 21 ?? ?? ?? FD 02 ?? ?? CD 20 0E 1F 52 BA ?? ?? 5A EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACProtect_V13X_risco: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtect_V13X_risco"
        weight = 1
    strings:
        $a = { 60 50 E8 01 00 00 00 75 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HACKSTOP_v113: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HACKSTOP_v113"
        weight = 1
    strings:
        $a = { 52 B8 ?? ?? 1E CD 21 86 E0 3D ?? ?? 73 ?? CD 20 0E 1F B4 09 E8 ?? ?? 24 ?? EA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Symantec_WinFax_PRO_83_Coverpage: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Symantec_WinFax_PRO_83_Coverpage"
        weight = 1
    strings:
        $a = { 0C BD 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 06 6C }
        $b = { FF FF ?? ?? ?? ?? ?? 43 6F 76 65 72 44 61 74 61 62 61 73 65 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Private_exe_Protector_20_SetiSoft_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_exe_Protector_20_SetiSoft_Team"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_Pascal_Desktop_File: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_Pascal_Desktop_File"
        weight = 1
    strings:
        $a = { 54 75 72 62 6F 20 50 61 73 63 61 6C 20 44 65 73 6B 74 6F 70 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Xtreme_Protector_v105: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Xtreme_Protector_v105"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? 00 B9 75 ?? ?? 00 50 51 E8 05 00 00 00 E9 4A 01 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 8A 06 46 88 07 47 BB 02 00 00 00 02 D2 75 05 8A 16 46 12 D2 73 EA 02 D2 75 05 8A 16 46 12 D2 73 4F 33 C0 02 D2 75 05 8A 16 46 12 D2 0F 83 DF 00 00 00 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule JEDMICS_CCITT4_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID JEDMICS_CCITT4_Graphics_format"
        weight = 1
    strings:
        $a = { 80 00 00 00 ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RAZOR_1911_encruptor: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RAZOR_1911_encruptor"
        weight = 1
    strings:
        $a = { E8 ?? ?? BF ?? ?? 3B FC 72 ?? B4 4C CD 21 BE ?? ?? B9 ?? ?? FD F3 A5 FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _MSLRH_v032a_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _MSLRH_v032a_emadicius"
        weight = 1
    strings:
        $a = { E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v275a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v275a"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 68 ?? ?? ?? 68 D0 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 28 ?? ?? ?? 33 D2 8A D4 89 15 24 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _v10_: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _v10_"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 0A 4A 44 00 BB 04 4A 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BeRo_Tiny_Pascal_BeRo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BeRo_Tiny_Pascal_BeRo"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? 20 43 6F 6D 70 69 6C 65 64 20 62 79 3A 20 42 65 52 6F 54 69 6E 79 50 61 73 63 61 6C 20 2D 20 28 43 29 20 43 6F 70 79 72 69 67 68 74 20 32 30 30 36 2C 20 42 65 6E 6A 61 6D 69 6E 20 27 42 65 52 6F 27 20 52 6F 73 73 65 61 75 78 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule COOLcryptor_09_kongfoo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID COOLcryptor_09_kongfoo"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 E9 EB 07 FF 04 24 EB 01 FF C3 E8 03 00 00 00 EB 02 EA C3 EB 08 8D 8D 72 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_Run_Time_Library_1987: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Run_Time_Library_1987"
        weight = 1
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? 9A ?? ?? ?? ?? B8 ?? ?? 50 9A ?? ?? ?? ?? 92 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MPRESS_V085_V092_MATCODE_Softwarenbsp_nbsp_SignByfly_20080414: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MPRESS_V085_V092_MATCODE_Softwarenbsp_nbsp_SignByfly_20080414"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 58 05 48 01 00 00 8B 30 03 F0 2B C0 8B FE 66 AD C1 E0 0C 8B C8 50 AD 2B C8 03 F1 8B C8 57 49 8A 44 39 06 74 05 88 04 31 EB F4 88 04 31 2B C0 3B FE 73 28 AC 0A C0 74 23 8A C8 24 3F C1 E0 10 66 AD 80 E1 40 74 0F 8B D6 8B CF 03 F0 E8 5F 00 00 00 03 F8 EB D8 8B C8 F3 A4 EB D2 5E 5A 83 EA 05 2B C9 3B CA 73 25 8B D9 AC 41 24 FE 3C E8 75 F2 83 C1 04 AD 0B C0 78 06 3B C2 73 E6 EB 06 03 C3 78 E0 03 C2 2B C3 89 46 FC EB D7 E8 00 00 00 00 5F 81 C7 6A FF FF FF B0 E9 AA B8 44 01 00 00 AB E8 00 00 00 00 58 05 A3 00 00 00 E9 93 00 00 00 53 56 57 8B F9 8B F2 8B DA 03 D8 51 55 33 C0 8B EB 8B DE 2B D2 2B C9 EB 4F 3B DD 73 6C 2B C9 66 8B 03 8D 5B 02 8A CC 80 E4 0F 0B C0 75 02 B4 10 C0 E9 04 80 C1 03 80 F9 12 72 19 8A 0B 66 83 C1 12 43 66 81 F9 11 01 72 0B 66 8B 0B 81 C1 11 01 00 00 43 43 8B F7 2B F0 F3 A4 12 D2 74 0A 72 B9 8A 03 43 88 07 47 EB F2 3B DD 73 1D 0A 13 F9 74 03 43 EB E6 8B 43 01 89 07 8B 43 05 89 47 04 8D 5B 09 8D 7F 08 33 C0 EB DF 5D 8B C7 59 2B C1 5F 5E 5B C3 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pe_Ninja_pDzA_kRAker_TNT: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pe_Ninja_pDzA_kRAker_TNT"
        weight = 1
    strings:
        $a = { BE 5B 2A 40 00 BF 35 12 00 00 E8 40 12 00 00 3D 22 83 A3 C6 0F 85 67 0F 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_V310X_Thinstall_Company: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Virtualization_Suite_V310X_Thinstall_Company"
        weight = 1
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB ?? ?? ?? ?? 2B C3 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 2C FF FF FF E9 90 FF FF FF CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_2xx_compressed_resources: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_2xx_compressed_resources"
        weight = 1
    strings:
        $a = { 56 57 53 31 DB 89 C6 89 D7 0F B6 06 89 C2 83 E0 1F C1 EA 05 74 2D 4A 74 15 8D 5C 13 02 46 C1 E0 08 89 FA 0F B6 0E 46 29 CA 4A 29 C2 EB 32 C1 E3 05 8D 5C 03 04 46 89 FA 0F B7 0E 29 CA 4A 83 C6 02 EB 1D C1 E3 04 46 89 C1 83 E1 0F 01 CB C1 E8 05 73 07 43 89 F2 01 DE EB 06 85 DB 74 0E EB A9 56 89 D6 89 D9 F3 A4 31 DB 5E EB 9D 89 F0 5B 5F 5E C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Delphi_Borland_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Borland_Delphi_Borland_Cpp"
        weight = 1
    strings:
        $a = { 2B C2 E8 02 00 00 00 95 4A 59 8D 3D 52 F1 2A E8 C1 C8 1C BE 2E ?? ?? 18 EB 02 AB A0 03 F7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v190a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v190a"
        weight = 1
    strings:
        $a = { 55 8B EC 64 FF 68 10 F2 40 00 68 14 9B 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PRO_PACK_v208: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PRO_PACK_v208"
        weight = 1
    strings:
        $a = { 8C D3 8E C3 8C CA 8E DA 8B 0E ?? ?? 8B F1 83 ?? ?? 8B FE D1 ?? FD F3 A5 53 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule QrYPt0r_by_NuTraL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID QrYPt0r_by_NuTraL"
        weight = 1
    strings:
        $a = { 80 F9 00 0F 84 8D 01 00 00 8A C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 32 C1 3C F3 75 89 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? BA D9 04 00 00 E8 00 00 00 00 5F 81 C7 16 01 00 00 80 2C 3A 01 }
        $b = { 86 18 CC 64 FF 35 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 64 89 25 00 00 00 00 BB 00 00 F7 BF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B8 78 56 34 12 87 03 E8 CD FE FF FF E8 B3 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ASDPack_asd_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASDPack_asd_SignByfly"
        weight = 1
    strings:
        $a = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8D 49 00 1F 01 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 90 }
        $b = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 8D 49 00 1F 01 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule CA_Visual_Objects_20_25: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CA_Visual_Objects_20_25"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule X_PEOR_v099b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID X_PEOR_v099b"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? 5D 8B CD 81 ED 7A 29 40 ?? 89 AD 0F 6D 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_620: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Microsoft_Visual_Cpp_620"
        weight = 1
    strings:
        $a = { 90 90 90 90 68 ?? ?? ?? ?? 67 64 FF 36 00 00 67 64 89 26 00 00 F1 90 90 90 90 55 8B EC 83 EC 50 53 56 57 BE 90 90 90 90 8D 7D F4 A5 A5 66 A5 8B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Diminisher_V01_Teraphy: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Diminisher_V01_Teraphy"
        weight = 1
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PKLITE_v150_Device_driver_compression: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PKLITE_v150_Device_driver_compression"
        weight = 1
    strings:
        $a = { B4 09 BA 14 01 CD 21 B8 00 4C CD 21 F8 9C 50 53 51 52 56 57 55 1E 06 BB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Petite_v_after_v14: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Petite_v_after_v14"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 66 9C 60 50 8D ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PluginToExe_v102_BoB_BobSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PluginToExe_v102_BoB_BobSoft"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 29 C0 5D 81 ED 32 42 40 00 50 8F 85 DD 40 40 00 50 FF 95 11 42 40 00 89 85 D9 40 40 00 FF 95 0D 42 40 00 50 FF 95 21 42 40 00 80 38 00 74 16 8A 08 80 F9 22 75 07 50 FF 95 25 42 40 00 89 85 E1 40 40 00 EB 6C 6A 01 8F 85 DD 40 40 00 6A 58 6A 40 FF 95 15 42 40 00 89 85 D5 40 40 00 89 C7 68 00 08 00 00 6A 40 FF 95 15 42 40 00 89 47 1C C7 07 58 00 }
        $b = { E8 00 00 00 00 29 C0 5D 81 ED 32 42 40 00 50 8F 85 DD 40 40 00 50 FF 95 11 42 40 00 89 85 D9 40 40 00 FF 95 0D 42 40 00 50 FF 95 21 42 40 00 80 38 00 74 16 8A 08 80 F9 22 75 07 50 FF 95 25 42 40 00 89 85 E1 40 40 00 EB 6C 6A 01 8F 85 DD 40 40 00 6A 58 6A }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Microsoft_Visual_Cpp_v70: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v70"
        weight = 1
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPacK_V37_LiuXingPing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPacK_V37_LiuXingPing"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D ?? ?? ?? ?? ?? 80 39 01 0F ?? ?? ?? 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ANDpakk2_apk2_V018_Dmitry_quotANDquot_Andreevnbsp_nbsp_SignByfly_20080731: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ANDpakk2_apk2_V018_Dmitry_quotANDquot_Andreevnbsp_nbsp_SignByfly_20080731"
        weight = 1
    strings:
        $a = { FC BE ?? ?? ?? ?? BF ?? ?? ?? ?? 57 83 CD FF 33 C9 F9 EB 05 A4 02 DB 75 05 8A 1E 46 12 DB 72 F4 33 C0 40 02 DB 75 05 8A 1E 46 12 DB 13 C0 02 DB 75 05 8A 1E 46 12 DB 72 0E 48 02 DB 75 05 8A 1E 46 12 DB 13 C0 EB DC 83 E8 03 72 0F C1 E0 08 AC 83 F0 FF 74 4D D1 F8 8B E8 EB 09 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 13 C9 75 1A 41 02 DB 75 05 8A 1E 46 12 DB 13 C9 02 DB 75 05 8A 1E 46 12 DB 73 EA 83 C1 02 81 FD ?? ?? ?? ?? 83 D1 01 56 8D 34 2F F3 A4 5E E9 73 FF FF FF C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeJoiner_153_Stub_engine_17_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeJoiner_153_Stub_engine_17_GlOFF"
        weight = 1
    strings:
        $a = { E8 33 FD FF FF 50 E8 0D 00 00 00 CC FF 25 08 20 40 00 FF 25 0C 20 40 00 FF 25 10 20 40 00 FF 25 14 20 40 00 FF 25 18 20 40 00 FF 25 1C 20 40 00 FF 25 20 20 40 00 FF 25 24 20 40 00 FF 25 28 20 40 00 FF 25 00 20 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Enigma_Protector_1X_Sukhov_Vladimir_Serge_N_Markin: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Enigma_Protector_1X_Sukhov_Vladimir_Serge_N_Markin"
        weight = 1
    strings:
        $a = { 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 00 00 52 65 67 43 6C 6F 73 65 4B 65 79 00 00 00 53 79 73 46 72 65 65 53 74 72 69 6E 67 00 00 00 43 72 65 61 74 65 46 6F 6E 74 41 00 00 00 53 68 65 6C 6C 45 78 65 63 75 74 65 41 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_110_Eng_dulekxt_MASM32_TASM32: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_110_Eng_dulekxt_MASM32_TASM32"
        weight = 1
    strings:
        $a = { 1B DB E8 02 00 00 00 1A 0D 5B 68 80 ?? ?? 00 E8 01 00 00 00 EA 5A 58 EB 02 CD 20 68 F4 00 00 00 EB 02 CD 20 5E 0F B6 D0 80 CA 5C 8B 38 EB 01 35 EB 02 DC 97 81 EF F7 65 17 43 E8 02 00 00 00 97 CB 5B 81 C7 B2 8B A1 0C 8B D1 83 EF 17 EB 02 0C 65 83 EF 43 13 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt"
        weight = 1
    strings:
        $a = { F7 DB 80 EA BF B9 2F 40 67 BA EB 01 01 68 AF ?? ?? BA 80 EA 9D 58 C1 C2 09 2B C1 8B D7 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Windows_Cabinet_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Windows_Cabinet_file"
        weight = 1
    strings:
        $a = { 4D 53 43 46 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Cpp_60_Debug_Version: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Microsoft_Visual_Cpp_60_Debug_Version"
        weight = 1
    strings:
        $a = { 55 8B EC 51 90 90 90 01 01 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MinGW_32x_Dll_WinMain: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MinGW_32x_Dll_WinMain"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 18 89 75 FC 8B 75 0C 89 5D F8 83 FE 01 74 5C 89 74 24 04 8B 55 10 89 54 24 08 8B 55 08 89 14 24 E8 96 01 00 00 83 EC 0C 83 FE 01 89 C3 74 2C 85 F6 75 0C 8B 0D 00 30 00 10 85 C9 75 10 31 DB 89 D8 8B 5D F8 8B 75 FC 89 EC 5D C2 0C 00 E8 59 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_v03_Eng_cyberbob: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_v03_Eng_cyberbob"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 B7 CD 46 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MinGW_v32x_Dll_main: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MinGW_v32x_Dll_main"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 6A 00 6A 00 6A 00 6A 00 E8 0D 00 00 00 B8 00 00 00 00 C9 C3 90 90 90 90 90 90 FF 25 38 20 40 00 90 90 00 00 00 00 00 00 00 00 FF FF FF FF 00 00 00 00 FF FF FF FF 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Microsoft_Visual_Basic_50_60: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Microsoft_Visual_Basic_50_60"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? E8 0A 00 00 00 00 00 00 00 00 00 30 00 00 00 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule D1S1G_v11_beta_D1N: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID D1S1G_v11_beta_D1N"
        weight = 1
    strings:
        $a = { 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 0A 00 00 00 18 00 00 80 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 02 00 00 00 88 00 00 80 38 00 00 80 96 00 00 80 50 00 00 80 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 00 00 68 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 01 00 00 00 00 00 78 00 00 00 B0 ?? ?? 00 10 00 00 00 00 00 00 00 00 00 00 00 C0 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 06 00 44 00 56 00 43 00 4C 00 41 00 4C 00 0B 00 50 00 41 00 43 00 4B 00 41 00 47 00 45 00 49 00 4E 00 46 00 4F 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v101b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v101b"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED D2 2A 44 ?? B8 CC 2A 44 ?? 03 C5 2B 85 A5 2E 44 ?? 89 85 B1 2E 44 ?? 80 BD 9C 2E 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NTkrnl_Secure_Suite_V01_NTkrnl_Software_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NTkrnl_Secure_Suite_V01_NTkrnl_Software_Sign_by_fly"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 34 10 00 00 28 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPXShit_006: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPXShit_006"
        weight = 1
    strings:
        $a = { B8 ?? ?? 43 00 B9 15 00 00 00 80 34 08 ?? E2 FA E9 D6 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule vfpexeNc_V500_Wang_JianGuo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID vfpexeNc_V500_Wang_JianGuo"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 50 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule by_Central_Point_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID by_Central_Point_Software"
        weight = 1
    strings:
        $a = { 50 51 52 56 57 8B EB 1E 2E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v035_alpha_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v035_alpha_Dwing"
        weight = 1
    strings:
        $a = { 8B F2 8B CA 03 4C 19 1C 03 54 1A 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UnoPiX_075_BaGiE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UnoPiX_075_BaGiE"
        weight = 1
    strings:
        $a = { 60 E8 07 00 00 00 61 68 ?? ?? 40 00 C3 83 04 24 18 C3 20 83 B8 ED 20 37 EF C6 B9 79 37 9E 61 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ZM_Exe_Executable_Image: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ZM_Exe_Executable_Image"
        weight = 1
    strings:
        $a = { 5A 4D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Crunch_4_Bit_Arts: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Crunch_4_Bit_Arts"
        weight = 1
    strings:
        $a = { EB 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 55 E8 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_Run_Time_Library_1990_07: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Run_Time_Library_1990_07"
        weight = 1
    strings:
        $a = { 2E 8C 1E ?? ?? BB ?? ?? 8E DB 1E E8 ?? ?? 1F 8B 1E ?? ?? 0B DB 74 ?? 8C D1 8B D4 FA 8E D3 BC ?? ?? FB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule GameGuard_v20065xx_exe: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID GameGuard_v20065xx_exe"
        weight = 1
    strings:
        $a = { 31 FF 74 06 61 E9 4A 4D 50 30 5A BA 7D 00 00 00 80 7C 24 08 01 E9 00 00 00 00 60 BE 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeJoiner_151_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeJoiner_151_GlOFF"
        weight = 1
    strings:
        $a = { 90 87 FF 90 90 B9 2B 00 00 00 BA 07 10 40 00 83 C2 03 90 87 FF 90 90 B9 04 00 00 00 90 87 FF 90 33 C9 C7 05 09 30 40 00 00 00 00 00 68 00 01 00 00 68 21 30 40 00 6A 00 E8 B7 02 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 21 30 40 00 E8 8F 02 00 00 A3 19 30 40 00 90 87 FF 90 8B 15 09 30 40 00 81 C2 04 01 00 00 F7 DA 6A 02 6A 00 52 }
        $b = { 90 87 FF 90 90 B9 2B 00 00 00 BA 07 10 40 00 83 C2 03 90 87 FF 90 90 B9 04 00 00 00 90 87 FF 90 33 C9 C7 05 09 30 40 00 00 00 00 00 68 00 01 00 00 68 21 30 40 00 6A 00 E8 B7 02 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 21 30 40 00 E8 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule JExeCompressor_10_by_Arash_Veyskarami: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID JExeCompressor_10_by_Arash_Veyskarami"
        weight = 1
    strings:
        $a = { 8D 2D D3 4A E5 14 0F BB F7 0F BA E5 73 0F AF D5 8D 0D 0C 9F E6 11 C0 F8 EF F6 DE 80 DC 5B F6 DA 0F A5 C1 0F C1 F1 1C F3 4A 81 E1 8C 1F 66 91 0F BE C6 11 EE 0F C0 E7 33 D9 64 F2 C0 DC 73 0F C0 D5 55 8B EC BA C0 1F 41 00 8B C2 B9 97 00 00 00 80 32 79 50 B8 02 00 00 00 50 03 14 24 58 58 51 2B C9 B9 01 00 00 00 83 EA 01 E2 FB 59 E2 E1 FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TAV: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TAV"
        weight = 1
    strings:
        $a = { E8 ?? ?? 4D 5A CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BeRoEXEPacker_v100_LZMA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BeRoEXEPacker_v100_LZMA"
        weight = 1
    strings:
        $a = { 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? B9 04 00 00 00 8B F9 81 FE ?? ?? ?? ?? 7F 10 AC 47 04 18 2C 02 73 F0 29 3E 03 F1 03 F9 EB E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_C_50: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_C_50"
        weight = 1
    strings:
        $a = { 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 C4 A8 53 56 57 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Berio_100_beta_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Berio_100_beta_h"
        weight = 1
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 E9 01 12 00 00 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 B0 01 00 83 BD 22 04 00 00 00 89 9D 22 04 00 00 0F 85 65 03 00 00 8D 85 2E 04 00 00 50 FF 95 4D 0F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NSIS_Installer_NullSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NSIS_Installer_NullSoft"
        weight = 1
    strings:
        $a = { 83 EC 20 53 55 56 33 DB 57 89 5C 24 18 C7 44 24 10 ?? ?? ?? ?? C6 44 24 14 20 FF 15 30 70 40 00 53 FF 15 80 72 40 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule JExeCompressor_V10_UsAr: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID JExeCompressor_V10_UsAr"
        weight = 1
    strings:
        $a = { 0F C8 0F CF C6 C4 8B 0F AC EA 99 0F AD D8 13 F5 0F BD EF 85 EF 85 DA 69 FE ?? ?? ?? ?? 21 F9 BE ?? ?? ?? ?? 23 CF 0F BC FE D2 DC 85 EF B9 ?? ?? ?? ?? C6 C0 F7 8D 35 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0F BC C8 EB ?? C3 B8 ?? ?? ?? ?? 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NoodleCrypt_v200_Eng_NoodleSpa: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NoodleCrypt_v200_Eng_NoodleSpa"
        weight = 1
    strings:
        $a = { EB 01 9A E8 76 00 00 00 EB 01 9A E8 65 00 00 00 EB 01 9A E8 7D 00 00 00 EB 01 9A E8 55 00 00 00 EB 01 9A E8 43 04 00 00 EB 01 9A E8 E1 00 00 00 EB 01 9A E8 3D 00 00 00 EB 01 9A E8 EB 01 00 00 EB 01 9A E8 2C 04 00 00 EB 01 9A E8 25 00 00 00 EB 01 9A E8 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEiD_Bundle_v101_BoB_BobSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEiD_Bundle_v101_BoB_BobSoft"
        weight = 1
    strings:
        $a = { 60 E8 23 02 00 00 8B 44 24 04 52 48 66 31 C0 66 81 38 4D 5A 75 F5 8B 50 3C 81 3C 02 50 45 00 00 75 E9 5A C2 04 00 60 89 DD 89 C3 8B 45 3C 8B 54 28 78 01 EA 52 8B 52 20 01 EA 31 C9 41 8B 34 8A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Install_Stub_32_bit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Install_Stub_32_bit"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 14 ?? 00 00 53 56 57 6A 00 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 29 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unnamed_Scrambler_12B_p0ke: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unnamed_Scrambler_12B_p0ke"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 E4 53 56 33 C0 89 45 E4 89 45 E8 89 45 EC B8 C0 47 00 10 E8 4F F3 FF FF BE 5C 67 00 10 33 C0 55 68 D2 4A 00 10 64 FF 30 64 89 20 E8 EB DE FF FF E8 C6 F8 FF FF BA E0 4A 00 10 B8 CC 67 00 10 E8 5F F8 FF FF 8B D8 8B D6 8B C3 8B 0D CC 67 00 10 }
        $b = { 55 8B EC 83 C4 D8 53 56 57 33 C0 89 45 D8 89 45 DC 89 45 E0 89 45 E4 89 45 E8 B8 70 3A 40 00 E8 C4 EC FF FF 33 C0 55 68 5C 3F 40 00 64 FF 30 64 89 20 E8 C5 D7 FF FF E8 5C F5 FF FF B8 20 65 40 00 33 C9 BA 04 01 00 00 E8 D3 DB FF FF 68 04 01 00 00 68 20 65 40 00 6A 00 FF 15 10 55 40 00 BA 6C 3F 40 00 B8 14 55 40 00 E8 5A F4 FF FF 85 C0 0F 84 1B 04 00 00 BA 18 55 40 00 8B 0D 14 55 40 00 E8 16 D7 FF FF 8B 05 88 61 40 00 8B D0 B8 54 62 40 00 E8 D4 E3 FF FF B8 54 62 40 00 E8 F2 E2 FF FF 8B D0 B8 18 55 40 00 8B 0D 88 61 40 00 E8 E8 D6 FF FF FF 35 34 62 40 00 FF 35 30 62 40 00 FF 35 3C 62 40 00 FF 35 38 62 40 00 8D 55 E8 A1 88 61 40 00 E8 E3 F0 FF FF 8B 55 E8 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule CAN_Crunched_ANsi_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CAN_Crunched_ANsi_file"
        weight = 1
    strings:
        $a = { CA 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Stealth_v276_WebToolMaster: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Stealth_v276_WebToolMaster"
        weight = 1
    strings:
        $a = { EB 65 45 78 65 53 74 65 61 6C 74 68 20 56 32 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 20 59 4F 55 52 20 41 44 20 48 45 52 45 21 50 69 52 41 43 59 20 69 53 20 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Password_protector_my_SMT: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Password_protector_my_SMT"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? 5D 8B FD 81 ?? ?? ?? ?? ?? 81 ?? ?? ?? ?? ?? 83 ?? ?? 89 ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 46 80 ?? ?? 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimplePack_12build3009_Method2_bagie: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimplePack_12build3009_Method2_bagie"
        weight = 1
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 86 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AutoLogic_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AutoLogic_Graphics_format"
        weight = 1
    strings:
        $a = { FF 04 00 07 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule BopCrypt_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID BopCrypt_v10"
        weight = 1
    strings:
        $a = { 60 BD ?? ?? ?? ?? E8 ?? ?? 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HEALTH_v51_by_Muslim_MPolyak: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HEALTH_v51_by_Muslim_MPolyak"
        weight = 1
    strings:
        $a = { 1E E8 ?? ?? 2E 8C 06 ?? ?? 2E 89 3E ?? ?? 8B D7 B8 ?? ?? CD 21 8B D8 0E 1F E8 ?? ?? 06 57 A1 ?? ?? 26 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPXFreak_v01_Borland_Delphi_HMX0101: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPXFreak_v01_Borland_Delphi_HMX0101"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? 83 C6 01 FF E6 00 00 00 ?? ?? ?? 00 03 00 00 00 ?? ?? ?? ?? 00 10 00 00 00 00 ?? ?? ?? ?? 00 00 ?? F6 ?? 00 B2 4F 45 00 ?? F9 ?? 00 EF 4F 45 00 ?? F6 ?? 00 8C D1 42 00 ?? 56 ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? 24 ?? 00 ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Virogen_Crypt_v075: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Virogen_Crypt_v075"
        weight = 1
    strings:
        $a = { 9C 55 E8 EC 00 00 00 87 D5 5D 60 87 D5 80 BD 15 27 40 00 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_ASM: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Microsoft_Visual_Cpp_60_ASM"
        weight = 1
    strings:
        $a = { 03 05 00 1B B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_PROTECT_09: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_PROTECT_09"
        weight = 1
    strings:
        $a = { E9 CF 00 00 00 0D 0A 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 }
        $b = { 50 45 2D 50 52 4F 54 45 43 54 20 30 2E 39 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Enigma_Protector_10X_Sukhov_Vladimir: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Enigma_Protector_10X_Sukhov_Vladimir"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ?? ?? 81 ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 83 C4 04 EB 02 ?? ?? 60 E8 24 00 00 00 00 00 ?? EB 02 ?? ?? 8B 44 24 0C 83 80 B8 00 00 00 03 31 C0 C3 83 C0 08 EB 02 ?? ?? 89 C4 61 EB 2E ?? ?? ?? ?? ?? ?? ?? EB 01 ?? 31 C0 EB 01 ?? 64 FF 30 EB 01 ?? 64 89 20 EB 02 ?? ?? 89 00 9A 64 8F 05 00 00 00 00 EB 02 C1 ?? 58 61 EB 01 }
        $b = { 60 E8 00 00 00 00 5D 83 ?? ?? 81 ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 83 C4 04 EB 02 ?? ?? 60 E8 24 00 00 00 00 00 ?? EB 02 ?? ?? 8B 44 24 0C 83 80 B8 00 00 00 03 31 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule kkrunchy_V02X_Ryd: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID kkrunchy_V02X_Ryd"
        weight = 1
    strings:
        $a = { BD ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? FF 4D 08 C6 45 0C 05 8D 7D 14 31 C0 B4 04 89 C1 F3 AB BF ?? ?? ?? ?? 57 BE ?? ?? ?? ?? 31 C9 41 FF 4D 0C 8D 9C 8D A0 00 00 00 FF D6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_60_DLL_Debug: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_60_DLL_Debug"
        weight = 1
    strings:
        $a = { 8B 44 24 08 8B 4C 24 10 0B C8 8B 4C 24 0C 75 09 8B 44 24 04 F7 E1 C2 10 00 53 F7 E1 8B D8 8B 44 24 08 F7 64 24 14 03 D8 8B 44 24 08 F7 E1 03 D3 5B C2 10 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACProtect_v135_risco_software_Inc_Anticrack_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtect_v135_risco_software_Inc_Anticrack_Software"
        weight = 1
    strings:
        $a = { 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 53 45 52 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 90 4D 69 6E 65 49 6D 70 6F 72 74 5F 45 6E 64 73 73 }
        $b = { 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 53 45 52 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 47 65 74 50 72 6F 63 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule AHTeam_EP_Protector_03_fake_PEtite_22_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_PEtite_22_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 B8 00 00 00 00 68 00 00 00 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_ExeSmasher: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_ExeSmasher"
        weight = 1
    strings:
        $a = { 9C FE 03 90 60 BE 90 90 41 90 8D BE 90 10 FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FE 0B E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Simple_UPX_Cryptor_v3042005_multi_layer_encryption_MANtiCORE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Simple_UPX_Cryptor_v3042005_multi_layer_encryption_MANtiCORE"
        weight = 1
    strings:
        $a = { 60 B8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 8A 14 08 80 F2 ?? 88 14 08 41 83 F9 ?? 75 F1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_Watcom_CCpp_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Watcom_CCpp_DLL"
        weight = 1
    strings:
        $a = { 53 56 57 55 8B 74 24 14 8B 7C 24 18 8B 6C 24 1C 83 FF 03 0F 87 01 00 00 00 F1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CodeCrypt_v0164: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CodeCrypt_v0164"
        weight = 1
    strings:
        $a = { E9 2E 03 00 00 EB 02 83 3D 58 EB 02 FF 1D 5B EB 02 0F C7 5F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RPolyCryptor_V142_Vaska_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RPolyCryptor_V142_Vaska_SignByfly"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_VirusConstructorbased: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_VirusConstructorbased"
        weight = 1
    strings:
        $a = { BB ?? ?? B9 ?? ?? 2E ?? ?? ?? ?? 43 43 ?? ?? 8B EC CC 8B ?? ?? 81 ?? ?? ?? 06 1E B8 ?? ?? CD 21 3D ?? ?? ?? ?? 8C D8 48 8E D8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_Inliner_v10_by_GPcH: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_Inliner_v10_by_GPcH"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 B3 85 40 00 2D AC 85 40 00 2B E8 8D B5 D5 FE FF FF 8B 06 83 F8 00 74 11 8D B5 E1 FE FF FF 8B 06 83 F8 01 0F 84 F1 01 00 00 C7 06 01 00 00 00 8B D5 8B 85 B1 FE FF FF 2B D0 89 95 B1 FE FF FF 01 95 C9 FE FF FF 8D B5 E5 FE FF FF 01 16 8B 36 8B FD 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 05 FF FF FF 85 C0 0F 84 06 03 00 00 89 85 C5 FE FF FF E8 00 00 00 00 5B B9 31 89 40 00 81 E9 2E 86 40 00 03 D9 50 53 E8 3D 02 00 00 61 03 BD A9 FE FF FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 2D 01 13 8B 33 03 7B 04 57 51 52 53 FF B5 09 FF FF FF FF B5 05 FF FF FF 56 57 FF 95 C5 FE FF FF 5B 5A 59 5F 83 F9 00 74 05 83 C3 08 EB CE 68 00 80 00 00 6A 00 FF B5 C5 FE FF FF FF 95 09 FF FF FF 8D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_v13b_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_v13b_Vaska"
        weight = 1
    strings:
        $a = { 61 83 EF 4F 60 68 ?? ?? ?? ?? FF D7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V121_Dll_aPlib_043_ap0xnbsp_nbsp_SignByfly_20080504: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V121_Dll_aPlib_043_ap0xnbsp_nbsp_SignByfly_20080504"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 74 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 D6 05 00 00 EB 0C 8B 85 D2 05 00 00 89 85 D6 05 00 00 E8 4C 01 00 00 8D B5 FE 05 00 00 8D 9D 85 04 00 00 33 FF E8 77 01 00 00 EB 1B 8B 85 D6 05 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD E2 05 00 00 00 74 0E 83 BD E6 05 00 00 00 74 05 E8 15 02 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 6B 05 00 00 89 85 FA 05 00 00 5B FF B5 FA 05 00 00 56 FF D3 83 C4 08 8B B5 FA 05 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD D6 05 00 00 83 C0 04 89 85 F6 05 00 00 EB 6E 56 FF 95 63 05 00 00 0B C0 75 05 E8 08 03 00 00 85 C0 0F 84 95 00 00 00 89 85 F2 05 00 00 8B C6 EB 2A 8B 85 F6 05 00 00 8B 00 50 FF B5 F2 05 00 00 E8 50 02 00 00 85 C0 74 73 89 07 83 85 F6 05 00 00 04 83 C7 04 8B 85 F6 05 00 00 83 38 00 75 D1 EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD D6 05 00 00 83 C0 04 89 85 F6 05 00 00 80 3E 01 75 8D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF B5 FA 05 00 00 FF 95 6F 05 00 00 68 ?? ?? ?? ?? 6A 00 FF B5 FA 05 00 00 FF 95 6F 05 00 00 E8 A0 00 00 00 E8 9B 01 00 00 61 E9 ?? ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_12003518_WFS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_12003518_WFS"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 79 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Embedded_2422_2428_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_2422_2428_Jitit"
        weight = 1
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D 9B 1A 00 00 B9 84 1A 00 00 BA 14 1B 00 00 BE 00 10 00 00 BF B0 53 00 00 BD E0 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? 81 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Encapsulated_Postscript_graphics_file_v20_EPSF_12: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Encapsulated_Postscript_graphics_file_v20_EPSF_12"
        weight = 1
    strings:
        $a = { 25 21 50 53 2D 41 64 6F 62 65 2D 32 2E 30 20 45 50 53 46 2D 31 2E 32 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Inbuild_v10_hard: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Inbuild_v10_hard"
        weight = 1
    strings:
        $a = { B9 ?? ?? BB ?? ?? 2E ?? ?? 2E ?? ?? 43 E2 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule aPack_v098_m: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID aPack_v098_m"
        weight = 1
    strings:
        $a = { 1E 06 8C C8 8E D8 05 ?? ?? 8E C0 50 BE ?? ?? 33 FF FC B2 ?? BD ?? ?? 33 C9 50 A4 BB ?? ?? 3B F3 76 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CrypKey_v5_v6: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CrypKey_v5_v6"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? 58 83 E8 05 50 5F 57 8B F7 81 EF ?? ?? ?? ?? 83 C6 39 BA ?? ?? ?? ?? 8B DF B9 0B ?? ?? ?? 8B 06 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Windows_Help_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Windows_Help_file"
        weight = 1
    strings:
        $a = { 3F 5F 03 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_PENinja_131: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_PENinja_131"
        weight = 1
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_Packer_Northfox: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_Packer_Northfox"
        weight = 1
    strings:
        $a = { 54 59 68 61 7A 79 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Trivial173_by_SMTSMF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Trivial173_by_SMTSMF"
        weight = 1
    strings:
        $a = { EB ?? ?? 28 54 72 69 76 69 61 6C 31 37 33 20 62 79 20 53 4D 54 2F 53 4D 46 29 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v099: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v099"
        weight = 1
    strings:
        $a = { E9 ?? ?? FF FF 00 00 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? 02 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? 02 00 00 00 00 00 ?? ?? 02 00 00 00 00 00 ?? ?? 02 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? 00 00 00 00 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? 02 00 ?? ?? 02 00 ?? ?? 02 00 ?? ?? 02 00 77 ?? 02 00 ?? ?? 02 00 ?? ?? ?? 00 ?? ?? ?? 00 ?? ?? 00 00 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 00 00 ?? 00 00 ?? ?? 00 ?? ?? 00 00 ?? ?? ?? 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_Borland_Cpp_1999: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Borland_Cpp_1999"
        weight = 1
    strings:
        $a = { EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 90 90 90 90 A1 ?? ?? ?? ?? A3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PeStubOEP_v1x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PeStubOEP_v1x"
        weight = 1
    strings:
        $a = { 40 48 BE 00 ?? ?? 00 40 48 60 33 C0 B8 ?? ?? ?? 00 FF E0 C3 C3 }
        $b = { 90 33 C9 33 D2 B8 ?? ?? ?? 00 B9 FF }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule FSG_110_Eng_dulekxt_Borland_Delphi_Borland_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_110_Eng_dulekxt_Borland_Delphi_Borland_Cpp"
        weight = 1
    strings:
        $a = { 23 CA EB 02 5A 0D E8 02 00 00 00 6A 35 58 C1 C9 10 BE 80 ?? ?? 00 0F B6 C9 EB 02 CD 20 BB F4 00 00 00 EB 02 04 FA EB 01 FA EB 01 5F EB 02 CD 20 8A 16 EB 02 11 31 80 E9 31 EB 02 30 11 C1 E9 11 80 EA 04 EB 02 F0 EA 33 CB 81 EA AB AB 19 08 04 D5 03 C2 80 EA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v095: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v095"
        weight = 1
    strings:
        $a = { E9 D5 E4 FF FF 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v096: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v096"
        weight = 1
    strings:
        $a = { E9 59 E4 FF FF 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeJoiner_10_Yoda: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeJoiner_10_Yoda"
        weight = 1
    strings:
        $a = { 68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 00 C6 00 5C 68 04 01 00 00 68 04 11 40 00 6A 00 E8 1A 03 00 00 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 68 04 11 40 00 E8 EC 02 00 00 83 F8 FF 0F 84 83 02 00 00 A3 08 12 40 00 6A 00 50 E8 E2 02 00 00 83 F8 FF 0F 84 6D 02 00 00 A3 0C 12 40 00 8B D8 83 EB 04 6A 00 6A 00 53 FF 35 08 12 40 00 E8 E3 02 00 00 6A 00 68 3C 12 40 00 6A 04 68 1E 12 40 00 FF 35 08 12 40 00 E8 C4 02 00 00 83 EB 04 6A 00 6A 00 53 FF 35 08 12 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v166: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v166"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 87 DD 8B 85 E6 90 40 01 85 33 90 40 66 C7 85 90 40 90 90 01 85 DA 90 40 01 85 DE 90 40 01 85 E2 90 40 BB 8B 11 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v167: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v167"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 87 DD 8B 85 E6 90 40 01 85 33 90 40 66 C7 85 90 40 90 90 01 85 DA 90 40 01 85 DE 90 40 01 85 E2 90 40 BB 7B 11 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeBASIC_016b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeBASIC_016b"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 88 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 68 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 45 08 89 04 24 FF 15 ?? ?? ?? 00 89 EC 5D C3 8D 76 00 8D BC 27 00 00 00 00 55 89 E5 83 EC 08 8B 45 08 89 04 24 FF 15 ?? ?? ?? 00 89 EC 5D C3 90 90 90 90 90 90 90 90 90 90 }
        $b = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 88 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 68 FF FF FF 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 45 08 89 04 24 FF 15 ?? ?? ?? 00 89 EC 5D }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Private_EXE_Protector_18: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_EXE_Protector_18"
        weight = 1
    strings:
        $a = { BB DC EE 0D 76 D9 D0 8D 16 85 D8 90 D9 D0 }
        $b = { A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3 31 C9 41 E8 EE FF FF FF 11 C9 E8 E7 FF FF FF 72 F2 C3 31 FF 31 F6 C3 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Goats_Mutilator_v16_Goat_e0f: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Goats_Mutilator_v16_Goat_e0f"
        weight = 1
    strings:
        $a = { E8 E8 01 ?? ?? 60 01 AD B3 27 40 ?? 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nPack_111502006Beta_NEOx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nPack_111502006Beta_NEOx"
        weight = 1
    strings:
        $a = { 83 3D ?? ?? ?? ?? ?? 75 05 E9 01 00 00 00 C3 E8 41 00 00 00 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 5E 00 00 00 E8 E0 01 00 00 E8 EC 06 00 00 E8 F7 05 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? C3 C3 56 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 5F A3 ?? ?? ?? ?? 5E C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HideProtect_1016_SoftWar_Company: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HideProtect_1016_SoftWar_Company"
        weight = 1
    strings:
        $a = { 90 90 90 E9 D8 ?? 05 00 95 ?? 53 00 95 4A 50 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NE_Exe_Executable_Image: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NE_Exe_Executable_Image"
        weight = 1
    strings:
        $a = { 4E 45 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1354_Obsidium_Software_SignByfly_200800207: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1354_Obsidium_Software_SignByfly_200800207"
        weight = 1
    strings:
        $a = { EB 03 ?? ?? ?? E8 2D 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 25 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 02 ?? ?? 50 EB 01 ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 01 ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 03 ?? ?? ?? EB 02 ?? ?? 58 EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 5B 28 00 00 }
        $b = { EB 03 ?? ?? ?? E8 2D 00 00 00 EB 04 ?? ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 25 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 03 ?? ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 02 ?? ?? 50 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Nullsoft_Install_System_v20a0: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_Install_System_v20a0"
        weight = 1
    strings:
        $a = { 83 EC 0C 53 56 57 FF 15 B4 10 40 00 05 E8 03 00 00 BE E0 E3 41 00 89 44 24 10 B3 20 FF 15 28 10 40 00 68 00 04 00 00 FF 15 14 11 40 00 50 56 FF 15 10 11 40 00 80 3D E0 E3 41 00 22 75 08 80 C3 02 BE E1 E3 41 00 8A 06 8B 3D 14 12 40 00 84 C0 74 19 3A C3 74 0B 56 FF D7 8B F0 8A 06 84 C0 75 F1 80 3E 00 }
        $b = { 83 EC 0C 53 55 56 57 C7 44 24 10 70 92 40 00 33 DB C6 44 24 14 20 FF 15 2C 70 40 00 53 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 2D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00 68 68 92 40 00 56 FF D5 E8 6A FF FF FF 85 C0 0F 84 57 01 00 00 BE 20 E4 42 00 56 FF 15 68 70 40 00 68 5C 92 40 00 56 E8 9C 28 00 00 57 FF 15 BC 70 40 00 BE 00 40 43 00 50 56 FF 15 B8 70 40 00 6A 00 FF 15 44 71 40 00 80 3D 00 40 43 00 22 A3 20 EC 42 00 75 0A C6 44 24 14 22 BE 01 40 43 00 FF 74 24 14 56 E8 8A 23 00 00 50 FF 15 80 71 40 00 8B F8 89 7C 24 18 EB 61 80 F9 20 75 06 40 80 38 20 74 FA 80 38 22 C6 44 24 14 20 75 06 40 C6 44 24 14 22 80 38 2F 75 31 40 80 38 53 75 0E 8A 48 01 80 C9 20 80 F9 20 75 03 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule RLPack_V118_Dll_LZMA_430_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V118_Dll_LZMA_430_ap0x"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 5C 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 ?? 8D B5 1A 04 00 00 8D 9D C1 02 00 00 33 FF E8 61 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 ?? 83 C7 ?? 83 3C 37 00 75 EB 83 BD 06 04 00 00 00 74 0E 83 BD 0A 04 00 00 00 74 05 E8 D7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PureBasic_4x_Neil_Hodgson: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PureBasic_4x_Neil_Hodgson"
        weight = 1
    strings:
        $a = { 68 ?? ?? 00 00 68 00 00 00 00 68 ?? ?? ?? 00 E8 ?? ?? ?? 00 83 C4 0C 68 00 00 00 00 E8 ?? ?? ?? 00 A3 ?? ?? ?? 00 68 00 00 00 00 68 00 10 00 00 68 00 00 00 00 E8 ?? ?? ?? 00 A3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Alloy_v1x2000: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Alloy_v1x2000"
        weight = 1
    strings:
        $a = { 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 07 20 40 ?? 87 DD 6A 04 68 ?? 10 ?? ?? 68 ?? 02 ?? ?? 6A ?? FF 95 46 23 40 ?? 0B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ThemidaWinLicense_V18X_V19X_Other_Oreans_Technologies_SignByfly_20080131: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ThemidaWinLicense_V18X_V19X_Other_Oreans_Technologies_SignByfly_20080131"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D ?? ?? ?? ?? FF FF FF FF FF FF FF FF 3D ?? ?? ?? ?? 00 00 58 25 00 F0 FF FF 33 FF 66 BB ?? ?? 66 83 ?? ?? 66 39 18 75 12 0F B7 50 3C 03 D0 BB ?? ?? ?? ?? 83 C3 ?? 39 1A 74 07 2D ?? ?? ?? ?? EB DA 8B F8 B8 ?? ?? ?? ?? 03 C7 B9 ?? ?? ?? ?? 03 CF EB 0A B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 50 51 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_25xx_Jtit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_25xx_Jtit"
        weight = 1
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D ?? 1A 00 00 B9 ?? 1A 00 00 BA ?? 1B 00 00 BE 00 10 00 00 BF ?? 53 00 00 BD ?? 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? ?? 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 ?? ?? ?? ?? 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3B F1 7C 04 3B F2 7C 02 89 2E 83 C6 04 3B F7 7C E3 58 50 68 00 00 40 00 68 80 5A }
        $b = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D ?? 1A 00 00 B9 ?? 1A 00 00 BA ?? 1B 00 00 BE 00 10 00 00 BF ?? 53 00 00 BD ?? 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? ?? 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Microsoft_Visual_Basic_v50_v60: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Basic_v50_v60"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 00 00 ?? 00 00 00 30 ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V121_LZMA_430_ap0xnbsp_nbsp_SignByfly_20080504: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V121_LZMA_430_ap0xnbsp_nbsp_SignByfly_20080504"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 E0 0C 00 00 EB 0C 8B 85 DC 0C 00 00 89 85 E0 0C 00 00 E8 87 01 00 00 8D B5 08 0D 00 00 8D 9D C6 04 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 71 0C 00 00 89 85 D8 0C 00 00 E8 98 01 00 00 EB 20 60 8B 85 E0 0C 00 00 FF B5 D8 0C 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD EC 0C 00 00 00 74 0E 83 BD F0 0C 00 00 00 74 05 E8 31 02 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 71 0C 00 00 89 85 04 0D 00 00 5B 60 FF B5 D8 0C 00 00 56 FF B5 04 0D 00 00 FF D3 61 8B B5 04 0D 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD E0 0C 00 00 83 C0 04 89 85 00 0D 00 00 EB 72 56 FF 95 69 0C 00 00 0B C0 75 05 E8 25 03 00 00 85 C0 0F 84 AC 00 00 00 89 85 FC 0C 00 00 8B C6 EB 2E 8B 85 00 0D 00 00 8B 00 50 FF B5 FC 0C 00 00 E8 6D 02 00 00 85 C0 0F 84 86 00 00 00 89 07 83 85 00 0D 00 00 04 83 C7 04 8B 85 00 0D 00 00 83 38 00 75 CD EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD E0 0C 00 00 83 C0 04 89 85 00 0D 00 00 80 3E 01 75 89 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF B5 04 0D 00 00 FF 95 75 0C 00 00 68 ?? ?? ?? ?? 6A 00 FF B5 04 0D 00 00 FF 95 75 0C 00 00 68 ?? ?? ?? ?? 6A 00 FF B5 D8 0C 00 00 FF 95 75 0C 00 00 E8 A0 00 00 00 E8 9B 01 00 00 61 E9 ?? ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Safeguard_10_101_Simonzh: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Safeguard_10_101_Simonzh"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 EB 29 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CrunchPE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CrunchPE"
        weight = 1
    strings:
        $a = { 55 E8 ?? ?? ?? ?? 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 }
        $b = { EB 10 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 5D 81 ED 18 ?? ?? ?? 8B C5 55 60 9C 2B 85 E9 06 ?? ?? 89 85 E1 06 ?? ?? FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24 03 00 00 89 85 D9 41 00 00 68 EC 49 7B 79 33 C0 50 E8 11 03 00 00 89 85 D1 41 00 00 E8 67 05 00 00 E9 56 05 00 00 51 52 53 33 C9 49 8B D1 33 C0 33 DB AC 32 C1 8A CD 8A EA 8A D6 B6 08 66 D1 EB 66 D1 D8 73 09 66 35 20 83 66 81 F3 B8 ED FE CE 75 EB 33 C8 33 D3 4F 75 D5 F7 D2 F7 D1 5B 8B C2 C1 C0 10 66 8B C1 5A 59 C3 68 03 02 00 00 E8 80 04 00 00 0F 82 A8 02 00 00 96 8B 44 24 04 0F C8 8B D0 25 0F 0F 0F 0F 33 D0 C1 C0 08 0B C2 8B D0 25 33 33 33 33 33 D0 C1 C0 04 0B C2 8B D0 25 55 55 55 55 33 D0 C1 C0 02 0B C2 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Armadillo_4000053_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_4000053_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 20 8B 4B 00 68 80 E4 48 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4B 00 33 D2 8A D4 89 15 A4 A1 4B 00 8B C8 81 E1 FF 00 00 00 89 0D A0 A1 4B 00 C1 E1 08 03 CA 89 0D 9C A1 4B 00 C1 E8 10 A3 98 A1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_C_v104: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_C_v104"
        weight = 1
    strings:
        $a = { FA B8 ?? ?? 8E D8 8E D0 26 8B ?? ?? ?? 2B D8 F7 ?? ?? ?? 75 ?? B1 04 D3 E3 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_25x_Jeremy_Collake: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_25x_Jeremy_Collake"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_v03_Cyberbob: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_v03_Cyberbob"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 B7 CD 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 8B 95 CB 2C 40 00 8B 42 3C 03 C2 89 85 D5 2C 40 00 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 9D E9 2C 40 00 53 8F 85 B6 2B 40 00 BB ?? 00 00 00 B9 75 0A 00 00 8D BD 7E 2D 40 00 4F 30 1C 39 FE CB E2 F9 68 3C 01 00 00 59 8D BD B6 36 40 00 C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 1F 53 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B9 08 00 00 00 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D DC 2C 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeJoiner_Small_build_014015_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeJoiner_Small_build_014015_GlOFF"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 86 FF 68 00 01 00 00 68 F8 13 40 00 6A 00 E8 F3 01 00 00 8A C0 6A 00 68 80 00 00 00 6A 03 6A 00 6A 00 68 00 00 00 80 68 F8 13 40 00 E8 C9 01 00 00 A3 E0 13 40 00 40 0F 84 8B 01 00 00 90 90 90 90 90 6A 02 6A 00 6A FB FF 35 E0 13 40 00 E8 D1 01 00 00 86 FF 6A 00 8D 45 FC 50 6A 04 8D 45 F8 50 FF 35 E0 13 40 00 E8 B2 01 00 00 8A C0 6A 00 8D 45 FC 50 6A 01 8D 45 F3 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule JPEG_Graphics_format_p_description: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID JPEG_Graphics_format_p_description"
        weight = 1
    strings:
        $a = { FF D8 FF FE 00 27 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_KBDflags1024: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_KBDflags1024"
        weight = 1
    strings:
        $a = { 8B EC 2E 89 2E 24 03 BC 00 04 8C D5 2E 89 2E 22 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_ACProtect_109: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_ACProtect_109"
        weight = 1
    strings:
        $a = { 60 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 02 00 00 90 90 90 04 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Video_CD_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Video_CD_file"
        weight = 1
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 43 44 58 41 66 6D 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule InstallShield_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID InstallShield_Archive"
        weight = 1
    strings:
        $a = { 2A AB 79 D8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V037_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V037_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { 58 8D 54 83 58 FF 16 72 5C 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 6F FF ?? ?? ?? C1 E5 08 8D 6C 6D 00 8D AC AB 08 10 00 00 B0 01 E3 2A 8B D7 2B 53 08 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 54 95 00 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E3 B4 00 33 C9 B5 01 FF 56 50 33 C9 E9 03 01 00 00 B1 30 8B 6B 08 03 D1 FF 16 73 51 03 D1 FF 16 72 1B 03 D1 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 43 08 8A 00 E9 D5 00 00 00 83 C2 60 FF 16 87 6B 0C 73 0C 03 D1 FF 16 87 6B 10 73 03 87 6B 14 3C 07 B0 08 72 02 B0 0B 50 55 8D 93 78 07 00 00 FF 56 54 5D 91 E9 99 00 00 00 3C 07 B0 07 72 02 B0 0A 50 87 6B 0C 87 6B 10 89 6B 14 8D 93 C0 0B 00 00 FF 56 54 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D AC 83 78 03 00 00 FF 56 4C 3C 04 8B E8 72 5C 33 ED D1 E8 13 ED 48 45 91 45 D3 E5 80 F9 05 8D 94 AB 78 01 00 00 76 2B 80 E9 04 33 C0 8B 53 FC D1 2B 8B 12 0F CA 2B 53 04 03 C0 3B 13 72 06 8B 13 40 01 53 04 FF 56 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Goats_Mutilator_V16_Goat_e0f: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Goats_Mutilator_V16_Goat_e0f"
        weight = 1
    strings:
        $a = { E8 EA 0B 00 00 ?? ?? ?? 8B 1C 79 F6 63 D8 8D 22 B0 BF F6 49 08 C3 02 BD 3B 6C 29 46 13 28 5D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Predator2448: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Predator2448"
        weight = 1
    strings:
        $a = { 0E 1F BF ?? ?? B8 ?? ?? B9 ?? ?? 49 ?? ?? ?? ?? 2A C1 4F 4F ?? ?? F9 CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MZ0oPE_106b_TaskFall: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MZ0oPE_106b_TaskFall"
        weight = 1
    strings:
        $a = { EB CA 89 03 83 C3 04 87 FE 32 C0 AE 75 FD 87 FE 80 3E FF 75 E2 46 5B 83 C3 04 53 8B 1B 80 3F FF 75 C9 8B E5 61 68 ?? ?? ?? ?? C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPolyX_v05: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPolyX_v05"
        weight = 1
    strings:
        $a = { ?? 00 BD 46 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Sun_Raster_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Sun_Raster_Graphics_format"
        weight = 1
    strings:
        $a = { 59 A6 6A 95 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_Morphine_12: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Morphine_12"
        weight = 1
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 06 00 90 90 90 90 90 90 90 90 EB 08 E8 90 00 00 00 66 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 51 66 90 90 90 59 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Trilobytes_JPEG_graphics_Library: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Trilobytes_JPEG_graphics_Library"
        weight = 1
    strings:
        $a = { 84 10 FF FF FF FF 1E 00 01 10 08 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Packman_V0001_Bubbasoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Packman_V0001_Bubbasoft"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 58 83 E8 3D 50 8D B8 ?? ?? ?? FF 57 8D B0 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MicroJoiner_15_coban2k: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MicroJoiner_15_coban2k"
        weight = 1
    strings:
        $a = { BF 05 10 40 00 83 EC 30 8B EC E8 C8 FF FF FF E8 C3 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_emadicius"
        weight = 1
    strings:
        $a = { E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 81 83 C4 04 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 3D FF FF FF 00 EB 01 68 EB 02 CD 20 EB 01 E8 76 1B EB 01 68 EB 02 CD 20 EB 01 E8 CC 66 B8 FE 00 74 04 75 02 EB 02 EB 01 81 66 E7 64 74 04 75 02 EB 02 EB 01 81 E8 0A 00 00 00 E8 EB 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v42_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v42_DLL"
        weight = 1
    strings:
        $a = { 66 8B C0 8D 24 24 EB 01 EB 60 EB 01 EB 9C E8 00 00 00 00 5E 83 C6 50 8B FE 68 78 01 ?? ?? 59 EB 01 EB AC 54 E8 03 ?? ?? ?? 5C EB 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CRYPT_Version_17_c_Dismember: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CRYPT_Version_17_c_Dismember"
        weight = 1
    strings:
        $a = { 0E 17 9C 58 F6 ?? ?? 74 ?? E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_Install_System_20a0: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_Install_System_20a0"
        weight = 1
    strings:
        $a = { 83 EC 0C 53 55 56 57 C7 44 24 10 ?? ?? ?? ?? 33 DB C6 44 24 14 20 FF 15 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? 56 57 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 8D FF FF FF 8B 2D ?? ?? ?? ?? 85 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEiD_Bundle_v100_BoB_BobSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEiD_Bundle_v100_BoB_BobSoft"
        weight = 1
    strings:
        $a = { 60 E8 21 02 00 00 8B 44 24 04 52 48 66 31 C0 66 81 38 4D 5A 75 F5 8B 50 3C 81 3C 02 50 45 00 00 75 E9 5A C2 04 00 60 89 DD 89 C3 8B 45 3C 8B 54 28 78 01 EA 52 8B 52 20 01 EA 31 C9 41 8B 34 8A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXERefactor_V01_random: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXERefactor_V01_random"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 90 0B 00 00 53 56 57 E9 58 8C 01 00 55 53 43 41 54 49 4F 4E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v184: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v184"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 E8 C1 40 00 68 F4 86 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v180: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v180"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 E8 C1 00 00 68 F4 86 00 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v183: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v183"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 E0 C1 40 00 68 64 84 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v182: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v182"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 E0 C1 40 00 68 74 81 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v190b4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v190b4"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 08 E2 40 00 68 B4 96 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v190b2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v190b2"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 F0 C1 40 00 68 A4 89 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v190b3: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v190b3"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 08 E2 40 00 68 94 95 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v190b1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v190b1"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 E0 C1 40 00 68 04 89 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASDPack_20_asd: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASDPack_20_asd"
        weight = 1
    strings:
        $a = { 5B 43 83 7B 74 }
        $b = { 8B 44 24 04 56 57 53 E8 CD 01 00 00 C3 00 00 00 00 00 00 00 00 00 00 00 00 00 10 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule RLPack_Full_Edition_117_iBox_aPLib: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_Full_Edition_117_iBox_aPLib"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 79 29 00 00 8D 9D 2C 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v172_v173: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v172_v173"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 E8 C1 ?? ?? 68 F4 86 ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Crypter_13_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Crypter_13_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 6C 28 40 00 B9 5D 34 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unnamed_Scrambler_251Beta_2_252_p0ke: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unnamed_Scrambler_251Beta_2_252_p0ke"
        weight = 1
    strings:
        $a = { 55 8B EC B9 15 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 B8 ?? 3A ?? ?? E8 ?? EE FF FF 33 C0 55 68 ?? 43 ?? ?? 64 FF 30 64 89 20 BA ?? 43 ?? ?? B8 E4 64 ?? ?? E8 0F FD FF FF 8B D8 85 DB 75 07 6A 00 E8 ?? EE FF FF BA E8 64 ?? ?? 8B C3 8B 0D E4 64 ?? ?? E8 }
        $b = { 55 8B EC B9 ?? 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 B8 ?? ?? 40 00 E8 ?? EA FF FF 33 C0 55 68 ?? ?? 40 00 64 FF 30 64 89 20 BA ?? ?? 40 00 B8 ?? ?? 40 00 E8 63 F3 FF FF 8B D8 85 DB 75 07 6A 00 E8 ?? ?? FF FF BA ?? ?? 40 00 8B C3 8B 0D ?? ?? 40 00 E8 ?? ?? FF FF C7 05 ?? ?? 40 00 0A 00 00 00 BB ?? ?? 40 00 BE ?? ?? 40 00 BF ?? ?? 40 00 B8 ?? ?? 40 00 BA 04 00 00 00 E8 ?? EB FF FF 83 3B 00 74 04 33 C0 89 03 8B D7 8B C6 E8 0A F3 FF FF 89 03 83 3B 00 0F 84 F7 04 00 00 B8 ?? ?? 40 00 8B 16 E8 ?? E1 FF FF B8 ?? ?? 40 00 E8 ?? E0 FF FF 8B D0 8B 03 8B 0E E8 ?? ?? FF FF 8B C7 A3 ?? ?? 40 00 8D 55 EC 33 C0 E8 ?? D3 FF FF 8B 45 EC B9 ?? ?? 40 00 BA ?? ?? 40 00 E8 8B ED FF FF 3C 01 75 2B A1 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule HACKSTOP_v100: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HACKSTOP_v100"
        weight = 1
    strings:
        $a = { FA BD ?? ?? FF E5 6A 49 48 0C ?? E4 ?? 3F 98 3F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WARNING_TROJAN_HuiGeZi: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WARNING_TROJAN_HuiGeZi"
        weight = 1
    strings:
        $a = { 55 8B EC 81 C4 ?? FE FF FF 53 56 57 33 C0 89 85 ?? FE FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CodeSafe_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CodeSafe_v20"
        weight = 1
    strings:
        $a = { 9C FE 03 ?? 60 BE ?? ?? 41 ?? 8D BE ?? 10 FF FF 57 83 CD FF EB 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UCEXE_v23_v24: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UCEXE_v23_v24"
        weight = 1
    strings:
        $a = { 50 1E 0E 1F FC 33 F6 E8 ?? ?? 16 07 33 F6 33 FF B9 ?? ?? F3 A5 06 B8 ?? ?? 50 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1333_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1333_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 28 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 58 EB 01 ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 2B 27 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V01X_V02X_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V01X_V02X_Dwing"
        weight = 1
    strings:
        $a = { 1E B8 CD 7B CD 21 81 FB CD 7B 75 03 E9 87 00 33 DB 0E 1F 8C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_VOB_ProtectCD_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_VOB_ProtectCD_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 5F 81 EF 00 00 00 00 BE 00 00 40 00 8B 87 00 00 00 00 03 C6 57 56 8C A7 00 00 00 00 FF 10 89 87 00 00 00 00 5E 5F }
        $b = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 5F 81 EF 00 00 00 00 BE 00 00 40 00 8B 87 00 00 00 00 03 C6 57 56 8C A7 00 00 00 00 FF 10 89 87 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Gleam_100: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Gleam_100"
        weight = 1
    strings:
        $a = { 83 EC 0C 53 56 57 E8 24 02 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DxPack_V086_Dxd: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DxPack_V086_Dxd"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 8B FD 81 ED 06 10 40 00 2B BD 94 12 40 00 81 EF 06 00 00 00 83 BD 14 13 40 00 01 0F 84 2F 01 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Creative_Audio_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Creative_Audio_file"
        weight = 1
    strings:
        $a = { 43 72 65 61 74 69 76 65 20 56 6F 69 63 65 20 46 69 6C 65 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LamCrypt_v10_LaZaRuS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LamCrypt_v10_LaZaRuS"
        weight = 1
    strings:
        $a = { 60 66 9C BB 00 ?? ?? 00 80 B3 00 10 40 00 90 4B 83 FB FF 75 F3 66 9D 61 B8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_Microsoft_Visual_Cpp_70_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Microsoft_Visual_Cpp_70_DLL"
        weight = 1
    strings:
        $a = { 55 8D 6C 01 00 81 EC 00 00 00 00 8B 45 90 83 F8 01 56 0F 84 00 00 00 00 85 C0 0F 84 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MIDI_Music_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MIDI_Music_file"
        weight = 1
    strings:
        $a = { 4D 54 68 64 00 00 00 06 ?? ?? ?? ?? ?? ?? 4D 54 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule USSR_031_by_Spirit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID USSR_031_by_Spirit"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 5D 83 C5 12 55 C3 20 83 B8 ED 20 37 EF C6 B9 79 37 9E 8C C9 30 C9 E3 01 C3 BE 32 ?? ?? ?? B0 ?? 30 06 8A 06 46 81 FE 00 ?? ?? ?? 7C F3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Crypt_15_BitShape_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Crypt_15_BitShape_Software"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 55 20 40 00 B9 7B 09 00 00 8D BD 9D 20 40 00 8B F7 AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Soft_Defender_11x_Randy_Li: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Soft_Defender_11x_Randy_Li"
        weight = 1
    strings:
        $a = { 74 07 75 05 19 32 67 E8 E8 74 1F 75 1D E8 68 39 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SA2_Adlib_Module_music_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SA2_Adlib_Module_music_file"
        weight = 1
    strings:
        $a = { 53 41 64 54 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RAR_SFX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RAR_SFX"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 00 00 00 00 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_30X_Thinstall_Company: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Virtualization_Suite_30X_Thinstall_Company"
        weight = 1
    strings:
        $a = { 9C 60 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 00 00 00 00 58 BB ?? ?? ?? ?? 2B C3 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 BA FE FF FF E9 ?? ?? ?? ?? CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESHiELD_v02_v02b_v02b2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESHiELD_v02_v02b_v02b2"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 41 4E 41 4B 49 4E 5D 83 ED 06 EB 02 EA 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule from_NORMAN_Anti_Virus_Utilites: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID from_NORMAN_Anti_Virus_Utilites"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5B 52 45 2F 4E 44 44 53 5D 0D 0A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V132_cyberbobnbsp_nbsp_SignByfly_20080310: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V132_cyberbobnbsp_nbsp_SignByfly_20080310"
        weight = 1
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 17 E6 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 ?? EB 01 ?? EB 0D FF E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 EB 04 ?? EB 04 00 EB FB FF E8 02 00 00 00 ?? ?? 5A 81 ?? ?? ?? ?? ?? 83 EA FE 89 95 A9 57 40 00 2B C0 2B C9 83 F1 06 09 85 CB 57 40 00 9C D3 2C 24 80 C1 FB 21 0C 24 50 52 B8 36 C7 09 FF 05 FE 37 F6 00 F7 64 24 08 8D 84 28 B1 35 40 00 89 44 24 08 5A 58 8D 64 24 04 FF 64 24 FC CD 20 BB 69 74 58 0B C1 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Basic_50: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Basic_50"
        weight = 1
    strings:
        $a = { FF FF FF 00 00 00 00 00 00 30 00 00 00 40 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Packman_0001: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Packman_0001"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 58 8D A8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule D1S1G_v11_Beta_pp_Scrambled_EXE_D1N: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID D1S1G_v11_Beta_pp_Scrambled_EXE_D1N"
        weight = 1
    strings:
        $a = { E8 07 00 00 00 E8 1E 00 00 00 C3 90 58 89 C2 89 C2 25 00 F0 FF FF 50 83 C0 55 8D 00 FF 30 8D 40 04 FF 30 52 C3 8D 40 00 55 8B EC 83 C4 E8 53 56 57 8B 4D 10 8B 45 08 89 45 F8 8B 45 0C 89 45 F4 8D 41 61 8B 38 8D 41 65 8B 00 03 C7 89 45 FC 8D 41 69 8B 00 03 C7 8D 51 6D 8B 12 03 D7 83 C1 71 8B 09 03 CF 2B CA 72 0A 41 87 D1 80 31 FF 41 4A 75 F9 89 45 F0 EB 71 8B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_Full_Edition_117_LZMA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_Full_Edition_117_LZMA"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 73 26 00 00 8D 9D 58 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 40 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule The_Best_Cryptor_FsK_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID The_Best_Cryptor_FsK_SignByfly"
        weight = 1
    strings:
        $a = { EB 06 56 52 55 4C 5A 00 90 90 90 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_70_Custom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_70_Custom"
        weight = 1
    strings:
        $a = { 60 BE 00 B0 44 00 8D BE 00 60 FB FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pohernah_Crypter_V101_Kas: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pohernah_Crypter_V101_Kas"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED F1 26 40 00 8B BD 18 28 40 00 8B 8D 20 28 40 00 B8 38 28 40 00 01 E8 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 1C 28 40 00 31 C0 51 31 C9 66 B9 FA 00 66 83 F9 00 74 49 8B 57 0C 03 95 1C 28 40 00 8B 85 24 28 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 89 CE E8 27 00 00 00 89 C1 5F B8 38 28 40 00 01 E8 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 14 28 40 00 89 44 24 1C 61 FF E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXEPACK_v405_v406: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXEPACK_v405_v406"
        weight = 1
    strings:
        $a = { 8C C0 05 ?? ?? 0E 1F A3 ?? ?? 03 06 ?? ?? 8E C0 8B 0E ?? ?? 8B F9 4F 8B F7 FD F3 A4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_V10b_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_V10b_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 4C 32 40 00 E8 03 00 00 00 EB 01 ?? B9 EA 47 40 00 81 E9 E9 32 40 00 8B D5 81 C2 E9 32 40 00 8D 3A 8B F7 33 C0 E8 04 00 00 00 90 EB 01 ?? E8 03 00 00 00 EB 01 ?? AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule JAR_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID JAR_Archive"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1A 4A 61 72 1B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FishPE_V10X_hellfish: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FishPE_V10X_hellfish"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? C3 90 09 00 00 00 2C 00 00 00 ?? ?? ?? ?? C4 03 00 00 BC A0 00 00 00 40 01 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 99 00 00 00 00 8A 00 00 00 10 00 00 ?? ?? 00 00 ?? ?? ?? ?? 00 00 02 00 00 00 A0 00 00 18 01 00 00 ?? ?? ?? ?? 00 00 0C 00 00 00 B0 00 00 38 0A 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 C0 00 00 40 39 00 00 ?? ?? ?? ?? 00 00 08 00 00 00 00 01 00 C8 06 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Encrypt_10_Liwuyue: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Encrypt_10_Liwuyue"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D 0F 05 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89 5D EC 8B 41 18 8B C8 49 85 C9 72 5A 41 33 C0 8B D8 C1 E3 02 03 DA 8B 3B 03 3E 81 3F 47 65 74 50 75 40 8B DF 83 C3 04 81 3B 72 6F 63 41 75 33 8B DF 83 C3 08 81 3B 64 64 72 65 75 26 83 C7 0C 66 81 3F 73 73 }
        $b = { 55 8B EC 83 C4 D0 53 56 57 8D 75 FC 8B 44 24 30 25 00 00 FF FF 81 38 4D 5A 90 00 74 07 2D 00 10 00 00 EB F1 89 45 FC E8 C8 FF FF FF 2D 0F 05 00 00 89 45 F4 8B 06 8B 40 3C 03 06 8B 40 78 03 06 8B C8 8B 51 20 03 16 8B 59 24 03 1E 89 5D F0 8B 59 1C 03 1E 89 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ARVIDs_TDR_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ARVIDs_TDR_file"
        weight = 1
    strings:
        $a = { 74 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MinGW_v32x_main: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MinGW_v32x_main"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 E4 40 40 00 E8 68 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 E4 40 40 00 E8 48 00 00 00 89 EC 31 C0 5D C3 89 F6 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 00 41 40 00 89 EC 5D C3 8D 76 00 8D BC 27 00 00 00 00 55 89 E5 83 EC 08 8B 55 08 89 14 24 FF 15 F4 40 40 00 89 EC 5D C3 8D 76 00 8D BC 27 00 00 00 00 55 89 E5 53 83 EC 24 C7 04 24 A0 11 40 00 E8 8D 07 00 00 83 EC 04 E8 85 02 00 00 C7 04 24 00 20 40 00 8B 15 10 20 40 00 8D 4D F8 C7 45 F8 00 00 00 00 89 4C 24 10 89 54 24 0C 8D 55 F4 89 54 24 08 C7 44 24 04 04 20 40 00 E8 02 07 00 00 A1 20 20 40 00 85 C0 74 76 A3 30 20 40 00 A1 F0 40 40 00 85 C0 74 1F 89 04 24 E8 C3 06 00 00 8B 1D 20 20 40 00 89 04 24 89 5C 24 04 E8 C1 06 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ARJ_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ARJ_Archive"
        weight = 1
    strings:
        $a = { 60 EA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V036_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V036_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { 58 8D 54 83 58 FF 16 72 5C 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 6F FF ?? ?? ?? C1 E5 08 8D 6C 6D 00 8D AC AB 08 10 00 00 B0 01 E3 2A 8B D7 2B 53 08 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 54 95 00 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E3 B4 00 33 C9 B5 01 FF 56 18 33 C9 E9 03 01 00 00 B1 30 8B 6B 08 03 D1 FF 16 73 51 03 D1 FF 16 72 1B 03 D1 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 43 08 8A 00 E9 D5 00 00 00 83 C2 60 FF 16 87 6B 0C 73 0C 03 D1 FF 16 87 6B 10 73 03 87 6B 14 3C 07 B0 08 72 02 B0 0B 50 55 8D 93 78 07 00 00 FF 56 1C 5D 91 E9 99 00 00 00 3C 07 B0 07 72 02 B0 0A 50 87 6B 0C 87 6B 10 89 6B 14 8D 93 C0 0B 00 00 FF 56 1C 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D AC 83 78 03 00 00 FF 56 14 3C 04 8B E8 72 5C 33 ED D1 E8 13 ED 48 45 91 45 D3 E5 80 F9 05 8D 94 AB 78 01 00 00 76 2B 80 E9 04 33 C0 8B 53 FC D1 2B 8B 12 0F CA 2B 53 04 03 C0 3B 13 72 06 8B 13 40 01 53 04 FF 56 3C E2 E3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v160a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v160a"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 98 71 40 00 68 48 2D 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimplePack_V121build0909_Method2_bagie: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimplePack_V121build0909_Method2_bagie"
        weight = 1
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 86 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1352_Obsidium_Software_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1352_Obsidium_Software_SignByfly"
        weight = 1
    strings:
        $a = { EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 25 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 01 ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 64 67 8F 06 00 00 EB 03 ?? ?? ?? 83 C4 04 EB 03 ?? ?? ?? E8 }
        $b = { EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 25 EB 03 ?? ?? ?? 33 C0 EB 04 ?? ?? ?? ?? C3 EB 04 ?? ?? ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 50 EB 04 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule VBOX_v43_v46: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VBOX_v43_v46"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? 90 03 C4 33 C4 33 C5 2B C5 33 C5 8B C5 ?? ?? 2B C5 48 ?? ?? 0B C0 86 E0 8C E0 ?? ?? 8C E0 86 E0 03 C4 40 }
        $b = { 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 8B C4 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule QuickLink_II_Fax_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID QuickLink_II_Fax_Graphics_format"
        weight = 1
    strings:
        $a = { 51 4C 49 49 46 41 58 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Patch_Creation_Wizard_v12_Memory_Patch: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Patch_Creation_Wizard_v12_Memory_Patch"
        weight = 1
    strings:
        $a = { 6A 00 E8 9B 02 00 00 A3 7A 33 40 00 6A 00 68 8E 10 40 00 6A 00 6A 01 50 E8 B5 02 00 00 68 5A 31 40 00 68 12 31 40 00 6A 00 6A 00 6A 04 6A 01 6A 00 6A 00 68 A2 30 40 00 6A 00 E8 51 02 00 00 85 C0 74 31 FF 35 62 31 40 00 6A 00 6A 30 E8 62 02 00 00 E8 0B 01 00 00 FF 35 5A 31 40 00 E8 22 02 00 00 FF 35 5E 31 40 00 E8 53 02 00 00 6A 00 E8 22 02 00 00 6A 10 68 F7 30 40 00 68 FE 30 40 00 6A 00 E8 63 02 00 00 6A 00 E8 08 02 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 75 6B 6A 01 FF 35 7A 33 40 00 E8 38 02 00 00 50 6A 01 68 80 00 00 00 FF 75 08 E8 34 02 00 00 68 00 30 40 00 6A 65 FF 75 08 E8 2B 02 00 00 68 51 30 40 00 6A 67 FF 75 08 E8 1C 02 00 00 68 A2 30 40 00 6A 66 FF 75 08 E8 0D 02 00 00 8B 45 08 A3 7E 33 40 00 68 3B 11 40 00 68 E8 03 00 00 68 9A 02 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_PE_Lock_NT_204_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_PE_Lock_NT_204_emadicius"
        weight = 1
    strings:
        $a = { EB 03 CD 20 C7 1E EB 03 CD 20 EA 9C EB 02 EB 01 EB 01 EB 60 EB 03 CD 20 EB EB 01 EB E8 03 00 00 00 E9 EB 04 58 40 50 C3 EB 03 CD 20 EB EB 03 CD 20 03 61 9D 83 C4 04 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_CD_Cops_II: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_CD_Cops_II"
        weight = 1
    strings:
        $a = { 53 60 BD 90 90 90 90 8D 45 90 8D 5D 90 E8 00 00 00 00 8D 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Banners_banner_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Banners_banner_file"
        weight = 1
    strings:
        $a = { D1 BA 01 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_Run_Time_Library_OS2_FORTRAN_Compiler_1989: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Run_Time_Library_OS2_FORTRAN_Compiler_1989"
        weight = 1
    strings:
        $a = { B4 30 CD 21 86 E0 2E A3 ?? ?? 3D ?? ?? 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_3035_3043_Thinstall_Company: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Virtualization_Suite_3035_3043_Thinstall_Company"
        weight = 1
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 28 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PKLITE_v114_v120: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PKLITE_v114_v120"
        weight = 1
    strings:
        $a = { B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 06 ?? ?? 72 ?? B4 09 BA ?? ?? CD 21 CD 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Safe_20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Safe_20"
        weight = 1
    strings:
        $a = { 83 EC 10 53 56 57 E8 C4 01 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESHiELD_v025: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESHiELD_v025"
        weight = 1
    strings:
        $a = { 60 E8 2B 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Excalibur_V103_forgot: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Excalibur_V103_forgot"
        weight = 1
    strings:
        $a = { E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 EB 39 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_PE_Protect_09: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_PE_Protect_09"
        weight = 1
    strings:
        $a = { 52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 07 00 00 00 58 83 C0 07 C6 90 C3 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pelles_C_300_400_450_EXE_X86_CRT_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pelles_C_300_400_450_EXE_X86_CRT_DLL"
        weight = 1
    strings:
        $a = { 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 53 56 57 89 65 E8 C7 45 FC ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 BE ?? ?? ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_2736_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_2736_Jitit"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 58 BB F3 1C 00 00 2B C3 50 68 00 00 40 00 68 00 26 00 00 68 CC 00 00 00 E8 C1 FE FF FF E9 97 FF FF FF CC CC CC CC CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3 A4 5E E9 F0 FE FF FF 33 C0 EB 05 8B C7 2B 45 0C 5E 5F 5B C9 C2 08 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Wind_of_Crypt_10_by_DarkPressure: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Wind_of_Crypt_10_by_DarkPressure"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 EC 53 ?? ?? ?? ?? 89 45 EC B8 64 40 00 10 E8 28 EA FF FF 33 C0 55 68 CE 51 00 10 64 ?? ?? ?? ?? 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 33 C0 E8 F6 DB FF FF 8B 45 EC E8 12 E7 FF FF 50 E8 3C EA FF FF 8B D8 83 FB FF 0F 84 A6 00 00 00 6A 00 53 E8 41 EA FF FF 8B F0 81 EE 00 5E 00 00 6A 00 6A 00 68 00 5E 00 00 53 E8 52 EA FF FF B8 F4 97 00 10 8B D6 E8 2E E7 FF FF B8 F8 97 00 10 8B D6 E8 22 E7 FF FF 8B C6 E8 AB D8 FF FF 8B F8 6A 00 68 F0 97 00 10 56 A1 F4 97 00 10 50 53 E8 05 EA FF FF 53 E8 CF E9 FF FF B8 FC 97 00 10 BA E8 51 00 10 E8 74 EA FF FF A1 F4 97 00 10 85 C0 74 05 83 E8 04 8B 00 50 B9 F8 97 00 10 B8 FC 97 00 10 8B 15 F4 97 00 10 E8 D8 EA FF FF B8 FC 97 00 10 E8 5A EB FF FF 8B CE 8B 15 F8 97 00 10 8B C7 E8 EB E9 FF FF 8B C7 85 C0 74 05 E8 E4 EB FF FF 33 C0 5A 59 59 64 89 10 68 D5 51 00 10 8D 45 EC E8 BB E5 FF FF C3 E9 A9 DF FF FF EB F0 5F 5E 5B E8 B7 E4 FF FF 00 00 00 FF FF FF FF 0A 00 00 00 63 5A 6C 56 30 55 6C 6B 70 4D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CC_v261_Beta: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CC_v261_Beta"
        weight = 1
    strings:
        $a = { BA ?? ?? B4 30 CD 21 3C 02 73 ?? 33 C0 06 50 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v42: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v42"
        weight = 1
    strings:
        $a = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 89 25 00 00 00 00 83 EC ?? 53 56 57 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_Borland_Delphi_60_70_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_Borland_Delphi_60_70_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 53 8B D8 33 C0 A3 00 00 00 00 6A 00 E8 00 00 00 FF A3 00 00 00 00 A1 00 00 00 00 A3 00 00 00 00 33 C0 A3 00 00 00 00 33 C0 A3 00 00 00 00 E8 }
        $b = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 53 8B D8 33 C0 A3 00 00 00 00 6A 00 E8 00 00 00 FF A3 00 00 00 00 A1 00 00 00 00 A3 00 00 00 00 33 C0 A3 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Fish_PE_Shield_112116_HellFish: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Fish_PE_Shield_112116_HellFish"
        weight = 1
    strings:
        $a = { 60 E8 EA FD FF FF FF D0 C3 8D 40 00 ?? 00 00 00 2C 00 00 00 }
        $b = { 55 8B EC 83 C4 D0 53 56 57 8B 45 10 83 C0 0C 8B 00 89 45 DC }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ASDPack_v10_asd: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASDPack_v10_asd"
        weight = 1
    strings:
        $a = { 55 8B EC 56 53 E8 5C 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 10 00 00 ?? ?? ?? 00 00 00 00 00 00 00 40 00 00 ?? ?? 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 ?? ?? 00 00 10 00 00 00 ?? 00 00 00 ?? ?? 00 00 ?? ?? 00 00 ?? ?? 00 00 ?? 00 00 00 ?? ?? 00 00 ?? 00 00 00 ?? ?? 00 00 ?? 00 00 00 ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 5B 81 EB E6 1D 40 00 83 7D 0C 01 75 11 55 E8 4F 01 00 00 E8 6A 01 00 00 5D E8 2C 00 00 00 8B B3 1A 1E 40 00 03 B3 FA 1D 40 00 8B 76 0C AD 0B C0 74 0D FF 75 10 FF 75 0C FF 75 08 FF D0 EB EE B8 01 00 00 00 5B 5E C9 C2 0C 00 55 6A 00 FF 93 20 21 40 00 89 83 FA 1D 40 00 6A 40 68 00 10 00 00 FF B3 02 1E 40 00 6A 00 FF 93 2C 21 40 00 89 83 06 1E 40 00 8B 83 F2 1D 40 00 03 83 FA 1D 40 00 50 FF B3 06 1E 40 00 50 E8 6D 01 00 00 5F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FucknJoy_v10c_UsAr: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FucknJoy_v10c_UsAr"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED D8 05 40 00 FF 74 24 20 E8 8C 02 00 00 0B C0 0F 84 2C 01 00 00 89 85 6C 08 40 00 8D 85 2F 08 40 00 50 FF B5 6C 08 40 00 E8 EF 02 00 00 0B C0 0F 84 0C 01 00 00 89 85 3B 08 40 00 8D 85 3F 08 40 00 50 FF B5 6C 08 40 00 E8 CF 02 00 00 0B C0 0F 84 EC 00 00 00 89 85 4D 08 40 00 8D 85 51 08 40 00 50 FF B5 6C 08 40 00 E8 AF 02 00 00 0B C0 0F 84 CC 00 00 00 89 85 5C 08 40 00 8D 85 67 07 40 00 E8 7B 02 00 00 8D B5 C4 07 40 00 56 6A 64 FF 95 74 07 40 00 46 80 3E 00 75 FA C7 06 74 6D 70 2E 83 C6 04 C7 06 65 78 65 00 8D 85 36 07 40 00 E8 4C 02 00 00 33 DB 53 53 6A 02 53 53 68 00 00 00 40 8D 85 C4 07 40 00 50 FF 95 74 07 40 00 89 85 78 07 40 00 8D 85 51 07 40 00 E8 21 02 00 00 6A 00 8D 85 7C 07 40 00 50 68 00 ?? ?? 00 8D 85 F2 09 40 00 50 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_V22004616_V22006630_WFS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_V22004616_V22006630_WFS"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 73 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 54 65 6D 70 50 61 74 68 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v072: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v072"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 83 ?? ?? 31 DB 5E 8D ?? ?? ?? ?? ?? 57 66 ?? ?? ?? ?? ?? ?? ?? ?? 81 ?? ?? ?? ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v070: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v070"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 58 83 ?? ?? 50 8D ?? ?? ?? ?? ?? 57 66 ?? ?? ?? ?? ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 83 ?? ?? 31 DB EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1357_Obsidium_Softwarenbsp_nbsp_SignByfly_20080521: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1357_Obsidium_Softwarenbsp_nbsp_SignByfly_20080521"
        weight = 1
    strings:
        $a = { EB 01 ?? E8 ?? 00 00 00 EB 03 ?? ?? ?? EB 01 ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 24 EB 03 ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 01 ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 02 ?? ?? 50 EB 03 ?? ?? ?? 33 C0 EB 01 ?? 8B 00 EB 03 ?? ?? ?? C3 EB 01 ?? E9 ?? ?? ?? ?? EB 03 ?? ?? ?? E8 ?? ?? ?? ?? EB 03 ?? ?? ?? EB 03 ?? ?? ?? 58 EB 01 ?? EB 02 ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 01 ?? E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_V16d_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_V16d_Vaska"
        weight = 1
    strings:
        $a = { 60 90 61 61 80 7F F0 45 90 60 0F 85 1B 8B 1F FF 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? 90 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 B8 ?? ?? ?? ?? 90 3D ?? ?? ?? ?? 74 06 80 30 ?? 40 EB F3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_August_16th_Iron_Maiden: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_August_16th_Iron_Maiden"
        weight = 1
    strings:
        $a = { BA 79 02 03 D7 B4 1A CD 21 B8 24 35 CD 21 5F 57 89 9D 4E 02 8C 85 50 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule diProtector_1x_diProtector_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID diProtector_1x_diProtector_Software"
        weight = 1
    strings:
        $a = { 01 00 A0 E3 14 00 00 EB 00 00 20 E0 44 10 9F E5 03 2A A0 E3 40 30 A0 E3 AE 00 00 EB 30 00 8F E5 00 20 A0 E1 3A 0E 8F E2 00 00 80 E2 1C 10 9F E5 20 30 8F E2 0E 00 00 EB 14 00 9F E5 14 10 9F E5 7F 20 A0 E3 C5 00 00 EB 04 C0 8F E2 00 F0 9C E5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE2COM_regular: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE2COM_regular"
        weight = 1
    strings:
        $a = { E9 8C CA 81 C3 ?? ?? 3B 16 ?? ?? 76 ?? BA ?? ?? B4 09 CD 21 CD 20 0D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_PE_Pack_099: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_PE_Pack_099"
        weight = 1
    strings:
        $a = { 60 E8 11 00 00 00 5D 83 ED 06 80 BD E0 04 90 90 01 0F 84 F2 FF CC 0A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CDS_SS_v10_Beta_1_CyberDoom_Team_X: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CDS_SS_v10_Beta_1_CyberDoom_Team_X"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED CA 47 40 00 FF 74 24 20 E8 D3 03 00 00 0B C0 0F 84 13 03 00 00 89 85 B8 4E 40 00 66 8C D8 A8 04 74 0C C7 85 8C 4E 40 00 01 00 00 00 EB 12 64 A1 30 00 00 00 0F B6 40 02 0A C0 0F 85 E8 02 00 00 8D 85 F6 4C 40 00 50 FF B5 B8 4E 40 00 E8 FC 03 00 00 0B C0 0F 84 CE 02 00 00 E8 1E 03 00 00 89 85 90 4E 40 00 8D 85 03 4D 40 00 50 FF B5 B8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_Neolite_20_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_Neolite_20_emadicius"
        weight = 1
    strings:
        $a = { E9 A6 00 00 00 B0 7B 40 00 78 60 40 00 7C 60 40 00 00 00 00 00 B0 3F 00 00 12 62 40 00 4E 65 6F 4C 69 74 65 20 45 78 65 63 75 74 61 62 6C 65 20 46 69 6C 65 20 43 6F 6D 70 72 65 73 73 6F 72 0D 0A 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 39 38 2C 31 39 39 39 20 4E 65 6F 57 6F 72 78 20 49 6E 63 0D 0A 50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 39 37 2D 31 39 39 39 20 4C 65 65 20 48 61 73 69 75 6B 0D 0A 41 6C 6C 20 52 69 67 68 74 73 20 52 65 73 65 72 76 65 64 2E 00 00 00 00 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule XCF_File_Format_by_Adeline_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID XCF_File_Format_by_Adeline_Software"
        weight = 1
    strings:
        $a = { 46 72 61 6D 65 4C 65 6E F4 0F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressor_v120b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_v120b"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC D4 01 00 00 53 56 57 EB 0C 45 78 50 72 2D 76 2E 31 2E 32 2E 2E B8 ?? ?? ?? 00 2B 05 84 ?? ?? 00 A3 ?? ?? ?? 00 83 3D ?? ?? ?? 00 00 74 16 A1 ?? ?? ?? 00 03 05 80 ?? ?? 00 89 85 54 FE FF FF E9 ?? 07 00 00 C7 05 ?? ?? ?? 00 01 00 00 00 68 04 01 00 00 8D 85 F0 FE FF FF 50 6A 00 FF 15 ?? ?? ?? 00 8D 84 05 EF FE FF FF 89 85 38 FE FF FF 8B 85 38 FE FF FF 0F BE 00 83 F8 5C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule E_: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID E_"
        weight = 1
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D A7 1A 00 00 B9 6C 1A 00 00 BA 20 1B 00 00 BE 00 10 00 00 BF B0 53 00 00 BD EC 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? 81 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FileShield: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FileShield"
        weight = 1
    strings:
        $a = { 50 1E EB ?? 90 00 00 8B D8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V119_Dll_aPlib_043_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V119_Dll_aPlib_043_ap0x"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 89 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 3C 04 00 00 EB 0C 8B 85 38 04 00 00 89 85 3C 04 00 00 8D B5 60 04 00 00 8D 9D EB 02 00 00 33 FF E8 52 01 00 00 EB 1B 8B 85 3C 04 00 00 FF 74 37 04 01 04 24 FF 34 37 01 04 24 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 DF 83 BD 48 04 00 00 00 74 0E 83 BD 4C 04 00 00 00 74 05 E8 B8 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 D1 03 00 00 89 85 5C 04 00 00 5B FF B5 5C 04 00 00 56 FF D3 83 C4 08 8B B5 5C 04 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 E9 94 00 00 00 56 FF 95 C9 03 00 00 85 C0 0F 84 B4 00 00 00 89 85 54 04 00 00 8B C6 EB 5B 8B 85 58 04 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 58 04 00 00 C7 00 20 20 20 00 EB 06 FF B5 58 04 00 00 FF B5 54 04 00 00 FF 95 CD 03 00 00 85 C0 74 71 89 07 83 C7 04 8B 85 58 04 00 00 EB 01 40 80 38 00 75 FA 40 89 85 58 04 00 00 66 81 78 02 00 80 74 A5 80 38 00 75 A0 EB 01 46 80 3E 00 75 FA 46 40 8B 38 03 BD 3C 04 00 00 83 C0 04 89 85 58 04 00 00 80 3E 01 0F 85 63 FF FF FF 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 5C 04 00 00 FF 95 D5 03 00 00 E8 3D 00 00 00 E8 24 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Patch_Creation_Wizard_v12_Seek_and_Destroy_Patch: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Patch_Creation_Wizard_v12_Seek_and_Destroy_Patch"
        weight = 1
    strings:
        $a = { E8 C5 05 00 00 6A 00 E8 5E 05 00 00 A3 CE 39 40 00 6A 00 68 29 10 40 00 6A 00 6A 01 50 E8 72 05 00 00 6A 00 E8 2F 05 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C1 00 00 00 6A 01 FF 35 CE 39 40 00 E8 61 05 00 00 50 6A 01 68 80 00 00 00 FF 75 08 E8 63 05 00 00 68 5F 30 40 00 6A 65 FF 75 08 E8 5A 05 00 00 68 B0 30 40 00 6A 67 FF 75 08 E8 4B 05 00 00 68 01 31 40 00 6A 66 FF 75 08 E8 3C 05 00 00 6A 00 FF 75 08 E8 0E 05 00 00 A3 CA 39 40 00 C7 05 D2 39 40 00 2C 00 00 00 C7 05 D6 39 40 00 10 00 00 00 C7 05 DA 39 40 00 00 08 00 00 68 D2 39 40 00 6A 01 6A FF FF 35 CA 39 40 00 E8 DD 04 00 00 C7 05 DA 39 40 00 00 00 00 00 C7 05 F6 39 40 00 00 30 40 00 C7 05 FA 39 40 00 01 00 00 00 68 D2 39 40 00 6A 01 6A FF FF 35 CA 39 40 00 E8 AB 04 00 00 EB 5F EB 54 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule XM_music_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID XM_music_file"
        weight = 1
    strings:
        $a = { 45 78 74 65 6E 64 65 64 20 4D 6F 64 75 6C 65 3A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ChSfx_small_v11: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ChSfx_small_v11"
        weight = 1
    strings:
        $a = { BA ?? ?? E8 ?? ?? 8B EC 83 EC ?? 8C C8 BB ?? ?? B1 ?? D3 EB 03 C3 8E D8 05 ?? ?? 89 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CRYPTCOM: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CRYPTCOM"
        weight = 1
    strings:
        $a = { BF ?? ?? 57 BE ?? ?? ?? B9 ?? ?? F3 A4 C3 8B ?? ?? ?? 8B ?? ?? ?? BF ?? ?? 57 BE ?? ?? ?? AD 33 C2 AB E2 ?? C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LY_WGKX_wwwszleyucom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LY_WGKX_wwwszleyucom"
        weight = 1
    strings:
        $a = { 4D 79 46 75 6E 00 62 73 }
        $b = { 4D 5A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 52 53 46 58 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_01_Borland_Delphi_30: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_Borland_Delphi_30"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v120_v1201: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v120_v1201"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F 70 40 ?? 87 DD 8B 85 9A 70 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Morphine_27_Holy_Father_Ratter29A: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Morphine_27_Holy_Father_Ratter29A"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 47 65 74 50 72 6F 63 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LCC_Win32: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LCC_Win32"
        weight = 1
    strings:
        $a = { 53 FF 15 58 70 40 00 B3 22 38 18 74 03 80 C3 FE 40 33 D2 8A 08 3A CA 74 10 3A CB 74 07 40 8A 08 3A CA 75 F5 38 10 74 01 40 52 50 52 52 FF 15 5C 70 40 00 50 E8 15 FB FF FF 50 FF 15 8C 70 40 00 5B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Freshbind_v20_gFresh: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Freshbind_v20_gFresh"
        weight = 1
    strings:
        $a = { 64 A1 00 00 00 00 55 89 E5 6A FF 68 1C A0 41 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_v12_Alexey_Solodovnikov: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v12_Alexey_Solodovnikov"
        weight = 1
    strings:
        $a = { 90 60 E8 1B 00 00 00 E9 FC 8D B5 0F 06 00 00 8B FE B9 97 00 00 00 AD 35 78 56 34 12 AB 49 75 F6 EB 04 5D 45 55 C3 E9 ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ZipWorxSecureEXE_v25_ZipWORX_Technologies_LLC: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ZipWorxSecureEXE_v25_ZipWORX_Technologies_LLC"
        weight = 1
    strings:
        $a = { E9 B8 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 53 65 63 75 72 65 45 58 45 20 45 78 65 63 75 74 61 62 6C 65 20 46 69 6C 65 20 50 72 6F 74 65 63 74 6F 72 0D 0A 43 6F 70 79 72 69 67 68 74 28 63 29 20 32 30 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ADEX_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ADEX_Graphics_format"
        weight = 1
    strings:
        $a = { 50 49 43 54 00 08 ?? 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V121_Dll_LZMA_430_ap0xnbsp_nbsp_SignByfly_20080504: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V121_Dll_LZMA_430_ap0xnbsp_nbsp_SignByfly_20080504"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 AF 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 E0 0C 00 00 EB 0C 8B 85 DC 0C 00 00 89 85 E0 0C 00 00 E8 87 01 00 00 8D B5 08 0D 00 00 8D 9D C6 04 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 71 0C 00 00 89 85 D8 0C 00 00 E8 98 01 00 00 EB 20 60 8B 85 E0 0C 00 00 FF B5 D8 0C 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD EC 0C 00 00 00 74 0E 83 BD F0 0C 00 00 00 74 05 E8 31 02 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 71 0C 00 00 89 85 04 0D 00 00 5B 60 FF B5 D8 0C 00 00 56 FF B5 04 0D 00 00 FF D3 61 8B B5 04 0D 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD E0 0C 00 00 83 C0 04 89 85 00 0D 00 00 EB 72 56 FF 95 69 0C 00 00 0B C0 75 05 E8 25 03 00 00 85 C0 0F 84 AC 00 00 00 89 85 FC 0C 00 00 8B C6 EB 2E 8B 85 00 0D 00 00 8B 00 50 FF B5 FC 0C 00 00 E8 6D 02 00 00 85 C0 0F 84 86 00 00 00 89 07 83 85 00 0D 00 00 04 83 C7 04 8B 85 00 0D 00 00 83 38 00 75 CD EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD E0 0C 00 00 83 C0 04 89 85 00 0D 00 00 80 3E 01 75 89 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 04 0D 00 00 FF 95 75 0C 00 00 68 ?? ?? ?? ?? 6A 00 FF B5 04 0D 00 00 FF 95 75 0C 00 00 68 ?? ?? ?? ?? 6A 00 FF B5 D8 0C 00 00 FF 95 75 0C 00 00 E8 A0 00 00 00 E8 9B 01 00 00 61 E9 ?? ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEiD_Bundle_v102_v104_BoB_BobSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEiD_Bundle_v102_v104_BoB_BobSoft"
        weight = 1
    strings:
        $a = { 60 E8 ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 36 ?? ?? ?? 2E ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 80 00 00 00 00 4B 65 72 6E 65 6C 33 32 2E 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_Armadillo_300: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Armadillo_300"
        weight = 1
    strings:
        $a = { 60 E8 2A 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 85 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TrueVision_Targa_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TrueVision_Targa_Graphics_format"
        weight = 1
    strings:
        $a = { 00 00 02 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VProtector_vcasm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VProtector_vcasm"
        weight = 1
    strings:
        $a = { 89 C6 C7 45 E0 01 00 00 00 F7 03 00 00 FF FF 75 18 0F B7 03 50 8B 45 D8 50 FF 55 F8 89 07 8B C3 E8 ?? FE FF FF 8B D8 EB 13 53 8B 45 D8 50 FF 55 F8 89 07 8B C3 E8 ?? FE FF FF 8B D8 83 C7 04 FF 45 E0 4E 75 C4 8B F3 83 3E 00 75 88 8B 45 E4 8B 40 10 03 45 DC }
        $b = { 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 00 47 44 49 33 32 2E 64 6C 6C 00 00 00 00 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 53 6C 65 65 70 00 00 00 47 65 74 56 65 72 73 69 6F 6E 00 00 00 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 00 00 47 65 74 53 74 61 72 74 75 70 49 6E 66 6F 41 00 00 00 47 65 74 41 43 50 00 00 00 43 72 65 61 74 65 54 68 72 65 61 64 00 00 00 44 65 66 57 69 6E 64 6F 77 50 72 6F 63 41 00 00 00 52 65 67 69 73 74 65 72 43 6C 61 73 73 45 78 41 00 00 00 43 72 65 61 74 65 57 69 6E 64 6F 77 45 78 41 00 00 00 47 65 74 53 79 73 74 65 6D 4D 65 74 72 69 63 73 00 00 00 53 68 6F 77 57 69 6E 64 6F 77 00 00 00 47 65 74 44 43 00 00 00 52 65 6C 65 61 73 65 44 43 00 00 00 46 69 6E 64 57 69 6E 64 6F 77 41 00 00 00 47 65 74 4D 65 73 73 61 67 65 41 00 00 00 44 65 73 74 72 6F 79 57 69 6E 64 6F 77 00 00 00 53 65 74 50 69 78 65 6C 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule SimplePack_121build0909_Method2_bagie: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimplePack_121build0909_Method2_bagie"
        weight = 1
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 8A 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Embedded_2501_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_2501_Jitit"
        weight = 1
    strings:
        $a = { 55 8B EC B8 ?? ?? ?? ?? BB ?? ?? ?? ?? 50 E8 00 00 00 00 58 2D A8 1A 00 00 B9 6D 1A 00 00 BA 21 1B 00 00 BE 00 10 00 00 BF C0 53 00 00 BD F0 1A 00 00 03 E8 81 75 00 ?? ?? ?? ?? 81 75 04 ?? ?? ?? ?? 81 75 08 ?? ?? ?? ?? 81 75 0C ?? ?? ?? ?? 81 75 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_MSVCpp_DLL_Method_4_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_MSVCpp_DLL_Method_4_emadicius"
        weight = 1
    strings:
        $a = { 55 8B EC 56 57 BF 01 00 00 00 8B 75 0C 85 F6 5F 5E 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MEW_11_SE_12: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MEW_11_SE_12"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? 0C ?? ?? ?? 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_v2460_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_v2460_Jitit"
        weight = 1
    strings:
        $a = { 55 8B EC 51 53 56 57 6A 00 6A 00 FF 15 F4 18 40 00 50 E8 87 FC FF FF 59 59 A1 94 1A 40 00 8B 40 10 03 05 90 1A 40 00 89 45 FC 8B 45 FC FF E0 5F 5E 5B C9 C3 00 00 00 76 0C 00 00 D4 0C 00 00 1E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXcalibur_v103_forgotus: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXcalibur_v103_forgotus"
        weight = 1
    strings:
        $a = { E9 00 00 00 00 60 E8 14 00 00 00 5D 81 ED 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 58 61 EB 39 20 45 78 63 61 6C 69 62 75 72 20 28 63 29 20 62 79 20 66 6F 72 67 6F 74 2F 75 53 2F 44 46 43 47 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V119_Dll_LZMA_430_ap0xnbsp_nbsp_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V119_Dll_LZMA_430_ap0xnbsp_nbsp_Sign_by_fly"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 C7 01 00 00 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressor_V10_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_V10_CGSoftLabs"
        weight = 1
    strings:
        $a = { E9 35 14 00 00 E9 31 13 00 00 E9 98 12 00 00 E9 EF 0C 00 00 E9 42 13 00 00 E9 E9 02 00 00 E9 EF 0B 00 00 E9 1B 0D 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_133_21_Registered_Alexey_Solodovnikov: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_133_21_Registered_Alexey_Solodovnikov"
        weight = 1
    strings:
        $a = { 68 01 ?? ?? ?? E8 01 00 00 00 C3 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeShield_Cryptor_13RC_Tom_Commander: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeShield_Cryptor_13RC_Tom_Commander"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 8C 21 40 00 B9 51 2D 40 00 81 E9 E6 21 40 00 8B D5 81 C2 E6 21 40 00 8D 3A 8B F7 33 C0 EB 04 90 EB 01 C2 AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SDProtector_11x_Randy_Li: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SDProtector_11x_Randy_Li"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 }
        $b = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Themida_18xx_19xx_Oreans_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Themida_18xx_19xx_Oreans_Technologies"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 60 0B C0 74 68 E8 00 00 00 00 58 05 53 00 00 00 80 38 E9 75 13 61 EB 45 DB 2D 37 ?? ?? ?? FF FF FF FF FF FF FF FF 3D 40 E8 00 00 00 00 58 25 00 F0 FF FF 33 FF 66 BB 19 5A 66 83 C3 34 66 39 18 75 12 0F B7 50 3C 03 D0 BB E9 44 00 00 83 C3 67 39 1A 74 07 2D 00 10 00 00 EB DA 8B F8 B8 ?? ?? ?? ?? 03 C7 B9 ?? ?? ?? ?? 03 CF EB 0A B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 50 51 E8 84 00 00 00 E8 00 00 00 00 58 2D 26 00 00 00 B9 EF 01 00 00 C6 00 E9 83 E9 05 89 48 01 61 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nSPack_2x_North_StarLiu_Xing_Ping: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nSPack_2x_North_StarLiu_Xing_Ping"
        weight = 1
    strings:
        $a = { FF FF 8B 4E 08 8D 56 10 8B 36 8B FE 83 F9 00 74 3F 8A 07 47 2C E8 3C 01 77 F7 8B 07 80 7A 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AHTeam_EP_Protector_03_fake_Xtreme_Protector_105_FEUERRADER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AHTeam_EP_Protector_03_fake_Xtreme_Protector_105_FEUERRADER"
        weight = 1
    strings:
        $a = { 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 FF E0 E8 00 00 00 00 5D 81 00 00 00 00 00 6A 45 E8 A3 00 00 00 68 00 00 00 00 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_Install_System_v20b4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_Install_System_v20b4"
        weight = 1
    strings:
        $a = { 83 EC 14 83 64 24 04 00 53 55 56 57 C6 44 24 13 20 FF 15 30 70 40 00 BE 00 20 7A 00 BD 00 04 00 00 56 55 FF 15 C4 70 40 00 56 E8 7D 2B 00 00 8B 1D 8C 70 40 00 6A 00 56 FF D3 BF 80 92 79 00 56 57 E8 15 26 00 00 85 C0 75 38 68 F8 91 40 00 55 56 FF 15 60 71 40 00 03 C6 50 E8 78 29 00 00 56 E8 47 2B 00 00 6A 00 56 FF D3 56 57 E8 EA 25 00 00 85 C0 75 0D C7 44 24 14 58 91 40 00 E9 72 02 00 00 57 FF 15 24 71 40 00 68 EC 91 40 00 57 E8 43 }
        $b = { 83 EC 10 53 55 56 57 C7 44 24 14 F0 91 40 00 33 ED C6 44 24 13 20 FF 15 2C 70 40 00 55 FF 15 88 72 40 00 BE 00 D4 42 00 BF 00 04 00 00 56 57 A3 60 6F 42 00 FF 15 C4 70 40 00 E8 9F FF FF FF 8B 1D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 60 71 40 00 68 E4 91 40 00 56 FF D3 E8 7C FF FF FF 85 C0 0F 84 59 01 00 00 BE E0 66 42 00 56 FF 15 68 70 40 00 68 D8 91 40 00 56 E8 FE 27 00 00 57 FF 15 BC 70 40 00 BE 00 C0 42 00 50 56 FF 15 B8 70 40 00 6A 00 FF 15 44 71 40 00 80 3D 00 C0 42 00 22 A3 E0 6E 42 00 8B C6 75 0A C6 44 24 13 22 B8 01 C0 42 00 8B 3D 10 72 40 00 EB 09 3A 4C 24 13 74 09 50 FF D7 8A 08 84 C9 75 F1 50 FF D7 8B F0 89 74 24 1C EB 05 56 FF D7 8B F0 80 3E 20 74 F6 80 3E 2F 75 44 46 80 3E 53 75 0C 8A 46 01 0C 20 3C 20 75 03 83 CD 02 81 3E 4E 43 52 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PseudoSigner_01_Pack_Master_10_PEX_Clone: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PseudoSigner_01_Pack_Master_10_PEX_Clone"
        weight = 1
    strings:
        $a = { 60 E8 01 01 00 00 E8 83 C4 04 E8 01 90 90 90 E9 5D 81 ED D3 22 40 90 E8 04 02 90 90 E8 EB 08 EB 02 CD 20 FF 24 24 9A 66 BE 47 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 FF FF E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Microsoft_Visual_Basic_50_60: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Microsoft_Visual_Basic_50_60"
        weight = 1
    strings:
        $a = { C1 CB 10 EB 01 0F B9 03 74 F6 EE 0F B6 D3 8D 05 83 ?? ?? EF 80 F3 F6 2B C1 EB 01 DE 68 77 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LGLZ_v104_com: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LGLZ_v104_com"
        weight = 1
    strings:
        $a = { BF ?? ?? 3B FC 72 19 B4 09 BA 12 01 CD 21 B4 4C CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_2021_protected_IAT: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_2021_protected_IAT"
        weight = 1
    strings:
        $a = { A4 ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? 94 ?? ?? ?? D8 ?? ?? ?? 00 00 00 00 FF FF FF FF B8 ?? ?? ?? D4 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 60 ?? ?? ?? 70 ?? ?? ?? 84 ?? ?? ?? 00 00 00 00 75 73 65 72 33 32 2E 64 6C 6C 00 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ActiveMark_Trymedia_Systems_Inc: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ActiveMark_Trymedia_Systems_Inc"
        weight = 1
    strings:
        $a = { 89 25 ?? ?? ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LGLZ_v104b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LGLZ_v104b"
        weight = 1
    strings:
        $a = { FC 1E 06 0E 8C C8 ?? ?? ?? ?? BA ?? ?? 03 C2 8B D8 05 ?? ?? 8E DB 8E C0 33 F6 33 FF B9 ?? ?? F3 A5 4B 48 4A 79 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeJoiner_Small_build_033_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeJoiner_Small_build_033_GlOFF"
        weight = 1
    strings:
        $a = { 50 66 33 C3 66 8B C1 58 E8 AC FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 00 FF 25 AC 10 40 00 }
        $b = { 50 66 33 C3 66 8B C1 58 E8 AC FD FF FF 6A 00 E8 0D 00 00 00 CC FF 25 78 10 40 00 FF 25 7C 10 40 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Obsidium_v1111: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_v1111"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 ?? 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_301_305: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_301_305"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 50 51 EB 0F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_13x_Cyberbob: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_13x_Cyberbob"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 71 DF 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Safeguard_103_Simonzh: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Safeguard_103_Simonzh"
        weight = 1
    strings:
        $a = { E8 ?? 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SLVc0deProtector_11x_SLV_ICU: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SLVc0deProtector_11x_SLV_ICU"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 58 C6 00 EB C6 40 01 08 FF E0 E9 4C ?? ?? 00 }
        $b = { E8 01 00 00 00 A0 5D EB 01 69 81 ED 5F 1A 40 00 8D 85 92 1A 40 00 F3 8D 95 83 1A 40 00 8B C0 8B D2 2B C2 83 E8 05 89 42 01 E8 FB FF FF FF 69 83 C4 08 E8 06 00 00 00 69 E8 F2 FF FF FF F3 B9 05 00 00 00 51 8D B5 BF 1A 40 00 8B FE B9 58 15 00 00 AC 32 C1 F6 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PE_Spin_v04x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Spin_v04x"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D }
        $b = { EB 01 68 60 E8 00 00 00 00 8B }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule FreeCryptor_02_build_002_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeCryptor_02_build_002_GlOFF"
        weight = 1
    strings:
        $a = { 33 D2 90 1E 68 1B ?? ?? ?? 0F A0 1F 8B ?? 90 50 54 8F 02 90 90 8E 64 24 08 FF E2 58 50 33 D2 52 83 F8 01 9B 40 8A 10 89 14 24 90 D9 04 24 90 D9 FA D9 5C 24 FC 8B 5C 24 FC 81 F3 C2 FC 1D 1C 75 E3 74 01 62 FF D0 90 5A 33 C0 8B 54 24 08 90 64 8F 00 90 83 C2 08 52 5C 5A }
        $b = { 33 D2 90 1E 68 1B ?? ?? ?? 0F A0 1F 8B 02 90 50 54 8F 02 90 90 8E 64 24 08 FF E2 58 50 33 D2 52 83 F8 01 9B 40 8A 10 89 14 24 90 D9 04 24 90 D9 FA D9 5C 24 FC 8B 5C 24 FC 81 F3 C2 FC 1D 1C 75 E3 74 01 62 FF D0 90 5A 33 C0 8B 54 24 08 90 64 8F 00 90 83 C2 08 52 5C 5A }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Overlay: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Overlay"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 D4 53 56 57 33 C0 89 45 F0 89 45 E4 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Crypt32_Console_v10_v101_v102: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Crypt32_Console_v10_v101_v102"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 5B 83 EB 05 EB 04 52 4E 44 21 EB 02 CD 20 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PKLITE_v200c: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PKLITE_v200c"
        weight = 1
    strings:
        $a = { 50 B8 ?? ?? BA ?? ?? 3B C4 73 ?? 8B C4 2D ?? ?? 25 ?? ?? 8B F8 B9 ?? ?? BE ?? ?? FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_SCRAMBLER_306_OnToL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_SCRAMBLER_306_OnToL"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 59 83 C1 07 51 C3 C3 BE ?? ?? ?? ?? 83 EC 04 89 34 24 B9 80 00 00 00 81 36 ?? ?? ?? ?? 50 B8 04 00 00 00 50 03 34 24 58 58 83 E9 03 E2 E9 EB D6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VIRUS_I_WormBagle: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VIRUS_I_WormBagle"
        weight = 1
    strings:
        $a = { 6A 00 E8 95 01 00 00 E8 9F E6 FF FF 83 3D 03 50 40 00 00 75 14 68 C8 AF 00 00 E8 01 E1 FF FF 05 88 13 00 00 A3 03 50 40 00 68 5C 57 40 00 68 F6 30 40 00 FF 35 03 50 40 00 E8 B0 EA FF FF E8 3A FC FF FF 83 3D 54 57 40 00 00 74 05 E8 F3 FA FF FF 68 E8 03 00 00 E8 B1 00 00 00 EB F4 CC FF 25 A4 40 40 00 FF 25 B8 40 40 00 FF 25 B4 40 40 00 FF 25 B0 40 40 00 FF 25 AC 40 40 00 FF 25 9C 40 40 00 FF 25 A0 40 40 00 FF 25 A8 40 40 00 FF 25 24 40 40 00 FF 25 28 40 40 00 FF 25 2C 40 40 00 FF 25 30 40 40 00 FF 25 34 40 40 00 FF 25 38 40 40 00 FF 25 3C 40 40 00 FF 25 40 40 40 00 FF 25 44 40 40 00 FF 25 48 40 40 00 FF 25 4C 40 40 00 FF 25 50 40 40 00 FF 25 54 40 40 00 FF 25 58 40 40 00 FF 25 5C 40 40 00 FF 25 60 40 40 00 FF 25 BC 40 40 00 FF 25 64 40 40 00 FF 25 68 40 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_VOB_ProtectCD_5: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_VOB_ProtectCD_5"
        weight = 1
    strings:
        $a = { 36 3E 26 8A C0 60 E8 00 00 00 00 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule N_Code_01_NEX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID N_Code_01_NEX"
        weight = 1
    strings:
        $a = { BB E8 03 00 00 81 C3 E8 03 00 00 B8 05 00 00 00 B9 73 00 00 00 01 C8 83 E8 32 90 90 90 90 6B C0 02 90 68 FF 64 24 F0 90 90 90 90 90 68 58 58 58 58 FF D4 50 8B 40 F2 05 B0 95 F6 95 0F 85 01 81 BB FF 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_LCC_Win32_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_LCC_Win32_DLL"
        weight = 1
    strings:
        $a = { 55 89 E5 53 56 57 83 7D 0C 01 75 05 E8 17 90 90 90 FF 75 10 FF 75 0C FF 75 08 A1 ?? ?? ?? ?? E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Dev_Cpp_4992_Bloodshed_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Dev_Cpp_4992_Bloodshed_Software"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 ?? ?? ?? 00 E8 C8 FE FF FF 90 8D B4 26 00 00 00 00 55 89 E5 83 EC 08 C7 04 24 02 00 00 00 FF 15 ?? ?? ?? 00 E8 A8 FE FF FF 90 8D B4 26 00 00 00 00 55 8B 0D ?? ?? ?? 00 89 E5 5D FF E1 8D 74 26 00 55 8B 0D ?? ?? ?? 00 89 E5 5D FF E1 90 90 90 90 55 89 E5 5D E9 ?? ?? 00 00 90 90 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_v1032_dllocx_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_v1032_dllocx_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 60 E8 00 00 00 00 5D 81 ED 94 73 42 00 8B D5 81 C2 E3 73 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 BF A4 42 00 81 E9 8E 74 42 00 8B D5 81 C2 8E 74 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 63 29 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 9C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pelles_C_280_290_EXE_X86_CRT_LIB: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pelles_C_280_290_EXE_X86_CRT_LIB"
        weight = 1
    strings:
        $a = { 55 89 E5 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 ?? ?? ?? ?? 64 89 25 ?? ?? ?? ?? 83 EC ?? 83 EC ?? 53 56 57 89 65 E8 68 00 00 00 ?? E8 ?? ?? ?? ?? 59 A3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLP_V073beta_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLP_V073beta_ap0x"
        weight = 1
    strings:
        $a = { 2E 72 6C 70 00 00 00 00 00 50 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 20 00 00 E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V024_V028_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V024_V028_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? AD 8B F8 95 AD 91 F3 A5 AD ?? ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 57 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF ?? ?? ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 01 E3 29 8B D7 2B 55 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 56 08 33 C9 FF 66 24 B1 30 8B 5D 0C 03 D1 FF 16 73 4B 03 D1 FF 16 72 19 03 D1 FF 16 72 29 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 45 0C 8A 00 FF 66 20 83 C2 60 FF 16 87 5D 10 73 0C 03 D1 FF 16 87 5D 14 73 03 87 5D 18 3C 07 B0 08 72 02 B0 0B 50 53 8B D5 03 56 14 FF 56 0C 5B 91 FF 66 3C 07 B0 07 72 02 B0 0A 50 87 5D 10 87 5D 14 89 5D 18 8B D5 03 56 18 FF 56 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V120_LZMA_430_ap0x_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V120_LZMA_430_ap0x_SignByfly"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 9C 0C 00 00 EB 0C 8B 85 98 0C 00 00 89 85 9C 0C 00 00 8D B5 C4 0C 00 00 8D 9D 82 04 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 2D 0C 00 00 89 85 94 0C 00 00 E8 59 01 00 00 EB 20 60 8B 85 9C 0C 00 00 FF B5 94 0C 00 00 FF 34 37 01 04 24 FF 74 37 04 01 04 24 FF D3 61 83 C7 08 83 3C 37 00 75 DA 83 BD A8 0C 00 00 00 74 0E 83 BD AC 0C 00 00 00 74 05 E8 F2 01 00 00 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 2D 0C 00 00 89 85 C0 0C 00 00 5B 60 FF B5 94 0C 00 00 56 FF B5 C0 0C 00 00 FF D3 61 8B B5 C0 0C 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 03 BD 9C 0C 00 00 83 C0 04 89 85 BC 0C 00 00 EB 72 56 FF 95 25 0C 00 00 0B C0 75 05 E8 E6 02 00 00 85 C0 0F 84 AB 00 00 00 89 85 B8 0C 00 00 8B C6 EB 2E 8B 85 BC 0C 00 00 8B 00 50 FF B5 B8 0C 00 00 E8 2E 02 00 00 85 C0 0F 84 85 00 00 00 89 07 83 85 BC 0C 00 00 04 83 C7 04 8B 85 BC 0C 00 00 83 38 00 75 CD EB 01 46 80 3E 00 75 FA 46 83 C0 04 8B 38 03 BD 9C 0C 00 00 83 C0 04 89 85 BC 0C 00 00 80 3E 01 75 89 68 00 40 00 00 68 ?? ?? ?? ?? FF B5 C0 0C 00 00 FF 95 31 0C 00 00 68 00 80 00 00 6A 00 FF B5 C0 0C 00 00 FF 95 31 0C 00 00 68 00 80 00 00 6A 00 FF B5 94 0C 00 00 FF 95 31 0C 00 00 E8 61 00 00 00 E8 5C 01 00 00 61 E9 ?? ?? ?? ?? 61 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Lock_NT_v202c: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Lock_NT_v202c"
        weight = 1
    strings:
        $a = { EB 02 C7 85 1E EB 03 CD 20 C7 9C EB 02 69 B1 60 EB 02 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PC_Guard_v405d_v410d_v415d: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PC_Guard_v405d_v410d_v415d"
        weight = 1
    strings:
        $a = { FC 55 50 E8 00 00 00 00 5D EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_Basic_v10_1987: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_Basic_v10_1987"
        weight = 1
    strings:
        $a = { 2E 8C ?? ?? ?? 2E C7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WinUpack_v030_beta_By_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WinUpack_v030_beta_By_Dwing"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 4C 01 02 }
        $b = { E9 ?? ?? ?? ?? 42 79 44 77 69 6E 67 40 00 00 00 50 45 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PKLITE_v100c_2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PKLITE_v100c_2"
        weight = 1
    strings:
        $a = { BA ?? ?? A1 ?? ?? 2D ?? ?? 8C CB 81 C3 ?? ?? 3B C3 77 ?? 05 ?? ?? 3B C3 77 ?? B4 09 BA ?? ?? CD 21 CD 20 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WWPACK_v305c4_Modified: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WWPACK_v305c4_Modified"
        weight = 1
    strings:
        $a = { B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DiskDupe_c_MSD_Users_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DiskDupe_c_MSD_Users_file"
        weight = 1
    strings:
        $a = { 4D 53 44 20 55 73 65 72 73 20 56 65 72 73 69 6F 6E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v220: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v220"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 10 12 41 00 68 F4 A0 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEQuake_V006_forgat: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEQuake_V006_forgat"
        weight = 1
    strings:
        $a = { E8 A5 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_116_aPLib_compression_ap0x_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_116_aPLib_compression_ap0x_h"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 53 03 00 00 8D 9D 02 02 00 00 33 FF E8 45 01 00 00 EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 8D 74 37 04 53 6A 40 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 E8 02 00 00 89 85 4F 03 00 00 5B FF B5 4F 03 00 00 56 FF D3 83 C4 08 8B B5 4F 03 00 00 8B C6 EB 01 40 80 38 01 75 FA 40 8B 38 E8 CD 00 00 00 83 C0 04 89 85 4B 03 00 00 E9 93 00 00 00 56 FF 95 E0 02 00 00 85 C0 0F 84 AE 00 00 00 89 85 47 03 00 00 8B C6 EB 5B 8B 85 4B 03 00 00 8B 00 A9 00 00 00 80 74 14 35 00 00 00 80 50 8B 85 4B 03 00 00 C7 00 20 20 20 00 EB 06 FF B5 4B 03 00 00 FF B5 47 03 00 00 FF 95 E4 02 00 00 85 C0 74 6B 89 07 83 C7 04 8B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SoftComp_1x_BG_Soft_PT: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SoftComp_1x_BG_Soft_PT"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 81 2C 24 3A 10 41 00 5D E8 00 00 00 00 81 2C 24 31 01 00 00 8B 85 2A 0F 41 00 29 04 24 8B 04 24 89 85 2A 0F 41 00 58 8B 85 2A 0F 41 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_v37_North_Star_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_v37_North_Star_h"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 8D ?? ?? ?? FF 80 39 01 0F 84 42 02 00 00 C6 01 01 8B C5 2B 85 ?? ?? ?? FF 89 85 ?? ?? ?? FF 01 85 ?? ?? ?? FF 8D B5 ?? ?? ?? FF 01 06 55 56 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? ?? FF 85 C0 0F 84 69 03 00 00 89 85 ?? ?? ?? FF E8 00 00 00 00 5B B9 67 03 00 00 03 D9 50 53 E8 B0 02 00 00 5E 5D 8B 36 8B FD 03 BD ?? ?? ?? FF 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 34 01 13 8B 33 03 7B 04 57 51 53 FF B5 ?? ?? ?? FF FF B5 ?? ?? ?? FF 8B D6 8B CF 8B 85 ?? ?? ?? FF 05 AA 05 00 00 FF D0 5B 59 5F 83 F9 00 74 05 83 C3 08 EB C7 68 00 80 00 00 6A 00 FF B5 ?? ?? ?? FF FF 95 ?? ?? ?? FF 8D B5 ?? ?? ?? FF 8B 4E 08 8D 56 10 8B 36 8B FE 83 F9 00 74 3F 8A 07 47 2C E8 3C 01 77 F7 8B 07 80 7A 01 00 74 14 8A 1A 38 1F 75 E9 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 EB 0A 8A 5F 04 86 C4 C1 C0 10 86 C4 2B C7 03 C6 89 07 83 C7 05 80 EB E8 8B C3 E2 C6 E8 3A 01 00 00 8D 8D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule InstallShield_2000: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID InstallShield_2000"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 C4 ?? 53 56 57 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimbiOZ_Poly_21_Extranger: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimbiOZ_Poly_21_Extranger"
        weight = 1
    strings:
        $a = { 55 50 8B C4 83 C0 04 C7 00 ?? ?? ?? ?? 58 C3 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Private_EXE_Protector_197_SetiSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_EXE_Protector_197_SetiSoft"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F4 FC 53 57 56 8B 74 24 20 8B 7C 24 24 66 81 3E 4A 43 0F 85 A5 02 00 00 83 C6 0A 33 DB BA 00 00 00 80 C7 44 24 14 08 00 00 00 43 8D A4 24 00 00 00 00 8B FF 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 73 2C 8B 4C 24 10 33 C0 8D A4 24 00 00 00 00 05 00 00 00 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 13 C0 49 75 EF 02 44 24 0C 88 07 47 EB C6 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 0F 82 6E 01 00 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 0F 83 DC 00 00 00 B9 04 00 00 00 33 C0 8D A4 24 00 00 00 00 8D 64 24 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 13 C0 49 75 EF 48 74 B1 0F 89 EF 01 00 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 73 42 BD 00 01 00 00 B9 08 00 00 00 33 C0 8D A4 24 00 00 00 00 05 00 00 00 00 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 13 C0 49 75 EF 88 07 47 4D 75 D6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Packanoid_Arkanoid: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Packanoid_Arkanoid"
        weight = 1
    strings:
        $a = { BF 00 10 40 00 BE ?? ?? ?? 00 E8 9D 00 00 00 B8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Protect_v09: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Protect_v09"
        weight = 1
    strings:
        $a = { 52 53 51 56 57 55 E8 ?? ?? ?? ?? 5D 81 ED 36 ?? ?? ?? E8 ?? 01 ?? ?? 60 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F }
        $b = { E9 ?? 00 00 00 0D 0A 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 50 45 2D 50 52 4F 54 45 43 54 20 30 2E 39 20 28 43 29 6F }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PEiD_Bundle_102_DLL_BoB_BobSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEiD_Bundle_102_DLL_BoB_BobSoft"
        weight = 1
    strings:
        $a = { 83 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 9C 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 41 00 08 00 39 00 08 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 80 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_FullEdition_V120_BasicEdition_Stub_ap0x_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_FullEdition_V120_BasicEdition_Stub_ap0x_SignByfly"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 00 10 00 00 08 00 00 00 }
        $b = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 4C 6F 61 64 4C 69 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Anskya_NTPacker_Generator_Anskya: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Anskya_NTPacker_Generator_Anskya"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 B8 88 1D 00 10 E8 C7 FA FF FF 6A 0A 68 20 1E 00 10 A1 14 31 00 10 50 E8 71 FB FF FF 8B D8 85 DB 74 2F 53 A1 14 31 00 10 50 E8 97 FB FF FF 85 C0 74 1F 53 A1 14 31 00 10 50 E8 5F FB FF FF 85 C0 74 0F 50 E8 5D FB FF FF 85 C0 74 05 E8 70 FC FF FF 5B E8 F2 F6 FF FF 00 00 48 45 41 52 54 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RatPacker_Glue_stub: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RatPacker_Glue_stub"
        weight = 1
    strings:
        $a = { 40 20 FF 00 00 00 00 00 00 00 ?? BE 00 60 40 00 8D BE 00 B0 FF FF }
        $b = { 40 20 FF ?? ?? ?? ?? ?? ?? ?? ?? BE ?? 60 40 ?? 8D BE ?? B0 FF FF }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PassLock_2000_v10_Eng_Moonlight_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PassLock_2000_v10_Eng_Moonlight_Software"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 50 40 00 66 2E F7 05 34 20 40 00 04 00 0F 85 98 00 00 00 E8 1F 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_V22004616_V22006630_WFS_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_V22004616_V22006630_WFS_SignByfly"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 7A 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 53 79 73 74 65 6D 44 69 72 65 63 74 6F 72 79 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Sentinel_SuperPro_Dongle_V54200_Rainbow_Technologies_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Sentinel_SuperPro_Dongle_V54200_Rainbow_Technologies_SignByfly"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? B9 10 FF 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 B9 20 FF 00 00 E8 ?? ?? ?? ?? 68 B9 30 FF 00 00 E8 ?? ?? ?? ?? 68 E8 ?? ?? ?? ?? 68 27 F0 10 7F E8 ?? ?? ?? ?? 68 BB 02 00 00 00 E8 ?? ?? ?? ?? 68 07 D4 30 7F E8 ?? ?? ?? ?? 68 BB 01 00 00 00 E8 ?? ?? ?? ?? 68 50 1E DF 80 E8 ?? ?? ?? ?? 68 B9 10 12 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 B9 20 12 00 00 E8 ?? ?? ?? ?? 68 E8 ?? ?? ?? ?? 68 07 2A A3 00 E8 ?? ?? ?? ?? 68 BB 01 00 00 00 E8 ?? ?? ?? ?? 68 88 B5 5B FF E8 ?? ?? ?? ?? 68 B9 30 12 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 }
        $b = { 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? B9 10 FF 00 00 BB 00 00 00 00 E8 ?? ?? ?? ?? 68 B9 20 FF 00 00 E8 ?? ?? ?? ?? 68 B9 30 FF 00 00 E8 ?? ?? ?? ?? 68 E8 ?? ?? ?? ?? 68 27 F0 10 7F E8 ?? ?? ?? ?? 68 BB 02 00 00 00 E8 ?? ?? ?? ?? 68 07 D4 30 7F E8 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Simple_UPX_Cryptor_V3042005_MANtiCORE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Simple_UPX_Cryptor_V3042005_MANtiCORE"
        weight = 1
    strings:
        $a = { 60 B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? ?? ?? ?? ?? E2 FA 61 68 ?? ?? ?? ?? C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_Borland_Cpp_DLL_Method_2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Borland_Cpp_DLL_Method_2"
        weight = 1
    strings:
        $a = { EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MPEG_movie_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MPEG_movie_file"
        weight = 1
    strings:
        $a = { 55 8B EC 83 ?? ?? 33 C0 89 45 F0 B8 ?? ?? ?? ?? E8 67 C4 FF FF 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 33 C0 E8 93 C8 FF FF 8B 45 F0 E8 87 CB FF FF A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 A1 ?? ?? ?? ?? E8 FA C9 FF FF 83 F8 FF }
        $b = { 00 00 01 BA 2F FF FD E6 C1 80 18 61 00 00 01 BB }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Private_exe_Protector_V230_V23X_SetiSoft_Team_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_exe_Protector_V230_V23X_SetiSoft_Team_SignByfly"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 04 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 04 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ORiEN_103_A_Fisun: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ORiEN_103_A_Fisun"
        weight = 1
    strings:
        $a = { E8 FD 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5B EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v71_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v71_DLL"
        weight = 1
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 85 F6 57 8B 7D 10 75 09 83 3D ?? ?? 40 00 00 EB 26 83 FE 01 74 05 83 FE 02 75 22 A1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_v081_v084_Modified: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_v081_v084_Modified"
        weight = 1
    strings:
        $a = { 01 DB ?? 07 8B 1E 83 EE FC 11 DB ?? ED B8 01 00 00 00 01 DB ?? 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 77 EF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Windows_Animation_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Windows_Animation_format"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 EC 53 ?? ?? ?? ?? 89 45 EC B8 64 40 00 10 E8 28 EA FF FF 33 C0 55 68 CE 51 00 10 64 ?? ?? ?? ?? 20 6A 00 68 80 00 00 00 6A 03 6A 00 6A 01 68 00 00 00 80 8D 55 EC 33 C0 E8 F6 DB FF FF 8B 45 EC E8 12 E7 FF FF 50 E8 3C EA FF FF 8B D8 83 FB FF }
        $b = { 52 49 46 46 ?? ?? ?? ?? 41 43 4F 4E 4C 49 53 54 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Sierras_audio_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Sierras_audio_file"
        weight = 1
    strings:
        $a = { 8D 0C 53 4F 4C 00 22 56 0D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_v_If_you_know_this_version_post_on_PEiD_board: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_v_If_you_know_this_version_post_on_PEiD_board"
        weight = 1
    strings:
        $a = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 ?? ?? 00 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 DD 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ActiveMARK_5x_Trymedia_SystemsInc: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ActiveMARK_5x_Trymedia_SystemsInc"
        weight = 1
    strings:
        $a = { 20 2D 2D 4D 50 52 4D 4D 47 56 41 2D 2D 00 75 73 65 72 33 32 2E 64 6C 6C 00 4D 65 73 73 61 67 65 42 6F 78 41 00 54 68 69 73 20 61 70 70 6C 69 63 61 74 69 6F 6E 20 63 61 6E 6E 6F 74 20 72 75 6E 20 77 69 74 68 20 61 6E 20 61 63 74 69 76 65 20 64 65 62 75 67 67 65 72 20 69 6E 20 6D 65 6D 6F 72 79 2E 0D 0A 50 6C 65 61 73 65 20 75 6E 6C 6F 61 64 20 74 68 65 20 64 65 62 75 67 67 65 72 20 61 6E 64 20 72 65 73 74 61 72 74 20 74 68 65 20 61 70 70 6C 69 63 61 74 69 6F 6E 2E 00 57 61 72 6E 69 6E 67 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_CodeSafe_20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_CodeSafe_20"
        weight = 1
    strings:
        $a = { 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0B 83 EC 10 53 56 57 E8 C4 01 00 85 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Basic_40: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Basic_40"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? 00 E8 ?? FF FF FF 00 00 ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_V21X_softcompletecom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_V21X_softcompletecom"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? 66 9C 60 50 8D 88 ?? ?? ?? ?? 8D 90 04 16 ?? ?? 8B DC 8B E1 }
        $b = { 83 EC 04 89 14 24 59 BA ?? 00 00 00 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Werus_Crypter_10_by_Kas: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Werus_Crypter_10_by_Kas"
        weight = 1
    strings:
        $a = { BB E8 12 40 00 80 33 05 E9 7D FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_ASPack_212_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_ASPack_212_emadicius"
        weight = 1
    strings:
        $a = { 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB 00 73 00 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 2B 04 24 74 04 75 02 EB 02 EB 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SDProtector_1x_Randy_Li: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SDProtector_1x_Randy_Li"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 1D 32 13 05 68 88 88 88 08 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 58 64 A3 00 00 00 00 58 58 58 58 8B E8 E8 3B 00 00 00 E8 01 00 00 00 FF 58 05 53 00 00 00 51 8B 4C 24 10 89 81 B8 00 00 00 B8 55 01 00 00 89 41 20 33 C0 89 41 04 89 41 08 89 41 0C 89 41 10 59 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 33 C0 64 FF 30 64 89 20 9C 80 4C 24 01 01 9D 90 90 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 C3 64 8F 00 58 74 07 75 05 19 32 67 E8 E8 74 27 75 25 EB 00 EB FC 68 39 44 CD 00 59 9C 50 74 0F 75 0D E8 59 C2 04 00 55 8B EC E9 FA FF FF 0E E8 EF FF FF FF 56 57 53 78 03 79 01 E8 68 A2 AF 47 01 59 E8 01 00 00 00 FF 58 05 7B 03 00 00 03 C8 74 C4 75 C2 E8 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NSPack_3x_Liu_Xing_Ping: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NSPack_3x_Liu_Xing_Ping"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? FF FF ?? 38 01 0F 84 ?? 02 00 00 ?? 00 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _22b_Anti_xiaohui: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _22b_Anti_xiaohui"
        weight = 1
    strings:
        $a = { EB F4 11 55 07 8B EC B8 14 80 0E 03 E8 D1 09 00 0A 57 33 D2 FF 75 18 B9 E8 1F DE 16 81 C0 8D BD EE 7F FB F8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_v1_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_v1_Vaska"
        weight = 1
    strings:
        $a = { 90 58 90 50 90 8B 00 90 3C 50 90 58 0F 85 67 D6 EF 11 50 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VProtector_V10A_vcasm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VProtector_V10A_vcasm"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 8A 8E 40 00 68 C6 8E 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AverCryptor_102_beta_os1r1s: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AverCryptor_102_beta_os1r1s"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 0C 17 40 00 8B BD 33 18 40 00 8B 8D 3B 18 40 00 B8 51 18 40 00 03 C5 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 37 18 40 00 33 C0 51 33 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 37 18 40 00 8B 85 3F 18 40 00 83 F8 02 75 06 81 C2 00 02 00 00 51 8B 4F 10 83 F8 02 75 06 81 E9 00 02 00 00 57 BF C8 00 00 00 8B F1 E8 27 00 00 00 8B C8 5F B8 51 18 40 00 03 C5 E8 24 00 00 00 59 49 EB B1 59 83 C7 28 49 EB 8A 8B 85 2F 18 40 00 89 44 24 1C 61 FF E0 56 57 4F F7 D7 23 F7 8B C6 5F 5E C3 }
        $b = { 60 E8 00 00 00 00 5D 81 ED 0C 17 40 00 8B BD 33 18 40 00 8B 8D 3B 18 40 00 B8 51 18 40 00 03 C5 80 30 05 83 F9 00 74 71 81 7F 1C AB 00 00 00 75 62 8B 57 0C 03 95 37 18 40 00 33 C0 51 33 C9 66 B9 F7 00 66 83 F9 00 74 49 8B 57 0C 03 95 37 18 40 00 8B 85 3F }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PolyCrypt_PE_214b215_JLab_Software_Creations: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PolyCrypt_PE_214b215_JLab_Software_Creations"
        weight = 1
    strings:
        $a = { 91 8B F4 AD FE C9 80 34 08 ?? E2 FA C3 60 E8 ED FF FF FF EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vcasm_Protector_10a_10d_vcasm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vcasm_Protector_10a_10d_vcasm"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? 00 68 ?? ?? ?? 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_Modified_Stub_b_Farb_rausch_Consumer_Consulting: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_Modified_Stub_b_Farb_rausch_Consumer_Consulting"
        weight = 1
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF FC B2 80 31 DB A4 B3 02 E8 6D 00 00 00 73 F6 31 C9 E8 64 00 00 00 73 1C 31 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 10 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 29 D9 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 11 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 89 E8 B3 01 56 89 FE 29 C6 F3 A4 5E EB 8E 00 D2 75 05 8A 16 46 10 D2 C3 31 C9 41 E8 EE FF FF FF 11 C9 E8 E7 FF FF FF 72 F2 C3 31 C0 31 DB 31 C9 5E 89 F7 B9 ?? ?? ?? ?? 8A 07 47 2C E8 3C 01 77 F7 80 3F ?? 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07 83 C7 05 89 D8 E2 D9 8D BE ?? ?? ?? ?? 8B 07 09 C0 74 45 8B 5F 04 8D 84 30 ?? ?? ?? ?? 01 F3 50 83 C7 08 FF 96 ?? ?? ?? ?? 95 8A 07 47 08 C0 74 DC 89 F9 79 07 0F B7 07 47 50 47 B9 57 48 F2 AE 55 FF 96 ?? ?? ?? ?? 09 C0 74 07 89 03 83 C3 04 EB D8 FF 96 ?? ?? ?? ?? 61 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Intel_DCX_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Intel_DCX_Graphics_format"
        weight = 1
    strings:
        $a = { B1 68 DE 3A 04 10 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DOS16M_DOS_Extender_c_Tenberry_Software_Inc_1987_1995: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DOS16M_DOS_Extender_c_Tenberry_Software_Inc_1987_1995"
        weight = 1
    strings:
        $a = { BF ?? ?? 8E C7 8E D7 BC ?? ?? 36 ?? ?? ?? ?? FF ?? ?? ?? 36 ?? ?? ?? ?? BE ?? ?? AC 8A D8 B7 00 ?? ?? 8B ?? ?? ?? 4F 8E C7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_ASPack_211d_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_ASPack_211d_emadicius"
        weight = 1
    strings:
        $a = { 60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CubiComp_PictureMaker_graphics_format_green: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CubiComp_PictureMaker_graphics_format_green"
        weight = 1
    strings:
        $a = { 26 0C FF 02 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEncrypt_v31: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEncrypt_v31"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? 00 F0 0F C6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UnderGround_Crypter_by_Booster2000: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UnderGround_Crypter_by_Booster2000"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 74 3C 00 11 E8 94 F9 FF FF E8 BF FE FF FF E8 0A F3 FF FF 8B C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule INCrypter_03_INinY_by_z3e_NiFe: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID INCrypter_03_INinY_by_z3e_NiFe"
        weight = 1
    strings:
        $a = { 60 64 A1 30 00 00 00 8B 40 0C 8B 40 0C 8D 58 20 C7 03 00 00 00 00 E8 00 00 00 00 5D 81 ED 4D 16 40 00 8B 9D 0E 17 40 00 64 A1 18 00 00 00 8B 40 30 0F B6 40 02 83 F8 01 75 05 03 DB C1 CB 10 8B 8D 12 17 40 00 8B B5 06 17 40 00 51 81 3E 2E 72 73 72 74 65 8B 85 16 17 40 00 E8 23 00 00 00 8B 85 1A 17 40 00 E8 18 00 00 00 8B 85 1E 17 40 00 E8 0D 00 00 00 8B 85 22 17 40 00 E8 02 00 00 00 EB 18 8B D6 3B 46 0C 72 0A 83 F9 01 74 0B 3B 46 34 72 06 BA 00 00 00 00 C3 58 83 FA 00 75 1A 8B 4E 10 8B 7E 0C 03 BD 02 17 40 00 83 F9 00 74 09 F6 17 31 0F 31 1F 47 E2 F7 59 83 C6 28 49 83 F9 00 75 88 8B 85 0A 17 40 00 89 44 24 1C 61 50 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CrunchPE_v10xx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CrunchPE_v10xx"
        weight = 1
    strings:
        $a = { 55 E8 ?? ?? ?? ?? 5D 83 ED 06 8B C5 55 60 89 AD ?? ?? ?? ?? 2B 85 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 80 BD ?? ?? ?? ?? ?? 75 09 C6 85 }
        $b = { EB 10 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 55 E8 ?? ?? ?? ?? 5D 81 ED 18 ?? ?? ?? 8B C5 55 60 9C 2B 85 E9 06 ?? ?? 89 85 E1 06 ?? ?? FF 74 24 2C E8 BB 01 00 00 0F 82 92 05 00 00 E8 F1 03 00 00 49 0F 88 86 05 00 00 68 6C D9 B2 96 33 C0 50 E8 24 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Thinstall_Embedded_2717_2719_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_2717_2719_Jitit"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 58 BB ?? ?? ?? ?? 2B C3 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 C1 FE FF FF E9 97 FF FF FF CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB A2 B9 01 00 00 00 E8 D0 00 00 00 83 C0 07 89 45 F8 C6 45 F7 00 83 F8 08 74 89 E8 B1 00 00 00 88 45 F7 E9 7C FF FF FF B9 07 00 00 00 E8 AA 00 00 00 50 33 C9 B1 02 E8 A0 00 00 00 8B C8 41 41 58 0B C0 74 04 8B D8 EB 5E 83 F9 02 74 6A 41 E8 88 00 00 00 89 45 FC E9 48 FF FF FF E8 87 00 00 00 49 E2 09 8B C3 E8 7D 00 00 00 EB 3A 49 8B C1 55 8B 4D FC 8B E8 33 C0 D3 E5 E8 5D 00 00 00 0B C5 5D 8B D8 E8 5F 00 00 00 3D 00 00 01 00 73 14 3D FF 37 00 00 73 0E 3D 7F 02 00 00 73 08 83 F8 7F 77 04 41 41 41 41 56 8B F7 2B F0 F3 A4 5E E9 F0 FE FF FF 33 C0 EB 05 8B C7 2B 45 0C 5E 5F 5B C9 C2 08 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_224_StrongbitSoftComplete_Development: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_224_StrongbitSoftComplete_Development"
        weight = 1
    strings:
        $a = { E8 F7 FE FF FF 05 ?? ?? 00 00 FF E0 E8 EB FE FF FF 05 ?? ?? 00 00 FF E0 E8 04 00 00 00 FF FF FF FF 5E C3 }
        $b = { 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 75 73 65 72 33 32 2E 64 6C 6C 00 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule EXE_: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 E4 53 56 57 33 C0 89 45 E4 89 45 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_Full_Edition_117_Ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_Full_Edition_117_Ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 ?? ?? ?? ?? 8D 9D ?? ?? ?? ?? 33 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v4000053_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v4000053_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 20 8B 4B 00 68 80 E4 48 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 53 56 57 89 65 E8 FF 15 88 31 4B 00 33 D2 8A D4 89 15 A4 A1 4B 00 8B C8 81 E1 FF 00 00 00 89 0D A0 A1 4B 00 C1 E1 08 03 CA 89 0D 9C A1 4B 00 C1 E8 10 A3 98 A1 4B 00 33 F6 56 E8 78 16 00 00 59 85 C0 75 08 6A 1C E8 B0 00 00 00 59 89 75 FC E8 43 13 00 00 FF 15 8C 30 4B 00 A3 A4 B7 4B 00 E8 01 12 00 00 A3 F8 A1 4B 00 E8 AA 0F 00 00 E8 EC 0E 00 00 E8 2D FA FF FF 89 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VIRUS_I_WormKLEZ: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VIRUS_I_WormKLEZ"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 40 D2 40 ?? 68 04 AC 40 ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 BC D0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp_ASM: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_dulekxt_Borland_Delphi_Microsoft_Visual_Cpp_ASM"
        weight = 1
    strings:
        $a = { EB 02 CD 20 EB 02 CD 20 EB 02 CD 20 C1 E6 18 BB 80 ?? ?? 00 EB 02 82 B8 EB 01 10 8D 05 F4 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi_v60_KOL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_v60_KOL"
        weight = 1
    strings:
        $a = { 55 89 E5 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 50 ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PC_Shrinker_v045: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PC_Shrinker_v045"
        weight = 1
    strings:
        $a = { ?? BD ?? ?? ?? ?? 01 AD E3 38 40 ?? FF B5 DF 38 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_v13045: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_v13045"
        weight = 1
    strings:
        $a = { E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 ?? ?? ?? ?? ?? ?? ?? 31 C0 89 41 14 89 41 18 80 A1 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v036_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v036_beta_Dwing"
        weight = 1
    strings:
        $a = { BE B0 11 ?? ?? AD 50 FF 76 34 EB 7C 48 01 ?? ?? 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? ?? 00 00 ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 3A 00 04 00 00 00 00 00 00 00 00 ?? ?? ?? 00 02 00 00 00 00 00 00 ?? 00 00 ?? 00 00 10 00 00 ?? ?? 00 00 00 10 00 00 10 00 00 00 00 00 00 0A 00 00 00 00 00 00 00 00 00 00 00 EE ?? ?? ?? 14 00 00 00 00 ?? ?? ?? ?? ?? 00 00 FF 76 38 AD 50 8B 3E BE F0 ?? ?? ?? 6A 27 59 F3 A5 FF 76 04 83 C8 FF 8B DF AB EB 1C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? ?? ?? ?? ?? 00 00 00 40 AB 40 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB 8B 7E 0C 57 51 E9 ?? ?? ?? ?? 56 10 E2 E3 B1 04 D3 E0 03 E8 8D 53 18 33 C0 55 40 51 D3 E0 8B EA 91 FF 56 4C 99 59 D1 E8 13 D2 E2 FA 5D 03 EA 45 59 89 6B 08 56 8B F7 2B F5 F3 A4 AC 5E B1 80 AA 3B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CrypKey_V56X_Kenonic_Controls_Ltd: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CrypKey_V56X_Kenonic_Controls_Ltd"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 00 75 07 6A 00 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule KByS_Packer_v028: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID KByS_Packer_v028"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? 00 E8 01 00 00 00 C3 C3 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DIET_v100d: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DIET_v100d"
        weight = 1
    strings:
        $a = { FC 06 1E 0E 8C C8 01 ?? ?? ?? BA ?? ?? 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_BJFNT_12: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_BJFNT_12"
        weight = 1
    strings:
        $a = { EB 02 69 B1 83 EC 04 EB 03 CD 20 EB EB 01 EB 9C EB 01 EB EB 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_ASProtect: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_ASProtect"
        weight = 1
    strings:
        $a = { 60 90 90 90 90 90 90 5D 90 90 90 90 90 90 90 90 90 90 90 03 DD E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_239_DLL_minimum_protection_wwwstrongbitcom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_239_DLL_minimum_protection_wwwstrongbitcom"
        weight = 1
    strings:
        $a = { 50 68 ?? ?? ?? ?? 58 C1 C0 0F E9 ?? ?? ?? 00 87 04 24 58 89 45 FC E9 ?? ?? ?? FF FF 05 ?? ?? ?? ?? E9 ?? ?? ?? 00 C1 C3 18 E9 ?? ?? ?? ?? 8B 55 08 09 42 F8 E9 ?? ?? ?? FF 83 7D F0 01 0F 85 ?? ?? ?? ?? E9 ?? ?? ?? 00 87 34 24 5E 8B 45 FC 33 D2 56 8B F2 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_vxx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_vxx"
        weight = 1
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB ?? ?? ?? ?? 2B C3 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 2C FF FF FF E9 90 FF FF FF CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v071b2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v071b2"
        weight = 1
    strings:
        $a = { 60 E8 44 11 00 00 C3 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PPC_PROTECT_11X_Alexey_Gorchakov: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PPC_PROTECT_11X_Alexey_Gorchakov"
        weight = 1
    strings:
        $a = { FF 5F 2D E9 20 00 9F E5 00 00 90 E5 18 00 8F E5 18 00 9F E5 00 00 90 E5 10 00 8F E5 01 00 A0 E3 00 00 00 EB 02 00 00 EA 04 F0 1F E5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EmbedPE_v124_cyclotron: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EmbedPE_v124_cyclotron"
        weight = 1
    strings:
        $a = { 83 EC 50 60 68 ?? ?? ?? ?? E8 CB FF 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_Full_Edition_117_DLL_LZMA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_Full_Edition_117_DLL_LZMA"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8D B5 74 1F 00 00 8D 9D 1E 03 00 00 33 FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 0F FF 74 37 04 FF 34 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NFO_v1x_modified: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NFO_v1x_modified"
        weight = 1
    strings:
        $a = { 60 9C 8D 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MEW_11_SE_v12_Northfox: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MEW_11_SE_v12_Northfox"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 02 FA 04 E8 49 00 00 00 69 E8 49 00 00 00 95 E8 4F 00 00 00 68 E8 1F 00 00 00 49 E8 E9 FF FF FF 67 E8 1F 00 00 00 93 E8 31 00 00 00 78 E8 DD FF FF FF 38 E8 E3 FF FF FF 66 E8 0D 00 00 00 04 E8 E3 FF FF FF 70 E8 CB FF FF FF 69 E8 DD FF FF FF 58 E8 DD FF FF FF 69 E8 E3 FF FF FF 79 E8 BF FF FF FF 69 83 C4 40 E8 00 00 00 00 5D 81 ED 9D 11 40 00 8D 95 B4 11 40 00 E8 CB 2E 00 00 33 C0 F7 F0 69 8D B5 05 12 40 00 B9 5D 2E 00 00 8B FE AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MoleBox_v254_Teggo: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MoleBox_v254_Teggo"
        weight = 1
    strings:
        $a = { ?? ?? ?? 00 8B 4D F0 8B 11 89 15 ?? ?? ?? 00 8B 45 FC A3 ?? ?? ?? 00 5F 5E 8B E5 5D C3 CC CC CC E8 EB FB FF FF 58 E8 ?? 07 00 00 58 89 44 24 24 61 58 58 FF D0 E8 ?? ?? 00 00 6A 00 FF 15 ?? ?? ?? 00 CC CC CC CC CC CC CC CC CC CC CC CC CC CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Exe_Shield_27b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Exe_Shield_27b"
        weight = 1
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 45 55 EB 04 B8 EB F9 00 C3 E8 00 00 00 00 5D 81 ED BC 1A 40 00 EB 01 00 8D B5 46 1B 40 00 BA B3 0A 00 00 EB 01 00 8D 8D F9 25 40 00 8B 09 E8 14 00 00 00 83 EB 01 00 8B FE E8 00 00 00 00 58 83 C0 07 50 C3 00 EB 04 58 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Stranik_13_ModulaCPascal: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Stranik_13_ModulaCPascal"
        weight = 1
    strings:
        $a = { E8 ?? ?? FF FF E8 ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Virtualization_Suite_3049_3080_Thinstall_Company: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Virtualization_Suite_3049_3080_Thinstall_Company"
        weight = 1
    strings:
        $a = { 9C 60 68 53 74 41 6C 68 54 68 49 6E E8 00 00 00 00 58 BB 37 1F 00 00 2B C3 50 68 ?? ?? ?? ?? 68 00 2C 00 00 68 04 01 00 00 E8 BA FE FF FF E9 90 FF FF FF CC CC CC CC CC CC CC 55 8B EC 83 C4 F4 FC 53 57 56 8B 75 08 8B 7D 0C C7 45 FC 08 00 00 00 33 DB BA 00 00 00 80 43 33 C0 E8 19 01 00 00 73 0E 8B 4D F8 E8 27 01 00 00 02 45 F7 AA EB E9 E8 04 01 00 00 0F 82 96 00 00 00 E8 F9 00 00 00 73 5B B9 04 00 00 00 E8 05 01 00 00 48 74 DE 0F 89 C6 00 00 00 E8 DF 00 00 00 73 1B 55 BD 00 01 00 00 E8 DF 00 00 00 88 07 47 4D 75 F5 E8 C7 00 00 00 72 E9 5D EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressorProtection_V1601_CGSoftLabsnbsp_nbsp_SignByfly_20080308: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressorProtection_V1601_CGSoftLabsnbsp_nbsp_SignByfly_20080308"
        weight = 1
    strings:
        $a = { EB 01 ?? EB 01 ?? 55 8B EC 83 EC 0C 53 56 57 EB 01 ?? 83 3D ?? ?? ?? ?? ?? 74 08 EB 01 ?? E9 56 01 00 00 EB 02 ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? EB 01 ?? E8 E2 05 00 00 EB 02 ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 59 59 EB 01 ?? EB 02 ?? ?? 68 ?? ?? ?? ?? E8 0E 05 00 00 59 EB 01 ?? 83 65 F4 00 EB 07 8B 45 F4 40 89 45 F4 83 7D F4 61 73 1F EB 02 ?? ?? 8B 45 F4 0F B6 ?? ?? ?? ?? ?? 33 45 F4 8B 4D F4 88 81 ?? ?? ?? ?? EB 01 ?? EB D4 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 83 C4 10 89 45 FC EB 02 ?? ?? 83 7D FC 00 75 0A 6A 00 A1 ?? ?? ?? ?? FF 50 14 EB 01 ?? F3 E8 A0 05 00 00 A1 ?? ?? ?? ?? 05 ?? ?? ?? ?? 89 45 F8 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 FC E8 01 00 00 00 ?? 83 04 24 06 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Packman_v10_Brandon_LaCombe: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Packman_v10_Brandon_LaCombe"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5B 8D 5B C6 01 1B 8B 13 8D 73 14 6A 08 59 01 16 AD 49 75 FA 8B E8 C6 06 E9 8B 43 0C 89 46 01 6A 04 68 00 10 00 00 FF 73 08 51 FF 55 08 8B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FishPE_V11X_hellfish_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FishPE_V11X_hellfish_SignByfly"
        weight = 1
    strings:
        $a = { 50 45 00 00 4C 01 0A 00 19 5E 42 2A 00 00 00 00 00 00 00 00 E0 00 8E 81 0B 01 02 19 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 04 00 00 00 00 00 00 02 00 00 00 00 00 10 00 00 40 00 00 00 00 10 00 00 10 00 00 00 00 00 00 10 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 18 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 20 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 20 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 04 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 00 E0 }
        $b = { 50 45 00 00 4C 01 0A 00 19 5E 42 2A 00 00 00 00 00 00 00 00 E0 00 8E 81 0B 01 02 19 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 10 00 00 00 02 00 00 04 00 00 00 00 00 00 00 04 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Hyings_PE_Armor_076_Hying_CCG: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Hyings_PE_Armor_076_Hying_CCG"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8E 00 00 00 E8 03 00 00 00 EB 01 ?? E8 81 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B7 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AA 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_13: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_13"
        weight = 1
    strings:
        $a = { BE A4 01 40 00 AD 93 AD 97 AD 56 96 B2 80 A4 B6 80 FF 13 73 F9 33 C9 FF 13 73 16 33 C0 FF 13 73 1F B6 80 41 B0 10 FF 13 12 C0 73 FA 75 3C AA EB E0 FF 53 08 02 F6 83 D9 01 75 0E FF 53 04 EB 26 AC D1 E8 74 2F 13 C9 EB 1A 91 48 C1 E0 08 AC FF 53 04 3D 00 7D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_Crypt_102: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_Crypt_102"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Apex_c_beta_500mhz: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Apex_c_beta_500mhz"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? B9 FF FF FF 00 01 D0 F7 E2 72 01 48 E2 F7 B9 FF 00 00 00 8B 34 24 80 36 FD 46 E2 FA C3 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MicroJoiner_16_coban2k: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MicroJoiner_16_coban2k"
        weight = 1
    strings:
        $a = { 33 C0 64 8B 38 48 8B C8 F2 AF AF 8B 1F 66 33 DB 66 81 3B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VProtector_V13X_vcasm_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VProtector_V13X_vcasm_SignByfly"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 47 65 74 50 72 6F 63 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi_Component: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_Component"
        weight = 1
    strings:
        $a = { C3 E9 ?? ?? ?? FF 8D 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXEStealth_275_WebtoolMaster: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXEStealth_275_WebtoolMaster"
        weight = 1
    strings:
        $a = { 33 C9 B4 4E CD 21 73 02 FF ?? BA ?? 00 B8 ?? 3D CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Setup2Go_Installer_Stub: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Setup2Go_Installer_Stub"
        weight = 1
    strings:
        $a = { 5B 53 45 54 55 50 5F 49 4E 46 4F 5D 0D 0A 56 65 72 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1334_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1334_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 29 00 00 00 EB 03 ?? ?? ?? EB 03 ?? ?? ?? 8B ?? 24 0C EB 01 ?? 83 ?? B8 00 00 00 28 EB 03 ?? ?? ?? 33 C0 EB 01 ?? C3 EB 04 ?? ?? ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 04 ?? ?? ?? ?? 50 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? 8B 00 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? E9 FA 00 00 00 EB 03 ?? ?? ?? E8 D5 FF FF FF EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 58 EB 01 ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 04 ?? ?? ?? ?? 83 C4 04 EB 04 ?? ?? ?? ?? E8 2B 27 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1333_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1333_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 01 ?? E8 29 00 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 02 ?? ?? 50 EB 01 ?? 33 C0 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EP_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EP_v10"
        weight = 1
    strings:
        $a = { 50 83 C0 17 8B F0 97 33 C0 33 C9 B1 24 AC 86 C4 AC AA 86 C4 AA E2 F6 00 B8 40 00 03 00 3C 40 D2 33 8B 66 14 50 70 8B 8D 34 02 44 8B 18 10 48 70 03 BA 0C ?? ?? ?? ?? C0 33 FE 8B 30 AC 30 D0 C1 F0 10 C2 D0 30 F0 30 C2 C1 AA 10 42 42 CA C1 E2 04 5F E9 5E B1 C0 30 ?? 68 ?? ?? F3 00 C3 AA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_Pascal_v20_1984: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_Pascal_v20_1984"
        weight = 1
    strings:
        $a = { ?? ?? ?? 90 90 CD AB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 38 34 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Adobe_PhotoShop_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Adobe_PhotoShop_Graphics_format"
        weight = 1
    strings:
        $a = { 38 42 50 53 00 01 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VMProtect_v125_PolyTech: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VMProtect_v125_PolyTech"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 55 50 52 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V010_V012_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V010_V012_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? AD 8B F8 95 A5 33 C0 33 C9 AB 48 AB F7 D8 B1 04 F3 AB C1 E0 0A B5 ?? F3 AB AD 50 97 51 AD 87 F5 58 8D 54 86 5C FF D5 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 ?? B3 00 8D 1C 5B 8D 9C 9E 0C 10 00 00 B0 01 67 E3 29 8B D7 2B 56 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF D5 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 55 CC 33 C9 E9 DF 00 00 00 8B 5E 0C 83 C2 30 FF D5 73 50 83 C2 30 FF D5 72 1B 83 C2 30 FF D5 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 46 0C B1 80 8A 00 EB CF 83 C2 60 FF D5 87 5E 10 73 0D 83 C2 30 FF D5 87 5E 14 73 03 87 5E 18 3C 07 B0 08 72 02 B0 0B 50 53 8D 96 7C 07 00 00 FF 55 D0 5B 91 EB 77 3C 07 B0 07 72 02 B0 0A 50 87 5E 10 87 5E 14 89 5E 18 8D 96 C4 0B 00 00 FF 55 D0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule IDA_Interactive_Disassembler_database: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID IDA_Interactive_Disassembler_database"
        weight = 1
    strings:
        $a = { 49 44 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule JDPack_2x_JDPack: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID JDPack_2x_JDPack"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 68 51 40 00 68 04 25 40 00 64 A1 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Trainer_Creation_Kit_v5_Trainer: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Trainer_Creation_Kit_v5_Trainer"
        weight = 1
    strings:
        $a = { 6A 00 68 80 00 00 00 6A 02 6A 00 6A 00 68 00 00 00 40 68 25 45 40 00 E8 3C 02 00 00 50 6A 00 68 40 45 40 00 68 00 10 00 00 68 00 30 40 00 50 E8 54 02 00 00 58 50 E8 17 02 00 00 6A 00 E8 2E 02 00 00 A3 70 45 40 00 68 25 45 40 00 E8 2B 02 00 00 A3 30 45 40 00 68 34 45 40 00 50 E8 15 02 00 00 6A 00 FF 35 30 45 40 00 50 6A 02 E8 4D 02 00 00 A3 74 45 40 00 6A 00 68 D4 10 40 00 6A 00 6A 01 FF 35 70 45 40 00 E8 02 02 00 00 B3 0A FE CB 74 10 FF 35 74 45 40 00 E8 27 02 00 00 83 F8 00 74 EC B3 0A FE CB 74 10 FF 35 30 45 40 00 E8 B7 01 00 00 83 F8 00 74 EC B3 0A FE CB 74 16 68 25 45 40 00 E8 96 01 00 00 83 F8 00 74 ED 6A 00 E8 90 01 00 00 55 8B EC 56 51 57 8B 45 0C 98 3D 10 01 00 00 0F 85 C7 00 00 00 6A 01 FF 35 70 45 40 00 E8 B0 01 00 00 50 6A 01 68 80 00 00 00 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AntiDote_10_beta_Spy_Instructor: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiDote_10_beta_Spy_Instructor"
        weight = 1
    strings:
        $a = { E8 BB FF FF FF 84 C0 74 2F 68 04 01 00 00 68 C0 23 60 00 6A 00 FF 15 08 10 60 00 E8 40 FF FF FF 50 68 78 11 60 00 68 68 11 60 00 68 C0 23 60 00 E8 AB FD FF FF 83 C4 10 33 C0 C2 10 00 90 90 90 8B 4C 24 08 56 8B 74 24 08 33 D2 8B C6 F7 F1 8B C6 85 D2 74 08 33 D2 F7 F1 40 0F AF C1 5E C3 90 8B 44 24 04 53 55 56 8B 48 3C 57 03 C8 33 D2 8B 79 54 8B 71 38 8B C7 F7 F6 85 D2 74 0C 8B C7 33 D2 F7 F6 8B F8 47 0F AF FE 33 C0 33 DB 66 8B 41 14 8D 54 08 18 33 C0 66 8B 41 06 89 54 24 14 8D 68 FF 85 ED 7C 37 33 C0 8B 4C 24 14 8D 04 80 8B 4C C1 08 85 C9 74 1A 8B C1 33 D2 F7 F6 85 D2 75 04 03 F9 EB 0C 8B C1 33 D2 F7 F6 40 0F AF C6 03 F8 43 8B C3 25 FF FF 00 00 3B C5 7E CB 8B C7 5F 5E 5D 5B C3 90 90 90 90 90 90 90 90 90 90 90 90 55 8B EC 6A FF 68 50 22 60 00 64 A1 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule REC_v034_3: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID REC_v034_3"
        weight = 1
    strings:
        $a = { 06 1E B4 30 CD 21 3C 02 73 ?? 33 C0 06 50 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MEW_11_SE_11_Northfox: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MEW_11_SE_11_Northfox"
        weight = 1
    strings:
        $a = { E9 ?? ?? ?? ?? 00 00 00 02 00 00 00 0C 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Exe_Stealth_275a_WebtoolMaster: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Exe_Stealth_275a_WebtoolMaster"
        weight = 1
    strings:
        $a = { EB 58 53 68 61 72 65 77 61 72 65 2D 56 65 72 73 69 6F 6E 20 45 78 65 53 74 65 61 6C 74 68 2C 20 63 6F 6E 74 61 63 74 20 73 75 70 70 6F 72 74 40 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 00 90 60 90 E8 00 00 00 00 5D 81 ED F7 27 40 00 B9 15 00 00 00 83 C1 04 83 C1 01 EB 05 EB FE 83 C7 56 EB 00 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9 96 0C 00 00 90 8D BD 74 28 40 00 8B F7 AC }
        $b = { EB 00 EB 17 53 68 61 72 65 77 61 72 65 20 2D 20 45 78 65 53 74 65 61 6C 74 68 00 60 90 E8 00 00 00 00 5D 81 ED C4 27 40 00 B9 15 00 00 00 83 C1 04 83 C1 01 EB 05 EB FE 83 C7 56 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule SimplePack_111_Method_2NT_bagieTMX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimplePack_111_Method_2NT_bagieTMX"
        weight = 1
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 89 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 40 00 00 C0 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 EB 01 CD 64 A1 30 00 00 00 EB 01 CD 8B 48 0C E3 6F EB 01 CD 05 AC 00 00 00 EB 01 CD 66 81 38 93 08 EB 01 CD 75 0A EB 01 CD B8 38 FF FF FF EB 14 EB 01 CD 66 81 38 28 0A 75 4A EB 01 CD B8 1A FF FF FF EB 00 EB 01 CD 31 C9 EB 01 CD 51 EB 01 CD 51 EB 01 CD 6A 11 EB 01 CD 6A FE EB 01 CD E8 03 00 00 00 EB 01 CD 83 04 24 18 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ATT_Group_4_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ATT_Group_4_Graphics_format"
        weight = 1
    strings:
        $a = { 01 00 ?? 00 3A 03 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_34_North_Star: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_34_North_Star"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 85 ?? ?? FF FF 80 38 01 0F 84 42 02 00 00 C6 00 01 8B D5 2B 95 ?? ?? FF FF 89 95 ?? ?? FF FF 01 95 ?? ?? FF FF 8D B5 ?? ?? FF FF 01 16 60 6A 40 68 00 10 00 00 68 00 10 00 00 6A 00 FF 95 ?? ?? FF FF 85 C0 0F 84 6A 03 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule bambam_V001_bedrock: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID bambam_V001_bedrock"
        weight = 1
    strings:
        $a = { 6A 14 E8 9A 05 00 00 8B D8 53 68 ?? ?? ?? ?? E8 6C FD FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_224_StrongbitSoftComplete_Development_h3: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_224_StrongbitSoftComplete_Development_h3"
        weight = 1
    strings:
        $a = { 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_C_Borland_Builder: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_C_Borland_Builder"
        weight = 1
    strings:
        $a = { 3B CF 76 05 2B CF FC F3 AA 59 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_224_StrongbitSoftComplete_Development_h1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_224_StrongbitSoftComplete_Development_h1"
        weight = 1
    strings:
        $a = { 06 8C C8 8E C0 BE ?? ?? 26 ?? ?? 34 ?? 26 ?? ?? 46 81 ?? ?? ?? 75 ?? 40 B3 ?? B3 ?? F3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Enigma_protector_v102_Vladimir_Sukhov_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Enigma_protector_v102_Vladimir_Sukhov_h"
        weight = 1
    strings:
        $a = { 55 53 20 50 54 4F 20 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_V540_Silicon_Realms_Toolworks_SignByfly_20080214: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_V540_Silicon_Realms_Toolworks_SignByfly_20080214"
        weight = 1
    strings:
        $a = { E8 93 3E 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 B4 1F 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 AF 1D 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 40 1D 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? ?? 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 C1 1B 00 00 59 89 7D FC FF 75 08 E8 B1 46 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 86 D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 C4 FA FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 67 1A 00 00 59 C3 }
        $b = { E8 93 3E 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 B4 1F 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 AF 1D 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 40 1D 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Hitachi_Raster_Format_graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Hitachi_Raster_Format_graphics_format"
        weight = 1
    strings:
        $a = { 43 41 44 43 2F 4B 52 20 52 53 54 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UNITA3_tm_by_Sanitary_Equipment_Research: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UNITA3_tm_by_Sanitary_Equipment_Research"
        weight = 1
    strings:
        $a = { E8 ?? ?? 4D 5A 3E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Code_Virtualizer_1310_Oreans_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Code_Virtualizer_1310_Oreans_Technologies"
        weight = 1
    strings:
        $a = { 60 9C FC E8 00 00 00 00 5F 81 EF ?? ?? ?? ?? 8B C7 81 C7 ?? ?? ?? ?? 3B 47 2C 75 02 EB 2E 89 47 2C B9 A7 00 00 00 EB 05 01 44 8F ?? 49 0B C9 75 F7 83 7F 40 00 74 15 8B 77 40 03 F0 EB 09 8B 1E 03 D8 01 03 83 C6 04 83 3E 00 75 F2 8B 74 24 24 8B DE 03 F0 B9 01 00 00 00 33 C0 F0 0F B1 4F 30 75 F7 AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Enigma_protector_110111_Vladimir_Sukhov: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Enigma_protector_110111_Vladimir_Sukhov"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 83 ED 06 81 ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 C0 C3 83 C0 08 EB 02 FF 15 89 C4 61 EB 2E EA EB 2B 83 04 24 03 EB 01 00 31 C0 EB 01 85 64 FF 30 EB 01 83 64 89 20 EB 02 CD 20 89 00 9A 64 8F 05 00 00 00 00 EB 02 C1 90 58 61 EB 01 3E EB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 01 E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 05 F6 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 B9 3D 1A }
        $b = { 60 E8 00 00 00 00 5D 83 ED 06 81 ED ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 9A 83 C4 04 EB 02 FF 35 60 E8 24 00 00 00 00 00 FF EB 02 CD 20 8B 44 24 0C 83 80 B8 00 00 00 03 31 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ExeJoiner_10_Yoda_f2f: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeJoiner_10_Yoda_f2f"
        weight = 1
    strings:
        $a = { 68 00 10 40 00 68 04 01 00 00 E8 39 03 00 00 05 00 10 40 00 C6 00 5C 68 04 01 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_102b_or_10803: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_102b_or_10803"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PseudoSigner_01_Borland_Delphi_50_KOLMCK: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PseudoSigner_01_Borland_Delphi_50_KOLMCK"
        weight = 1
    strings:
        $a = { 55 8B EC 90 90 90 90 68 ?? ?? ?? ?? 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 FF 90 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 EB 04 00 00 00 01 90 90 90 90 90 90 90 00 01 90 90 90 90 90 90 90 90 90 90 90 EB 08 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 08 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 08 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0E 00 90 90 90 90 90 00 00 00 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 EB 0A 00 00 00 90 90 90 90 90 00 00 00 01 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_TravJack883: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_TravJack883"
        weight = 1
    strings:
        $a = { EB ?? 9C 9E 26 ?? ?? 51 04 ?? 7D ?? 00 ?? 2E ?? ?? ?? ?? 8C C8 8E C0 8E D8 80 ?? ?? ?? ?? 74 ?? 8A ?? ?? ?? BB ?? ?? 8A ?? 32 C2 88 ?? FE C2 43 81 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_REALBasic: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_REALBasic"
        weight = 1
    strings:
        $a = { 55 89 E5 90 90 90 90 90 90 90 90 90 90 50 90 90 90 90 90 00 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FakeNinja_v28_Anti_Debug_Spirit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FakeNinja_v28_Anti_Debug_Spirit"
        weight = 1
    strings:
        $a = { 64 A1 18 00 00 00 EB 02 C3 11 8B 40 30 EB 01 0F 0F B6 40 02 83 F8 01 74 FE EB 01 E8 90 C0 FF FF EB 03 BD F4 B5 64 A1 30 00 00 00 0F B6 40 02 74 01 BA 74 E0 50 00 64 A1 30 00 00 00 83 C0 68 8B 00 EB 00 83 F8 70 74 CF EB 02 EB FE 90 90 90 0F 31 33 C9 03 C8 0F 31 2B C1 3D FF 0F 00 00 73 EA E8 08 00 00 00 C1 3D FF 0F 00 00 74 AA EB 07 E8 8B 40 30 EB 08 EA 64 A1 18 00 00 00 EB F2 90 90 90 BA ?? ?? ?? ?? FF E2 64 11 40 00 FF 35 84 11 40 00 E8 40 11 00 00 6A 00 6A 00 FF 35 70 11 40 00 FF 35 84 11 40 00 E8 25 11 00 00 FF }
        $b = { 64 A1 18 00 00 00 EB 02 C3 11 8B 40 30 EB 01 0F 0F B6 40 02 83 F8 01 74 FE EB 01 E8 90 C0 FF FF EB 03 BD F4 B5 64 A1 30 00 00 00 0F B6 40 02 74 01 BA 74 E0 50 00 64 A1 30 00 00 00 83 C0 68 8B 00 EB 00 83 F8 70 74 CF EB 02 EB FE 90 90 90 0F 31 33 C9 03 C8 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PESpin_03_Cyberbob_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_03_Cyberbob_h"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPack_14_by_North_Star_Liu_Xing_Ping: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPack_14_by_North_Star_Liu_Xing_Ping"
        weight = 1
    strings:
        $a = { 8B DF 83 3F 00 75 0A 83 C7 04 B9 00 00 00 00 EB 16 B9 01 00 00 00 03 3B 83 C3 04 83 3B 00 74 2D 01 13 8B 33 03 7B 04 57 51 52 53 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PRO_MIDI_Music_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PRO_MIDI_Music_file"
        weight = 1
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 52 4D 49 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule STUD_RC4_10_Jamie_Edition_ScanTime_UnDetectable_by_MarjinZ: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID STUD_RC4_10_Jamie_Edition_ScanTime_UnDetectable_by_MarjinZ"
        weight = 1
    strings:
        $a = { 68 2C 11 40 00 E8 F0 FF FF FF 00 00 00 00 00 00 30 00 00 00 38 00 00 00 00 00 00 00 37 BB 71 EC A4 E1 98 4C 9B FE 8F 0F FA 6A 07 F6 00 00 00 00 00 00 01 00 00 00 20 20 46 6F 72 20 73 74 75 64 00 20 54 6F 00 00 00 00 06 00 00 00 CC 1A 40 00 07 00 00 00 D4 18 40 00 07 00 00 00 7C 18 40 00 07 00 00 00 2C 18 40 00 07 00 00 00 E0 17 40 00 56 42 35 21 F0 1F 2A 00 00 00 00 00 00 00 00 00 00 00 00 00 7E 00 00 00 00 00 00 00 00 00 00 00 00 00 0A 00 09 04 00 00 00 00 00 00 E8 13 40 00 F4 13 40 00 00 F0 30 00 00 FF FF FF 08 00 00 00 01 00 00 00 00 00 00 00 E9 00 00 00 04 11 40 00 04 11 40 00 C8 10 40 00 78 00 00 00 7C 00 00 00 81 00 00 00 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 61 61 61 00 53 74 75 64 00 00 73 74 75 64 00 00 01 00 01 00 30 16 40 00 00 00 00 00 FF FF FF FF FF FF FF FF 00 00 00 00 B4 16 40 00 10 30 40 00 07 00 00 00 24 12 40 00 0E 00 20 00 00 00 00 00 1C 9E 21 00 EC 11 40 00 5C 10 40 00 E4 1A 40 00 2C 34 40 00 68 17 40 00 58 17 40 00 78 17 40 00 8C 17 40 00 8C 10 40 00 62 10 40 00 92 10 40 00 F8 1A 40 00 24 19 40 00 98 10 40 00 9E 10 40 00 77 04 18 FF 04 1C FF 05 00 00 24 01 00 0D 14 00 78 1C 40 00 48 21 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Anslym_Crypter: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Anslym_Crypter"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 56 B8 38 17 05 10 E8 5A 45 FB FF 33 C0 55 68 21 1C 05 10 64 FF 30 64 89 20 EB 08 FC FC FC FC FC FC 27 54 E8 85 4C FB FF 6A 00 E8 0E 47 FB FF 6A 0A E8 27 49 FB FF E8 EA 47 FB FF 6A 0A 68 30 1C 05 10 A1 60 56 05 10 50 E8 68 47 FB FF 8B D8 85 DB 0F 84 B6 02 00 00 53 A1 60 56 05 10 50 E8 F2 48 FB FF 8B F0 85 F6 0F 84 A0 02 00 00 E8 F3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Enigma_Protector_131_Build_20070615_Dll_Sukhov_Vladimir_Serge_N_Markin: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Enigma_Protector_131_Build_20070615_Dll_Sukhov_Vladimir_Serge_N_Markin"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 81 ED ?? ?? ?? ?? E9 49 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 8A 84 24 28 00 00 00 80 F8 01 0F 84 07 00 00 00 B8 ?? ?? ?? ?? FF E0 E9 04 00 00 00 ?? ?? ?? ?? B8 ?? ?? ?? ?? 03 C5 81 C0 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 30 10 40 49 0F 85 F6 FF FF FF E9 04 00 00 00 }
        $b = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 81 ED ?? ?? ?? ?? E9 49 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PluginToExe_v101_BoB_BobSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PluginToExe_v101_BoB_BobSoft"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 29 C0 5D 81 ED C6 41 40 00 50 8F 85 71 40 40 00 50 FF 95 A5 41 40 00 89 85 6D 40 40 00 FF 95 A1 41 40 00 50 FF 95 B5 41 40 00 80 38 00 74 16 8A 08 80 F9 22 75 07 50 FF 95 B9 41 40 00 89 85 75 40 40 00 EB 6C 6A 01 8F 85 71 40 40 00 6A 58 6A 40 FF 95 A9 41 40 00 89 85 69 40 40 00 89 C7 68 00 08 00 00 6A 40 FF 95 A9 41 40 00 89 47 1C C7 07 58 00 00 00 C7 47 20 00 08 00 00 C7 47 18 01 00 00 00 C7 47 34 04 10 88 00 8D 8D B9 40 40 00 89 4F 0C 8D 8D DB 40 40 00 89 4F 30 FF B5 69 40 40 00 FF 95 95 41 40 00 FF 77 1C 8F 85 75 40 40 00 8B 9D 6D 40 40 00 60 6A 00 6A 01 53 81 C3 ?? ?? ?? 00 FF D3 61 6A 00 68 44 69 45 50 FF B5 75 40 40 00 6A 00 81 C3 ?? ?? 00 00 FF D3 83 C4 10 83 BD 71 40 40 00 00 74 10 FF 77 1C FF 95 AD 41 40 00 57 FF 95 AD 41 40 00 6A 00 FF 95 9D 41 40 00 }
        $b = { E8 00 00 00 00 29 C0 5D 81 ED C6 41 40 00 50 8F 85 71 40 40 00 50 FF 95 A5 41 40 00 89 85 6D 40 40 00 FF 95 A1 41 40 00 50 FF 95 B5 41 40 00 80 38 00 74 16 8A 08 80 F9 22 75 07 50 FF 95 B9 41 40 00 89 85 75 40 40 00 EB 6C 6A 01 8F 85 71 40 40 00 6A 58 6A }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_02_VOB_ProtectCD_5: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_VOB_ProtectCD_5"
        weight = 1
    strings:
        $a = { 36 3E 26 8A C0 60 E8 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Windows_Icon_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Windows_Icon_Graphics_format"
        weight = 1
    strings:
        $a = { 00 00 01 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi_v50_KOLMCK: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_v50_KOLMCK"
        weight = 1
    strings:
        $a = { 55 8B EC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v071: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v071"
        weight = 1
    strings:
        $a = { 60 E8 ED 10 00 00 C3 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule tElock_v070: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID tElock_v070"
        weight = 1
    strings:
        $a = { 60 E8 BD 10 00 00 C3 83 E2 00 F9 75 FA 70 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_MSVCpp_DLL_Method_4_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_MSVCpp_DLL_Method_4_emadicius"
        weight = 1
    strings:
        $a = { 55 8B EC 53 8B 5D 08 56 8B 75 0C 5E 5B 5D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Thinstall_Embedded_19X_Jitit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Thinstall_Embedded_19X_Jitit"
        weight = 1
    strings:
        $a = { 55 8B EC 51 53 56 57 6A 00 6A 00 FF 15 ?? ?? ?? ?? 50 E8 87 FC FF FF 59 59 A1 ?? ?? ?? ?? 8B 40 10 03 05 ?? ?? ?? ?? 89 45 FC 8B 45 FC FF E0 5F 5E 5B C9 C3 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SDProtect_Randy_Li: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SDProtect_Randy_Li"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 01 00 00 00 FF 15 A0 91 40 00 E8 DB FE FF FF 55 89 E5 53 83 EC 14 8B 45 08 8B 00 8B 00 3D 91 00 00 C0 77 3B 3D 8D 00 00 C0 72 4B BB 01 00 00 00 C7 44 24 04 00 00 00 00 C7 04 24 08 00 00 00 E8 CE 24 00 00 83 F8 01 0F 84 C4 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v252b2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v252b2"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 B0 ?? ?? ?? 68 60 ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? 83 EC 58 53 56 57 89 65 E8 FF 15 24 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PECompact_v140b2_v140b4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PECompact_v140b2_v140b4"
        weight = 1
    strings:
        $a = { EB 06 68 ?? ?? ?? ?? C3 9C 60 E8 02 ?? ?? ?? 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 0F A0 40 ?? 87 DD 8B 85 A6 A0 40 ?? 01 85 03 A0 40 ?? 66 C7 85 ?? A0 40 ?? 90 90 01 85 9E A0 40 ?? BB 86 11 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimplePack_V11X_Method1_bagie: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimplePack_V11X_Method1_bagie"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5B 8D 5B FA BD ?? ?? ?? ?? 8B 7D 3C 8D 74 3D 00 8D BE F8 00 00 00 0F B7 76 06 4E 8B 47 10 09 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AntiDote_1214_SE_DLL_SIS_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiDote_1214_SE_DLL_SIS_Team"
        weight = 1
    strings:
        $a = { EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 08 32 90 90 90 90 90 90 90 90 90 90 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF EB 0B 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 ?? 75 ?? 8B 1E 83 EE FC 11 DB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Ding_Boys_PE_lock_Phantasm_v10_v11: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Ding_Boys_PE_lock_Phantasm_v10_v11"
        weight = 1
    strings:
        $a = { 55 57 56 52 51 53 66 81 C3 EB 02 EB FC 66 81 C3 EB 02 EB FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NX_PE_Packer_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NX_PE_Packer_v10"
        weight = 1
    strings:
        $a = { FF 60 FF CA FF 00 BA DC 0D E0 40 00 50 00 60 00 70 00 80 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_301_350a_Silicon_Realms_Toolworks: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_301_350a_Silicon_Realms_Toolworks"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 ?? 87 DB 7A F0 ?? ?? 61 50 51 EB 0F ?? EB 0F ?? EB 07 ?? EB 0F ?? EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC ?? 59 58 60 9C 33 C0 E8 09 00 00 00 E8 E8 23 00 00 00 7A 23 ?? 8B 04 24 EB 03 7A 29 ?? C6 00 90 C3 ?? 70 F0 87 D2 71 07 ?? ?? 40 8B DB 7A 11 EB 08 ?? EB F7 EB C3 ?? 7A E9 70 DA 7B D1 71 F3 ?? 7B F3 71 D6 ?? 9D 61 83 ED 06 33 FF 47 60 33 C9 75 02 EB 15 ?? 33 C9 75 18 7A 0C 70 0E EB 0D ?? 72 0E 79 F1 ?? ?? ?? 79 09 74 F0 EB 87 ?? 7A F0 ?? ?? 61 8B 9C BD B8 43 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_11_BasicEdition_ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_11_BasicEdition_ap0x"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 4A 02 00 00 8D 9D 11 01 00 00 33 FF EB 0F FF 74 37 04 FF 34 37 FF D3 83 C4 08 83 C7 08 83 3C 37 00 75 EB 8D 74 37 04 53 6A 40 68 00 10 00 00 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unknown_SFX_Archive_IDSKA32: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_SFX_Archive_IDSKA32"
        weight = 1
    strings:
        $a = { 69 64 73 6B 61 33 32 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPolyX_04_by_delikon: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPolyX_04_by_delikon"
        weight = 1
    strings:
        $a = { 55 8B EC ?? ?? ?? ?? ?? ?? 59 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 E9 ?? E2 ?? C3 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_V22006710_WFS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_V22006710_WFS"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 73 01 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimplePack_V1X_Method2_bagie: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimplePack_V1X_Method2_bagie"
        weight = 1
    strings:
        $a = { 4D 5A 90 EB 01 00 52 E9 8A 01 00 00 50 45 00 00 4C 01 02 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 00 0F 03 0B 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 0C 00 00 00 00 ?? ?? ?? 00 10 00 00 00 02 00 00 01 00 00 00 00 00 00 00 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v300a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v300a"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 50 51 EB 0F B9 EB 0F B8 EB 07 B9 EB 0F 90 EB 08 FD EB 0B F2 EB F5 EB F6 F2 EB 08 FD EB E9 F3 EB E4 FC E9 59 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_PE_Protect_09: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_PE_Protect_09"
        weight = 1
    strings:
        $a = { 52 51 55 57 64 67 A1 30 00 85 C0 78 0D E8 07 00 00 00 58 83 C0 07 C6 90 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MS_Run_Time_Library_1990_1992_09: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MS_Run_Time_Library_1990_1992_09"
        weight = 1
    strings:
        $a = { B4 30 CD 21 3C 02 73 ?? C3 8C DF 8B 36 ?? ?? 2E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vterminal_V10X_Lei_Peng: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vterminal_V10X_Lei_Peng"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 58 05 ?? ?? ?? ?? 9C 50 C2 04 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nSPack_1x2x_North_StarLiu_Xing_Ping: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nSPack_1x2x_North_StarLiu_Xing_Ping"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D B8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EPExE_Pack_V14_lite_final_6aHguT_g_l_u_k: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EPExE_Pack_V14_lite_final_6aHguT_g_l_u_k"
        weight = 1
    strings:
        $a = { 90 90 90 90 61 B8 ?? ?? ?? ?? FF E0 55 8B EC 60 55 8B 75 08 8B 7D 0C E8 02 00 00 00 EB 04 8B 1C 24 C3 81 C3 00 02 00 00 53 57 8B 07 89 03 83 C7 04 83 C3 04 4E 75 F3 5F 5E FC B2 80 8A 06 46 88 07 47 02 D2 75 05 8A 16 46 12 D2 73 EF 02 D2 75 05 8A 16 46 12 D2 73 4A 33 C0 02 D2 75 05 8A 16 46 12 D2 0F 83 D6 00 00 00 02 D2 75 05 8A 16 46 12 D2 13 C0 02 D2 75 05 8A 16 46 12 D2 13 C0 02 D2 75 05 8A 16 46 12 D2 13 C0 02 D2 75 05 8A 16 46 12 D2 13 C0 74 06 57 2B F8 8A 07 5F 88 07 47 EB A0 B8 01 00 00 00 02 D2 75 05 8A 16 46 12 D2 13 C0 02 D2 75 05 8A 16 46 12 D2 72 EA 83 E8 02 75 28 B9 01 00 00 00 02 D2 75 05 8A 16 46 12 D2 13 C9 02 D2 75 05 8A 16 46 12 D2 72 EA 56 8B F7 2B F5 F3 A4 5E E9 58 FF FF FF 48 C1 E0 08 8A 06 46 8B E8 B9 01 00 00 00 02 D2 75 05 8A 16 46 12 D2 13 C9 02 D2 75 05 8A 16 46 12 D2 72 EA 3D 00 7D 00 00 73 1A 3D 00 05 00 00 72 0E 41 56 8B F7 2B F0 F3 A4 5E E9 18 FF FF FF 83 F8 7F 77 03 83 C1 02 56 8B F7 2B F0 F3 A4 5E E9 03 FF FF FF 8A 06 46 33 C9 C0 E8 01 74 12 83 D1 02 8B E8 56 8B F7 2B F0 F3 A4 5E E9 E7 FE FF FF 5D 2B 7D 0C 89 7D FC 61 5D C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Shield_v01b_v03b_v03_SMoKE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Shield_v01b_v03b_v03_SMoKE"
        weight = 1
    strings:
        $a = { E8 04 00 00 00 83 60 EB 0C 5D EB 05 }
        $b = { EB 06 68 40 85 06 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 00 87 DD 8B 85 E6 90 40 00 01 85 33 90 40 00 66 C7 85 30 90 40 00 90 90 01 85 DA 90 40 00 01 85 DE 90 40 00 01 85 E2 90 40 00 BB 7B 11 00 00 03 9D EA 90 40 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Apex_30_alpha_500mhz: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Apex_30_alpha_500mhz"
        weight = 1
    strings:
        $a = { 5F B9 14 00 00 00 51 BE 00 10 40 00 B9 00 ?? ?? 00 8A 07 30 06 46 E2 FB 47 59 E2 EA 68 ?? ?? ?? 00 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V022_V023_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V022_V023_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { 6A 07 BE ?? ?? ?? ?? AD 8B F8 59 95 F3 A5 AD ?? ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 59 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF ?? ?? ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 01 E3 29 8B D7 2B 55 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 56 08 33 C9 E9 07 01 00 00 8B 5D 0C 83 C2 30 FF 16 73 53 83 C2 30 FF 16 72 1B 83 C2 30 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 45 0C B1 80 8A 00 EB CF 83 C2 60 FF 16 87 5D 10 73 0D 83 C2 30 FF 16 87 5D 14 73 03 87 5D 18 3C 07 B0 08 72 02 B0 0B 50 53 8D 95 7C 07 00 00 FF 56 0C 5B 91 E9 9C 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AVPACK_v120: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AVPACK_v120"
        weight = 1
    strings:
        $a = { 50 1E 0E 1F 16 07 33 F6 8B FE B9 ?? ?? FC F3 A5 06 BB ?? ?? 53 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_Install_System_20_RC2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_Install_System_20_RC2"
        weight = 1
    strings:
        $a = { 83 EC 0C 53 56 57 FF 15 20 71 40 00 05 E8 03 00 00 BE 60 FD 41 00 89 44 24 10 B3 20 FF 15 28 70 40 00 68 00 04 00 00 FF 15 28 71 40 00 50 56 FF 15 08 71 40 00 80 3D 60 FD 41 00 22 75 08 80 C3 02 BE 61 FD 41 00 8A 06 8B 3D F0 71 40 00 84 C0 74 0F 3A C3 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v60_Debug_Version: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v60_Debug_Version"
        weight = 1
    strings:
        $a = { 55 8B EC 51 ?? ?? ?? 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 10 ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule USSR_V031_SpiritST: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID USSR_V031_SpiritST"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 2E 55 53 53 52 00 00 00 00 10 00 00 ?? ?? ?? ?? 00 10 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 C0 2E 55 53 53 52 00 00 00 00 10 00 00 ?? ?? ?? ?? 00 10 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule MicroJoiner_17_coban2k: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MicroJoiner_17_coban2k"
        weight = 1
    strings:
        $a = { BF 00 10 40 00 8D 5F 21 6A 0A 58 6A 04 59 60 57 E8 8E 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Erdas_LANGIS_Image_graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Erdas_LANGIS_Image_graphics_format"
        weight = 1
    strings:
        $a = { 48 45 41 44 37 34 00 00 03 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXELOCK_666_15: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXELOCK_666_15"
        weight = 1
    strings:
        $a = { BA ?? ?? BF ?? ?? EB ?? EA ?? ?? ?? ?? 79 ?? 7F ?? 7E ?? 1C ?? 48 78 ?? E3 ?? 45 14 ?? 5A E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_110_Eng_bartxt: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_110_Eng_bartxt"
        weight = 1
    strings:
        $a = { BB D0 01 40 00 BF 00 10 40 00 BE ?? ?? ?? 00 53 E8 0A 00 00 00 02 D2 75 05 8A 16 46 12 D2 C3 FC B2 80 A4 6A 02 5B FF 14 24 73 F7 33 C9 FF 14 24 73 18 33 C0 FF 14 24 73 21 B3 02 41 B0 10 FF 14 24 12 C0 73 F9 75 3F AA EB DC E8 43 00 00 00 2B CB 75 10 E8 38 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v211d: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v211d"
        weight = 1
    strings:
        $a = { 60 E8 02 00 00 00 CD 20 E8 00 00 00 00 5E 2B C9 58 74 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi_3_Portions_Copyright_c_198396_Borland_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_3_Portions_Copyright_c_198396_Borland_h"
        weight = 1
    strings:
        $a = { 50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 38 33 2C 39 36 20 42 6F 72 6C 61 6E 64 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule E_language: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID E_language"
        weight = 1
    strings:
        $a = { E8 06 00 00 00 50 E8 ?? 01 00 00 55 8B EC 81 C4 F0 FE FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1363_Obsidium_Softwarenbsp_nbsp_SignByfly_20080730: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1363_Obsidium_Softwarenbsp_nbsp_SignByfly_20080730"
        weight = 1
    strings:
        $a = { EB 03 ?? ?? ?? 50 EB 04 ?? ?? ?? ?? E8 ?? 00 00 00 EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 03 ?? ?? ?? 83 82 B8 00 00 00 26 EB 03 ?? ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 03 ?? ?? ?? EB 02 ?? ?? 33 C0 EB 02 ?? ?? 64 FF 30 EB 01 ?? 64 89 20 EB 01 ?? EB 02 ?? ?? 8B 00 EB 03 ?? ?? ?? C3 EB 04 ?? ?? ?? ?? E9 ?? 00 00 00 EB 03 ?? ?? ?? E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v211b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v211b"
        weight = 1
    strings:
        $a = { 60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 E9 3D 04 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v211c: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v211c"
        weight = 1
    strings:
        $a = { 60 E8 02 00 00 00 EB 09 5D 55 81 ED 39 39 44 00 C3 E9 59 04 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Crypto_Lock_v202_Eng_Ryan_Thian: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Crypto_Lock_v202_Eng_Ryan_Thian"
        weight = 1
    strings:
        $a = { 60 BE 15 90 40 00 8D BE EB 7F FF FF 57 83 CD FF EB 10 90 90 90 90 90 90 8A 06 46 88 07 47 01 DB 75 07 8B 1E 83 EE FC 11 DB 72 ED B8 01 00 00 00 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C0 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 31 C9 83 E8 03 72 0D C1 E0 08 8A 06 46 83 F0 FF 74 74 89 C5 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 75 20 41 01 DB 75 07 8B 1E 83 EE FC 11 DB 11 C9 01 DB 73 EF 75 09 8B 1E 83 EE FC 11 DB 73 E4 83 C1 02 81 FD 00 F3 FF FF 83 D1 01 8D 14 2F 83 FD FC 76 0F 8A 02 42 88 07 47 49 75 F7 E9 63 FF FF FF 90 8B 02 83 C2 04 89 07 83 C7 04 83 E9 04 77 F1 01 CF E9 4C FF FF FF 5E 89 F7 B9 55 00 00 00 8A 07 47 2C E8 3C 01 77 F7 80 3F 01 75 F2 8B 07 8A 5F 04 66 C1 E8 08 C1 C0 10 86 C4 29 F8 80 EB E8 01 F0 89 07 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Pelles_C_450_DLL_X86_CRT_LIB: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pelles_C_450_DLL_X86_CRT_LIB"
        weight = 1
    strings:
        $a = { 55 89 E5 53 56 57 8B 5D 0C 8B 75 10 85 DB 75 0D 83 3D ?? ?? ?? ?? 00 75 04 31 C0 EB 57 83 FB 01 74 05 83 FB 02 75 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PCrypt_v351: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PCrypt_v351"
        weight = 1
    strings:
        $a = { 50 43 52 59 50 54 FF 76 33 2E 35 31 00 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_FullEdition_V120_aPlib_043_ap0x_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_FullEdition_V120_aPlib_043_ap0x_SignByfly"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 10 00 00 08 00 00 00 }
        $b = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 47 65 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_01_CD_Cops_II: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_CD_Cops_II"
        weight = 1
    strings:
        $a = { 53 60 BD 90 90 90 90 8D 45 90 8D 5D 90 E8 00 00 00 00 8D 01 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Lockless_Intro_Pack: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Lockless_Intro_Pack"
        weight = 1
    strings:
        $a = { B8 00 30 CD 21 3C 03 73 ?? 0E 1F BA ?? ?? B4 09 CD 21 06 33 C0 50 CB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vcasm_Protector_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vcasm_Protector_10"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? 00 68 ?? ?? ?? 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 03 00 00 00 C7 84 00 58 EB 01 E9 83 C0 07 50 C3 FF 35 E8 07 00 00 00 C7 83 83 C0 13 EB 0B 58 EB 02 CD 20 83 C0 02 EB 01 E9 50 C3 E8 B9 04 00 00 00 E8 1F 00 00 00 EB FA E8 16 00 00 00 E9 EB F8 00 00 58 EB 09 0F 25 E8 F2 FF FF FF 0F B9 49 75 F1 EB 05 EB F9 EB F0 D6 EB 01 0F 31 F0 EB 0C 33 C8 EB 03 EB 09 0F 59 74 05 75 F8 51 EB F1 E8 16 00 00 00 8B 5C 24 0C 8B A3 C4 00 00 00 64 8F 05 00 00 00 00 83 C4 04 EB 14 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 33 C9 99 F7 F1 E9 E8 05 00 00 00 0F 01 EB 05 E8 EB FB 00 00 83 C4 04 B9 04 00 00 00 E8 1F 00 00 00 EB FA E8 16 00 00 00 E9 EB F8 00 00 58 EB 09 0F 25 E8 F2 FF FF FF 0F B9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Enigma_protector_110_unregistered: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Enigma_protector_110_unregistered"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 1B 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
        $b = { 60 72 80 72 88 72 8C 72 90 72 94 72 98 72 9C 72 A0 72 A4 59 A8 B0 5C E8 39 D5 39 E4 39 F1 31 F9 5C 3D 58 CA 5F 56 B1 2D 20 7A 2E 30 16 32 72 2B 72 36 1C A5 33 A9 9C AD 9C B1 9C B5 9C B9 9C BD 9C C1 9C C5 9C C9 9C CD 9C D1 9C D5 9C D9 9C DD 9C E1 9C E5 89 E9 51 0B C4 80 BC 7E 35 09 37 E7 C9 3D C9 45 C9 4D 74 92 BA E4 E9 24 6B DF 3E 0E 38 0C 49 10 27 80 51 A1 8E 3A A3 C8 AE 3B 1C 35 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule ROD_High_TECH_Ayman: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ROD_High_TECH_Ayman"
        weight = 1
    strings:
        $a = { 60 8B 15 1D 13 40 00 F7 E0 8D 82 83 19 00 00 E8 58 0C 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_SVKP_111_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_SVKP_111_emadicius"
        weight = 1
    strings:
        $a = { 60 E8 01 00 00 00 E8 83 C4 04 E8 01 00 00 00 E9 5D 81 ED FF 22 40 00 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_PESHiELD_025_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_PESHiELD_025_emadicius"
        weight = 1
    strings:
        $a = { 60 E8 2B 00 00 00 0D 0A 0D 0A 0D 0A 52 65 67 69 73 74 41 72 65 64 20 74 6F 3A 20 4E 4F 4E 2D 43 4F 4D 4D 45 52 43 49 41 4C 21 21 0D 0A 0D 0A 0D 00 58 61 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE32Pack_v13x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE32Pack_v13x"
        weight = 1
    strings:
        $a = { 3B ?? 74 02 81 83 55 3B ?? 74 02 81 ?? 53 3B ?? 74 01 ?? ?? ?? ?? ?? 02 81 ?? ?? E8 ?? ?? ?? ?? 3B 74 01 ?? 5D 8B D5 81 ED }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MoleBoxPro_255_Mole_Studio_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MoleBoxPro_255_Mole_Studio_h"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 60 E8 4F 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E9 CA 69 00 00 E9 DE 69 00 00 E9 D9 69 00 00 E8 5E FB FF FF 3E F4 00 00 }
        $b = { E8 00 00 00 00 60 E8 4F 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E9 CA 69 00 00 E9 DE 69 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Password_Protector_for_the_UPX_030_g0d: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Password_Protector_for_the_UPX_030_g0d"
        weight = 1
    strings:
        $a = { C8 50 01 00 60 E8 EC 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 55 53 45 52 33 32 2E 64 6C 6C 00 44 69 61 6C 6F 67 42 6F 78 49 6E 64 69 72 65 63 74 50 61 72 61 6D 41 00 53 65 6E 64 4D 65 73 73 61 67 65 41 00 45 6E 64 44 69 61 6C 6F 67 00 00 00 55 8B EC 57 BF 00 00 00 00 33 C0 81 6D 0C 10 01 00 00 75 03 40 EB 13 83 7D 0C 01 75 0D 66 83 7D 10 0B 75 0B FF 75 14 8F 47 E4 5F 5D C2 10 00 66 83 7D 10 02 77 F4 74 0E 8D 4F A0 51 6A 40 6A 0D FF 77 E4 FF 57 E8 50 FF 75 08 FF 57 EC EB DB 84 08 C8 90 00 00 00 00 01 00 64 00 64 00 64 00 14 00 00 00 00 00 45 00 6E 00 74 00 65 00 72 00 20 00 50 00 61 00 73 00 73 00 77 00 6F 00 72 00 64 00 00 00 A0 00 00 50 00 00 02 00 05 00 05 00 5A 00 0A 00 0B 00 FF FF 81 00 00 00 00 00 5E FC 8D BE AA FE FF FF 8D 86 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Reg2Exe_222223_by_Jan_Vorel: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Reg2Exe_222223_by_Jan_Vorel"
        weight = 1
    strings:
        $a = { 6A 00 E8 2F 1E 00 00 A3 C4 35 40 00 E8 2B 1E 00 00 6A 0A 50 6A 00 FF 35 C4 35 40 00 E8 07 00 00 00 50 E8 1B 1E 00 00 CC 68 48 00 00 00 68 00 00 00 00 68 C8 35 40 00 E8 76 16 00 00 83 C4 0C 8B 44 24 04 A3 CC 35 40 00 68 00 00 00 00 68 A0 0F 00 00 68 00 00 00 00 E8 EC 1D 00 00 A3 C8 35 40 00 E8 62 1D 00 00 E8 92 1A 00 00 E8 80 16 00 00 E8 13 14 00 00 68 01 00 00 00 68 08 36 40 00 68 00 00 00 00 8B 15 08 36 40 00 E8 71 3F 00 00 B8 00 00 10 00 BB 01 00 00 00 E8 82 3F 00 00 FF 35 48 31 40 00 B8 00 01 00 00 E8 0D 13 00 00 8D 0D EC 35 40 00 5A E8 F2 13 00 00 68 00 01 00 00 FF 35 EC 35 40 00 E8 84 1D 00 00 A3 F4 35 40 00 FF 35 48 31 40 00 FF 35 F4 35 40 00 FF 35 EC 35 40 00 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ThemidaWinLicense_V1X_NoCompression_SecureEngine_Oreans_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ThemidaWinLicense_V1X_NoCompression_SecureEngine_Oreans_Technologies"
        weight = 1
    strings:
        $a = { 8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 89 B5 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? ?? ?? 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_v1331_Obsidium_Software_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_v1331_Obsidium_Software_h"
        weight = 1
    strings:
        $a = { EB 04 ?? ?? ?? ?? E8 2A 00 00 00 EB 03 ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 26 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 01 ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 02 ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_joiner_Amok: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_joiner_Amok"
        weight = 1
    strings:
        $a = { A1 14 A1 40 00 C1 E0 02 A3 18 A1 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_v71_DLL_Debug: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_v71_DLL_Debug"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 55 89 E5 83 EC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 55 ?? ?? ?? ?? ?? ?? ?? ?? ?? FF ?? ?? ?? ?? 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WWPACK_v305c4_Unextractable_p_Virus_Shield: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WWPACK_v305c4_Unextractable_p_Virus_Shield"
        weight = 1
    strings:
        $a = { 03 05 40 1B B8 ?? ?? 8C CA 03 D0 8C C9 81 C1 ?? ?? 51 B9 ?? ?? 51 06 06 B1 ?? 51 8C D3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v102a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v102a"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED 06 ?? ?? ?? 64 A0 23 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE2COM_Encrypted_without_selfcheck: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE2COM_Encrypted_without_selfcheck"
        weight = 1
    strings:
        $a = { B3 ?? B9 ?? ?? BE ?? ?? BF ?? ?? EB ?? 54 69 ?? ?? ?? ?? 03 ?? ?? 32 C3 AA 43 49 E3 ?? EB ?? BE ?? ?? 8B C6 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASPack_v102b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASPack_v102b"
        weight = 1
    strings:
        $a = { 60 E8 ?? ?? ?? ?? 5D 81 ED 96 78 43 ?? B8 90 78 43 ?? 03 C5 2B 85 7D 7C 43 ?? 89 85 89 7C 43 ?? 80 BD 74 7C 43 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule fasm_Tomasz_Grysztar_flat: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID fasm_Tomasz_Grysztar_flat"
        weight = 1
    strings:
        $a = { 53 51 52 56 57 55 E8 00 00 00 00 5D 8B CD 81 ED 33 30 40 ?? 2B 8D EE 32 40 00 83 E9 0B 89 8D F2 32 40 ?? 80 BD D1 32 40 ?? 01 0F 84 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_JDPack_1x_JDProtect_09: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_JDPack_1x_JDProtect_09"
        weight = 1
    strings:
        $a = { 60 E8 22 00 00 00 5D 8B D5 81 ED 90 90 90 90 2B 95 90 90 90 90 81 EA 06 90 90 90 89 95 90 90 90 90 83 BD 45 00 01 00 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_Install_System_1xx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_Install_System_1xx"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC 2C 53 56 33 F6 57 56 89 75 DC 89 75 F4 BB A4 9E 40 00 FF 15 60 70 40 00 BF C0 B2 40 00 68 04 01 00 00 57 50 A3 AC B2 40 00 FF 15 4C 70 40 00 56 56 6A 03 56 6A 01 68 00 00 00 80 57 FF 15 9C 70 40 00 8B F8 83 FF FF 89 7D EC 0F 84 C3 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Go32Stub_v200_DOS_Extender: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Go32Stub_v200_DOS_Extender"
        weight = 1
    strings:
        $a = { 0E 1F 8C 1E ?? ?? 8C 06 ?? ?? FC B4 30 CD 21 80 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Cpp_DLL: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Cpp_DLL"
        weight = 1
    strings:
        $a = { EB 10 66 62 3A 43 2B 2B 48 4F 4F 4B 90 E9 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E0 02 A3 ?? ?? ?? ?? 8B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_V22004616_V22006630_WFS_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_V22004616_V22006630_WFS_Sign_by_fly"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 79 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Fish_PE_Shield_101_HellFish: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Fish_PE_Shield_101_HellFish"
        weight = 1
    strings:
        $a = { 60 E8 12 FE FF FF C3 90 09 00 00 00 2C 00 00 00 }
        $b = { 55 8B EC 83 C4 D0 53 56 57 8B 45 10 83 C0 0C 8B 00 89 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Microsoft_Visual_Cpp_30_old_crap: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_30_old_crap"
        weight = 1
    strings:
        $a = { 64 A1 00 00 00 00 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 64 ?? ?? ?? ?? ?? ?? 83 ?? ?? 53 56 57 89 ?? ?? FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE32Pack_v139: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE32Pack_v139"
        weight = 1
    strings:
        $a = { 8B EC FA C7 ?? ?? ?? ?? 4C 4C C3 FB BF ?? ?? B8 ?? ?? 2E ?? ?? D1 C8 4F 81 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE32Pack_v138: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE32Pack_v138"
        weight = 1
    strings:
        $a = { 3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC ?? ?? ?? ?? 02 81 ?? ?? ?? ?? ?? ?? ?? 3B DB 74 01 BE 5D 8B D5 81 ED EC 8D 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_V22X_V24X_StrongBit_Technology_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_V22X_V24X_StrongBit_Technology_SignByfly"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? 05 ?? ?? ?? ?? FF E0 E8 ?? ?? ?? ?? 05 ?? ?? ?? ?? FF E0 E8 04 00 00 00 FF FF FF FF 5E C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_v102_dllocx_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_v102_dllocx_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 60 E8 00 00 00 00 5D 81 ED 23 3F 42 00 8B D5 81 C2 72 3F 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 35 66 42 00 81 E9 1D 40 42 00 8B D5 81 C2 1D 40 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 BE 1F 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 90 EB 01 ?? AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 9C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE32Pack_v137: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE32Pack_v137"
        weight = 1
    strings:
        $a = { 3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC ?? ?? ?? ?? 02 81 ?? ?? ?? ?? ?? ?? ?? 3B DB 74 01 BE 5D 8B D5 81 ED 4C 8E 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE32Pack_v136: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE32Pack_v136"
        weight = 1
    strings:
        $a = { 3B C0 74 02 81 83 55 3B C0 74 02 81 83 53 3B C9 74 01 BC ?? ?? ?? ?? 02 81 ?? ?? ?? ?? ?? ?? ?? 3B DB 74 01 BE 5D 8B D5 81 ED CC 8D 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V1322_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V1322_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 27 00 00 00 EB 02 ?? ?? EB 03 ?? ?? ?? 8B 54 24 0C EB 01 ?? 83 82 B8 00 00 00 22 EB 04 ?? ?? ?? ?? 33 C0 EB 01 ?? C3 EB 02 ?? ?? EB 02 ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 01 ?? EB 03 ?? ?? ?? 50 EB 03 ?? ?? ?? 33 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Go32Stub_v200T_DOS_Extender: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Go32Stub_v200T_DOS_Extender"
        weight = 1
    strings:
        $a = { 0E 1F 8C 1E ?? ?? 8C 06 ?? ?? FC B4 30 CD 21 3C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_DEF_10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_DEF_10"
        weight = 1
    strings:
        $a = { BE 00 01 40 00 6A 05 59 80 7E 07 00 74 11 8B 46 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 90 83 C1 01 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_22004616_22006630_WFS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_22004616_22006630_WFS"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 7A 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 53 79 73 74 65 6D 44 69 72 65 63 74 6F 72 79 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WarWind_Save_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WarWind_Save_file"
        weight = 1
    strings:
        $a = { 57 41 52 53 41 56 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SimbiOZ_Extranger: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SimbiOZ_Extranger"
        weight = 1
    strings:
        $a = { 50 60 E8 00 00 00 00 5D 81 ED 07 10 40 00 68 80 0B 00 00 8D 85 1F 10 40 00 50 E8 84 0B 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nPack_V112752006Beta_NEOx_SignByfly_200800212: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nPack_V112752006Beta_NEOx_SignByfly_200800212"
        weight = 1
    strings:
        $a = { 55 8B EC 51 51 56 57 BE ?? ?? ?? ?? 8D 7D F8 66 A5 A4 BE ?? ?? ?? ?? 8D 7D FC 8D 45 FC 66 A5 50 8D 45 F8 50 A4 FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 5F 5E 75 05 E8 02 00 00 00 C9 C3 E8 46 00 00 00 E8 73 00 00 00 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 9C 00 00 00 E8 1A 02 00 00 E8 CA 06 00 00 E8 19 06 00 00 A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 01 05 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? C3 C3 56 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 5F A3 ?? ?? ?? ?? 5E C3 }
        $b = { 55 8B EC 51 51 56 57 BE ?? ?? ?? ?? 8D 7D F8 66 A5 A4 BE ?? ?? ?? ?? 8D 7D FC 8D 45 FC 66 A5 50 8D 45 F8 50 A4 FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 5F 5E 75 05 E8 02 00 00 00 C9 C3 E8 46 00 00 00 E8 73 00 00 00 B8 ?? ?? ?? ?? 2B 05 ?? ?? ?? ?? A3 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Phonebook_configuration_file_Version_v3v4: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Phonebook_configuration_file_Version_v3v4"
        weight = 1
    strings:
        $a = { 02 6F ?? ?? ?? 0A 0A 06 8D ?? ?? ?? 01 0B 16 0C 38 36 00 00 00 02 08 6F ?? ?? ?? 0A 0D 09 06 08 59 61 D2 13 04 09 1E 63 08 61 D2 13 05 07 08 11 05 1E 62 11 04 60 D1 9D 08 17 58 0C 08 07 8E 69 38 0B 00 00 00 28 ?? ?? ?? 0A 2A 38 EC FF FF FF 3F C0 FF FF FF }
        $b = { 50 68 6F 6E 65 62 6F 6F 6B ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 63 6F }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule FSG_120_Eng_dulekxt_Microsoft_Visual_Cpp_60_70: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_120_Eng_dulekxt_Microsoft_Visual_Cpp_60_70"
        weight = 1
    strings:
        $a = { 33 C2 2C FB 8D 3D 7E 45 B4 80 E8 02 00 00 00 8A 45 58 68 02 ?? 8C 7F EB 02 CD 20 5E 80 C9 16 03 F7 EB 02 40 B0 68 F4 00 00 00 80 F1 2C 5B C1 E9 05 0F B6 C9 8A 16 0F B6 C9 0F BF C7 2A D3 E8 02 00 00 00 99 4C 58 80 EA 53 C1 C9 16 2A D3 E8 02 00 00 00 9D CE }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_Install_System_206: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_Install_System_206"
        weight = 1
    strings:
        $a = { 83 EC 10 53 55 56 57 C7 44 24 14 70 92 40 00 33 ED C6 44 24 13 20 FF 15 2C 70 40 00 55 FF 15 84 72 40 00 BE 00 54 43 00 BF 00 04 00 00 56 57 A3 A8 EC 42 00 FF 15 C4 70 40 00 E8 8D FF FF FF 8B 1D 90 70 40 00 85 C0 75 21 68 FB 03 00 00 56 FF 15 5C 71 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EZIP_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EZIP_v10"
        weight = 1
    strings:
        $a = { E9 19 32 00 00 E9 7C 2A 00 00 E9 19 24 00 00 E9 FF 23 00 00 E9 1E 2E 00 00 E9 88 2E 00 00 E9 2C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upx_Lock_10_12_CyberDoom_Team_X_BoB_BobSoft: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upx_Lock_10_12_CyberDoom_Team_X_BoB_BobSoft"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 48 12 40 00 60 E8 2B 03 00 00 61 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Symantec_C_v210_v400_or_Zortech_C_v30r1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Symantec_C_v210_v400_or_Zortech_C_v30r1"
        weight = 1
    strings:
        $a = { FA FC B8 ?? ?? 8E D8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Gleam_v100: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Gleam_v100"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 83 EC 0C 53 56 57 E8 24 02 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeHand_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeHand_Graphics_format"
        weight = 1
    strings:
        $a = { 41 47 44 32 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_20_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_20_Vaska"
        weight = 1
    strings:
        $a = { 60 90 61 61 80 7F F0 45 90 60 0F 85 1B 8B 1F FF 68 40 A1 14 13 B8 00 10 14 13 90 3D 24 C0 14 13 74 06 80 30 F6 40 EB F3 B8 8C 20 18 13 90 3D B9 27 18 13 74 06 80 30 89 40 EB F3 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Guardant_Stealth_aka_Novex_Dongle: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Guardant_Stealth_aka_Novex_Dongle"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 60 E8 51 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HA_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HA_Archive"
        weight = 1
    strings:
        $a = { 48 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule XPack_152_164: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID XPack_152_164"
        weight = 1
    strings:
        $a = { 8B EC FA 33 C0 8E D0 BC ?? ?? 2E ?? ?? ?? ?? 2E ?? ?? ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Inno_Installer_v405_collides_with_Inno_Setup_Module_Heuristic_Mode_Inno_SFX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Inno_Installer_v405_collides_with_Inno_Setup_Module_Heuristic_Mode_Inno_SFX"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 C0 53 56 57 33 C0 89 45 F0 89 45 C4 89 45 C0 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unnamed_Scrambler_10_p0ke: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unnamed_Scrambler_10_p0ke"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 EC 53 56 33 C0 89 45 ?? ?? ?? ?? 40 00 E8 11 F4 FF FF BE 30 6B 40 00 33 C0 55 68 C9 42 40 00 64 FF 30 64 89 20 E8 C9 FA FF FF BA D8 42 40 00 8B ?? ?? ?? ?? FF FF 8B D8 B8 28 6B 40 00 8B 16 E8 37 F0 FF FF B8 2C 6B 40 00 8B 16 E8 2B F0 FF FF B8 28 6B 40 00 E8 19 F0 FF FF 8B D0 8B C3 8B 0E E8 42 E3 FF FF BA DC 42 40 00 8B C6 E8 2A FA FF FF 8B D8 B8 20 6B 40 00 8B 16 E8 FC EF FF FF B8 24 6B 40 00 8B 16 E8 F0 EF FF FF B8 20 6B 40 00 E8 DE EF FF FF 8B D0 8B C3 8B 0E E8 07 E3 FF FF 6A 00 6A 19 6A 00 6A 32 A1 28 6B 40 00 E8 59 EF FF FF 83 E8 05 03 C0 8D 55 EC E8 94 FE FF FF 8B 55 EC B9 24 6B 40 00 A1 20 6B 40 00 E8 E2 F6 FF FF 6A 00 6A 19 6A 00 6A 32 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_123_RC4_build_0807_exe_Alexey_Solodovnikov_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_123_RC4_build_0807_exe_Alexey_Solodovnikov_h"
        weight = 1
    strings:
        $a = { 90 60 E8 03 00 00 00 E9 EB 04 5D 45 55 C3 E8 01 00 00 00 EB 5D BB ED FF FF FF 03 DD 81 EB ?? ?? ?? ?? 80 7D 4D 01 75 0C 8B 74 24 28 83 FE 01 89 5D 4E 75 31 8D 45 53 50 53 FF B5 D5 09 00 00 8D 45 35 50 E9 82 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Kodak_Color_management_for_Windows_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Kodak_Color_management_for_Windows_file"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? 4B 43 4D 53 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Phonebook_packed_datafile: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Phonebook_packed_datafile"
        weight = 1
    strings:
        $a = { 21 50 48 32 50 41 43 4B 24 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Nullsoft_PIMP_Install_System_v13x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Nullsoft_PIMP_Install_System_v13x"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC ?? ?? 00 00 56 57 6A ?? BE ?? ?? ?? ?? 59 8D BD }
        $b = { 83 EC 0C 53 56 57 FF 15 ?? ?? 40 00 05 E8 03 00 00 BE ?? ?? ?? 00 89 44 24 10 B3 20 FF 15 28 ?? 40 00 68 00 04 00 00 FF 15 ?? ?? 40 00 50 56 FF 15 ?? ?? 40 00 80 3D ?? ?? ?? 00 22 75 08 80 C3 02 BE ?? ?? ?? 00 8A 06 8B 3D ?? ?? 40 00 84 C0 74 ?? 3A C3 74 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PESpin_v07_Cyberbob: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_v07_Cyberbob"
        weight = 1
    strings:
        $a = { EB 01 68 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 83 D5 46 00 0B E4 74 9E 75 01 C7 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 A3 68 72 01 FF 5D 33 C9 41 E2 17 EB 07 EA EB 01 EB EB 0D FF E8 01 00 00 00 EA 5A 83 EA 0B FF E2 EB 04 9A EB 04 00 EB FB FF 8B 95 88 39 40 00 8B 42 3C 03 C2 89 85 92 39 40 00 EB 01 DB 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 9A EB FB 00 83 04 24 0C C3 3B 8B 59 10 03 DA 8B 1B 89 9D A6 39 40 00 53 8F 85 4A 38 40 00 BB ?? 00 00 00 B9 EC 0A 00 00 8D BD 36 3A 40 00 4F EB 01 AB 30 1C 39 FE CB E2 F9 EB 01 C8 68 CB 00 00 00 59 8D BD 56 44 40 00 E8 03 00 00 00 EB 04 FA EB FB 68 83 04 24 0C C3 8D C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 5A 8D 85 B3 5F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 68 E8 1A 00 00 00 8D 34 28 B9 08 00 00 00 B8 ?? ?? ?? ?? 2B C9 83 C9 15 0F A3 C8 0F 83 81 00 00 00 8D B4 0D 99 39 40 00 8B D6 B9 10 00 00 00 AC 84 C0 74 06 C0 4E FF 03 E2 F5 E8 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule JDPack: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID JDPack"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 ?? ?? ?? E8 01 00 00 00 ?? ?? ?? ?? ?? ?? 05 00 00 00 00 83 C4 0C 5D 60 E8 00 00 00 00 5D 8B D5 64 FF 35 00 00 00 00 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Escargot_01_final_ppMeat: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Escargot_01_final_ppMeat"
        weight = 1
    strings:
        $a = { EB 04 40 30 2E 31 60 68 61 ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 B8 92 ?? ?? ?? 8B 00 FF D0 50 B8 CD ?? ?? ?? 81 38 DE C0 37 13 75 2D 68 C9 ?? ?? ?? 6A 40 68 00 ?? 00 00 68 00 00 ?? ?? B8 96 ?? ?? ?? 8B 00 FF D0 8B 44 24 F0 8B 4C 24 F4 EB 05 49 C6 04 01 40 0B C9 75 F7 BE 00 10 ?? ?? B9 00 ?? ?? 00 EB 05 49 80 34 31 40 0B C9 75 F7 58 0B C0 74 08 33 C0 C7 00 DE C0 AD 0B BE ?? ?? ?? ?? E9 AC 00 00 00 8B 46 0C BB 00 00 ?? ?? 03 C3 50 50 }
        $b = { EB 04 40 30 2E 31 60 68 61 ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 B8 92 ?? ?? ?? 8B 00 FF D0 50 B8 CD ?? ?? ?? 81 38 DE C0 37 13 75 2D 68 C9 ?? ?? ?? 6A 40 68 00 ?? 00 00 68 00 00 ?? ?? B8 96 ?? ?? ?? 8B 00 FF D0 8B 44 24 F0 8B 4C 24 F4 EB 05 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Shrink_Wrap_v14: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Shrink_Wrap_v14"
        weight = 1
    strings:
        $a = { 58 60 8B E8 55 33 F6 68 48 01 ?? ?? E8 49 01 ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PackItBitch_10_archphase: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PackItBitch_10_archphase"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 28 ?? ?? ?? 35 ?? ?? ?? 00 00 00 }
        $b = { 00 00 00 00 00 00 00 00 00 00 00 00 28 ?? ?? ?? 35 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 41 ?? ?? ?? 50 ?? ?? ?? 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? ?? ?? ?? ?? ?? ?? 79 ?? ?? ?? 7D ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Pe123_v2006412: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Pe123_v2006412"
        weight = 1
    strings:
        $a = { 8B C0 60 9C E8 01 00 00 00 C3 53 E8 72 00 00 00 50 E8 1C 03 00 00 8B D8 FF D3 5B C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 55 8B EC 60 8B 4D 10 8B 7D 0C 8B 75 08 F3 A4 61 5D C2 0C 00 E8 00 00 00 00 58 83 E8 05 C3 8B C0 E8 00 00 00 00 58 83 C0 05 C3 8B C0 E8 00 00 00 00 58 C1 E8 0C C1 E0 0C 66 81 38 4D 5A 74 0C 2D 00 10 00 00 66 81 38 4D 5A 75 F4 C3 E8 00 00 00 00 58 83 E8 05 C3 8B C0 55 8B EC 81 C4 4C FE FF FF 53 6A 40 8D 85 44 FF FF FF 50 E8 BC FF FF FF 50 E8 8A FF FF FF 68 F8 00 00 00 8D 85 4C FE FF FF 50 E8 A5 FF FF FF 03 45 80 50 E8 70 FF FF FF E8 97 FF FF FF 03 85 CC FE FF FF 83 C0 34 89 45 FC E8 86 FF FF FF 03 85 CC FE FF FF 83 C0 38 89 45 8C 60 8B 45 FC 8B 00 89 45 F8 89 45 9C 8B 45 8C 8B 00 89 45 88 89 45 98 E8 0D 00 00 00 6B 65 72 6E 65 6C 33 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_Code_Lock: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Code_Lock"
        weight = 1
    strings:
        $a = { 43 4F 44 45 2D 4C 4F 43 4B 2E 4F 43 58 00 01 28 01 50 4B 47 05 4C 3F B4 04 4D 4C 47 4B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressor_v1451_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_v1451_CGSoftLabs"
        weight = 1
    strings:
        $a = { 55 8B EC 83 EC 58 53 56 57 83 65 DC 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 34 2E 00 A1 00 ?? ?? ?? 05 00 ?? ?? ?? A3 08 ?? ?? ?? A1 08 ?? ?? ?? B9 81 ?? ?? ?? 2B 48 18 89 0D 0C ?? ?? ?? 83 3D 10 ?? ?? ?? 00 74 16 A1 08 ?? ?? ?? 8B 0D 0C ?? ?? ?? 03 48 14 89 4D CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule WinKript_v10_Mr_Crimson: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID WinKript_v10_Mr_Crimson"
        weight = 1
    strings:
        $a = { 33 C0 8B B8 00 ?? ?? ?? 8B 90 04 ?? ?? ?? 85 FF 74 1B 33 C9 50 EB 0C 8A 04 39 C0 C8 04 34 1B 88 04 39 41 3B CA 72 F0 58 83 C0 08 EB D5 61 E9 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1338_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1338_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 04 ?? ?? ?? ?? E8 28 00 00 00 EB 01 ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 ?? EB 04 ?? ?? ?? ?? 33 C0 EB 03 ?? ?? ?? C3 EB 01 ?? EB 01 ?? 64 67 FF 36 00 00 EB 03 ?? ?? ?? 64 67 89 26 00 00 EB 02 ?? ?? EB 01 ?? 50 EB 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_2223_compressed_code_wwwstrongbitcom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_2223_compressed_code_wwwstrongbitcom"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 58 ?? ?? ?? ?? ?? 8B 1C 24 81 EB ?? ?? ?? ?? B8 ?? ?? ?? ?? 50 6A 04 68 00 10 00 00 50 6A 00 B8 C4 ?? ?? ?? 8B 04 18 FF D0 59 BA ?? ?? ?? ?? 01 DA 52 53 50 89 C7 89 D6 FC F3 A4 B9 ?? ?? ?? ?? 01 D9 FF D1 58 8B 1C 24 68 00 80 00 00 6A 00 50 B8 C8 ?? ?? ?? 8B 04 18 FF D0 59 58 5B 83 EB 05 C6 03 B8 43 89 03 83 C3 04 C6 03 C3 09 C9 74 46 89 C3 E8 A0 00 00 00 FC AD 83 F8 FF 74 38 53 89 CB 01 C3 01 0B 83 C3 04 AC 3C FE 73 07 25 FF 00 00 00 EB ED 81 C3 FE 00 00 00 09 C0 7A 09 66 AD 25 FF FF 00 00 EB DA AD 4E 25 FF FF FF 00 3D FF FF FF 00 75 CC ?? ?? ?? ?? ?? C3 }
        $b = { E8 00 00 00 00 58 ?? ?? ?? ?? ?? 8B 1C 24 81 EB ?? ?? ?? ?? B8 ?? ?? ?? ?? 50 6A 04 68 00 10 00 00 50 6A 00 B8 C4 ?? ?? ?? 8B 04 18 FF D0 59 BA ?? ?? ?? ?? 01 DA 52 53 50 89 C7 89 D6 FC F3 A4 B9 ?? ?? ?? ?? 01 D9 FF D1 58 8B 1C 24 68 00 80 00 00 6A 00 50 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule MPRESS_V077b_MATCODE_Softwarenbsp_nbsp_SignByfly_20080313: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MPRESS_V077b_MATCODE_Softwarenbsp_nbsp_SignByfly_20080313"
        weight = 1
    strings:
        $a = { 60 E8 0B 00 00 00 E8 77 00 00 00 61 E9 75 01 00 00 E8 00 00 00 00 58 05 75 01 00 00 8B 30 03 F0 2B C0 8B FE 66 AD C1 E0 0C 8B C8 AD 2B C8 03 F1 8B C8 49 8A 44 39 06 74 05 88 04 31 EB F4 88 04 31 2B C0 3B FE 73 3A AC 0A C0 74 35 8A C8 24 3F 80 E1 C0 C1 E0 10 66 AD 80 F9 C0 74 1C F6 C1 40 75 08 8B C8 2B C0 F3 AA EB D7 8B D6 8B CF 03 F0 E8 7E 00 00 00 03 F8 EB C8 8B C8 F3 A4 75 FC EB C0 C3 E8 00 00 00 00 5F 81 C7 79 FF FF FF B0 E9 AA B8 81 01 00 00 AB 2B FF E8 00 00 00 00 58 05 ED 00 00 00 8B 78 08 8B D7 8B 78 04 0B FF 74 42 8B 30 03 F0 2B F2 8B EE 8B 48 10 2B CD 74 33 8B 50 0C 03 F2 03 FE 2B C0 AD 3B F7 73 25 8B D8 AD 3B F7 73 1E 8B D0 83 EA 08 03 D6 66 AD 0A E4 74 0B 25 FF 0F 00 00 03 C3 03 C5 29 08 3B F2 73 D8 EB E9 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_V102_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_V102_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { E8 03 00 00 00 EB 01 ?? BB 55 00 00 00 E8 03 00 00 00 EB 01 ?? E8 8F 00 00 00 E8 03 00 00 00 EB 01 ?? E8 82 00 00 00 E8 03 00 00 00 EB 01 ?? E8 B8 00 00 00 E8 03 00 00 00 EB 01 ?? E8 AB 00 00 00 E8 03 00 00 00 EB 01 ?? 83 FB 55 E8 03 00 00 00 EB 01 ?? 75 2E E8 03 00 00 00 EB 01 ?? C3 60 E8 00 00 00 00 5D 81 ED 23 3F 42 00 8B D5 81 C2 72 3F 42 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 4B CC C3 E8 03 00 00 00 EB 01 ?? 33 DB B9 3A 66 42 00 81 E9 1D 40 42 00 8B D5 81 C2 1D 40 42 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 17 00 00 00 90 90 90 E9 C3 1F 00 00 33 C0 64 FF 30 64 89 20 43 CC C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FACRYPT_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FACRYPT_v10"
        weight = 1
    strings:
        $a = { B9 ?? ?? B3 ?? 33 D2 BE ?? ?? 8B FE AC 32 C3 AA 49 43 32 E4 03 D0 E3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1258_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1258_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 01 ?? E8 29 00 00 00 EB 02 ?? ?? EB 01 ?? 8B 54 24 0C EB 04 ?? ?? ?? ?? 83 82 B8 00 00 00 24 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 01 ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 EB 03 ?? ?? ?? 33 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EP_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EP_v20"
        weight = 1
    strings:
        $a = { 6A ?? 60 E9 01 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_yodas_cryptor_12_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_yodas_cryptor_12_emadicius"
        weight = 1
    strings:
        $a = { 53 55 8B E8 33 DB EB 60 0D 0A 0D 0A 57 57 50 61 63 6B 33 32 20 64 65 63 6F 6D 70 72 65 73 73 69 6F 6E 20 72 6F 75 74 69 6E 65 20 76 65 72 73 69 6F 6E 20 31 2E 31 32 0D 0A 28 63 29 20 31 39 39 38 20 50 69 6F 74 72 20 57 61 72 65 7A 61 6B 20 61 6E 64 20 52 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Quake518: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Quake518"
        weight = 1
    strings:
        $a = { 1E 06 8C C8 8E D8 ?? ?? ?? ?? ?? ?? ?? B8 21 35 CD 21 81 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPXFreak_V01_HMX0101: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPXFreak_V01_HMX0101"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? 83 C6 01 FF E6 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MEGALITE_v120a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MEGALITE_v120a"
        weight = 1
    strings:
        $a = { B8 ?? ?? BA ?? ?? 05 ?? ?? 3B 2D 73 ?? 72 ?? B4 09 BA ?? ?? CD 21 CD 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LHA_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LHA_Archive"
        weight = 1
    strings:
        $a = { ?? ?? ?? 6C 68 35 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_v110_Eng_bartxt_Watcom_CCpp_EXE: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_v110_Eng_bartxt_Watcom_CCpp_EXE"
        weight = 1
    strings:
        $a = { EB 02 CD 20 03 ?? 8D ?? 80 ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule OS2_Icon_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID OS2_Icon_Graphics_format"
        weight = 1
    strings:
        $a = { 43 49 4E 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AMGC_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AMGC_Archive"
        weight = 1
    strings:
        $a = { AD 36 22 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ASProtect_20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ASProtect_20"
        weight = 1
    strings:
        $a = { 68 01 ?? 40 00 E8 01 00 00 00 C3 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Stealth_v274: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Stealth_v274"
        weight = 1
    strings:
        $a = { EB 00 EB 17 53 68 61 72 65 77 61 72 65 20 2D 20 45 78 65 53 74 65 61 6C 74 68 00 60 90 E8 00 00 00 00 5D 81 ED C4 27 40 00 B9 15 00 00 00 83 C1 04 83 C1 01 EB 05 EB FE 83 C7 56 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9 91 0C 00 00 90 8D BD 38 28 40 00 8B F7 AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Werus_Crypter_10_Kas: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Werus_Crypter_10_Kas"
        weight = 1
    strings:
        $a = { 68 98 11 40 00 6A 00 E8 50 00 00 00 C9 C3 ED B3 FE FF FF 6A 00 E8 0C 00 00 00 FF 25 80 10 40 00 FF 25 84 10 40 00 FF 25 88 10 40 00 FF 25 8C 10 40 00 FF 25 90 10 40 00 FF 25 94 10 40 00 FF 25 98 10 40 00 FF 25 9C 10 40 00 FF 25 A0 10 40 00 FF 25 A4 10 40 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Stealth_v273: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Stealth_v273"
        weight = 1
    strings:
        $a = { EB 00 EB 2F 53 68 61 72 65 77 61 72 65 20 2D 20 45 78 65 53 74 65 61 6C 74 68 00 EB 16 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 00 60 90 E8 00 00 00 00 5D 81 ED F0 27 40 00 B9 15 00 00 00 83 C1 05 EB 05 EB FE 83 C7 56 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9 77 0C 00 00 90 8D BD 61 28 40 00 8B F7 AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 CC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Amiga_IFFILBM_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Amiga_IFFILBM_Graphics_format"
        weight = 1
    strings:
        $a = { 46 4F 52 4D ?? ?? ?? ?? 49 4C 42 4D 42 4D 48 44 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_PECompact_14x_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_PECompact_14x_emadicius"
        weight = 1
    strings:
        $a = { EB 06 68 2E A8 00 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 40 00 61 9D EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressorPacK_150X_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressorPacK_150X_CGSoftLabs"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 83 A5 ?? ?? ?? ?? ?? F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 2E 00 83 7D 0C ?? 75 23 8B 45 08 A3 ?? ?? ?? ?? 6A 04 68 00 10 00 00 68 20 03 00 00 6A 00 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 04 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Exe_Shield_v17: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Exe_Shield_v17"
        weight = 1
    strings:
        $a = { EB 06 68 90 1F 06 00 C3 9C 60 E8 02 00 00 00 33 C0 8B C4 83 C0 04 93 8B E3 8B 5B FC 81 EB 3F 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule fds0ft_c0m_pr0tect_v04b: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID fds0ft_c0m_pr0tect_v04b"
        weight = 1
    strings:
        $a = { 8C CA 2E ?? ?? ?? ?? B4 30 8B ?? ?? ?? 8B ?? ?? ?? 8E DA A3 ?? ?? 8C ?? ?? ?? 89 ?? ?? ?? 89 ?? ?? ?? EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEiD_1783_32Lite_v003a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID 32Lite_v003a"
        weight = 1
    strings:
        $a = { 60 06 FC 1E 07 BE ?? ?? ?? ?? 6A 04 68 ?? 10 ?? ?? 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_02x_beta_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_02x_beta_Dwing"
        weight = 1
    strings:
        $a = { BE 88 01 40 00 AD 8B F8 95 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_1337_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_1337_Obsidium_Software"
        weight = 1
    strings:
        $a = { EB 02 ?? ?? E8 2C 00 00 00 EB 04 ?? ?? ?? ?? EB 04 ?? ?? ?? ?? 8B 54 24 0C EB 02 ?? ?? 83 82 B8 00 00 00 27 EB 04 ?? ?? ?? ?? 33 C0 EB 02 ?? ?? C3 EB 02 ?? ?? EB 03 ?? ?? ?? 64 67 FF 36 00 00 EB 04 ?? ?? ?? ?? 64 67 89 26 00 00 EB 03 ?? ?? ?? EB 01 ?? 50 EB 02 ?? ?? 33 C0 EB 02 ?? ?? 8B 00 EB 04 ?? ?? ?? ?? C3 EB 02 ?? ?? E9 FA 00 00 00 EB 04 ?? ?? ?? ?? E8 D5 FF FF FF EB 02 ?? ?? EB 04 ?? ?? ?? ?? 58 EB 04 ?? ?? ?? ?? EB 03 ?? ?? ?? 64 67 8F 06 00 00 EB 01 ?? 83 C4 04 EB 03 ?? ?? ?? E8 23 27 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vcasm_Protector_11_12_vcasm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vcasm_Protector_11_12_vcasm"
        weight = 1
    strings:
        $a = { EB 0B 5B 56 50 72 6F 74 65 63 74 5D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SoftProtect_wwwsoftprotectbyru: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SoftProtect_wwwsoftprotectbyru"
        weight = 1
    strings:
        $a = { E8 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D ?? ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 ?? ?? ?? ?? ?? 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Unnamed_Scrambler_21Beta_211_p0ke: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unnamed_Scrambler_21Beta_211_p0ke"
        weight = 1
    strings:
        $a = { 55 8B EC B9 0A 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 B8 1C 2F 40 00 E8 C8 F1 FF FF 33 C0 55 68 FB 33 40 00 64 FF 30 64 89 20 BA 0C 34 40 00 B8 E4 54 40 00 E8 EF FE FF FF 8B D8 85 DB 75 07 6A 00 E8 5A F2 FF FF BA E8 54 40 00 8B C3 8B 0D E4 54 40 00 E8 74 }
        $b = { 55 8B EC B9 15 00 00 00 6A 00 6A 00 49 75 F9 53 56 57 B8 ?? 3A ?? ?? E8 ?? EE FF FF 33 C0 55 68 ?? 43 ?? ?? 64 FF 30 64 89 20 BA ?? 43 ?? ?? B8 E4 64 ?? ?? E8 0F FD FF FF 8B D8 85 DB 75 07 6A 00 E8 ?? EE FF FF BA E8 64 ?? ?? 8B C3 8B 0D E4 64 ?? ?? E8 ?? D7 FF FF B8 F8 ?? ?? ?? BA 04 00 00 00 E8 ?? EF FF FF 33 C0 A3 F8 ?? ?? ?? BB ?? ?? ?? ?? C7 45 EC E8 64 ?? ?? C7 45 E8 ?? ?? ?? ?? C7 45 E4 ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? B8 E0 ?? ?? ?? BA 04 00 00 00 E8 ?? EF FF FF 68 F4 01 00 00 E8 ?? EE FF FF 83 7B 04 00 75 0B 83 3B 00 0F 86 ?? 07 00 00 EB 06 0F 8E ?? 07 00 00 8B 03 8B D0 B8 E4 ?? ?? ?? E8 ?? E5 FF FF B8 E4 ?? ?? ?? E8 ?? E3 FF FF 8B D0 8B 45 EC 8B 0B E8 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Symantec_WinFax_PRO_75_Coverpage: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Symantec_WinFax_PRO_75_Coverpage"
        weight = 1
    strings:
        $a = { 0C BD 03 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? C0 06 80 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LOCK98_V10028_keenvim: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LOCK98_V10028_keenvim"
        weight = 1
    strings:
        $a = { 55 E8 00 00 00 00 5D 81 ?? ?? ?? ?? ?? EB 05 E9 ?? ?? ?? ?? EB 08 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Software_Compress_v12_BG_Software_Protect_Technologies: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Software_Compress_v12_BG_Software_Protect_Technologies"
        weight = 1
    strings:
        $a = { E9 BE 00 00 00 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C3 60 FF 74 24 24 6A 40 FF 95 1A 0F 41 00 89 44 24 1C 61 C2 04 00 E8 00 00 00 00 81 2C 24 3A 10 41 00 5D E8 00 00 00 00 81 2C 24 31 01 00 00 8B 85 2A 0F 41 00 29 04 24 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule File_Analyzer_Registration_file_v11: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID File_Analyzer_Registration_file_v11"
        weight = 1
    strings:
        $a = { 24 46 41 52 45 47 24 45 4E 43 3D ?? 26 26 52 45 47 3D ?? 26 26 45 58 50 3D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule File_Analyzer_Registration_file_v10: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID File_Analyzer_Registration_file_v10"
        weight = 1
    strings:
        $a = { 24 46 41 52 45 47 24 4D 2D ?? ?? ?? ?? 31 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_v16b_v16c_Vaska: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_v16b_v16c_Vaska"
        weight = 1
    strings:
        $a = { 8B C7 03 04 24 2B C7 80 38 50 0F 85 1B 8B 1F FF 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RCryptor_16_by_Vaska_Damrai_sign_20032007_2041: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RCryptor_16_by_Vaska_Damrai_sign_20032007_2041"
        weight = 1
    strings:
        $a = { 83 2C 24 4F 68 40 A1 14 13 FF 54 24 04 83 44 24 04 4F B8 00 10 14 13 3D 24 C0 14 13 74 06 80 30 2B 40 EB F3 B8 8C 20 18 13 3D B9 27 18 13 74 06 80 30 19 40 EB F3 E8 00 00 00 00 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_Pascal_v40_Unit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_Pascal_v40_Unit"
        weight = 1
    strings:
        $a = { 54 50 55 30 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_v118_Basic_DLL_aPLib: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_v118_Basic_DLL_aPLib"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SVKP_v132_Pavol_Cerven_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SVKP_v132_Pavol_Cerven_h"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 06 36 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 0C 61 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 18 61 00 00 5D 6A FF FF 95 10 61 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule N_Joy_13_NEX: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID N_Joy_13_NEX"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 B8 48 36 40 00 E8 54 EE FF FF 6A 00 68 D8 2B 40 00 6A 0A 6A 00 E8 2C EF FF FF E8 23 E7 FF FF 8D 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_Pascal_Help_File: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_Pascal_Help_File"
        weight = 1
    strings:
        $a = { 54 55 52 ?? ?? ?? 50 41 53 ?? ?? ?? ?? 48 45 4C 50 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FSG_120_Eng_dulekxt_Microsoft_Visual_Cpp_60: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FSG_120_Eng_dulekxt_Microsoft_Visual_Cpp_60"
        weight = 1
    strings:
        $a = { EB 02 CD 20 EB 01 91 8D 35 80 ?? ?? 00 33 C2 68 83 93 7E 7D 0C A4 5B 23 C3 68 77 93 7E 7D EB 01 FA 5F E8 02 00 00 00 F7 FB 58 33 DF EB 01 3F E8 02 00 00 00 11 88 58 0F B6 16 EB 02 CD 20 EB 02 86 2F 2A D3 EB 02 CD 20 80 EA 2F EB 01 52 32 D3 80 E9 CD 80 EA }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule vcasm_10_11_vcasm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID vcasm_10_11_vcasm"
        weight = 1
    strings:
        $a = { EB 01 9A 60 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NTkrnl_Secure_Suite_NTkrnl_Team_Blue: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NTkrnl_Secure_Suite_NTkrnl_Team_Blue"
        weight = 1
    strings:
        $a = { 68 29 19 43 00 E8 01 00 00 00 C3 C3 A2 A9 61 4E A5 0E C7 A6 59 90 6E 4D 4C DB 36 46 FB 6E C4 45 A3 C2 2E 0E 41 59 1A 50 17 39 62 4D B8 61 24 8E CF D1 0E 9E 7A 66 C0 8D 6B 9C 52 7E 96 46 80 AF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MPRESS_V071a_V075b_MATCODE_Softwarenbsp_nbsp_SignByfly_20080310: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MPRESS_V071a_V075b_MATCODE_Softwarenbsp_nbsp_SignByfly_20080310"
        weight = 1
    strings:
        $a = { 57 56 53 51 52 55 E8 10 00 00 00 E8 7A 00 00 00 5D 5A 59 5B 5E 5F E9 84 01 00 00 E8 00 00 00 00 58 05 84 01 00 00 8B 30 03 F0 2B C0 8B FE 66 AD C1 E0 0C 8B C8 AD 2B C8 03 F1 8B C8 49 8A 44 39 06 74 05 88 04 31 EB F4 88 04 31 2B C0 AC 0A C0 74 37 8A C8 24 3F 80 E1 C0 C1 E0 10 66 AD 80 F9 C0 74 1E F6 C1 40 75 0A 8B C8 2B C0 F3 AA 75 FC EB D9 8B D6 8B CF 03 F0 E8 8F 00 00 00 03 F8 EB CA 8B C8 F3 A4 75 FC EB C2 C3 E8 00 00 00 00 5F 81 C7 71 FF FF FF B0 E9 AA B8 9A 01 00 00 AB 2B FF E8 00 00 00 00 58 05 FE 00 00 00 8B 78 08 8B D7 8B 78 04 0B FF 74 53 8B 30 03 F0 2B F2 8B EE 8B C2 8B 45 3C 03 C5 8B 48 34 2B CD 74 3D E8 00 00 00 00 58 05 DD 00 00 00 8B 10 03 F2 03 FE 2B C0 AD 3B F7 73 25 8B D8 AD 3B F7 73 1E 8B D0 83 EA 08 03 D6 66 AD 0A E4 74 0B 25 FF 0F 00 00 03 C3 03 C5 29 08 3B F2 73 D8 EB E9 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEtite_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEtite_v20"
        weight = 1
    strings:
        $a = { B8 ?? ?? ?? ?? 66 9C 60 50 8B D8 03 ?? 68 54 BC ?? ?? 6A ?? FF 50 18 8B CC 8D A0 54 BC ?? ?? 8B C3 8D 90 E0 15 ?? ?? 68 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MicroDog_Win32Shell_V4093_SafeNet_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MicroDog_Win32Shell_V4093_SafeNet_SignByfly"
        weight = 1
    strings:
        $a = { 60 55 8B EC 81 EC 34 04 00 00 53 56 57 C6 85 B8 FE FF FF 00 C6 85 B9 FE FF FF 00 C6 85 BA FE FF FF 00 C6 85 BB FE FF FF 00 8D BD BC FE FF FF 33 C0 B9 3F 00 00 00 F3 AB C6 85 E8 FC FF FF 00 C6 85 E9 FC FF FF 00 C6 85 EA FC FF FF 00 C6 85 EB FC FF FF 00 8D BD EC FC FF FF 33 C0 B9 3F 00 00 00 F3 AB C7 85 10 FE FF FF A5 A5 00 00 66 C7 85 08 FE FF FF 0A 00 E9 13 09 00 00 90 68 00 10 00 00 E8 B8 F5 FF FF 83 C4 04 89 45 D0 83 7D D0 00 75 05 E9 C1 11 00 00 68 00 10 00 00 A1 ?? ?? ?? ?? 50 8B 45 D0 50 E8 FF F6 FF FF 83 C4 0C A1 ?? ?? ?? ?? 33 05 ?? ?? ?? ?? 89 85 34 FE FF FF 8B 85 34 FE FF FF 89 45 CC E9 CE 0E 00 00 E9 36 11 00 00 E9 3D 11 00 00 E9 38 11 00 00 66 C7 45 EC 00 00 EB 04 66 FF 45 EC 8B 45 EC 25 FF FF 00 00 83 F8 03 0F 8D DF 00 00 00 8B 45 EC 25 FF FF 00 00 8B 4D EC 81 E1 FF FF 00 00 0F AF C1 8B 4D EC 81 E1 FF FF 00 00 0F AF C1 8B 4D EC 81 E1 FF FF 00 00 0F AF C1 83 C0 07 89 85 EC FB FF FF EB 7E }
        $b = { 60 55 8B EC 81 EC 34 04 00 00 53 56 57 C6 85 B8 FE FF FF 00 C6 85 B9 FE FF FF 00 C6 85 BA FE FF FF 00 C6 85 BB FE FF FF 00 8D BD BC FE FF FF 33 C0 B9 3F 00 00 00 F3 AB C6 85 E8 FC FF FF 00 C6 85 E9 FC FF FF 00 C6 85 EA FC FF FF 00 C6 85 EB FC FF FF 00 8D }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PEcrypt_by_archphase: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEcrypt_by_archphase"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 E0 53 56 33 C0 89 45 E4 89 45 E0 89 45 EC ?? ?? ?? ?? 64 82 40 00 E8 7C C7 FF FF 33 C0 55 68 BE 84 40 00 64 FF 30 64 89 20 68 CC 84 40 00 ?? ?? ?? ?? 00 A1 10 A7 40 00 50 E8 1D C8 FF FF 8B D8 85 DB 75 39 E8 3A C8 FF FF 6A 00 6A 00 68 A0 A9 40 00 68 00 04 00 00 50 6A 00 68 00 13 00 00 E8 FF C7 FF FF 6A 00 68 E0 84 40 00 A1 A0 A9 40 00 50 6A 00 E8 ?? ?? ?? ?? E9 7D 01 00 00 53 A1 10 A7 40 00 50 E8 42 C8 FF FF 8B F0 85 F6 75 18 6A 00 68 E0 84 40 00 68 E4 84 40 00 6A 00 E8 71 C8 FF FF E9 53 01 00 00 53 6A 00 E8 2C C8 FF FF A3 ?? ?? ?? ?? 83 3D 48 A8 40 00 00 75 18 6A 00 68 E0 84 40 00 68 F8 84 40 00 6A 00 E8 43 C8 FF FF E9 25 01 00 00 56 E8 F8 C7 FF FF A3 4C A8 40 00 A1 48 A8 40 00 E8 91 A1 FF FF 8B D8 8B 15 48 A8 40 00 85 D2 7C 16 42 33 C0 8B 0D 4C A8 40 00 03 C8 8A 09 8D 34 18 88 0E 40 4A 75 ED 8B 15 48 A8 40 00 85 D2 7C 32 42 33 C0 8D 34 18 8A 0E 80 F9 01 75 05 C6 06 FF EB 1C 8D 0C 18 8A 09 84 ?? ?? ?? ?? ?? 00 EB 0E 8B 0D 4C A8 40 00 03 C8 0F B6 09 49 88 0E 40 4A 75 D1 8D ?? ?? ?? ?? E8 A5 A3 FF FF 8B 45 E8 8D 55 EC E8 56 D5 FF FF 8D 45 EC BA 18 85 40 00 E8 79 BA FF FF 8B 45 EC E8 39 BB FF FF 8B D0 B8 54 A8 40 00 E8 31 A6 FF FF BA 01 00 00 00 B8 54 A8 40 00 E8 12 A9 FF FF E8 DD A1 FF FF 68 50 A8 40 00 8B D3 8B 0D 48 A8 40 00 B8 54 A8 40 00 E8 56 A7 FF FF E8 C1 A1 FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MEW_5_10_Northfox: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MEW_5_10_Northfox"
        weight = 1
    strings:
        $a = { BE 5B 00 40 00 AD 91 AD 93 53 AD 96 56 5F AC C0 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CExe_v10a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CExe_v10a"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 0C 02 ?? ?? 56 BE 04 01 ?? ?? 8D 85 F8 FE FF FF 56 50 6A ?? FF 15 54 10 40 ?? 8A 8D F8 FE FF FF 33 D2 84 C9 8D 85 F8 FE FF FF 74 16 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RE_Crypt_v07x_Crudd_RET_h1: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RE_Crypt_v07x_Crudd_RET_h1"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED E7 1A 40 00 E8 A1 00 00 00 E8 D1 00 00 00 E8 85 01 00 00 F7 85 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_v118_Basic_DLL_LZMA_Ap0x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_v118_Basic_DLL_LZMA_Ap0x"
        weight = 1
    strings:
        $a = { 80 7C 24 08 01 0F 85 ?? ?? ?? ?? 60 E8 00 00 00 00 8B 2C 24 83 C4 04 8D B5 21 0B 00 00 8D 9D FF 02 00 00 33 FF E8 9F 01 00 00 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 AA 0A 00 00 89 85 F9 0A 00 00 EB 14 60 FF B5 F9 0A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V021_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V021_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? AD 8B F8 6A 04 95 A5 33 C0 AB 48 AB F7 D8 59 F3 AB C1 E0 0A ?? ?? F3 AB AD 50 97 51 58 8D 54 85 5C FF 16 72 5A 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF ?? ?? ?? B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 01 67 E3 29 8B D7 2B 55 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 56 08 33 C9 E9 07 01 00 00 8B 5D 0C 83 C2 30 FF 16 73 53 83 C2 30 FF 16 72 1B 83 C2 30 FF 16 72 2B 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 45 0C B1 80 8A 00 EB CF 83 C2 60 FF 16 87 5D 10 73 0D 83 C2 30 FF 16 87 5D 14 73 03 87 5D 18 3C 07 B0 08 72 02 B0 0B 50 53 8D 95 7C 07 00 00 FF 56 0C 5B 91 E9 9C 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SuckStop_v111: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SuckStop_v111"
        weight = 1
    strings:
        $a = { EB ?? ?? ?? BE ?? ?? B4 30 CD 21 EB ?? 9B }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NET_executable: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NET_executable"
        weight = 1
    strings:
        $a = { FF 25 00 20 40 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DBPE_v233: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DBPE_v233"
        weight = 1
    strings:
        $a = { EB 20 ?? ?? 40 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 9C 55 57 56 52 51 53 9C E8 ?? ?? ?? ?? 5D 81 ED ?? ?? ?? ?? 9C 6A 10 73 0B EB 02 C1 51 E8 06 ?? ?? ?? C4 11 73 F7 5B CD 83 C4 04 EB 02 99 EB FF 0C 24 71 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_02_ZCode_101: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_ZCode_101"
        weight = 1
    strings:
        $a = { E9 12 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E9 FB FF FF FF C3 68 00 00 00 00 64 FF 35 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V01_cyberbobnbsp_nbsp_SignByfly_20080312: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V01_cyberbobnbsp_nbsp_SignByfly_20080312"
        weight = 1
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 5C CB 46 00 0B E4 74 9E 75 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 8B ?? ?? ?? ?? ?? 8B 42 3C 03 C2 89 ?? ?? ?? ?? ?? 41 C1 E1 07 8B 0C 01 03 CA 8B 59 10 03 DA 8B 1B 89 ?? ?? ?? ?? ?? 53 8F 85 ?? ?? ?? ?? BB ?? ?? ?? ?? B9 A5 08 00 00 8D ?? ?? ?? ?? ?? 4F 30 1C 39 FE CB E2 F9 68 2D 01 00 00 59 8D ?? ?? ?? ?? ?? C0 0C 39 02 E2 FA E8 02 00 00 00 FF 15 ?? ?? ?? ?? 4F 56 00 BB 54 13 0B 00 D1 E3 2B C3 FF E0 E8 01 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Private_exe_Protector_18X_19X_SetiSoft_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_exe_Protector_18X_19X_SetiSoft_Team"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CrackStop_v101_c_Stefan_Esser_1997: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CrackStop_v101_c_Stefan_Esser_1997"
        weight = 1
    strings:
        $a = { B4 48 BB FF FF B9 EB 27 8B EC CD 21 FA FC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Ionic_Wind_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Ionic_Wind_Software"
        weight = 1
    strings:
        $a = { 9B DB E3 9B DB E2 D9 2D 00 ?? ?? 00 55 89 E5 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_2117_StrongbitSoftComplete_Development: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_2117_StrongbitSoftComplete_Development"
        weight = 1
    strings:
        $a = { BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 D0 03 45 F4 8B 18 8B 7E 10 01 D7 03 7D F4 09 DB 0F 84 ?? 00 00 00 F7 C3 00 00 00 80 0F 85 04 00 00 00 8D 5C 13 02 81 E3 FF FF FF 7F 53 FF 75 F8 FF 15 9C ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 07 83 45 F4 04 E9 A6 FF FF FF }
        $b = { BE ?? ?? ?? ?? B8 00 00 ?? ?? 89 45 FC 89 C2 8B 46 0C 09 C0 0F 84 ?? 00 00 00 01 D0 89 C3 50 FF 15 94 ?? ?? ?? 09 C0 0F 85 0F 00 00 00 53 FF 15 98 ?? ?? ?? 09 C0 0F 84 ?? 00 00 00 89 45 F8 6A 00 8F 45 F4 8B 06 09 C0 8B 55 FC 0F 85 03 00 00 00 8B 46 10 01 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Minke_101_by_Codius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Minke_101_by_Codius"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F0 53 ?? ?? ?? ?? ?? 10 E8 7A F6 FF FF BE 68 66 00 10 33 C0 55 68 DB 40 00 10 64 FF 30 64 89 20 E8 FA F8 FF FF BA EC 40 00 10 8B C6 E8 F2 FA FF FF 8B D8 B8 6C 66 00 10 8B 16 E8 88 F2 FF FF B8 6C 66 00 10 E8 76 F2 FF FF 8B D0 8B C3 8B 0E E8 E3 E4 FF FF E8 2A F9 FF FF E8 C1 F8 FF FF B8 6C 66 00 10 8B 16 E8 6D FA FF FF E8 14 F9 FF FF E8 AB F8 FF FF 8B 06 E8 B8 E3 FF FF 8B D8 B8 6C 66 00 10 E8 38 F2 FF FF 8B D3 8B 0E E8 A7 E4 FF ?? ?? ?? ?? C4 FB FF FF E8 E7 F8 FF FF 8B C3 E8 B0 E3 FF FF E8 DB F8 FF FF 33 C0 5A 59 59 64 89 10 68 E2 40 00 10 C3 E9 50 EB FF FF EB F8 5E 5B E8 BB EF FF FF 00 00 00 43 41 31 38 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECrypt_10_ReBirth: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECrypt_10_ReBirth"
        weight = 1
    strings:
        $a = { 90 90 60 E8 00 00 00 00 5D 81 ED D1 27 40 00 B9 15 00 00 00 83 C1 04 83 C1 01 EB 05 EB FE 83 C7 56 EB 00 EB 00 83 E9 02 81 C1 78 43 27 65 EB 00 81 C1 10 25 94 00 81 E9 63 85 00 00 B9 96 0C 00 00 90 8D BD 4E 28 40 00 8B F7 AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule HSC_music_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID HSC_music_file"
        weight = 1
    strings:
        $a = { C8 E2 04 20 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPolyX_delikon: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPolyX_delikon"
        weight = 1
    strings:
        $a = { FF 96 ?? ?? ?? 00 61 E9 ?? ?? ?? FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_Visual_Cpp_80_Debug: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_Visual_Cpp_80_Debug"
        weight = 1
    strings:
        $a = { C0 ?? ?? 00 00 00 00 00 00 ?? ?? 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 ?? ?? ?? ?? ?? 00 00 00 00 00 ?? 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? ?? 00 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 ?? 00 00 00 00 00 ?? ?? ?? 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_v10b_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_v10b_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 60 E8 00 00 00 00 5D 81 ED 4C 32 40 00 E8 03 00 00 00 EB 01 ?? B9 EA 47 40 00 81 E9 E9 32 40 00 8B D5 81 C2 E9 32 40 00 8D 3A 8B F7 33 C0 E8 04 00 00 00 90 EB 01 ?? E8 03 00 00 00 EB 01 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 9C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_v1401: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_v1401"
        weight = 1
    strings:
        $a = { E8 24 00 00 00 8B 4C 24 0C C7 01 17 00 01 00 C7 81 B8 00 00 00 00 ?? ?? 00 31 C0 89 41 14 89 41 18 80 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_or_Borland_Pascal_v7x_Unit: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_or_Borland_Pascal_v7x_Unit"
        weight = 1
    strings:
        $a = { 54 50 55 51 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Simple_UPX_Cryptor_v3042005_multi_layer_encryption: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Simple_UPX_Cryptor_v3042005_multi_layer_encryption"
        weight = 1
    strings:
        $a = { 60 B8 ?? ?? ?? 00 B9 18 00 00 00 80 34 08 ?? E2 FA 61 68 ?? ?? ?? 00 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Themida_1201_Oreans_Technologies_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Themida_1201_Oreans_Technologies_h"
        weight = 1
    strings:
        $a = { 8B C5 8B D4 60 E8 00 00 00 00 5D 81 ED ?? ?? 35 09 89 95 ?? ?? 35 09 89 B5 ?? ?? 35 09 89 85 ?? ?? 35 09 83 BD ?? ?? 35 09 00 74 0C 8B E8 8B E2 B8 01 00 00 00 C2 0C 00 8B 44 24 24 89 85 ?? ?? 35 09 6A 45 E8 A3 00 00 00 68 9A 74 83 07 E8 DF 00 00 00 68 25 4B 89 0A E8 D5 00 00 00 E9 11 02 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Exe_Shield_vxx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Exe_Shield_vxx"
        weight = 1
    strings:
        $a = { 65 78 65 73 68 6C 2E 64 6C 6C C0 5D 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PESpin_V11_cyberbobnbsp_nbsp_SignByfly_20080311: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PESpin_V11_cyberbobnbsp_nbsp_SignByfly_20080311"
        weight = 1
    strings:
        $a = { EB 01 ?? 60 E8 00 00 00 00 8B 1C 24 83 C3 12 81 2B E8 B1 06 00 FE 4B FD 82 2C 24 7D DE 46 00 0B E4 74 9E 75 01 ?? 81 73 04 D7 7A F7 2F 81 73 19 77 00 43 B7 F6 C3 6B B7 00 00 F9 FF E3 C9 C2 08 00 ?? ?? ?? ?? ?? 5D 33 C9 41 E2 17 EB 07 ?? ?? ?? ?? ?? ?? ?? E8 01 00 00 00 ?? 5A 83 EA 0B FF E2 EB 04 ?? EB 04 00 EB FB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 02 ?? ?? F9 72 08 73 0E F9 83 04 24 17 C3 E8 04 00 00 00 0F F5 73 11 EB 06 ?? ?? ?? ?? ?? ?? F5 72 0E F5 72 F8 68 EB EC 83 04 24 07 F5 FF 34 24 C3 41 C1 E1 07 8B 0C 01 03 CA E8 03 00 00 00 EB 04 ?? EB FB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_V22006710_V220070411_WFS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_V22006710_V220070411_WFS"
        weight = 1
    strings:
        $a = { 60 9C 64 FF 35 00 00 00 00 E8 1B 02 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 47 65 74 54 65 6D 70 50 61 74 68 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 41 00 00 00 43 72 65 61 74 65 46 69 6C 65 4D 61 70 70 69 6E 67 41 00 00 00 4D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 55 6E 6D 61 70 56 69 65 77 4F 66 46 69 6C 65 00 00 00 43 6C 6F 73 65 48 61 6E 64 6C 65 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Private_EXE_v20a: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_EXE_v20a"
        weight = 1
    strings:
        $a = { 53 E8 ?? ?? ?? ?? 5B 8B C3 2D ?? ?? ?? ?? 50 81 ?? ?? ?? ?? ?? 8B }
        $b = { 53 E8 ?? ?? ?? ?? 5B 8B C3 2D }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule DZA_Patcher_v13_DZA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DZA_Patcher_v13_DZA"
        weight = 1
    strings:
        $a = { EB 08 35 48 34 30 4C 31 4E 00 60 E8 00 00 00 00 5D 8B D5 81 ED 44 73 40 00 2B 95 74 74 40 00 83 EA 10 89 95 70 74 40 00 8B 44 24 20 25 00 00 FF FF 80 38 4D 74 07 2D 00 00 01 00 EB F4 93 89 85 7C 74 40 00 8D BD 8C 74 40 00 E8 83 00 00 00 89 85 80 74 40 00 }
        $b = { BF 00 40 40 00 99 68 48 20 40 00 68 00 20 40 00 52 52 52 52 52 52 52 57 E8 15 01 00 00 85 C0 75 1C 99 52 52 57 52 E8 CB 00 00 00 FF 35 4C 20 40 00 E8 D2 00 00 00 6A 00 E8 BF 00 00 00 99 68 58 20 40 00 52 52 68 63 10 40 00 52 52 E8 DB 00 00 00 6A FF FF 35 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Wise_Installer_Stub: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Wise_Installer_Stub"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 78 05 00 00 53 56 BE 04 01 00 00 57 8D 85 94 FD FF FF 56 33 DB 50 53 FF 15 34 20 40 00 8D 85 94 FD FF FF 56 50 8D 85 94 FD FF FF 50 FF 15 30 20 40 00 8B 3D 2C 20 40 00 53 53 6A 03 53 6A 01 8D 85 94 FD FF FF 68 00 00 00 80 50 FF D7 83 F8 FF 89 45 FC 0F 84 7B 01 00 00 8D 85 90 FC FF FF 50 56 FF 15 28 20 40 00 8D 85 98 FE FF FF 50 53 8D 85 90 FC FF FF 68 10 30 40 00 50 FF 15 24 20 40 00 53 68 80 00 00 00 6A 02 53 53 8D 85 98 FE FF FF 68 00 00 00 40 50 FF D7 83 F8 FF 89 45 F4 0F 84 2F 01 00 00 53 53 53 6A 02 53 FF 75 FC FF 15 00 20 40 00 53 53 53 6A 04 50 89 45 F8 FF 15 1C 20 40 00 8B F8 C7 45 FC 01 00 00 00 8D 47 01 8B 08 81 F9 4D 5A 9A 00 74 08 81 F9 4D 5A 90 00 75 06 80 78 04 03 74 0D FF 45 FC 40 81 7D FC 00 80 00 00 7C DB 8D 4D F0 53 51 68 }
        $b = { 55 8B EC 81 EC ?? ?? 00 00 53 56 57 6A 01 5E 6A 04 89 75 E8 FF 15 ?? 40 40 00 FF 15 ?? 40 40 00 8B F8 89 7D ?? 8A 07 3C 22 0F 85 ?? 00 00 00 8A 47 01 47 89 7D ?? 33 DB 3A C3 74 0D 3C 22 74 09 8A 47 01 47 89 7D ?? EB EF 80 3F 22 75 04 47 89 7D ?? 80 3F 20 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule eXPressor_v1501_Options_Light_Full_support_CGSoftLabs: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressor_v1501_Options_Light_Full_support_CGSoftLabs"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC ?? 02 00 00 53 56 57 83 A5 ?? FD FF FF 00 F3 EB 0C 65 58 50 72 2D 76 2E 31 2E 35 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Vx_Eddie2100: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Vx_Eddie2100"
        weight = 1
    strings:
        $a = { E8 ?? ?? 4F 4F 0E E8 ?? ?? 47 47 1E FF ?? ?? CB E8 ?? ?? 84 C0 ?? ?? 50 53 56 57 1E 06 B4 51 CD 21 8E C3 ?? ?? ?? ?? ?? ?? ?? 8B F2 B4 2F CD 21 AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule eXPressorProtection_V150X_CGSoftLabs_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID eXPressorProtection_V150X_CGSoftLabs_Sign_by_fly"
        weight = 1
    strings:
        $a = { EB 01 68 EB 01 ?? ?? ?? ?? 83 EC 0C 53 56 57 EB 01 ?? 83 3D ?? ?? ?? ?? 00 74 08 EB 01 E9 E9 56 01 00 00 EB 02 E8 E9 C7 05 ?? ?? ?? ?? 01 00 00 00 EB 01 C2 E8 E2 05 00 00 EB 02 DA 9F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? FF D0 59 59 EB 01 C8 EB 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nPack_v11_250_Beta_NEOx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nPack_v11_250_Beta_NEOx"
        weight = 1
    strings:
        $a = { 83 3D 04 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 2E ?? ?? ?? 2B 05 08 ?? ?? ?? A3 00 ?? ?? ?? E8 9C 00 00 00 E8 04 02 00 00 E8 FB 06 00 00 E8 1B 06 00 00 A1 00 ?? ?? ?? C7 05 04 ?? ?? ?? 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00 ?? ?? ?? C3 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ENIGMA_Protector_Sukhov_Vladimir: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ENIGMA_Protector_Sukhov_Vladimir"
        weight = 1
    strings:
        $a = { 45 6E 69 67 6D 61 20 70 72 6F 74 65 63 74 6F 72 20 76 31 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SVK_Protector_v13x_Eng_Pavol_Cerven: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SVK_Protector_v13x_Eng_Pavol_Cerven"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 5D 81 ED 06 00 00 00 EB 05 B8 ?? ?? 42 00 64 A0 23 00 00 00 EB 03 C7 84 E8 84 C0 EB 03 C7 84 E9 75 67 B9 49 00 00 00 8D B5 C5 02 00 00 56 80 06 44 46 E2 FA 8B 8D C1 02 00 00 5E 55 51 6A 00 56 FF 95 0C 61 00 00 59 5D 40 85 C0 75 3C 80 3E 00 74 03 46 EB F8 46 E2 E3 8B C5 8B 4C 24 20 2B 85 BD 02 00 00 89 85 B9 02 00 00 80 BD B4 02 00 00 01 75 06 8B 8D 0C 61 00 00 89 8D B5 02 00 00 8D 85 0E 03 00 00 8B DD FF E0 55 68 10 10 00 00 8D 85 B4 00 00 00 50 8D 85 B4 01 00 00 50 6A 00 FF 95 18 61 00 00 5D 6A FF FF 95 10 61 00 00 44 65 62 75 67 67 65 72 20 6F 72 20 74 6F 6F 6C 20 66 6F 72 20 6D 6F 6E 69 74 6F 72 69 6E 67 20 64 65 74 65 63 74 65 64 21 21 21 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_V028_V0399_Dwingnbsp_nbsp_SignByfly_20080321: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_V028_V0399_Dwingnbsp_nbsp_SignByfly_20080321"
        weight = 1
    strings:
        $a = { 60 E8 09 00 00 00 ?? ?? ?? ?? E9 06 02 00 00 33 C9 5E 87 0E E3 F4 2B F1 8B DE AD 2B D8 AD 03 C3 50 97 AD 91 F3 A5 5E AD 56 91 01 1E AD E2 FB AD 8D 6E 10 01 5D 00 8D 7D 1C B5 1C F3 AB 5E AD 53 50 51 97 58 8D 54 85 5C FF 16 72 57 2C 03 73 02 B0 00 3C 07 72 02 2C 03 50 0F B6 5F FF C1 E3 03 B3 00 8D 1C 5B 8D 9C 9D 0C 10 00 00 B0 01 E3 29 8B D7 2B 55 0C 8A 2A 33 D2 84 E9 0F 95 C6 52 FE C6 8A D0 8D 14 93 FF 16 5A 9F 12 C0 D0 E9 74 0E 9E 1A F2 74 E4 B4 00 33 C9 B5 01 FF 56 08 33 C9 FF 66 1C B1 30 8B 5D 0C 03 D1 FF 16 73 4C 03 D1 FF 16 72 19 03 D1 FF 16 72 29 3C 07 B0 09 72 02 B0 0B 50 8B C7 2B 45 0C 8A 00 FF 66 18 83 C2 60 FF 16 87 5D 10 73 0C 03 D1 FF 16 87 5D 14 73 03 87 5D 18 3C 07 B0 08 72 02 B0 0B 50 53 8B D5 03 56 38 FF 56 0C 5B 91 FF 66 30 3C 07 B0 07 72 02 B0 0A 50 87 5D 10 87 5D 14 89 5D 18 8B D5 03 56 3C FF 56 0C 6A 03 59 50 48 3B C1 72 02 8B C1 C1 E0 06 B1 40 8D 9C 85 7C 03 00 00 FF 56 04 3C 04 8B D8 72 5F 33 DB D1 E8 13 DB 48 43 91 43 D3 E3 80 F9 05 8D 94 9D 7C 01 00 00 76 2E 80 E9 04 33 C0 8B 55 00 D1 6D 08 8B 12 0F CA 2B 55 04 03 C0 3B 55 08 72 07 8B 55 08 40 01 55 04 FF 56 10 E2 E0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AVI_movie_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AVI_movie_file"
        weight = 1
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 41 56 49 ?? 4C 49 53 54 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DIET_v144_v145f: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DIET_v144_v145f"
        weight = 1
    strings:
        $a = { F8 9C 06 1E 57 56 52 51 53 50 0E FC 8C C8 BA ?? ?? 03 D0 52 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CERBERUS_v20: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CERBERUS_v20"
        weight = 1
    strings:
        $a = { 9C 2B ED 8C ?? ?? 8C ?? ?? FA E4 ?? 88 ?? ?? 16 07 BF ?? ?? 8E DD 9B F5 B9 ?? ?? FC F3 A5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_PaCK_v10_C_Copyright_1998_by_ANAKiN: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_PaCK_v10_C_Copyright_1998_by_ANAKiN"
        weight = 1
    strings:
        $a = { C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 20 2D 3D FE 20 50 45 2D 50 41 43 4B 20 76 31 2E 30 20 2D FE 2D 20 28 43 29 20 43 6F 70 79 72 69 67 68 74 20 31 39 39 38 20 62 79 20 41 4E 41 4B 69 4E 20 FE 3D 2D 20 0D 0A C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 }
        $b = { C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 C4 0D 0A 20 2D 3D FE 20 50 45 2D 50 41 43 4B 20 76 31 2E 30 20 2D FE 2D 20 28 43 29 20 43 6F 70 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule _PseudoSigner_02_Video_Lan_Client: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_02_Video_Lan_Client"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 90 90 90 90 90 90 90 90 90 90 90 90 90 90 01 FF FF 01 01 01 00 01 90 90 90 90 90 90 90 90 90 90 90 90 90 90 00 01 00 01 00 01 90 90 00 01 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EncryptPE_V22006115_WFS: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EncryptPE_V22006115_WFS"
        weight = 1
    strings:
        $a = { 45 50 45 3A 20 45 6E 63 72 79 70 74 50 45 20 56 32 2E 32 30 30 36 2E 31 2E 31 35 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MinGW_GCC_3x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MinGW_GCC_3x"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 08 C7 04 24 ?? 00 00 00 FF 15 ?? ?? ?? ?? E8 ?? ?? FF FF ?? ?? ?? ?? ?? ?? ?? ?? 55 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Gentee_Installer_Custom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Gentee_Installer_Custom"
        weight = 1
    strings:
        $a = { 55 8B EC 81 EC 14 04 00 00 53 56 57 6A 00 FF 15 08 41 40 00 68 00 50 40 00 FF 15 04 41 40 00 85 C0 74 29 6A 00 A1 00 20 40 00 ?? ?? ?? ?? 41 40 00 8B F0 6A 06 56 FF 15 1C 41 40 00 6A 03 56 FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule TPACK_v17_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID TPACK_v17_Archive"
        weight = 1
    strings:
        $a = { ?? 54 50 41 43 ?? 31 2E 37 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_V101_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_V101_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 E8 03 00 00 00 EB 01 ?? E8 86 00 00 00 E8 03 00 00 00 EB 01 ?? E8 79 00 00 00 E8 03 00 00 00 EB 01 ?? E8 A4 00 00 00 E8 03 00 00 00 EB 01 ?? E8 97 00 00 00 E8 03 00 00 00 EB 01 ?? E8 2D 00 00 00 E8 03 00 00 00 EB 01 ?? 60 E8 00 00 00 00 5D 81 ED D5 E4 41 00 8B D5 81 C2 23 E5 41 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PEQuake_V006_forgot: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PEQuake_V006_forgot"
        weight = 1
    strings:
        $a = { E8 A5 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5D 81 ED 05 00 00 00 8D 75 3D 56 FF 55 31 8D B5 81 00 00 00 56 50 FF 55 2D 89 85 8E 00 00 00 6A 04 68 00 10 00 00 68 ?? ?? ?? ?? 6A 00 FF 95 8E 00 00 00 50 8B 9D 7D 00 00 00 03 DD 50 53 E8 04 00 00 00 5A 55 FF E2 60 8B 74 24 24 8B 7C 24 28 FC B2 80 33 DB A4 B3 02 E8 6D 00 00 00 73 F6 33 C9 E8 64 00 00 00 73 1C 33 C0 E8 5B 00 00 00 73 23 B3 02 41 B0 10 E8 4F 00 00 00 12 C0 73 F7 75 3F AA EB D4 E8 4D 00 00 00 2B CB 75 10 E8 42 00 00 00 EB 28 AC D1 E8 74 4D 13 C9 EB 1C 91 48 C1 E0 08 AC E8 2C 00 00 00 3D 00 7D 00 00 73 0A 80 FC 05 73 06 83 F8 7F 77 02 41 41 95 8B C5 B3 01 56 8B F7 2B F0 F3 A4 5E EB 8E 02 D2 75 05 8A 16 46 12 D2 C3 33 C9 41 E8 EE FF FF FF 13 C9 E8 E7 FF FF FF 72 F2 C3 2B 7C 24 28 89 7C 24 1C 61 C2 08 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule dUP_2x_Patcher_wwwdiablo2oo2cjbnet: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID dUP_2x_Patcher_wwwdiablo2oo2cjbnet"
        weight = 1
    strings:
        $a = { 8B CB 85 C9 74 ?? 80 3A 01 74 08 AC AE 75 0A 42 49 EB EF 47 46 42 49 EB E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_293_LZMA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_293_LZMA"
        weight = 1
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 89 E5 8D 9C 24 ?? ?? ?? ?? 31 C0 50 39 DC 75 FB 46 46 53 68 ?? ?? ?? ?? 57 83 C3 04 53 68 ?? ?? ?? ?? 56 83 C3 04 53 50 C7 03 03 00 02 00 90 90 90 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SQZ_Archive: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SQZ_Archive"
        weight = 1
    strings:
        $a = { 48 4C 53 51 5A }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_V520Beta1_Silicon_Realms_Toolworks_SignByfly_20080214: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_V520Beta1_Silicon_Realms_Toolworks_SignByfly_20080214"
        weight = 1
    strings:
        $a = { E8 8E 3F 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 9E 16 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 F5 14 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 86 14 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7 75 03 33 F6 46 33 DB 89 5D E4 83 FE E0 77 69 83 3D ?? ?? ?? ?? ?? 75 4B 83 C6 0F 83 E6 F0 89 75 0C 8B 45 08 3B 05 ?? ?? ?? ?? 77 37 6A 04 E8 07 13 00 00 59 89 7D FC FF 75 08 E8 AC 47 00 00 59 89 45 E4 C7 45 FC FE FF FF FF E8 5F 00 00 00 8B 5D E4 3B DF 74 11 FF 75 08 57 53 E8 7C D3 FF FF 83 C4 0C 3B DF 75 61 56 6A 08 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 3B DF 75 4C 39 3D ?? ?? ?? ?? 74 33 56 E8 C7 F9 FF FF 59 85 C0 0F 85 72 FF FF FF 8B 45 10 3B C7 0F 84 50 FF FF FF C7 00 0C 00 00 00 E9 45 FF FF FF 33 FF 8B 75 0C 6A 04 E8 AD 11 00 00 59 C3 }
        $b = { E8 8E 3F 00 00 E9 16 FE FF FF 6A 0C 68 ?? ?? ?? ?? E8 9E 16 00 00 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 F5 14 00 00 C7 00 0C 00 00 00 57 57 57 57 57 E8 86 14 00 00 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule PowerBASICCC_30x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PowerBASICCC_30x"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 BB 00 ?? ?? 00 66 2E F7 05 ?? ?? ?? 00 04 00 0F 85 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_v10059_Final: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_v10059_Final"
        weight = 1
    strings:
        $a = { E8 AB 1C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_wwwupxsourceforgenet: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_wwwupxsourceforgenet"
        weight = 1
    strings:
        $a = { 60 BE ?? ?? ?? 00 8D BE ?? ?? ?? FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Cygwin32: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Cygwin32"
        weight = 1
    strings:
        $a = { 55 89 E5 83 EC 04 83 3D }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Metrowerks_CodeWarrior_v20_Console: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Metrowerks_CodeWarrior_v20_Console"
        weight = 1
    strings:
        $a = { 55 89 E5 55 B8 FF FF FF FF 50 50 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? 00 00 E8 ?? ?? 00 00 E8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Adys_Glue_v010: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Adys_Glue_v010"
        weight = 1
    strings:
        $a = { 2E 8C 06 ?? ?? 0E 07 33 C0 8E D8 BE ?? ?? BF ?? ?? FC B9 ?? ?? 56 F3 A5 1E 07 5F }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule _PseudoSigner_01_PEX_099: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID _PseudoSigner_01_PEX_099"
        weight = 1
    strings:
        $a = { 60 E8 01 00 00 00 55 83 C4 04 E8 01 00 00 00 90 5D 81 FF FF FF 00 01 E9 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PuNkMoD_1x_PuNkDuDe: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PuNkMoD_1x_PuNkDuDe"
        weight = 1
    strings:
        $a = { 94 B9 ?? ?? 00 00 BC ?? ?? ?? ?? 80 34 0C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Petite_13_c1998_Ian_Luck_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Petite_13_c1998_Ian_Luck_h"
        weight = 1
    strings:
        $a = { ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 68 00 00 ?? ?? 8B 3C 24 8B 30 66 81 C7 80 07 8D 74 06 08 89 38 8B 5E 10 50 56 6A 02 68 80 08 00 00 57 6A ?? 6A 06 56 6A 04 68 80 08 00 00 57 FF D3 83 EE 08 59 F3 A5 59 66 83 C7 68 81 C6 ?? ?? 00 00 F3 A5 FF D3 58 8D 90 B8 01 00 00 8B 0A 0F BA F1 1F 73 16 8B 04 24 FD 8B F0 8B F8 03 72 04 03 7A 08 F3 A5 83 C2 0C FC EB E2 83 C2 10 8B 5A F4 85 DB 74 D8 8B 04 24 8B 7A F8 03 F8 52 8D 34 01 EB 17 58 58 58 5A 74 C4 E9 1C FF FF FF 02 D2 75 07 8A 16 83 EE FF 12 D2 C3 81 FB 00 00 01 00 73 0E 68 60 C0 FF FF 68 60 FC FF FF B6 05 EB 22 81 FB 00 00 04 00 73 0E 68 80 81 FF FF 68 80 F9 FF FF B6 07 EB 0C 68 00 83 FF FF 68 00 FB FF FF B6 08 6A 00 32 D2 4B A4 33 C9 83 FB 00 7E A4 E8 AA FF FF FF 72 17 A4 30 5F FF 4B EB ED 41 E8 9B FF FF FF 13 C9 E8 94 FF FF FF 72 F2 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ExeTools_v21_Encruptor_by_DISMEMBER: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ExeTools_v21_Encruptor_by_DISMEMBER"
        weight = 1
    strings:
        $a = { E8 ?? ?? 5D 83 ?? ?? 1E 8C DA 83 ?? ?? 8E DA 8E C2 BB ?? ?? BA ?? ?? 85 D2 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AINEXE_v230: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AINEXE_v230"
        weight = 1
    strings:
        $a = { 0E 07 B9 ?? ?? BE ?? ?? 33 FF FC F3 A4 A1 ?? ?? 2D ?? ?? 8E D0 BC ?? ?? 8C D8 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Netopsystems_FEAD_Optimizer: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Netopsystems_FEAD_Optimizer"
        weight = 1
    strings:
        $a = { 60 BE 00 50 43 00 8D BE 00 C0 FC FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule VProtector_11A_12_vcasm: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID VProtector_11A_12_vcasm"
        weight = 1
    strings:
        $a = { 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 00 76 63 61 73 6D 5F 70 72 6F 74 65 63 74 5F 32 30 30 35 5F 33 5F 31 38 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 33 F6 E8 10 00 00 00 8B 64 24 08 64 8F 05 00 00 00 00 58 EB 13 C7 83 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 AD CD 20 EB 01 0F 31 F0 EB 0C 33 C8 EB 03 EB 09 0F 59 74 05 75 F8 51 EB F1 B9 04 00 00 00 E8 1F 00 00 00 EB FA E8 16 00 00 00 E9 EB F8 00 00 58 EB 09 0F 25 E8 F2 FF FF FF 0F B9 49 75 F1 EB 05 EB F9 EB F0 D6 E8 07 00 00 00 C7 83 83 C0 13 EB 0B 58 EB 02 CD 20 83 C0 02 EB 01 E9 50 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule RLPack_V119_LZMA_430_ap0xnbsp_nbsp_Sign_by_fly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID RLPack_V119_LZMA_430_ap0xnbsp_nbsp_Sign_by_fly"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 8B 2C 24 83 C4 04 83 7C 24 28 01 75 0C 8B 44 24 24 89 85 49 0B 00 00 EB 0C 8B 85 45 0B 00 00 89 85 49 0B 00 00 8D B5 6D 0B 00 00 8D 9D 2F 03 00 00 33 FF 6A 40 68 00 10 00 00 68 00 20 0C 00 6A 00 FF 95 DA 0A 00 00 89 85 41 0B 00 00 E8 76 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_v032a_fake_PEtite_21_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_v032a_fake_PEtite_21_emadicius"
        weight = 1
    strings:
        $a = { B8 00 50 40 00 6A 00 68 BB 21 40 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 66 9C 60 50 83 C4 04 61 66 9D 64 8F 05 00 00 00 00 83 C4 08 EB 05 E8 EB 04 40 00 EB FA E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF 83 C4 08 74 04 75 02 EB 02 EB 01 81 50 E8 02 00 00 00 29 5A 58 6B C0 03 E8 02 00 00 00 29 5A 83 C4 04 58 74 04 75 02 EB 02 EB 01 81 0F 31 50 0F 31 E8 0A 00 00 00 E8 EB 0C 00 00 E8 F6 FF FF FF E8 F2 FF FF FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FASM_v13x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FASM_v13x"
        weight = 1
    strings:
        $a = { 6A ?? FF 15 ?? ?? ?? ?? A3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_v210b2: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_v210b2"
        weight = 1
    strings:
        $a = { 55 8B EC 6A FF 68 18 12 41 00 68 24 A0 40 00 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 83 EC 58 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule AntiDote_10_Demo_12_SIS_Team: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID AntiDote_10_Demo_12_SIS_Team"
        weight = 1
    strings:
        $a = { 00 00 00 00 09 01 47 65 74 43 6F 6D 6D 61 6E 64 4C 69 6E 65 41 00 DB 01 47 65 74 56 65 72 73 69 6F 6E 45 78 41 00 73 01 47 65 74 4D 6F 64 75 6C 65 46 69 6C 65 4E 61 6D 65 41 00 00 7A 03 57 61 69 74 46 6F 72 53 69 6E 67 6C 65 4F 62 6A 65 63 74 00 BF 02 52 65 73 75 6D 65 54 68 72 65 61 64 00 00 29 03 53 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 94 03 57 72 69 74 65 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 00 6B 03 56 69 72 74 75 61 6C 41 6C 6C 6F 63 45 78 00 00 A6 02 52 65 61 64 50 72 6F 63 65 73 73 4D 65 6D 6F 72 79 00 CA 01 47 65 74 54 68 72 65 61 64 43 6F 6E 74 65 78 74 00 00 62 00 43 72 65 61 74 65 50 72 6F 63 65 73 73 41 00 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MoleBox_V23X_MoleStudiocom: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MoleBox_V23X_MoleStudiocom"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 60 E8 4F 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_290_LZMA: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_290_LZMA"
        weight = 1
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 57 83 CD FF 89 E5 8D 9C 24 ?? ?? ?? ?? 31 C0 50 39 DC 75 FB 46 46 53 68 ?? ?? ?? ?? 57 83 C3 04 53 68 ?? ?? ?? ?? 56 83 C3 04 53 50 C7 03 ?? ?? ?? ?? 90 90 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule DOS32_v33_DOS_Extender_and_Loader: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID DOS32_v33_DOS_Extender_and_Loader"
        weight = 1
    strings:
        $a = { 0E 1F FC 9C 5B 8B C3 80 F4 ?? 50 9D 9C 58 3A E7 75 ?? BA ?? ?? B4 09 CD 21 B4 4C CD 21 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Upack_v0399_Dwing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Upack_v0399_Dwing"
        weight = 1
    strings:
        $a = { 0B 01 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 18 10 00 00 10 00 00 00 00 ?? ?? 00 00 00 40 00 00 10 00 00 00 02 00 00 04 00 00 00 00 00 3A 00 04 00 00 00 00 00 00 00 00 ?? ?? 00 00 02 00 00 00 00 00 00 ?? 00 00 00 00 00 10 00 00 ?? 00 00 00 00 10 00 00 10 00 00 00 00 00 00 0A 00 00 00 00 00 00 00 00 00 00 00 EE ?? ?? 00 14 00 00 00 00 ?? ?? 00 ?? ?? 00 00 FF 76 38 AD 50 8B 3E BE F0 ?? ?? 00 6A 27 59 F3 A5 FF 76 04 83 C8 FF 8B DF AB EB 1C 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 ?? ?? ?? 00 ?? 00 00 00 40 AB 40 B1 04 F3 AB C1 E0 0A B5 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Matrix_Dongle_TDi_GmbH: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Matrix_Dongle_TDi_GmbH"
        weight = 1
    strings:
        $a = { E8 00 00 00 00 E8 00 00 00 00 59 5A 2B CA 2B D1 E8 1A FF FF FF }
        $b = { 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 E8 B6 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? E8 00 00 00 00 5B 2B D9 8B F8 8B 4C 24 2C 33 C0 2B CF F2 AA 8B 3C 24 8B 0A 2B CF 89 5C 24 20 80 37 A2 47 49 75 F9 8D 64 24 04 FF 64 24 FC 60 C7 42 08 ?? ?? ?? ?? E8 C5 FF FF FF C3 C2 F7 29 4E 29 5A 29 E6 86 8A 89 63 5C A2 65 E2 A3 A2 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Private_EXE_Protector_197_SetiSoft_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Private_EXE_Protector_197_SetiSoft_h"
        weight = 1
    strings:
        $a = { 55 8B EC 83 C4 F4 FC 53 57 56 8B 74 24 20 8B 7C 24 24 66 81 3E 4A 43 0F 85 A5 02 00 00 83 C6 0A 33 DB BA 00 00 00 80 C7 44 24 14 08 00 00 00 43 8D A4 24 00 00 00 00 8B FF 03 D2 75 08 8B 16 83 C6 04 F9 13 D2 73 2C 8B 4C 24 10 33 C0 8D A4 24 00 00 00 00 05 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PC_Guard_v303d_v305d: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PC_Guard_v303d_v305d"
        weight = 1
    strings:
        $a = { 55 53 56 51 52 57 E8 16 00 00 00 }
        $b = { FC 55 50 E8 00 00 00 00 5D 60 E8 03 00 00 00 83 EB 0E EB 01 0C 58 EB 01 35 40 EB 01 36 FF E0 0B 61 B8 30 D2 40 00 EB 01 E3 60 E8 03 00 00 00 D2 EB 0B 58 EB 01 48 40 EB 01 35 FF E0 E7 61 2B E8 9C EB 01 D5 9D EB 01 0B 58 60 E8 03 00 00 00 83 EB 0E EB 01 0C }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Trilobytes_RNR_graphics_library: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Trilobytes_RNR_graphics_library"
        weight = 1
    strings:
        $a = { 84 10 ?? ?? ?? ?? ?? ?? ?? 10 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ILUCRYPT_v4015_exe: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ILUCRYPT_v4015_exe"
        weight = 1
    strings:
        $a = { 8B EC FA C7 46 F7 ?? ?? 42 81 FA ?? ?? 75 F9 FF 66 F7 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MSLRH_032a_fake_nSPack_13_emadicius: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MSLRH_032a_fake_nSPack_13_emadicius"
        weight = 1
    strings:
        $a = { E9 A6 00 00 00 B0 7B 40 00 78 60 40 00 7C 60 40 00 00 00 00 00 B0 3F 00 00 12 62 40 00 4E 65 6F 4C 69 74 65 20 45 78 65 63 75 74 61 62 6C 65 20 46 69 6C 65 20 43 6F 6D 70 72 65 73 73 6F 72 0D 0A 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 39 38 2C 31 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Solidshield_Protector_V1X_Solidshield_Technologies_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Solidshield_Protector_V1X_Solidshield_Technologies_SignByfly"
        weight = 1
    strings:
        $a = { 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? C3 00 60 89 00 0A 00 00 00 46 33 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Turbo_Pascal_Configuration_File: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Turbo_Pascal_Configuration_File"
        weight = 1
    strings:
        $a = { 54 75 72 62 6F 20 50 61 73 63 61 6C 20 43 6F 6E 66 69 67 75 72 61 74 69 6F 6E }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule CorelDraw_CMX_Graphics_format: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID CorelDraw_CMX_Graphics_format"
        weight = 1
    strings:
        $a = { 52 49 46 46 ?? ?? ?? ?? 43 4D 58 31 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule MOD_8_Track_Oktatracker_music_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID MOD_8_Track_Oktatracker_music_file"
        weight = 1
    strings:
        $a = { 4F 43 54 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule aPack_v082: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID aPack_v082"
        weight = 1
    strings:
        $a = { 1E 06 8C CB BA ?? ?? 03 DA 8D ?? ?? ?? FC 33 F6 33 FF 48 4B 8E C0 8E DB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Obsidium_V125_Obsidium_Software: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Obsidium_V125_Obsidium_Software"
        weight = 1
    strings:
        $a = { E8 0E 00 00 00 8B 54 24 0C 83 82 B8 00 00 00 0D 33 C0 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Inset_Systems_IGF_graphics_file: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Inset_Systems_IGF_graphics_file"
        weight = 1
    strings:
        $a = { 01 80 04 00 01 00 58 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule UPX_Scrambler_RC_v1x: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID UPX_Scrambler_RC_v1x"
        weight = 1
    strings:
        $a = { 90 61 BE 00 20 44 00 8D BE 00 F0 FB FF C7 87 9C E0 04 00 6A F0 8A 5E 57 83 CD FF EB 0E }
        $b = { 66 C7 05 ?? ?? ?? ?? 75 07 E9 ?? FE FF FF 00 ?? ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 00 ?? ?? 00 ?? ?? 00 00 00 ?? ?? 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule EXE_Stealth_274: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Stealth_274"
        weight = 1
    strings:
        $a = { EB 00 EB 2F 53 68 61 72 65 77 61 72 65 20 2D 20 45 78 65 53 74 65 61 6C 74 68 00 EB 16 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D 00 60 90 E8 00 00 00 00 5D 81 ED F0 27 40 00 B9 15 00 00 00 83 C1 05 EB 05 EB FE 83 C7 56 EB 00 83 E9 02 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Packman_0001_bubba: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Packman_0001_bubba"
        weight = 1
    strings:
        $a = { 60 E8 00 00 00 00 58 8D A8 ?? FE FF FF 8D 98 ?? ?? ?? FF 8D ?? ?? 01 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXE_Stealth_273: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXE_Stealth_273"
        weight = 1
    strings:
        $a = { 60 90 EB 22 45 78 65 53 74 65 61 6C 74 68 20 2D 20 77 77 77 2E 77 65 62 74 6F 6F 6C 6D 61 73 74 65 72 2E 63 6F 6D E8 00 00 00 00 5D 81 ED 40 1E 40 00 B9 99 09 00 00 8D BD 88 1E 40 00 8B F7 AC }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Borland_Delphi_v30: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Borland_Delphi_v30"
        weight = 1
    strings:
        $a = { 50 6A ?? E8 ?? ?? FF FF BA ?? ?? ?? ?? 52 89 05 ?? ?? ?? ?? 89 42 04 E8 ?? ?? ?? ?? 5A 58 E8 ?? ?? ?? ?? C3 55 8B EC 33 C0 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Microsoft_C_Library_1985: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Microsoft_C_Library_1985"
        weight = 1
    strings:
        $a = { BF ?? ?? 8B 36 ?? ?? 2B F7 81 FE ?? ?? 72 ?? BE ?? ?? FA 8E D7 81 C4 ?? ?? FB 73 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule yodas_Protector_v101_Ashkbiz_Danehkar: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID yodas_Protector_v101_Ashkbiz_Danehkar"
        weight = 1
    strings:
        $a = { 55 8B EC 53 56 57 E8 03 00 00 00 EB 01 ?? E8 86 00 00 00 E8 03 00 00 00 EB 01 ?? E8 79 00 00 00 E8 03 00 00 00 EB 01 ?? E8 A4 00 00 00 E8 03 00 00 00 EB 01 ?? E8 97 00 00 00 E8 03 00 00 00 EB 01 ?? E8 2D 00 00 00 E8 03 00 00 00 EB 01 ?? 60 E8 00 00 00 00 5D 81 ED A5 E5 41 00 8B D5 81 C2 F3 E5 41 00 52 E8 01 00 00 00 C3 C3 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 E8 D1 FF FF FF C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? 33 C0 64 FF 30 64 89 20 CC C3 E8 03 00 00 00 EB 01 ?? B9 F0 FE 41 00 81 E9 93 E6 41 00 8B D5 81 C2 93 E6 41 00 8D 3A 8B F7 33 C0 E8 03 00 00 00 EB 01 ?? E8 0E 00 00 00 33 C0 64 FF 30 64 89 20 CC C3 90 EB 01 ?? AC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AA E2 9C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Datafile_from_Norton_Utilities: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Datafile_from_Norton_Utilities"
        weight = 1
    strings:
        $a = { 50 4E 43 49 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ActiveMARKTM_R5311140_Trymedia: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ActiveMARKTM_R5311140_Trymedia"
        weight = 1
    strings:
        $a = { 79 07 0F B7 07 47 50 47 B9 57 48 F2 AE 55 FF 96 84 ?? 00 00 09 C0 74 07 89 03 83 C3 04 EB D8 FF 96 88 ?? 00 00 61 E9 ?? ?? ?? FF }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule IMP_Packer_10_Mahdi_Hezavehi_IMPOSTER_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID IMP_Packer_10_Mahdi_Hezavehi_IMPOSTER_h"
        weight = 1
    strings:
        $a = { 28 ?? ?? ?? 00 00 00 00 00 00 00 00 40 ?? ?? ?? 34 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 4C ?? ?? ?? 5C ?? ?? ?? 00 00 00 00 4B 65 52 6E 45 6C 33 32 2E 64 4C 6C 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule ACProtect_V13X_V14X_RiSco_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID ACProtect_V13X_V14X_RiSco_SignByfly"
        weight = 1
    strings:
        $a = { 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 4B 45 52 4E 45 4C 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 55 53 45 52 33 32 2E 44 4C 4C 00 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 4D 65 73 73 61 67 65 42 6F 78 41 00 90 4D 69 6E 65 49 6D 70 6F 72 74 5F 45 6E 64 73 73 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule SecuROM_V7X_Sony_DADC_SignByfly_20080114: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID SecuROM_V7X_Sony_DADC_SignByfly_20080114"
        weight = 1
    strings:
        $a = { 9C 9C 83 EC 1C C7 44 24 18 ?? ?? ?? ?? C7 44 24 14 BF 03 01 00 89 74 24 10 BE F0 ?? ?? ?? C1 4C 24 18 18 ?? 89 6C 24 0C 8B 2E 01 6C 24 18 ?? 83 C6 04 66 FF 4C 24 14 52 5A 75 ED 80 64 24 18 FE ?? 8B 74 24 1C C1 E1 00 8B 6C 24 18 89 74 24 18 8B 74 24 10 89 6C 24 1C C1 E2 00 8B 6C 24 0C 83 C4 18 9D ?? 74 12 81 04 24 ?? ?? ?? ?? ?? 81 04 24 C3 D1 FF 00 EB FA 6B 81 04 24 ?? ?? ?? ?? 0F AC F8 00 81 04 24 C2 04 00 3E FF 74 24 04 9D EB F5 EE 93 9D }
        $b = { 9C 9C 83 EC 1C C7 44 24 18 ?? ?? ?? ?? C7 44 24 14 BF 03 01 00 89 74 24 10 BE F0 ?? ?? ?? C1 4C 24 18 18 ?? 89 6C 24 0C 8B 2E 01 6C 24 18 ?? 83 C6 04 66 FF 4C 24 14 52 5A 75 ED 80 64 24 18 FE ?? 8B 74 24 1C C1 E1 00 8B 6C 24 18 89 74 24 18 8B 74 24 10 89 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule Unknown_by_SMT: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Unknown_by_SMT"
        weight = 1
    strings:
        $a = { 60 BE ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 83 ?? ?? 57 EB }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule FreeJoiner_152_Stub_engine_16_GlOFF: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID FreeJoiner_152_Stub_engine_16_GlOFF"
        weight = 1
    strings:
        $a = { E8 46 FD FF FF 50 E8 0C 00 00 00 FF 25 08 20 40 00 FF 25 0C 20 40 00 FF 25 10 20 40 00 FF 25 14 20 40 00 FF 25 18 20 40 00 FF 25 1C 20 40 00 FF 25 20 20 40 00 FF 25 24 20 40 00 FF 25 28 20 40 00 FF 25 00 20 40 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Morphine_v33_Silent_Software_Silent_Shield_c2005_h: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Morphine_v33_Silent_Software_Silent_Shield_c2005_h"
        weight = 1
    strings:
        $a = { BB 00 BD 46 00 83 EC 04 89 1C 24 ?? B9 ?? 00 00 00 80 33 ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule NsPacK_V31_LiuXingPing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPacK_V31_LiuXingPing"
        weight = 1
    strings:
        $a = { 9C 60 E8 00 00 00 00 5D 83 ED 07 8D 9D ?? ?? ?? ?? 8A 03 3C 00 74 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule nPack_v11_150_200_Beta_NEOx: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID nPack_v11_150_200_Beta_NEOx"
        weight = 1
    strings:
        $a = { 83 3D 40 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 41 00 00 00 B8 80 ?? ?? ?? 2B 05 08 ?? ?? ?? A3 3C ?? ?? 00 E8 5E 00 00 00 E8 E0 01 00 00 E8 EC 06 00 00 E8 F7 05 00 00 }
        $b = { 83 3D 04 ?? ?? ?? 00 75 05 E9 01 00 00 00 C3 E8 46 00 00 00 E8 73 00 00 00 B8 2E ?? ?? ?? 2B 05 08 ?? ?? ?? A3 00 ?? ?? ?? E8 9C 00 00 00 E8 04 02 00 00 E8 FB 06 00 00 E8 1B 06 00 00 A1 00 ?? ?? ?? C7 05 04 ?? ?? ?? 01 00 00 00 01 05 00 ?? ?? ?? FF 35 00 }
    condition:
        check_peid_bool and (for any of ($*) : ( $ at pe.entry_point ))

}

rule NsPacK_Net_LiuXingPing: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID NsPacK_Net_LiuXingPing"
        weight = 1
    strings:
        $a = { 56 69 72 74 75 61 6C 50 72 6F 74 65 63 74 00 00 BB 01 47 65 74 53 79 73 74 65 6D 49 6E 66 6F 00 4B 45 52 4E 45 4C 33 32 2E 64 6C 6C 00 00 5E 00 5F 43 6F 72 ?? ?? ?? 4D 61 69 6E 00 6D 73 63 6F 72 65 65 2E 64 6C 6C }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule LaunchAnywhere_v4001: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID LaunchAnywhere_v4001"
        weight = 1
    strings:
        $a = { 55 89 E5 53 83 EC 48 55 B8 FF FF FF FF 50 50 68 E0 3E 42 00 64 FF 35 00 00 00 00 64 89 25 00 00 00 00 68 C0 69 44 00 E8 E4 80 FF FF 59 E8 4E 29 00 00 E8 C9 0D 00 00 85 C0 75 08 6A FF E8 6E 2B 00 00 59 E8 A8 2C 00 00 E8 23 2E 00 00 FF 15 4C C2 44 00 89 C3 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule EXECryptor_2223_protected_IAT: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID EXECryptor_2223_protected_IAT"
        weight = 1
    strings:
        $a = { CC ?? ?? ?? 00 00 00 00 FF FF FF FF 3C ?? ?? ?? B4 ?? ?? ?? 08 ?? ?? ?? 00 00 00 00 FF FF FF FF E8 ?? ?? ?? 04 ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 6B 65 72 6E 65 6C 33 32 2E 64 6C 6C 00 00 00 00 00 00 47 65 74 4D 6F 64 75 6C 65 48 61 6E 64 6C 65 41 00 00 00 00 4C 6F 61 64 4C 69 62 72 61 72 79 41 00 00 00 00 47 65 74 50 72 6F 63 41 64 64 72 65 73 73 00 00 00 00 00 00 45 78 69 74 50 72 6F 63 65 73 73 00 00 00 00 00 56 69 72 74 75 61 6C 41 6C 6C 6F 63 00 00 00 00 56 69 72 74 75 61 6C 46 72 65 65 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 4C ?? ?? ?? 60 ?? ?? ?? 70 ?? ?? ?? 84 ?? ?? ?? 94 ?? ?? ?? A4 ?? ?? ?? 00 00 00 00 75 73 65 72 33 32 2E 64 6C 6C 00 00 00 00 4D 65 73 73 61 67 65 42 6F 78 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule PE_PACK_v10_by_ANAKiN_1998_: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID PE_PACK_v10_by_ANAKiN_1998_"
        weight = 1
    strings:
        $a = { 74 ?? E9 ?? ?? ?? ?? 00 00 00 00 }
    condition:
        check_peid_bool and $a at pe.entry_point

}

rule Armadillo_V500_V5X_Dll_Silicon_Realms_Toolworks_SignByfly: PEiD
{
    meta:
        author = "Jaume Martin"
        description = "PEID Armadillo_V500_V5X_Dll_Silicon_Realms_Toolworks_SignByfly"
        weight = 1
    strings:
        $a = { 83 7C 24 08 01 75 05 E8 ?? ?? ?? ?? FF 74 24 04 8B 4C 24 10 8B 54 24 0C E8 ?? ?? ?? ?? 59 C2 0C 00 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 08 33 FF 3B CF 76 2E 6A E0 58 33 D2 F7 F1 3B 45 0C 1B C0 40 75 1F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 D5 00 00 00 0F AF 4D 0C 8B F1 89 75 08 3B F7