/*
  Copyright 2020-2024 Lowdefy, Inc

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

import React from 'react';
import { render } from '@testing-library/react';

import ErrorBoundary from './ErrorBoundary.js';

let logError;
beforeAll(() => {
  logError = console.error;
  console.error = () => undefined;
});
afterAll(() => {
  console.error = logError;
});

test('no error', () => {
  const { container } = render(
    <ErrorBoundary>
      <div>one</div>
    </ErrorBoundary>
  );
  expect(container.firstChild).toMatchSnapshot();
});

test('display no error message on error generated by child', () => {
  const ProblemChild = () => {
    throw new Error('ErrorBoundary test error');
  };
  const { container } = render(
    <ErrorBoundary>
      <ProblemChild />
    </ErrorBoundary>
  );
  expect(container.firstChild).toMatchSnapshot();
});

test('display error message on error generated by child', () => {
  const ProblemChild = () => {
    throw new Error('ErrorBoundary test error');
  };
  const { container } = render(
    <ErrorBoundary fullPage>
      <ProblemChild />
    </ErrorBoundary>
  );
  expect(container.firstChild).toMatchSnapshot();
});

test('display error message and description on error generated by child', () => {
  const ProblemChild = () => {
    throw new Error('ErrorBoundary test error');
  };
  const { container } = render(
    <ErrorBoundary fullPage description="error description">
      <ProblemChild />
    </ErrorBoundary>
  );
  expect(container.firstChild).toMatchSnapshot();
});

test('display fallback component on error generated by child', () => {
  const ProblemChild = () => {
    throw new Error('ErrorBoundary test error');
  };
  const { container } = render(
    <ErrorBoundary fallback={(error) => <div>fallback: {error.message}</div>}>
      <ProblemChild />
    </ErrorBoundary>
  );
  expect(container.firstChild).toMatchSnapshot();
});
