/*
  Copyright 2020-2024 Lowdefy, Inc

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

function createStdOutLineHandler({ context }) {
  const { logger } = context;
  function stdOutLineHandler(line) {
    try {
      const { level, name, time, rid, ...msgObj } = JSON.parse(line);
      if (level) {
        const print = level === 30 ? 'log' : logger.levels.labels[level];
        logger[logger.levels.labels[level]]({ print }, JSON.stringify(msgObj));
      }
    } catch (error) {
      logger.info({ print: 'log' }, line);
    }
  }
  return stdOutLineHandler;
}

export default createStdOutLineHandler;
