/*
  Copyright 2020-2024 Lowdefy, Inc

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

import getFromObject from './getFromObject.js';

const createGetRequestDetails = ({ arrayIndices, blockId, context }) => {
  return function getRequestDetails(params) {
    return getFromObject({
      arrayIndices,
      location: blockId,
      object: context.requests,
      method: 'getRequestDetails',
      params,
    });
  };
};

export default createGetRequestDetails;
